/*
 * Extended Pacsat Header Generator
 * NORD><LINK Software, for non-comercial use only
 * Copyright by PE1CHL & DB7KG
 * Linux Version by DF6LN
 */
// RCS Source Logout: 02.08.96, AG, HL

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

/* definition of a PFH item (used for verbose printout of PFH and user input) */
struct pfh
{
    unsigned int id;                    /* PFH ID */
    unsigned char type;                 /* printout type */
#define TEXT    0
#define BYTE    1
#define WORD    2
#define TIME    3
#define LONG    4
#define DUMP    5
#define SEU     6
#define COMP    7
    unsigned char flags;                /* various attributes: */
#define SUPPR   0x01                    /* suppress it when -s? */
#define MAND    0x02                    /* mandatory item */
#define PROMPT  0x04                    /* prompt for user input */
#define SPACE   0x08                    /* init to spaces */
#define SKIP    0x10                    /* skip this when pfh -as? */
    unsigned char len;                  /* default/max length for pfhadd */
    char *title;
};

char writeerr[] = "Warning: write error in %s (disk full?)\n";

char _from[40], _to[40], _bid[40], _lt[40], _type[2], _compr[2], _title[120],
     _fid[20], _uploadtime[20], _fromcall[80];
long akttime;

/* table of known pfh items and their types and names */
struct pfh pfh[] =
{
    {0x01, LONG, 0x06, 4, _fid},
    {0x02, TEXT, 0x0b, 8, NULL},
    {0x03, TEXT, 0x0b, 3, NULL},
    {0x04, LONG, 0x02, 4, NULL},
    {0x05, TIME, 0x03, 4, NULL},
    {0x06, TIME, 0x03, 4, NULL},
    {0x07, SEU,  0x02, 1, NULL},
    {0x08, BYTE, 0x06, 1, _type},
    {0x09, WORD, 0x03, 2, NULL},
    {0x0a, WORD, 0x03, 2, NULL},
    {0x0b, WORD, 0x03, 2, NULL},

    {0x10, TEXT, 0x06, 0, _from},
    {0x11, TEXT, 0x06, 6, _fromcall},
    {0x12, LONG, 0x06, 4, _uploadtime},
    {0x13, BYTE, 0x03, 1, NULL},
    {0x14, TEXT, 0x06, 0, _to},
    {0x15, TEXT, 0x0b, 6, NULL},
    {0x16, TIME, 0x03, 4, NULL},
    {0x17, TIME, 0x06, 4, _lt},
    {0x18, BYTE, 0x07, 1, NULL},

    {0x19, COMP, 0x04, 1, _compr},
    {0x20, TEXT, 0x14, 1, _type},
    {0x21, TEXT, 0x04, 0, _bid},    // 7KG->1KWA: und sie wird auch gespeichert
    {0x22, TEXT, 0x04, 0, _title},
    {0x23, TEXT, 0x14, 0, NULL},
    {0x24, TEXT, 0x00, 0, NULL},
    {0x25, TEXT, 0x00, 0, NULL},
    {0x26, TEXT, 0x04, 0, NULL},
    {0,    DUMP, 0x00, 0, NULL}
};

#if defined(UNIX) || defined(M_XENIX)
# define READ_BIN       "r"
# define WRITE_BIN      "w"
# define RDWR_BIN       "w+"
#else
# define READ_BIN       "rb"
# define WRITE_BIN      "wb"
# define RDWR_BIN       "w+b"
#endif

unsigned char data[2048];                       /* buffer */

#ifdef __linux__
/*
   String in Grossbuchstaben umwandeln - aus DJGPP GNU-Paket fuer MS-DOS
   von D.J. Delorie
*/

char *
strupr(char *s)
{
  char *p = s;
  while (*s)
  {
    if ((*s >= 'a') && (*s <= 'z'))
      *s += 'A'-'a';
    s++;
  }
  return(p);
}
#endif

void err(char *s)
{
    printf("%s: (%s)\n", s, _title);
    exit(10);
}

void strccat(char *s, char c)
{
    static char sc[3] = " ";
    *sc = c;
    strcat(s, sc);
}

/* add a PFH to a file, for upload to the server */
void pfhadd (char *inputfile, char *outputfile, char *fid, char *fromcall)
{
    FILE *inp;
    FILE *out;
    struct pfh *pi;
    int len;
    unsigned short csum;
    unsigned long val = 0L;
    unsigned long fsizepos = 0L;
    unsigned long bcsumpos = 0L;
    unsigned long hcsumpos = 0L;
    unsigned long boffpos = 0L;
    unsigned long bodypos = 0L;
    unsigned char ftype = 0;
    unsigned char ctype = 0;
    time_t now;
    static char dummy1[80];
    static char dummy2[80];
    char *dp;
    char *cp;

#ifndef __linux__
    strupr(inputfile);
    strupr(outputfile);
#endif
    strupr(fromcall);

    /* open inputfile */

    if ((inp = fopen(inputfile,READ_BIN)) == NULL)
    {
        perror(inputfile);
        exit(2);
    }
#ifdef _IOFBF
    setvbuf(inp,NULL,_IOFBF,4096);
#endif

    sscanf(fid, "%lx", &val);
    sprintf(_fid, "%lu", val);
    fgets(_title, 120, inp);
    if (strchr(_title, 13)) *strchr(_title, 13) = 0;
    *dummy1 = *dummy2 = *_from = *_bid = 0;
    cp = _title;
    /* der neue Parser, stabiler als der alte, auch fuer User-Mehl */
    if (*cp++ != 'S') err("line must start with 'S'");
    if (*cp != ' ')
    {
        if ((*cp != 'P') && (*cp != 'B'))
             err("'P'rivate or 'B'ulletin expected");
        else cp++;
    }
    if (*cp++ != ' ') err("unexpected character after S/SP/SB");
    while (*cp && (*cp != ' ')) strccat(dummy1, *cp++);
    if (!*dummy1) err("missing destination");
    if (*cp++ != ' ') err("missing space after destination");
    if (*cp == '@') {
        cp++;
        if (*cp++ != ' ') err("missing space after '@'");
        while (*cp && (*cp != ' ')) strccat(dummy2, *cp++);
        if (!*dummy2) err("missing box after '@'");
        if (*cp++ != ' ') err("missing space after box");
    }
   if (*cp++ != '<') err("missing '<'");
    if (*cp++ != ' ') err("missing space after '<'");
    while (*cp && (*cp != ' ')) strccat(_from, *cp++);
    if (!*_from) err("missing fromcall");
    if (*cp) {
        if (*cp++ != ' ') err("missing space after fromcall");
        // DB7KG->DG1KWA: Hier wird die BID aus der S&F Zeile gelesen
        //                und gespeichert
        if (*cp++ == '$')
            while (*cp && (*cp != ' ')) strccat(_bid, *cp++);
    }

    dp = strchr(_title, '#');
    time(&now);
    sprintf(_uploadtime, "%lu", (long) now);
    if (dp != 0) {
        dp++;
        sscanf(dp, "%s", _lt);
    } else strcpy(_lt, "4");

    strcat(dummy1, " @ ");
    strcat(dummy1, dummy2);
    strcpy(_to, dummy1);
    strcpy(_type, "0");
    strcpy(_compr, "0");
    strcpy(_fromcall, fromcall);
    strupr(_to);
    strupr(_fromcall);
    if ((dp = strchr(_fromcall, '-')) != NULL) *dp = 0;

    fgets(_title, 120, inp);
    if (strchr(_title, 13) != NULL) *strchr(_title, 13) = 0;

    /* create outputfile */

    if ((out = fopen(outputfile,RDWR_BIN)) == NULL)
    {
        perror(outputfile);
        fclose(inp);
        exit(4);
    }
#ifdef _IOFBF
    setvbuf(out,NULL,_IOFBF,4096);
#endif

    time(&now);                         /* get default time */

    putc(0xaa,out);                     /* PFH magic number */
    putc(0x55,out);

    for (pi = pfh; pi->id != 0; pi++)
    {
        if (pi->flags & PROMPT ||       /* user-input item? */
            (pi->id == 0x24 && ftype == 255) || /* file description? */
            (pi->id == 0x25 && ctype == 255))   /* compression description? */
        {
            if (pi->flags & SKIP)       /* skip it (short list)? */
            {
                data[0] = '\0';
            }
            else
            {
                if (pi->title != NULL) {
                    strcpy(data, pi->title);
                } else data[0] = 0;

                while (data[0] == ' ' || data[0] == '\t')
                    strcpy((char *)data,(char *)data+1);
            }

            len = 0;                    /* no conversion = no data */

            switch (pi->type)           /* conversion depending on type */
            {
            case TEXT:
                len = (int)strlen((char *)data); /* use user-supplied data len */

                if (pi->len != 0 && len > pi->len)
                    len = pi->len;
                break;

            case BYTE:
            case WORD:
            case LONG:
                len = pi->type;
                val = atol((char *)data);       /* get value of decimal input */

                data[0] = (unsigned char)val;   /* convert to little-endian */
                data[1] = (unsigned char)(val >> 8);
                data[2] = (unsigned char)(val >> 16);
                data[3] = (unsigned char)(val >> 24);
                break;

            case TIME:
                len = 4;

                if ((val = atol((char *)data)) != 0) /* get decimal value */
                    val = now + 86400L * val;   /* when given, cvt to days */

                data[0] = (unsigned char)val;   /* convert to little-endian */
                data[1] = (unsigned char)(val >> 8);
                data[2] = (unsigned char)(val >> 16);
                data[3] = (unsigned char)(val >> 24);
                break;

            case COMP:
                len = 1;

                if (strstr((char *)data,"arc") != NULL)
                    data[0] = 1;
                else
                    if (strstr((char *)data,"zip") != NULL)
                        data[0] = 2;
                    else
                        if (strstr((char *)data,"lha") != NULL)
                            data[0] = 3;
                        else
                            data[0] = (unsigned char)atoi((char *)data);
            }
        }
        else                            /* else must be fixed item */
        {
            memset(data,(pi->flags & SPACE? ' ':'\0'),len = pi->len);
        }

        switch (pi->id)                 /* special treatment for some items */
        {
        case 0x04:                      /* file_size */
            fsizepos = ftell(out) + 3;
            break;

        case 0x05:                      /* create_time */
            data[0] = (unsigned char)now; /* convert time to little-endian */
            data[1] = (unsigned char)(now >> 8);
            data[2] = (unsigned char)(now >> 16);
            data[3] = (unsigned char)(now >> 24);
            break;

        case 0x08:                      /* file_type */
            ftype = data[0];
            break;

        case 0x09:                      /* body_checksum */
            bcsumpos = ftell(out) + 3;
            break;

        case 0x0a:                      /* header_checksum */
            hcsumpos = ftell(out) + 3;
            break;

        case 0x0b:                      /* body_offset */
            boffpos = ftell(out) + 3;
            break;

        case 0x11:                      /* upload call */
            while (strlen(data) < 6) strcat(data, " ");
            len = 6;
            break;

        case 0x16:                      /* download time */
            data[0] = (unsigned char)now; /* convert time to little-endian */
            data[1] = (unsigned char)(now >> 8);
            data[2] = (unsigned char)(now >> 16);
            data[3] = (unsigned char)(now >> 24);
            break;

        case 0x19:                      /* compression_type */
            ctype = data[0];
            break;

        case 0x26:                      /* user_filename */
            cp = outputfile;
            if (strchr(cp, '\\')) cp = strrchr(cp, '\\')+1;
            strcpy((char *)data, cp);
            len = (int)strlen((char *)data);
            break;
        }

        if (len != 0 || (pi->flags & MAND))
        {
            putc((unsigned char)pi->id,out); /* write the item */
            putc((unsigned char)(pi->id >> 8),out);
            putc((unsigned char)len,out);
            fwrite(data,1,len,out);
        }
    }

    putc(0,out);                        /* terminate PFH */
    putc(0,out);
    putc(0,out);

    /* get body offset */

    bodypos = ftell(out);

    /* copy file to output, taking checksum */

    csum = 0;

    while ((len = (int)fread(data,1,sizeof(data),inp)) != 0) /* read data */
    {
        fwrite(data,1,len,out);         /* write to output */

        while (len > 0)                 /* update checksum */
            csum += data[--len];
    }

    /* store total file size */

    val = ftell(out);
    fseek(out,fsizepos,0);
    putc((unsigned char)val,out);
    putc((unsigned char)(val >> 8),out);
    putc((unsigned char)(val >> 16),out);
    putc((unsigned char)(val >> 24),out);

    /* store calculated body checksum */

    fseek(out,bcsumpos,0);
    putc((unsigned char)csum,out);
    putc((unsigned char)(csum >> 8),out);

    /* set correct body offset */

    fseek(out,boffpos,0);
    putc((unsigned char)bodypos,out);
    putc((unsigned char)(bodypos >> 8),out);

    /* calculate header checksum */

    csum = 0;
    fseek(out,0L,0);

    while (bodypos-- > 0)
        csum += getc(out);

    /* store calculated header checksum */

    fseek(out,hcsumpos,0);
    putc((unsigned char)csum,out);
    putc((unsigned char)(csum >> 8),out);

    if (ferror(out))
        fprintf(stderr,writeerr,outputfile);

    fclose(inp);
    fclose(out);
    exit(0); /* Alles ok */
}

int main(int argc, char *argv[]) {
         if (argc == 4) pfhadd(argv[1],   /* alter Syntax ... */
                               argv[2],
                               argv[3],
                               "");
    else if (argc == 5) pfhadd(argv[1],   /* ab PACSERV v3.0  */
                               argv[2],
                               argv[3],
                               argv[4]);
    else {
        printf("\nExtended Header Generator for TheNetNode PACSERV v3.3\n");
        printf("Copyright (c) 1994 by NORD><LINK (DB7KG, DG1KWA)\n");
        printf("This file is called from TheNetNode to add the Pacsat Header to a\n");
        printf("received message (from store & forward). Put this into the same\n");
        printf("directory as the PACSAT-Files.\n");
    }
    return(-1);
}
