/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/cvs_cmds.c (maintained by: DL1XAO)                          */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2002 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

/*
 * $Log$
 */

/*
 * This is Ping-Pong convers/conversd derived from the wampes
 * convers package written by Dieter Deyke <deyke@hpfcmdd.fc.hp.com>
 *
 * Modifications by Fred Baumgarten <dc6iq@insl1.etec.uni-karlsruhe.de>
 * $Revision: 3.12 $$Date: 1996/03/03 10:09:47 $
 *
 */

/* zusammengefuehrtes USER.C und HOST.C, damit alle Kommandos samt
   Kommandotabelle mit statischen Funktionen auskommen                    */

#include "cvs_cmds.h"
#ifdef PPCONVERS


/*---------------------------------------------------------------------------*/

void process_input(CONNECTION *cp)
{
  char *arg;
  WORD arglen;
  CMDTABLE *cmdp;
  CHANNEL *ch;
  CONNECTION *c;

  clear_locks();
  cp->locked = 1;
  ts2();

  if (cp->type == CT_USER) {
    arg = convertin(cp->charset_in, cnvinbuf);
    if (arg != cnvinbuf)
      strcpy(cnvinbuf, arg);
  }
  cnvinbuf[2000] = '\0';             /* Zulange Antworten vermeiden */

  if (*cnvinbuf == '/') {
    if (!strncmp(cnvinbuf, "/\377\200", 3) && tolower(*(cnvinbuf+3)) != 'c')
      send_proto("cmds", "RX fm %s %s", cp->name, cnvinbuf+3);
    arglen = (WORD)strlen(arg = getarg(cnvinbuf + 1, GET_NXTLC));
    for (cmdp = cmdtable; cmdp->name; cmdp++)
      if (!strncmp(cmdp->name, arg, arglen)) {
        if (cmdp->states & (1 << cp->type)) {
          (*cmdp->fnc)(cp);
          return;
        }
      }
    if (cp->type == CT_USER) {
      if (!strncmp(arg, "\377\200", 2))      /* unangemeldete Hosts */
        return;                              /* werden ignoriert    */
      appenddirect(cp, "*** Unknown command '/");
      appendstring(cp, arg);
      appenddirect(cp, "'. Type /HELP for help.\r");
      appendprompt(cp, 0);
    }
    else if (cp->type == CT_HOST && !strncmp(arg, "\377\200", 2)) {
      if (strncmp("\377\200host", arg, 6)) {
        *strchr(cnvinbuf, 0) = ' '; /* durch getarg verursachte \0 loeschen */
        h_unknown_command(cp);
      }
    }
    return;
  }

  if (cp->type == CT_USER) {
    if (cp->away)
      appenddirect(cp, "*** You are away, aren't you ? :-)\r");
    if (cp->query[0] == '\0') {
      for (ch = channels; ch; ch = ch->next) {
         if (ch->chan == cp->channel) break;
      }
      if (cp->operator || cp->channelop || !(ch->flags & M_CHAN_M)) {
        send_msg_to_channel(cp->name, cp->channel, cnvinbuf);
      } else {
        appenddirect(cp, "*** This is a moderated channel. Only channel operators may write.\r");
      }
    } else {
      for (c = connections; c; c = c->next)
        if (c->type == CT_USER && !strcmp(c->name, cp->query))
          break;
      if (!c) {
        appenddirect(cp, "*** Queried user left convers.\r");
      } else {
        send_msg_to_user(cp->name, cp->query, cnvinbuf);
      }
    }
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/
/* User-Kommandos                                                            */
/*---------------------------------------------------------------------------*/

static void all_command(CONNECTION *cp)
{
  CHANNEL *ch;
  char *s;

  s = getarg(NULL, GET_ALL);

  for (ch = channels; ch; ch = ch->next) {
    if (ch->chan == cp->channel) break;
  }
  if (cp->operator || cp->channelop || !(ch->flags & M_CHAN_M)) {
    if (*s) {
      send_msg_to_channel(cp->name, cp->channel, s);
    }
  } else {
    appenddirect(cp, "*** This is a moderated channel. Only channel operators may write.\r");
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void away_command(CONNECTION *cp)
{
  char *s;
  char buffer[128];
  CONNECTION *p;

  s = getarg(NULL, GET_ALL);
  if (*s || cp->away) {
    if (*s)
      sprintf(buffer, "%sYou are marked as being away.\r", timestamp);
    else
      sprintf(buffer, "%sYou are no longer marked as being away.\r", timestamp);
    for (p = connections; p; p = p->next) {
      if (p->type == CT_USER && !p->via && !Strcmp(p->name, cp->name)) {
        setstring(&(p->away), s, 256);
        p->atime = currtime;
        p->locked = 1;
      }
    }
    send_awaymsg(cp->name, myhostname, currtime, s);
  } else
    sprintf(buffer, "%sActually you were marked as being here :-)\r", timestamp);

  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void beep_command(CONNECTION *cp)
{
  char buffer[32], *c;

  if (cp->prompt[3] == '\0') {
    cp->prompt[3] = '\007';
    c = "en";
  }
  else {
    cp->prompt[3] = '\0';
    c = "dis";
  }
  sprintf(buffer, "*** Beep mode %sabled\r", c);
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

void bye_command2(CONNECTION *cp, char *reason)
{
  CONNECTION *p;
  WORD users_left;
  CLIST *cl = NULLCLIST;
  WORD channel;

  switch (cp->type) {
  case CT_UNKNOWN:
    cp->type = CT_CLOSED;
    break;
  case CT_USER:
    cp->type = CT_CLOSED;
    cl = cp->chan_list;
    while (cl) {
      users_left = count_user(cl->channel);
      if (!users_left) destroy_channel(cl->channel);
      clear_locks();
      send_user_change_msg(cp->name, cp->host, cl->channel, -1, reason, currtime);
      cp->chan_list = cl->next;
      free (cl);
      cl = cp->chan_list;
    }
    break;
  case CT_HOST:
    cp->type = CT_CLOSED;
    update_permlinks(cp->name, NULLCONNECTION, 0);
    for (p = connections; p; p = p->next)
      if (p->via == cp) {
        p->type = CT_CLOSED;
        clear_locks();
        channel = p->channel;
        send_user_change_msg(p->name, p->host, p->channel, -1, reason, currtime);
        users_left = count_user(channel);
        if (!users_left) destroy_channel(channel);
      }
    break;
  case CT_CLOSED:
    break;
  }
}

/*---------------------------------------------------------------------------*/

void bye_command(CONNECTION *cp)
{
  char *s;
  char buffer[256];

  s = getarg(NULL, GET_ALL);
  if (!s || !*s) {
    bye_command2(cp, "/quit");
  } else {
    sprintf(buffer, "\"%.252s\"", s);
    bye_command2(cp, buffer);
  }
}

/*---------------------------------------------------------------------------*/

static CHANNEL *ins_channel(WORD chan)
{
  CHANNEL *ch, *ch1;

  ch = (CHANNEL *) calloc(1, sizeof(CHANNEL));

  if (ch) {
    ch->chan = chan;

    if (!channels || channels->chan > chan) {
      ch->next = channels;
      channels = ch;
    } else {
      ch1 = channels;
      while (ch1->next) {
        if (ch1->next->chan > chan) {
          ch->next = ch1->next;
          ch1->next = ch;
          return(ch);
        }
        ch1 = ch1->next;
      }
      if (!ch1->next) {
        ch->next = ch1->next;
        ch1->next = ch;
      }
    }
  }

  return(ch);
}

/*---------------------------------------------------------------------------*/

static BOOLEAN has_ChOp(WORD chan)
{
  CONNECTION *p;
  CLIST *cl;

  for (p = connections; p; p = p->next) {
    if (p->type == CT_USER) {
      if (p->channel == chan && p->channelop)
        return(1);
      for (cl = p->chan_list; cl; cl = cl->next)
        if (cl->channel == chan && cl->channelop)
          return(1);
    }
  }
  return(0);
}

/*---------------------------------------------------------------------------*/

static void channel_command(CONNECTION *cp)
{
  char *s;
  char buffer[256];
  WORD newchannel;
  LONG nc;
  CHANNEL *ch;
  CONNECTION *p;
  WORD printit, first;
  CLIST *cl;

  s = getarg(NULL, GET_NXTLC);

  if (!*s) {
    sprintf(buffer, "%sYou are talking to channel %d. There are %d users.\r",
            timestamp, cp->channel, count_user(cp->channel));
    appenddirect(cp, buffer);
    for (ch = channels; ch; ch = ch->next) {
      if (ch->chan == cp->channel) break;
    }
    if (ch->topic) {
      appenddirect(cp, "*** current Topic is:\r               ");
      appendstring(cp, ch->topic);
      appenddirect(cp, "\r");
    }
    printit = 0;
    first = 1;
    for (cl = cp->chan_list; cl; cl = cl->next) {
      if (cl->channel != cp->channel) {
        if (first) {
          first = 0;
          appenddirect(cp, "*** Also attached:");
        } else {
          appenddirect(cp, ",");
        }
        printit = count_user(cl->channel);
        if (printit == 1) {
          sprintf(buffer, " channel %d (alone)", cl->channel);
        } else {
          sprintf(buffer, " channel %d (%d users)", cl->channel, printit);
        }
        appenddirect(cp, buffer);
      }
    }
    if (printit) appenddirect(cp, ".\r");
    appendprompt(cp, 0);
    return;
  }
  nc = atol(s); newchannel = (WORD)nc;
  if (nc < 0L || nc > MAXCHANNEL) {
    sprintf(buffer, "%sChannel numbers must be in the range 0..%d.\r", timestamp, MAXCHANNEL);
    appenddirect(cp, buffer);
    appendprompt(cp, 0);
    return;
  }
  if (newchannel == cp->channel) {
    sprintf(buffer, "%sChannel %d is already default.\r", timestamp, cp->channel);
    appenddirect(cp, buffer);
    appendprompt(cp, 0);
    return;
  }

  for (ch = channels; ch; ch = ch->next) {
    if (ch->chan == newchannel) break;
  }
  for (cl = cp->chan_list; cl; cl = cl->next) {
    if (cl->channel == newchannel) break;
  }
  if (!((cp->invitation_channel == newchannel) || !(ch) || !(ch->flags & M_CHAN_P)) && !cl && !cp->operator) {
    sprintf(buffer, "%sYou need an invitation to join the private channel %d.\r", timestamp, newchannel);
    appenddirect(cp, buffer);
    appendprompt(cp, 0);
    sprintf(buffer, "%s%s@%s try to join your privat channel.", timestamp, cp->name, cp->host);
    send_msg_to_channel("conversd", newchannel, buffer);
    return;
  }
  if (!cl) {
    cl = (CLIST *)calloc(1, sizeof(CLIST));
    if (!cl || (!ch && NULL == ins_channel(newchannel)) ) {
      sprintf(buffer, "%scannot join channel %d, no more space.\r", timestamp, newchannel);
      appenddirect(cp, buffer);
      appendprompt(cp, 0);
      if (cl)
        free(cl);
      return;
    }
    cp->locked = 1;
    send_user_change_msg(cp->name, cp->host, -1, newchannel, cp->pers, cp->time);
    cl->time = currtime;
    cp->mtime = currtime;
    if (!ch || !has_ChOp(newchannel))
      cl->channelop = 2;
    cl->channel = newchannel;
    cl->next = cp->chan_list;
    cp->chan_list = cl;
    cp->locked = 0;
  }
  cp->channel = newchannel;
  sprintf(buffer, "%sYou are now talking to channel %d. ", timestamp, cp->channel);
  appenddirect(cp, buffer);
  if (ch) {
    if ((first = count_user(cp->channel)) == 1) {
      sprintf(buffer, "You're alone.\r");
    } else {
      sprintf(buffer, "There are %d users.\r", first);
    }
    appenddirect(cp, buffer);
    if (ch->topic) {
      appenddirect(cp, "*** current Topic is:\r               ");
      appendstring(cp, ch->topic);
      appenddirect(cp, "\r");
    }
  } else {
    appenddirect(cp, "You're alone.\r");
  }
  if (cl->channelop == 2) {
    for (p = connections; p; p = p->next) {
      if (p->type == CT_HOST) {
        sprintf(buffer, "/\377\200OPER conversd %d %s\r", cp->channel, cp->name);
        appenddirect(p, buffer);
        send_proto("cmds", "TX to %s %s", p->name, buffer+3);
      }
    }
  }
  cp->channelop = cl->channelop;
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void charset_command(CONNECTION *cp)
{
  char *s1, *s2;
  char buffer[300];
  WORD charset_in, charset_out;

  s1 = getarg(NULL, GET_NXTLC);

  if (!*s1) {
    sprintf(buffer, "*** Charset in/out is %s/%s.\r",
                        get_charset_by_ind(cp->charset_in),
                        get_charset_by_ind(cp->charset_out));
    appenddirect(cp, buffer);
    appendprompt(cp, 0);
    return;
  }

  charset_in = get_charset_by_name(s1);

  s2 = getarg(NULL, GET_NXTLC);
  if (*s2) charset_out = get_charset_by_name(s2);
  else charset_out = charset_in;

  if (charset_in < 0 || charset_out < 0) {
    cp->charset_out = ISO;
    sprintf(buffer, "Unknown charset: '%s'.  You may use one of them:\r%s***\r",
                        (charset_in < 0) ? s1 : s2, list_charsets());
    appenddirect(cp, buffer);
    appendprompt(cp, 0);
    return;
  }

  cp->charset_in = charset_in;
  cp->charset_out = charset_out;

  sprintf(buffer, "*** Charset in/out set to %s/%s.\r",
                        get_charset_by_ind(cp->charset_in),
                        get_charset_by_ind(cp->charset_out));
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void cstat_command(CONNECTION *cp)
{
  cp->verbose = 1;            /* Flag wird beim Aendern der Links geloescht */
  if (*getarg(NULL, GET_ALL) != '#') {
    links_command(cp);
    getarg("", GET_NXTLC);    /* damit hosts_command keine Argumente kriegt */
  }
  if (cp->verbose)
    hosts_command(cp);
}

/*---------------------------------------------------------------------------*/

static void filter_command(CONNECTION *cp)
{
  ed_list(cp, 1);
}

/*---------------------------------------------------------------------------*/
/*  Damit convers der sprachlichen Umgebung angepasst werden kann ist
 *  die Hilfe extern organisiert. Die Hilfedatei besteht aus den
 *  jeweiligen Hifstexten, die am Anfang ein Stichwort zum Suchen
 *  haben und zwar @@Stichwort. Der allgemeine Hilfetext sind die
 *  ersten Zeilen in der Datei, bis zum @@ des ersten Stichworts.
 */
static WORD read_xhelp(char *topic, CONNECTION *cp)
{
  FILE *fp;
  char tmp[128], ts[16];
  char *c;

   if (!topic)
     return(0);
   sprintf(tmp, "%sconversd.xhf", textpath);
   if ((fp = xfopen(tmp, "rt")) == NULL)
     return(0);
   if (*topic) {              /* topic gesetzt, suchen... */
     sprintf(ts, "@@%s", topic);
     do {
       if (fgets(tmp, 120, fp) == NULL) {
         fclose(fp);
         return(0);
       }
       if ((c = strpbrk(tmp, "\r\n")) != NULL)
         *c = NUL;
     }
     while (strcmp(ts,tmp));
   }
   if (fgets(tmp, 120, fp) == NULL) {
     fclose(fp);
     return(0);
   }
   do {
     if ((c = strpbrk(tmp, "\r\n")) != NULL)
     {
       *c++ = '\r';
       *c = NUL;
     }
     appendstring(cp, tmp);
     topic = fgets(tmp, 120, fp);
   }
   while (topic && (*tmp != '@' || *(tmp+1) != '@'));
   fclose(fp);
   return(1);
}

static void help_command(CONNECTION *cp)
{
  char *s1;
  CMDTABLE *cmdp;

  s1 = getarg(NULL, GET_NXTLC);
  if (*s1 == '/')
    s1++;

  if (*s1 == '\0')
    read_xhelp("", cp);
  else {
    for (cmdp = cmdtable; cmdp->name; cmdp++)
      if ((cmdp->states & (1 << cp->type)) && !strnicmp(cmdp->name, s1, strlen(s1)))
        break;
    if (cmdp->name) {
      if (!read_xhelp(cmdp->help, cp))
        appenddirect(cp, "Help on this command not yet implemented...\rWrite it - or try another one :-)\r");
    }
    else
      appenddirect(cp, "No such command...\r");
  }
  appendprompt(cp, 1);
}

/*---------------------------------------------------------------------------*/

static void hosts_command(CONNECTION *cp)
{
  char buffer[256], tmp[64];
  DESTINATION *d;
  WORD i = 1;
  char *dest;

  dest = getarg(NULL, GET_NXTCS);

  if (*dest == '\0') {
    for (d = destinations; d; d = d->next) {
      if (d->rtt) {
        sprintf(buffer, "%-9.9s (%-8.8s) %3s", d->name, d->rev, ts3(d->rtt,tmp));
        appenddirect(cp, buffer);
        if ((i == 3) || !(d->next)) {
          appenddirect(cp, "\r");
          i = 0;
        } else {
          appenddirect(cp, "   ");
        }
        i++;
      }
    }
    if ((i != 1)) {
      appenddirect(cp, "\r");
    }
    if (cp->type == CT_USER) {
      appendprompt(cp, 1);
    }
  } else if (*dest == '#') {
    for (d = destinations; d; d = d->next) {
      if (d->rtt)
        sprintf(buffer, "%-12.12s (%-8.8s) %5ld ->%-6s", d->name, d->rev, (long)d->rtt, d->link->cname);
       else
        sprintf(buffer, "%-12.12s                0         ", d->name);
      appenddirect(cp, buffer);
      if ((i == 2) || !(d->next)) {
        appenddirect(cp, "\r");
        i = 0;
      } else {
        appenddirect(cp, "   ");
      }
      i++;
    }
    if ((i != 1)) {
      appenddirect(cp, "\r");
    }
    if (cp->type == CT_USER) {
      appendprompt(cp, 1);
    }
  } else {
    for (d = destinations; d; d = d->next) {
      if (d->rtt && d->link && !strcmp(d->name, dest)) {
        clear_locks();
        sprintf(buffer, "*** Host : %s (%-8.8s) T=%lds\r", dest, d->rev, (long)d->rtt);
        appenddirect(cp, buffer);
        sprintf(buffer, "*** route: %s (%ld) %s -> %s\r", myhostname,
                        (long)((d->link->rxtime + d->link->txtime) / 2L),
                        d->link->cname, dest);
        appenddirect(cp, buffer);
        if (strcmp(dest, d->link->name)) {
          sprintf(buffer, "/\377\200ROUT %s %s 99\r", dest, cp->name);
          appenddirect(d->link->connection, buffer);
          send_proto("cmds", "TX to %s %s", d->link->connection->name, buffer+3);
        }
        break;
      }
    }
    if (d == NULLDESTINATION) {
      sprintf(buffer, "*** no route to %s\r", dest);
      appenddirect(cp, buffer);
    }
    appendprompt(cp, 0);
  }
}

/*---------------------------------------------------------------------------*/

static void imsg_command(CONNECTION *cp)
{
  char *toname, *text;
  CONNECTION *p, *q;

  toname = getarg(NULL, GET_NXTLC);
  text = getarg(NULL, GET_ALL);
  if (!*text) {
    appendprompt(cp, 0);
    return;
  }
  for (p = connections; p; p = p->next) {
    if (p->type == CT_USER && p->channel == cp->channel && strcmp(p->name, toname) != 0) {
      send_msg_to_user(cp->name, p->name, text);
      q = p->next;
      while (q) {
        if (!strcmp(p->name, q->name))
           q->locked = 1;
        q = q->next;
      }
    }
    if (p->via)
      p->via->locked = 0;
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void invite_command(CONNECTION *cp)
{
  char *toname;

  toname = getarg(NULL, GET_NXTLC);
  if (*toname) send_invite_msg(cp->name, toname, cp->channel);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void leave_command(CONNECTION *cp)
{
  WORD chan;
  WORD users_left;
  CLIST *cl, *cl2;
  char *arg;
  char buffer[128];

  arg = getarg(NULL, GET_NXTLC);
  if (*arg) {
    chan = atoi(arg);
  } else {
    chan = cp->channel;
  }
  if ((chan == cp->channel) && (cp->chan_list->next == NULLCLIST)) {
    bye_command(cp);
    return;
  }
  cl2 = cp->chan_list;
  if (cl2->channel == chan) {
    cp->chan_list = cl2->next;
    free(cl2);
    users_left = count_user(chan);
    if (!users_left) destroy_channel(chan);
    cp->locked = 1;
    send_user_change_msg(cp->name, cp->host, chan, -1, "/leave", cp->time);
    cp->locked = 0;
    if (chan == cp->channel) {
      cp->channel = cp->chan_list->channel;
      cp->channelop = cp->chan_list->channelop;
      sprintf(buffer, "%sDefault channel is now %d.\r", timestamp, cp->channel);
      appenddirect(cp, buffer);
      appendprompt(cp, 0);
    } else {
      sprintf(buffer, "%sLeft channel %d.\r", timestamp, chan);
      appenddirect(cp, buffer);
      appendprompt(cp, 0);
    }
    return;
  }
  cl = cp->chan_list;
  while (cl) {
    if (cl->channel == chan) {
      cl2->next = cl->next;
      free (cl);
      cl = cl2;
      users_left = count_user(chan);
      if (!users_left) destroy_channel(chan);
      cp->locked = 1;
      send_user_change_msg(cp->name, cp->host, chan, -1, "/leave", cp->time);
      cp->locked = 0;
      if (chan == cp->channel) {
        cp->channel = cp->chan_list->channel;
        cp->channelop = cp->chan_list->channelop;
        sprintf(buffer, "%sDefault channel is now %d.\r", timestamp, cp->channel);
        appenddirect(cp, buffer);
        appendprompt(cp, 0);
        return;
      } else {
        sprintf(buffer, "%sLeft channel %d.\r", timestamp, chan);
        appenddirect(cp, buffer);
        appendprompt(cp, 0);
        return;
      }
    } else {
      cl2 = cl;
    }
    cl = cl->next;
  }
  sprintf(buffer, "%sYou were not on channel %d.\r", timestamp, chan);
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/
static BOOLEAN scan_linksarg(char *arg, char *hostname, WORD *act,
                             char *call, char *via, WORD *prt)
{
  WORD port, bcnt;
  char buffer[256], *bp;

  if (*arg == '-' || *arg == '+') {
    if (*arg == '-')
      *act = 1;
    do {
      arg++;
    } while (*arg == ' ');
  }

  bcnt = (WORD) min(strlen(arg), 255);
  if (!bcnt)
    return(FALSE);
  arg[bcnt] = NUL;
  bp = buffer;
  strcpy(buffer, arg);

  if (getcal(&bcnt, &bp, TRUE, call) != YES)           /* Call ok ? */
    return(FALSE);

  callss2str(hostname, call);           /* hostname: Call ohne SSID */
  strlwr(hostname);
  if (*act)                      /* Beim Loeschen reicht das soweit */
    return(TRUE);

  *prt = 255;
  *via = '\0';
  if (skipsp(&bcnt, &bp) == FALSE)        /* keine weiteren Angaben */
    return(TRUE);

  if (bcnt && !isdigit(*bp))                    /* Keine Portangabe */
    return(FALSE);

  port = nxtnum(&bcnt, &bp);
  if (port >= L2PNUM && port != 254)              /* Falscher Port */
    return(FALSE);

  *prt = port;
  if (port != 254)
    getdig(&bcnt, &bp, 0, via);

  return(TRUE);
}


/*  /links - host                  loeschen (egal, ob L2 oder circuit)
 *  /links [+] host                circuit eintragen
 *  /links [+] host port [vialist] L2 Verbindung eintragen
 *  /links @ host                  Fernabfrage versenden
 */

static void links_command(CONNECTION *cp)
{
  char buffer[128];
  char hn[L2CALEN+1], hc[L2IDLEN], hv[L2VLEN+1];
  char *arg;
  WORD pl, remove = 0, hp;
  PERMLINK *p;
  CONNECTION *c;

  arg = getarg(NULL, GET_ALL);
  if (*arg == '@' && cp->type == CT_USER) { /* Fernabfrage, aehnlich tpp */
    arg = getarg(NULL, GET_NXTCS);
    if (*arg == '@') arg++;
    if (!*arg) arg = getarg(NULL, GET_NXTCS);
    if (!Strcmp(myhostname, arg)) {
      disp_links(cp, NULL);
      appendprompt(cp, 1);
    } else {
      sprintf(buffer, "/\377\200LINK %s %s\r", cp->name, arg);
      for (c = connections; c; c = c->next)
        if (c->type == CT_HOST) {
          appenddirect(c, buffer);
          send_proto("cmds", "TX to %s %s", c->name, buffer+3);
        }
      sprintf(buffer, "*** Request sent to %s.\r", arg);
      appenddirect(cp, buffer);
      appendprompt(cp, 0);
    }
    return;
  }
  if (*arg) {
    if (cp->operator != 2) {
      appenddirect(cp, "You must be an operator to set up new links\r");
    } else {
      if (scan_linksarg(arg, hn, &remove, hc, hv, &hp) == TRUE) {
        for (pl = 0; pl < MAXCVSHOST; pl++) {
          p = permarray[pl];
          if (p && !strcmp(p->cname, hn)) {
            if (p->connection)
              bye_command2(p->connection, "link killed");
            if (permarray[pl] != NULLPERMLINK) {
              permarray[pl] = NULLPERMLINK;
              free(p);
            }
            break;
          }
        }
        for (c = connections; c; c = c->next)
          if (!strcmp(c->name, hn))
            bye_command2(c, "link killed");
        if (!remove) {
          p = update_permlinks(hn, NULLCONNECTION, 1);
          if (p) {
            strcpy(p->cname, hn);
            p->port        = hp;                              /* port  */
            cpyid(p->call,   hc);                             /* call  */
            cpyidl(p->via,   hv);                             /* digis */
          } else {
            appenddirect(cp, "Link table full !\r");
          }
        }
        cp->verbose = 0; /* bei cstat keine Destinations mehr anzeigen */
        userpo->sysflg = 2;
      } else {
        appenddirect(cp, "Argument error !\r");
      }
    }
  }
  disp_links(cp, NULL);
  if (cp->type == CT_USER) {
    appendprompt(cp, 1);
  }
}

static void disp_links(CONNECTION *cp, char *user)
{
  char buffer[128], *bp, tmp[10];
  WORD pl;
  PERMLINK *p;

  strcpy(buffer, "Host      State        Quality Revision  Since NextTry Tries Queue    RX    TX");
  if (user) {
    clear_locks();
    send_msg_to_user ("conversd", user, buffer);
  } else {
    strcat(buffer, "\r");
    appenddirect(cp, buffer);
  }
  for (pl = 0; pl < MAXCVSHOST; pl++) {
    p = permarray[pl];
    if (p) {
      bp = buffer;
      bp += sprintf(bp, "%-9.9s ", p->cname);
      if (!p->connection) {
        bp += sprintf(bp, "%s   ---            %s",
                      (p->locked)?"Disc./locked":"Disconnected", ts(p->statetime));
        if (p->port != 254)
          bp += sprintf(bp, " %s %5d", ts(p->retrytime), p->tries);
      } else {
        if (p->connection->type == CT_HOST) {
          bp += sprintf(bp, "Connected    ");
          if (p->txtime || p->rxtime) {
            if (p->rxtime == -1) {
              bp += sprintf(bp, "  %3s  ", ts3(p->txtime, tmp));
            } else {
              bp += sprintf(bp, "%3s/", ts3(p->txtime, tmp));
              bp += sprintf(bp, "%-3s", ts3(p->rxtime, tmp));
            }
          } else {
            bp += sprintf(bp, "  ---  ");
          }
          bp += sprintf(bp, " %-8.8s %s               %5ld %4ldK %4ldK",
                  p->connection->rev, ts(p->connection->time),
                  queuelength(p->connection), p->connection->received/1024L,
                  p->connection->xmitted/1024L);
        } else {
          bp += sprintf(bp, "Connecting     ---            %s", ts(p->statetime));
          bp += sprintf(bp, " %s %5d", ts(p->retrytime), p->tries);
        }
      }
      if (user) {
        clear_locks();
        send_msg_to_user ("conversd", user, buffer);
      } else {
        strcpy(bp, "\r");
        appenddirect(cp, buffer);

        if (cp->operator) {
          call2str(tmp, p->call);
          bp = buffer;
          if (p->port == 254) {
            bp += sprintf(bp, "(trusted host");
          } else {
            bp += sprintf(bp, "(%s", tmp);
            if (p->port != 255) {
              bp += sprintf(bp, " on port %d", p->port);
              if (*p->via) {
               char *liste = p->via;
                bp += sprintf(bp, " via");
                while (*liste) {
                  call2str(tmp, liste);
                  bp += sprintf(bp, " %s", tmp);
                  liste += L2IDLEN;
                }
              }
            }
          }
          strcpy(bp, ")\r");
          appenddirect(cp, buffer);
        }
      }
      if (p->nlcks) {
        sprintf(buffer, " %d loops detected.", p->nlcks);
        if (user) {
          clear_locks();
          send_msg_to_user ("conversd", user, buffer);
        } else {
          strcat(buffer, "\r");
          appenddirect(cp, buffer);
        }
      }
    }
  }
  if (user) {
    clear_locks();
    send_msg_to_user ("conversd", user, "***");
  }
}

/*---------------------------------------------------------------------------*/

static void list_command(CONNECTION *cp)
{
  char buffer[2048];
  char *flags, *bp;
  register CHANNEL *ch;
  WORD hide, showit, isonchan, n;
  CONNECTION *p;
  CLIST *cl;

  appenddirect(cp, "Channel Flags  Topic\r        Users\r");
  for (ch = channels; ch; ch = ch->next) {
    isonchan = 0;
    hide = 0;
    if (ch->chan == cp->channel)
      isonchan++;
    for (cl = cp->chan_list; cl && !isonchan; cl = cl->next) {
      if (cl->channel == ch->chan) {
        isonchan++;
      }
    }
    flags = getflags(ch->flags);
    if (ch->flags & M_CHAN_S)
      hide |= 1;
    if (ch->flags & M_CHAN_I)
      hide |= 2;
    showit = 0;
    bp = buffer;
    if (!hide || isonchan || cp->operator) {
      if (!ch->flags && (!ch->topic)) {
        bp += sprintf(bp, "%7d", ch->chan);
      } else {
        bp += sprintf(bp, "%7d %-6.6s %s\r       ", ch->chan, flags, ch->topic?ch->topic:"");
      }
      showit++;
    } else {
      if (hide == 1) {
        bp += sprintf(bp, "------- %-6.6s %s\r       ", flags, ch->topic?ch->topic:"");
        showit++;
      }
    }
    n = 9;
    if (showit) {
      for (p = connections; p; p = p->next) {
        if (p->type == CT_USER) {
          if (p->via) {
            if (p->channel == ch->chan) {
              if (n > cp->width - 12) {
                n = 9;
                bp += sprintf(bp, "\r       ");
              }
              bp += sprintf(bp, " %s(", p->name);
              n += 2 + (WORD)strlen(p->name);
              if (p->operator) {
                *bp++ = '!';
                n++;
              }
              else if (p->channelop) {
                *bp++ = '@';
                n++;
              }
              if (p->away) {
                *bp++ = 'G';
                n++;
              }
              if (*(bp-1) == '(') {
                bp--;
                n--;
              } else {
                *bp++ = ')';
                n++;
              }
            }
          } else {
            for (cl = p->chan_list; cl; cl = cl->next) {
              if (cl->channel == ch->chan) {
                if (n > cp->width - 12) {
                  n = 9;
                  bp += sprintf(bp, "\r       ");
                }
                bp += sprintf(bp, " %s(", p->name);
                n += 2 + (WORD)strlen(p->name);
                if (p->operator) {
                  *bp++ = '!';
                  n++;
                }
                else if (cl->channelop) {
                  *bp++ = '@';
                  n++;
                }
                if (p->away) {
                  *bp++ = 'G';
                  n++;
                }
                if (*(bp-1) == '(') {
                  bp--;
                  n--;
                } else {
                  *bp++ = ')';
                  n++;
                }
              }
            }
          }
        }
      }
      *bp++ = '\r';
      *bp = '\0';
      appendstring(cp, buffer);
    }
  }
  if (cp->type == CT_USER) {
    appendprompt(cp, 1);
  }
}

/*---------------------------------------------------------------------------*/

static void me_command(CONNECTION *cp)
{
  char *text;
  char buffer[2048];
  CHANNEL *ch;

  text = getarg(NULL, GET_ALL);

  if (*text) {
    for (ch = channels; ch; ch = ch->next) {
      if (ch->chan == cp->channel) break;
    }
    if (cp->operator || cp->channelop || !(ch->flags & M_CHAN_M)) {
      cp->locked = 1;
      sprintf(buffer, "*** %s@%s %s", cp->name, cp->host, text);
      send_msg_to_channel("conversd", cp->channel, buffer);
    } else {
      appenddirect(cp, "*** This is a moderated channel. Only channel operators may write.\r");
    }
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void msg_command(CONNECTION *cp)
{
  char *toname, *text;
  char buffer[600];
  CONNECTION *p;
  WORD chan;
  CHANNEL *ch;
  CLIST *cl;

  toname = getarg(NULL, GET_NXTLC);
  text = getarg(NULL, GET_ALL);
  if (!*text) {
    appendprompt(cp, 0);
    return;
  }
  if (toname[0] == '#') {
    chan = atoi(toname+1);
    for (cl = cp->chan_list; cl; cl = cl->next) {
      if (cl->channel == chan) break;
    }
    if (!cl) {
      sprintf(buffer, "%sYou have not joined channel %d.\r", timestamp, chan);
      appenddirect(cp, buffer);
    } else {
      for (ch = channels; ch; ch = ch->next) {
        if (ch->chan == chan) break;
      }
      if (cl->channelop || !(ch->flags & M_CHAN_M)) {
        send_msg_to_channel(cp->name, chan, text);
      } else {
        appenddirect(cp, "*** This is a moderated channel. Only channel operators may write.\r");
      }
    }
  } else {
    for (p = connections; p; p = p->next)
      if (p->type == CT_USER && !strcmp(p->name, toname)) break;
    if (!p) {
      sprintf(buffer, "%sNo such user: %s.\r", timestamp, toname);
      appendstring(cp, buffer);
    } else {
      if (p->away) {
        sprintf(buffer, "%s%s is away: %s\r", timestamp, toname, p->away);
        appendstring(cp, buffer);
      }
      send_msg_to_user(cp->name, toname, text);
    }
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void mode_command(CONNECTION *cp)
{
  char *arg, *c;
  WORD remove = 0;
  WORD channel;
  CONNECTION *p;
  register CHANNEL *ch;
  WORD oldflags = 0;
  CLIST *cl;
  WORD op = 0;

  if (cp->type == CT_USER) {
    arg = getarg(NULL, GET_ALL);
    if (isdigit(*arg))
      channel = atoi(getarg(NULL, GET_NXTLC));
    else
      channel = cp->channel;
    arg = getarg(NULL, GET_ALL);
    for (cl = cp->chan_list; cl; cl = cl->next) {
      if ((cl->channel == channel) && (cl->channelop)) {
        op++;
        break;
      }
    }
  }
  else {
    channel = atoi(getarg(NULL, GET_NXTLC));
    arg = getarg(NULL, GET_ALL);
  }

  for (ch = channels; ch; ch = ch->next)
    if (channel == ch->chan)
      break;

  if (!ch && cp->type == CT_USER) {
    appenddirect(cp, "*** non existing channel !\r");
    appendprompt(cp, 0);
    return;
  }

  /* Kanal 0 soll keine setzbaren Flags haben.
     Flags von Hosts werden durchgereicht.
     Sysop loescht fern, bei Aufruf von /mo                      */
  if (channel == 0) {
    if (cp->type == CT_USER) {    /* bei uns eingegeben          */
      if (!cp->operator) {        /* User duerfen nix            */
        appenddirect(cp, "*** no modes on channel 0 !\r");
        appendprompt(cp, 0);
        return;
      }
      else {                      /* Sysop setzt andere Hosts    */
        arg = "-sptiml";          /* zurueck (arg ist egal)      */
        ch->flags = 0xFFFFU;      /* alle Flags an, zum Loeschen */
      }
    }
  } /* Flags werden unten nochmals (nach Aussendung) geloescht */

  if (*arg) {
    if (op || cp->operator || (cp->type == CT_HOST)) {
      if (ch)
        oldflags = ch->flags;
      while (*arg) {
        switch (toupper(*arg)) {
        case '+':
          remove = 0;
          arg++;
          break;

        case '-':
          remove = 1;
          arg++;
          break;

        case 'I':
          if (ch) {
            if (remove) ch->flags &= ~(M_CHAN_I);
              else      ch->flags |= M_CHAN_I;
          }
          arg++;
          break;

        case 'L':
          if (ch) {
            if (remove) ch->flags &= ~(M_CHAN_L);
              else      ch->flags |= M_CHAN_L;
          }
          arg++;
          break;

        case 'M':
          if (ch) {
            if (remove) ch->flags &= ~(M_CHAN_M);
              else      ch->flags |= M_CHAN_M;
          }
          arg++;
          break;

        case 'O':
          arg++;
          while (*arg) {
            while (*arg == ' ') arg++;
            c = arg;
            while (*c != '\0' && *c != ' ')
              *c++ = tolower(*c);
            if (*c != '\0')
              *c++ = '\0';
            for (p = connections; p; p = p->next) {
              if (p->type == CT_USER && !Strcmp(p->name, arg)) {
                if ((channel == -1) && (cp->type == CT_HOST)) {
                  p->operator = 1;
                  send_opermsg(arg, p->host, cp->name, -1);
                } else {
                  if (p->channel == channel) {
                    p->channelop = 1;
                  }
                  for (cl = p->chan_list; cl; cl = cl->next) {
                    if (cl->channel == channel) cl->channelop = 1;
                  }
                  send_opermsg(arg, p->host, cp->name, channel);
                }
              }
            }
            arg = c;
          }
          break;

        case 'P':
          if (ch) {
            if (remove) ch->flags &= ~(M_CHAN_P);
              else      ch->flags |= M_CHAN_P;
          }
          arg++;
          break;

        case 'S':
          if (ch) {
            if (remove) ch->flags &= ~(M_CHAN_S);
              else      ch->flags |= M_CHAN_S;
          }
          arg++;
          break;

        case 'T':
          if (ch) {
            if (remove) ch->flags &= ~(M_CHAN_T);
              else      ch->flags |= M_CHAN_T;
          }
          arg++;
          break;

        default:
          arg++;
          break;
        }
      }
      if (ch && ch->flags != oldflags) {
        if (cp->type == CT_HOST)
          cp->locked = 1;
        send_mode(ch);
        if (channel == 0)            /* KEINE Flags auf Kanal 0 ! */
          ch->flags = 0;
      }
    } else {
      appenddirect(cp, "*** You are not an operator !\r");
    }
  }
  if (cp->type == CT_USER) {
    appenddirect(cp, "*** Flags: ");
    appenddirect(cp, getflags(ch->flags));
    appenddirect(cp, "\r");
    appendprompt(cp, 0);
  }
}


/*---------------------------------------------------------------------------*/

static void name_command(CONNECTION *cp)
{
  char buffer[2048], *pers;
  WORD newchannel;
  LONG nc;
  CHANNEL *ch;
  CLIST *cl;
  WORD cnt;

  getarg(NULL, GET_NXTLC);                                  /* name */

  cp->type = CT_USER;
  sprintf(buffer, "%s @ %s PingPong-Release %5.5s (TNN) - Type /HELP for help.\r", convtype, myhostname, strchr(REV, ':')+2);
  appenddirect(cp, buffer);
  nc = atol(getarg(NULL, GET_NXTLC)); newchannel = (WORD)nc;
  if (nc < 0L || nc > MAXCHANNEL) {
    sprintf(buffer, "%sChannel numbers must be in the range 0..%d.\r", timestamp, MAXCHANNEL);
    appenddirect(cp, buffer);
    newchannel = 0;
  }
  cp->channel = newchannel;
  for (ch = channels; ch; ch = ch->next) {
    if (ch->chan == cp->channel) break;
  }
  if (ch && (ch->flags & M_CHAN_P) && !cp->operator) {
    sprintf(buffer, "%sYou need an invitation to join channel %d.\r", timestamp, newchannel);
    appenddirect(cp, buffer);
    sprintf(buffer, "%s%s@%s try to join your privat channel.", timestamp, cp->name, cp->host);
    send_msg_to_channel("conversd", cp->channel, buffer);
    clear_locks();
    cp->locked = 1;
    cp->channel = 0;
    newchannel = 0;
    for (ch = channels; ch; ch = ch->next) {
      if (ch->chan == cp->channel) break;
    }
  }
  pers = personalmanager(GET, cp, NULL);

  cl = (CLIST *) calloc(1, sizeof(CLIST));
  if (!cl || (!ch && NULL == ins_channel(newchannel)) ) {
    sprintf(buffer, "%scannot join channel %d, no more space.\r", timestamp, newchannel);
    appenddirect(cp, buffer);
    appendprompt(cp, 0);
    if (cl)
      free(cl);
    cp->type = CT_CLOSED;
    return;
  }
  if (ch) {
    cnt = count_user(newchannel);
    sprintf(buffer, "%sYou are now talking to channel %d. ", timestamp, newchannel);
    appenddirect(cp, buffer);
    if (!cnt) {
      sprintf(buffer, "You're alone.\r");
    } else {
      sprintf(buffer, "There are %d users.\r", cnt+1);
    }
    appenddirect(cp, buffer);
    if (ch->topic) {
      sprintf(buffer, "*** current Topic is:\r               %s\r", ch->topic);
      appendstring(cp, buffer);
    }
    cp->channelop = (has_ChOp(newchannel)) ? 0 : 1;
  } else {
    sprintf(buffer, "*** You created a new channel %d.\r", cp->channel);
    appenddirect(cp, buffer);
    cp->channelop = 1;
  }
  cl->next = NULLCLIST;
  cl->channelop = cp->channelop;
  cl->channel = cp->channel;
  cl->time = currtime;
  cp->mtime = currtime;
  cp->chan_list = cl;
  send_user_change_msg(cp->name, cp->host, -1, cp->channel, pers, currtime);
  if (cp->channelop) {
    clear_locks();
    send_opermsg(cp->name, cp->host, "conversd", cp->channel);
  }
  if (cp->operator) {        /* TNN Sysop-Status wird durchgereicht */
    clear_locks();
    send_opermsg(cp->name, myhostname, cp->name, -1);
  }
  if (pers == NULL) {                /* freshmeat, jummy    XAO*/
    read_xhelp("FAID", cp);
  } else if (*pers) {
    sprintf(buffer, "*** Personal text and data set.\rHello, %s\r", pers);
    appendstring(cp, buffer);
    appendprompt(cp, 1);
    setstring(&(cp->pers), pers, 256);
  } else
    appenddirect(cp, "*** Please set your personal text. ( /H PERS )\r");
}

/*---------------------------------------------------------------------------*/

static void notify_command(CONNECTION *cp)
{
  ed_list(cp, 0);
}

/*---------------------------------------------------------------------------*/

/*
 * Bearbeiten von Userlisten
 * which = 0 modifiziert die /notify-, sonst /filter-Liste
 */
static void ed_list(CONNECTION *cp, WORD which)
{
  char *p, *q, *toname;
  CONNECTION *pc;
  char buffer[256], tmp[512], wbuf[512];
  WORD action;

  toname = getarg(NULL, GET_NXTLC);
  strcpy(tmp, toname);
  toname = tmp;

  p = (which == 0) ? cp->notify : cp->filter;
  if (p)
    strcpy(wbuf, p);
  else
    *wbuf = '\0';

  if (*toname == '\0') {
    sprintf(buffer,
           (which == 0) ? "%sYou are notified if one of the following users sign on/off:\r"
                       : "%sYou filter the messages of the following users:\r",
            timestamp);
    appenddirect(cp, buffer);
    appendstring(cp, wbuf);
    appenddirect(cp, "\r");
  }

  action = 0;
  while (*toname) {
    while ((*toname == '+') || (*toname == '-')) {
      while (*toname == '+') {
        action = 0;
        toname++;
        if (*toname == '\0') {
          toname = getarg(NULL, GET_NXTLC);
          strcpy(tmp, toname);
          toname = tmp;
          if (*toname == '\0') {
            break;
          }
        }
      }
      while (*toname == '-') {
        action = 1;
        toname++;
        if (*toname == '\0') {
          toname = getarg(NULL, GET_NXTLC);
          strcpy(tmp, toname);
          toname = tmp;
          if (*toname == '\0') {
            break;
          }
        }
      }
    }
    strcat(toname, " ");
    p = wbuf;
    p = strstr(p, toname);
    while (p) {
      p--;
      if (*p != ' ') {
        p++;
        p++;
      } else {
        q = ++p;
        while (*q != ' ') q++;
        while (*q == ' ') q++;
        while (*q != '\0') *p++ = *q++;
        *p = *q;
        p = wbuf;
      }
      p = strstr(p, toname);
    }
    if (action == 0 && strcmp(toname, "conversd ")) {
      if (wbuf[0] == '\0') {
        strcpy(wbuf, " ");
      }
      strcat(wbuf, toname);
      if (which == 0) {
        for (pc = connections; pc; pc = pc->next) {
          sprintf(buffer, "%s ", pc->name);
          if ((pc->type == CT_USER) && !strncmp(tmp, buffer, strlen(buffer))) {
            sprintf(buffer, "*** %s is online.\r", pc->name);
            appendstring(cp, buffer);
            break;
          }
        }
      }
    }
    toname = getarg(NULL, GET_NXTLC);
    strcpy(tmp, toname);
    toname = tmp;
  }
  appendprompt(cp, 0);
  setstring((which == 0) ? &cp->notify : &cp->filter, wbuf, 256);
}

/*---------------------------------------------------------------------------*/

static void personal_command(CONNECTION *cp)
{
  char *s;
  char buffer[128], *bp;

  s = getarg(NULL, GET_ALL);

  bp = buffer + sprintf(buffer, "%sPersonal text ", timestamp);

  if (!*s) {
    if (cp->pers) {
      s = cp->pers;
      strcpy(bp, "and data saved.\r");
    } else {
      appenddirect(cp, "*** No personal text to save.\r");
      appendprompt(cp, 0);
      return;
    }
  } else if (!strcmp(s, "@")) {
    s = "";
    strcpy(bp, "deleted.\r");
  } else {
    strcpy(bp, "and data set.\r");
  }
  personalmanager(SET, cp, s);
  if (s != cp->pers) {
    setstring(&(cp->pers), s, 256);
    cp->mtime = currtime;
    send_persmsg(cp->name, myhostname, cp->channel, s, cp->time);
  }
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void prompt_command(CONNECTION *cp)
{
  char buffer[32];
  char *args, *p;

  args = getarg(NULL, GET_ALL);
  p = cp->prompt;
  p[2] = '\0';
  p[3] = '\0';
  p[0] = '\0';

  if ((p[1] = args[0]) != '\0')
    if ((p[2] = args[1]) != '\0')
      if ((p[3] = args[2]) != '\0')
        p[0] = args[3];
  if (p[3] == '\b' && p[0] == '\0') {
    p[0] = '\b';
    p[3] = '\0';
  }

  sprintf(buffer, "*** Prompting mode %sabled\r", (*args) ? "en" : "dis");
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/
/* die loop-lock Loesung soll anders geschehen */
/* restart loest die loop-locks,
   mit dem Komando ist noch mehr geplant
*/
static void restart_command(CONNECTION *cp)
{
  char     buffer[128];
  WORD     pl;
  PERMLINK *p;

  if (cp->operator != 2) {
      appenddirect(cp, "You must be an operator to restart!\r");
    }
    else {
    for (pl = 0; pl < MAXCVSHOST; pl++) {
      p = permarray[pl];
      if (p) {
        if (p->locked) {
          p->locked = 0;
          p->statetime = currtime; /* Aufbauzeit auf 1min spaeter setzen */
          p->tries = 0;
          p->waittime = 60;
          p->rxtime = 0;
          p->txtime = 0;
          p->testwaittime = currtime;
          p->testnexttime = currtime + 60;
          p->retrytime = currtime + p->waittime;
          sprintf(buffer, "Link to %s delocked.\r", p->cname);
          appenddirect(cp, buffer);
        }
      }
    }
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void query_command(CONNECTION *cp)
{
  char *toname;
  char buffer[128];
  CONNECTION *p;

  toname = getarg(NULL, GET_NXTLC);

  if (*toname) {
    for (p = connections; p; p = p->next)
      if (p->type == CT_USER && !strcmp(p->name, toname)) break;
    if (!p) {
      sprintf(buffer, "%sNo such user: %.20s.\r", timestamp, toname);
      appendstring(cp, buffer);
    }
    else {
      strcpy(cp->query, toname);
      sprintf(buffer, "%sStarting private conversation with %s.\r", timestamp, cp->query);
      appendstring(cp, buffer);
    }
  }
  else if (cp->query[0] != '\0') {
    sprintf(buffer, "%sEnding private conversation with %s.\r", timestamp, cp->query);
    appendstring(cp, buffer);
    cp->query[0] = '\0';
  }
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void topic_command(CONNECTION *cp)
{
  CHANNEL *ch;
  CONNECTION *p;
  register char *topic;
  char buffer[128];
  time_t time;
  WORD channel;

  channel = cp->channel;
  topic = getarg(NULL, GET_ALL);
  if (*topic == '#') {
    topic++;
    while (*topic == ' ') topic++;
    channel = atoi(topic);
    while (*topic && *topic != ' ') topic++;
    while (*topic == ' ') topic++;
  }
  for (p = connections; p; p = p->next)
    if (p->type == CT_USER && !strcmp(p->name, cp->name) && (p->channel == channel)) break;
  time = currtime;
  for (ch = channels; ch; ch = ch->next) {
    if (ch->chan == channel) break;
  }
  if (ch) {
    if (ch->time > time) time = ch->time+1L;
    if (*topic) {
      if (p && (((ch->flags & M_CHAN_T) == 0) || cp->operator || p->channelop)) {
        if (*topic == '@') {
          *topic = '\0';
          sprintf(buffer, "%sChannel topic on channel %d removed.\r", timestamp, channel);
        } else {
          sprintf(buffer, "%sChannel topic set on channel %d.\r", timestamp, channel);
        }
        send_topic(cp->name, cp->host, time, channel, topic);
      } else {
        sprintf(buffer, "%sYou are not an operator.\r", timestamp);
      }
    } else {
      if (ch->topic) {
        sprintf(buffer, "%sCurrent channel topic on channel %d is\r               ", timestamp, channel);
        appenddirect(cp, buffer);
        appendstring(cp, ch->topic);
        strcpy(buffer, "\r");
      } else {
        sprintf(buffer, "%sNo current channel topic on channel %d.\r", timestamp, channel);
      }
    }
  } else {
    sprintf(buffer, "%sChannel channel %d non existent.\r", timestamp, channel);
  }
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void uptime_command(CONNECTION *cp)
{
  char buffer[128];

  sprintf(buffer, "*** %s@%s is up for %s\r", convtype, myhostname, ts4(currtime - boottime));
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void verbose_command(CONNECTION *cp)
{
  char buffer[32];

  cp->verbose = 1 - cp->verbose;
  sprintf(buffer, "*** Verbose mode %sabled\r", (cp->verbose) ? "en" : "dis");
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void version_command(CONNECTION *cp)
{
  char buffer[128];

  sprintf(buffer, "*** conversd PingPong-Release %5.5s (TNN)\r", strchr(REV, ':')+2);
  appenddirect(cp, buffer);
  appenddirect(cp, "  This conversd implementation was originally written by Dieter Deyke\r"
                   "  <deyke@mdddhd.fc.hp.com>. It was modified and maintained up to version\r"
                   "  3.11 by Fred Baumgarten, dc6iq. This implementation is partly rewritten,\r"
                   "  enhanced and maintained by Odo Roscher <dl1xao@db0hhb.#hh.deu.eu>\r"
                   "  for TheNetNode and Xnet.\r");

  appendprompt(cp, 1);
}

/*---------------------------------------------------------------------------*/

static void who_command(CONNECTION *cp)
{
  char buffer[2048];
  char tmp[20];
  WORD flags;
  WORD thischan = -1;
  WORD full = 0;
  WORD aways = 0;
  WORD user = 0;
  char channelstr[16];
  char *options;
  char *athost = NULL;
  CONNECTION *p;
  CHANNEL *ch;
  CLIST *cl;
  WORD showit;
  WORD opstat;
  WORD isop;
  WORD width, w;

  options = getarg(NULL, GET_NXTLC);
  if (   *options == '\0'
      || strchr("*aln@u", *options) == NULL) {
    list_command(cp);
    return;
  }
  appenddirect(cp, "User    Host   Via    Chan.  ");
  width = cp->width;
  if (width < 66)
    width = 80;
  switch (*options) {
    case '*':
      appenddirect(cp, " Idle Personal\r");
      thischan = cp->channel;
      break;
    case 'a':
      appenddirect(cp, "Login State\r");
      aways = 1;
      break;
    case 'u':
      user = 1;
      options++;
      if (!*options)
        options = getarg(NULL, GET_ALL);
    case 'l':
      appenddirect(cp, "Login Queue     RX      TX\r");
      full = 1;
      break;
    case '@':
      athost = ++options;
      if (!*athost)
        athost = getarg(NULL, GET_NXTCS);
    case 'n':
      appenddirect(cp, "Login Personal\r");
  }
  if (!user && athost == NULL) {            /* optional bei *,a,l,n */
    options = getarg(NULL, GET_NXTLC);      /* Kanalfilter setzen   */
    if (*options)
      thischan = atoi(options);
  }

  for (ch = channels; ch; ch = ch->next) {
    flags = ch->flags;
    for (p = connections; p; p = p->next) {
      if (p->type != CT_USER)
        continue;
      showit = 0;
      opstat = 0;
      isop = 0;
      if (p->channel == ch->chan) {
        opstat = p->channelop;
        showit = 1;
      }
      isop = cp->operator;
      for (cl = cp->chan_list; cl; cl = cl->next) {
        if (ch->chan == cl->channel) {
          isop |= cl->channelop;
          break;
        }
      }
      for (cl = p->chan_list; cl; cl = cl->next) {
        if (ch->chan == cl->channel) {
          opstat = cl->channelop;
          showit = 1;
          break;
        }
      }
      if (   ((flags & M_CHAN_I) && !(isop || ch->chan == cp->channel))
          || (thischan != -1 && thischan != ch->chan)
          || (athost && strncmp(athost, p->host, strlen(athost)))
          || (user && strstr(options, p->name) == NULL))
        showit = 0;

      if (showit) {
        if (!(flags & M_CHAN_S) || (isop) || (ch->chan == cp->channel)) {
          sprintf(channelstr, "%5d", ch->chan);
        } else {
          strcpy(channelstr, "-----");
        }
        sprintf(buffer, full ?
                "%-6.6s%c %-6.6s %-6.6s %5s %6s %5ld %7ld %7ld" :
                "%-6.6s%c %-6.6s %-6.6s %5s %6s",
                p->name, p->operator ? '!' : opstat ? '@' : ' ', p->host,
                p->via ? p->via->name : "", channelstr,
                (thischan != -1) ? ts3(currtime - p->mtime, tmp) : ts(p->time),
                queuelength(p), p->received, p->xmitted);
        w = width;
        if (p->pers || aways) {
          if (full) {
            strcat(buffer, "\r        Personal: ");
            strcat(buffer, p->pers?p->pers:"");
          } else {
            strcat(buffer, " ");
            if (aways) {
              if (p->away) {
                strncat(buffer, p->away, w - 51);
                strcat(buffer, " (since ");
                strcat(buffer, ts(p->atime));
                strcat(buffer, ")");
              } else {
                strcat(buffer, "(here)");
              }
            } else {
              if (p->away)
                w -= 7;
              if (p->pers)
                strncat(buffer, p->pers, w - 36);
            }
          }
        }
        if (!aways) {
          if (p->away) {
            if (full) {
              strcat(buffer, "\r        Away: ");
              strcat(buffer, p->away);
              strcat(buffer, " (since ");
              strcat(buffer, ts(p->atime));
              strcat(buffer, ")");
            } else {
              strcat(buffer, " (AWAY)");
            }
         } else {
            if (full) {
              if (p->mtime) {
                strcat(buffer, "\r        Last Activity: ");
                strcat(buffer, ts(p->mtime));
              }
            }
          }
        }
        strcat(buffer, "\r");
        appendstring(cp, buffer);
      }
    }
  }
  if (cp->type == CT_USER) {
    appendprompt(cp, 1);
  }
}

/*---------------------------------------------------------------------------*/

static void width_command(CONNECTION *cp)
{
  WORD neww;
  char buffer[128];

  neww = atoi(getarg(NULL, GET_NXTLC));

  if (neww == 0)
    sprintf(buffer, "*** Current screen width is %d\r", cp->width);
  else if (neww < 32 || neww > 255)
    sprintf(buffer, "*** Range 32 to 255\r");
  else {
    cp->width = neww;
    sprintf(buffer, "*** Screen width set to %d\r", cp->width);
  }
  appenddirect(cp, buffer);
  appendprompt(cp, 0);
}

/*---------------------------------------------------------------------------*/

static void wall_command(CONNECTION *cp)
{
  char       buffer[128];
  CONNECTION *p;
  char       *text;

  if (cp->operator != 2) {
    appenddirect(cp, "*** You are not an operator !\r");
    appendprompt(cp, 0);
    return;
  }

  text = getarg(NULL, GET_ALL);
  if (!*text)
    return;

  for (p = connections; p; p = p->next)
    if (   p->type == CT_USER
        && !p->via
        && p != cp) {
      sprintf(buffer, "*** Urgent message from operator (%s):\r    ", cp->name);
      appenddirect(p, buffer);
      appendstring(p, text);
      appenddirect(p, "\r");
      appendprompt(p, 0);
    }
}

/*---------------------------------------------------------------------------*/

#ifdef CVS_ZAPPING
static void zap_command(CONNECTION *cp)
{
  char buffer[256], *arg;

  arg = getarg(NULL, GET_ALL);
  if (cp->operator != 2 || !*arg)
    return;

  sprintf(buffer, "/\377\200%.245s\r", arg);
  for (cp = connections; cp; cp = cp->next)
    if (cp->type == CT_HOST) {
      appenddirect(cp, buffer);
      send_proto("cmds", "TX to %s %s", cp->name, buffer+3);
    }
}
#endif

/*---------------------------------------------------------------------------*/
/* Host-Kommandos                                                            */
/*---------------------------------------------------------------------------*/

static void h_away_command(CONNECTION *cp)
{
  char *fromname, *hostname, *text;
  time_t time;
  CONNECTION *p;
  int changed = 1;

  fromname = getarg(NULL, GET_NXTLC);
  hostname = getarg(NULL, GET_NXTCS);
  time = atol(getarg(NULL, GET_NXTLC));
  if (time <= MAXCHANNEL)                           /* altes AWAY erkennen */
    return;
  text = getarg(NULL, GET_ALL);
  cp->locked = 1;
  for (p = connections; p; p = p->next) {
    if (   p->type == CT_USER
        && !Strcmp(p->name, fromname)
        && !Strcmp(p->host, hostname)) {
      if (p->away && !strcmp(p->away, text)) {
        changed = 0;
        continue;
      }
      setstring(&(p->away), text, 256);
      p->atime = time;
    }
  }
  if (changed)
    send_awaymsg(fromname, hostname, time, text);
}

/*---------------------------------------------------------------------------*/

#pragma warn -par
static void h_cmsg_command(CONNECTION *cp)
{
  char *text;
  char *name;
  WORD channel;

  name = getarg(NULL, GET_NXTLC);
  if (strlen(name) > 64)  /* 1. Schutz vor Nicknames */
    name[64] = NUL;
  channel = atoi(getarg(NULL, GET_NXTLC));
  text = getarg(NULL, GET_ALL);
  if (*text)
    send_msg_to_channel(name, channel, text);
}
#pragma warn .par

/*---------------------------------------------------------------------------*/

static WORD is_looped(PERMLINK *l, char *host)
{
  DESTINATION *d;

  /* Schleifenerkennung 1:
     Nachbar will uns was ueber uns erzaehlen */
  if (!Strcmp(myhostname, host))
    return(1);

  /* Schleifenerkennung 2:
     host schon aus anderer Richtung bekannt */
  if (l) {
    for (d = destinations; d; d = d->next)
      if (!Strcmp(d->name, host))
        break;
    if (d && d->link != l && d->rtt)
      return(1);
  }

  return(0);
}

/*---------------------------------------------------------------------------*/

static void h_dest_command(CONNECTION *cp)
{
  char *name, *rev;
  LONG rtt;
  PERMLINK *l;

  name = getarg(NULL, GET_NXTCS);
  if (!*name)
    return;
  rtt = atol(getarg(NULL, GET_NXTLC));
  rev = getarg(NULL, GET_NXTLC);

  l = permlink_of(cp);

  if (is_looped(l, name)) {
    if (l)
      l->locked = 1;                               /*   verriegeln */
    bye_command2(cp, "loop detect");               /* und abwerfen */
    return;
  }

  if (l && rtt >= 0L)
    update_destinations(l, name, rtt, rev);
}

/*---------------------------------------------------------------------------*/

static void h_host_command(CONNECTION *cp)
{
  char        *name;
  char        *rev;
/*char        *features;*/
  char        buffer[1024];
  WORD        pl;
  char        *flags;
  CONNECTION  *c;
  PERMLINK    *p;
  DESTINATION *d;
  CHANNEL     *ch;
  CLIST       *cl;

  name = getarg(NULL, GET_NXTCS);
  if (!*name)
    return;
  rev = getarg(NULL, GET_NXTLC);
  if (!*rev)
    rev = "?";
/*features = getarg(NULL, GET_NXTCS);*/

  for (pl = 0; pl < MAXCVSHOST; pl++) {
    p = permarray[pl];
    if (p && !Strcmp(p->cname, cp->name)) {
      if (p->connection && (p->connection != cp))
        bye_command2(p->connection, "link reorg");
    }
  }
  for (c = connections; c; c = c->next)        /* sicher ist sicher */
    if (!Strcmp(c->name, cp->name) && c != cp && !c->via)
      bye_command2(c, "link reorg");

  cp->type = CT_HOST;
  strcpy(cp->host, "-");
  Strcpy(cp->rev, rev);
  p = update_permlinks(cp->name, cp, 0);
  Strcpy(p->name, name);
  if (cp->up->convflag == 1) { /* nur senden, wenn connect von aussen */
    sprintf(buffer, "/\377\200HOST %s %s %s\r", myhostname, myrev, myfeatures);
    appenddirect(cp, buffer);
    send_proto("cmds", "TX to %s %s", cp->name, buffer+3);
  }
  send_proto("cmds", "sending user, modes... to %s", cp->name);
  /* DEST's zuerst aussenden (fuer loop-detect) */
  for (d = destinations; d; d = d->next) {
    if (d->rtt) {
      sprintf(buffer, "/\377\200DEST %s %ld %s\r", d->name, (long)d->rtt + 99L, d->rev);
      appenddirect(cp, buffer);
    }
  }
  /* Aussenden eines DEST zum Bekanntmachen (fuer loop-detect) */
  update_destinations(p, name, 1, rev);
  for (c = connections; c; c = c->next) {
    if (c->type == CT_USER) {
      if (!c->via) {
        for (cl = c->chan_list; cl; cl = cl->next) {
          sprintf(buffer, "/\377\200USER %s %s %ld -1 %d %s\r", c->name, c->host, (long)cl->time, cl->channel, c->pers?c->pers:"");
          appenddirect(cp, buffer);
          if (cl->channelop) {
            sprintf(buffer, "/\377\200OPER conversd %d %s\r", cl->channel, c->name);
            appenddirect(cp, buffer);
          }
        }
        if (c->away) {
          sprintf(buffer, "/\377\200AWAY %s %s %ld %s\r", c->name, c->host, (long)c->atime, c->away);
          appenddirect(cp, buffer);
        }
        if (c->operator) {
          sprintf(buffer, "/\377\200OPER conversd -1 %s\r", c->name);
          appenddirect(cp, buffer);
        }
      } else {
        sprintf(buffer, "/\377\200USER %s %s %ld -1 %d %s\r", c->name, c->host, (long)c->time, c->channel, c->pers?c->pers:"");
        appenddirect(cp, buffer);
        if (c->away) {
          sprintf(buffer, "/\377\200AWAY %s %s %ld %s\r", c->name, c->host, (long)c->atime, c->away);
          appenddirect(cp, buffer);
        }
        if (c->channelop) {
          sprintf(buffer, "/\377\200OPER conversd %d %s\r", c->channel, c->name);
          appenddirect(cp, buffer);
        }
        if (c->operator) {
          sprintf(buffer, "/\377\200OPER conversd -1 %s\r", c->name);
          appenddirect(cp, buffer);
        }
      }
    }
  }
  for (ch = channels; ch; ch = ch->next) {
    if (ch->topic) {
      sprintf(buffer, "/\377\200TOPI conversd %s %ld %d %s\r", myhostname, (long)ch->time, ch->chan, ch->topic);
      appenddirect(cp, buffer);
    }
    /* Dies wuerde zu 2 unterschiedlichen Modes zwischen den Teilnetzen
       der sich verbindenden Hosts fuehren
    sprintf(buffer, "/\377\200MODE %d -sptiml+%s\r", ch->chan, flags);
       folglich senden wir nur die gesetzten Flags, wenn welche gesetzt sind
    */
    flags = strlwr(getflags(ch->flags));
    if (*flags) {
      sprintf(buffer, "/\377\200MODE %d +%s\r", ch->chan, flags);
      appenddirect(cp, buffer);
    }
  }
}

/*---------------------------------------------------------------------------*/

#pragma warn -par
static void h_invi_command(CONNECTION *cp)
{

  char *fromname, *toname;
  WORD channel;

  fromname = getarg(NULL, GET_NXTLC);
  toname = getarg(NULL, GET_NXTLC);
  channel = atoi(getarg(NULL, GET_NXTLC));
  send_invite_msg(fromname, toname, channel);
}
#pragma warn .par

/*---------------------------------------------------------------------------*/

static void h_link_command(CONNECTION *cp)
{
  char buffer[256];
  char *user, *host;

  user = getarg(NULL, GET_NXTLC);
  host = getarg(NULL, GET_NXTCS);
  if (!Strcmp (myhostname, host)) {
    if (!*user)
      return;
    clear_locks();
    sprintf(buffer, "*** Links at %s", myhostname);
    send_msg_to_user("conversd", user, buffer);
    disp_links(NULLCONNECTION, user);
  } else {                                  /* dies macht tpp nicht */
    sprintf(buffer, "/\377\200LINK %s %s", user, host);
    strcpy(cnvinbuf, buffer);
    h_unknown_command(cp);
  }
}

/*---------------------------------------------------------------------------*/

static void h_oper_command(CONNECTION *cp)
{
  char       *toname, *fromname;
  WORD       channel;
  CONNECTION *p;
  CLIST      *cl;

  fromname = getarg(NULL, GET_NXTLC);
  channel  = atoi(getarg(NULL, GET_NXTLC));
  toname   = getarg(NULL, GET_NXTLC);
  cp->locked = 1;

  for (p = connections; p; p = p->next) {
    if (Strcmp(p->name, toname))
      continue;

    if (channel == -1) {
      if (p->type == CT_USER) {
        p->operator = 1;
        send_opermsg(toname, p->host, fromname, channel);
      }
    } else {
      if (p->channel == channel) {
        p->channelop = 1;
      }
      for (cl = p->chan_list; cl; cl = cl->next) {
        if (cl->channel == channel) cl->channelop = 1;
      }
      send_opermsg(toname, p->host, cp->name, channel);
    }
  }
}

/*---------------------------------------------------------------------------*/

static void h_ping_command(CONNECTION *cp)
{
  PERMLINK *l;
  char buffer[128];

  l = permlink_of(cp);
  if (l) {
    sprintf(buffer, "/\377\200PONG %ld\r", (long)l->txtime);
    appenddirect(cp, buffer);
    send_proto("cmds", "TX to %s %s", cp->name, buffer+3);
  }
}

/*---------------------------------------------------------------------------*/

static void h_pong_command(CONNECTION *cp)
{
  PERMLINK *l;

  l = permlink_of(cp);
  if (l) {
    l->rxtime = atol(getarg(NULL, GET_NXTLC));
    l->txtime = max(currtime - l->testwaittime, 1L);
    if (l->rxtime == 0L) l->rxtime = l->txtime;
    if ((labs(l->rxtime) > 20001L) || (labs(l->txtime) > 20001L)) {
      l->rxtime = 0;
      l->txtime = 0;
    }
    l->testnexttime = l->testwaittime + max(min(60L * (l->txtime), 7200L), 120L);
    /* I hacked this because of it's nasty behave - rewrite of the whole stuff is in progress */
    update_destinations(l, l->name,
                        (l->rxtime == -1L) ? l->txtime : (l->rxtime + l->txtime) / 2L,
                        cp->rev);
  }
}

/*---------------------------------------------------------------------------*/

#pragma warn -par
static void h_rout_command(CONNECTION *cp)
{
  char *dest, *user;
  DESTINATION *d;
  char buffer[128];
  WORD ttl;

  dest = getarg(NULL, GET_NXTCS);
  user = getarg(NULL, GET_NXTLC);
  ttl = atoi(getarg(NULL, GET_NXTLC));
  clear_locks();
  for (d = destinations; d; d = d->next) {
    if (d->rtt && d->link && !Strcmp(d->name, dest)) {
      sprintf(buffer, "*** route: %s (%ld) %s -> %s", myhostname,
                      (long)((d->link->rxtime + d->link->txtime) / 2L),
                      d->link->cname, dest);
      send_msg_to_user("conversd", user, buffer);
      if (ttl && Strcmp(d->link->name, dest)) {
        ttl--;
        sprintf(buffer, "/\377\200ROUT %s %s %d\r", dest, user, ttl);
        appenddirect(d->link->connection, buffer);
        send_proto("cmds", "TX to %s %s", d->link->connection->name, buffer+3);
      }
    }
  }
}
#pragma warn .par

/*---------------------------------------------------------------------------*/

static void h_topi_command(CONNECTION *cp)
{
  char *fromname, *hostname, *text;
  WORD channel;
  time_t time;

  fromname = getarg(NULL, GET_NXTLC);
  hostname = getarg(NULL, GET_NXTCS);
  time = atol(getarg(NULL, GET_NXTLC));
  channel = atoi(getarg(NULL, GET_NXTLC));
  text = getarg(NULL, GET_ALL);
  cp->locked = 1;
  send_topic(fromname, hostname, time, channel, text);
}

/*---------------------------------------------------------------------------*/

static void h_udat_command(CONNECTION *cp)
{
  char *fromname, *hostname, *text;
  CONNECTION *p;

  fromname = getarg(NULL, GET_NXTLC);
  hostname = getarg(NULL, GET_NXTCS);
  text = getarg(NULL, GET_ALL);
  if (!strcmp(text, "@"))              /* wir verwenden keinen @ mehr */
    text = "";
  cp->locked = 1;
  for (p = connections; p; p = p->next) {
    if (p->type == CT_USER && !Strcmp(p->name, fromname) &&
        !Strcmp(p->host, hostname) && strcmp(p->pers?p->pers:"", text)) {
      setstring(&(p->pers), text, 256);
      send_persmsg(fromname, hostname, p->channel, text, currtime);
    }
  }
}

/*---------------------------------------------------------------------------*/

#pragma warn -par
static void h_umsg_command(CONNECTION *cp)
{
  char *fromname, *toname, *text;

  fromname = getarg(NULL, GET_NXTLC);
  if (strlen(fromname) > 64)  /* 1. Schutz vor Nicknames */
    fromname[64] = NUL;
  toname = getarg(NULL, GET_NXTLC);
  text = getarg(NULL, GET_ALL);
  if (*text) send_msg_to_user(fromname, toname, text);
}
#pragma warn .par

/*---------------------------------------------------------------------------*/

/* this command simply passes on any host requests that we don't understand,
   since our neighbors MIGHT understand them (von tpp uebernommen) */

static void h_unknown_command(CONNECTION *cp)
{
  CONNECTION *p;

  for (p = connections; p; p = p->next)
    if (p->type == CT_HOST && p != cp) {
       appenddirect(p, cnvinbuf);
       appenddirect(p, "\r");
       send_proto("cmds", "TX to %s %s", p->name, cnvinbuf+3);
    }
}

/*---------------------------------------------------------------------------*/

static BOOLEAN name_ok(char *call)
{
  char tmp[L2IDLEN], buffer[12], *bp;
  WORD n, bcnt;

  n = (WORD) strlen(call);
  if (n < 4 || n > 9)
    return(FALSE);
  strcpy(buffer, call);
  if ((bp = strchr(buffer, '-')) != NULL) /* auch Buchstaben-SSID kuerzen(-u) */
    *bp = '\0';
  bp = buffer;
  bcnt = (WORD) strlen(bp);
  return(getcal(&bcnt, &bp, TRUE, tmp) == YES);
}

static BOOLEAN host_ok(char *call)
{
  char *c;

  if ((WORD)strlen(call) < 4)
    return(FALSE);

  c = call;
  while (*c) {                         /* nur 0...9 A...Z a...z . - */
    if (!(isalnum(*c) || *c == '.' || *c == '-'))
      return(FALSE);
    c++;
  }

  c = call;
  while (*c)                            /* mindestens ein Buchstabe */
    if (isalpha(*c++))
      return(TRUE);

  return(FALSE);
}

/*---------------------------------------------------------------------------*/

static void h_user_command(CONNECTION *cp)
{
  char *host;
  char *name;
  char *pers;
  WORD newchannel;
  WORD oldchannel;
  CONNECTION *p;
  CHANNEL *ch;
  PERMLINK *l;
  WORD users_left;
  time_t time;

  name = getarg(NULL, GET_NXTLC);
  host = getarg(NULL, GET_NXTCS);

  if (   name_ok(name) != TRUE
      || host_ok(host) != TRUE)
    return;

  if (   (l = permlink_of(cp)) != NULL            /* Looperkennung */
      && is_looped(l, host)) {
    l->locked = 1;                                 /*   verriegeln */
    bye_command2(cp, "loop detect");               /* und abwerfen */
    return;
  }

  time = atol(getarg(NULL, GET_NXTLC));
  if (time == 0) time = currtime;
  oldchannel = atoi(getarg(NULL, GET_NXTLC));
  newchannel = atoi(getarg(NULL, GET_NXTLC));
  if (   oldchannel < -1
      || newchannel < -1
      || (oldchannel == -1 && newchannel == -1)) /* einige WAMPEn tun dies */
    return;
  pers = getarg(NULL, GET_ALL);

  for (p = connections; p; p = p->next) {
    if (p->type == CT_USER) {
      if ((p->via == cp) &&
          !Strcmp(p->name, name) &&
          !Strcmp(p->host, host) &&
          p->channel == oldchannel) break;
    }
  }
  if (!p) {
    p = (CONNECTION *) calloc(1, sizeof(CONNECTION));
    if (p) {
      p->type = CT_USER;
      Strcpy(p->name, name);
      Strcpy(p->host, host);
      p->via = cp;
      p->next = connections;
      connections = p;
    }
  }
  if (p) {
    p->time = time;
    p->mtime = currtime;
    if (*pers && strcmp(pers, "@"))
      setstring(&(p->pers), pers, 256);
    if ((p->channel = newchannel) < 0) {
      p->type = CT_CLOSED;
    }
  }
  users_left = count_user(oldchannel);
  if (!users_left) destroy_channel(oldchannel);
  for (ch = channels; ch; ch = ch->next) {
    if (ch->chan == newchannel) break;
  }
  if (p && !ch && (newchannel != -1)) {
    ch = ins_channel(newchannel);
  }
  send_user_change_msg(name, host, oldchannel, newchannel, pers, time);
}

/*---------------------------------------------------------------------------*/

#else

#pragma warn -par
void bye_command2(CONNECTION *cp, char *reason)
{
}

#pragma warn .par
#endif
/* End of $RCSfile$ */
