/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File include/all.h (maintained by: ???)                              */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2000 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* Aktivierung einzelner Elemente in TNN                                */
/************************************************************************/

#define IPROUTE                       /* DB7KG-IP-Router                */
#define PACSAT                        /* PACSAT-Server                  */
#define GRAPH                         /* Graphische Statistiken         */
#define PORTGRAPH                     /* Port spezifische Statistiken   */
#define USER_PASSWORD                 /* Userpassword Option von SQ2FRB */
#define FLEXHOST                      /* FlexNet durchmelden zu NET/ROM */

/*#define L2PROFILER*/                /* Spielzeug fuer DB7KG           */
/*#define EXPERT*/                    /* EXPERTEN-Modus, mehr Paras     */

/*#define DAMASLAVE*/                 /* DAMA-Slave-Modus               */
                                      /* noch unvollstaendig!           */
#define BUFFER_DEBUG                  /* Bufferanalyse fuer Fehlersuche */
#define _CVS_ZAPPING                  /* Diagnosetool fuer Convers      */
/*#define PROFILING*/                 /* Programm-Profiling-Tool        */
/*#define MAXFRAMEDEBUG*/             /* zusaetzliche Anzeige bei Trace */

/* PORTGRAPH braucht GRAPH */
#ifdef PORTGRAPH
#define GRAPH
#endif

/************************************************************************/
/* Deaktivierung einzelner Elemente wenn fuer Zielsystem unmoeglich     */
/* (Diese Definitionen duerfen nicht editiert werden.                   */
/************************************************************************/

#if defined(MC68K)
#undef  PACSAT
#endif

/* Unser ganz privater Assert ******************************************/
#ifdef MC68302
  #define HALT(x) {dbg(x); reboot_system();}
#else
  #define HALT(x) {xprintf("Halted by " x); reboot_system();}
#endif

/* Unser ganz privater Debugger ****************************************/
#define dbg(x)
#if defined(ST) || defined(__LINUX__)
#undef dbg
#define dbg(x) wowarich=x
#endif
#ifdef MC68302
#undef dbg
#define dbg(x) *(char **)0x11CL=x
#endif

/************************************************************************/
/* Definition von Konstanten die in gesammten TNN genutzt werden.       */
/************************************************************************/

#define LOOP        for( ; ; )          /* Endlosschleife               */

#if defined (__GO32__) || defined(__LINUX__)
#define LINKNMBR    400
#else
#define LINKNMBR    250                 /* maximale Anzahl Links        */
#endif
#define NUMCIR      200                 /* maximale Anzahl Circuits     */
#define MAXHST      30+1                /* maximale Anzahl Hostkanaele  */
#define NUMPAT      (LINKNMBR+NUMCIR+MAXHST)
                                        /* Eintraege Patchcordliste     */

#define DEFL2L      1
#define TAILTIME    3                   /* Tailtime fuer die KISS-TNCs  */

#define L2PNUM      16                  /* Anzahl L2-Ports              */
#if (L2PNUM != 8) && (L2PNUM != 10) && (L2PNUM != 16)
#error "L2PNUM muss 8, 10 oder 16 sein!"
#endif

#define DAMA_CH     L2PNUM      /* Anzahl der Dama-Kanaele              */

#ifdef MC68302
# define MAXCOMS 3              /* Anzahl der seriellen Ports           */
#else
# define MAXCOMS 4
#endif
#define MAXKISS MAXCOMS         /* Anzahl der KISSLINKS                 */

#define MAXSUSPEND  50          /* Maximalanzahl Sperrungen             */
#define MAXCVSHOST  10          /* Maximaleintraege ConversHosts        */
#define MAXSTAT     16          /* Anzahl der Statistik-Eintraege       */
#define MAXNMBSTN   16          /* Quantisierung Stationen/Port         */

#define MINBUFF     256

#define NUL         ((char) 0x00)       /* ASCII-Zeichen                */
#define BELL        0x07
#define BS          0x08
#define TAB         0x09
#define LF          0x0A
#define CR          0x0D
#define XON         0x11
#define XOFF        0x13
#define ESC         0x1B
#define DEL         0x7F

#define MONI        0x01                /* Monitor: I-Frames            */
#define MONU        0x02                /*          UI-Frames           */
#define MONS        0x04                /*          S-Frames            */
#define MONC        0x08                /* Anzeige, auch wenn connected */
#define MONF        0x10                /* Anzeige des Info-Feldes      */
#define MONT        0x20                /* Sende-/Empfangszeit          */
#define MONL        0x40                /* Info-Laengen-Anzeige         */

#define SECONDS_PER_DAY   86400L   /* the number of seconds in one day  */
#define SECONDS_PER_HOUR   3600L   /*  "    "    "    "      "  "  hour */
#define SECONDS_PER_MIN      60L   /*  "    "    "    "      "  "  min. */

#ifdef CRASHDEBUG
#define TRACE(x) wowarich2 = "x"
#else
#define TRACE(x)
#endif

/************************************************************************/
/*                Einiges fuer TNC3                                     */
/************************************************************************/
#ifdef MC68302
#define __BOOLEAN
#include <apbind.h>

#undef stdout             /* stdout Simulation */
extern FILE *stdout;

#define MAXPATH   20

#define xchdir(a);

#endif

/************************************************************************/
/* hier noch einige Sachen fuer PP-conversd                             */
/************************************************************************/

#define MAXCHANNEL      32767          /* hoechster conversd Kanal      */

#if defined(__TURBOC__) || defined(__STDC__)
#define __ARGS(x)       x
#ifndef __DOTS
#define __DOTS          ,...
#endif
#else
#define __ARGS(x)       ()
#define const
#ifndef __DOTS
#define __DOTS
#endif
#endif

#if !defined (min)
#define min(a,b) ((a) >= (b) ? (b) : (a))
#define max(a,b) ((a) >= (b) ? (a) : (b))
#endif

/*#define uchar(x) ((x) & 0xff) wers braucht, solls anmachen, DL1XAO*/
#define uchar(x) (x)

#define REV "$Revision: 3.12c $"

#define INIT 0   /* Befehle fuer personalmanager und convers_config */
#define SAVE 1
#define SET  2
#define GET  3

/************************************************************************/
/* Dateitrennungszeichen usw fuer das Filesystem festlegen              */
/************************************************************************/
#define SEPARATORS "\\/"            /* die DOS- und die Unix-Konvention */

                                    /* File-Flags                       */
#define FF_LWR 1                    /* Dateinamen sind immer klein      */
#define FF_TXT 2                    /* Unterscheidung TEXT/BIN bei open */

#ifdef __LINUX__
#define FILE_SEP '/'                /* Linux und falcOS haben /         */
#define FILE_FLAGS FF_LWR
#define NO_DISKDRIVE                /* keine Laufwerksbuchstaben        */
/* die folgenden Pfade koennen auch ueber einen Compilerswitch im       */
/* makefile definiert werden                                            */
#ifndef TEXTPATH
#define TEXTPATH "/usr/local/tnn/"
#endif
#ifndef TEXTCMDPATH
#define TEXTCMDPATH TEXTPATH "textcmd/"
#endif
#ifndef USEREXEPATH
#define USEREXEPATH TEXTPATH "userexe/"
#endif
#ifndef SYSEXEPATH
#define SYSEXEPATH TEXTPATH "sysexe/"
#endif
#ifndef MSGPATH
#define MSGPATH TEXTPATH "msg/"
#endif
#ifdef PACSAT
#ifndef PACSATPATH
#define PACSATPATH TEXTPATH "pacsat/"
#endif
#endif
#define STRIPCHR CR
#define ENDCHR LF
#define PORTABLE
#else /* nicht __LINUX__ */
#define FILE_SEP '\\'               /* DOS und ST haben das alte \      */
#define STRIPCHR LF
#define ENDCHR CR
#ifndef MC68302
#define FILE_FLAGS FF_TXT
#ifndef TEXTPATH
#define TEXTPATH "\\TNN\\"
#endif
#ifndef TEXTCMDPATH
#define TEXTCMDPATH TEXTPATH "TEXTCMD\\"
#endif
#ifndef USEREXEPATH
#define USEREXEPATH TEXTPATH "USEREXE\\"
#endif
#ifndef SYSEXEPATH
#define SYSEXEPATH TEXTPATH "SYSEXE\\"
#endif
#ifdef PACSAT
#ifndef PACSATPATH
#define PACSATPATH TEXTPATH "PACSAT\\"
#endif
#endif
#ifndef MSGPATH
#define MSGPATH TEXTPATH "MSG\\"
#endif
#else /* MC68302 */
#define FILE_FLAGS FF_LWR
#define TEXTPATH "r:\\"
#define TEXTCMDPATH TEXTPATH
#define USEREXEPATH TEXTPATH
#define SYSEXEPATH TEXTPATH
#define MSGPATH TEXTPATH
#endif
#endif

#define GRAPH_LINES        15
#define GRAPH_INTERVAL     10 /* Alle 10 s einen neuen Wert speichern   */
#define GRAPH_STD_ELEMENTS 60 /* 60 Elemente je Stunde                  */
#define GRAPH_DAY_ELEMENTS 48 /* 24 * 2 halbe Stunden je Tag            */
#define GRAPH_WEK_ELEMENTS 56 /* 8 * 7 Tagesabschnitte je Woche         */

#ifdef BUFFER_DEBUG
#define ALLOC_LEHEAD       1
#define ALLOC_MBHEAD       2
#define ALLOC_USRBLK1      3
#define ALLOC_USRBLK2      4
#define ALLOC_L2LINK       5
#define ALLOC_MB           6
#define ALLOC_MONBUF       7
#define ALLOC_CQBUF        8
#define ALLOC_IP_ROUTE     9
#define ALLOC_ARP_TAB     10
#define ALLOC_MHEARD      11
#define ALLOC_PACSATBLK   12
#define ALLOC_INPOPT      13
#define ALLOC_NO_OWNER    14
#define ALLOC_MAXELEMENTE 15
#else
#define ALLOC_LEHEAD
#define ALLOC_MBHEAD
#define ALLOC_USRBLK1
#define ALLOC_USRBLK2
#define ALLOC_L2LINK
#define ALLOC_MB
#define ALLOC_MONBUF
#define ALLOC_CQBUF
#define ALLOC_IP_ROUTE
#define ALLOC_ARP_TAB
#define ALLOC_MHEARD
#define ALLOC_PACSATBLK
#define ALLOC_INPOPT
#define ALLOC_NO_OWNER
#define ALLOC_MAXELEMENTE
#endif

/* End of include/all.h */
