/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/version.c (maintained by: ???)                              */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2000 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/*----------------------------------------------------------------------*/
/* Meldetext und Version, Datum und Zeit automatisch eingebunden        */
/*----------------------------------------------------------------------*/

/* Die naechsten beiden Zeilen werden bei einem Hauptrelease geaendert  */
#define __NAME__     "TheNetNode"
#define __VER__      "1.77"

#define DEBUG

#define __AUTHOR__   "nk"       /* Monogramm des Autors/Programmierers  */
#define __PATCH__    "05"       /* Patch-Level des Autors               */

/* Zuerst legen wir die variierenden Texte mal fest                     */
#ifdef __LINUX__
#  define __SYSTEM__                   " (Linux)"
#else
#  ifdef __GO32__
#    define __SYSTEM__                 " (GO32)"
#  else
#    ifdef ST
#      define __SYSTEM__               " (ST)"
#    else
#      ifdef MC68302
#        define __SYSTEM__         " (TNC3)"
#      else
#        define __SYSTEM__       " (unknown)"
#      endif
#    endif
#  endif
#endif

/* Aufbau der Versionskennung, diesmal was uebersichtlicher **************/

char signon[]  = __NAME__ __SYSTEM__
                      ", " __VER__ __AUTHOR__ __PATCH__ " (";

char version[] = __NAME__ __SYSTEM__
                      ", " "Version " __VER__ __AUTHOR__ __PATCH__
#ifdef DEBUG
                      " ("__DATE__")\r"
                      ";       BETA-TEST SOFTWARE, USE ONLY FOR DEBUG PURPOSES.\r";
#else
                      " ("__DATE__")\r";
#endif

char cfgfile[] = "TNN177";

char loginstr[] = "TNN V" __VER__ __SYSTEM__ "\r";

char infostr[] = "TNN177";

/* End of src/version.c */
