/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File os/dos16/mem386.c (maintained by: ???)                          */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

#ifndef __DPMI32__
/* modulinterne globale Variablen */

WORD   umb_buffers = 0;

/* Um beim Start einer Sub-Shell die UMB-Bereiche freigeben zu koennen    */
/* merken wir uns die Segmentadressen der UMB-Bloecke beim Belegen.       */

#define MAXUMB 20                /* Maximal 20 UMB Bloecke merken wir uns */
WORD   umb[MAXUMB];
WORD   umbcnt = 0;

/*------------------------------------------------------------------------
 * Die Speicherbelegungs-Strategie von DOS aendern. Moegliche Werte sind:
 *
 * 00h low memory first fit
 * 01h low memory best fit
 * 02h low memory last fit
 * Ab DOS 5:
 * 40h high memory first fit
 * 41h high memory best fit
 * 42h high memory last fit
 * 80h first fit, try high then low memory
 * 81h best fit, try high then low memory
 * 82h last fit, try high then low memory
 *
 * Fuer die UMB-Verwaltung wird die Strategie auf 40h (first fit) gestellt
 * und alle verfuegbaren Speicherbereiche im UMB-Bereich alloziert.
 */
UBYTE set_allocstrategy(UBYTE new) {

  UBYTE   old;
  union  REGS r;

  /* Zuerst die derzeitige Strategie abfragen */
  r.h.ah = 0x58; /* GET OR SET MEMORY ALLOCATION STRATEGY  */
  r.h.al = 0x00; /* SUBFUNCTION 0: GET ALLOCATION STRATEGY */
  intdos(&r, &r);
  old = r.h.al;
  if (r.x.cflag) printf("Error: 58-00 (%u)!\n",r.x.ax);

  /* und erst dann neu setzen */
  r.h.ah = 0x58; /* GET OR SET MEMORY ALLOCATION STRATEGY  */
  r.h.al = 0x01; /* SUBFUNCTION 1: SET ALLOCATION STRATEGY */
  r.h.bl = new;
  r.h.bh = 0;
  intdos(&r, &r);
  if (r.x.cflag) printf("Error: 58-01 (%u)!\n",r.x.ax);

  return(old);
}

/*------------------------------------------------------------------------
 * Damit DOS ueberhaupt UMB's in die Speicherverwaltung miteinbezieht
 * muessen diese in diese einbezogen werden. Diese Funktion aktiviert
 * oder deaktiviert die UMB's fuer die DOS-Speicherverwaltung.
 */
UBYTE set_umblinkstate(UBYTE new) {

  UBYTE   old;
  union  REGS r;

  /* Zuerst den derzeitigen Zustand abfragen */
  r.h.ah = 0x58; /* GET OR SET UMB LINK STATE */
  r.h.al = 0x02; /* SUBFUNCTION 2: GET UMB LINK STATE */
  intdos(&r, &r);
  old = r.h.al;
  if (r.x.cflag) printf("Error: 58-02 (%u)!\n",r.x.ax);

  /* und dann den neuen Zustand setzen */
  r.h.ah = 0x58; /* GET OR SET UMB LINK STATE */
  r.h.al = 0x03; /* SUBFUNCTION 3: SET UMB LINK STATE */
  r.h.bl = new;
  r.h.bh = 0;
  intdos(&r, &r);
  if (r.x.cflag) printf("Error: 58-03 (%u)!\n",r.x.ax);

  return(old);
}

/*-------------------------------------------------------------------------
 * angegebenen Speicherbereich fuer TNN-Buffers benutzen.
 */
void use_mem(char huge *start, UWORD para) {
  MAX_BUFFER huge *actbp;
  char       huge *minm;
  char       huge *maxm;
  ULONG      n;
  ULONG      len;

  /* Hinten 16 Bytes Schutzabstand lassen da eventuell gleich dahinter */
  /* Geraetetreiber folgen (die auch im UMB sind)                       */

  len = ((ULONG) para - 1) * 16UL;

  actbp = (MAX_BUFFER *) (minm = start);
  maxm = minm + len - 1;

  actbp = (MAX_BUFFER *)minm;
  n = (ULONG)((maxm - minm) / sizeof(MAX_BUFFER));
  while (n--)
    dealoc ((MBHEAD *) actbp++);
  umb_buffers += n;
}

/*-------------------------------------------------------------------------
 * Die UMB-initialisierung gesieht durch diese Routine. Zuerst wird auf
 * die DOS-Version geprueft (UMB erst ab 5.0) und ob ueberhaupt UMB-
 * Benutzung gewuenscht wird. Die Umgebungsvariable TNNBUFFERS muss
 * auf TNNBUFFERS=lowbuffers,UMB gesetzt sein damit auch UMB verwendet
 * wird.
 */
void alloc_umb(void) {

  char   s[255];
  WORD   size;
  unsigned int segm;          /* Groesse und Startsegment eines UMB-Blocks */
  UBYTE  old_strategy;        /* alte Speicher-Belegungs-Strategie         */
  UBYTE  old_umblinkstate;    /* alte UMB-Linkstate                        */

  if (_osmajor > 4) {                     /* UMB gibts erst ab DOS 5.0     */
    if (getenv("TNNBUFFERS") != NULL) {   /* TNNBUFFERS muss gesetzt sein  */
      strcpy(s, getenv("TNNBUFFERS"));
      if (strstr(strupr(s), ",UMB")) {    /* ,UMB muss angegeben sein      */
                                                        /* ok, wir duerfen UMBs nehmen   */
        /* Oberen Speicherbloecke fuer die DOS-Speicherverwaltung zu-      */
        /* gaenglich machen.                                               */
        old_umblinkstate = set_umblinkstate(1);
        /* und DOS anweisen NUR diese zu verwenden.                        */
        old_strategy = set_allocstrategy(0x42);

        /* Viel zu grossen Speicherblock anfordern, DOS verweigert das     */
        /* setzt aber in size die Groesse des groessten Speicherblocks im  */
        /* Hauptspeicher. Dies ist nicht (unbedingt) der groesste Block    */
        /* im UMB (dort sind sie vieleicht kleiner).                       */


        /* Wir nehmen nun size aus Ausgangspunkt und fragen nach dem       */
          /* groesten verfgbaren Block und allocieren den dann.             */
        for (umbcnt = 0, size = 32767;
             ((umbcnt < MAXUMB) && (size > 20));
             umbcnt++
            )
        {
          size = allocmem(0xffff, &segm);
          if (size > 20)
          {
            allocmem(size, &segm);       /* Einen Block mit Size anfordern */
            /* Dann merken wir uns den Block um ihn ggfs. freigeben        */
            /* zu koennen                                                  */
            umb[umbcnt] = segm;
            /* Dann beziehen wir den Speicherblock in unsere Speicher-     */
                /* verwaltung mit ein.                                         */
            use_mem((char huge *) MK_FP(segm, 0), size);
          }
        }

        /* Alten Speichermanagerstatus wiederherstellen                    */
        set_umblinkstate(old_umblinkstate);
        set_allocstrategy(old_strategy);
      } /* use UMBs? */
    } /* TNNBUFFERS? */
  } /* DOS_VER >4    */
}

/*-------------------------------------------------------------------------
 * Die explizite Freigabe der UMB ist nur bei ccpstart() notwendig. Nach
 * Beendigung des Programmes gibt DOS automatisch alle Speicherbloecke frei.
 * Bei ccpstart() bleibt allerdings ein Teil des Codes im Speicher und
 * somit waeren die UMB-Bereich fuer das Nachfolgeprogramm blockiert.
 */
void done_umb(void) {

  char  old_umblinkstate;     /* alte UMB-Linkstate                        */


  /* UMB-Bloecke in die DOS-Speicherverwaltung miteinbeziehen              */
  /* (Was DOS nicht kennt kann es auch nicht freigeben.                    */
  old_umblinkstate = set_umblinkstate(1);
  /* Nun geben wir nacheinander alle Speicherbloecke frei.                 */
  while (umbcnt-- > 0) {
    freemem(umb[umbcnt]);
  }
  /* zum Schluss muessen wir noch den alten Status wiederherstellen.       */
  set_umblinkstate(old_umblinkstate);
}
#endif

/* End of MEM386.C */
