/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l7conn.c (maintained by: DF6LN)                             */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

static char usrvia[2*L2VLEN+L2IDLEN+1];

static BOOLEAN  isheard(char *, DEST *);
static BOOLEAN  is_cq(const char *, DEST *);
static WORD     conprm2(DEST *, DEST *);
static WORD     conprm(WORD  *, char **, DEST *);
static void     conerr(int, DEST *);
static void     setupmsg(DEST *);
static void     setptc(void *, UBYTE);
static void     conhst(void);
static void     conl4(DEST *);
static void     conl2(DEST *);
static void     con_cq(DEST *);
static void     conusr(int, DEST *);

#define CP_L2CON   2
#define CP_L4CON   4
#define CP_HOSTCON 7
#define CP_CQ      42

#define CP_PARERR  10
#define CP_NODIG   11
#define CP_BADQUAL 12
#define CP_INTERN  13
#define CP_UNKNOWN 14

/************************************************************************/
/* Schaun, ob wir ein Call in der MH-Liste haben und dest fuellen.      */
/*----------------------------------------------------------------------*/
static BOOLEAN
isheard(char *id, DEST *dest)
{
  MHEARD *mhp;
  BOOLEAN found = FALSE;

  for (mhp = (MHEARD *)l2heard.heardl.head;
       mhp != (MHEARD *)&l2heard.heardl;
       mhp  = mhp->next)
    if (cmpcal(id, mhp->id))                    /* Call in MH-Liste     */
     {
      dest->port = mhp->port;                   /* Port aus MH          */
      dest->typ = 'U';
      *dest->via = 0;
      found = TRUE;
      if (cmpid(id, mhp->id))         /* wenn SSID auch passt, fertig!  */
        return(MHEARD_AVAILABLE);
     }
  return(found ? MHEARD_AVAILABLE : MHEARD_UNKNOWN);
}

/************************************************************************/
/*                                                                      */
/* Feststellen, ob das gewuenschte Call ein CQ-Rufer ist.               */
/*                                                                      */
/************************************************************************/
static BOOLEAN
is_cq(const char *id, DEST *dest)
{
  CQBUF *cqp;

  for (cqp = (CQBUF *)cq_user.head;             /* CQ-Liste durchsuchen */
       cqp != (CQBUF *)&cq_user;
       cqp = cqp->next)
   {
    if (cmpid(id, cqp->id))                     /* Call stimmt?         */
     {
      dest->uid = cqp->uid;                     /* UID eintragen        */
      cpyid(dest->call, id);                    /* Call auch            */
      dealoc((MBHEAD *)ulink((LEHEAD *)cqp));   /* CQ-Eintrag loeschen  */
      return(TRUE);
     }
   }
  return(FALSE);
}

/*
 * Connectwunsch bewerten und analysieren.
 */
static WORD
conprm2(DEST *user, DEST *dest)
{
  int l3route;

#if 0
  dest->call[0] = '\0';
  dest->via[0] = '\0';
  dest->port = NOPORT;
  dest->typ = 'U';
  dest->nbrcal[0] = '\0';
  dest->np = NULL;
  dest->uid = NO_UID;
#endif

  if (user->call[0] == 0)
    return(CP_PARERR);              /* Parameter-Fehler                 */

  if (cmpid(user->call, hostid))
    return(CP_HOSTCON);

  switch (l3route = l3_find_route(user->call, dest))
   {
    case NODE_DOWN:
/* Als erstes wird geprueft, ob das Ziel eventuell unerreichbar ist.    */
/* Dann brauchen wir gar nicht fortzufahren.                            */
      if (user->port == NOPORT)
       {
        cpyid(dest->call, user->call);
        return(CP_BADQUAL);
       }
/* Wenn der Node ausgefallen ist, duerfen auch User einen Umweg         */
/* probieren.                                                           */
      dest->typ = 'U';
      break;
    case NODE_UNKNOWN:
/* Kennen wir das Ziel nicht direkt, schauen wir ins Addressfeld,       */
/* vielleicht kennen wir ja den ersten via-Digi. Ist dieser down, dann  */
/* ist das Ziel nicht erreichbar. Ist es ein NET/ROM, koennen wir so    */
/* nicht routen. Vielleicht ist es aber auch ein CQ-Rufer? Als letztes  */
/* hilft nur der Blick in die MH-Liste.                                 */
      switch (l3route = l3_find_route(user->via, dest))
       {
        case NODE_DOWN:
          cpyid(dest->call, user->call);
          return(CP_BADQUAL);
        case NODE_AVAILABLE:
          if (dest->typ <= NETROM)
            return(CP_NODIG);
          addid(dest->via, user->via);
          user->via[0] = 0;
          break;
        case NODE_UNKNOWN:
          if (is_cq(user->call, dest))
            return(CP_CQ);
          if (isheard(user->call, dest) == MHEARD_UNKNOWN)
           {
            cpyid(dest->call, user->call);
            if (user->port != NOPORT)
             {
              dest->port = user->port;
              dest->via[0] = 0;
              dest->typ = 'U';
              return(CP_L2CON);
             }
            return(CP_UNKNOWN);
           }
       }
   }
/* Der User darf den Connect beeinflussen, der Typ wird von NET/ROM auf */
/* L2 Connect aber nur beim Sysop geaendert.                            */
  if (issyso() || (dest->typ > NETROM))
   {
    if (user->port != NOPORT)
     {
      dest->port = user->port;
      dest->via[0] = '\0';
      dest->typ = 'U';
     }
    if (user->via[0])
     {
      cpyidl(dest->via, user->via);
      dest->typ = 'U';
     }
   }
  cpyid(dest->call, user->call);
  if ((l3route == NODE_DOWN) && (user->port != NOPORT))
    return(CP_L2CON);
  return(dest->typ <= NETROM ? CP_L4CON : CP_L2CON);
}

/************************************************************************/
/*                                                                      */
/* Parameter fuer den Connect-Befehl auswerten und in dest speichern.   */
/* conprm() erhaelt eine Kopie von clipoi/clicnt und arbeitet damit.    */
/*                                                                      */
/************************************************************************/
static WORD
conprm(WORD  *n,                /* Restlaenge der Parameterzeile        */
       char **p,                /* Parameter des Connectbefehls         */
       DEST  *dest)
{
  int     index;
  char    ident[L2CALEN];
  DEST    user;

  user.typ     = 'U';
  user.call[0] = 0;
  user.port    = NOPORT;            /* Port setzen                      */
  user.via[0]  = 0;

  if (!*n) return(CP_HOSTCON);

  if (getcal(n, p, VCpar, user.call) != YES)
    if (getide(n, p, ident) != ERRORS)
      if ((index = find_alias(ident)) != -1)
        cpyid(user.call, netp->nodetab[index].id);
  getport(n, p, &user.port);
  getdig(n, p, VCpar, user.via);
  getport(n, p, &user.port);

#ifdef PACSAT
  if (cmpid(user.call, pacsatid))
   {
    ccpbox();
    return(CP_INTERN);
   }
  else
#endif
    return(conprm2(&user, dest));
}

#define CE_HTFULL  0
#define CE_CTFULL  1
#define CE_LTFULL  2
#define CE_BADQUAL 3
#define CE_SUSPEND 4
#define CE_BUSY    5
#define CE_PORTOFF 6
#define CE_INVCAL  7
#define CE_UNKNOWN 8

/************************************************************************/
/*                                                                      */
/* (xxx table full) Fehler ausgeben und Fernconnects ablehnen.          */
/*                                                                      */
/************************************************************************/
static void
conerr(int error, DEST *dest)
{
  static const char *fullerr[] = {"Host", "Circuit", "Link"};
  static const char *failerr[] = {" (not available)\r",
                                  " (you are restricted)\r"};
  static const char *busyerr[] = {" (already connected)\r"};
  MBHEAD            *mbp;
  int                port;
  char               dstcal[10];

  if (ptctab[userpo->uid].local == PTC_LOCAL)
   {
    switch (error)
     {
      case CE_HTFULL :
      case CE_CTFULL :
      case CE_LTFULL :
      case CE_SUSPEND:
      case CE_BUSY   :
      case CE_INVCAL :
      case CE_UNKNOWN:
        if (g_utyp(userpo->uid) == L2_USER)
          rejlnk(g_ulink(userpo->uid));         /* durchfallen */
      default        :
        disusr(userpo->uid);
     }
   }
  else
   {
    switch (error)
     {
      case CE_HTFULL :
      case CE_CTFULL :
      case CE_LTFULL :
        puttfu(fullerr[error]);
        return;
      case CE_BADQUAL :
      case CE_SUSPEND :
        mbp = putals("Failure with ");
        putid(dest->call, mbp);
        putstr(failerr[error-CE_BADQUAL], mbp);
        break;
      case CE_BUSY :
        mbp = putals("Busy from ");
        putid(dest->call, mbp);
        putstr(busyerr[error-CE_BUSY], mbp);
        break;
      case CE_PORTOFF :
        mbp = putals("Port not in use\r");
        break;
      case CE_INVCAL :
        mbp = putals("Invalid call\r");
        break;
      case CE_UNKNOWN:
        call2str(dstcal, dest->call);
        mbp = getmbp();
        putprintf(mbp, "\rNode / User %s unknown! Please specify port, "
                       "if %s is a User:\r", dstcal, dstcal);
        for (port = 0; port < L2PNUM; port++)
         {
          if (portenabled(port) && updmheard(port))
            putprintf(mbp, "CONNECT %s %s\r", dstcal, portpar[port].name);
         }
        break;
     }
    prompt(mbp);
    seteom(mbp);
   }
}

/************************************************************************/
/*                                                                      */
/* Nachricht ueber den Linkaufbau ausgeben.                             */
/*                                                                      */
/************************************************************************/
static void
setupmsg(DEST *dest)
{
  MBHEAD *mbp;

  if (ptctab[userpo->uid].local == PTC_NORMAL)
   {
    switch (dest->typ)
     {
      case NETROM:
      case TNN   :
      case INP   :
      case THENET:
        mbp = putals("Interlink setup (");
        putstr(portpar[dest->port].name, mbp);
        break;
      case FLEXNET :
        mbp = putals("Interlink setup (via ");
        putid(dest->nbrcal, mbp);
        break;
      case LOCAL_M :
        mbp = putals("Link setup (");
        putstr(portpar[dest->port].name, mbp);
        break;
      default :
        mbp = putals("Downlink setup (");
        putstr(portpar[dest->port].name, mbp);
        putstr(") ...\r", mbp);
        /*
         * Bei einem Downlink soll keine LOOP-Warnung angezeigt werden.
         */
        seteom(mbp);
        return;
     }
    putstr(") ...\r", mbp);
    if (userport(userpo) == dest->port)
      putstr("WARNING: Loop detected (HELP LOOP)\r", mbp);
    seteom(mbp);
   }
}

/************************************************************************/
/*                                                                      */
/* Connect-Partner in der Patchcord-Liste eintragen.                    */
/*                                                                      */
/************************************************************************/
static void
setptc(void *link, UBYTE typ)
{
  PTCENT *ptcp;
  PTCENT *p_ptcp;
  UID     uid = userpo->uid;

  ptcp = ptctab + uid;
  ptcp->p_uid = g_uid(link, typ);
  p_ptcp = ptctab + ptcp->p_uid;
  p_ptcp->p_uid = uid;
}

/************************************************************************/
/*                                                                      */
/* Connect an die Host-Console herstellen.                              */
/*                                                                      */
/************************************************************************/
static void
conhst(void)
{
  int     i;

  for (i = 1, hstusr = hstubl + 1; i < MAXHST; ++i, ++hstusr)
    if ((!hstusr->conflg) && (cmpid(hstusr->call, hostid)))
      break;

  if (i != MAXHST)
   {
    cpyid(hstusr->call, usrcal);
    if (hstreq())
     {
      setptc(hstusr, HOST_USER);
      userpo->status = US_CREQ;
      return;
     }
   }

  conerr(CE_HTFULL, NULL);
}

/*
 * Level 4 Connect (Circuit) herstellen.
 */
static void
conl4(DEST *dest)
{
  CIRBLK *cirp;
  LNKBLK *frelnk;
  int     i;

  for (i = 0, cirpoi = cirtab; i < NUMCIR; ++i, ++cirpoi)
    if (cirpoi->state == L4SDSCED)
      break;

  if (i != NUMCIR)
   {
    cpyid(cirpoi->downca, dest->np->id);
    cpyid(cirpoi->upcall, usrcal);
    switch (g_utyp(userpo->uid))
     {
      case L4_USER:  /* User ist Circuit    */
        cirp = (CIRBLK *) g_ulink(userpo->uid);
        cpyid(cirpoi->upnod, cirp->upnod);
        /* Uplinkknoten setzen */
        cpyidl(cirpoi->upnodv, cirp->upnodv);
        /* Digikette auch      */
        break;

      case L2_USER:  /* User ist L2-Link    */
        frelnk = (LNKBLK *) g_ulink(userpo->uid);
        cpyid(cirpoi->upnod, myid);
        /* Uplink hier         */
        cpyidl(cirpoi->upnodv, frelnk->viaidl);
        /* und Digikette       */
        break;

      default:    /* User vom Host       */
        cpyid(cirpoi->upnod, hostid);
        /* Uplink hier         */
        *cirpoi->upnodv = '\0';
        /* kein Digi           */
        break;
     }
    cirpoi->l3node = dest->np;
    userpo->status = US_CREQ;
    setptc(cirpoi, L4_USER);
    setupmsg(dest);                 /* "Interlink setup ..."            */
    newcir();
   }
  else                              /* Circuit aufbauen                 */
    conerr(CE_CTFULL, dest);        /* Circuit Table full               */
}

/*
 * Level 2 Connect herstellen.
 */
static void
conl2(DEST *dest)
{
  if (dest->typ == 'U')
    if (is_down_suspended(dest->call, dest->port))
     {
      conerr(CE_SUSPEND, dest);
      return;
     }

  if (portenabled(dest->port))
   {
    if (dest->typ != FLEXNET)       /* nur bei FLEXNET Pfadweitergabe   */
     {
      cpyid(usrvia, myid);
      usrvia[L2IDLEN - 1] |= L2CH;
      usrvia[L2IDLEN] = 0;
     }

    addidl(usrvia, dest->via);      /* gefundenen Pfad noch drankleben  */

    if (strlen(usrvia) > L2VLEN)    /* Headerfeld ist zu gross          */
     {
      conerr(CE_INVCAL, dest);
      return;
     }

    /* wenn wir diesen Link schon aktiv haben, melden wir BUSY          */

    lnkpoi = getlnk(dest->port, usrcal, dest->call, usrvia);

    if (lnkpoi)
     {
      if (lnkpoi->state == L2SDSCED)
       {
        userpo->status = US_CREQ;
        setptc(lnkpoi, L2_USER);
        setupmsg(dest);             /* "Downlink setup" ...             */
        newlnk();                   /* Neuen Link aufbauen              */
       }
      else
        conerr(CE_BUSY, dest);      /* Busy (Already connected)         */
     }
    else
      conerr(CE_LTFULL, dest);      /* Link table full                  */
   }
  else
    conerr(CE_PORTOFF, dest);       /* Port ist abgeschaltet            */
}

static void
con_cq(DEST *dest)
{
  UID     uid = userpo->uid;
  PTCENT *ptcp;
  PTCENT *p_ptcp;
  CQBUF  *cqp;

  ptcp = ptctab + uid;
  ptcp->p_uid = dest->uid;
  p_ptcp = ptctab + ptcp->p_uid;
  p_ptcp->p_uid = uid;

  cqp = (CQBUF *)allocb();
  cqp->uid = uid;
  cqp->p_uid = dest->uid;
  relink((LEHEAD *)cqp, (LEHEAD *)cq_statl.tail);
}

static void
conusr(int type, DEST *dest)
{
  switch (type)
   {
    case CP_CQ:                     /* CQ-User connecten                */
      con_cq(dest);
      break;
    case CP_HOSTCON:                /* Connect an die Console           */
      conhst();                     /* nicht an Kanal 0 connecten       */
      break;
    case CP_L4CON:                  /* Layer4 (NET/ROM) Connect?        */
      conl4(dest);                  /* Level 4 Connect                  */
      break;
    case CP_L2CON:                  /* Level2 connect?                  */
      conl2(dest);
      break;
    case CP_BADQUAL:
      conerr(CE_BADQUAL, dest);
      break;
    case CP_INTERN:
      break;
    case CP_UNKNOWN:
      conerr(CE_UNKNOWN, dest);
      break;
    default :                       /* Fehler aufgetreten?              */
      conerr(CE_INVCAL, dest);
      break;
   }
}

/************************************************************************/
/* Einleiten einer Weiterverbindung bei Gateway-Connects.               */
/* Hierzu wird aus dem L2-via-Feld gelesen, wohin der Link gehen        */
/* soll. Bei L4-Links wird entsprechend das Zielcall gelesen.           */
/*----------------------------------------------------------------------*/
void
gateway(void)
{
  UID     uid = userpo->uid;
  PTCENT *ptcp = ptctab + uid;
  char   *viap;
  char   *p;
  DEST    user;
  DEST    dest;

  cpyid(usrcal, calofs(UPLINK, userpo->uid));    /* Mycall                */

  switch (g_utyp(userpo->uid))
   {
    case L2_USER :
      lnkpoi = g_ulink(userpo->uid);
      cpyid(user.call, lnkpoi->srcid);            /* Ziel-Rufzeichen      */

/* Jetzt stellen wir das Addressfeld des eingehenden Links zusammen.      */
/* In usrvia wird der bisherige Weg gespeichert, in user.via der          */
/* restliche.                                                             */
/* Der Weg wird nur soweit kopiert, bis wir den ersten Digi kennen, der   */
/* Rest ist dann unwichtig.                                               */

      for (viap = lnkpoi->viaidl; *viap; viap += L2IDLEN);
      for (p = usrvia; viap > lnkpoi->viaidl; )
       {
        viap -= L2IDLEN;
        memcpy(p, viap, L2IDLEN);
        p[L2IDLEN - 1] ^= L2CH;
        if (!(p[L2IDLEN - 1] & L2CH))
         {
          p[L2IDLEN - 1] |= L2CH;
          p[L2IDLEN] = 0;
          for (p = user.via; viap > lnkpoi->viaidl; )
           {
            viap -= L2IDLEN;        /* den Rest regulaer kopieren         */
            cpyid(p, viap);         /* die muessen alle noch              */
            p += L2IDLEN;
           }
          break;
         }
        p += L2IDLEN;
       }
      *p = 0;

      break;

    case L4_USER :
      cirpoi = g_ulink(userpo->uid);

      cpyid(user.call, cirpoi->destca);           /* Ziel-Rufzeichen      */

      user.via[0] = 0;              /* hier werden wir spaeter mal aus    */
                                    /* cirpoi->upnod/upnodv den alten     */
                                    /* und mit einer L4-modif den weitern */
                                    /* weg rausfinden.                    */

      cpyid(usrvia, myid);          /* eigenes Call                       */
      usrvia[L2IDLEN - 1] |= L2CH;
      usrvia[L2IDLEN] = 0;
      break;

    default :
      return;
   }

  user.port = NOPORT;               /* Port ist uns egal                  */
  user.typ  = 0;

  ptcp->local = PTC_LOCAL;

  conusr(conprm2(&user, &dest), &dest);
  ptcp->recflg = FALSE;             /* nie Reconnect                      */
}

/**************************************************************************/
/* CONNECT                                                                */
/*------------------------------------------------------------------------*/
void
ccpcon(char *Direct)
{
  DEST dest;

  cpyid(usrvia, myid);
  usrvia[L2IDLEN - 1] |= L2CH;
  usrvia[L2IDLEN] = 0;
  conusr(conprm(&clicnt, &clipoi, &dest), &dest);
  ptctab[userpo->uid].recflg = (Direct == NULL);
}

/**************************************************************************/
/* CQ                                                                     */
/*------------------------------------------------------------------------*/
void
ccpcq(void)
{
  MBHEAD *mbp;
  WORD    prt;
  CQBUF  *cqp;
  PTCENT *ptcp;
  UID     uid = userpo->uid;

  cqp = (CQBUF *)allocb();
  cqp->uid = uid;
  cpyid(cqp->id, calofs(UPLINK, uid));
  relink((LEHEAD *)cqp, (LEHEAD *)cq_user.tail);
  userpo->status = US_CQ;
  ptcp = ptctab + uid;
  ptcp->p_uid = uid;
  ptcp->recflg = TRUE;
  skipsp(&clicnt, &clipoi);
  mbp = getmbp();
  mbp->l2fflg = L2CPID;
  while (clicnt-- > 0)
    putchr(*clipoi++, mbp);
  putchr(CR, mbp);
  cpyid(usrvia, myid);
  usrvia[L2IDLEN - 1] |= L2CH;
  usrvia[L2IDLEN] = 0;
  for (prt = 0; prt < L2PNUM; prt++)
   {
    if (!(updmheard(prt) && portenabled(prt)))
      continue;
    rwndmb(mbp);
    sdui(usrvia, cqdest, usrcal, prt, mbp);
   }
  dealmb(mbp);
  mbp = putals("Waiting ...\r");
  seteom(mbp);
}

/* End of src/l7conn.c */
