/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l7utils.c (maintained by: ???)                              */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

static char *search_file(char *, char *);

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void kilusr(void)
{
  MBHEAD *mbp;
  char file[128];

  if (userpo->sysflg > 1)
    save_stat();

  if (userpo->monitor) {
    moncmd(NULL, userpo->monitor, "N", 1); /* Monitor abschalten */
    dealoc((MBHEAD *)userpo->monitor);
    userpo->monitor = NULL;
  }

  if (   userpo->status == US_WBIN                 /* Upload beenden */
      || userpo->status == US_RBIN
      || userpo->status == US_RTXT
     )
  {
    fclose(loadfp);
#ifndef MC68302
    xremove(loadtmp);
#else
    xremove(loadname);
#endif
    loadname[0] = loadtmp[0] = 0;
  }
  if (userpo->fp != NULL)                          /* Read beenden */
  {
    fclose(userpo->fp);
    userpo->fp = NULL;
    if (userpo->fdefblk != NULL)
    {
      xremove(userpo->fdefblk->data);
      dealoc((MBHEAD *)ulink((LEHEAD *) userpo->fdefblk));
      userpo->fdefblk = NULL;
    }
  }
  if (userpo->convers != NULLCONNECTION)           /* Convers beenden */
  {
    userpo->convers->up = NULL;
    send_proto("L7", "link failure with %s", userpo->convers->name);
    if (userpo->convers->type == CT_HOST) {
      sprintf(file, "%s<>%s broken", myhostname, userpo->convers->name);
      bye_command2(userpo->convers, file);
    }
    else
      bye_command2(userpo->convers, "link failure");
  }
  userpo->convers = NULLCONNECTION;
  userpo->convflag = 0;

  userpo->status = US_NULL;

  if ((mbp = userpo->mbhd) != NULL)
     dealmb(mbp);

#ifdef PACSAT
  if (userpo->pacsat != NULL) {
      if (userpo->pacsat->tempfp != NULL) {
          fclose(userpo->pacsat->tempfp);
          xremove(userpo->pacsat->tempfile);
      }
      free(userpo->pacsat);
      userpo->pacsat = NULL;
  }
#endif

  dealoc((MBHEAD *)ulink((LEHEAD *)userpo));
  userpo = NULL;
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void invcal(void)
{
  putmsg("Invalid Call\r");
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void msgfrm(LINKTYP uplink, UID uid, char *msg)
{
  MBHEAD *mbp;
  UBYTE   user = g_utyp(uid);
  int     index;
  NODE   *np;

  mbp = putals(msg);
  if (uid != NO_UID)
   {
      if ((user == L4_USER) && (uplink != CQ_LINK))
       {
        index = find_node_this_ssid(((CIRBLK *)g_ulink(uid))->downca);
        if (index != -1)
         {
          np = netp->nodetab+index;
          putalt(np->alias, mbp);
         }
       }
    putid(calofs(uplink, uid), mbp);
  } else {
    putalt(alias, mbp);
    putid(myid, mbp);
  }
  putchr('\r', mbp);
  if (msg != conmsg)
    prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void puttfu(const char *name)
{
  MBHEAD *mbp;

  putstr(" table full\r", (mbp = putals(name)));
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putmsg(const char *string)
{
  MBHEAD *mbp;

  mbp = putals(string);
  if (userpo->convflag == 0)
    prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
MBHEAD *putals(const char *string)
{
  MBHEAD *mbp;

  mbp = getmbp();

  putalt(alias, mbp);
  putid(myid, mbp);
  putstr("> ", mbp);
  putstr(string, mbp);
  return(mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
MBHEAD *getmbp(void)
{
  MBHEAD *mbp;

  mbp = (MBHEAD *) allocb();
  mbp->l2link = g_ulink(userpo->uid);
  mbp->type   = g_utyp(userpo->uid);

  return(mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putuse(LINKTYP seite, UID uid, MBHEAD *mbp)
{
  CIRBLK *cp;
  LNKBLK *lp;
  HOSTUS *hp;
  int     index;
  NODE   *np;

  if (seite == CQ_LINK)
   {
    putstr("CQ(", mbp);
    switch (g_utyp(uid))
     {
      case L4_USER:
        putid(((CIRBLK *)g_ulink(uid))->upcall, mbp);
        break;

      case L2_USER:
        putid(((LNKBLK *)g_ulink(uid))->dstid, mbp);
        break;

      default:
        putid(((HOSTUS *)g_ulink(uid))->call, mbp);
        break;
     }
    putstr(")\r", mbp);
    return;
   }

  switch (g_utyp(uid)) {
    case L4_USER:
      cp = g_ulink(uid);
      putstr("Circuit(", mbp);
      index = find_node_this_ssid(cp->downca);
      if (index != -1)
       {
        np = netp->nodetab+index;
        putalt(np->alias, mbp);
       }
      putid(cp->downca, mbp);
      putchr(' ', mbp);
      putid(cp->upcall, mbp);
      putchr(')', mbp);
      break;

    case L2_USER:
      lp = g_ulink(uid);
      if (seite == UPLINK) {
        putstr("Uplink(", mbp);
        putid(lp->dstid, mbp);
        putchr(')', mbp);
      }
      else {
        putstr("Downlink(", mbp);
        putid(lp->srcid, mbp);
        putchr(' ', mbp);
        putid(lp->dstid, mbp);
        putchr(')', mbp);
      }
      break;

    default:
      hp = g_ulink(uid);
      putstr("Host(", mbp);
      if (cmpid(hostid, myid))
       {
        putalt(alias, mbp);
        putid(myid, mbp);
       }
      else
       {
        if (seite == UPLINK) putid(hp->call, mbp);
        else
         {
          putid(hp->call, mbp);
          putchr(' ', mbp);
          putid(hostid, mbp);
         }
       }
      putchr(')', mbp);
      break;
  }
}

static BOOLEAN issecret(WORD channel)
{
  CHANNEL *ch;

  for (ch = channels; ch; ch = ch->next)
    if (ch->chan == channel)
      break;
  if (ch->flags & (M_CHAN_S|M_CHAN_I))
    return(TRUE);
  return(FALSE);
}

/************************************************************************/
/* putcvsu                                                              */
/* Da die Verbindungen des Conversmodus so verdreht aufgebaut werden,   */
/* hier nun eine entsprechend verdrehte Ausgaberoutine         DL1XAO   */
/*----------------------------------------------------------------------*/
void putcvsu(USRBLK *u, MBHEAD *mbp)
{
  UID         uid = u->uid;
  CONNECTION *cp  = u->convers;

  if (u->convflag == 2) {                /* ausgehender Convershost */
    putstr("Convers(", mbp);
    putid(myid, mbp); /* SSID egal? ja! */
    putchr(')', mbp);
    if (cp->type == CT_HOST)
      putstr(" Host", mbp);
    putspa(37, mbp);
    putstr(u->status == US_CHST ? "<..>  "            /* im Aufbau? */
                                : "<-->  ", mbp);
    putuse(DOWNLINK, uid, mbp);
    viaput(DOWNLINK, uid, mbp);
  }
  else {                             /* User und eingehende CVSHOST */
    putuse(UPLINK, uid, mbp);
    putspa(37, mbp);
    putstr("<-->  Convers(", mbp);
    putid(calofs(UPLINK, uid), mbp);
    putchr(')', mbp);
    if (   cp->type == CT_USER
        && (issecret(cp->channel) == FALSE || userpo->sysflg)) {
      putstr(" Ch", mbp);
      putlong((LONG)cp->channel, 0, mbp);
    }
    if (cp->type == CT_HOST)
      putstr(" Host", mbp);
    viaput(UPLINK, uid, mbp);
  }
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putdil(const char *liste, MBHEAD *mbp)
{
  BOOLEAN mark = TRUE;

  if (*liste) {
    putstr(" via", mbp);
    while (*liste) {
      putchr(' ', mbp);
      putid(liste, mbp);
      if (mark)
        if ((liste[L2IDLEN - 1] & L2CH) != 0)
          if (!liste[L2IDLEN] || !(liste[L2ILEN - 1] & L2CH)) {
            putchr('*', mbp);
            mark = FALSE;
        }
      liste += L2IDLEN;
    }
  }
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putid(const char *call, MBHEAD *mbp)
 {
  char   ssid;
  char   c;
  WORD   i;

  for (i = 0; i < L2IDLEN-1; ++i)
   {
    c = *call++;

    if (c > ' ') putchr(c, mbp);
    else
     {
      if (c < ' ')
       {
        putchr('^', mbp);
        putchr((c + '@'), mbp);
       }
     }
   }
  ssid = (*call >> 1) & 0x0f;
  if (ssid != 0) {
    putchr('-', mbp);
    putnum(ssid, mbp);
  }
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putalt(char *ident, MBHEAD *mbp)
{
  if (*ident != ' ') {
    putcal(ident, mbp);
    putchr(':', mbp);
  }
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putcal(char *call, MBHEAD *mbp)
{
  char *cp;
  WORD i;

  for (i = 0, cp = call; i < L2CALEN; ++cp, ++i) {
    if (*cp == ' ')
      break;
    putchr(*cp, mbp);
  }
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void puttim(time_t *time, MBHEAD *mbp)
{
  struct tm *p;

  p = localtime(time);
  putprintf(mbp,"%02d.%02d.%02d %02d:%02d:%02d",
          p->tm_mday,  p->tm_mon+1, p->tm_year % 100,
          p->tm_hour, p->tm_min, p->tm_sec);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putnum(int zahl, MBHEAD *mbp)
{
  char buf[10];

  sprintf(buf, "%d", zahl);
  putstr(buf, mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putlong(ULONG zahl, BOOLEAN justify, MBHEAD *mbp)
{
  char buf[20];

  sprintf(buf,justify ? " %10lu" : " %lu",zahl);
  putstr(buf, mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putstr(const char *string, MBHEAD *mbp)
{
  while (*string)
    putchr(*string++, mbp);
}

/**************************************************************************/
/* printf fuer mbp-Fuellen                                       DL1XAO   */
/*------------------------------------------------------------------------*/
void putprintf(MBHEAD *mbp, const char *format, ...)
{
  va_list arg_ptr;
  char    str[256];

  va_start(arg_ptr, format);
  vsprintf(str, format, arg_ptr);
  va_end(arg_ptr);
  putstr(str, mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void vputstr(char *string, MBHEAD *mbp, ...)
{
  va_list param;
  UWORD inum;
  char *cp, *p;

  va_start(param, mbp);
  cp = string;

  while (*cp)
  {
    switch (*cp)
    {
      case '%': ++cp;
                switch (*cp)
                {
                  case 'a': p = va_arg(param, char *);
                            putalt(p, mbp);
                            break;
                  case 'u': inum = va_arg(param, UWORD);      /* UWORD */
                            putnum(inum, mbp);
                            break;
                  case 'c': p = va_arg(param, char *);
                            putcal(p, mbp);
                            break;
                  case 'i': p = va_arg(param, char *);
                            putid(p, mbp);
                            break;
                  case 's': p = va_arg(param, char *);
                            putstr(p, mbp);
                            break;
                  case 'v': p = va_arg(param, char *);
                            putdil(p, mbp);
                            break;
                  default:  putchr(*cp, mbp);
                }
                ++cp;
                break;

      default:  putchr(*cp++, mbp);
    }
  }
  va_end(param);
}
/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
void putspa(WORD stop, MBHEAD *mbp)
{
  WORD i;

  i = mbp->l4time + stop - mbp->mbpc;
  while (i-- > 0)
    putchr(' ', mbp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN
getdig(WORD *laenge, char **inbuf, BOOLEAN pflag, char *outbuf)
{
  char      *lispoi;
  WORD       i;
  char      *p;
  WORD       n;

  *outbuf = 0;
  skipsp(laenge, inbuf);
  if ((n = *laenge) < 4) return(FALSE);
  p = *inbuf;

  if (!strnicmp((char*)p, "VIA", 3)) {
    p += 3;
    n -= 3;
  }
  skipsp(&n, &p);

  /* solange wir gueltige Calls finden */
  for (i = 0, lispoi = outbuf; n > 0 && i < L2VNUM; ++i, lispoi += L2IDLEN)
    if (getcal(&n, &p, pflag, lispoi) != YES) break;
  *lispoi = 0;
  if (i > 0) {
    *laenge = n;
    *inbuf = p;
    return(TRUE);
  }
  return(FALSE);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
TRILLIAN
getcal(WORD *laenge, char **inbuf, BOOLEAN pflag, char *outbuf)
{
  char  call[L2IDLEN];
  char  binsid;
  char *bufpoi;
  char  zeichen;
  WORD  i;
  char *p = *inbuf;
  WORD  n = *laenge;

  cpyid(call,nullid);

  skipsp(&n, &p);

  bufpoi = call;
  i = 0;
  while (n > 0) {
    if (((zeichen = (char) toupper(*p)) == ' ' ) || (zeichen == ','))
      break;
    if (zeichen < ' ')
      return(ERRORS);
    if (zeichen == '-') {
      if ((i == 0) || (n <= 0))
        return(ERRORS);
      ++p;
      --n;
      if (n <= 0)
        return(ERRORS);
      zeichen = *p;
      if ((zeichen < '0') || (zeichen > '9'))
        return(ERRORS);
      ++p;
      --n;
      binsid = (zeichen - '0');
      if (n > 0) {
        zeichen = *p;
        if ((zeichen >= '0') && (zeichen <= '9')) {
          binsid *= 10;
          binsid += (zeichen - '0');
          if (binsid > 15)
            return(ERRORS);
          ++p;
          --n;
        }
      }
      call[L2IDLEN-1] = (binsid << 1) | 0x60;
      break;
    }
    else {
      if (i++ == L2IDLEN-1)
        return(ERRORS);
      *bufpoi++ = zeichen;
      ++p;
      --n;
    }
  }

  while (n > 0) {
    zeichen = *p;
    if ((zeichen != ' ') && (zeichen != ','))
      break;
    ++p;
    --n;
    if (zeichen == ',') break;
  }

  if (i == 0)
    return(NO);

  if (fvalca(pflag, call) == ERRORS)
    return(ERRORS);

  cpyid(outbuf, call);
  *laenge = n;
  *inbuf  = p;

  return(YES);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN getport(WORD *laenge, char **inbuf, WORD *port)
{
  WORD i;
  WORD tmp_port;
  char *save_inbuf = *inbuf;
  WORD  save_laenge = *laenge;
  char pn[12];
  char *inbp;
  char ch;

  skipsp(laenge, (char **) inbuf);

  if (*laenge <= 0) return(FALSE);

  inbp = *inbuf;
  for (i = 0; i < min(*laenge, 11); i++)
   {
    ch = *inbp++;
    if (ch == ' ')
      break;
    pn[i] = ch;
   }
  pn[i] = '\0';

  for (i = 0; i < L2PNUM; i++) {    /* erst Portnamen vergleichen */
    if (stricmp(portpar[i].name, pn) == 0) {
      nextspace(laenge, inbuf);
      return(portenabled(*port = i));
    }
  }

  if (isdigit(*clipoi)) {           /* sonst Portnummer pruefen   */
    tmp_port = nxtnum(laenge, inbuf);
    if (   (tmp_port >= 0)
        && (tmp_port < L2PNUM)) {   /* Port gueltig?              */
      return(portenabled(*port = tmp_port));
    }
  }

  *inbuf = save_inbuf;              /* Position restaurieren            */
  *laenge = save_laenge;

  return(FALSE);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
TRILLIAN
getide(WORD *laenge, char *(*inbuf), char *outbuf)
{
  char   ident[L2CALEN];
  char   c;
  WORD   i;
  WORD   n = *laenge;
  char  *p = *inbuf;

  memcpy(ident, nulide, L2CALEN);

  for (i = 0; (i < L2CALEN) && (n > 0); ++i) {
    --n;
    c = *p++;
    if (c != ' ') {
      if (c != '*') {
        ident[i] = c;
        continue;
      }
      if (i != 0 || c != '*')
        return(ERRORS);
    }
    break;
  }

  if ((i == L2CALEN) && (n > 0) && (*p != ' '))
    return(ERRORS);

  if (valcal(ident) == YES)
    return(ERRORS);

  memcpy(outbuf, ident, L2CALEN);
  if (ident[0] != ' ') {            /* Ident korrekt gelesen            */
    *laenge = n;
    *inbuf = p;
    return(YES);
  }

  return(NO);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
UWORD nxtnum(WORD *laenge, char **buffer)
{
  UWORD temp;

  skipsp(laenge, buffer);
  temp = 0;
  while (*laenge > 0 && **buffer >= '0' && **buffer <= '9') {
    --*laenge;
    temp *= 10;
    temp += (*(*buffer)++ - '0');
  }
  return(temp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
LONG nxtlong(WORD *laenge, char **buffer)
{
  LONG temp;

  skipsp(laenge, buffer);
  temp = 0;
  while (*laenge > 0 && **buffer >= '0' && **buffer <= '9') {
    --*laenge;
    temp *= 10;
    temp += (*(*buffer)++ - '0');
  }
  return(temp);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
TRILLIAN
fvalca(WORD pflag, char *call)
{
  if (*call == ' ' )
    return(NO);
  if (!pflag)
    return(YES);
  return(valcal(call));
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
TRILLIAN
valcal(char *call)
{
  char *numpos;
  char *actual;
  char zeichen;
  WORD zahl;
  WORD i;

  for (zahl = 0, i = 0, actual = call; i < L2IDLEN-1; ++i, ++actual) {
    if ((zeichen = *actual) == ' ')
      break;
    if (!((zeichen >= 'A') && (zeichen <= 'Z'))) {
      if ((zeichen >= '0') && (zeichen <= '9')) {
        zahl += 1;
        numpos = actual;
      }
      else
        return(ERRORS);
    }
  }
  if ( (actual - call) < 4 || zahl == 0 || zahl > 2 || numpos == call
    || (numpos == (actual -1)))
    return(ERRORS);
  return(TRUE);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN ismemr(void)
{
  if (nmbfre < 300 && !userpo->sysflg)
    return(FALSE);

  return(TRUE);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
char *calofs(LINKTYP uplink, UID uid)
{
  void *link;

  if (uid == NO_UID) return(myid);

  link = g_ulink(uid);
  switch (g_utyp(uid)) {
    case L2_USER :
      return(((LNKBLK *)link)->dstid);
    case L4_USER :
      return(  ((uplink == UPLINK) || (uplink == CQ_LINK))
             ? ((CIRBLK *)link)->upcall
             : ((CIRBLK *)link)->downca);
  }

  if (tnnb_aktiv) return(myid);
  if (uplink == DOWNLINK) return(hostid);
  return(hstusr->call);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN getlin(MBHEAD *mbp)
{
  char huge *nextch;
  WORD getcou;
  WORD found;
  WORD laenge;
  WORD mlaenge = 81;

  if (userpo->status == US_WBIN || userpo->status == US_RBIN)
    return(TRUE);

  if (userpo->convers) {
    if (userpo->convers->type == CT_UNKNOWN)
      return(TRUE);
    mlaenge = 2047;
  }
  nextch = mbp->mbbp;
  getcou = mbp->mbgc;
  found = FALSE;
  laenge = 0;
  while (mbp->mbgc < mbp->mbpc) {
    if (((getchr(mbp)) == CR) || (++laenge == mlaenge)) {
      found = TRUE;
      break;
     }
  }
  mbp->mbbp = nextch;
  mbp->mbgc = getcou;
  return(found);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN issyso(void)
{
  return(userpo->sysflg != 0);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN skipsp(WORD *cnt, char **cpp)
{
  while ((*cnt > 0) && **cpp == ' ') {
    ++*cpp;
    --*cnt;
  }
  return((*cnt > 0) ? TRUE : FALSE);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
WORD getparam(WORD *cnt, char **cpp, WORD min, WORD max, WORD def)
{
  int par;
  if ((*cnt) > 1) {
    (*cpp)++;
    (*cnt)--;
    if (toupper(*(*cpp)) == 'O') { /* BOOLEAN */
      if (toupper((*cpp)[1]) == 'N') par = 1;
      else par = 0;
      nextspace(cnt, cpp);
      return(par);
    }
    par = (nxtnum(cnt, cpp));
    if (par > max) par = max;
    if (par < min) par = min;
    return(par);
  }
  return(def);
}

/**************************************************************************/
/*                                                                        */
/*------------------------------------------------------------------------*/
BOOLEAN nextspace(WORD *cnt, char **cpp)
{
  while ((*cnt > 0) && **cpp != ' ') {
    ++*cpp;
    --*cnt;
  }
  return((*cnt > 0) ? TRUE : FALSE);
}

/* Ermittelt das Filedatum von AKTUELL.TXT und stellt es zur Verfuegung
 */
static char *aktuell(void)
{
  char file[128];
  struct ffblk fb;
  static char akt[10] = "?";
#ifdef MC68302
  struct tm *ftime;
#endif

  strcpy(file, textcmdpath);
#ifdef MC68302
  strcat(file, "aktuell.txc");
#else
  strcat(file, "aktuell.txt");
#endif
  if (xfindfirst(file, &fb, 0) == 0) {
#ifdef MC68302
    ftime = localtime(&fb.ff_ftime);
    sprintf(akt, "%02d.%02d.%02d", ftime->tm_mday,
                                  (ftime->tm_mon)+1,
                                  (ftime->tm_year)%100);
#else
    sprintf(akt,"%02d.%02d.%02d", fb.ff_fdate & 0x1f,
                                 (fb.ff_fdate >> 5) & 0xf,
                                 ((fb.ff_fdate >> 9) + 80) % 100);
#endif
  }
  return(akt);
}

/*------------------------------------------------------------------------*/
/* Prompt generieren und an Message-Buffer anhaengen                      */
/*------------------------------------------------------------------------*/
/* Prompt aufbauen, im Convers-Modus gibt es keinen Prompt, sondern */
/* stattdessen  einen String '***\r', der das Ende der Ausgabe des  */
/* Digis anzeigt.                                                   */
void prompt(MBHEAD *mbp)
{
  if (userpo->convers == NULLCONNECTION)
    prompt2str(mbp, promptstr);
  else
    putstr("***\r", mbp);
}

  /* String nach '%' durchsucht und gegebenenfalls ergaenzt.    */
  /*     '%a' wird durch den Digipeater-Ident ersetzt,          */
  /*     '%A' wird durch das Datum des aktuell.txt ersetzt,     */
  /*     '%c' durch das Call des Users,                         */
  /*     '%C' durch das User-Call mit SSID,                     */
  /*     '%n' durch den NAmen des Users,                        */
  /*     '%d' durch das Call des Digipeaters,                   */
  /*     '%D' durch das Call des Digipeaters mit SSID,          */
  /*     '%r' durch Carriage-Return                             */
  /*     '%s' durch Datum                                       */
  /* und '%t' durch die aktuelle Uhrzeit (HH:MM).               */
  /* '%0' unterdrueckt die Aussendung eines Prompts.            */
void prompt2str(MBHEAD *mbp, char *str)
{
  char *cp;
  char buf[26];
  struct tm *lt;

  while (*str) {
    for (cp = str; *cp && *cp != '%'; ++cp)
      ;
    if (*cp == '%') {
      *cp = '\0';
      putstr(str, mbp);
      *cp++ = '%';
      switch (*cp) {
        case 'a':  putalt(alias, mbp);
                   break;

        case 'A':  putstr(aktuell(), mbp);
                   break;

        case 'c':  putcal(calofs(UPLINK, userpo->uid), mbp);
                   break;

        case 'C':  putid(calofs(UPLINK, userpo->uid), mbp);
                   break;

        case 'd':  putcal(myid, mbp);
                   break;

        case 'D':  putid(myid, mbp);
                   break;

        case 'n':  putstr("N.N.",mbp);
                   break;

        case 's':  lt = localtime(&sys_time);
                   putprintf(mbp, "%02u.%02u.%02u",
                                  lt->tm_mday, lt->tm_mon+1, lt->tm_year%100);
                   break;

        case 't':  sprintf(buf,"%16.16s",ctime(&sys_time));
                   putstr(&buf[11], mbp);
                   break;

        case 'r':  putchr(CR, mbp);
                   break;

        case '0':  break;

        case '%':  putchr('%', mbp);
                   break;
      }
      str = ++cp;
    }
    else {
      putstr(str, mbp);
      str = cp;
    }
  }
}

/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
void putide(char *ID, MBHEAD *mbp)
{
  int i;

  for (i = 5; (i >= 0) && (ID[i] == ' '); i--)       putchr(' ', mbp);
  for (i = 0; (i <  L2CALEN) && (ID[i] != ' '); i++) putchr(ID[i],mbp);
}

/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
void putkbytes(ULONG zahl,MBHEAD *mbp)
{
  char buf[10];
  sprintf(buf,"%7lu",zahl>>10);
  putstr(buf,mbp);
}


/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
void invmsg(void)
{
  putmsg("Invalid command. Try HELP.\r");
}

/************************************************************************/
/* Beacons                                                              */
/*----------------------------------------------------------------------*/
void dump_beacn(MBHEAD *mbp)
{
  BEACON *beapoi;
  int port;

  putstr(";\r; Stat/Text-Broadcast\r;\r", mbp);
  for (port = 0, beapoi = beacon; port < L2PNUM; ++port, ++beapoi) {
    if (*beapoi->text)
      putprintf(mbp, "BEACON %d = %s\r", port, beapoi->text);
    putprintf(mbp, "BEACON %d %d %d ", port, beapoi->interval, beapoi->telemetrie);
    putid(beapoi->beades, mbp);
    putdil(beapoi->beadil, mbp);
    putchr('\r', mbp);
  }
}

/************************************************************************/
/* Convers-Links                                                        */
/*----------------------------------------------------------------------*/
void dump_convc(MBHEAD *mbp)
{
  int  pl;
  char *c;
  PERMLINK *p;

  putstr(";\r; Convers Interlinks\r;\r", mbp);
  for (pl = 0; pl < MAXCVSHOST; pl++) {
    p = permarray[pl];
    if (p ) {
      putstr("CONV C ", mbp);
      putid(p->call, mbp);
      if (p->port != 255) {
    putchr(' ', mbp);
    putnum(p->port, mbp);
    if (*(c = p->via)) {
      while (*c) {
        putchr(' ', mbp);
        putid(c, mbp);
        c += L2IDLEN;
      }
    }
      }
      putchr('\r', mbp);
    }
  }
}


/************************************************************************/
/* Links                                                                */
/*----------------------------------------------------------------------*/
void dump_links(MBHEAD *mbp)
{
  char   *c;
  L2LINK *p;
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;

  putstr(";\r; Links\r;\r", mbp);

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used) {
      p = pp->l2link;
      putstr("LINK + ", mbp);
      putprintf(mbp, "%2.2s ",typtbl + pp->typ*2);
      putnum(p->port, mbp);
      putchr(' ', mbp);
      putcal(p->alias, mbp);
      putchr(' ', mbp);
      putid (p->call, mbp);
      putchr(' ', mbp);

      if (*(c = p->digil )) {
        while (*c) {
          putchr(' ', mbp);
          putid(c, mbp);
          c += L2IDLEN;
        }
      }
      putchr('\r',mbp);
    }
}

/************************************************************************/
/* Parameter                                                            */
/*----------------------------------------------------------------------*/
void dump_parms(MBHEAD *mbp)
{
  UWORD  num;
  PARAM  *p;

  putstr(";\r; Parameters\r;\r", mbp);
  for (p = partab, num = 1; num <= partablen; p++, num++)
    if (p->paradr && strncmp(p->parstr, "unu", 3))
      putprintf(mbp, "PAR %s %u\r", p->parstr, *(p->paradr));
}

/************************************************************************/
/* Ports                                                                */
/*----------------------------------------------------------------------*/
void dump_ports(MBHEAD *mbp)
{
  int port;
  PORTINFO *pp;
  L1MODETAB *mtp;
  char mode[16], *cp;

  putstr(";\r; Port Configuration (Level 1)\r;\r", mbp);
  for (port = 0, pp = portpar; port < L2PNUM; port++, pp++) {
    putprintf(mbp, "PORT %d NAME=%s ", port, pp->name);
    l1hwcfg(port, mbp);
    cp = mode;
    for (mtp = l1modetab; mtp->ch; mtp++)
      if (pp->l1mode & mtp->mode) *cp++ = mtp->ch;
    *cp = 0;
    putprintf(mbp, " MODE=%u00%s TXD=%u MAX=%u DAMA=%u CTEXT=%u SYSOP=%u MH=%u\r",
                   pp->speed,
                   mode,
                   pp->txdelay,
                   pp->maxframe,
                   pp->l2mode & MODE_a ? 1 : 0,
                   pp->l2mode & MODE_x ? 1 : 0,
                   pp->l2mode & MODE_s ? 1 : 0,
                   pp->l2mode & MODE_h ? 1 : 0);
  }
}

/************************************************************************/
/* SUSPEND                                                              */
/*----------------------------------------------------------------------*/
void dump_suspd(MBHEAD *mbp)
{
  SUSPEND *suspoi;
  int     i;

  putstr(";\r; Suspended Users\r;\r", mbp);
  for (suspoi = sustab, i = 0; i < MAXSUSPEND; suspoi++, i++)
    if (suspoi->call[0]) {
      putprintf(mbp, "SUSPEND + %d ", suspoi->port);
      putcal(suspoi->call, mbp);
      if (suspoi->port == 255) {
        putchr(' ', mbp);
        putnum(suspoi->okcount, mbp);
      }
      putchr('\r', mbp);
   }
}

/************************************************************************/
/* ip                                                                   */
/*----------------------------------------------------------------------*/
#ifdef IPROUTE
void dump_ipr(MBHEAD *mbp)
{
 IP_ROUTE *ipr;
 ARP_TAB  *arp;
 const char *dgmode_tab[] = {"", "DG", "VC"};

  putstr(";\r;IP-Config\r;\rIPA ", mbp);
  show_ip_addr(my_ip_addr, mbp);               /* My IP-Adress */
  putchr('\r', mbp);

  for (ipr =  (IP_ROUTE *)IP_Routes.head;         /* IP-Routen */
       ipr != (IP_ROUTE *)&IP_Routes;
       ipr =  (IP_ROUTE *)ipr->nextip) {
    putstr("IPR ", mbp);
    show_ip_addr(ipr->dest, mbp);          /* Adresse anzeigen */
    putprintf(mbp, "/%d + %s%s ",
                   ipr->bits, /* Bitmaske zeigen  */
                   ipr->flags & RTDYNAMIC ? "D " : " ",
                   ipr->port == NETROM_PORT ?
                   "NET/ROM" : portpar[ipr->port].name);
    if (ipr->gateway != 0)
      show_ip_addr(ipr->gateway, mbp);     /* Gateway          */
    putchr(' ', mbp );
    if (ipr->metric != 0)                  /* if metric set,   */
        putnum(ipr->metric, mbp);          /* show metric      */
    putchr('\r', mbp);
  }

  for (arp =  (ARP_TAB *)Arp_tab.head;                  /* ARP */
       arp != (ARP_TAB *)&Arp_tab;
       arp =  (ARP_TAB *)arp->nextar) {
    if (arp->timer == 0) {              /* nur feste EIntraege */
      putstr("ARP ", mbp);
      show_ip_addr(arp->dest, mbp);
      putprintf(mbp, " + %c %s %s ",
                     arp->publish_flag ? 'P' : ' ',
                     arp->port == NETROM_PORT ?
                     "NET/ROM" : portpar[arp->port].name,
                     dgmode_tab[(int)arp->dgmode]);
      putid(arp->callsign, mbp);
      putchr(' ', mbp );
      putdil(arp->digi, mbp);
      putchr('\r', mbp );
    }
  }
}
#endif

/************************************************************************/
/* Versch. noch eintragen                                               */
/*----------------------------------------------------------------------*/
void dump_divrs(MBHEAD *mbp)
{
#ifdef PACSAT
  WORD x;

  /* PACSAT-BROADCAST */

  putstr(";\r; Pacsat Broadcast\r;\r", mbp);
  for (x = 0; x < L2PNUM; x++)
  {
    if (pacsat_enabled[x])
    {
      putprintf(mbp, "PACSAT + %u\r", x);
    }
  }
  putprintf(mbp, "PACSAT CALL ");
  putid(pacsatid,mbp);

  putprintf(mbp, "\rPACSAT P 1 %u\r",pacsat_timer);
  putprintf(mbp, "PACSAT P 2 %u\r",pacsat_frames);
  putprintf(mbp, "PACSAT P 3 %u\r",pacsat_free);
#endif
  /* versch. */

  putstr(";\r; Mailbox and Cluster\r;\r", mbp);
  putstr("MAILBOX ", mbp);
  putid(boxid, mbp);
  putstr("\rDXCLUSTER ", mbp);
  putid(dxcid, mbp);
  putstr("\r;\r; MHeard, Prompt\r;\r", mbp);
  putprintf(mbp, "MH = %d\r", l2heard.max);
  putprintf(mbp, "L3MH = %d\r", l3heard.max);
  putprintf(mbp, "PROMPT =%s\r", promptstr);
  if (tkcom > -1) {
    /* Tokenring-Speed */
    putstr(";\r; Tokenspeed\r;\r", mbp);
    putprintf(mbp, "#T %u00",tkbaud);
  }
}

void save_parms(void)
{
  MBHEAD    *mbp;
  FILE      *fp;
  UBYTE      ch;
  char       call[20];

  if ((fp = xfopen("PARMS.TNB", "wt+")) == NULL) return;
#ifdef ST
    setvbuf(fp, NULL, _IOFBF, 4096L); /* speedup */
#endif

  mbp = (MBHEAD *) allocb();

  /* Versionskennung und Datum speichern */

  putprintf(mbp, "; ----------------------------------------------\r"
                 ";\r"
                 "; THIS FILE MAY BE OVERWRITTEN - DO NOT CHANGE!!\r"
                 ";               (use %s.TNB)\r;\r", cfgfile);
  putprintf(mbp, "; ----------------------------------------------\r"
                 "; TheNetNode AutoConfiguration Batch File\r\r"
                 "; Created: ");
  puttim(&sys_time, mbp);
  call2str(call,myid);
  putprintf(mbp, "\r; Version: %s\r"
                 "; Node Ident : %s\r"
                 "; Node MyCall: %s\r;\r", version, alias, call);

  /* die ganzen Parameter ausgeben, nach DL1XAO */

  dump_beacn(mbp);
  dump_convc(mbp);
  dump_links(mbp);
  dump_parms(mbp);
  dump_ports(mbp);
  dump_suspd(mbp);
#ifdef IPROUTE
  dump_ipr(mbp);
#endif
  dump_divrs(mbp);
  rwndmb(mbp);

  while (mbp->mbgc < mbp->mbpc)
  {
    ch = getchr(mbp);
    if (ch == 13) fprintf(fp, "\n");
    else fputc(ch, fp);
  }

  dealmb(mbp);
  fclose(fp);
}

/************************************************************************/
/* Ein Ereigniss protokollieren, jeder Sysop, der einen Trace mit dem   */
/* notwendigen Level eingestellt hat, bekommt die Meldung zugeschickt.  */
/*----------------------------------------------------------------------*/
void notify(int level, const char *format, ...)
{
  va_list    arg_ptr;
  char       str[1024];
  USRBLK    *sav_userpo;
  MBHEAD    *mbp;
  struct    tm *p;

  p = localtime(&sys_time);

  va_start(arg_ptr, format);
  vsprintf(str, format, arg_ptr);
  va_end(arg_ptr);

  sav_userpo = userpo;

  for (userpo =  (USRBLK *) usccpl.head;
       userpo != (USRBLK *) &usccpl;
       userpo =  (USRBLK *) userpo->unext)
  {
    if (userpo->status == US_CCP && userpo->auditlevel >= level) {
      mbp = getmbp();
      putprintf(mbp, "(%u) %02d.%02d.%02d %02d:%02d:%02d ",
                     level,
                     p->tm_mday, p->tm_mon+1, p->tm_year % 100,
                     p->tm_hour, p->tm_min, p->tm_sec);
      putstr(str, mbp);
      putchr('\r', mbp);
      if (!send_msg(FALSE,mbp))
        dealmb((MBHEAD *)ulink((LEHEAD *)mbp)); /* der Link ist voll */
      break;
    }
  }

  userpo = sav_userpo;
}

/************************************************************************/
/* Feststellen, ob ein User einen Downlink auf einem Port machen darf.  */
/*----------------------------------------------------------------------*/
BOOLEAN is_down_suspended(char *user_call, int user_port)
{
  LNKBLK  *link;
  SUSPEND *suspended;
  WORD    user_links;
  WORD    i, j;

  /* Suspended-Liste nach dem User-Rufzeichen durchsuchen */
  for (suspended = sustab, i = 0; i < MAXSUSPEND; suspended++, i++)
    if (strnicmp(user_call, suspended->call, L2CALEN) == 0)
      break;

  if (i == MAXSUSPEND)                    /* User nicht in der Liste       */
    return(FALSE);                        /* er darf..                     */

  if (user_port == suspended->port)       /* User gesperrt auf diesem Port */
    return(TRUE);                         /* also abwerfen..               */

  if (suspended->port == 254)             /* darf ueberhauptnicht          */
    return(TRUE);

  if (suspended->port != 255)             /* Falls 255 dann zaehlen...     */
    return(FALSE);

  /* Anzahl der Links dieses Users zum Knoten ermitteln */
  for (link = lnktbl, j = 0, user_links = 0; j < LINKNMBR; j++, link++)
    if (cmpcal(link->dstid, user_call) && link->state != L2SDSCED )
      user_links++;

  return(user_links > suspended->okcount);
}

/************************************************************************/
/*--- Test, ob User gesperrt ist                                     ---*/
/*                                                                      */
/* Parameter im Aufruf:                                                 */
/*      *u_block: Pointer auf User Kontrollblock                        */
/*                                                                      */
/* Rueckgabe:                                                           */
/*      TRUE: User ist gesperrt                                         */
/*     FALSE: User hat noch mindestens einen Kanal frei                 */
/*                                                                      */
/* Es wird auf PORT und OKCOUNT geprueft. OKCOUNT ist die Maximalzahl   */
/* der zulaessigen Links, unabhaengig vom Port. PORT ist immer gesperrt.*/
/* Um einen User nur fuer einen Port zu sperren ist also OKCOUNT auf    */
/* 255 zu setzen und PORT auf den Sperrport. Um einen USER auf eine     */
/* Maximalzahl von Links zu begrenzen, ist PORT auf 255 zu setzen und   */
/* OKCOUNT auf die gewuenschte Zahl an Links.                           */
/* Der Port 254 entspricht einem L4-User                                */
/*----------------------------------------------------------------------*/
BOOLEAN is_suspended(USRBLK *u_block)
{
  LNKBLK  *link;
  SUSPEND *suspended;
  char    *user_call;
  UBYTE   user_port;
  WORD    user_links;
  WORD    i, j;

  switch (g_utyp(u_block->uid)) {
    case HOST_USER:
             return(FALSE);                     /* User am Host-Terminal   */

                                                /* User im Level-2 Uplink  */
    case L2_USER:
            link = g_ulink(u_block->uid);
            user_call = link->dstid;
            user_port = link->liport;
            break;

                                                /* User kommt per Circuit  */
    case L4_USER:
            user_call = ((CIRBLK *)g_ulink(u_block->uid))->upcall;
            user_port = 254;
            break;
  }

  /* Suspended-Liste nach dem User-Rufzeichen durchsuchen */
  for (suspended = sustab, i = 0; i < MAXSUSPEND; suspended++, i++)
    if (cmpcal(user_call, suspended->call))
      break;

  if (i == MAXSUSPEND)                    /* User nicht in der Liste       */
    return(FALSE);                        /* er darf..                     */

  if (user_port == suspended->port)       /* User gesperrt auf diesem Port */
    return(TRUE);                         /* also abwerfen..               */

  /* Anzahl der Links dieses Users zum Knoten ermitteln */
  for (link = lnktbl, j = 0, user_links = 0; j < LINKNMBR; j++, link++)
    if (cmpcal(link->dstid, user_call) && link->state != L2SDSCED )
      user_links++;

  if (user_links > suspended->okcount)  /* Anzahl der Links ueberschritten */
    return(TRUE);                       /* also abwerfen..                 */

  return(FALSE);                          /* User darf..                   */
}

/************************************************************************/
/*--- CRC-Tabelle berechnen                                          ---*/
/*                                                                      */
/*----------------------------------------------------------------------*/
void init_crctab(void)
{
    UWORD n;
    UWORD m;
    UWORD r;
    UWORD mask;

    static UWORD bitrmdrs[] = { 0x9188, 0x48C4, 0x2462, 0x1231,
                                0x8108, 0x4084, 0x2042, 0x1021};

    for (n = 0; n < 256; ++n)
      {
        for (mask = 0x0080, r = 0, m = 0; m < 8; ++m, mask >>= 1)
          if (n & mask)
            r = bitrmdrs[m] ^ r;
        crctab[n] = r;
      }
}

/*----------------------------------------------------------------------*/
static char *search_file(char *dir_name, char *text_name) {
/*                                                                      */
/* Das erste Wort in *clipoi als Filenamen annehmen. Dabei sind         */
/* Abkuerzungen erlaubt. Nach einem passenden File im Directory dir_name*/
/* suchen und den Namen bei Bedarf ergaenzen.                           */
/*                                                                      */
/* Rueckgabe: char * auf den Filenamen ohne Extention, wenn gefunden    */
/*            NULL  : kein passendes File gefunden                      */
/*                                                                      */
/* 18/02/95 DL9HCJ Extention nicht zurueckgeben, damit mehr Platz in der*/
/*                 Eingabezeile ist.                                    */
/*                                                                      */
/*----------------------------------------------------------------------*/

  char         *cli_save;
  WORD          cli_cnt;
  struct ffblk  file_block;
  WORD          i;

  cli_save = clipoi;
  cli_cnt = clicnt;
  strcpy(text_name, dir_name);

  i = 0;
  while (isalnum(*clipoi) && (i < 8) && (clicnt > 0)) {
    strncat(text_name, (char *) clipoi++, 1);
    clicnt--;
    i++;
  }

  if (i == 0) return(NULL);

  if (i < 8)
    strcat(text_name, "*");

/*****************************************************************************/
/*** Da es beim MC68302-Betriebssystem keine Verzeichnisse gibt, unter-    ***/
/*** scheiden wir anhand der Dateiendung um was es sich hier handelt...    ***/
#ifdef MC68302
  if (dir_name == userexepath)
    strcat(text_name, ".APU");
  else if (dir_name == sysopexepath)
    strcat(text_name, ".APS");
  else
    strcat(text_name, ".TXC");
#endif
#if defined(__GO32__) || defined(__DOS16__) || defined(__WIN32__)
  if (dir_name == textcmdpath)
    strcat(text_name, ".TXT");
  else
    strcat(text_name, ".EXE");
#endif
#ifdef ST
  if (dir_name == textcmdpath)
    strcat(text_name, ".TXT");
  else
    strcat(text_name, ".TTP");
#endif

  if (xfindfirst(text_name, &file_block, 0) == 0)
  {
    strcpy(text_name, dir_name);
    strcat(text_name, file_block.ff_name);

    return(text_name);
   }
  clipoi = cli_save;
  clicnt = cli_cnt;
  return(NULL);
}
/*----------------------------------------------------------------------*/


/*----------------------------------------------------------------------*/
BOOLEAN read_txt(void) {
/*                                                                      */
/* Das erste Wort *clipoi als Filenamen annehmen. Dabei sind            */
/* Abkuerzungen erlaubt. Nach einem passenden File im Directory "TEXT"  */
/* suchen und den Namen bei Bedarf ergaenzen. Das File lesen und an den */
/* User userpo schicken.                                                */
/*                                                                      */
/* Rueckgabe:                                                           */
/*       TRUE: Fehler, File nicht gefunden.                             */
/*      FALSE: kein Fehler.                                             */
/*                                                                      */
/*----------------------------------------------------------------------*/

  char    file_path[128];

  if (search_file(textcmdpath, file_path) != NULL)
  {
    ccpread(file_path);
    return(FALSE);
  }
  return(TRUE);
}


/*----------------------------------------------------------------------*/
BOOLEAN do_file(char *directory) {
/*                                                                      */
/* Sucht in Directory directory nach einem zu *clipoi passenden File    */
/* und fuehrt es bei Erfolg aus. Der Rest von clilin wird als Argument  */
/* uebergeben.                                                          */
/* Wenn die auszufuehrende Kommandozeile nicht zu lang ist, dann wird   */
/* die Ausgabe auf ein File umgeleitet und an den User ueber ccpread    */
/* geschickt.                                                           */
/* Als zusaetzliches Argument wird das User Call+SSID uebergeben        */
/*                                                                      */
/* Rueckgabe: TRUE : Fehler, kein File gefunden                         */
/*            FALSE: kein Fehler aufgetreten                            */
/*                                                                      */
/*----------------------------------------------------------------------*/

  char    command_line[512];
/* erstmal 512 zeichen, bis jemand was besseres weiss .. noch besser:   */
/* die routine neu schreiben, so dass mit relativen pfaden gearbeitet   */
/* werden kann                                                          */
  char    call[10];
  char   *tmpfile;
#ifdef __GO32__
  int     i;
#endif

  if (search_file(directory, command_line) != NULL)
  {
    if (clicnt > 0)
      strncat(command_line, (char *) clipoi, clicnt);

#ifdef __LINUX__
    security_check(command_line);
#else
    command_line[strcspn(command_line,"<>|")] = '\0';
#endif
    strcat(command_line, " ");

    tmpfile = tempnam(textpath, "do");
    if (tmpfile == NULL) return(FALSE);
    call2str(call, usrcal);
    strcat(command_line, call);
#ifndef MC68302
    strcat(command_line, " > ");
#else
    strcat(command_line, " ");
#endif
    strcat(command_line, tmpfile);
#ifndef __LINUX__
    if (strlen(command_line) >127)        /* max. Laenge der Kommando-  */
#else
    if (strlen(command_line) >MAXPATH)    /* max. Laenge der Kommando-  */
#endif
    {                                     /* Zeile ist 127 bei DOSE     */
      putmsg("Commandline too long..");
    }
    else
    {
      xchdir(textpath);
      system(command_line);               /* Ausgaben ins Temporaerfile */
#ifdef __GO32__
      for (i = 0; i < MAXCOMS; i++)
        clear_rs232(i);                   /* DOS schaltet IRQs ab???    */
#endif
      xchdir(NULL);
      userpo->fdefblk = (MB *) allocb();
      /*tmpfile[63] = '\0'; es MUSS halt reinpassen....*/
      strcpy(userpo->fdefblk->data, tmpfile);
      relink((LEHEAD *)userpo->fdefblk,(LEHEAD *)fdfl.tail);
      ccpread(tmpfile);
    }
    free(tmpfile);
    return(FALSE);                        /* Kommandoauswertung beenden */
  }
  return(TRUE);
}


/*----------------------------------------------------------------------*/
BOOLEAN extern_command(void) {
/*                                                                      */
/* Sucht in Directory "USEREXE" nach einem *clipoi passenden File       */
/* und fuehrt es bei Erfolg aus. Der Rest von clilin wird als Argument  */
/* uebergeben. Die Ausgabe wird auf EXTCMD.TMP umgeleitet und den User  */
/* ueber ccpread geschickt.                                             */
/* Als zusaetzliches Argument wird das User Call uebergeben             */
/* Falls der User Sysop Status hat, auch in "SYSEXE" nachsehen          */
/*                                                                      */
/* Rueckgabe: TRUE : Fehler, kein File gefunden                         */
/*            FALSE: kein Fehler aufgetreten                            */
/*                                                                      */
/*----------------------------------------------------------------------*/

  if (!do_file(userexepath))
    return(FALSE);

  if (issyso())
     return(do_file(sysopexepath));
  return(TRUE);

 }

/*----------------------------------------------------------------------*/
BOOLEAN intern_command(COMAND *tabelle) {
/*                                                                      */
/* Das erste Wort in clilin als Befehl annehmen und nach einem          */
/* passenden Befehl suchen und ihn bei Erfolg ausfuehren.               */
/*                                                                      */
/* Rueckgabe: TRUE : Fehler, nichts gefunden                            */
/*            FALSE: kein Fehler, Befehl wurde ausgefuehrt.             */
/*                                                                      */
/*----------------------------------------------------------------------*/

  COMAND        *cmdpoi;
  const char    *cmdnam;
  char          *command_line_save;
  WORD           command_length_save;

  command_line_save = clipoi;
  command_length_save = clicnt;
  for (cmdpoi = tabelle;
       cmdpoi->cmdstr != 0;
       ++cmdpoi) {
    clipoi = command_line_save;
    clicnt = command_length_save;
    cmdnam = cmdpoi->cmdstr;
    while ((clicnt != 0) && (*clipoi != ' ')) {
      if ((char) toupper(*clipoi) != *cmdnam)
        break;
      ++clipoi;
      --clicnt;
      ++cmdnam;
    }
    if (clicnt == 0 || *clipoi == ' ')
      break;
  }
  if (cmdpoi->cmdfun != NULL) {
    skipsp(&clicnt, &clipoi);
    (*cmdpoi->cmdfun)(cmdpoi->cmdpar);
     return(FALSE);
  }
  clipoi = command_line_save;
  clicnt = command_length_save;
  return(TRUE);
}

/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
void inv_cmd(void)
{
  putmsg("Invalid Command. Try HELP.\r");
  if (g_ulink(userpo->uid) != hstubl)
    if (++userpo->errcnt >= 5)
      disusr(userpo->uid);
}

/************************************************************************/
/* Binaerfile einladen, Pruefsumme berechnen.                           */
/*----------------------------------------------------------------------*/
void program_load(MBHEAD *mhdp)
{
  MBHEAD *mbp;
  char c;

  while (mhdp->mbgc < mhdp->mbpc) {
    c = getchr(mhdp) & 0xFF;
    fputc(c, loadfp);
    checksum += c;
    crc = crctab[crc >> 8] ^ ((crc << 8) | (UWORD)c);
    bytecnt--;
    if (bytecnt == 0L) {
      userpo->status = US_CCP;
      fclose(loadfp);
      mbp = getmbp();
#ifndef MC68302
      if (xrename(loadtmp, loadname) == 0)
#endif
        strcpy(loadtmp, loadname);
      putprintf(mbp,"%s ok. Checksum: %ld  CRC: %u\r", loadtmp, checksum, crc);
      prompt(mbp);
      seteom(mbp);
      checksum = 0L;
      crc = 0;
      loadname[0] = loadtmp[0] = 0;
    }
  }
}

/*----------------------------------------------------------------------*/
/* Binaerfileuebertragung nach dem THP-AUTOBIN-Format starten.          */
/*----------------------------------------------------------------------*/
void start_autobin(void)
{
  MBHEAD *mbp;

  if (strnicmp(clilin, "#BIN#", 5) == 0) {
    clipoi = clilin + 5;
    clicnt -= 5;
     if ((bytecnt = nxtlong(&clicnt,&clipoi)) != 0L) {
       userpo->status = US_RBIN;
       xremove(loadname);
       mbp = getmbp();
       putstr("#OK#\r", mbp);
       seteom(mbp);
       return;
    }
  }
  fclose(loadfp);
  loadname[0] = loadtmp[0] = 0;
  userpo->status = US_CCP;
}

/*----------------------------------------------------------------------*/
/* Text-Eingabe starten. Der Text wird zunaechst in die Datei TMP.TXT   */
/* geschrieben. Wird ein '.' als erstes Zeichen einer Zeile empfangen,  */
/* wird TMP.TXT umbenannt in den vom Sysop angegebenen Dateinamen.      */
/* Da nur ein temporaeres File TMP.TXT zur gleichen Zeit vorhanden      */
/* sein kann, darf bei mehreren eingelogten Sysops immer nur einer      */
/* Dateien editieren.                                                   */
/*----------------------------------------------------------------------*/
void load_text(void)
{
  MBHEAD *mbp;

  *clipoi = '\0';
  clipoi = clilin;
  if (*clipoi == '.' || *clipoi == 0x1A) {
    userpo->status = US_CCP;
    fclose(loadfp);
    mbp = getmbp();
#ifndef MC68302
    if (xrename(loadtmp, loadname) == 0)
#endif
      strcpy(loadtmp, loadname);
    putprintf(mbp, "%s ok!\r", loadtmp);
    prompt(mbp);
    seteom(mbp);
    loadname[0] = loadtmp[0] = '\0';
  }
  else {
    fputs(clilin, loadfp);
    fputc('\n', loadfp);
  }
}

/************************************************************************/
/* Vom User eingegebene Zeichen mit aktuellem Passwort vergleichen und  */
/* bei korrekter Eingabe SYSOP-Flag setzen. In jedem Fall den Versuch   */
/* in die Datei SYSOP-PRO aufnehmen.                                    */
/*----------------------------------------------------------------------*/
void get_password(void)
{
  WORD i;
  char file[128];
  FILE *fp;
  char pwd[6];                            /* ala BayBox   DL1XAO */

  memcpy(pwd, userpo->paswrd, 5);
  pwd[5] = '\0';
  i = FALSE;
  if (strlen((char *)clipoi) > 80)        /* maximal 80 Zeichen  */
    *(clipoi + 80) = '\0';
  if (clicnt >= 5 && strstr((char *)clipoi, pwd) != NULL) {
    i = TRUE;
    userpo->sysflg = 1;
  }

  /* Wenn SYSOP-Protokoll gefuehrt werden soll, Rufzeichen, Datum, */
  /* Zeit und ob SYSOP-Befehl erfolgreich in eine Datei mit Namen  */
  /* SYSOP.PRO schreiben. Diese Datei kann spaeter vom SYSOP       */
  /* ausgelesen und ausgewertet werden.                            */

  if (syspro_flag == TRUE) {
    strcpy(file, confpath);
    strcat(file, "SYSOP.PRO");
    if ((fp = xfopen(file,"at")) != NULL) {
      fprintf(fp, "%24.24s %6.6s: %s\n",
                  ctime(&sys_time),
                  calofs(UPLINK, userpo->uid),
                  i ? "accepted" : "rejected");
      fclose(fp);
    }
  }
  userpo->status = US_CCP;
}

/*
 * CTEXT mit mehr Moeglichkeiten (wie prompt)
 */
static void out_ctext(char *name, MBHEAD *mbp)
{
 FILE *fp;
 char line[128], *c;

  if ((fp = xfopen(name, "rt")) != NULL) {
    while (fgets(line, 126, fp) != NULL) {
      if ((c = strchr(line, '\n')) != NULL)
        *c = CR;
      prompt2str(mbp, line);
    }
    fclose(fp);
  }
}

/*
 * Einstiegsport des User feststellen fuer LOOP-Warning
 */
int userport(USRBLK *u)
{
  CIRBLK *cirp;
  LNKBLK *lnkp;
  PEER   *pp;

  /* Einstiegsport des Users feststellen (fuer LOOP-Warning) */
  switch (g_utyp(u->uid)) {
    case L4_USER:  /* User ist Circuit    */
      cirp = (CIRBLK *) g_ulink(u->uid);
      if (find_best_qual((int)(cirp->l3node - netp->nodetab), &pp, DG) > 0)
        return(pp->l2link->port);
      break;

    case L2_USER:  /* User ist L2-Link    */
      lnkp = (LNKBLK *) g_ulink(u->uid);
      return(lnkp->liport);
  }
  return(L2PNUM); /* Defaultport */
}

/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
void send_ctext(void)
{
  BOOLEAN ok = FALSE;
  UWORD   port = 0;
  MBHEAD *mbp;
  char    file[14];
  char    name[MAXPATH];
  UBYTE   typ = g_utyp(userpo->uid);
  CIRBLK *cp;
  LNKBLK *lp;

  /*
   * Wenn eine Verbindung als Digipeating reinkommt, setzen wir den
   * Status entsprechend und senden kein CTEXT.
   */
  if (typ == L2_USER) {
    lp = g_ulink(userpo->uid);
    if (lp->state == L2SHTH) {
      userpo->status = US_DIG;
      return;
    }
  } else
  if (typ == L4_USER) {

    cp = g_ulink(userpo->uid);
    if (cmpid(cp->destca,myid) == FALSE) {
      userpo->status = US_DIG;
      return;
    }
  }

  /*
   * Der CTEXT wird abhaengig vom Port gesendet.
   */
  port = userport(userpo);

  /* Jedes Rufzeichen, das wir in der Nodes-Liste finden, begruessen
   * wir ueberhaupt nicht. */
  if (find_node_ssid_range(calofs(UPLINK, userpo->uid)) != -1)
    return;

  if (port == L2PNUM)                   /* HOST                         */
    ok = TRUE;
  else
    if (ctextenabled(port))
      ok = TRUE;

  mbp = getmbp();

  if (ok) {
    putstr (loginstr,mbp);
    sprintf(name, "%sCTEXT.TXT", textpath);
    out_ctext(name, mbp);

    /* sende nun  CTEXT.Port  */
    sprintf(name, "%sCTEXT.%u", textpath, port);
    out_ctext(name, mbp);

    /*  Digimail Text(e), falls File "CALL.MSG" vorhanden */
    callss2str(file,calofs(UPLINK, userpo->uid));
    sprintf(name, "%s%s.MSG", msgpath, file);
    if (xaccess(name, 0) == 0) {
      putstr("\r", mbp);
      seteom(mbp);
      ccpread(name);
      return;                       /* nicht nochmal Prompt             */
    }
  }  /* kein CTEXT gewuenscht .. dann nur Prompt  */

  putchr('\r', mbp);
  prompt(mbp);
  seteom(mbp);
}

/*
 * Manche Befehle erhalten die Anwort erst ein bischen spaeter (PING,
 * DEST, NRR usw), deshalb mit besonderer Vorsicht ausgeben.
 */
void send_async_response(USRBLK *ublk, const char *title, const char *text) {
  MBHEAD *mbp;
  USRBLK *up;
  LHEAD   mbhd;

  /* Antwort generieren und an den User senden                      */
  for (up = (USRBLK *) usccpl.head;
       (USRBLK *) &usccpl != up;
       up = (USRBLK *) up->unext)
  {
    if (up == ublk)
      /* das ist der gesuchte User, darf er die Antwort bekommen? */
      if ((up->status == US_CCP || up->status == US_TALK))
      {
        (mbp = (MBHEAD *)allocb())->l2fflg = L2CPID; /* tnx DB2OS */
        putchr('\r', mbp);
        putalt(alias, mbp);
        putid(myid, mbp);
        putstr("> ", mbp);
        putstr(title, mbp);
        putstr(text, mbp);
        putchr('\r', mbp);
        rwndmb(mbp);
        inithd(&mbhd);
        relink((LEHEAD *)mbp, (LEHEAD *)mbhd.tail);
        itousr(up->uid, NO_UID, FALSE, mbp);
      }
  }
}

/************************************************************************/
/* Parameternummer aus Namen ermitteln                                           */
/*----------------------------------------------------------------------*/
static UWORD getparnum(PARAM *partab, int len)
{
  size_t l;
  UWORD  num;
  PARAM  *p;

  for (p = partab, num = 1; num <= len; p++, num++)
    if (p->paradr) {
      l = strlen(p->parstr);
      if (!strnicmp(p->parstr, clipoi, l)) {
        clipoi += l;
        clicnt -= (WORD)l;
        return(num);
      }
    }
  return(0);
}

/* Interpreter fuer einfache Parametertabellen.
 */
void ccp_par(const char *name, PARAM *partab, int len)
{
  int     i;
  UWORD   parnum;
  MBHEAD *mbp;
  PARAM  *parpoi;
  UWORD   nummer;
  UWORD   wert;

  nummer = 0;
  if (issyso())
  {
    if (!isdigit(*clipoi))
      nummer = getparnum(partab, len);
    else
      nummer = nxtnum(&clicnt, &clipoi);
  }

  if (nummer != 0 && nummer <= len)
  {
    parpoi = partab + nummer-1;
    if (   clicnt != 0
        && ((wert = nxtnum(&clicnt, &clipoi)) >= parpoi->minimal)
        && (wert <= parpoi->maximal)
       )
      *(parpoi->paradr) = wert;
    mbp = putals(name);
    putprintf(mbp, "%u: %s = %u (%u...%u)\r", nummer, parpoi->parstr,
          *(parpoi->paradr), parpoi->minimal, parpoi->maximal);
  } else {
    mbp = putals(name);

    mbp->l4time = mbp->mbpc;
    for (i = 0, parnum = 1, parpoi = partab;
         parnum <= len;  ++i, ++parnum, ++parpoi)
    {
      if (i >= 3) {
        putchr('\r', mbp);
        mbp->l4time = mbp->mbpc;
        i = 0;
      } else
        putspa(25 * i, mbp);
      putprintf(mbp, "%02u:%-12s %5u", parnum, parpoi->parstr, *(parpoi->paradr));
    }
    putchr('\r', mbp);
  }
  prompt(mbp);
  seteom(mbp);
}

/* Rufzeichen eintragen/Austragen.
 */
void ccp_call(char *id)
{
  if (!issyso())
    invmsg();

  if (*clipoi == '-')             /* Call austragen? */
    id[0] = '\0';
  else
    if (!getcal(&clicnt, &clipoi, TRUE, id)) { /* ein Call ? */
      putmsg("Invalid call\r");
    } else {
      MBHEAD *mbp = getmbp();
      prompt(mbp);
      seteom(mbp);
    }
}

/* Fuer den L4 feststellen, wie gross fragmentierte Frames sein duerfen */

int
ptc_p_max(void *link, UBYTE typ)
{
  UID     p_uid;

  p_uid = (ptctab + g_uid(link, typ))->p_uid;
  if (p_uid == NO_UID) return(256);
  if (g_utyp(p_uid) == L4_USER)
    return(236);
  return(256);
}

/* Ende src/l7utils.c */
