/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
* Default-Parameter fuer TheNet und TheBoxware.				 *
*									 *
* Achtung! die Reihenfolge muss mit den RAM-Adressen uebereinstimmen!	 *
*									 *
* Dieses Modul wird von L1.C geladen und zwar im Anschluss an die	 *
* Deklaration der RAM-Variablen des L1.					 *
*									 *
\************************************************************************/

#ifdef BOXWARE
#asm
		public	defIp?, defID?

defIp?:		db	'      ',60h	; eigenes Rufzeichen
defID?:		db	'      '	; mnemonischer Name
#endasm
#else
#asm
		public	myid?, nodID0?, nodID1?

myid?:		db	'NO1DE ','0'*2	; Call des TNC
nodID0?:	db	'THENET'	; Ident des TNC auf dem HDLC-Port
nodID1?:	db	'THENET'	; Ident des TNC auf dem RS232-Port
#endasm
#endif

#ifdef BOXWARE
char	myid[7];
#endif

char	alias[6];

#ifndef BOXWARE
char	 alias0[6];
char	 alias1[6];
#endif

/************************************************************************\
*									 *
* Hier werden die Default-Parameter und die dazugehoerenden RAM-	 *
* Variablen definiert. Die initialisierten konstanten Daten werden dabei *
* im EPROM gespeichert, die jeweils direkt anschliessend (in der selben	 *
* Zeile) deklarierten Variablen werden beim Kaltstart (mit Blockmove)	 *
* auf die EPROM-Werte gesetzt.						 *
*									 *
\************************************************************************/


/* Parameter 1 - Hoechstzahl Eintraege in der Nodesliste		*/
unsigned defDES = 80;		unsigned maxdes;

/* Parameter 2 - minimale Qualitaet fuer automatisches Update		*/
unsigned defWQU = 30;		unsigned worqua;

/* Parameter 3 - HDLC Kanal Qualitaet					*/
unsigned defCH0 = 50;		unsigned ch0qua;

#ifndef BOXWARE
/* TheNet: Parameter 4 - RS232 Kanal Qualitaet				*/
unsigned defCH1 = 100;		unsigned ch1qua;
#endif

/* TheNet: Par. 5, TheBoxware: Par. 4 - Anfangswert Knotenlebensdauer	*/
unsigned defOBC = 6;		unsigned obcini;

#ifndef BOXWARE
/* TheNet: Parameter 6 - Restlebensdauer fuer Rundspruch		*/
unsigned defOBB = 5;		unsigned obcbro;
#endif

/* TheNet: Par. 7, TheBoxware: Par. 5 - Rundspruchintervall		*/
unsigned defBRI = 600;		unsigned broint;

/* TheNet: Par. 8, TheBoxware: Par. 6 - Anfangswert Paketlebensdauer	*/
unsigned defTLI = 30;		unsigned timliv;

/* TheNet: Par. 9; TheBoxware: Par. 7 - Timeout in Level4		*/
unsigned defTTO = 300;		unsigned tratou;

/* TheNet: Par. 10; TheBoxware: Par. 8 - Versuche in Level4		*/
unsigned defTTR = 2;		unsigned tratri;

/* TheNet: Par. 11; TheBoxware: Par. 9 - Level4 Wartezeit bis ACK	*/
unsigned defTAC = 3;		unsigned traack;

/* TheNet: Par. 12; TheBoxware: Par. 10 - Level4 Busy Wartezeit		*/
unsigned defTBS = 180;		unsigned trabsy;

/* TheNet: Par. 13; TheBoxware: Par. 11 - Fenstergroesse in Level4	*/
unsigned defTWI = 4;		unsigned trawir;

/* TheNet: Par. 14; TheBoxware: Par. 12 - gebufferte Frames/Verbindung	*/
unsigned defCON = 4;		unsigned conctl;

/* TheNet: Par. 15; TheBoxware: Par. 13 - no-activity-timeout		*/
unsigned defNOA = 900;		unsigned ininat;

/* TheNet: Par. 16; TheBoxware: Par. 14 - P-Persistance-Wert		*/
unsigned defPER = 32;		unsigned Ppar;

/* TheNet: Par. 17; TheBoxware: Par. 15 - Zeitschlitzbreite		*/
unsigned defSLO = 10;		unsigned Wpar;

/* TheNet: Par. 18; TheBoxware: Par. 16 - Level 2, Timer 1 (Frack)	*/
unsigned defRAK = 5;		unsigned Fpar;

/* TheNet: Par. 19; TheBoxware: Par. 17 - Level 2, Fenstergroesse	*/
unsigned defMAF = 3;		unsigned Opar;

/* TheNet: Par. 20; TheBoxware: Par. 18 - Level 2, Versuche		*/
unsigned defL2T = 10;		unsigned Npar;

/* TheNet: Par. 21; TheBoxware: Par. 19 - Level 2, Timer 2		*/
unsigned defLT2 = 200;		unsigned T2par;

/* TheNet: Par. 22; TheBoxware: Par. 20 - Level 2, Timer 3		*/
unsigned defLT3 = 18000;	unsigned T3par;

#ifndef BOXWARE
/* TheNet: Parameter 23 - Level 2 Digipeating Freigabe			*/
unsigned defRPA = 1;		unsigned Rpar;
#endif

/* TheNet: Par. 24; TheBoxware: Par. 21 - Calls pruefen			*/
unsigned defVAL = 1;		unsigned VCpar;

#ifndef BOXWARE
/* TheNet: Parameter 25 - Bakenmodus					*/
unsigned defBEA = 2;		unsigned beacen;

/* TheNet: Parameter 26 - CQ-UI-Frame Freigabe				*/
unsigned defCQ  = 1;		unsigned cqen;
#endif

/* TheNet: Par. 27; TheBoxware: Par. 22 - Vollduplex			*/
unsigned defDPA = 0;		unsigned Dpar;

/* TheNet: Par. 28; TheBoxware: Par. 23 - Flags in Sendepausen		*/
unsigned defXFP = 0;		unsigned xFpar;

#ifdef BOXWARE
/* TheBoxware: Parameter 24 - PTT Freigabe				*/
unsigned defXp  = 1;		unsigned Xpar;
#endif

/* TheNet: Par. 29; TheBoxware: Par. 25 - Senderverzoegerung		*/
unsigned defTp  = 30;		unsigned Tpar;

#ifndef BOXWARE
/* TheNet: Parameter 30 - Systemflags					*/
unsigned defFLG = 1280;		unsigned Flags;

/* TheNet: Parameter 31 - min. freie Buffer fuer CCP-Freigabe		*/
unsigned defMBU = 256;		unsigned minbuf;

/* TheNet: Parameter 32 - Sonderzeichen fuer Info-Befehl		*/
unsigned defLCA = '\\';		unsigned lincar;
#else

/* TheBoxware: Parameter 26 - Hoechstzahl Connects von Aussen		*/
unsigned defMXC = NUMCIR;	unsigned maxcir;
#endif

/* TheNet: Par. 33; TheBoxware: Par. 27 - eigene Qualitaet		*/
unsigned defMYQ = 0;		unsigned myqua;

#ifndef BOXWARE
/* TheNet: Parameter 34 - Hoechstzahl Uplinks				*/
unsigned defYp  = LINKNMBR;	unsigned Ypar;

/* TheNet: Parameter 35 - Level 2, Timer 1 fuer RS-232-Port		*/
unsigned defRA1 = 1;		unsigned Fpar1;

/* TheNet: Parameter 36 - Level 2, Timer 2 fuer RS-232-Port		*/
unsigned defT2R = 20;		unsigned T2par1;

/* TheNet: Parameter 37 - Level 2 Fenstergroesse fuer RS-232-Port	*/
unsigned defMA1 = 7;		unsigned Opar1;

/* TheNet: Parameter 38 - Anfangsstunde Level-2-Protokollaenderung	*/
unsigned defMIH = 0;		unsigned minhr;

/* TheNet: Parameter 39 - Endstunde Level-2-Protokollaenderung		*/
unsigned defMAH = 0;		unsigned maxhr;

char defPWD[80] = {'1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0',
		   '1','2','3','4','5','6','7','8','9','0' };

#else

/* TheBoxware: Monitor-Parameter					*/
/*	Bit 0 - I-Frames						*/
/*	Bit 1 - UI-Frames						*/
/*	Bit 2 - Supervisory-Frames					*/
/*	Bit 3 - Monitor waehrend connectet				*/
unsigned defMp = 0;		unsigned Mpar;

unsigned defM7 = 0;
#endif

unsigned Hugo;			/* Fuer direkte Parameteruebergabe	     */

/*****************************************************************************\
*									      *
* sdefpa()	setzen der Default Parameter beim Kaltstart		      *
*									      *
* parameter:	-							      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/


sdefpa()
 {
#ifdef BOXWARE
#asm
    push BC
    ld	HL,defIp?
    ld 	DE,myid?
    ld	BC,Hugo?-myid?
    ldir
    pop BC
#endasm
#else
#asm
    push BC
    ld	HL,nodID0?
    ld 	DE,alias0?
    ld	BC,Hugo?-alias0?
    ldir
    pop BC
#endasm

 cpycal(alias,alias0);	/* Beim Kaltstart immer HDLC-Ident fuer Useranzeige  */
#endif

}
