/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*                                                                        *
*                                                                        *
*    L2S.C   -   Level 2 Statetable                                      *
*                                                                        *
*    angelegt:      DC4OX                                                *
*    modifiziert:   DF6LN   300990  l2stma aus L2B.C -> L2S.C            *
*                                   Statetable komprimiert               *
*                   DF6LN   120191  stbl22 geaendert                     *
*                                                                        *
\************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "l2ext.h"


/*                                                              Defines   */
/**************************************************************************/

#define NUMSTATS 16           /* Anzahl States AX.25 Level 2              */

/**************************************************************************/
/*            Defines fuer zusaetzliche Zustandstabelle                   */
/*                                                                        */
/*      Name            Routine          neuer Zustand                    */
/*                                                                        */
#define XDMDSCED 0   /*    xdm              L2SDSCED                      */
#define XDMDSCRQ 1   /*    xdm              L2SDSCRQ                      */
#define NULDSCED 2   /*    xnull            L2SDSCED                      */
#define NULLKSUP 3   /*    xnull            L2SLKSUP                      */
#define NULFRREJ 4   /*    xnull            L2SFRREJ                      */
#define NULDSCRQ 5   /*    xnull            L2SDSCRQ                      */
#define NULIXFER 6   /*    xnull            L2SIXFER                      */
#define NULRS    7   /*    xnull            L2SRS                         */
#define NULWA    8   /*    xnull            L2SWA                         */
#define NULDBS   9   /*    xnull            L2SDBS                        */
#define NULRBS   10  /*    xnull            L2SRBS                        */
#define NULBBS   11  /*    xnull            L2SBBS                        */
#define NULWADBS 12  /*    xnull            L2SWADBS                      */
#define NULWARBS 13  /*    xnull            L2SWARBS                      */
#define NULWABBS 14  /*    xnull            L2SWABBS                      */
#define NULRSDBS 15  /*    xnull            L2SRSDBS                      */
#define NULRSRBS 16  /*    xnull            L2SRSRBS                      */
#define NULRSBBS 17  /*    xnull            L2SRSBBS                      */
#define XFRFRREJ 18  /*    xfrmr            L2SFRREJ                      */
#define XRRIXFER 19  /*    xrrr             L2SIXFER                      */
#define XRRRS    20  /*    xrrr             L2SRS                         */
#define XRRWA    21  /*    xrrr             L2SWA                         */
#define XRRRBS   22  /*    xrrr             L2SRBS                        */
#define XRRWARBS 23  /*    xrrr             L2SWARBS                      */
#define XRRRSRBS 24  /*    xrrr             L2SRSRBS                      */
#define XNRDBS   25  /*    xrnrr            L2SDBS                        */
#define XNRBBS   26  /*    xrnrr            L2SBBS                        */
#define XNRWADBS 27  /*    xrnrr            L2SWADBS                      */
#define XNRWABBS 28  /*    xrnrr            L2SWABBS                      */
#define XNRRSDBS 29  /*    xrnrr            L2SRSDBS                      */
#define XNRRSBBS 30  /*    xrnrr            L2SRSBBS                      */
#define TRRIXFER 31  /*    t2rrr            L2SIXFER                      */
#define TRRRS    32  /*    t2rrr            L2SRS                         */
#define TRRWA    33  /*    t2rrr            L2SWA                         */
#define TRRRBS   34  /*    t2rrr            L2SRBS                        */
#define TRRWARBS 35  /*    t2rrr            L2SWARBS                      */
#define TRRRSRBS 36  /*    t2rrr            L2SRSRBS                      */
#define TNRDBS   37  /*    t2rnrr           L2SDBS                        */
#define TNRBBS   38  /*    t2rnrr           L2SBBS                        */
#define TNRWADBS 39  /*    t2rnrr           L2SWADBS                      */
#define TNRWABBS 40  /*    t2rnrr           L2SWABBS                      */
#define TNRRSDBS 41  /*    t2rnrr           L2SRSDBS                      */
#define TNRRSBBS 42  /*    t2rnrr           L2SRSBBS                      */
#define XUADSCED 43  /*    xua              L2SDSCED                      */
#define XUAIXFER 44  /*    xua              L2SIXFER                      */
#define XUADBS   45  /*    xua              L2SDBS                        */
#define XSALKSUP 46  /*    xsabm            L2SLKSUP                      */
#define XDIDSCRQ 47  /*    xdisc            L2SDSCRQ                      */
#define XRCWA    48  /*    xrrc             L2SWA                         */
#define XRCWARBS 49  /*    xrrc             L2SWARBS                      */
#define XNCWADBS 50  /*    xrnrc            L2SWADBS                      */
#define XNCWABBS 51  /*    xrnrc            L2SWABBS                      */
#define TJRRS    52  /*    t2rejr           L2SRS                         */
#define TJRRSRBS 53  /*    t2rejr           L2SRSRBS                      */
#define XJRRS    54  /*    xrejr            L2SRS                         */
#define XJRWA    55  /*    xrejr            L2SWA                         */
#define XJRWARBS 56  /*    xrejr            L2SWARBS                      */
#define XJRRSRBS 57  /*    xrejr            L2SRSRBS                      */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/*                 L2-Linkzustaende                                       */
/*                                                                        */
/*      Name         Linkzustand                                          */
/*                                                                        */
/*    0 L2SDSCED  -  disconnected                                         */
/*    1 L2SLKSUP  -  link setup                                           */
/*    2 L2SFRREJ  -  frame reject                                         */
/*    3 LS2DSCRQ  -  disconnect request                                   */
/*    4 L2SIXFER  -  information transfer                                 */
/*    5 L2SRS     -  REJ sent                                             */
/*    6 L2SWA     -  waiting acknowledge                                  */
/*    7 L2SDBS    -  device busy                                          */
/*    8 L2SRBS    -  remote busy                                          */
/*    9 L2SBBS    -  both busy                                            */
/*   10 L2SWADBS  -  waiting ack and device busy                          */
/*   11 L2SWARBS  -  waiting ack and remote busy                          */
/*   12 L2SWABBS  -  waiting ack and both busy                            */
/*   13 L2SRSDBS  -  REJ sent and device busy                             */
/*   14 L2SRSRBS  -  REJ sent and remote busy                             */
/*   15 L2SRSBBS  -  REJ sent and both busy                               */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/*     Externals: auszufuehrende Routine                                  */
/**************************************************************************/
/*                                                                        */
extern xdm();         /*  DM senden                                       */
extern xnull();       /*  nix zu tun                                      */
extern xfrmr();       /*  FRMR senden                                     */
extern xrrr();        /*  RR als Response senden                          */
extern xrnrr();       /*  RNR als Response senden                         */
extern t2rrr();       /*  RR als Response senden und Timer T2 starten     */
extern t2rnrr();      /*  RNR als Response senden und Timer T2 starten    */
extern xua();         /*  UA senden                                       */
extern xsabm();       /*  SABM senden                                     */
extern xdisc();       /*  DISC senden                                     */
extern xrrc();        /*  RR als Command senden                           */
extern xrnrc();       /*  RNR als Command senden                          */
extern t2rejr();      /*  REJ als Response senden und Timer T2 starten    */
extern xrejr();       /*  REJ als Response senden                         */



/**************************************************************************\
*                                                                          *
*  Zusaetzliche Zustandstabelle - wird ueber laufende Nummer angesprochen  *
*                                                                          *
\**************************************************************************/

STENT stblx[] =
  {

/* XDMDSCED */    { xdm,      L2SDSCED },
/* XDMDSCRQ */    { xdm,      L2SDSCRQ },
/* NULDSCED */    { xnull,    L2SDSCED },
/* NULLKSUP */    { xnull,    L2SLKSUP },
/* NULFRREJ */    { xnull,    L2SFRREJ },
/* NULDSCRQ */    { xnull,    L2SDSCRQ },
/* NULIXFER */    { xnull,    L2SIXFER },
/* NULRS    */    { xnull,    L2SRS    },
/* NULWA    */    { xnull,    L2SWA    },
/* NULDBS   */    { xnull,    L2SDBS   },
/* NULRBS   */    { xnull,    L2SRBS   },
/* NULBBS   */    { xnull,    L2SBBS   },
/* NULWADBS */    { xnull,    L2SWADBS },
/* NULWARBS */    { xnull,    L2SWARBS },
/* NULWABBS */    { xnull,    L2SWABBS },
/* NULRSDBS */    { xnull,    L2SRSDBS },
/* NULRSRBS */    { xnull,    L2SRSRBS },
/* NULRSBBS */    { xnull,    L2SRSBBS },
/* XFRFRREJ */    { xfrmr,    L2SFRREJ },
/* XRRIXFER */    { xrrr,     L2SIXFER },
/* XRRRS    */    { xrrr,     L2SRS    },
/* XRRWA    */    { xrrr,     L2SWA    },
/* XRRRBS   */    { xrrr,     L2SRBS   },
/* XRRWARBS */    { xrrr,     L2SWARBS },
/* XRRRSRBS */    { xrrr,     L2SRSRBS },
/* XNRDBS   */    { xrnrr,    L2SDBS   },
/* XNRBBS   */    { xrnrr,    L2SBBS   },
/* XNRWADBS */    { xrnrr,    L2SWADBS },
/* XNRWABBS */    { xrnrr,    L2SWABBS },
/* XNRRSDBS */    { xrnrr,    L2SRSDBS },
/* XNRRSBBS */    { xrnrr,    L2SRSBBS },
/* TRRIXFER */    { t2rrr,    L2SIXFER },
/* TRRRS    */    { t2rrr,    L2SRS    },
/* TRRWA    */    { t2rrr,    L2SWA    },
/* TRRRBS   */    { t2rrr,    L2SRBS   },
/* TRRWARBS */    { t2rrr,    L2SWARBS },
/* TRRRSRBS */    { t2rrr,    L2SRSRBS },
/* TNRDBS   */    { t2rnrr,   L2SDBS   },
/* TNRBBS   */    { t2rnrr,   L2SBBS   },
/* TNRWADBS */    { t2rnrr,   L2SWADBS },
/* TNRWABBS */    { t2rnrr,   L2SWABBS },
/* TNRRSDBS */    { t2rnrr,   L2SRSDBS },
/* TNRRSBBS */    { t2rnrr,   L2SRSBBS },
/* XUADSCED */    { xua,      L2SDSCED },
/* XUAIXFER */    { xua,      L2SIXFER },
/* XUADBS   */    { xua,      L2SDBS   },
/* XSALKSUP */    { xsabm,    L2SLKSUP },
/* XDIDSCRQ */    { xdisc,    L2SDSCRQ },
/* XRCWA    */    { xrrc,     L2SWA    },
/* XRCWARBS */    { xrrc,     L2SWARBS },
/* XNCWADBS */    { xrnrc,    L2SWADBS },
/* XNCWABBS */    { xrnrc,    L2SWABBS },
/* TJRRS    */    { t2rejr,   L2SRS    },
/* TJRRSRBS */    { t2rejr,   L2SRSRBS },
/* XJRRS    */    { xrejr,    L2SRS    },
/* XJRWA    */    { xrejr,    L2SWA    },
/* XJRWARBS */    { xrejr,    L2SWARBS },
/* XJRRSRBS */    { xrejr,    L2SRSRBS }

  };

/**************************************************************************\
*                                                                          *
*   I WITH POLL (COMMAND)                                                  *
*                                                                          *
\**************************************************************************/

/*STENTRY stbl00[NUMSTATS] =
  {*/
/* L2SDSCED ->  XDMDSCED, *//* DM senden -> disconnected                  */
/* L2SLKSUP ->  NULLKSUP, *//* nix tun   -> Linksetup                     */
/* L2SFRREJ ->  XFRFRREJ, *//* FRMR senden -> Frame Reject                */
/* LS2DSCRQ ->  XDMDSCRQ, *//* DM senden -> Disc Request                  */
/* L2SIXFER ->  XRRIXFER, *//* RR Response senden -> Info Transfer        */
/* L2SRS    ->  XRRIXFER, *//* RR Response senden -> Info Transfer        */
/* L2SWA    ->  XRRWA,    *//* RR Response senden -> waiting ACK          */
/* L2SDBS   ->  XNRDBS,   *//* RNR Response senden -> device busy         */
/* L2SRBS   ->  XRRRBS,   *//* RR Response senden -> remote busy          */
/* L2SBBS   ->  XNRBBS,   *//* RNR Response senden -> both busy           */
/* L2SWADBS ->  XNRWADBS, *//* RNR Resp. senden -> wait. ACK, device busy */
/* L2SWARBS ->  XRRWARBS, *//* RR Resp. senden -> wait. ACK, remote busy  */
/* L2SWABBS ->  XNRWABBS, *//* RNR Resp. senden -> wait. ACK, both busy   */
/* L2SRSDBS ->  XNRRSDBS, *//* RNR Resp. senden -> REJ sent, device busy  */
/* L2SRSRBS ->  XRRRBS,   *//* RR Resp. senden -> remote busy             */
/* L2SRSBBS ->  XNRRSBBS  *//* RNR Resp. senden -> REJ sent, both busy
  };*/



/**************************************************************************\
*                                                                          *
* I WITHOUT POLL (COMMAND)                                                 *
*                                                                          *
\**************************************************************************/

STENTRY stbl01[NUMSTATS] =
  {
/* L2SDSCED -> */     NULDSCED,
/* L2SLKSUP -> */     NULLKSUP,
/* L2SFRREJ -> */     NULFRREJ,
/* LS2DSCRQ -> */     NULDSCRQ,
/* L2SIXFER -> */     TRRIXFER,
/* L2SRS    -> */     TRRIXFER,
/* L2SWA    -> */     TRRWA,
/* L2SDBS   -> */     TNRDBS,
/* L2SRBS   -> */     TRRRBS,
/* L2SBBS   -> */     TNRBBS,
/* L2SWADBS -> */     TNRWADBS,
/* L2SWARBS -> */     TRRWARBS,
/* L2SWABBS -> */     TNRWABBS,
/* L2SRSDBS -> */     TNRRSDBS,
/* L2SRSRBS -> */     TRRRBS,
/* L2SRSBBS -> */     TNRRSBBS
  };




/**************************************************************************\
*                                                                          *
* RR WITH POLL (COMMAND)                                                   *
*                                                                          *
\**************************************************************************/

STENTRY stbl02[NUMSTATS] =
  {
    XDMDSCED,
    NULLKSUP,
    XFRFRREJ,
    XDMDSCRQ,
    XRRIXFER,
    XRRRS,
    XRRWA,
    XNRDBS,
    XRRIXFER,
    XNRDBS,
    XNRWADBS,
    XRRWA,
    XNRWADBS,
    XNRRSDBS,
    XRRRS,
    XNRRSDBS
  };



/**************************************************************************\
*                                                                          *
*   RR WITHOUT POLL (COMMAND)                                              *
*                                                                          *
\**************************************************************************/

STENTRY stbl03[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    NULFRREJ,
    NULDSCRQ,
    NULIXFER,
    NULRS,
    NULWA,
    NULDBS,
    NULIXFER,
    NULDBS,
    NULWADBS,
    NULWA,
    NULWADBS,
    NULRSDBS,
    NULRS,
    NULRSDBS
  };



/**************************************************************************\
*                                                                          *
*   RNR WITH POLL (COMMAND)                                                *
*                                                                          *
\**************************************************************************/

STENTRY stbl06[NUMSTATS] =
  {
    XDMDSCED,
    NULLKSUP,
    XFRFRREJ,
    XDMDSCRQ,
    XRRRBS,
    XRRRSRBS,
    XRRWARBS,
    XNRBBS,
    XRRRBS,
    XNRBBS,
    XNRWABBS,
    XRRWARBS,
    XNRWABBS,
    XNRRSBBS,
    XRRRSRBS,
    XNRRSBBS
  };



/**************************************************************************\
*                                                                          *
*   RNR WITHOUT POLL (COMMAND)                                             *
*                                                                          *
\**************************************************************************/

STENTRY stbl07[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    NULFRREJ,
    NULDSCRQ,
    NULRBS,
    NULRSRBS,
    NULWARBS,
    NULBBS,
    NULRBS,
    NULBBS,
    NULWABBS,
    NULWARBS,
    NULWABBS,
    NULRSBBS,
    NULRSRBS,
    NULRSBBS
  };



/**************************************************************************\
*                                                                          *
*   SABM EITHER (COMMAND)                                                  *
*                                                                          *
\**************************************************************************/

STENTRY stbl08[NUMSTATS] =
  {
    XUAIXFER,
    XUAIXFER,
    XUAIXFER,
    XUADSCED,
    XUAIXFER,
    XUAIXFER,
    XUAIXFER,
    XUADBS,
    XUAIXFER,
    XUADBS,
    XUADBS,
    XUAIXFER,
    XUADBS,
    XUADBS,
    XUAIXFER,
    XUAIXFER
  };



/**************************************************************************\
*                                                                          *
*   DISC EITHER (COMMAND)                                                  *
*                                                                          *
\**************************************************************************/

STENTRY stbl09[NUMSTATS] =
  {
    XDMDSCED,
    XDMDSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED,
    XUADSCED
  };



/**************************************************************************\
*                                                                          *
*   RR WITH FINAL (RESPONSE)                                               *
*                                                                          *
\**************************************************************************/

STENTRY stbl10[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    NULFRREJ,
    NULDSCRQ,
    NULIXFER,
    NULRS,
    NULIXFER,
    NULDBS,
    NULIXFER,
    NULDBS,
    NULDBS,
    NULIXFER,
    NULDBS,
    NULRSDBS,
    NULRS,
    NULRSDBS
  };



/**************************************************************************\
*                                                                          *
*   RNR WITH FINAL (RESPONSE)                                              *
*                                                                          *
\**************************************************************************/

STENTRY stbl14[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    NULFRREJ,
    NULDSCRQ,
    NULRBS,
    NULRSRBS,
    NULRBS,
    NULBBS,
    NULRBS,
    NULBBS,
    NULBBS,
    NULRBS,
    NULBBS,
    NULRSBBS,
    NULRSRBS,
    NULRSBBS
  };



/**************************************************************************\
*                                                                          *
* UA EITHER (RESPONSE)                                                     *
*                                                                          *
\**************************************************************************/

STENTRY stbl16[NUMSTATS] =
  {
    NULDSCED,
    NULIXFER,
    NULFRREJ,
    NULDSCED,
    NULIXFER,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP
  };



/**************************************************************************\
*                                                                          *
* DM EITHER (RESPONSE)                                                     *
*                                                                          *
\**************************************************************************/

STENTRY stbl17[NUMSTATS] =
  {
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED,
    NULDSCED
  };



/**************************************************************************\
*                                                                          *
*   FRMR EITHER (RESPONSE)                                                 *
*                                                                          *
\**************************************************************************/

STENTRY stbl18[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    XSALKSUP,
    NULDSCRQ,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP,
    XSALKSUP
  };



/**************************************************************************\
*                                                                          *
* STATION BECOMES BUSY                                                     *
*                                                                          *
\**************************************************************************/

STENTRY stbl21[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    NULFRREJ,
    NULDSCRQ,
    TNRDBS,
    TNRRSDBS,
    TNRWADBS,
    NULDBS,
    TNRBBS,
    NULBBS,
    NULWADBS,
    TNRWABBS,
    NULWABBS,
    NULRSDBS,
    TNRRSBBS,
    NULRSBBS
  };



/**************************************************************************\
*                                                                          *
* BUSY CONDITION CLEARS                                                    *
*                                                                          *
* geaendert: RR mit Poll senden und T1 starten. Dadurch wird sicherge-     *
* stellt, dass die Gegenstation vom neuen Linkzustand erfaehrt.            *
*                                                                          *
\**************************************************************************/

STENTRY stbl22[NUMSTATS] =
  {
    NULDSCED,              /*  0 L2SDSCED - disconnected                  */
    NULLKSUP,              /*  1 L2SLKSUP - link setup                    */
    NULFRREJ,              /*  2 L2SFRREJ - frame reject                  */
    NULDSCRQ,              /*  3 LS2DSCRQ - disconnect request            */
    NULIXFER,              /*  4 L2SIXFER - information transfer          */
    NULRS,                 /*  5 L2SRS    - REJ sent                      */
    NULWA,                 /*  6 L2SWA    - waiting acknowledge           */
    XRCWA,                 /*  7 L2SDBS   - device busy                   */
    XRCWARBS,              /*  8 L2SRBS   - remote busy                   */
    XRCWARBS,              /*  9 L2SBBS   - both busy                     */
    XRCWA,                 /* 10 L2SWADBS - waiting ack and device busy   */
    XRCWARBS,              /* 11 L2SWARBS - waiting ack and remote busy   */
    XRCWARBS,              /* 12 L2SWABBS - waiting ack and both busy     */
    XRCWA,                 /* 13 L2SRSDBS - REJ sent and device busy      */
    XRCWARBS,              /* 14 L2SRSRBS - REJ sent and remote busy      */
    XRCWARBS               /* 15 L2SRSBBS - REJ sent and both busy        */
  };


/**************************************************************************\
*                                                                          *
* T1 EXPIRES (VERSION 2)                                                   *
*                                                                          *
\**************************************************************************/

STENTRY stbl23[NUMSTATS] =
  {
    NULDSCED,
    XSALKSUP,
    XFRFRREJ,
    XDIDSCRQ,
    XRCWA,
    XRCWA,
    XRCWA,
    XNCWADBS,
    XRCWARBS,
    XNCWABBS,
    XNCWADBS,
    XRCWARBS,
    XNCWABBS,
    XNCWADBS,
    XRCWARBS,
    XNCWADBS
  };



/**************************************************************************\
*                                                                          *
*   T3 EXPIRES                                                             *
*                                                                          *
\**************************************************************************/

STENTRY stbl24[NUMSTATS] =
  {
    NULDSCED,
    XSALKSUP,
    XFRFRREJ,
    XDIDSCRQ,
    XRCWA,
    XRCWA,
    NULWA,
    XNCWADBS,
    XRCWARBS,
    XNCWABBS,
    NULWADBS,
    NULWARBS,
    NULWABBS,
    XNCWADBS,
    XRCWARBS,
    XNCWADBS
  };



/**************************************************************************\
*                                                                          *
*   INVALID N(S) RECEIVED WITHOUT POLL                                     *
*                                                                          *
\**************************************************************************/

STENTRY stbl26[NUMSTATS] =
  {
    NULDSCED,
    NULLKSUP,
    NULFRREJ,
    NULDSCRQ,
    TJRRS,
    NULRS,
    NULWA,
    TNRDBS,
    TJRRSRBS,
    TNRBBS,
    NULWADBS,
    NULWARBS,
    NULWABBS,
    TNRRSDBS,
    NULRSRBS,
    TNRRSBBS
  };



/**************************************************************************\
*                                                                          *
*   INVALID N(S) RECEIVED WITH POLL                                        *
*                                                                          *
\**************************************************************************/

STENTRY stb26b[NUMSTATS] =
  {
    XDMDSCED,
    NULLKSUP,
    XFRFRREJ,
    XDMDSCRQ,
    XJRRS,
    XJRRS,
    XJRWA,
    XNRDBS,
    XJRRSRBS,
    XNRBBS,
    XNRWADBS,
    XJRWARBS,
    XNRWABBS,
    XNRRSDBS,
    XJRRSRBS,
    XNRRSBBS
  };


/**************************************************************************\
*                                                                          *
* "level 2 state machine"                                                  *
*                                                                          *
* Ausfuehren der Zustandsuebergangsfunktion des Linkstatus (state) des     *
* aktuellen Linkblocks (lnkpoi) in der Statetable stbl, danach einnehmen   *
* des durch die Statetable gegebenen neuen Zustands.                       *
*                                                                          *
* In der Protokollversion 1 (dort gibt es nur 5 Zustaende), alle Zustaende *
* oberhalb Informationstransfer auf Informationstransfer setzen.           *
*                                                                          *
* Komprimierte Tabelle: Zugriff ueber eine Zusatztabelle                   *
*                                                                          *
\**************************************************************************/

VOID l2stma(stbl)
STENTRY stbl[];
 {
  unsigned n;

  n = stbl[lnkpoi->state];
  (*stblx[n].func)();					/* Funktion ...	     */
  lnkpoi->state = stblx[n].newstate;			/* neuer Zustand     */
  if (!lnkpoi->V2link && lnkpoi->state > L2SIXFER)	/* Version 1	     */
    lnkpoi->state = L2SIXFER;				/* Stutzung	     */
 }


/* Ende von L2S.C */
