/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*                                                                        *
*                                                                        *
*    L2V.C   -   Level 2, globale Variable                               *
*                                                                        *
*    angelegt:      DC4OX                                                *
*    modifiziert:                                                        *
*                                                                        *
\************************************************************************/





/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */





/*                                                              Globals   */
/**************************************************************************/

#ifdef BOXFIRM
char        myid[L2IDLEN];    /* Call (normal) + SSID (1 Bit linksgesch.) */
char        alias[L2CALEN];   /* Ident der Station                        */
#else
BOOLEAN     istraf;	      /* TRUE -> Frame gesendet                   */
#endif

char        nmblks;           /* Anzahl aktiver Level-2-Links (1..127)    */

#ifndef BOXWARE
#ifdef FIRMWARE
char        Ypar;	      /* Anzahl moeglicher Links (Y-Befehl)       */
char        Vpar;	      /* 0 = Linkaufbau mit Version 1 Protokoll   */
			      /* 1 = Linkaufbau mit Version 2 Protokoll   */
#endif
#endif

                              /* empfangenes Frame :                      */
char        rxfhdr[L2AFLEN+1];/*   Header (Ziel/Quell/via-Id's), 0-term.  */
char        rxfctl;           /*   Kontrollbyte ohne P/F-Bit              */
char        rxfPF;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
char        rxfV2;            /*   0 = V1-Frame, 1 = V2-Frame             */
char        rxfCR;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x80 = Command-Frame         */
                              /*             0x00 = Response-Frame        */
#ifndef BOXFIRM
char        rxfprt;           /*   0 = HDLC-Frame, 1 = Crosslink-Frame    */

                              /* zu sendendes Frame :                     */
#endif
char        txfhdr[L2AFLEN+1];/*   Header (Ziel/Quell/via-Id's), 0-term.  */
char        txfctl;           /*   Kontrollbyte ohne P/F-Bit              */
char        txfPF;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
char        txfV2;            /*   0 = V1-Frame, 1 = V2-Frame             */
char        txfCR;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x80 = Command-Frame         */
                              /*             0x00 = Response-Frame        */
#ifndef BOXFIRM
char        txfprt;           /*   0 = HDLC-Frame, 1 = Crosslink-Frame    */
#else
unsigned    Fpar;             /* FRACK      sec               F-Befehl    */
unsigned    Opar;             /* MAXFRAME   0..7              O-Befehl    */
unsigned    Npar;             /* RETRY      0..127            N-Befehl    */
unsigned    T2par;            /* T2         20ms              @-T2-Befehl */
unsigned    T3par;            /* T3         sec               @-T3-Befehl */
#ifndef BOXWARE
unsigned    Rpar;             /* DIGION     0..1              R-Befehl    */
                              /* 1 = Digipeaten ein, 0 = aus              */
#endif
#endif
unsigned    nmbfre;           /* "number free", Anzahl freier 32-Byte-    */
                              /* Buffer (36 Byte mit Kopf)                */
LHEAD       freel;            /* "free list",                             */
                              /* Listenkopf Freibuffer                    */
LHEAD       rxfl;             /* "rx frame list",                         */
                              /* Listenkopf empfangene Frames             */
LHEAD       stfl;             /* "sent frame list",                       */
                              /* Listenkopf gesendete Frames              */
LHEAD       trfl;             /* "trash frame list",                      */
                              /* Listenkopfe Frames fuer den Muelleimer   */
#ifndef BOXFIRM
LHEAD       txl2fl[L2PNUM];   /* "tx level 2 frame list",                 */
                              /* Listenkoepfe (je Port einer) zu sendende */
                              /* Frames                                   */
MBHEAD     *rxfhd[L2PNUM];    /* "rx frame head",                         */
                              /* Zeiger (je Port einer) auf das gerade    */
                              /* aktuelle Frame waherend Empfang,         */
                              /* 0 = es wird gerade kein Frame empfangen  */
MBHEAD     *txfhd[L2PNUM];    /* "tx frame head",                         */
                              /* Zeiger (je Port einer) auf das gerade    */
                              /* aktuelle Frame waherend Sendung,         */
                              /* 0 = es wird gerade kein Frame gesendet   */
#else
LHEAD       txl2fl;	      /* "tx level 2 frame list",                 */
			      /* Listenkoepfe zu sendende Frames	  */
MBHEAD     *rxfhd;	      /* "rx frame head",                         */
			      /* Zeiger auf das gerade aktuelle Frame	  */
			      /* waherend Empfang, 0 = es wird gerade	  */
			      /* kein Frame empfangen			  */
MBHEAD     *txfhd;	      /* "tx frame head",                         */
			      /* Zeiger auf das gerade aktuelle Frame	  */
			      /* waherend Sendung, 0 = es wird gerade	  */
			      /* kein Frame gesendet			  */
#endif
LNKBLK      lnktbl[LINKNMBR]; /* "link table", fuer jeden moeglichen      */
                              /* Level-2-Link ein Eintrag                 */
LNKBLK     *lnkpoi;           /* "link pointer", globaler Zeiger auf den  */
                              /* gerade aktuellen Linkblock (in lnktbl)   */



/* Ende von L2V.C */
