/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    L4.C	-   The Net, The Boxware. Level 4, Transport		 *
*									 *
*    angelegt:      DF6LN aus TNL4.C von DF2AU mit diversen Aenderungen	 *
*    modifiziert:   DF6LN 100792: l3tol4 zusaetzlich			 *
*		    DF6LN 120792: schnellere Weitergabe von fragmen-	 *
*				  tierten Frames			 *
*									 *
\************************************************************************/


#include "all.h"		/* Definition von Konstanten		     */
#include "l234.h"		/* Definition der Typen			     */
#include "l4v.c"		/* Definition der L4-Variablen		     */
#include "l4e.h"		/* Externe Definitionen			     */

/*---------------------------------------------------------------------------*/
VOID	l4init()			/* Level 4 initialisieren	     */
 {
#ifndef BOXWARE
  CIRTYP *cirpoi;
#endif

  inithd(&l4rxfl);			/* Liste fuer empfangene Frames	     */
  cirpoi = cirtab;			/* gesamte Circuit Tabelle	     */
  do
   {
    cirpoi->state4 =			/* Eintrag ist leer		     */
    cirpoi->numrx  =			/* keine Frames empfangen	     */
    cirpoi->numtx  = 0;			/* keine Frames zu senden	     */
    inithd(&cirpoi->mbhdrx);		/* Empfangskette ist leer	     */
    inithd(&cirpoi->mbhdtx);		/* Sendekette ist leer		     */
    inithd(&cirpoi->mbhdos);		/* Kette "ausser Reihenfolge" leer   */
#ifndef BOXWARE
    cirpoi->fragme = NULL;		/* kein Frame Fragment da	     */
#else
    clrcir();	/* keine Frames offen fuer Hostmode L-Befehl		     */
    resupn();	/* Absender, Uplink-Knoten und -Vialiste zuruecksetzen	     */
#endif
   } while (++cirpoi < &cirtab[NUMCIR]);
 }

/*---------------------------------------------------------------------------*/
VOID	l4tx()			/* Frames senden			     */
 {
  unsigned unack;		/* unbestaetigte Frames			     */
  unsigned isweg;		/* schon gesendete Frames		     */
  MBHEAD  *nxtfra;		/* naechstes Frame			     */

  cirpoi = cirtab;			/* gesamte Circuittabelle	     */
  do
   {
    if ((cirpoi->state4 == L4SCONN)	/* Eintrag ist connected	     */
      && (!(cirpoi->l4flag & L4FRBS))	/* und Partner nicht choked	     */
      && ((unack = (cirpoi->l4vs - cirpoi->l4rxvs) 
	  & 0xff) < cirpoi->numtx)
      && (unack < cirpoi->window))	/* Fenstergroesse nicht erreicht     */
     {
      for (isweg = 0,nxtfra = (MBHEAD *) cirpoi->mbhdtx.head; /* neue Frames */
	   isweg < unack;	/* schon gesendete offene Frames uebergehen  */
	   ++isweg, nxtfra = (MBHEAD *) nxtfra->nextmh);
      do 
       {
	nxtfra->l4trie = 0;			/* Versuche := 0	     */
	sndfrm(cirpoi->l4vs++, nxtfra);		/* naechstes Frame senden    */
	nxtfra = (MBHEAD *) nxtfra->nextmh;	/* vorruecken		     */
       }
      while ((++unack < cirpoi->numtx)	/* bis Ende der Kette oder	     */
	&& (cirpoi->window > unack));	/* Fenstergroesse ueberschritten     */
     }
   } while (++cirpoi < &cirtab[NUMCIR]);
 }

/*---------------------------------------------------------------------------*/
VOID	l4rx()			/* Frames empfangen			     */
  {
  MBHEAD  *nxtfra;		/* naechstes Frame			     */
  unsigned cnt;			/* Scratch Zaehler			     */
  unsigned fenste;		/* Fenstergroesse			     */
  MBHEAD  *antwor;		/* Antwort auf Frame			     */
  CIRTYP  *cirent;		/* CIRTAB Eintrag des Users		     */
  char	 *viapoi;		/* Zeiger in Vialiste			     */
  char	  usrcal[L2IDLEN];	/* Call des Users			     */
  char	  orgnod[L2IDLEN];	/* Call des absendenden Knotens		     */
  char	  upno[L2IDLEN];	/* Call Uplinkknoten			     */
  char	  upnov[L2VLEN+1];	/* Vialiste bei Uplink			     */

  while ((nxtfra = (MBHEAD *) l4rxfl.head) != (MBHEAD *) &l4rxfl.head)
   {
    unlink(nxtfra);				/* Frame aus Kette loesen    */
    if (morinb(nxtfra) >= L4HDRLEN)		 /* lang genug?		     */
     {
      l4hdr0 = getchr(nxtfra);			/* Header holen		     */
      l4hdr1 = getchr(nxtfra);
      l4hdr2 = getchr(nxtfra);
      l4hdr3 = getchr(nxtfra);
      if (((l4opco = getchr(nxtfra))
			& 0x07) != L4CCONREQ)		/* CONREQ immer gut  */
       {
	if ((l4hdr0 < NUMCIR)				/* Index im Bereich? */
	  && ((cirpoi = &cirtab[l4hdr0])->state4 != L4SDSCED)
	  && (cirpoi->ideige == l4hdr1))
	 {
	  l4pidx = cirpoi->idxpar;
	  l4pcid = cirpoi->idpart;
	 }
	else
	 {
	  if (l4opco == L4CCONACK)	/* alles ausser CON-ACK = Muell	     */
	   {
	    l4pidx = l4hdr2;	/* Partner Circuit-Index		     */
	    l4pcid = l4hdr3;	/* und -ID fuer Antwort			     */
	    l4ahd2 =
	    l4ahd3 = 0;
	    l4aopc = L4CDISREQ;	/* DISC-REQ als Antwort			     */
	    nhtol3();
	   }
	  dealmb(nxtfra);
	  continue;
	 }
       }
      switch (l4opco & 0x07) 	/* ueber Opcode verzweigen		     */
       {

/*=============================*/
case L4CCONREQ:					/* Connect Request	     */
  if ((morinb(nxtfra)				/* Frame lang genug?	     */
	>= (1 + 2 * L2IDLEN))			/* Fenstergroesse + 2 Calls  */
    && ((fenste = getchr(nxtfra) & 0xff) != 0)  /* Fenster muss sein         */
    && (getfid(usrcal, nxtfra) == TRUE)         /* gueltiges Usercall	     */
    && (getfid(orgnod, nxtfra) == TRUE)         /* gueltiger Absender	     */
    && (iscall(orgnod) == TRUE))            	/* Absender bekannt	     */
   {

/*****************************************************************************\
*									      *
* Protokollerweiterung: Beim Connect-Request-Frame wird im Anschluss an die   *
* Fenstergroesse der Uplinkknoten und die Via-Liste beim Uplink uebertragen   *
* (nullterminiert), also maximal 64 Bytes zusaetzlich. Diese Erweiterung ist  *
* kompatibel zur bisherigen Software, da laengere Frames nicht weiter unter-  *
* sucht werden. Um auch hier spaetere Erweiterungen zu ermoeglichen, wird     *
* der Rest des Frames nicht untersucht. Ist kein Uplinkknoten im Frame ent-   *
* halten, also bei aelterer Software, wird das Call des Absenderknotens als   *
* Uplinkknoten eingesetzt.						      *
*									      *
\*****************************************************************************/

    if (morinb(nxtfra) < L2IDLEN		/* alte Software?	     */
	|| (!getfid(upno,nxtfra)))		/* kein Uplinkknoten?	     */
     {
      cpyid(upno,orgnod);		/* Absender = Uplink annehmen	     */
      *upnov = '\0';			/* und dort keine Digis		     */
     }
    else				/* neue Software		     */
     {
      for (viapoi = upnov;			/* Vialiste holen	     */
	   viapoi < upnov + L2VLEN;		/* max. 8 Calls		     */
	   viapoi = viapoi + L2IDLEN)		/* viapoi -> naechstes Call  */
       {
	if (!getfid(viapoi, nxtfra)) break;	/* Ende Vialiste?	     */
       }
      *viapoi = '\0';				/* Ende markieren	     */
     }
    l4pidx = l4hdr0;				 /* Index und		     */
    l4pcid = l4hdr1;				 /* ID des Partners merken   */
#ifdef BOXWARE
    cnt =
#endif
    cirent = NULL;
    cirpoi = cirtab;				/* Circuit Tabelle absuchen */
    do
     {
#ifdef BOXWARE
      ++cnt;
#endif
      if (cirpoi->state4 != L4SDSCED) 		 /* Circuit aktiv?	     */
       {
	if ((cmpid(usrcal, cirpoi->upcall) == TRUE)	/* Calls gleich	     */
	  && (cmpid(orgnod, cirpoi->downca) == TRUE))
	 {
	  if ((cirpoi->idxpar == l4hdr0)   /* Index und ID des Partners	     */
	    && (cirpoi->idpart == l4hdr1)) /* auch gleich? dann ignorieren,  */
	    break;			   /* weil schon beantwortet	     */
	 }
       }
      else 					/* Circuit nicht aktiv	     */
       {
#ifdef BOXWARE
	if (cmpid(cirpoi->upcall,myid)	/* Call auf Circuitkanal gesetzt?    */
	    && (cirent == NULL)		/* erster freier Circuit	     */
	    && (cnt < maxcir))		/* noch annehmbar?		     */
	  cirent = cirpoi;		/* dann diesen nehmen		     */
#else
	if (cirent == NULL) cirent = cirpoi;
#endif
       }
     } while (++cirpoi < &cirtab[NUMCIR]);

    if (cirpoi == &cirtab[NUMCIR])		/* Ende der Tabelle erreicht?		     */
     {
      if ((cirent != NULL)			/* freien Platz gefunden?    */
	&& (fvalca(VCpar, usrcal) == TRUE)	/* User Call gueltig?	     */
	&& (nmbfre > 192))			/* noch Platz im RAM?	     */
       {
	cirpoi = cirent;		/* dann Eintrag nehmen		     */
	cpyid(cirpoi->upcall, usrcal);	/* Calls eintragen		     */
	cpyid(cirpoi->downca, orgnod);
	cpyid(cirpoi->upnod, upno);	/* Uplinkinformation auch	     */
	cpyidl(cirpoi->upnodv, upnov);
	cirpoi->idxpar = l4hdr0;	/* Parameter des Partnerknotens	     */
	cirpoi->idpart = l4hdr1;
	cirpoi->ideige = random();	/* eigener ID			     */
	cirpoi->l3node = despoi;	/* Nachbar fuer den Eintrag	     */
#ifdef BOXWARE
	cirpoi->dir = 1;		/* Connect kam von aussen	     */
#endif
	l4tol7(L4MCONNT);		/* neuen Circuit an L7 melden	     */
	cirpoi->tranoa = ininat;	/* Timeout setzen		     */
       }
      else 			/* kein Platz oder ungueltiges Call	     */
       {
	l4ahd2 =		/* Antwort aufbauen			     */
	l4ahd3 = 0;
	l4aopc = (L4CCONACK | L4CCHOKE);		/* Connect ablehnen  */
	(antwor = gennhd())->l2link = (LNKBLK *) despoi;/* Antwort aufbauen  */
	relink(antwor, l3txl.tail); /* in Sendekette haengen		     */
	break;
       }
     }					       /* Eintrag gibt es schon	     */
    cirpoi->window = (fenste > trawir)? trawir : fenste;
    clrcir();				       /* Eintrag initialisieren     */
    l4ahd2 = (cirpoi - cirtab);
    l4ahd3 = cirpoi->ideige;		       /* eigene Parameter setzen    */
    l4aopc = L4CCONACK;			       /* Antwort wird ACK	     */
    putchr(cirpoi->window, (antwor = gennhd()));
    itol3(antwor);			       /* senden		     */
    cirpoi->state4 = L4SCONN;		       /* Status = connected	     */
   }
break;

/*=============================*/
case L4CCONACK:			  /* Connect Acknowledge		     */
  if (cirpoi->state4 == L4SLKSUP) /* macht nur Sinn, wenn Connect verlangt   */
   {
    if (!(l4opco & L4CCHOKE))		/* Partner darf nicht choked sein    */
     {
      if (morinb(nxtfra) != 0)		/* noch Info da?		     */
       {
	cirpoi->window = getchr(nxtfra);/* holen			     */
	cirpoi->idpart = l4hdr3;	/* Partner Parameter setzen	     */
	cirpoi->idxpar = l4hdr2;
	cirpoi->l4try = 0;
	l4tol7(L4MCONNT);		/* 'Connected' melden an L7 von L4   */
	cirpoi->tranoa = ininat;	/* Timeout setzen		     */
	cirpoi->state4 = L4SCONN;	/* Status = connected		     */
       }
     }
    else 			/* Partner ist choked (= BUSY)		     */
     {
      inicir(L4MBUSYF);		/* melden				     */
     }
   }
break;

/*=============================*/
case L4CDISREQ:			/* Disconnect Request			     */
  clr4rx(TRUE);			/* restliche Info nach oben geben	     */
  inicir(L4MDISCF);		/* nach oben melden			     */
  l4ahd2 =
  l4ahd3 = 0;			/* Antwort aufbauen			     */
  l4aopc = L4CDISACK;		/* Opcode = Disconnect ACK		     */
  nhtol3();
break;

/*=============================*/
case L4CDISACK:				/* Disconnect Acknowledge	     */
  if (cirpoi->state4 == L4SDSCRQ) 	/* wurde DISC gegeben?		     */
   {
    inicir(L4MDISCF);			/* melden			     */
   }
break;

/*=============================*/
case L4CINFTRA:				/* Info Transfer		     */
  if (cirpoi->state4 != L4SCONN)	/* nur wenn connected		     */
    break;
  chksts();			/* Status Info auswerten		     */
  if (((nxtfra->l2fflg = (l4hdr2 - cirpoi->l4vr) & 0xff) < cirpoi->window)
    && !(cirpoi->l4flag & L4FDBS))	   /* passt das Frame ins Fenster?   */
   {
    nxtfra->morflg = (l4opco & L4CMORE) != 0;	/* fragmentiert?	     */
    if (!nxtfra->l2fflg) 			/* passt Sequenz?	     */
     {
      takfrm(nxtfra);			   /* Frame uebernehmen		     */
      for (cnt = 1, antwor = (MBHEAD *) cirpoi->mbhdos.head; /* Frames,      */
	(MBHEAD *) &(cirpoi->mbhdos) != antwor; /* die zu frueh kamen, absu- */
	   antwor = (MBHEAD *) antwor->nextmh)	/* chen, ob nun passt	     */
       {
	if ((antwor->l2fflg -=cnt) == 0)	/* neuer Offset		     */
	 {
	  nxtfra = (MBHEAD *) antwor->prevmh; /* Frame passt bei Offset 0    */
	  takfrm(unlink(antwor)); /* Frame aus Kette nehmen und verwerten    */
	  antwor = nxtfra;
	  ++cnt;		/* zulaessiger Offset eins weiter	     */
	 }
       }
      cirpoi->l4rs = L4FNXTACK;	/* Antwort wird ACK			     */
      cirpoi->acktim = traack;	/* ACK Timer laden			     */
     }
    else			/* Sequenz passt nicht			     */
     {
      antwor = (MBHEAD *) cirpoi->mbhdos.head;
      LOOP
       {                                /* in extra Kette haengen	     */
	if ((MBHEAD *) &(cirpoi->mbhdos) == antwor)   /* Ende der Kette?     */
         {
	  relink(nxtfra, cirpoi->mbhdos.tail); /* dann einhaengen	     */
	  break;
	 }
	if (antwor->l2fflg == nxtfra->l2fflg) /* Frame schon mal angekommen? */
	 {
	  dealmb(nxtfra);	/* dann wegwerfen			     */
	  break;
	 }
	if (antwor->l2fflg > nxtfra->l2fflg)/* an passender Stelle einhaengen*/
	 {
	  relink(nxtfra, antwor->prevmh);
	  break;
	 }
	antwor = (MBHEAD *) antwor->nextmh; /* ein Frame weiter		     */
       }
      if (cirpoi->l4rs == L4FNXTACK)	/* Frame haengt in extra Kette	     */
       {
	cirpoi->l4rs = L4FNXTNAK;	/* wenn ACK gefordert war, nun NAK   */
	cirpoi->acktim = traack;	/* ACK Wartezeit setzen		     */
       }
     }
    continue;			/* naechstes Frame			     */
   }
  else				/* ungueltiges Frame oder selbst choked	     */
    cirpoi->acktim = traack;	/* Antwort hat Zeit			     */
break;

/*=============================*/
case L4CINFACK:				/* Info Acknowledge		     */
  if (cirpoi->state4 == L4SCONN)	/* nur sinnvoll, wenn connected	     */
    chksts();				/* enthaltene Statusinfo auswerten   */
break;

/*=============================*/
default:			/* ungueltiger Opcode			     */
break;				/* ignorieren				     */

/*=============================*/
      } }			/* Ende des Switch ueber Opcode		     */
    dealmb(nxtfra);		/* fertig bearbeitet, wegwerfen		     */
  } }

/*---------------------------------------------------------------------------*/
VOID	l4rest()		/* diverse Level4 Funktionen		     */
  {
  cirpoi = cirtab;		/* gesamte Tabelle bearbeiten		     */
  do
   {
    if (cirpoi->state4 == L4SCONN)	/* nur fuer connectete Eintrage	     */
     {
      if (((cirpoi->l4flag & L4FDSLE) != 0) /* Abwurf gefordert		     */
	&& (cirpoi->numtx == 0)) { /* und alles gesendet?		     */
	endcir();		/* Eintrag loeschen			     */
	}
      else {
	clr4rx(FALSE);	/* kein Abwurf gefordert: Info nach oben geben	     */
	if ((cirpoi->l4flag & L4FDBS) == 0) { /* selbst choked?		     */
	  if ((nmbfre < 80)	/* nein: kein Platz im Buffer?		     */
	    || (cirpoi->numrx >= conctl)) { /* oder zu viel empfangen?	     */
	    cirpoi->l4flag |= L4FDBS;	    /* dann selbst choked setzen     */
	    cirpoi->l4rs = L4FNXTACK;	    /* ACK als naechste Antwort	     */
	    sndack();
	    }
	  }
	else {
	  if ((nmbfre > 112)	/* selbst choked: wieder Platz im Buffer?    */
	    && (cirpoi->numrx < (conctl / 2))) { /* und Datenstau abgebaut?  */
	    cirpoi->l4flag &= ~L4FDBS;		 /* dann choked ruecksetzen  */
	    sndack();		/* melden				     */
	  } }
      } }
  } while (++cirpoi < &cirtab[NUMCIR]);
 }

/*---------------------------------------------------------------------------*/
VOID	l4timr()		/* Timerservice fuer Level 4		     */
  {
  MBHEAD   *nxtfra;		/* aktuelles Frame			     */
  unsigned actsts;		/* Status des aktuellen Eintrages	     */
  unsigned fropen;		/* Zahl der unbestaetigten Frames	     */
  unsigned tosend;		/* Zahl der zu sendenden Frames		     */

  cirpoi = cirtab;		/* gesamte Tabelle bearbeiten		     */
  do
   {
    if ((actsts = cirpoi->state4) != L4SDSCED) { /* nur aktive Eintraege     */
      if (cirpoi->traout != 0) { /* Timeout noch nicht abgelaufen	     */
	if (--cirpoi->traout == 0) { /* Timeout nun abgelaufen?		     */
	  if (actsts == L4SCONN) /* Status = connected?			     */
	    cirpoi->l4flag &= ~L4FRBS;	/* nichts neues senden		     */
	  else {		/* anderer Status:			     */
	    if (++cirpoi->l4try < tratri) /* noch mal versuchen?	     */
	      (actsts == L4SLKSUP)? sconrq() : sdisrq(); /* ja		     */
	    else inicir(L4MFAILW);	/* Fehler melden		     */
	    }
	} }
      else {			/* Timeout ist schon 0			     */
	if ((actsts == L4SCONN)	/* connectet und Frames unbestaetigt?	     */
	  && ((fropen = (cirpoi->l4vs - cirpoi->l4rxvs) & 0xff) != 0)) {
	  for (tosend = 0, nxtfra = (MBHEAD *) cirpoi->mbhdtx.head;
	     tosend < fropen;	/* Frames wiederholen			     */
	     ++tosend, nxtfra = (MBHEAD *) nxtfra->nextmh) {
	    if (--nxtfra->l4time == 0) { /* wenn Timeout abgelaufen	     */
	      if (++nxtfra->l4trie < tratri) /* und noch Versuche frei	     */
		sndfrm(nxtfra->l2fflg, nxtfra);
	      else {
		inicir(L4MFAILW);	/* sonst melden			     */
		break;
		}
	      }
	    }
	  }
	}
      if (actsts == L4SCONN) {	/* connectet?				     */
	if ((cirpoi->acktim != 0)
	  && (--cirpoi->acktim == 0)) /* ACK-Timer gerade abgelaufen?	     */
	  sndack();		/* dann ACK senden			     */
	if ((cirpoi->tranoa != 0)
	  && (--cirpoi->tranoa == 0)) /* No-activity-Timeout abgelaufen?     */
	  endcir();		/* dann abwerfen			     */
	}
     }
   } while (++cirpoi < &cirtab[NUMCIR]);
 }

/*---------------------------------------------------------------------------*/
VOID	newcir()		/* neuen Circuit aufbauen		     */
  {
  clrcir();			/* Eintrag in CIRTAB loeschen		     */
#ifdef BOXWARE
  cirpoi->dir = 0;		/* ich bin Verursacher des Connects	     */
#endif
  cirpoi->ideige = random();	/* eigenen ID erzeugen			     */
  cirpoi->l4try = 0;		/* Versuche = 0				     */
  sconrq();			/* Connect Request senden		     */
  cirpoi->state4 = L4SLKSUP;	/* neuer Status				     */
  }


/*****************************************************************************\
*									      *
* discir - Circuit aufloesen						      *
*									      *
* Fuer die Boxware wurde die Disconnect-Routine an die Disconnect-Syntax des  *
* L2 angepasst. D.h. bei connectetem Circuit wird beim ersten Aufruf die      *
* Empfangsframeliste geloescht und fuer die Sendeliste markiert, dass nach    *
* vollstaendiger Aussendung der Circuit disconnected werden soll. Beim 2.     *
* Aufruf wird auch die Sendeframeliste geloescht und sofort ein Disconnect    *
* eingeleitet. Beim 3. Aufruf wird der Circuit komplett geloescht.	      *
*									      *
\*****************************************************************************/

#ifdef BOXWARE
VOID	discir()			/* Circuit aufloesen		     */
 {
  if ((cirpoi->state4 == L4SLKSUP)	/* 3. Aufruf bzw. Status CON-REQ     */
       || (cirpoi->state4 == L4SDSCRQ))	/* oder DIS-REQ			     */
    inicir(L4MDISCF);			/* an L7: Disconnected melden	     */
  else					/* connectet oder disconnected	     */
   {
    if (!cirpoi->state4)		/* disconnected			     */
      inicir(L4MNIX);
    else
     {
      if (!(cirpoi->l4flag & L4FDSLE))	/* Abwurf noch nicht eingeleitet     */
       {
	dealml(&cirpoi->mbhdrx);	/* empfangene Frames loeschen	     */
	cirpoi->numrx = 0;
	cirpoi->l4flag |= L4FDSLE;	/* Abwurf einleiten		     */
       }
      else			/* Abwurf war schon eingeleitet = 2. Aufruf  */
       {			/* Circuit gleich beenden		     */
	endcir();
       }
     }
   }
 }
#else
VOID	discir()			/* Circuit aufloesen		     */
  {
  if ((cirpoi->state4 == L4SLKSUP)	/* Status CON-REQ?		     */
       || (cirpoi->state4 == L4SDSCRQ))	/* oder DIS-REQ?		     */
    inicir(L4MNIX);			/* nur intern Circuit loeschen	     */
  else					/* connectet:			     */
   {
    kilfra();				/* alle Fragmente loeschen	     */
    dealml(&cirpoi->mbhdrx);		/* empfangene Frames loeschen	     */
    cirpoi->numrx = 0;
    cirpoi->l4flag |= L4FDSLE;		/* Abwurf einleiten		     */
   }
 }
#endif

/*---------------------------------------------------------------------------*/
VOID	l3tol4()		/* Meldung L3 -> L4: Knoten, auf den despoi  */
 {				/* zeigt, wird aus der Nodesliste gestrichen */
  unsigned cnt;			/* Scratch Zaehler			     */
  CIRTYP  *cirp;		/* Zwischenspeicher fuer cirpoi		     */
  NODTYP  *nodsav;		/* Zwischenspeicher fuer despoi		     */

  cnt = 0;			/* Circuit-Tabelle nach Eintraegen absuchen, */
  cirpoi = cirtab;		/* die zum Zielknoten verbunden sind, auf    */
  do				/* den despoi zeigt			     */
   {
    if ((cirpoi->state4 != L4SDSCED)	/* Eintrag belegt		     */
	&& (cirpoi->l3node == despoi))	/* Zielknoten wurde geloescht	     */
     {
      nodsav = despoi;	/* despoi und cirpoi merken, weil sie evtl. bei den  */
      cirp = cirpoi;	/* von l4tol7 aufgerufenen Routinen geaendert werden */
      clr4rx(TRUE);	/* empfangene Frames abliefern			     */
      inicir(L4MFAILW);	/* Meldung an L7: Failure (Zielknoten ist weg)	     */
      cirpoi = cirp;	/* despoi und cirpoi restaurieren		     */
      despoi = nodsav;
     }
    ++cirpoi;
   } while (++cnt < NUMCIR);
 }

/*---------------------------------------------------------------------------*/
BOOLEAN	itocir(cflg, mbhd)	/* Info an Circuit senden		     */
  MBHEAD  *mbhd;		/* Message Header			     */
  BOOLEAN  cflg;		/* Congestion Flag			     */
  {
  CIRTYP *cblk;			/* Kontrollblock			     */

  if (((cblk = (CIRTYP *) mbhd->l2link)->numtx < conctl)	/* Platz?    */
    || (cflg == TRUE))					/* immer senden?     */
    {
      relink(unlink(mbhd), cblk->mbhdtx.tail);	 	/* Info umhaengen    */
      ++cblk->numtx;					/* Frames zaehlen    */
      cblk->tranoa = ininat;				/* Timeout neu	     */
      return(TRUE);					/* hat funktioniert  */
    }
  else return(FALSE);					/* Fehler, ging nicht*/
  }

/*---------------------------------------------------------------------------*/
VOID	clr4rx(cflg)		/* restliche Info senden		     */
  BOOLEAN cflg;			/* Congestion Flag			     */
  {
  MBHEAD  *mbhd;		/* Message Header			     */

  while (cirpoi->numrx != 0) {	/* ein Frame nach dem anderen		     */
    (mbhd = (MBHEAD * )cirpoi->mbhdrx.head)->l2link = (LNKBLK *)cirpoi;
    mbhd->type = 4;		/* User ist Circuit			     */
    if (fmlink(cflg, mbhd) == FALSE) break; /* Ende bei Fehler		     */
    cirpoi->tranoa = ininat;	/* Timeout setzen			     */
    --cirpoi->numrx;		/* ein Frame ist weg			     */
    }
  }

/*---------------------------------------------------------------------------*/
VOID	chksts()		/* Status des eingelaufenen Frames auswerten */
  {
  unsigned frofs;		/* bestaetigter Offset			     */
  unsigned fropen;		/* unbestaetigte Frames			     */

  if ((fropen = (cirpoi->l4vs - cirpoi->l4rxvs) & 0xff) != 0) 
   {				/* Frames offen?			     */
    if ((frofs = (l4hdr3 - cirpoi->l4rxvs) & 0xff) != 0) 
     {				/* neu bestaetigte Frames		     */
      if (frofs <= fropen) 
       {
	while (frofs-- != 0) 
	 {
	  dealmb(unlink(cirpoi->mbhdtx.head));	/* koennen weg		     */
	  --cirpoi->numtx;	/* eins weniger zu senden		     */
	  ++cirpoi->l4rxvs;	/* eins mehr bestaetigt			     */
    } } } }
  if ((l4opco & L4CCHOKE) == 0) {	   /* Partner choked?		     */
    cirpoi->l4flag &= ~L4FRBS;		   /* nein: merken		     */
    cirpoi->traout = 0;			   /* Timeout kann nicht kommen	     */
    if (((l4opco & L4CNOACK) != 0)	   /* NAK Flag?			     */
      && (cirpoi->l4vs != cirpoi->l4rxvs)) /* und noch was offen?	     */
      sndfrm(cirpoi->l4rxvs, cirpoi->mbhdtx.head);      /* dann wiederholen  */
    }
  else {			/* Partner ist choked			     */
    cirpoi->l4flag |= L4FRBS;	/* merken				     */
    cirpoi->traout = trabsy;	/* warten				     */
    cirpoi->l4vs = cirpoi->l4rxvs; /* keine Frames offen		     */
    }
  }

/*---------------------------------------------------------------------------*/
VOID	takfrm(mbhd)		/* empfangenes Frame uebernehmen	     */
MBHEAD	 *mbhd;
 {
  MBHEAD  *fragmn;		/* Fragment des Frames			     */
  unsigned cnt;
  BOOLEAN  more;		/* Frame ist auch nur Fragment		     */

  if ((cirpoi->l4flag & L4FDSLE) == 0)  /* wenn nicht DISC-REQ		     */
    {

/*****************************************************************************\
*									      *
* Bei der Boxware muessen die Fragmente einzeln ausgegeben werden, weil der   *
* Hostmodus maximal 256 Zeichen auf einmal uebertragen kann. Bei der Abfrage  *
* von Knoten- oder Userlisten kommen aber eventuell auch mehr als 256 Zeichen *
* in einem Monsterpaket aus etlichen Frames. Nachteil: Beim User mit 256      *
* Bytes abgeschickte Frames kommen durch die Fragmentierung als 2 Pakete beim *
* Hostrechner an. Man koennte hier allerdings auch wieder die ankommenden     *
* Frames zusammensetzen und anschliessend in 256-Bytebloecken zum Host ueber- *
* tragen. Aus Platzgruenden wurde darauf vorerst verzichtet.		      *
*									      *
\*****************************************************************************/

#ifndef BOXWARE
    if (!cprtnr())			     /* User mit L4-Partner?	     */
     {
      more = mbhd->morflg;		     /* kommt noch mehr?	     */
      if ((fragmn = cirpoi->fragme) == NULL) /* noch kein Fragment vorhanden */
       {
	if (more == TRUE)	 	/* ist dies ein Fragment?	     */
	 {
	  cirpoi->fragme = mbhd;	/* dann nur merken		     */
	  mbhd = NULL;			/* Frame ist weg		     */
	 }
       }
      else				/* Fragment schon vorhanden	     */
       {
	addinf(fragmn, mbhd);		/* Info von mbhd an fragmn haengen   */
	mbhd = NULL;			/* mbhd ist ungueltig		     */
	if (!more			/* Frame komplett		     */
	    || ((cnt = morinb(fragmn)) 	/* oder zufaellig 256 Bytes Info     */
		       == INFOLEN))
	 {
	  mbhd = fragmn;		/* dann ist das Ergebnis die neue    */
	  cirpoi->fragme = NULL;	/* Summe - kein Fragment mehr da     */
	 }
	else				/* es kommt noch mehr		     */
	 {
	  if (cnt > INFOLEN)		/* mehr als ein volles L2-Frame?     */
	   {
	    mbhd = (MBHEAD *) allocb();		/* neuen Puffer holen	     */
	    while (mbhd->mbpc  < INFOLEN)	/* 256 Bytes aus fragmn an   */
	      putchr(getchr(fragmn),mbhd);	/* L2-User bzw. CCP liefern  */
	    rwndmb(mbhd);
	   } /* mehr als volles L2-Frame */
	 } /* es kommt noch mehr */
       } /* Fragment schon vorhanden */
     } /* if (!cprtnr()) */
    if (mbhd != NULL)			/* Frame noch da?		     */
     {
#endif
      relink(mbhd, cirpoi->mbhdrx.tail);	/* dann in RX Liste haengen  */
      ++cirpoi->numrx;				/* ein Frame mehr da	     */
#ifndef BOXWARE
     }
#endif
   }
  else				/* Kanal soll abgeworfen werden		     */
   {
    dealmb(mbhd);		/* Frame vernichten			     */
   }
  ++cirpoi->l4vr;		/* RX-Sequenz erhoehen			     */
 }

/*---------------------------------------------------------------------------*/
VOID	sndfrm(txsequ, mbhd)	/* Frame senden				     */
MBHEAD	 *mbhd;			/* Info					     */
unsigned txsequ;		/* Sendesequenz fuer L4			     */
  {
  MBHEAD *netmhd;		/* Netzwerk MBHD		     	     */
  char	 *next;			/* Pointer auf letztes Zeichen des Headers   */

  l4ahd2 =			/* VS in Netzwerkheader			     */
  mbhd->l2fflg = txsequ;	/* VS als PID				     */
  l4aopc = L4CINFTRA;		/* Opcode = Info			     */
  ackhdr();			/* Rest des Headers erzeugen		     */
  next =
  (netmhd = gennhd())		/* Buffer fuer Netzwerkframe holen	     */
	  ->mbbp;		/* Position Opcode merken (eins davor)	     */
  if ((
    splcpy((INFOLEN - netmhd->mbpc), netmhd, mbhd) /* Info umkopieren	     */
    ) == TRUE) {		/* hat alles reingepasst?		     */
    ++cirpoi->numtx;		/* nein: ein Frame mehr			     */
    mbhd->morflg = TRUE;	/* Fragmentierung markieren		     */
    }
  if (mbhd->morflg == TRUE)
    *(next -1) |= L4CMORE;	/* MORE Flag im Opcode setzen		     */
  itol3(netmhd);		/* Frame an Level3 liefern		     */
  mbhd->l4time = tratou;	/* Timeout im Infoframe setzen		     */
  }



/****************************************************************************\
*									     *
* Circuit initialisieren und ggf. an L7 melden				     *
*									     *
* Die Ursache fuer das Ende des Circuit ist nur fuer L7 interessant. Es gibt *
* folgende Moeglichkeiten fuer uebergebene Meldungen:			     *
*									     *
* L4MNIX:	Der Circuit wurde vom L7 ueber discir() beendet (TheNet)     *
*		oder mit discir() wurde der Circuit initialisiert beim	     *
*		I-Befehl (Boxware)					     *
* L4MDISCF:	Der Circuit wurde ueber discir() beendet (Boxware) oder	     *
*		regulaer mit Disc-Request und Disc-Acknowledge beendet 	     *
* L4MBUSYF:	Connect-Request wurde von der Gegenstation abgewiesen (busy) *
* L4MFAILW:	L4-Versuche abgelaufen oder Zielknoten wurde aus der Nodes-  *
*		liste entfernt (vom Sysop oder weil veraltet).		     *
*									     *
\****************************************************************************/

VOID	inicir(msg)
char	msg;
  {
  if (msg != L4MNIX) 		/* nur intern fuer L4			     */
   {
    l4tol7(msg);		/* Meldung von L4 an L7			     */
   }
  clrcir();			/* alle Pointer im Eintrag loeschen	     */
  dealml(&cirpoi->mbhdrx);	/* keine Frames empfangen		     */
  dealml(&cirpoi->mbhdtx);	/* keine Frames zu senden		     */
  cirpoi->numrx =		/* Emfangsliste ist leer		     */
  cirpoi->numtx =		/* Sendeliste ist leer			     */
  cirpoi->state4 = 0;		/* Status = Eintrag ist disconnected	     */
#ifdef BOXWARE
  resupn();			/* Absender + Uplinkknoten zuruecksetzen     */
#endif
 }

/****************************************************************************\
*									     *
* Meldung von L4 an L7							     *
*									     *
* L4 meldet eine Aenderung des Circuit-Zustands an L7. Folgende Meldungen    *
* sind moeglich:							     *
*									     *
* L4MCONNT:	Der Circuit ist jetzt Connected.			     *
* L4MDISCF:	Der Circuit wurde ueber discir() beendet (Boxware) oder	     *
*		regulaer mit Disc-Request und Disc-Acknowledge beendet 	     *
* L4MBUSYF:	Connect-Request wurde von der Gegenstation abgewiesen (busy) *
* L4MFAILW:	L4-Versuche abgelaufen oder Zielknoten wurde aus der Nodes-  *
*		liste entfernt (vom Sysop oder weil veraltet).		     *
*									     *
\****************************************************************************/

VOID	l4tol7(msg)
char	msg;
 {
  lxtol7(msg, cirpoi, 4);	/* Meldung von L4 an L7			     */
 }

/*---------------------------------------------------------------------------*/
#ifdef BOXWARE
VOID resupn()
 {
  cpyid(cirpoi->upcall, myid);	/* Absender zuruecksetzen		     */
  cpyid(cirpoi->upnod, myid);	/* Uplinkknoten auch			     */
  *cirpoi->upnodv = '\0';	/* Uplinkvialiste leer			     */
 }
#endif

/*---------------------------------------------------------------------------*/
VOID	endcir()		/* Circuit aufloesen			     */
  {
    clrcir();			/* Eintrag in CIRTAB loeschen		     */
    cirpoi->l4try = 0;		/* Versuche ruecksetzen			     */
    sdisrq();			/* Abwurf einleiten			     */
    cirpoi->state4 = L4SDSCRQ;	/* neuer Status: DISC-REQ gegeben	     */
  }

/*---------------------------------------------------------------------------*/
VOID	clrcir()		/* Eintrag in CIRTAB loeschen		     */
  {
#ifndef BOXWARE
  kilfra();			/* Fragmente loeschen			     */
#endif
  dealml(&cirpoi->mbhdos);	/* Messageliste dafuer auch		     */
  cirpoi->l4rxvs =		/* alle Sequenzen auf 0			     */
  cirpoi->l4vs =
  cirpoi->l4vr =
  cirpoi->l4rs =		/* ACK-NAK Flag				     */
  cirpoi->traout =		/* Timeout				     */
  cirpoi->l4flag = 0;		/* niemand choked, kein DISC-REQ	     */
  }

/*---------------------------------------------------------------------------*/
VOID	sconrq()		/* CON-REQ senden			     */
  {
  MBHEAD *mbhd;			/* Buffer fuer Frame			     */
  char	 *viapoi;		/* Zeiger in Vialiste			     */

  l4pidx = cirpoi - cirtab;	/* Index setzen				     */
  l4pcid = cirpoi->ideige;	/* Partner und eigener Index		     */
  l4ahd2 =			/* zwei Bytes leer			     */
  l4ahd3 = 0;
  l4aopc = L4CCONREQ;		/* Opcode				     */
  putchr (trawir, (mbhd = gennhd())); /* Rest des Headers		     */
  putfid(cirpoi->upcall, mbhd);	/* beide Calls in das Frame		     */
  putfid(myid, mbhd);
  putfid(cirpoi->upnod, mbhd);	/* Uplinkknoten dazu			     */
  viapoi = cirpoi->upnodv;	/* Uplink-Vialiste auch			     */
  while (*viapoi != '\0')	/* Ende Vialiste erreicht?		     */
   {
    putfid(viapoi, mbhd);	/* Call in Puffer			     */
    viapoi = viapoi + L2IDLEN;	/* zum naechsten Call			     */
   }
  putchr('\0', mbhd);		/* 0 markiert Ende Vialiste		     */
  itol3(mbhd);			/* an Level3 liefern			     */
  cirpoi->traout = tratou;	/* Timeout setzen			     */
  }

/*---------------------------------------------------------------------------*/
VOID	sdisrq()		/* DISC-REQ senden			     */
  {
  l4pidx = cirpoi->idxpar;	/* Index setzen				     */
  l4pcid = cirpoi->idpart;	/* und ID				     */
  l4ahd2 =			/* zwei Bytes leer			     */
  l4ahd3 = 0;
  l4aopc = L4CDISREQ;		/* Opcode				     */
  nhtol3();
  cirpoi->traout = tratou;	/* Timeout setzen			     */
  }

/*---------------------------------------------------------------------------*/
VOID	sndack()		/* ACK senden				     */
  {
  l4ahd2 = 0;
  l4aopc = L4CINFACK;		/* Opcode				     */
  ackhdr();			/* Rest des Headers			     */
  nhtol3();
  }

/*---------------------------------------------------------------------------*/
VOID	ackhdr()		/* ACK Header erzeugen			     */
  {
  l4pidx = cirpoi->idxpar;		/* Partner Index		     */
  l4pcid = cirpoi->idpart;		/* Partner ID			     */
  l4ahd3 = cirpoi->l4vr;		/* RX-Sequenz			     */
  if ((cirpoi->l4flag & L4FDBS) != 0)	/* selbst choked?		     */
    l4aopc |= L4CCHOKE;			/* dann Flag setzen		     */
  else {
    if (cirpoi->l4rs == L4FNXTNAK) {	/* wird es ein NAK Header?	     */
      l4aopc |= L4CNOACK;		/* dann Flag setzen		     */
      cirpoi->l4rs = L4FNAKSENT;	/* NAK als gesendet markieren	     */
      }
    }
  cirpoi->acktim = 0;		/* ACK Timer ruecksetzen		     */
  }

/*---------------------------------------------------------------------------*/
VOID	itol3(mbhd)		/* Info an Level3			     */
MBHEAD	*mbhd;
 {
  mbhd->l2link = (LNKBLK *) cirpoi->l3node;	/* Kontrollblock	     */
  relink(mbhd, l3txl.tail);			/* umhaengen in L3-Tx-Liste  */
 }

/*---------------------------------------------------------------------------*/
MBHEAD	*gennhd()		/* Netzwerk Header erzeugen		     */
  {
  MBHEAD  *mbhd;		/* Buffer fuer Info			     */
  unsigned cnt;			/* Scratch Zaehler			     */

  mbhd = (MBHEAD *) allocb();	/* Buffer besorgen			     */
  cnt = 0;			/* die ersten 15 Bytes fuer den Header leer  */
  do
   {
    putchr(0, mbhd);
   } while (++cnt < L3HDRLEN);

  putchr(l4pidx, mbhd);		/* Transport Header schreiben		     */
  putchr(l4pcid, mbhd);
  putchr(l4ahd2, mbhd);
  putchr(l4ahd3, mbhd);
  putchr(l4aopc, mbhd);

  return(mbhd);			/* Buffer wird zurueck gegeben		     */
  }

/*---------------------------------------------------------------------------*/
VOID nhtol3()
 {
  itol3(gennhd());
 }
/*---------------------------------------------------------------------------*/
#ifndef BOXWARE			/* Fragmentierung nicht bei BOXWARE	     */
VOID	kilfra()		/* Fragmente loeschen			     */
  {
  if (cirpoi->fragme != NULL) {  	/* schon leer?			     */
    dealmb(cirpoi->fragme);             /* Fragment loeschen		     */
    cirpoi->fragme = NULL;		/* Eintrag loeschen		     */
    }
  }
#endif
/*- Ende Level 4 ------------------------------------------------------------*/
