/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
\************************************************************************/


/* Level 7B, Befehlsinterpreter, Befehle				     */
/* Version 1.01  							     */
/* Hans Georg Giese, DF2AU, Hinter dem Berge 5, 3300 Braunschweig	     */
/* 08-MAY-88								     */

/* Aenderungen:								     */
/*              231288 DF6LN: Downlink nicht mehr moeglich bei #-Knoten      */
/*		080189 DF6LN: RESTART-Befehl zusaetzlich		     */
/*              041289 DL2LAY: V1.01c                                        */
/*                            - Downlink-Sperre ueber Flags.1 anstelle #ID   */
/*                            - Downlink fuer Sysop immer erlaubt            */
/*                            - INFO-Befehl geaendert auf 255 freie Zeichen  */
/*                            - neue Befehle 'CLINFO' und 'TEST'             */
/*                            - 'Invalid command'-Ausgabe bei Sysop-Befehlen */
/*                              ohne Sysop                                   */
/*              180190 DL2LAY: V1.11d                                        */ 
/*                            - Befehl FLAG                                  */
/*		150391 DF6LN: C!-Befehl zusaetzlich (Connect o. Reconnect)   */
/*		160391 DF6LN: Uhrzeit					     */
/*		200391 DF6LN: MHeard-befehl, Heard-Liste		     */
/*		180192 DF6LN: partab -> L7B.C				     */
/*		230192 DF6LN: Texte umgestellt auf Buffer (INFO, CLINFO)     */
/*		230192 DF6LN: CTEXT- und DTEXT-Befehl entfaellt,	     */
/*			      AKTUELL-Befehl zusaetzlich		     */
/*		050292 DF6LN: ROUTES-, PARMS-, FLAGS- und Y-Befehl ueber     */
/*			      syscmd() gesperrt, wenn Flags.13 gesetzt	     */
/*		080792 DF6LN: Y-Befehl entfernt (-> Parameter 34)	     */
/*			      Zusaetzliche Parameter Ypar, T2par1	     */
/*		090792 DF6LN: Test-Befehl ohne Assembler-Routine	     */
/*		250792 DF6LN: Zusaetzliche Parameter Fpar1, Opar1	     */
/*		260792 DF6LN: Nodesbefehl geaendert: 'N #' statt 'N ?'	     */
/*		010892 DF6LN: Black List				     */
/*		090892 DF6LN: Lifetime fuer NODES-Broadcast in ccpnod()	     */
/*		230892 DF6LN: Downlink-Sperre auch bei CQ		     */


#include "l7.h"
#include "l7be.h"

/*****************************************************************************\
*									      *
* ccpakt()	Aktuell--Text abfragen					      *
*									      *
\*****************************************************************************/

VOID ccpakt()
 {
  if (!nodbsy()) shotx1(ATXT);		/* nur Text anzeigen		     */
 }

/*****************************************************************************\
*									      *
* ccpbl()	Schwarze Liste setzen bzw. abfragen			      *
*									      *
* Die schwarze Liste wird als Digi-Liste gespeichert. Dadurch wird nur wenig  *
* Programmplatz benoetigt fuer den Befehl BL. Daher koennen auch SSIDs ange-  *
* geben werden, die aber bei der Auswertung in isinbl() nicht beruecksichtigt *
* werden. Es sind daher die Rufzeichen in der schwarzen Liste vollstaendig    *
* gesperrt, unabhaengig vom SSID.					      *
*									      *
\*****************************************************************************/

VOID ccpbl()
 {
  MBHEAD *fbp;
  char    bl[L2VLEN+1];

  if (issyso() == TRUE)		/* Sysop will aendern			     */
   {
    if (*clipoi == '-')		/* Liste loeschen?			     */
     {
      blklis[0] = 0;
     }
    else
     {
      if (getdig(2,bl) != ERROR)	/* zu sperrende Calls holen	     */
       {
	cpyidl(blklis,bl);		/* uebernehmen, wenn kein Fehler     */
       }
     }
   }

  if (!syscmd())
   {
    fbp = putals("BlackList:");
    putdig(blklis,fbp);
    prompt(fbp);
   }
 }

/*****************************************************************************\
*									      *
* ccpc0()	Connect ohne Reconnect (C!-Befehl)			      *
*									      *
\*****************************************************************************/

VOID ccpc0()
 {
  ccpco();		   /* erst normaler Connect-Befehl		     */
  if (userpo->status == 2) /* Connect laeuft?				     */
    userpo->status = 4;	   /* ja: status -> Connect laeuft, kein Reconnect   */
 }

/*****************************************************************************\
*									      *
* ccpclk()	Setzen der Uhrzeit durch den Sysop (K-Befehl)		      *
*									      *
\*****************************************************************************/

VOID ccpclk()			/* Uhrzeit setzen (K-Befehl)		     */
 {
  if (issyso() == TRUE)		/* das darf nur der Sysop		     */
   {
    stunde = nxtnum();		/* erste Zahl = Stunde			     */
    minute = nxtnum();		/* danach Minute			     */
    sec = 0;			/* Sekunde immer 0			     */
    putmsg("Clock set");	/* Antworten				     */
   }
  else nocmd();
 }

/*****************************************************************************\
*									      *
* ccpco()	Connect-Befehl gemeinsame Routine fuer CONNECT und C!	      *
*									      *
\*****************************************************************************/

VOID	ccpco()			/* CONNECT Befehl			     */
 {
  USRTYP   *usrpoi;		/* aktueller User beim Suchen		     */
  char	   *cpoisa;		/* Temp fuer clipoi			     */
  unsigned ccntsa;		/* Temp fuer clicnt			     */
  char	   call[L2IDLEN];	/* User Call				     */
  char	   digil[L2VLEN];	/* Downlink Digiliste			     */
  char	   node[L2CALEN];	/* Ziel Node				     */
  BOOLEAN  isrufz;		/* Ergebniss der Suche nach Call	     */
  BOOLEAN  isnode;		/* Ergebniss der Suche nach Node	     */
  LNKBLK   *frelnk;		/* freier lnkpoi Platz			     */
  LNKBLK   *p_cblk;		/* Partner lnkpoi Block			     */
  CIRTYP   *cirp;

  if (!ismemr()) return;	/* noch Platz? 				     */

  if (clicnt != 0)		/* ohne Parameter -> Host connecten, wenn    */
   {				/* vorhanden. Sonst CircuitTableFull melden  */
    cpoisa = clipoi;		/* Parameter des Aufrufs retten		     */
    ccntsa = clicnt;
    isnode = getide(node);	/* Node angegeben?			     */
    clipoi = cpoisa;		/* Aufrufparameter zurueck		     */
    clicnt = ccntsa;

    if (
       (((isrufz = ((getcal(VCpar, call) == TRUE) &&
                    (getdig(FALSE, digil) != ERROR))
                    ) == TRUE)
        && (digil[0] == 0)
        && (iscall(call) == TRUE))
        || ((isnode == TRUE) && (isidnt(node) == TRUE)))
     {

/*=== Node soll connected werden ============================================*/

      cirpoi = cirtab;
      do
       {				  /* freien Platz in CIRTAB suchen   */
        if (cirpoi->state4 == 0) break;
       } while (++cirpoi < &cirtab[NUMCIR]);

      if (cirpoi != &cirtab[NUMCIR])			/* Erfolg dabei?	     */
       {
        userpo->cblk_p = (LNKBLK *) cirpoi;	/* in User Block eintragen   */
        userpo->typ_p = 4;			/* und Usertyp eintragen     */
        userpo->status = 2;			/* Status: connect requested */
        cpyid(cirpoi->downca, despoi->nodcal);
        cpyid(cirpoi->upcall, usrcal);		/* User Call merken	     */

/* Uplinkinformation weitergeben					     */

	if (userpo->typ_u == 4)			/* User ist Circuit	     */
	 {
	  cirp = (CIRTYP *) userpo->cblk_u;	/* vom anderen Circuit holen */
	  cpyid(cirpoi->upnod,cirp->upnod);	/* Uplinkknoten holen	     */
	  cpyidl(cirpoi->upnodv,cirp->upnodv);	/* Digikette auch	     */
	 }
	else					/* User ist L2-Link	     */
	 {					   
	  frelnk = (LNKBLK *) userpo->cblk_u;		/* aus L2 holen	     */
	  cpyid(cirpoi->upnod,myid);			/* Uplink hier	     */
	  cpyidl(cirpoi->upnodv,frelnk->viaidl);	/* Digikette	     */
	 }
        cirpoi->l3node = despoi;	/* CIRTAB Eintrag mit Userdaten	     */
        newcir();			/* Circuit aufbauen		     */
       }
      else puttfu("Circuit");		/* kein Platz: melden		     */
      return;
     }

    if (!cmpmyc(call))			/* Downlink -> Myid = Host connecten */
     {
/*=== User soll connected werden ============================================*/
      if (isrufz == TRUE)		/* gueltiges Call?		     */
       {
        for (usrpoi = (USRTYP *) usccpl.head;	/* Antwort auf CQ-Ruf?	     */
             (USRTYP *) &usccpl != usrpoi;
              usrpoi = usrpoi->unext)
         {				/* Userliste absuchen		     */
          if ((usrpoi->status == 2)	/* Status muss stimmen		     */
            &&(usrpoi->typ_p == 2)	/* gesuchter Partner muss stimmen    */
            &&((p_cblk = usrpoi->cblk_p)->state == 0))	/* und noch kein L2  */
           {
            if (cmpid(p_cblk->srcid, call) == TRUE)	/* und eigenes Call  */
             {
              disusr(p_cblk, 2);	/* dann aus CCP entfernen	     */
              for (ptcrdp = ptcrdl;
		   ptcrdp->luserl != NULL;
		   ptcrdp += 2)
                ;			/* freier Eintrag links		     */
              makcon(usrpoi);		/* Verbindung herstellen	     */
              ++ptcrdp;			/* auf rechte Seite		     */
              frelnk = (LNKBLK *) userpo;
              userpo = usrpoi;
              makcon(usrpoi = (USRTYP *) frelnk);	/* zweite Seite      */
              kilusr();					/* Partner loeschen  */
              userpo = usrpoi;
              kilusr();			/* eigenen Eintrag loeschen	     */
              return;
             }
           }
         }
                                        /* Connect in L2 absetzen	     */
        invsid();			/* SSID aendern			     */

        p_cblk = NULL;				 /* freien Eintrag finden    */
        lnkpoi = lnktbl;
        do
         {
          if (lnkpoi->state != 0)	/* Eintrag leer?		     */
           {
            if ((cmpid(lnkpoi->srcid, usrcal) == TRUE)
                && (cmpid(lnkpoi->dstid, call) == TRUE))
             {
              msgfrm('D', lnkpoi, 2, dmmsg); /* nicht gleiche Partner 2-mal    */
              return;
             }
           }
          else				/* leerer Eintrag gefunden:	     */
           {
            if ((!p_cblk) && (lnkpoi->srcid[0] == 0))
              p_cblk = lnkpoi;		/* den ersten merken		     */
           }
         } while (++lnkpoi < &lnktbl[LINKNMBR]);


/* ----- ggf. Downlink sperren ------------------- DF6LN   DL2LAY ---------  */
	
        if ((p_cblk != NULL)		/* freier Platz da?		     */
	    && (!(Flags&2)) 		/* und nicht gesperrt		     */
            || (userpo->sysflg != 0))	/* oder Sysop                        */
	 {				/* Downlink erlaubt?     	     */

/* ------------------------------------------------------------------------  */

          lnkpoi = p_cblk;		/* merken			     */
          setl2b();			/* L2 Block initialisieren	     */
          cpyid(lnkpoi->dstid, call);	/* Partner Call			     */
          cpyidl(lnkpoi->viaidl, digil);/* Digipeater			     */
          lnkpoi->liport = HDLCPORT;	/* Port ist HDLC		     */
          newlnk();			/* an Level2 melden		     */
         }
        else				/* alles voll			     */
         {
	  nolnk();			/* 'Link table full' melden	     */
         }
       }
      else
       {
        invcal();
       }
      return;
     }
   }

/*=== Host soll connected werden ============================================*/

  puttfu("Host");			/* kein Kanal frei		     */
 }

/*****************************************************************************\
*									      *
* ccpcon()	Connect-Befehl ggf. mit Bestaetigung			      *
*									      *
\*****************************************************************************/

VOID ccpcon()
 {
  ccpco();			/* erst Connect-Befehl bearbeiten	     */
  if (userpo->status == 2)	/* Connect laeuft?			     */
   {
    shotx0(COTXT);		/* Bestaetigungstext zeigen, wenn vorhanden  */
   }
 }

/*****************************************************************************\
*									      *
* ccpcq()	CQ-Befehl						      *
*									      *
\*****************************************************************************/

ccpcq()				/* CQ-Ruf starten			     */
  {
  MBHEAD    *mbhd;			/* Buffer fuer Meldung		     */

  if (Flags&2)
   {
    nolnk();
    return;
   }
  if (ismemr() == TRUE)			/* Platz genug?			     */
   {
    lnkpoi = lnktbl;
    do
     {					/* freien Platz in L2-Liste suchen   */
      if ((lnkpoi->state == 0) && (lnkpoi->srcid[0] == 0))
        break;
     } while (++lnkpoi < &lnktbl[LINKNMBR]);

    if (lnkpoi < &lnktbl[LINKNMBR])
     {
      invsid();				/* SSID umdrehen		     */
      setl2b();				/* L2 Kontrollblock initialisieren   */
      if (cqen == TRUE)			/* CQ-Ruf zulaessig?		     */
       {
        (mbhd = (MBHEAD *) allocb())->l2fflg = L2CPID;	/* PID setzen	     */
        while (clicnt != 0)		/* Rest der Zeile ist Meldung	     */
         {
          putchr(*clipoi, mbhd);	/* umkopieren			     */
          nxtcli();
         }
        putcr(mbhd);				 /* Zeilenende anhaengen     */
        sdui(cqdil,cqdest,usrcal,HDLCPORT,mbhd); /* senden		     */
        dealmb(mbhd);				 /* Buffer wieder freigeben  */
       }
      shotx0(CQTXT);			/* bestaetigen, dass CQ angekommen   */
     }
    else				/* Tabelle ist voll		     */
      nolnk();				/* 'Link table full' melden	     */
   }
  }

/*****************************************************************************\
*									      *
* ccpflg()	FLAG-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpflg()		/* FLAG Befehl                               */
 {
  unsigned i;
  unsigned bitmsk;
  MBHEAD    *bufpoi;

  if (issyso() == TRUE)
   {
    bitmsk = 1 << nxtnum();
    if ((i = nxtnum()) < 2) Flags = !i ? (Flags & ~bitmsk) : (Flags | bitmsk);
    else
     {
      putmsg("Bad value (0,1)");
      return;
     }
   }
  if (!syscmd())
   {
    bufpoi = putals("Flags:");
    i = 0;
    do
     {
      pspnum((Flags >>i) & 1,bufpoi);
     } while (++i < 16);

    prompt(bufpoi);
   }
 }

/*****************************************************************************\
*									      *
* ccpide()	ID-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpide()		/* ID Befehl                                 */
 {
  MBHEAD    *bufpoi;

    if (userpo->sysflg == TRUE)		/* ohne Sysop laeuft nix	     */
    {
      if (issyso() == TRUE)		/* Sysop setzt IDs                   */
      {
	getide(alias0);
	if (nxtnos() == TRUE) getide(alias1);
	if (nxtnos() == TRUE) getide(alias);
      }
      bufpoi = putals("ID0: ");
      pu6chr(alias0,bufpoi);
      pu6chr(alias1,putstr(" ID1: ",bufpoi));
      pu6chr(alias,putstr(" User-ID: ",bufpoi));
      prompt(bufpoi);
    }
    else nocmd();
  }

/*****************************************************************************\
*									      *
* ccpinf()	Info-Text abfragen oder vom Sysop einen der diversen Texte    *
*		aendern oder loeschen					      *
*									      *
* Die Texte sind in normalen Puffern gespeichert und koennen daher beliebig   *
* lang werden, belegen aber keinen Platz, wenn nicht gesetzt.		      *
*									      *
\*****************************************************************************/

VOID ccpinf()
 {
  MBHEAD  *bufpoi;			/* Text-Buffer			     */
  unsigned num;				/* Textnummer			     */
  BOOLEAN  escape;			/* Sonderzeichenbehandlung	     */
  BOOLEAN  clri;

  if (issyso() == TRUE)			/* Sysop will aendern		     */
   {
    num = *clipoi;
    if (clri = (num == '-'))
     {
      nxtcli();
      nxtnos();
     }
    if ((num = *clipoi - '0') >= TEXTE)		/* Textnummer muss stimmen   */
     {
      putmsg("\7?eh");			/* falsche Textnummer		     */
      return;				/* Abbruch			     */
     }
    nxtcli();
    if (clri)
     {
      if ((bufpoi = text[num]) != NULL)
       {
	dealmb(bufpoi);
	text[num] = NULL;
       }
      return;
     }    
    if (!nxtnos())			/* kommt denn auch wirklich etwas?   */
     {
      putmsg("Info?");			/* Text fehlt			     */
      return;				/* Abbruch			     */
     }
    if (text[num] == NULL)		/* wenn Text noch nicht belegt	     */
      text[num] = (MBHEAD *) allocb();	/* Text neu anlegen		     */
    bufpoi = text[num];
    endbuf(bufpoi);			/* ans Textende			     */
    escape = FALSE;			/* erstmal keine Sonderbehandlung    */
    while(clicnt-- > 0)			/* solange Text eingegeben	     */
     {
      if (escape == FALSE)		/* keine Sonderbehandlung?	     */
       {
	if (*clipoi == lincar)		/* aber jetzt?			     */
	 {
	  escape = TRUE;		/* Sonderbehandlung einschalten	     */
	  if (clicnt == 0)		/* es kommt nix weiter?		     */
	    putcr(bufpoi);		/* dann soll's ein <CR> sein	     */
	  ++clipoi;			/* Zeichen ist weg		     */
	  continue;			/* nun zum naechsten		     */
	 }
       }
      escape = FALSE;			/* keine Sonderbehandlung mehr	     */
      putchr(*clipoi++,bufpoi);		/* Zeichen in Puffer schreiben	     */
     }
    bufpoi = puttxt(num);		/* Text komplett in Buffer	     */
    if (!(Flags&4096))			/* Flag 12 gesetzt?		     */
      prompt(bufpoi);			/* nein - Text anzeigen		     */
    else				/* Flag gesetzt - nicht anzeigen     */
      dealmb(bufpoi);			/* also weg damit ..		     */
   }
  else					/* keine Aenderung		     */
   {
    if (!nodbsy()) shotx1(ITXT);	/* Infotext anzeigen		     */
   }
 }

/*****************************************************************************\
*									      *
* ccpled()	LED-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpled()
 {
  if (issyso() == TRUE)
   {
    LEDS(); 
    putmsg("LEDs set");
   }
  else nocmd();
 }

/*****************************************************************************\
*									      *
* ccpmh()	Abfragen der Heardliste (Mheard-Befehl)			      *
*									      *
\*****************************************************************************/

VOID ccpmh()
 {
  MBHEAD   *fbp;
  unsigned cnt;
  HRDTYP   *hrd;

  fbp = putals("MHEARD:\15");
  hrd = hrdlis;
  cnt = 0;				/* gesamte Heardliste bearbeiten     */
  do
   {
    fbp->l4time = fbp->mbpc;		    /* Position merken fuer putspa() */
    if (hrd->hrdcal[0] != ' ')		    /* Platz mit Call belegt?	     */
     {
      puttim(hrd->hour,hrd->min,fbp);	    /* zuletzt gehoerte Zeit	     */
      putchr('=',fbp);			    /* Trennung			     */
      putid(hrd->hrdcal,fbp);		    /* Call hinterher		     */
      if (++cnt == 5)			    /* 5 Calls je Zeile		     */
       {
	putcr(fbp);			    /* Zeile voll - neue Zeile	     */
	cnt = 0;
       }
      else putspa(16,fbp);		    /* Abstand zum naechsten Eintrag */
     }
    else break;				/* letzter Eintrag gefunden - fertig */
   } while (++hrd < &hrdlis[MAXHRD]);

  prompt(fbp);				/* abschicken mit Prompt bei Bedarf  */
 }

/*****************************************************************************\
*									      *
* ccpnod()	NODES-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpnod()		/* NODES Befehl				     */
{
  MBHEAD   *bufpoi;		/* Buffer fuer Meldung an User		     */
  unsigned cnt;			/* Scratch Zaehler			     */
  char	   newcal[L2IDLEN];	/* neues Call				     */
  char	   niden[L2CALEN];	/* neuer Ident				     */
  char     *cpoisa;		/* temp fuer clipoi			     */
  BOOLEAN  alles;		/* versteckte Nodes auch zeigen		     */
  BOOLEAN  newlist;             /* neues Listenformat                        */
  unsigned nobc;		/* neuer Abwesenheitszaehler		     */
  unsigned wegcnt;		/* Zaehler fuer Wege in Ausgabe		     */
  unsigned aender;		/* Aenderungsmode: + oder -		     */
  BOOLEAN  isrufz;		/* Ergebniss des Tests auf gueltiges Call    */
  BOOLEAN  isnode;		/* Ergebniss des Tests auf gueltigen Node    */
  unsigned ccntsa;		/* temp fuer clicnt			     */
  BOOLEAN  neupar;		/* neue Parameter in der Zeile		     */
  WEGTYP   *actweg;		/* aktueller Weg der Ausgabe		     */
  NBRTYP   *nabar;		/* Nachbar fuer aktuellen Node		     */
  USRTYP   *usrsav;		/* temp fuer userpo			     */
  unsigned nodlt;

  alles =			/* default: keine versteckten Nodes	     */
  newlist = FALSE;              /* default: altes Listenformat         1.16f */


  if (clicnt != 0)		/* mit Argument aufgerufen?	   	     */
  {
    cpoisa = clipoi;		/* Befehlszeile retten		   	     */
    ccntsa = clicnt;
    isnode = getide(niden);	/* Test auf Node Namen			     */
    clipoi = cpoisa;		/* Befehlszeile zurueck			     */
    clicnt = ccntsa;
    isrufz = getcal(VCpar, newcal); 	/* Test auf Call		     */
    clipoi = cpoisa;			/* Befehlszeile zurueck		     */
    clicnt = ccntsa;

    newlist = cmpcal(niden,hidide);

    while (clicnt != 0)
    {
      if (*clipoi == ' ') break;
      nxtcli();			/* Call bzw Ident ueberlesen		     */
    }

    if ((isrufz == TRUE)	/* alle Nodes oder was spezielles gefragt?   */
       || ((isnode != ERROR)
	  && !newlist))
    {                                   /* spezielles                        */
      neupar = FALSE;			/* default: keine neuen Parameter    */
 
      if ((issyso() == TRUE)		/* nur Sysop darf aendern	     */
         && (isrufz == TRUE))		/* wenn er ein Call angibt	     */
      {
        --clicnt;			/* Aenderungsmode uebergehen	     */
    
        if (((aender = *clipoi++) == '+') /* nur + oder - erlaubt	     */
           || (aender == '-'))
        {

/*=== Node Parameter aendern ================================================*/
          if (nxtnos() == TRUE			 /* Parameter holen	     */
             && ((isnode = getide(niden)) != ERROR)) /* Ident		     */
          {

            if (getqua() == TRUE)	/* Qualitaet holen		     */
            {

              if (nxtnos() == TRUE
                 && ((nobc = nxtnum()) <= 255))
              {
		if (nxtnos() == TRUE
		    && ((nodlt = nxtnum()) <= 255))
		 {
		  if (getpar() == TRUE)
			neupar = TRUE;		/* Port, Digis, Nachbar	     */
		 }
              }
            }
          }
        }
      } /* issyso */
      else 
      if (isnode == FALSE) alles = TRUE;	/* Sternchen eingegeben	     */

      if (neupar == TRUE) 		/* neue Werte spezifiziert	     */
      {
	usrsav = userpo;
        if (chgnod(aender, nobc, nquali, nport, ndigi,
		   ncall, niden, newcal, nodlt) == FALSE) 
        {
          puttfu("Routing");		/* hat nicht geklappt, Ende	     */
          return;
        }
	userpo = usrsav;
      }



      if (((isrufz == TRUE) && (iscall(newcal) == TRUE))   /* gueltiges Call */
         || ((isnode == TRUE) && (isidnt(niden) == TRUE))) /* Node?	     */
      {

        putnod(bufpoi = putals("Routes to: "));		 /* gueltig:	     */
        wegcnt = 0;
	do
        {				/* alle Wege zeigen		     */
          nabar = (actweg = &despoi->weg[wegcnt])->nachba;
          putstr((((despoi->actrou != 0) && (despoi->wegnr == wegcnt)) ?
          "\15> " : "\015  "), bufpoi);	/* aktiven Weg markieren	     */
          putnbr(nabar, pspnum((actweg->lifeti) &0xff,	/* Nachbarn Zeigen   */
		pspnum((actweg->obscnt) & 0xff,
			putnum((actweg->qualit) &0xff, bufpoi))));
        } while (++wegcnt < despoi->wege);

        prompt(bufpoi);			/* Ende anhaengen		     */
        return;
      }
      else                                                          /* 1.16e */
      if ((isnode == TRUE) || (isrufz == TRUE))
      {
        putmsg("No entry");
	return;
      }
    }
  }

  /*=== Nodes anzeigen ======================================================*/
  if (nodbsy() == TRUE) return;
  bufpoi = putals("Nodes (");		/* Kopfzeile holt Buffer	     */
  putnum(numdes,bufpoi);
  putstr("):\15",bufpoi);
  cnt = 0;
  for (despoi = (NODTYP *) destil.head;	/* gesamte Liste		     */
      (NODTYP *) &destil != despoi;
      despoi = (NODTYP *) despoi->nodlnk.head) 
   {
    if (despoi->nodcal[0] != 0) 	/* Eintrag definiert?		     */
     {
      if (  (despoi->nodide[0] > 0x2F) 
         || (userpo->sysflg == TRUE)
         || (alles == TRUE))
       {                               /* auch versteckte Nodes zeigen?      */
        bufpoi->l4time = bufpoi->mbpc;
        if (newlist == TRUE)
         {
          putalt(despoi->nodide,bufpoi);
          putspa(7,bufpoi);
          putspa(17,putid(despoi->nodcal,bufpoi));
          putspa(21,putnum(despoi->weg->qualit &0xff,bufpoi));
          putnum(despoi->weg->obscnt &0xff,bufpoi);
          if (++cnt != 3)
	   {
	    putspa(26,bufpoi);
           }
	  else
	   {
	    putcr(bufpoi);
	    cnt = 0;
	   }
	 }
        else 
         {
          putnod(bufpoi);
	  if (++cnt != 4)
           {
	    putspa(19,bufpoi);
	   }
	  else
	   {
	    putcr(bufpoi);
	    cnt = 0;
	   }
         }
       }
     }
   }
  prompt(bufpoi);			/* Endekennung anhaengen	     */
 }

/*****************************************************************************\
*									      *
* partab	Parametertabelle - Adressen, Minimal- und Maximalwerte der    *
*		verschiedenen Parameter beim PARMS-Befehl		      *
*									      *
\*****************************************************************************/

PARTYP	partab[39] = {		/* Parameter Tabelle			     */
	&maxdes,   1,    100,	/* maximale Laenge der Nodes-Liste	     */
	&worqua,   0,    255,	/* minimale Qualiatet fuer Autoupdate	     */
	&ch0qua,   0,    255,	/* HDLC Kanal Qualitaet			     */
	&ch1qua,   0,    255,	/* RS232 Kanal Qualitaet		     */
	&obcini,   0,    255,	/* Anfangswert Knotenlebensdauer	     */
	&obcbro,   1,    255,	/* min Wert Restlebensdauer fuer Rundspruch  */
	&broint,   0, 0xffff,	/* Rundspruchintervall			     */
	&timliv,   1,    255,	/* Anfangswert Paketlebensdauer		     */
	&tratou,   5,    600,	/* Timeout in Level4			     */
	&tratri,   2,    127,	/* Versuche in Level4			     */
	&traack,   1,     60,	/* Level4 Wartezeit bis ACK		     */
	&trabsy,   1,   1000,	/* Level4 Busy Wartezeit		     */
	&trawir,   2,    127,	/* vorgeschlagene Fenstergroesse in Level4   */
	&conctl,   1,    127,	/* gebufferte Frames je Verbindung	     */
	&ininat,   0, 0xffff,	/* no-activity-timeout			     */
	&Ppar,     0,    256,	/* Entschlossenheit fuer Sendung frei        */
	&Wpar,     0,    255,	/* Zeitschlitzbreite			     */
	&Fpar,     1,     15,	/* Level2, Timer1			     */
	&Opar,     1,      7,	/* Level2, Fenstergroesse		     */
	&Npar,     0,    127,	/* Level2, Versuche			     */
	&T2par,    0,   6000,	/* Level2, Timer2 f. HDLC-Port		     */
	&T3par,    0, 0xffff,	/* Level2, Timer3			     */
	&Rpar,     0,      1,	/* Level2 Digipeating Freigabe		     */
	&VCpar,    0,      1,	/* Calls pruefen			     */
	&beacen,   0,      2,	/* Bake ein-aus				     */
	&cqen,     0,      1,	/* CQ-Ruf ein-aus			     */
	&Dpar,     0,      1,   /* Full-Duplex j/n                           */
	&xFpar,    0,      1,   /* Flags in den Pausen j/n                   */
	&Tpar,     0,    255,	/* TX-Delay                                  */
	&Flags,	   0, 0xffff,   /* Diverse Flags                             */
	&minbuf,   0,    600,   /* minimale freie Buffer fuer CCP-Freigabe   */
	&lincar,   0,    127,   /* Character fuer Leerzeichen in Info        */
				/* nicht > 127, da char als signed definiert.*/
				/* gibt sonst Probleme mit ?gcs wg. sign ext.*/
	&myqua,	   0,	 255,	/* Qualitaet des eigenen Eintrags	     */
	&Ypar,	   1,LINKNMBR,	/* max. L2-Verbindungen			     */
	&Fpar1,	   1,	  15,	/* Frack fuer RS-232-Port		     */
	&T2par1,   0,	 600,	/* Level2, Timer2 f. RS-232-Port	     */
	&Opar1,	   1,      7,	/* Maxframe RS-232-Port			     */
	&minhr,	   0, 0xffff,	/* Anfangsstunde L2-Protokoll-Aenderung	     */
	&maxhr,	   0, 0xffff	/* Endstunde L2-Protokoll-Aenderung	     */
	};

/*****************************************************************************\
*									      *
* ccppar()	PARMS-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccppar()		/* PARMS Befehl				     */
  {
  MBHEAD   *bufpoi;		/* Message Buffer			     */
  unsigned laenge;		/* Laenge der Zeile bisher		     */
  unsigned newval;		/* neuer Wert des Parameters		     */
  unsigned parnum;		/* Nummer des aktuellen Parameters	     */
  PARTYP   *parpoi;		/* Pointer auf aktuellen Parameter	     */
  unsigned altDpar;		/* alter Dpar-Wert			     */

  if (!syscmd())
   {
    bufpoi = putals(nulstr);			/* Kopfzeile		     */
    altDpar = Dpar;
    laenge = parnum = 0;
    parpoi = partab;
    do
     {
      if (issyso() == TRUE)			/* Sysop am anderen Ende?    */
       {
	if (*clipoi != '*')			/* Wert aendern?	     */
	 {
	  newval = nxtnum();			/* neuen Wert holen	     */
	  if ((newval >= parpoi->minimal) && (newval <= parpoi->maximal))
           *(parpoi->paradr) = newval;
          else clicnt = 0;			/* Fehler: Rest vergessen    */
         }
        else					/* Parameter bleibt:	     */
         {
          nxtcli();				/* das Sternchen verbrauchen */
         }
       }
      if ((bufpoi->mbpc - laenge) > 72)
       {
        putcr(bufpoi);				/* neue Zeile		     */
        laenge = bufpoi->mbpc;
       }
      else putsp(bufpoi);
      putnum(*(parpoi->paradr), bufpoi);	/* Wert ausgeben	     */
      ++parpoi;
     } while (++parnum < (sizeof(partab) / sizeof(PARTYP)));

    if ((Dpar == 1) && (altDpar == 0))
     {
      DIinc();
      pushtx();
      decEI();
     }
    seteom(bufpoi,(userpo->sysflg == TRUE) ? PNEVER : PFLG);
/* Es gibt ein haeufig verwendetes Terminalprogramm (SP), das keinen Prompt  */
/* im gleichen Frame mag. Wenigstens der arme Sysop soll eine vernuenftige   */
/* Parameterauswertung von diesem Programm bekommen.			     */
/*				(Idee: DL2LAY, Ausfuehrung DF6LN)	     */
   }
 }

/*****************************************************************************\
*									      *
* ccpqui()	QUIT-Befehl von TheNetNode (DL8ZAW) uebernommen		      *
*									      *
\*****************************************************************************/

VOID ccpqui()
 {
  if (nmbfre > 256)	/* wenn reichlich Platz				     */
   {
    shotx0(DTXT);	/* Disc-Text erst anzeigen, wenn vorhanden	     */
   }
  disco();		/* User disconnecten				     */
 }

/*****************************************************************************\
*									      *
* ccprou()	ROUTES-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccprou()		/* ROUTES Befehl			     */
  {
  NBRTYP   *neigb;
  unsigned mode;
  MBHEAD   *mbhd;

  if (!syscmd()) {


  neigb = NULL;					/* default: kein Nachbar     */
  if (clicnt != 0)				/* aendern oder zeigen?	     */
   {
    if (getpar() == TRUE)			/* Nachbardaten holen	     */
     {
      neigb = (NBRTYP *) getnei(ndigi, ncall, nport);  /* existiert Nachbar? */
      if (issyso() == TRUE)			/* nur SYSOP darf aendern    */
       {
        mode = *clipoi;				/* Modus holen, merken	     */
	nxtcli();				/* Mode uebergehen	     */
        if (getqua() == TRUE)			/* Qualitaet muss passen     */
         {
          if (mode == '+')			/* blockieren?		     */
           {
            if (neigb == NULL)			/* Nachbar existiert nicht?  */
              neigb = (NBRTYP *) updnbr(ndigi, ncall, nport); /* erzeugen    */

            neigb->pathqu = nquali;		/* neue Daten setzen	     */
            neigb->nbrflg |= L3FLOCKED;		/* blockieren		     */
           }
          else
           {
            if (mode == '-')			/* freigeben?		     */
             {
              if (neigb != NULL)		/* wenn Nachbar existiert    */
               {
                neigb->pathqu = nquali;		/* neue Daten setzen	     */
                neigb->nbrflg &= ~L3FLOCKED;	/* nicht blockieren	     */
                if (neigb->nbrrou == 0)		/* wenn keine Wege aktiv     */
                 {
                  dealoc(unlink(neigb));	/* Eintrag loeschen	     */
                  neigb = NULL;
                 }
               }
             }
           }
         }
       }  /* if sysop */
     }
   }

  mbhd = putals("Routes:");			/* neue Daten zeigen	     */
  if (neigb == NULL)				/* kein Nachbar angegeben    */
   {
    for (neigb = (NBRTYP *) neigbl.head;
        (NBRTYP *) &neigbl != neigb;
         neigb = (NBRTYP *) neigb->nbrlnk.head)
     {						/* alle Wege zeigen	     */
      putrou(neigb, mbhd);
     }
   }
  else
    putrou(neigb, mbhd);			/* sonst Wege des Nachbarn   */

  prompt(mbhd);					/* Ende Kennung anhaengen    */

  }
}

/*****************************************************************************\
*									      *
* ccpres()	RESET-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpres()		/* RESET Befehl				     */
 {
  if (userpo->sysflg == TRUE)			/* darf nur der Sysop	     */
   {
    magicn = 0;					/* immer Kaltstart	     */
    reset();
   }
 else nocmd();
 }

/*****************************************************************************\
*									      *
* ccprst()	RESTART-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccprst()		/* RESTART Befehl			     */
 {
  if (userpo->sysflg == TRUE)			/* darf nur der Sysop	     */
   {
    reset();					/* Warmstart		     */
   }
 else nocmd();
 }

/*****************************************************************************\
*									      *
* ccpsys()	SYSOP-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpsys()		/* SYSOP Befehl				     */
  {

  unsigned cnt;			/* Scratch Zaehler			     */
  unsigned num;			/* Zufallszahl fuer Zeichenauswahl	     */
  unsigned chk;			/* Check Zaehler			     */
  MBHEAD   *bufpoi;		/* Buffer fuer Passwort-Zahlen		     */

    bufpoi = putals(nulstr);			/* Buffer besorgen	     */
    cnt = 0;
    do
     {
      do
       {
        do;
        while (((num = random()) >= 80)		/* Zufallszahl holen	     */
          || (defPWD[num] == ' '));		/* gueltiges Zeichen?	     */
        for (chk = 0; chk < cnt; ++chk)		/* keine Zahl doppelt	     */
         {
          if ((userpo->paswrd[chk] & 0xff) == num) break;
         }
       }
      while (cnt != chk);
      userpo->paswrd[cnt] = num; /* neue Zahl merken			     */
      pspnum(num +1, bufpoi);	/* dem User mitteilen			     */
     } while (++cnt < 5);

    seteom(bufpoi,PNEVER);
/* weil SP sauer reagiert auf einen Prompt im gleichen Frame musste dieser   */
/* entfallen!	(DF6LN)							     */
    userpo->status = 3;		/* neuer Status: Passwort soll kommen	     */
  }

/*****************************************************************************\
*									      *
* ccptst()	TEST-Befehl						      *
*									      *
\*****************************************************************************/

VOID    ccptst()                /* TEST Befehl                               */
 {
  MBHEAD   *fbp;
  unsigned  n;

  if ((userpo->sysflg == TRUE) || (Flags&1))
   {
    if (nodbsy() == TRUE) return;
    fbp = (MBHEAD *) allocb();	/* Puffer holen				     */
    fbp->l2port = HDLCPORT;	/* immer auf der HF-Seite		     */
    n = 4096;			/* 4096 Bytes 0x00 -> staendiger 0/1-Wechsel */
    do				/* bei HDLC (ohne Flags)		     */
     {
      putchr(0,fbp);
     } while (--n != 0);
    sdl2fr(fbp);		/* Monsterframe senden			     */
    putmsg("Test ok");
   }
  else nocmd();
 }

/*****************************************************************************\
*									      *
* ccpuse()	USERS-Befehl						      *
*									      *
\*****************************************************************************/

VOID	ccpuse()		/* USERS Befehl				     */
  {
  MBHEAD   *bufpoi;		/* MBHD fuer Meldungen			     */
  unsigned cnt;			/* Scratch Zaehler			     */
  BOOLEAN  CQ;
  USRTYP   *userp;		/* Userkontrollblock fuer CCP User	     */
  LNKBLK   *ucblk;		/* L2 User Kontrollblock		     */
  PTCTYP   *ptcp;

  if (nodbsy() == TRUE) return;
  bufpoi = putals(signon);			/* Kopf			     */
  putchr(')', putnum(nmbfre, bufpoi));		/* freie Buffer		     */

						/* erst die User mit Partner */
  cnt = 0;
  ptcp = ptcrdl;		/* Patchcord Liste absuchen  */
  do
   {
    if (ptcp->luserl != NULL)				/* Eintrag belegt?   */
     {
      putcr(bufpoi);
      bufpoi->l4time = bufpoi->mbpc;		/* Zeichen im Buffer merken  */
      putuse('L', ptcp->luserl, ptcp->lusert, bufpoi); /* linke Seite    */
      putspa(35, bufpoi);			/* Leerzeichen als Trennung  */

      putuse('R', (ptcp +1)->luserl,
	(ptcp +1)->lusert,			/* rechte Seite		     */
	putstr(" <--> ", bufpoi));		/* Verbindung steht	     */

/* DF3AV 1.1-e 'viaput' */
      viaput('L', ptcp->luserl,ptcp->lusert, bufpoi);
      viaput('R', (ptcp+1)->luserl,(ptcp+1)->lusert, bufpoi);
/* -------------------- */

     }
    ptcp += 2;			/* nur "linke" Eintraege     */
   } while (++cnt < ((NUMPAT +1) /2));


  for (userp = (USRTYP *) usccpl.head;		/* nun die User am CCP	     */
       (USRTYP *) &usccpl != userp;		/* bis zum Ende der Liste    */
       userp = userp->unext)
   {
    putcr(bufpoi);				/* neue Zeile je User	     */
    bufpoi->l4time = bufpoi->mbpc;		/* Zeichen im Buffer merken  */
    putuse('L', userp->cblk_u, userp->typ_u, bufpoi); /* immer links	     */
    if ((userp->status == 2) || (userp->status == 4)) /* Connect laeuft?     */
     {
      putspa(35, bufpoi);			/* Trennung		     */
      putstr(" <..> ", bufpoi);			/* Verbindung wartet	     */
      if ((userp->typ_p == 2)			/* wird L2 Verbindung?	     */
        &&((ucblk = userp->cblk_p)->state == 0)) /* Status: connect laeuft   */
       {
        CQ = TRUE;
        putid(ucblk->srcid, putstr("CQ(", bufpoi));	/* Partner ist "CQ"  */
        putchr(')', bufpoi);
       }
      else

/* DF3AV 'viaput' */
      {						/* andere L2 Verbindung	     */
        putuse('R', userp->cblk_p, userp->typ_p, bufpoi);
        CQ = FALSE;
      }
     }
     viaput('L', userp->cblk_u, userp->typ_u, bufpoi);
     if(CQ == FALSE && userp->status == 2)
     viaput('R', userp->cblk_u, userp->typ_u, bufpoi);
/* -------------- */

   }
  prompt(bufpoi);				/* Ende der Meldung setzen   */
  }

/*--- Ende Level7B ----------------------------------------------------------*/
