/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****						 *
*	       *****  *****						 *
*	     *****	*****		The Net.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
\************************************************************************/

/* Level 7, Utilities							     */
/* Version 1.01								     */
/* Hans Georg Giese, DF2AU, Hinter dem Berge 5, 3300 Braunschweig	     */
/* 14-MAY-88								     */
/* Aenderungen:                                                              */

/*	       150391 DF6LN: C!-Befehl zusaetzlich (Connect o. Reconnect)    */
/*	       160391 DF6LN: Uhrzeit					     */
/*	       200391 DF6LN: MHeard-befehl, Heard-Liste			     */
/*	       230192 DF6LN: Texte umgestellt auf Buffer		     */
/*	       260192 DF6LN: ROUTES-, PARMS-, FLAGS- und Y-Befehl nur fuer   */
/*			     Sysop zugaenglich, wenn Flags.13 gesetzt	     */
/*	       050292 DF6LN: ROUTES-, PARMS-, FLAGS- und Y-Befehl ueber	     */
/*			     syscmd() gesperrt (spart Platz)		     */
/*	       010892 DF6LN: Black List					     */
/*	       020892 DF6LN: Rufzeichenueberpruefung verbessert		     */

#include "l7.h"
#include "l7ue.h"


/*---------------------------------------------------------------------------*/
BOOLEAN DLflag()
 {
  return(((maxhr > 24)
	  || ((stunde >= minhr)		/* Uhrzeit muss passen fuer L2-	     */
	     && (stunde < maxhr)))	/* Sonderprotokoll		     */
	 && (!lnkpoi->liport));		/* nur bei HDLC-Port		     */
 }

/*---------------------------------------------------------------------------*/
VOID nolnk()
 {
  puttfu("Link");		/* 'Link table full' melden		     */
 }

/*---------------------------------------------------------------------------*/
VOID msgbp()
 {
  MBHEAD	*mbhd;			/* Buffer fuer Meldung		     */

  if (text[DLTXT] != NULL)
   {
    (mbhd = puttxt(DLTXT))->l2fflg = L2CPID;	/* Buffer mit Text und PID   */
    if (mbhd->mbpc > INFOLEN)			/* zu lang fuer UI-Frame?    */
      mbhd->mbpc = INFOLEN;			/* dann begrenzen	     */
    sdui(lnkpoi->viaidl,lnkpoi->dstid,
	 myid,HDLCPORT,mbhd);
    dealmb(mbhd);
   }
 }

/*---------------------------------------------------------------------------*/
MBHEAD *newbuf()	/* neuen Buffer holen mit Typ u. Link wie in userpo  */
 {
  MBHEAD *fbp;

  fbp = (MBHEAD *) allocb();
  fbp->type = userpo->typ_u;
  fbp->l2link = userpo->cblk_u;
  fbp->morflg = 0;
  return(fbp);
 }

/*****************************************************************************\
*									      *
* shotx0()	Text anzeigen, wenn vorhanden - ohne Prompt		      *
*									      *
\*****************************************************************************/

VOID shotx0(num)
unsigned num;
 {
  if (text[num] != NULL)		/* Text vorhanden?		     */
    seteom(puttxt(num),PNEVER);		/* dann diesen anzeigen		     */
 }

/*****************************************************************************\
*									      *
* shotx1()	Text anzeigen						      *
*									      *
\*****************************************************************************/

VOID shotx1(num)
unsigned num;
 {
  prompt(puttxt(num));
 }

/*---------------------------------------------------------------------------*/
BOOLEAN cprtnr()		/* feststellen, ob mit L4-Partner verbunden  */
 {
  PTCTYP   *ptcp;
  unsigned cnt;

  cnt = 0;					/* Patchcordliste absuchen   */
  ptcp = ptcrdl;				/* ob User connected zu	     */
  do						/* Partner		     */
   {
    if ((ptcp->lusert == 4)			/* Usertyp und		     */
	&& (ptcp->luserl == cirpoi))
     {
      cnt ^= 1;					/* auf andere Seite der	     */
      ptcp = &ptcrdl[cnt];			/* Verbindung		     */
      return(ptcp->lusert == 4);
     }
    ++ptcp;
   } while (++cnt < NUMPAT);
  return(FALSE);				/* User ist am CCP	     */
 }

/*---------------------------------------------------------------------------*/
VOID nxtcli()		/* zum naechsten Zeichen der Kommandozeile gehen     */
 {
  ++clipoi;
  --clicnt;
 }

/*---------------------------------------------------------------------------*/
MBHEAD *endbuf(puffer)		/* Rest des Puffers lesen		     */
MBHEAD *puffer;
 {
  while(morinb(puffer) != 0) getchr(puffer);
  return(puffer);
 }

/*---------------------------------------------------------------------------*/
MBHEAD *putsp(puffer)		/* Leerzeichen in Puffer schreiben	     */
MBHEAD *puffer;
 {
  putchr(' ',puffer);
  return(puffer);
 }

/*---------------------------------------------------------------------------*/
MBHEAD	*putnum(zahl, mbhd)	/* Zahl in Buffer MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
unsigned zahl;			/* auszugebende Zahl			     */
  {
  unsigned diviso;		/* Stellenwert der aktuellen Stelle	     */
  unsigned notnul;		/* fuehrende Null j/n			     */
  unsigned ziffer;		/* aktuelle Ziffer			     */
  unsigned numcnt;		/* Zahl der ausgegebenen Ziffern	     */

  notnul = FALSE;
  diviso = 10000;
  numcnt = 0;
  do
   {
    ziffer = zahl / diviso;
    if ((ziffer != 0) || (notnul == TRUE) || (diviso == 1)) {
      putchr((ziffer + '0'), mbhd); /* Stelle ausgeben			     */
      notnul = TRUE;
      }
    zahl %= diviso;
    diviso /= 10;
    } while (++numcnt < 5);
  return(mbhd);
  }

/*---------------------------------------------------------------------------*/
MBHEAD	*putstr(string, mbhd)	/* String in Buffer MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
char	*string;		/* auszugebender String			     */
 {
  while (*string != 0)		/* so lange der Vorrat reicht		     */
   {
    putchr(*string++, mbhd);	/* weg damit				     */
   }
  return(mbhd);
 }

/*---------------------------------------------------------------------------*/
MBHEAD	*pspnum(zahl,mbhd)	/* Leerzeichen + Zahl in Puffer schreiben    */
MBHEAD	*mbhd;
unsigned zahl;
 {
  return(putnum(zahl,putsp(mbhd)));
 }

/*---------------------------------------------------------------------------*/
MBHEAD	*putid(call, mbhd)	/* Call mit SSID in MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
char	*call;			/* Call					     */
  {
  unsigned zeichen;		/* Scratch bei Ausgabe			     */
  unsigned cnt;			/* zaehlt Zeichen			     */
  char	   ssid;		/* SSID des Calls			     */

  cnt = 0;
  do
   {
    zeichen = *call++;		/* naechstes Zeichen holen		     */

    if (zeichen > ' ')		/* druckbar?				     */
      putchr(zeichen, mbhd);	/* dann raus				     */
    else 			/* nicht druckbar:			     */
     {
      if (zeichen < ' ') 	/* Leerzeichen uebergehen		     */
       {
	putchr('^', mbhd);	/* Kontrollzeichen mit Prefix		     */
	putchr((zeichen + '@'), mbhd);
       }
     }
   } while (++cnt < L2CALEN);		/* 6 Zeichen Call		     */
  ssid = (*call >> 1) & 0x0f;	/* SSID passend schieben		     */
  if (ssid != 0) {		/* nur SSID != 0 ausgeben		     */
    putchr('-', mbhd);		/* mit Trennstrich			     */
    putnum(ssid, mbhd);
    }
  return(mbhd);
  }

/*****************************************************************************\
*									      *
* syscmd()	Wenn Flags.13 gesetzt, werden einige Befehle nur noch fuer    *
*		den Sysop zugaenglich					      *
*									      *
* parameter:	-							      *
*									      *
* return:	TRUE:	Befehl nur fuer Sysop zulaessig und User wurde	      *
*			darueber informiert (nocmd())			      *
*		FALSE:	Befehl frei zugaenglich oder Sysop		      *
*									      *
\*****************************************************************************/

BOOLEAN syscmd()
 {
  if (!(Flags&8192) 			/* wenn Flags.13 nicht gesetzt	     */
      || (userpo->sysflg == TRUE))	/* oder Sysop			     */
    return(FALSE);			/* Befehl ist erlaubt		     */
  else					/* wenn Befehl gesperrt		     */
   {
    nocmd();				/* Fehlermeldung		     */
    return(TRUE);			/* Befehl nicht ausfuehren!	     */
   }
 }

/*****************************************************************************\
*									      *
* puttxt(num)	kopiert einen der Standardtexte (Connect-, Info-Text, usw.)   *
*		in einen neuen Buffer					      *
*									      *
* parameter:	0 - Connect-Text L2					      *
*		1 - Connect-Text L4					      *
* 		2 - Disconnect-Text					      *
* 		3 - Info-Text						      *
* 		4 - Aktuell-Text					      *
*		5 - Connect-Bestaetigung				      *
*		6 - CQ-Bestaetigung					      *
* 		7 - Baken-Text fuer miese Parameter			      *
*									      *
* return:	Zeiger auf Buffer mit kopiertem Text			      *
*									      *
\*****************************************************************************/

MBHEAD *puttxt(num)
unsigned num;
 {
  MBHEAD *txtpoi;		/* Text, der kopiert wird		     */
  MBHEAD *bufpoi;		/* in diesen Puffer wird geschrieben	     */

/* Puffer holen, bei Connect- und Disc-Text ohne Rufzeichen-Header	     */

  bufpoi = putalf(nulstr, ((num < ITXT) || (num > CQTXT))
			  ? PNEVER
			  : PFLG);

  if ((txtpoi = text[num]) != NULL)	/* wenn Text belegt		     */
   {
    rwndmb(txtpoi);			/* Text auf Anfang		     */
    addbuf(bufpoi,txtpoi);		/* in Puffer schreiben		     */
   }
  return(bufpoi);			/* das war's			     */
 }

/*****************************************************************************\
*									      *
* istxt(buffer)		Test, ob buffer fuer einen Text verwendet wird.	      *
*			Wird beim Warmstart aufgerufen, damit Texte nicht     *
*			geloescht werden (von l2init).			      *
*									      *
* parameter:		Zeiger auf den in Frage kommenden Buffer	      *
*									      *
* return:		TRUE:	Buffer wird fuer einen Text benutzt	      *
*			FALSE:	Buffer wird nicht fuer einen Text benutzt     *
*									      *
\*****************************************************************************/

BOOLEAN istxt(buffer)
MB *buffer;
 {
  MBHEAD *txtpoi;		/* Pointer auf Text			     */
  unsigned cnt;			/* Zaehler fuer Textnummer		     */
  LHEAD *bufpoi;		/* Pointer im Text			     */

  cnt = 0;
  do
   {
    if ((txtpoi = text[cnt]) == NULL)	/* Text nicht verwendet -> naechsten */
      continue;				/* Text untersuchen		     */
    if (txtpoi == buffer) return(TRUE);	/* Text-Header = Buffer?	     */
    for (bufpoi = txtpoi->mbl.head;	/* einen Text durchsuchen ob einer   */
	 bufpoi != &txtpoi->mbl.head;	/* der Textbuffer gefragt ist	     */
	 bufpoi = bufpoi->head)
      if (bufpoi == buffer) return(TRUE);	/* wenn Buffer gefunden	     */
   } while (++cnt < TEXTE);			/* alle Texte untersuchen    */
  return(FALSE);				/* nix gefunden		     */
 }

/*****************************************************************************\
*									      *
* addbuf(dest,src)	Inhalt des Buffers src an den Inhalt des Buffers dest *
*			anhaengen					      *
*									      *
* parameter:	dest	dahin soll kopiert werden			      *
*		src	und von da kommt der zusaetzliche Krams		      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID addbuf(dest,src)
MBHEAD *dest;				/* Zielpuffer			     */
MBHEAD *src;				/* Quellpuffer			     */
 {
  while (morinb(src) != 0)		/* solange Zeichen im Quellpuffer    */
    putchr(getchr(src),dest);		/* diese kopieren		     */
 }

/*****************************************************************************\
*									      *
* addinf(dest,src)	Inhalt des Buffers src an den Inhalt des Buffers dest *
*			anhaengen, anschliessend mbbp und mbgc wieder zurueck *
*			auf die urspruenglichen Werte des Zielpuffers. Der    *
*			Quellpuffer wird nicht mehr benoetigt und daher	      *
*			deallokiert.					      *
*									      *
* parameter:	dest	dahin soll kopiert werden			      *
*		src	und von da kommt der zusaetzliche Krams		      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID addinf(dest,src)
MBHEAD *dest;				/* Zielpuffer			     */
MBHEAD *src;				/* Quellpuffer			     */
 {
  unsigned gc;				/* Zwischenspeicher fuer mbgc	     */
  char	  *bp;				/* Zwischenspeicher fuer mbbp	     */

  gc = dest->mbgc;			/* mbgc merken			     */
  bp = dest->mbbp;			/* mbbp auch			     */
  addbuf(endbuf(dest),src);		/* Info anhaengen ans Ende	     */
  dest->mbgc = gc;			/* mbgc zurueck			     */
  dest->mbbp = bp;			/* mbbp auch			     */
  dealmb(src);				/* Quellpuffer kommt auf den Muell   */
 }

/*****************************************************************************\
*									      *
* cpyhrd(dest,source)	einen kompletten Heardlisteneintrag kopieren	      *
*									      *
* parameter:	dest	hier soll der Eintrag hinkopiert werden		      *
*		source	dieser Eintrag soll kopiert werden		      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID cpyhrd(dest,source)
HRDTYP	*dest;				/* hierher kopieren		     */
HRDTYP	*source;			/* diesen Eintrag kopieren	     */
 {
  moveb(sizeof(HRDTYP),dest,source);
 }

/*****************************************************************************\
*									      *
* updhrd()	Heardliste auf neuesten Stand bringen			      *
*		Wird bei jedem empfangenen Frame von l2rx() aufgerufen.	      *
*									      *
* parameter:	-							      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID updhrd()
 {
  HRDTYP   *hrd;		/* momentan bearbeitetes Call		     */
  HRDTYP   *hrd1;		/* neues Call				     */
  HRDTYP   alt;			/* altes Call fuer Sortieren		     */
  HRDTYP   neu;			/* neues Call fuer Sortieren		     */

  if (!rxfprt)			/* MH-Liste nur fuer HF-Seite		     */
   {
    if (fvalca(TRUE,&rxfhdr[L2IDLEN]) != TRUE)	/* nur echte Rufzeichen	     */
      return;
    hrd = &neu;					/* neues Call zu bearbeiten  */
    cpyid(hrd->hrdcal,&rxfhdr[L2IDLEN]);	/* Absender holen	     */
    hrd->min = minute;				/* Empfangszeit merken	     */
    hrd->hour = stunde;

    hrd = hrd1 = hrdlis;			/* gesamte Heardliste	     */
    do
     {
      cpyhrd(&alt,hrd);				     /* altes Call aus Liste */
      cpyhrd(hrd,&neu);				     /* neues Call in Liste  */
      if (cmpid(hrd1->hrdcal,alt.hrdcal) == TRUE)    /* neues Call schon in */
	break;					     /* der Liste gewesen?   */
      cpyhrd(&neu,&alt);			     /* alt -> neu	     */
     } while (++hrd < &hrdlis[MAXHRD]);

   }			/* => geht das nicht einfacher? <= */
 }                      /* => und vor allem schneller?  <= */

/*****************************************************************************\
*									      *
* waicon()	feststellen, ob der aktuelle User auf Connect wartet	      *
*									      *
* parameter:	-							      *
*									      *
* return:	TRUE:	User wartet auf Connect				      *
*		FALSE:	User wartet nicht auf Connect			      *
*									      *
\*****************************************************************************/

BOOLEAN waicon()
 {
  return((userpo->status == 2)		/* war C-Befehl?		     */
	|| (userpo->status == 4));	/* oder C!-Befehl?		     */
 }


/*****************************************************************************\
*									      *
* puttim(st,mi,puffer)	Uhrzeit in einen Puffer schreiben (fuer Heardanzeige) *
*									      *
* parameter:	st	Stunde anzuzeigen				      *
*		mi	Minute anzuzeigen				      *
*		puffer	in diesen Puffer schreiben			      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID puttim(st, mi, puffer)
unsigned st;				/* Stunde			     */
unsigned mi;				/* Minute			     */
MBHEAD *puffer;				/* Zielpuffer			     */
 {
  if (st == ERROR)			/* Uhr war noch nicht gestellt, als  */
    putstr("--:--",puffer);		/* Station gehoert wurde	     */
  else					/* Uhr war schon gestellt	     */
   {
    putti1(st, puffer);			/* Stunde anzeigen		     */
    putchr(':',puffer);			/* Trennung dazu		     */
    putti1(mi, puffer);			/* Minute anzeigen		     */
  }
 }

/*****************************************************************************\
*									      *
* putti1(zahl,puffer)	Zahl zweistellig in Puffer schreiben fuer Uhrzeit     *
*									      *
* parameter:	zahl	Stunde oder Minute anzuzeigen			      *
*		puffer	in diesen Puffer schreiben			      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID putti1(zahl, puffer)	/* Zahl 2-stellig in Puffer schreiben	     */
unsigned zahl;
MBHEAD  *puffer;
 {
  if (zahl < 10) putchr('0',puffer);	/* ggf. mit fuehrender Null	     */
  putnum(zahl,puffer);			/* dann die Zahl		     */
 }

/*---------------------------------------------------------------------------*/
VOID	kilusr()		/* User abwerfen			     */
  {
  if (userpo->mbhd != NULL)	/* noch Info im Buffer?			     */
    dealmb(userpo->mbhd);	/* dann vernichten			     */

  dealoc(unlink(userpo));	/* User Kontrollblock auch wieder frei	     */
  userpo = NULL;		/* Userpointer ungueltig machen		     */
  }

/*---------------------------------------------------------------------------*/
VOID	invcal()		/* ungueltiges Rufzeichen melden	     */
  {
  putmsg("Invalid Call");
  }

/*---------------------------------------------------------------------------*/
VOID	makcon(usrp)		/* Verbindung melden, Eintrag herstellen     */
USRTYP *usrp;				/* Userkontrollblock		     */
  {
  msgfrm('U', (ptcrdp->luserl = usrp->cblk_u),
	      (ptcrdp->lusert = usrp->typ_u), conmsg);
  }

/*---------------------------------------------------------------------------*/
VOID	msgfrm(seite, link, user, msg)	/* Systemstatus melden		     */
unsigned seite;				/* Uplink - Downlink		     */
CTYP	 *link;				/* Kontrollblock des Users	     */
unsigned user;				/* Typ: 0=Host, 2=Level2, 4=Circuit  */
char	 *msg;				/* Meldung			     */
 {
  MBHEAD  *bufpoi;				/* MBHD der Meldung	     */

  bufpoi = putals(msg);				/* Meldung ausgeben	     */
  
  if (seite == 'D')				/* Downlink?		     */
   {
    if (user == 4)					/* User ist Circuit? */
      putalt(link->l3blk.l3node->nodide, bufpoi);	/* dann Ident vorweg */
   }
  putid(calofs(seite, link, user), bufpoi);	  /* Call immer ausgeben     */
  seteom(bufpoi,(msg == conmsg) ? PNEVER : PFLG); /* Endekennung	     */
  }

/*---------------------------------------------------------------------------*/
VOID	puttfu(name)		/* Tabelle voll melden			     */
char	*name;			/* Tabellenname				     */
 {
  seteom(putstr(" table full", putals(name)),PFLG);
 }

/*---------------------------------------------------------------------------*/
VOID	putmsg(string)		/* Meldung an User ausgeben		     */
char	*string;
 {
  seteom(putals(string),PFLG );		/* Meldung mit Endekennung raus	     */
 }

/*---------------------------------------------------------------------------*/
MBHEAD	*putalf(string,i)	/* String nach Nodeident in neuen Buffer     */
char	*string;		/* Rueckgabe: Pointer auf neuen Buffer	     */
unsigned i;	                /* PEVER:  0: Anfangsprompt kommt immer
				   PFLG    1: kommt nur wenn nicht Flags.9
				   PNEVER: 2: kommt nie                      */
  {
  MBHEAD *bufpoi;		/* neuer Buffer				     */

  bufpoi = (MBHEAD *) newbuf();	/* neue Buffer mit Userdaten		     */

  if (((!(Flags&512)) || (i == PEVER)) && (i != PNEVER))
    {
     paltid(bufpoi);	 	/* Ident schreiben			     */
     putstr("> ", bufpoi);	/* Trennzeichen				     */
    }

  return(putstr(string, bufpoi));	/* String dazu			     */
  }

/*---------------------------------------------------------------------------*/
MBHEAD	*putals(string)		/* String nach Nodeident in neuen Buffer     */
char	*string;		/* Rueckgabe: Pointer auf neuen Buffer	     */
 {
  return(putalf(string,PEVER));
 }

/*---------------------------------------------------------------------------*/
VOID	putrou(neigb, mbhd)	/* Weg zu einem Nachbarn ausgeben	     */
NBRTYP  *neigb;				/* Pointer auf den Nachbarn	     */
MBHEAD   *mbhd;				/* Buffer fuer die Meldung	     */
 {
  unsigned flg;

  putnbr(neigb,					/* Nachbarn ausgeben	     */
	putstr((neigb->nbrl2l == NULL)?		/* aktiver Weg?		     */
		"\015 " : "\015>", mbhd));
  pspnum((neigb->pathqu & 0xff), mbhd);		/* Qualitaet des Weges	     */
  pspnum(neigb->nbrrou, mbhd);			/* Zahl der Links	     */
  if ((flg = neigb->nbrflg) & L3FLOCKED)	/* fester Eintrag?	     */
    putstr(" !", mbhd);
  if (flg & L3FNBROK)				/* Nachbar connected?	     */
    putstr(" c", mbhd);
 }

/*---------------------------------------------------------------------------*/
VOID	putnbr(neigb, mbhd)	/* Daten eines Nachbarn ausgeben	     */
NBRTYP  *neigb;				/* Pointer auf den Nachbarn	     */
MBHEAD   *mbhd;				/* Buffer fuer die Meldung	     */
  {
  pspnum(neigb->nbrpor, mbhd);		/* Port Nummer			     */
  putid(neigb->nbrcal, putsp(mbhd));	/* Call nach Space als Trennung	     */
  putdil(neigb->nbrdil, mbhd);		/* Digiliste			     */
  }

/*---------------------------------------------------------------------------*/
VOID	putuse(seite, link, typ, mbhd) /* User Daten in MBHD legen	     */
MBHEAD	 *mbhd;			/* Kopf der Messageliste		     */
unsigned typ;			/* Usertyp: 0=Host, 2=Level2, 4=Circuit	     */
CTYP	 *link;			/* Kontrollblock			     */
unsigned seite;			/* L=uplink, R=downlink			     */
  {
  if (typ == 4)
   {
    putalt(link->l3blk.l3node->nodide,		/* Node ID		     */
	putstr("Circuit(", mbhd));
    putid(link->l3blk.downca, mbhd);		/* Node Call		     */

    putid(link->l3blk.upcall, putsp(mbhd));	/* User Call		     */
   }
  else
   {
    if (seite == 'L') 				/* Uplink oder Downlink?     */
     {
      putid(link->l2blk.dstid,			/* User Call		     */
	putstr("Uplink(", mbhd));
     }
    else 					/* Downlink:		     */
     {
      putid(link->l2blk.srcid,			/* User Call		     */
	putstr("Downlink(", mbhd));
      putid(link->l2blk.dstid, putsp(mbhd));	/* Gegenstation		     */
     }
   }
  putchr(')', mbhd);		/* Ende dieser Seite			     */
 }

/*---------------------------------------------------------------------------*/
VOID viaput(seite, link,typ,mbhd)	                  /* aus 1.1-e DF3AV */
				/* User Daten in MBHD legen		     */
MBHEAD	 *mbhd;			/* Kopf der Messageliste		     */
unsigned typ; 			/* Rueckgabe ob neue Zeile oder nicht  	     */
CTYP	 *link;			/* Kontrollblock			     */
unsigned seite;			/* L=uplink, R=downlink			     */
 {
  char *c;
  char *id;

  if(typ == 2)			/* nur bei Level2-Verbindungen		     */
   {
    c = link->l2blk.viaidl;	/* Pointer auf Anfang der VIA-Liste	     */
    if(*c != '\0')	        /* Nur arbeiten wenn Liste nicht leer        */
     {
      putcr(mbhd);
      putdil(c, putstr((seite == 'L') ?		/* Liste ausgeben	     */
		" Uplink" : " Downlink", mbhd));
     }
   }
  else
   {
    if (seite == 'L')			/* bei L4-Verbindungen Eingangsseite */
     {

/*****************************************************************************\
*									      *
* Die Uplinkinformation wird nur angezeigt, wenn entweder der letzte	      *
* Absenderknoten nicht der Uplinkknoten ist oder aber wenn beim Uplink Digis  *
* verwendet wurden. dann steht in einer eigenen Zeile:			      *
* ' Uplink @ uplinkknoten via digikette'				      *
*									      *
\*****************************************************************************/

     c = link->l3blk.upnodv;
     id = link->l3blk.upnod;
     if ((!cmpid(id, link->l3blk.downca))		/* Anzeige sinnvoll? */
	|| (*c != '\0'))
      {
       putcr(mbhd);				/* neue Zeile		     */
       putid(id, putstr(" Uplink @ ",mbhd));	/* Uplinkknoten		     */
       putdil(c,mbhd);				/* Uplinkdigis		     */
      }
    }
  }
}

/*---------------------------------------------------------------------------*/
VOID	putdig(liste, mbhd)	/* Digiliste in Puffer mbhd schreiben	     */
MBHEAD	*mbhd;			/* ohne 'via'				     */
char	*liste;
 {
  while (*liste != 0)		/* solange Calls vorhanden		     */
   {
    putid(liste,putsp(mbhd));	/* Call in Puffer schreiben		     */
    liste += L2IDLEN;		/* und zum naechsten			     */
   }
 }

/*---------------------------------------------------------------------------*/
VOID	putdil(liste, mbhd)	/* Digiliste in MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
char	*liste;			/* Digiliste, 0 am Ende			     */
 {
  if (*liste != 0)		/* existiert die Liste?			     */
   {
    putstr(" via", mbhd);	/* dann 'via' vorweg			     */
    putdig(liste,mbhd);		/* und Digiliste hinterher		     */
   }
 }

/*---------------------------------------------------------------------------*/
VOID	putnod(mbhd)		/* Knoten Info in MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
  {
  putalt(despoi->nodide, mbhd);	/* Ident ausgeben			     */
  putid(despoi->nodcal, mbhd);	/* und Call				     */
  }

/*---------------------------------------------------------------------------*/
VOID	paltid(mbhd)		/* Ident + Call in Buffer MBHD legen	     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
 {
  putalt(alias,mbhd);		/* Ident schreiben			     */
  putid(myid,mbhd);		/* Call schreiben			     */
 }

/*---------------------------------------------------------------------------*/
VOID	putalt(ident, mbhd)	/* Ident in Buffer MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
char	*ident;			/* auszugebender Ident			     */
  {
  if (*ident != ' ') {		/* ueberhaupt definiert?		     */
    putcal(ident, mbhd);	/* dann ausgeben			     */
    putchr(':', mbhd);		/* Trennzeichen hinterher		     */
    }
  }

/*---------------------------------------------------------------------------*/
VOID	putcal(call, mbhd)	/* Call in Buffer MBHD legen		     */
MBHEAD	*mbhd;			/* Kopf der Messageliste		     */
char	call[];			/* auszugebendes Call			     */
  {
  unsigned cnt;			/* Zaehler fuer Zeichen im Call		     */
  unsigned zeichen;		/* Scratch fuer aktuelles Zeichen	     */

  cnt = 0;
  do
   {
    zeichen = call[cnt];
    if (zeichen == ' ')		/* Leerzeichen nicht ausgeben		     */
      break;
    putchr(zeichen, mbhd);
   } while (++cnt < L2CALEN);		/* Call ist immer 6 Zeichen lang     */
  }

/*---------------------------------------------------------------------------*/
VOID	putspa(stop, mbhd)	/* bis stop die Zeile mit Space fuellen	     */
unsigned stop;				/* Ende der Leerraeume		     */
MBHEAD *mbhd;				/* Buffer der Meldung		     */
  {
  int cnt;				/* Scratch Zaehler		     */

  cnt = mbhd->l4time + stop - mbhd->mbpc;
  while (cnt-- > 0)
   {
    putsp(mbhd);
   }
  }


/*---------------------------------------------------------------------------*/
BOOLEAN getqua()
  {
   return (
	      (nxtnos() == TRUE)
	   && ((nquali = nxtnum()) <= 255)
	  );
  }


/*---------------------------------------------------------------------------*/
BOOLEAN getpar()		/* Parameter fuer Ziel holen		     */
  {
   return (
	     (nxtnos() == TRUE)
	   && ((nport = nxtnum()) < 2)
	   && (getcal(VCpar, ncall) == TRUE)
	   && (getdig(FALSE, ndigi) != ERROR)
	   );
  }

/*---------------------------------------------------------------------------*/
char viastr[] = "VIA  ";

getdig(pflag, outbuf)		/* Digiliste aus CLI-Buffer holen	     */
char     pflag;			/* Call-pruefen Flag			     */
char	 *outbuf;		/* Ziel fuer das Call			     */
  {
  unsigned zeichen;		/* Scratch				     */
  char	   *lispoi;		/* Pointer in liste			     */
  unsigned cnt;			/* Zaehler, Scratch			     */
  char	   liste[L2VLEN+1];	/* Zwischenspeicher			     */
  char	   *cpoisa;		/* Kopie von clipoi			     */
  unsigned ccntsa;		/* Kopie von clicnt			     */
  int	   caltyp;		/* Typ des letzten Call: 0=leer, -1=niO, 1=OK*/

  cpoisa = clipoi;			/* clipoi und clicnt merken, falls   */
  ccntsa = clicnt;			/* nicht 'VIA' eingegeben	     */
  if (getcal(FALSE, liste) == TRUE)	/* 'VIA' als Call holen		     */
   {
    lispoi = liste;

    cnt = 0;
    do							/* Call mit 'VIA  '  */
     {							/* vergleichen	     */
      zeichen = *lispoi++;
      if ((zeichen != viastr[cnt])	/* stimmt nicht ueberein	     */
	&& (zeichen != ' ')) break;	/* auch nicht abgekuerzt	     */
     } while (++cnt < L2CALEN);

    if (cnt != L2CALEN)			/* es war nicht VIA		     */
     {
      clipoi = cpoisa;
      clicnt = ccntsa;
     }
   }

  cnt = 0;
  lispoi = liste;
  do
   {						/* maximal 8 Digis	     */
    if (clicnt != 0)
     {
      if (((zeichen = *clipoi) == '+')
         ||(zeichen == '-'))
	break;
     }
    if ((caltyp = getcal(pflag, lispoi)) == ERROR) /* ungueltig? */
      return(ERROR);				/* Abbruch		     */
    if (caltyp == FALSE) break;			/* nichts mehr da: Ende	     */
    lispoi += L2IDLEN;
   } while (++cnt < L2VNUM);

  *lispoi = 0;					/* Endekennung		     */
  cpyidl(outbuf, liste);			/* in Ziel kopieren	     */
  return(*outbuf != 0);				/* Erfolg melden	     */
  }

/*---------------------------------------------------------------------------*/
getcal(pflag, outbuf) 		/* Call aus Buffer holen		     */
char	 pflag;			/* Call-pruefen Flag			     */
char	 *outbuf;		/* Ziel fuer das Call			     */
  {
  unsigned zeichen;		/* Scratch				     */
  unsigned cnt;			/* Zaehler, Scratch			     */
  char	   call[L2IDLEN];	/* Zwischenspeicher			     */
  unsigned binsid;		/* SSID, binaer				     */
  char	   *calpoi;		/* Pointer in Call			     */

  cpyid(call,nulide);

  nxtnos();					/* auf erstes Zeichen != ' ' */

  calpoi = call;				/* wieder nach vorn	     */
  cnt = 0;					/* gelesene Zeichen = 0	     */
  while (clicnt != 0) {				/* so lange Zeichen da sind  */
    if (((zeichen = upcase(*clipoi))		/* und gueltig		     */
       == ' ' ) || (zeichen == ',')) break;
    if (zeichen < ' ') return(ERROR);
    if (zeichen == '-') {			/* Trennung zum SSID?	     */
      if ((cnt == 0) || (clicnt == 0))
	return(ERROR);			/* Fehler: kein Call oder SSID	     */
      nxtcli();				/* Trennung uebergehen		     */
      if (clicnt == 0) return (ERROR); 	/* SSID angesagt, kommt aber nicht   */
      zeichen = *clipoi;		/* erste Ziffer SSID holen	     */
      if (!isnum(zeichen))		/* ungueltige Ziffer		     */
	return(ERROR);
      nxtcli();				/* Ziffer ist verbraucht	     */
      binsid = (zeichen - '0');		/* Binaer merken		     */
      if (clicnt != 0) {		/* noch Zeichen da?		     */
	zeichen = *clipoi;		/* holen			     */
        if (isnum(zeichen) == TRUE) {	/* gueltige Ziffer?		     */
          binsid *= 10;			/* 1. Ziffer 1 Stelle nach links     */
          binsid += (zeichen - '0');	/* + neue Ziffer		     */
          if (binsid > 15)
	    return(ERROR);		/* ungueltiger SSID		     */
          nxtcli();			/* letzte Ziffer verbrauchen	     */
          }
        }
      call[L2CALEN] = (binsid << 1) | 0x60;	/* SSID merken		     */
      break;
      }
    else {			/* kein SSID, anderes Zeichen		     */
      if (cnt++ == L2CALEN)
        return(ERROR);		/* Call zu lang				     */
      *calpoi++ = zeichen;	/* Zeichen merken			     */
      nxtcli();			/* Lesepointer rauf			     */
      }
    }
				/* Call ist im Buffer			     */
  while (clicnt != 0) {		/* Rest des Buffers ansehen		     */
    zeichen = *clipoi;		/* Zeichen holen			     */
    if ((zeichen != ' ')
	&& (zeichen != ','))
      break;			/* kein Trennzeichen, stop		     */
    nxtcli();			/* naechstes Zeichen			     */
    if (zeichen == ',') break;	/* Leerraum uebergehen			     */
    }
  if (cnt == 0) return(FALSE);		/* Call war leer		     */
  if (fvalca(pflag, call) == ERROR)
    return(ERROR);			/* Call war ungueltig		     */
  cpyid(outbuf, call);			/* Call kopieren		     */
  return(TRUE);				/* ok melden			     */
  }

/*---------------------------------------------------------------------------*/
getide(buffer)			/* Ident aus cli-Buffer holen		     */
char	buffer[];		/* -1=kein Erfolg, 0=leer, 1=Erfolg	     */
{
  unsigned cnt;			/* Zaehler, Scratch			     */
  unsigned zeichen;		/* Scratch				     */
  char	   ident[L2CALEN];	/* Zwischenspeicher			     */

  delcal(ident);		/* Zwischenspeicher loeschen		     */

  for (cnt = 0;
      (cnt < L2CALEN) && (clicnt != 0);
      ++cnt)
  {
    zeichen = upcase(*clipoi);	/* so lange Zeichen da und Buffer nicht voll */
    nxtcli();			/* Zeichen aus CLI-Buffer holen		     */

    if (zeichen != ' ')		/* Schluss bei Trennzeichen		     */
    {
      if ((isltr(zeichen) == TRUE)
	 || (isnum(zeichen) == TRUE)
	 || ((cnt == 0) && (zeichen == '#'))) /* gueltiges Zeichen?	     */
      {
	 ident[cnt] = zeichen;
	 continue;
      }
      if ((cnt != 0) || (zeichen != '*')) return(-1);     /* '*' als Ident   */
    }
    break;
  }


  if ((cnt == L2CALEN) && (clicnt != 0) && (*clipoi) != ' ')
    return(ERROR);			/* Ident zu lang? Fehler melden	     */

  if (valcal(ident) == TRUE)
    return(ERROR);			/* Ident darf kein Call sein	     */

  cpycal(buffer, ident);		/* umkopieren			     */

  return(ident[0] != ' ');
  }

/*---------------------------------------------------------------------------*/
unsigned nxtnum()		/* Zahl aus cli-Buffer holen		     */
 {
  unsigned temp;		/* Scratch				     */

  nxtnos();			/* auf erstes Zeichen != ' '		     */
  temp = 0;			/* Ergebnis = 0				     */
  while ((clicnt != 0)
	 && (isnum(*clipoi) == TRUE))
   {
    --clicnt;			/* mitzaehlen				     */
    temp *= 10;			/* Ergebnis eine Stelle weiter		     */
    temp += (*clipoi++ - '0');	/* + naechstes Digit			     */
   }
  return (temp);		/* mit Ergebnis zurueck			     */
 }

/*---------------------------------------------------------------------------*/
BOOLEAN isinbl(call)	/* Pruefen ob call in Black List steht (SSID egal)   */
char	*call;
 {
  unsigned n;

  n = 0;					/* auf Anfang		     */
  while(blklis[n] != 0)				/* noch ein Call in Liste    */
   {
    if (cmpcal(call,&blklis[n]) == TRUE)	/* gefunden?		     */
      return(TRUE);				/* ja ..		     */
    n += L2IDLEN;				/* nein - auf zum naechsten  */
   }
  return(FALSE);				/* nicht gefunden	     */
 }

/*---------------------------------------------------------------------------*/
fvalca(pflag, call)		/* Call pruefen: 0=leeres call, ohne Flag    */
char	*call;			/* -1=niO (m. Flag), 1=ok oder o. Flag	     */
BOOLEAN  pflag;
  {
  if (*call == ' ' ) return(0);		/* leer				     */
  if (!pflag) return (1);		/* nicht pruefen		     */
  if ((pflag != 2)			/* Schwarze Liste absuchen?	     */
      && (isinbl(call) == TRUE))	/* Call in Schwarzer Liste?	     */
    return(ERROR);
  return (valcal(call));		/* pruefen, valcal liefert Ergebnis  */
  }

/*---------------------------------------------------------------------------*/
valcal(call)			/* Call auf Gueltigkeit pruefen		     */
char	*call;			/* -1=ungueltiges Zeichen, 1=Call ist ok     */
  {
  unsigned zeichen;		/* aktuelles Zeichen			     */
  unsigned numpos;		/* Position der Zahl im Call		     */
  unsigned zahl;		/* Zahlen im Call			     */
  unsigned cnt;			/* gepruefte Zeichen			     */

  zahl =			/* keine Zahl gefunden			     */
  cnt = 0;			/* nichts geprueft			     */
  do
   {
    if ((zeichen = call[cnt]) == ' ')	/* Ende des Calls?		     */
     {
      break;
     }
    if (!isltr(zeichen))		/* Alfa ist immer gut		     */
     {
      if (isnum(zeichen)	/* Zahl nur ok, wenn max. 3. Stelle	     */
	  && (cnt < 3))
       {
        ++zahl;			/* Zahlen zaehlen			     */
        numpos = cnt;		/* Position merken			     */
       }
      else
       {
        return(ERROR);		/* ungueltiges Zeichen im Call		     */
       }
     }
   } while (++cnt < L2CALEN);	/* maximal 6 Zeichen Call		     */

  if (
       (cnt < 4)		/* minimal 4 Zeichen			     */
    || ((zahl == 2)		/* nicht 2 Zahlen am Anfang		     */
	&& (numpos == 1))
    || (zahl - 1 > 1)		/* min. 1 Zahl, max. 2 Zahlen		     */
    || (!numpos)		/* wenn nur 1 Zahl, nicht an erster Stelle   */
    || (numpos == (cnt -1)))	/* mindestens 1 Buchstabe Suffix	     */
    return(ERROR);		/* Call ist ungueltig			     */
  else return(TRUE);		/* Call ist gueltig			     */
  }

/*---------------------------------------------------------------------------*/
BOOLEAN isltr(zeichen)
unsigned zeichen;
 {
  return((zeichen >= 'A') && (zeichen <= 'Z'));
 }

/*---------------------------------------------------------------------------*/
BOOLEAN isnum(zeichen)
unsigned zeichen;
 {
  return ((zeichen >= '0') && (zeichen <= '9'));
 }

/*---------------------------------------------------------------------------*/
BOOLEAN nodbsy()
  {
  if (nmbfre < 256)
   {
    putmsg("Node busy");
    return(TRUE);
   }
  return(FALSE);
  }

/*---------------------------------------------------------------------------*/
BOOLEAN ismemr()		/* Test auf genuegend freien Speicher	     */
  {
  if (!userpo->sysflg)		/* Platz oder Sysop?	     */
   {
    if (nodbsy() == TRUE) return(FALSE);
   }
  cpyid(usrcal, calofs('U', userpo->cblk_u, userpo->typ_u));
  return(TRUE);
  }

/*---------------------------------------------------------------------------*/
VOID setl2b()			/* User Kontrollblock aufbauen		     */
  {
  userpo->cblk_p = lnkpoi;			/* Pointer auf L2-Block	     */
  userpo->typ_p = 2;				/* Partner ist L2	     */
  userpo->status = 2;				/* Status: connect laeuft    */
  cpyid(lnkpoi->srcid, usrcal);			/* Call eintragen	     */
  }

/*---------------------------------------------------------------------------*/
char *calofs(seite, link, user)	/* Offset Call-String im Kontrollblock	     */
unsigned user;			/* Usertyp: 0=Host, 2=L2-User, 4=Circuit     */
CTYP	 *link;			/* Linkkontrollblock			     */
unsigned seite;			/* Seite der Verbindung: U=uplink, D=downlink*/
  {
  if (user == 4) {		/* Circuit?				     */
    return ((seite == 'D') ?	/* welche Seite?			     */
      link->l3blk.downca : link->l3blk.upcall);
    }
  else return(link->l2blk.dstid);
  }

/*---------------------------------------------------------------------------*/
BOOLEAN getlin(mbhd)		/* Zeile im Messagebuffer verfuegbar?	     */
MBHEAD	*mbhd;
  {
  char	 *nextch;		/* naechstes Zeichen			     */
  unsigned getcou;		/* verfuegbare Zeichen			     */
  BOOLEAN  found;			/* Flag: Ueberlauf			     */
  unsigned laenge;		/* Laenge der Zeile			     */

  nextch = mbhd->mbbp;			/* Pointer auf naechstes Zeichen     */
  getcou = mbhd->mbgc;			/* verfuegbare Zeichen		     */
  found = FALSE;			/* default: Zeile nicht da	     */
  laenge = 0;				/* Laenge initialisieren	     */
  while (morinb(mbhd) != 0) { 		/* so lange Vorrat reicht	     */
    if (((getchr(mbhd) & 0x7f) == 0x0d) /* Zeichen = Zeilenende?	     */
      || (++laenge == 81)){		/* Zeile zu lang?		     */
      found = TRUE;			/* markieren			     */
      break;
     }
    }
  mbhd->mbbp = nextch;		/* MBHD auf alte Werte zurueck		     */
  mbhd->mbgc = getcou;
  return (found);
  }

/*---------------------------------------------------------------------------*/
invsid()			/* SSID umdrehen			     */
  {
  usrcal[L2CALEN] = 0x7e - (usrcal[L2CALEN] & 0x1e);
  }

/*---------------------------------------------------------------------------*/
BOOLEAN issyso()		/* Test auf Sysop Attribut		     */
  {
  return (
             (userpo->sysflg == TRUE)
          && (nxtnos() == TRUE) 		/* kein Sysop ohne Eingabe   */
         );
  }

/*---------------------------------------------------------------------------*/
BOOLEAN nxtnos()		/* auf naechstes Zeichen != ' ' in CLI-Zeile */
 {				/* TRUE wenn noch Zeichen vorhanden	     */
  while ((clicnt != 0) && (*clipoi == ' '))
   {
    nxtcli();
   }
  return (clicnt != 0);
 }

/*---------------------------------------------------------------------------*/
VOID timer()			/* alle 10ms Uhrzeit erhoehen		     */
  {
  ++tic10;
  }

/*---------------------------------------------------------------------------*/
VOID putcr(puffer)		/* <CR> in Puffer schreiben		     */
 {
  putchr(0x0d,puffer);
 }

/*---------------------------------------------------------------------------*/
BOOLEAN iswarm ()                   /* Test auf Warmstart		     */
  {
  return (magicn == MAGIC);    /* RAM noch intakt? dann Warmstart	     */
  }

/*--- Ende Level 7u ---------------------------------------------------------*/
