/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    TBA.C	-   The Boxware, Teil 1					 *
*									 *
*  angelegt:	DF6LN aus TFA.C von DC4OX mit diversen Aenderungen	 *
*									 *
*  modifiziert:	DF6LN  260492 Korrektur in tolink()			 *
*									 *
\************************************************************************/





/*							Includes	  */
/**************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			  */
#include "tb.h"		/* Festlegungen/Datenstrukturen fuer TheBoxware   */
#include "l234.h"	/* ------------"--------------- fuer Level 2 - 4  */
#include "tbext.h"	/* globale Variable / nicht int-Funktionen	  */





/**************************************************************************\
*									   *
* "main function"							   *
*									   *
* Hauptprogramm - wird nach der L1-Initialisierung aufgerufen		   *
*									   *
*		Alle Level initialisieren				   *
*		Hauptprogrammschleife - regelmaessiges Aufrufen von	   *
*					L2, L3, L4 und Host		   *
*									   *
\**************************************************************************/

mainf()
 {
  DIinc();			/* Int's stoeren erstmal		  */
  l4init();			/* L4 initialisieren			  */
  l3init();			/* L3 initialisieren			  */
  l2init();			/* L2 initialisieren			  */
  l7init();			/* Host initialisieren			  */
  srand();			/* Zufallsgenerator initialisieren	  */
  decEI();			/* Int's frei - nun geht's los!		  */
  hputs("\15\12The Boxware V 1.02b - ");		/* Startmeldung	  */
  hputud(NUMCIR);
  hputs(" Channel\15\12Copyright By NORD><LINK (DC4OX/DF2AU/DF6LN)\15\12");
  LOOP							/* Endlosschleife */
   {
    l2rx();
     l3rx();
      l4rx();
       l7();
       l4rest();
       l3rest();
       l2rest();
      l4tx();
     l3tx();
    l2tx();
   }
 }





/**************************************************************************\
*									   *
* "level x to level 7"                                                     *
*									   *
* Statusaenderungen werden aus Level 2 oder Level 4 gemeldet aber nur L4-  *
* Meldungen werden auch angezeigt.					   *
*									   *
\**************************************************************************/

VOID lxtol7(msg,lnk,lev)
char        msg;
LNKBLK     *lnk;
unsigned    lev;
 {
  char     *frmrp;
  MBHEAD   *mbp;

  if (lev == 4)				/* nur L4-Verbindungen		  */
   {
    putchr('(',mbp = allocb());		/* Puffer holen			  */
    putudc((cirpoi - cirtab) + 1,mbp);	/* Kanalnummer anzeigen		  */
    putstr(") ",mbp);
    putstr(l4msgs[msg - 1],mbp);	/* Circuitstatustext		  */
    if (!cirpoi->dir)			/* selbst connected		  */
     {
      putid(cirpoi->downca,mbp);
     }
    else				/* Connect kam von aussen	  */
     {
      putid(cirpoi->upcall,mbp);	/* Usercall in Puffer		  */
      if (!cmpid(cirpoi->upcall,cirpoi->upnod)
	 || cirpoi->upnodv[0] != '\0')
       {
	putstr(viasp,mbp);		/* " via " hinterher		  */
	putid(cirpoi->upnod,mbp);	/* dann Uplinkknoten		  */
	putvl(FALSE,cirpoi->upnodv,mbp);/* und Uplink-Vialiste		  */
       }
     }
    mbp->type = msg;
    relink(mbp, !ishmod			/* Im Terminalmodus immer, im	  */
	? statml.tail			/* Hostmodus nur auf angewaehl-	  */
	: chnlml[cirpoi-cirtab].tail);	/* tem Kanal anzeigen		  */
   }
 }





/**************************************************************************\
*									   *
* "from link"								   *
*									   *
*  Empfangene L4-Frames in MSG-Liste des entsprechenden Kanals umhaengen,  *
*  L2-Frames im Rundordner ablegen.					   *
*									   *
\**************************************************************************/

BOOLEAN fmlink(conflg, fbp)
BOOLEAN     conflg;		/* Congestion Flag (nicht verwendet)	  */
MBHEAD     *fbp;		/* Info-Puffer				  */
 {
  if (fbp->type == 4)				/* L4-Infos		  */
   {
    fbp->type = L4MNIX;				/* Info, nicht Status	  */
    relink(unlink(fbp),				/* umhaengen in Empfangs- */
	   chnlml[cirpoi-cirtab].tail);		/* Liste des Kanals	  */
   }
  else 
   {
    dealmb(unlink(fbp));		/* sonst verwerfen		  */
   }
  return(TRUE);				/* wurde immer uebernommen	  */
 }





/**************************************************************************\
*									   *
* "to link"								   *
*									   *
*  Info an den entsprechenden Circuit uebergeben fuer Sendeliste	   *
*									   *
\**************************************************************************/

VOID tolink(mbp)
MBHEAD *mbp;

 {
  MBHEAD mbhd;

  rwndmb(mbp);
  mbp->l2link = (LNKBLK *) cirpoi;
  inithd(&mbhd);
  relink(mbp, &mbhd);
  itocir(1,mbp);
 }



/**************************************************************************\
*									   *
* Host-Service								   *
*									   *
\**************************************************************************/

VOID l7()
{
 unsigned    n;			/* Zaehler				  */
 unsigned    inchar;		/* empfangenes Zeichen			  */
 unsigned    time;		/* Aktueller Stand 10ms-Systemtimer	  */
 unsigned    newtic;		/* Aenderung 10ms-Systemtimer		  */
 MBHEAD     *mbp;		/* Arbeitspuffer			  */

 DIinc();                       /* Int's aus				  */
 xonctl();                      /* XON senden bei Bedarf		  */
 decEI();			/* Int's bearbeiten, falls noetig	  */
 DIinc();			/* Int's aus fuer Uhr ablesen		  */
 time = ticks;			/* wie spaet ists?			  */
 decEI();			/* Int's wieder frei			  */
 newtic = time - oldtic;        /* TICKs seit letztem Hostservice-Aufruf  */
 oldtic = time;                 /* merken fuer naechsten Durchlauf	  */
 if (newtic != 0)               /* 10ms-Systemtimer veraendert?		  */
 {
  l2timr(newtic);                      /* Update L2-Timer T1, T2, T3      */
  if ((tic1s += newtic) >= 100)        /* alle Sekunde:                   */
  {
   tic1s -= 100;                       /* Uebertrag merken                */
   l3timr();                           /* Rundsprueche                    */
   l4timr();                           /* L4-Timerservice		  */
  }
 }

/**************************************************************************\
*									   *
* Steuern der CONNECT-LED. Wenn im Terminalmodus der aktuelle Kanal nicht  *
* der Monitorkanal ist und im Circuit-Setup-Status, bleibt die CON-LED	   *
* ausgeschaltet. Andernfalls wird die LED eingeschaltet, wenn zumindest	   *
* ein aktiver Circuit existiert.					   *
*									   *
\**************************************************************************/


 for(n = 0; n < NUMCIR; ++n)		/* ein Kanal belegt?		  */
   if (cirtab[n].state4 != 0) break;

 CONled(!ishmod				/* Terminalmodus?		  */
     && actch != 0			/* Monitorkanal?		  */
     && cirtab[actch - 1].state4	/* bei Circuitsetup LED aus	  */
	== L4SLKSUP			/* ein wenn min. 1 Circuit aktiv  */
	? 0 : n != NUMCIR);

/**************************************************************************\
*									   *
* Steuern der STATUS-LED. Wenn auf einem Kanal Statusmeldungen oder	   *
* Empfangsframes vorliegen, wird die LED eingeschaltet.			   *
*									   *
\**************************************************************************/

 for (n = 0; n < NUMCIR; ++n)                  /* alle Kanaele durchsehen */
   if (chnlml[n].head != &chnlml[n]) break;    /* Info vorhanden?         */
 STAled(n != NUMCIR);                          /* LED schalten            */


/**************************************************************************\
*									   *
* Terminalmodus								   *
*									   *
* Monitorframes, Ein- und Ausgaben bearbeiten				   *
*									   *
\**************************************************************************/

 if (!ishmod)
 {
  if (actch != 0) cirpoi = &cirtab[actch - 1];/* Circuitpointer fuer	  */
					      /* aktuellen Kanal setzen	  */
  selmfl();				      /* Monitorframes bearbeiten */

  if (incnt == 0)	/* wenn keine Eingabe, dann Ausgaben bearbeiten   */
   {

   while (!ishput() && (mbp = statml.head) != &statml)
   {                                 /* solange Statusmeldungen vorliegen */
    unlink(mbp);                     /* Statusmeldung holen               */
    trpmbb(mbp);                     /* anzeigen                          */
    dealmb(mbp);                     /* anschliessend auf den Muell       */
   }

   while (!ishput() && (mbp = smonfl.head) != &smonfl)
   {                                   /* solange Monitorframes vorhanden */
    unlink(mbp);                       /* Frame aus Liste holen           */
    if (ismonf(mbp) == TRUE)           /* darf noch angezeigt werden?     */
    {
     hcrlf();                          /* neue Zeile                      */
     frhmon(mbp);                      /* Monitorheader anzeigen          */
     hcrlf();                          /* neue Zeile                      */
     if (morinb(mbp) != 0)	        /* I-Feld vorhanden?               */
     {
      hputmb(mbp);                     /* I-Feld anzeigen                 */
      hcrlf();                         /* neue Zeile                      */
     }
    }
    dealmb(mbp);                       /* Reste auf den Muell             */
   }

   if (actch != 0)                       /* Circuitkanal                  */
    while (!ishput()                     /* solange Status-Meldungen oder */
	&& (mbp = chnlml[actch-1].head)  /* Empfangsframes vorhanden      */
		  != &chnlml[actch - 1])
    {
     unlink(mbp);                       /* Statusmeldung bzw. Frame holen */
     if (!mbp->type)                    /* Empfangsframe                  */
      hputmb(mbp);                      /* anzeigen                       */
     else                               /* Statusmeldung wie Monitorframe */
      trpmbb(mbp);                      /* anzeigen                       */
     dealmb(mbp);                       /* Reste auf den Muell            */
    }

  } /* end if (incnt == 0) */

  if (ishget() == TRUE && !ishput())       /* Eingaben bearbeiten         */
  {
   inchar = hgetc() & 0xFF;                /* Zeichen holen               */
   if (!isctlr || inchar == CONTROLR)      /* Ctrl-R?                     */
   {                                       /* wenn noch nix eingegeben    */
    if (!incnt) inbufp = hinbuf;           /* Eingabepuffer auf Anfang    */
     switch (inchar)                       /* was wurde eingegeben?       */
     {

      case CR :                         /* Zeilenende                     */
       hputc(CR);	                /* Echo CR                        */
       hputlf();			/* LF hinterher			  */
       inbufp = hinbuf;                /* Puffer auf Anfang f. Auswertung */
       if (incnt != 0 
	   && *inbufp == 0x1b)		/* ESC (Befehl)?                  */
       {
	++inbufp;                      /* Zeiger auf Befehl               */
	--incnt;
	cmd();                         /* Befehl ausfuehren               */
       }
       else                                 /* Info an Circuit            */
	if (nmbfre > 128)                   /* noch Platz? dann Daten	  */
	{                                   /* in Frame kopieren mit PID  */
	 (mbp = allocb())->l2fflg = L2CPID; /* fuer UI-Frame              */
	 while (incnt--)                    /* alle Zeichen               */
	  putchr(*inbufp++,mbp);            /* aus Eingabepuffer holen    */
	 putchr(CR,mbp);                    /* CR hinterher               */
	 rwndmb(mbp);                       /* Puffer wieder auf Anfang   */
	 if (!actch)                        /* Monitorkanal               */
	 {
	  if (myid[0] != ' ')                   /* wenn MyCall gesetzt	  */
	   sdui(ch0via,ch0id,myid,mbp);		/* als UI-Frame senden	  */
	  else                                  /* MyCall nicht gesetzt	  */
	   rspnsc();                            /* meckern		  */
	  dealmb(mbp);                          /* Reste auf den Muell	  */
	 }
	 else                           /* Circuit aktiv auf diesem Kanal */
	  tolink(mbp);	                /* Info an Circuit                */
	}
	else                            /* zu wenig Platz                 */
	 rsplig();                      /* Meldung: Zeile ignoriert       */
	incnt = 0;                      /* Eingabezeile loeschen          */
      break;

      case BS  :
      case DEL :
       if (incnt != 0) delich();        /* 1 Zeichen zurueck              */
      break;

      case CONTROLU :
      case CONTROLX :
       while (incnt != 0) delich();     /* Eingabe loeschen               */
      break;

      case CONTROLR :
       if (!isctlr)                     /* erstes Ctlr-R                  */
       {
	if (incnt != 0)                 /* schon was eingegeben           */
	 while (incnt != 0)             /* Anzeige loeschen:              */
	 {
	  delich();                     /* 1 Zeichen zurueck              */
	  ++isctlr;                     /* Zeichenzahl merken             */
	 }
       }
       else                             /* zweites Ctrl-R                 */
	while (isctlr != 0)             /* solange noch Zeichen da        */
	{
	 hpinch(*inbufp++);             /* Zeichen wieder anzeigen        */
	 ++incnt;                       /* Zeichen zaehlen                */
	 --isctlr;
	}
      break;

      default :                         /* kein Sonderzeichen             */
       if (incnt < HBUFLEN - 1)         /* noch Platz in Eingabepuffer    */
       {                                /* vorhanden?                     */
	hpinch(inchar);                 /* Echo Zeichen                   */
	*inbufp++ = inchar;             /* Zeichen in Puffer              */
	++incnt;                        /* Zeichen zaehlen                */
       }
       else                             /* Eingabepuffer voll             */
	hputbe();                       /* meckern                        */
      break;

     } /* end switch (inchar) */

   } /* end if (!isctlr || inchar == CONTROLR) */
   else                                            /* Ctrl-R aktiv, keine */
    hputbe();                                      /* Eingabe moeglich    */

  } /* end if (ishget() == TRUE && !ishput()) */

 } /* end if (!ishmod) */
 else

/**************************************************************************\
*									   *
* Hostmodus								   *
*									   *
\**************************************************************************/

 {
  actch = 0;                            /* auf Monitorkanal schalten      */
  selmfl();                             /* Monitorframes selektieren      */
  while (ishget() == TRUE)              /* Eingabezeichen vorhanden?      */
  {
   inchar = hgetc() & 0xFF;             /* Zeichen holen                  */
   switch (hmstat)                      /* hmstat: 0 = warten auf Kanal   */
   {                                    /*         1 = Info/Befehl        */
					/*         2 = Laenge             */
					/*         3 = Eingabe in Puffer  */
    case 0 :
     hmch = inchar;                     /* Kanal merken                   */
     ++hmstat;                          /* -> warten auf Info/Befehl      */
    break;

    case 1 :
     hmcmd = inchar;                    /* Info/Befehl merken             */
     ++hmstat;                          /* Status -> warten auf Laenge    */
    break;

    case 2 :
     hmlen = inchar;                    /* Laenge merken                  */
     ++hmstat;                          /* Status -> normale Eingabe      */
     inbufp = hinbuf;                   /* Eingabepuffer loeschen         */
     incnt = 0;                         /* Zaehler zuruecksetzen          */
    break;

    case 3 :
     *inbufp++ = inchar;                /* Zeichen zum Puffer dazu        */
     ++incnt;                           /* Zeichen Zaehlen                */
     if (hmlen != 0)                    /* kommen noch mehr Zeichen?      */
      --hmlen;
     else                               /* Eingabe vollstaendig           */
     {
      hmstat = 0;                            /* -> warten auf Kanal       */
      if (((actch = hmch) & 0xFF) <= NUMCIR) /* Kanal gueltig?            */
      {
       if (actch != 0)                    /* Circuitkanal?                */
	cirpoi = &cirtab[actch - 1];      /* Circuitpointer setzen        */
       inbufp = hinbuf;                   /* Eingabepuffer zuruecksetzen  */
       if (hmcmd == TRUE) cmd();          /* wenn Befehl, ausfuehren      */
       else                               /* Info                         */

	if (nmbfre > 128)                   /* noch Platz?                */
	{                                   /* Eingabe in Frame kopieren  */
	 (mbp = allocb())->l2fflg = L2CPID; /* mit PID fuer UI-Frame      */
	 while (incnt--)                    /* alle Zeichen aus Eingabe-  */
	  putchr(*inbufp++,mbp);            /* puffer holen               */
	 rwndmb(mbp);                       /* Puffer auf Anfang          */
	 if (!actch)                        /* Monitorkanal?              */
	 {
	  if (myid[0] != ' ')		    /* MyCall gesetzt?            */
	  {
	   sdui(ch0via,ch0id,myid,mbp);	    /* als UI senden         */
	   rspsuc();
	  }
	  else                               /* MyCall nicht gesetzt      */
	   rspnsc();                         /* meckern!                  */
	  dealmb(mbp);                       /* Reste auf den Muell       */
	 }
	 else                                /* auf Circuitkanal nur      */
	 {                                   /* senden wenn Circuit aktiv */
	  if (cirpoi->state4 != 0)
	   tolink(mbp);
	  else                               /* Circuit inaktiv - Eingabe */
	   dealmb(mbp);                      /* ignorieren                */
	  rspsuc();
	 }
	} /* end if (nmbfre >= 128) */
	else                                /* zu wenig Platz             */
	 rsplig();                          /* Meldung: Eingabe ignoriert */
      } /* end if ((actch = hmch) <= NUMCIR) */
      else
      {                                    /* ungueltiger Kanal - meckern */
       hputin("CHANNEL NUMBER");
       hputnu();
      }
      return;
     } /* end else from if (hmlen != 0) */
    break;


   } /* end switch (hmstat) */
  } /* end if (ishget() == TRUE) */
 } /* end else from if (!ishmod) */
}


/**************************************************************************\
*									   *
* "command"								   *
*									   *
*  Befehlsauswertung: Nur das erste Zeichen (ausser Space) wird als Befehl *
*  verwendet								   *
*									   *
\**************************************************************************/

VOID cmd()
 {
  unsigned c;

  if (nxtnos() == TRUE)		  /* wenn nicht nur Space eingegeben	  */
   {
    c = upcase(*inbufp++ & 0xFF); /* Zeichen holen -> gross		  */
    --incnt;			  /* 1 Zeichen weniger im Puffer	  */
    nxtnos();			  /* Leerzeichen uebergehen		  */
    if (c >= '@' && c <= 'Z')	  /* nur Buchstaben -> Befehl		  */
      (*cmdtab[c - '@'])(c);	  /* "(c)" fuer rspcic() ...		  */
    else			  /* kein Buchstabe			  */
      rspic(c);			  /* meckern				  */
   }
  else				/* nix eingegeben			  */
    rspsuc();			/* ignorieren				  */
 }



/* Ende von TBA.C */
