/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    TBC.C	-   The Boxware, Teil 3, Utilities			 *
*									 *
*  angelegt:	DF6LN aus TFC.C von DC4OX mit diversen Aenderungen	 *
*									 *
*  modifiziert:	DF6LN  280492 rspnwc() -> I-Befehl in TBB.C		 *
*									 *
\************************************************************************/





/*								Includes  */
/**************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			  */
#include "tb.h"		/* Festlegungen/Datenstrukturen fuer TheBoxware   */
#include "l234.h"	/* Festlegungen/Datenstrukturen fuer Level 2 - 4  */
#include "tbext.h"	/* globale Variable / nicht int-Funktionen	  */





/**************************************************************************\
*									   *
* "initialize links"							   *
*									   *
* Alle nicht belegten Linkkanaele mit neuen Parametern initialisieren.	   *
* Fuer die bereits aktiven Links werden nur Frack, Maxframe und Retries	   *
* neu gesetzt.								   *
*									   *
\**************************************************************************/

VOID inilks()
 {
  unsigned    n;
  LNKBLK     *savelp;

  savelp = lnkpoi;			/* Linkpointer merken		  */
  for (n = 0, lnkpoi = lnktbl;		/* alle Linkkanaele bearbeiten	  */
	n < LINKNMBR;
	++n, ++lnkpoi)
   {
    if (!lnkpoi->state) inilbl(); /* freien Linkkanal initialisieren	  */
    else			  /* belegter Linkkanal			  */
     {
      setiT1();			  /* nur teilweise initialisieren	  */
     }
   }
  lnkpoi = savelp;		/* Linkpointer wieder auf alten Wert	  */
 }





/**************************************************************************\
*									   *
* "Host put INVALID"							   *
*									   *
\**************************************************************************/

VOID hputin(str)
char	*str;
  {
    rspini(HMRFMSG);
    hputs("INVALID ");
    hputs(str);
  }



/**************************************************************************\
*									   *
* "Host put space ID"							   *
*									   *
\**************************************************************************/

VOID hputsi(id)
char *id;
 {
  hputsp();
  hputid(id);
 }





/**************************************************************************\
*									   *
* "response invalid command"						   *
*									   *
\**************************************************************************/

VOID rspic(c)
unsigned c;
 {
  hputin("COMMAND: ");
  hpccxb(c);
 }




/**************************************************************************\
*									   *
* "response invalid extended command"					   *
*									   *
\**************************************************************************/

VOID rspiec(c)
unsigned c;
 {
  hputin("EXTENDED COMMAND: ");
  hpccxb(c);
 }





/**************************************************************************\
*									   *
* "response invalid value"						   *
*									   *
\**************************************************************************/

VOID rspiv(value)
unsigned value;
 {
  hputin("VALUE: ");
  hputud(value);
  rspexb();
 }





/**************************************************************************\
*									   *
* "response invalid callsign"						   *
*									   *
\**************************************************************************/

VOID rspics()
 {
  hputin("CALLSIGN");
  rspexb();
 }





/**************************************************************************\
*									   *
* "response no source callsign"						   *
*									   *
\**************************************************************************/

VOID rspnsc()
 {
  rspini(HMRFMSG);
  hputs("NO SOURCE CALLSIGN");
  rspexb();
 }





/**************************************************************************\
*									   *
* "response line ignored"                                                  *
*									   *
\**************************************************************************/

VOID rsplig()
  {
    rspini(HMRFMSG);
    hputs("TNC BUSY - LINE IGNORED");
    rspexb();
  }





/**************************************************************************\
*									   *
* "response invalid parameter"						   *
*									   *
\**************************************************************************/

VOID rspipa()
 {
  hputin("PARAMETER");
  rspexb();
 }





/**************************************************************************\
*									   *
* "response channel status"						   *
*									   *
* Fuer den aktuellen Kanal wird angezeigt, mit welcher Gegenstation ueber  *
* welchen Digiweg der Circuit aktiv ist.				   *
*									   *
\**************************************************************************/

VOID rspcs()
 {
  rspini(HMRSMSG);
  if (!actch)				/* Monitorkanal			  */
   {
    hputid(ch0id);			/* Zielcall und Digiliste fuer	  */
    hputv(FALSE,ch0via);		/* UI-Frames anzeigen		  */
   }
  else					/* Circuitkanal			  */
   {
    if (cirpoi->state4 != 0)		/* Kanal aktiv			  */
     {
      if (!cirpoi->dir)			/* selbst connected		  */
       {
	hputid(cirpoi->downca);		/* Zielcall anzeigen		  */
       }
      else				/* Connect kam von aussen	  */
       {
	hputid(cirpoi->upcall);		/* Zielcall anzeigen		  */
	hputs(viasp);			/* " via " anzeigen		  */
	hputid(cirpoi->upnod);		/* Uplink-Knoten dazu		  */
	hputvl(FALSE,cirpoi->upnod);	/* Uplink-Vialiste anzeigen	  */
       }
     }
    else				/* Kanal nicht aktiv		  */
     {
      hputs("CHANNEL NOT");
      hputco();
     }
   }
  rspex();
 }





/**************************************************************************\
*									   *
* "response parameter"							   *
*									   *
\**************************************************************************/

VOID rsppar(par)
unsigned par;
 {
  rspini(HMRSMSG);
  hputud(par);
  rspex();
 }





/**************************************************************************\
*									   *
* "response init"							   *
*									   *
* Einleitung fuer Antwort.						   *
*									   *
\**************************************************************************/

VOID rspini(r)
unsigned r;
 {
  if (!ishmod)				/* im Terminalmodus		  */
    hputs("* ");
  else					/* im Hostmodus			  */
    hmputr(r);
 }





/**************************************************************************\
*									   *
* "response success"							   *
*									   *
\**************************************************************************/

VOID rspsuc()
 {
  if (ishmod == TRUE) hmputr(0);
 }





/**************************************************************************\
*									   *
* "response exit"							   *
*									   *
\**************************************************************************/

VOID rspex()
 {
  if (!ishmod)
    hputs(" *\015\012");
  else
    hputnu();
 }





/**************************************************************************\
*									   *
* "response exit bell"							   *
*									   *
\**************************************************************************/

VOID rspexb()
 {
  if (!ishmod)
    hpeoln();
  else
    hputnu();
 }


/**************************************************************************\
*									   *
* "frame header monitor"						   *
*									   *
* Monitoranzeige des Framekopfes. Absender, Empfaenger, Digiliste,	   *
* Frametyp, und PID anzeigen. Im Terminalmodus werden ausserdem L3- und	   *
* L4-Parameter von TheNet-Frames dargestellt.				   *
*									   *
\**************************************************************************/

VOID frhmon(fbp)
MBHEAD *fbp;
 {
  char     id[L2IDLEN];
  unsigned l4opco;
  unsigned pid;
  unsigned n;

  hputs("fm");
  hputsi(rxfhdr + L2IDLEN);		/* Absendercall anzeigen	  */
  hputs(" to");
  hputsi(rxfhdr);			/* Empfaengercall anzeigen	  */
  hputv(TRUE,rxfhdr + L2ILEN);		/* Vialiste anzeigen		  */
  hputs(" ctl ");			/* Frametyp anzeigen:		  */
  if (!(rxfctl & L2CNOIM))		/* I-Frame			  */
   {
    hputI();
   }
  else					/* kein I-Frame			  */
   {
    if (!(rxfctl & L2CNOSM))		/* S-Frame			  */
     {
      switch ((rxfctl >> 2) & 0x3)
       {
	case 0  :   hputs("RR");    break;
	case 1  :   hputs("RNR");   break;
	case 2  :   hputs("REJ");   break;
	default :				/* Frametyp unbekannt	  */
	  hputfz();
	  hputby(rxfctl | rxfPF);		/* als HEXzahl anzeigen	  */
	  hputH();
	break;
       }
     }
    else					/* kein S-Frame		  */
     {
      switch (rxfctl & 0xFF)
       {
	case L2CUI   :
	  hputs("UI");
	break;
	case L2CDM   :
	  hputs("DM");
	break;
	case L2CSABM :
	  hputs("SABM");
	break;
	case L2CDISC :
	  hputs("DISC");
	break;
	case L2CUA   :
	  hputs("UA");
	break;
	case L2CFRMR :
	  hputs("FRMR");
	  while (morinb(fbp) != 0)		/* FRMR-Infofeld als	  */
	   {
	    hputby(getchr(fbp));		/* HEXdaten anzeigen	  */
	   }
	break;
	default      :				/* unbekannter Frametyp	  */
	  hputfz();
	  hputby(rxfctl | rxfPF);		/* als HEXzahl anzeigen	  */
	  hputH();
	break;
       }
     }
   }
  if ((rxfctl & 0x3) != 3)			/* I- und S-Frames	  */
   {
    hputud((rxfctl >> 5) & 0x7);		/* Nummer naechstes Frame */
    if (!(rxfctl & L2CNOIM))			/* I-Frame		  */
     {
      hputud((rxfctl >> 1) & 0x7);		/* Framenummer		  */
     }
   }
  if (rxfPF != 0)				/* Poll/Final gesetzt	  */
   {
    if (!rxfV2)					/* AX25L2V1		  */
     {
      hputc('!');
     }
    else					/* AX25L2V2		  */
     {
      hputc(rxfCR != 0 ? '+' : '-'); /* Command+Poll oder Response+Final  */
     }
   }
  else						/* ohne Poll/Final	  */
   {
    if (rxfV2 == TRUE)				/* nur bei AX25L2V2	  */
     {
      hputc(rxfCR != 0 ? '^' : 'v');
     }
   }
  if (!(rxfctl & L2CNOIM) || rxfctl == L2CUI)	/* Frames mit PID	  */
   {
    hputs(" pid");
    hpspby(pid = morinb(fbp) != 0	/* PID als HEXzahl, wenn	  */
		? getchr(fbp) : 0);	/* vorhanden			  */
    if (!ishmod &&			/* im Terminalmodus TheNet-Frames */
	     (pid & 0xFF) == L3CPID)	/* L3/L4-Daten darstellen	  */
     {
      if (rxfctl != L2CUI)		/* I-Frames			  */
       {
	if (morinb(fbp) >= 1+2*L2IDLEN)	/* gueltiger L3-Teil?		  */
	 {
	  if (getfid(id,fbp) == TRUE)	/* L3-Teil muss mit Call	  */
	   {				/* beginnen			  */
	    hputs("\015\012(l3");	/* L3/4-Teil in neuer Zeile	  */
	    hputsi(id);			/* L3-Absender-Call		  */
	    if (getfid(id,fbp) == TRUE)	/* L3-Empfaenger vorhanden	  */
	     {
	      hputsi(id);			/* L3-Empfaenger-Call	  */
	      if (morinb(fbp) != 0)		/* noch Zeichen da	  */
	       {
	        hpspby(getchr(fbp));		/* L3-Time-To-Live	  */
	       }
	      if (morinb(fbp) >= 5)		/* gueltiger L4-Teil?	  */
	       {
	        hputs(")\15\12(l4");		/* in neue Zeile	  */
	        for (n = 0; n < 5; ++n)		/* 5 L4-Header-Bytes	  */
	         {
		  hpspby(l4opco = getchr(fbp));	/* Byte holen, merken und */
	         }				/* anzeigen		  */
	        l4opco &= 0x07;
	        if (l4opco == 1 || l4opco == 2)	/* ConnReq o. ConnAck	  */
	         {
		  if (morinb(fbp) != 0)
		   {
		    hpspby(getchr(fbp));	/* L4 Window Size	  */
		    if ((l4opco == 1)		/* Connect Request	  */
			&& (morinb(fbp) >= 2*L2IDLEN))
		     {
		      if (getfid(id,fbp) == TRUE)
		       {
		        hputsi(id);			/* User-Call	  */
		        if (getfid(id,fbp))
		         {
			  hputsi(id);			/* Absenderknoten */
			  if (morinb(fbp) >= L2IDLEN)
                           {
			    if (getfid(id,fbp) == TRUE)
                             {
                              hputs(viasp);
                              hputid(id);		 /* Uplinkknoten  */
			      while (*fbp->mbbp != '\0') /* Uplink-Via-	  */
			       {			 /* Liste	  */
				if (morinb(fbp) < L2IDLEN) break;
			        if (!getfid(id,fbp)) break;
			        hputsi(id);
			       } /* Uplink-Vialiste */
			      if (morinb(fbp) != 0)
				getchr(fbp); /* Nullterminierung Vialiste */
                             } /* Uplinkknoten */
			   } /* genuegend Zeichen fuer Uplinkknoten */
		         } /* Absenderknoten */
		       } /* User-Call */
		     } /* Connect Request */
		   } /* end if (morinb(fbp) != 0) */
	         } /* Connect Request oder Connect Acknowledge */
	       } /* gueltiger L4-Teil */
	     } /* L3-Empfaenger ok */
	    hputc(')');
	   } /* L3-Teil beginnt mit Call */
	 } /* gueltiger L3-Teil moeglich */
       } /* end if (rxfctl != L2CUI) */
      else						/* L3-UI-Frame	  */
       {
	if (morinb(fbp) >= L2IDLEN)
	 {
	  hcrlf();			/* neue Zeile			  */
	  hputby(getchr(fbp));		/* L3-Kennung normal 0xFF	  */
	  hputsp();
	  for (n = 0; n < L2CALEN; ++n)	/* 6 Zeichen Node-IDENT		  */
	    hputcc(getchr(fbp));
	  while (morinb(fbp) >= 2*L2IDLEN+L2CALEN+1)/* Knotenliste zeigen */
	   {
	    if (getfid(id,fbp) == TRUE)		/* gueltiges Ziel-Call	  */
	     {
	      hcrlf();		/* eigene Zeile fuer jeden Zielknoten	  */
	      hputid(id);	/* Ziel-Call anzeigen			  */
	      hputsp();
	      for (n = 0; n < L2CALEN; ++n)	/* IDENT Zielknoten	  */
		hputcc(getchr(fbp));
	      if (getfid(id,fbp) == TRUE)	/* Nachbarcall holen	  */
	       {
		hputsi(id);			/* Nachbarcall anzeigen	  */
		hpspby(getchr(fbp));		/* Qualitaet Zielknoten	  */
		continue;
	       }
             }
	    return;
	   } /* end while */
	 } /* end if (morinb(fbp) >= L2IDLEN) */
       } /* L3 UI-Frame */
     } /* Terminalmodus - L3/L4-Anzeige */
   } /* Frames mit PID */
 }





/**************************************************************************\
*									   *
* "terminal mode response message buffer bell"				   *
*									   *
* Anzeige von Statusmeldungen im Terminalmodus in eigener Zeile, mit	   *
* Bimmel und eingerahmt mit Sternchen (sehr huebsch!).			   *
*									   *
\**************************************************************************/

VOID trpmbb(mbp)
MBHEAD *mbp;
 {
  rwndmb(mbp);			/* Puffer auf Anfang			  */
  hputs("\015\012* ");		/* Anfangssternchen in neuer Zeile	  */
  hputmb(mbp);			/* Pufferinhalt anzeigen		  */
  hpeoln();			/* Abschlusssternchen und Bimmel	  */
 }





/**************************************************************************\
*									   *
* "host put message buffer"						   *
*									   *
* Der Dateninhalt des Puffers mbp wird fuer die Ausgabe kopiert. Dabei     *
* werden BS und DEL gesondert ausgewertet. Controlzeichen werden mit '^'   *
* vorneweg und nachfolgendem Buchstaben angezeigt, ausser BELL, TAB, CR    *
* und LF. Auf CR folgt bei eingeschaltetem A-Parameter ausserdem ein LF.   *
*									   *
\**************************************************************************/

VOID hputmb(mbp)
MBHEAD *mbp;
 {
  unsigned    ch;
  MBHEAD     *copy;
  MBHEAD     *copy2;

  copy = allocb();			/* Puffer fuer Kopie holen	  */
  while (morinb(mbp) != 0)		/* noch Zeichen im Puffer	  */
   {
    ch = getchr(mbp) & 0xFF;	/* Zeichen aus Puffer holen		  */
    if (!defM7) ch &= 0x7F;	/* ggf. Bit 7 loeschen			  */
    if (ch == BS || ch == DEL)	/* Sonderbehandlung fuer BS und DEL	  */
     {
      if (copy->mbpc != 0)		/* schon Zeichen in Kopiepuffer	  */
       {
	--copy->mbpc;			/* ein Zeichen weniger im Puffer  */
	rwndmb(copy);			/* Kopiepuffer auf Anfang	  */
	copy2 = allocb();		/* Puffer fuer Kopie der Kopie	  */
	addbuf(copy2,copy);		/* Kopie kopieren		  */
	dealmb(copy);			/* alte Kopie auf Muell		  */
	copy = copy2;			/* weiter mit der Kopie der Kopie */
       }
     }
    else		/* keine Sonderbehandlung, normales Zeichen	  */
      putchr(ch,copy);	/* Zeichen zum Kopiepuffer dazu			  */
   }
  rwndmb(copy);				/* Kopie wieder auf Anfang	  */
  while (morinb(copy) != 0)		/* kopierte Daten anzeigen	  */
   {
    if ((ch = getchr(copy) & 0xFF) >= ' '	/* normales Zeichen oder  */
		|| ch == BELL			/* Bimmel, TAB oder LF	  */
		|| ch == TAB			/* direkt anzeigen	  */
		|| ch == LF)
     {
      hputc(ch);
     }
    else					/* Sonderbehandlung fuer  */
     {
      if (ch == CR)				/* CR: LF hinterher	  */
       {
	hputc(CR);
	hputlf();
       }
      else				/* Control-Zeichen werden	  */
       {				/* in normale Zeichen		  */
	hpcc(ch);			/* umgewandelt			  */
       }
     }
   }
  dealmb(copy);				/* fertig - Kopie auf den Muell	  */
 }





/**************************************************************************\
*									   *
* "host put via"							   *
*									   *
* Wenn eine Digiliste existiert, diese anzeigen.			   *
*									   *
\**************************************************************************/

VOID hputv(dmark,vial)
unsigned    dmark;
char       *vial;
 {
  if (*vial != '\0')		/* Digiliste vorhanden			  */
   {
    hputs(viastr);		/* " via" vorneweg			  */
    hputvl(dmark,vial);		/* Digiliste anzeigen			  */
   }
}





/**************************************************************************\
*									   *
* "host put via list"							   *
*									   *
* Anzeigen der Digiliste. Es werden alle Digicalls der Reihe nach	   *
* angezeigt. Ggf. wird das Call des Absenderdigis markiert mit einem	   *
* Sternchen.								   *
*									   *
\**************************************************************************/

VOID hputvl(dmark,vial)
unsigned    dmark;
char       *vial;
 {
  while (*vial != '\0')			/* noch Digicall vorhanden	  */
   {
    hputsi(vial);			/* Digirufzeichen anzeigen	  */
    if (dmark == TRUE)			/* es soll markiert werden	  */
     {
      if ((vial[L2IDLEN - 1] & L2CH) != 0)	/* hier schon digipeated  */
       {
	if (!vial[L2IDLEN]		      /* kein weiterer Digi oder  */
	    || !(vial[2*L2IDLEN - 1] & L2CH)) /* naechster hat noch nicht */
	 {
	  hputc('*');			/* mit Sternchen markieren	  */
	  dmark = FALSE;		/* keine 2. Markierung		  */
	 }
       }
     }
    vial += L2IDLEN;			/* naechstes Call		  */
   }
 }





/**************************************************************************\
*									   *
* "host put ID"								   *
*									   *
* Es wird ein AX.25-Rufzeichen angezeigt. Der SSID wird nur angezeigt,	   *
* wenn er nicht 0 ist.							   *
*									   *
\**************************************************************************/

VOID hputid(id)
char *id;
 {
  unsigned ssid;
  unsigned n;
  unsigned ch;

  for (n = 0; n < L2CALEN; ++n)		/* Rufzeichen bearbeiten	  */
   {
    if ((ch = *id++ & 0xFF) > ' ')	/* ein Zeichen holen		  */
      hputc(ch);			/* normales Zeichen		  */
    else				/* Control-Zeichen		  */
     {
      if (ch < ' ')			/* Leerzeichen im Call ignorieren */
       {
	hpcc(ch);			/* Controlzeichen		  */
       }
     }
   }
  if ((ssid = (*id >> 1) & 0xF) != 0)	/* SSID nicht 0			  */
   {
    hputc('-');				/* SSID anzeigen		  */
    hputud(ssid);
   }
 }





/**************************************************************************\
*									   *
* "host put unsigned decimal"						   *
*									   *
* Dezimalzahl in ASCII-String umwandeln und anzeigen.			   *
*									   *
\**************************************************************************/

VOID hputud(u)
unsigned u;
 {
  unsigned   n;
  BOOLEAN    out;
  unsigned   div;
  unsigned   digit;

  for (out = FALSE, div = 10000, n = 0; n < 5; ++n)
   {
    if ((digit = u/div) != 0 || out == TRUE || div == 1)
     {
      hputc0(digit);
      out = TRUE;
     }
    u  %= div;
    div /= 10;
   }
 }




/**************************************************************************\
*									   *
* "host put space byte"							   *
*									   *
* Nach einem Leerzeichen ein Byte als HEXzahl anzeigen.			   *
*									   *
\**************************************************************************/

VOID hpspby(byte)
unsigned byte;
 {
  hputsp();
  hputby(byte);
 }






/**************************************************************************\
*									   *
* "host put byte"							   *
*									   *
* Ein Byte als HEXzahl anzeigen.					   *
*									   *
\**************************************************************************/

VOID hputby(byte)
unsigned byte;
 {
  hputni(byte >> 4);			/* zuerst Bit 4-7		  */
  hputni(byte);				/* danach Bit 0-3		  */
 }





/**************************************************************************\
*									   *
* "host put nibble"							   *
*									   *
* Nibble als HEXziffer anzeigen.					   *
*									   *
\**************************************************************************/

VOID hputni(nibble)
unsigned nibble;
 {
  nibble &= 0xF;			/* nur Bit 0-3			  */
  if (nibble > 9) nibble += 7;		/* A-F				  */
  hputc0(nibble);			/* -> ASCII-Zeichen		  */
 }





/**************************************************************************\
*									   *
* "host mode put response"						   *
*									   *
\**************************************************************************/

VOID hmputr(r)
unsigned r;
 {
  hputc(actch);
  hputc(r);
 }





/**************************************************************************\
*									   *
* "host carriage return linefeed"					   *
*									   *
\**************************************************************************/

VOID hcrlf()
 {
  hputs("\015\012");
 }





/**************************************************************************\
*									   *
* "host put string"							   *
*									   *
\**************************************************************************/

VOID hputs(str)
char *str;
 {
  while (*str != '\0')
    hputc(*str++);
 }





/**************************************************************************\
*									   *
* "host put control character"						   *
*									   *
\**************************************************************************/

VOID hputcc(c)
unsigned c;
 {
  if (c >= ' ')
    hputc(c);
  else
   {
    hpcc(c);
   }
 }








/**************************************************************************\
*									   *
* "put via ID's"							   *
*									   *
* Wenn Digipeaterliste vorhanden, " via" und anschliessend die Digipeater- *
* liste in einen Puffer schreiben und ggf. den Absenderdigi markieren mit  *
* '*'.									   *
*									   *
\**************************************************************************/

VOID putv(dmark,vial,mbp)
unsigned    dmark;
char       *vial;
MBHEAD     *mbp;
 {
  if (*vial != '\0')			/* Digiliste ist vorhanden	  */
   {
    putstr(viastr,mbp);
    putvl(dmark, vial, mbp);
   }	
 }



/**************************************************************************\
*									   *
* "put via ID's"							   *
*									   *
* Digipeaterliste in einen Puffer schreiben und ggf. den Absenderdigi	   *
* markieren mit '*'.							   *
*									   *
\**************************************************************************/

VOID putvl(dmark,vial,mbp)
unsigned    dmark;
char       *vial;
MBHEAD     *mbp;
 {
  while (*vial != '\0')			/* bis zum Ende der Digiliste	  */
   {
    putchr(' ',mbp);
    putid(vial,mbp);			/* ein Digicall in den Puffer	  */
    if (dmark == TRUE)
     {
      if ((vial[L2IDLEN - 1] & L2CH) != 0)
       {
	if ((!vial[L2IDLEN] || !(vial[2*L2IDLEN - 1] & L2CH)))
	 {
	  putchr('*',mbp);		/* Absenderdigi wird markiert	  */
	  dmark = FALSE;		/* nur eine Markierung!		  */
	 }
       }
     }
    vial += L2IDLEN;		/* weiter mit naechstem Call	  */
   }
 }



/**************************************************************************\
*									   *
* "put ID"								   *
*									   *
* Rufzeichen von AX.25-Format in ASCII unwandeln und in einen Puffer       *
* schreiben.								   *
*									   *
\**************************************************************************/

VOID putid(id,mbp)

char     *id;
MBHEAD   *mbp;

  {
    unsigned n;
    unsigned ssid;
    unsigned c;

    for (n = 0; n < L2CALEN; ++n)       /* ein Call bearbeiten            */
      if ((c = *id++ & 0xFF) > ' ')     /* Leerzeichen im Call ignorieren */
	putchr(c,mbp);
      else
	if (c < ' ')
	  {
	    putchr('^',mbp);             /* Control-Zeichen gesondert     */
	    putchr(c + '@',mbp);         /* behandeln                     */
	  }
    if ((ssid = (*id >> 1) & 0xF) != 0)  /* der SSID wird nur angezeigt,  */
      {                                  /* wenn der Wert > 0 ist         */
	putchr('-',mbp);
	putudc(ssid,mbp);
      }
  }





/**************************************************************************\
*									   *
* "put unsigned decimal"						   *
*									   *
* Dezimalzahl als ASCII-String in Puffer schreiben.			   *
*									   *
\**************************************************************************/

VOID putudc(u,mbp)

unsigned    u;
MBHEAD     *mbp;

  {
    BOOLEAN    out;
    unsigned   div;
    unsigned   digit;
    unsigned   n;

    for (out = FALSE, div = 10000, n = 0; n < 5; ++n)
      {
	if ((digit = u/div) != 0 || out == TRUE || div == 1)
	  {
	    putchr(digit + '0',mbp);
	    out = TRUE;
	  }
	u %= div;
	div /= 10;
      }
  }





/**************************************************************************\
*									   *
* "put byte"								   *
*									   *
* Ein Byte in ASCII-String umwandeln und in einen Puffer schreiben.	   *
*									   *
\**************************************************************************/

VOID putbyt(byte,mbp)

unsigned    byte;
MBHEAD     *mbp;

  {
    putnib(byte >> 4,mbp);
    putnib(byte,mbp);
  }





/**************************************************************************\
*									   *
* "put nibble"								   *
*									   *
* Ein Nibble als HEXziffer in einen Puffer schreiben.			   *
*									   *
\**************************************************************************/

VOID putnib(nibble,mbp)

unsigned    nibble;
MBHEAD     *mbp;

  {
    nibble &= 0xF;
    if (nibble > 9) nibble += 7;
    putchr(nibble + '0',mbp);
  }





/**************************************************************************\
*									   *
* "put string"								   *
*									   *
* Einen String in einen Puffer kopieren.				   *                                                                         *
*									   *
\**************************************************************************/

VOID putstr(str,mbp)

char     *str;
MBHEAD   *mbp;

  {
    while (*str != '\0')
      putchr(*str++,mbp);
  }





/**************************************************************************\
*									   *
* "buffer get parameter"						   *
*									   *
* Einen Zahlenwert als Parameter aus einem Puffer holen.		   *
*									   *
\**************************************************************************/

unsigned bgetp()
  {
    unsigned par;

    nxtnos();                  /* Leerzeichen ignorieren                  */
    par = 0;
    while (incnt != 0 && *inbufp >= '0' && *inbufp <= '9') /* nur Ziffern */
      {
	--incnt;
	par *= 10;
	par += *inbufp++ - '0';
      }
    return (par);
  }





/**************************************************************************\
*									   *
* "flagged validate callsign"						   *
*									   *
* Es wird ueberprueft, ob CALL ein gueltiges Rufzeichen darstellt. Ein     *
* leeres Call ist immer ungueltig. Ist CHECK <> 0, wird auch ueberprueft,  *
* ob CALL den folgenden Bedingungen entspricht:				   *
* Call besteht aus mindestens 4 Zeichen und ein oder zwei Ziffern, die     *
* aber nicht am Anfang oder Ende des Rufzeichens stehen duerfen.           *
*									   *
\**************************************************************************/

int fvalca(check,call)

BOOLEAN    check;
char       *call;

  {
    if (*call == ' ') return(FALSE);     /* leeres Rufzeichen             */
    if (!check) return(TRUE);            /* nicht ueberpruefen, immer gut */
    return(valcal(call));
  }


/**************************************************************************\
*									   *
* "validate callsign"							   *
*									   *
* Es wird ueberprueft, ob CALL ein gueltiges Rufzeichen darstellt, d.h.    *
* ob CALL den folgenden Bedingungen entspricht:				   *
* Call besteht aus mindestens 4 Zeichen und ein oder zwei Ziffern, die     *
* aber nicht am Anfang oder Ende des Rufzeichens stehen duerfen.           *
*									   *
\**************************************************************************/


int valcal(call)

char *call;
  {
    unsigned    n;
    unsigned    nmbn;
    unsigned    c;
    char       *lnpoi;
    char       *cpoi;


    for (nmbn = n = 0, cpoi = call; n < L2CALEN; ++n, ++cpoi)
      {
	if ((c = *cpoi & 0xFF) == ' ') break;  /* Rufzeichenende          */
	if (!(c >= 'A' && c <= 'Z'))           /* Grossbuchstaben sind ok */
	  if (c >= '0' && c <= '9')            /* Ziffern werden gezaehlt */
	    {
	      ++nmbn;                          /* 1 Ziffer mehr           */
	      lnpoi = cpoi;                    /* Zeiger letzte Ziffer    */
	    }
	  else                 /* keine Ziffer und kein Grossbuchstabe    */
	    return (ERROR);    /* also ungueltiges Rufzeichen             */
      }
    if (    cpoi - call < 4    /* mindestens 4 Zeichen lang               */
	 || !nmbn              /* mindestens eine Ziffer                  */
	 || nmbn > 2           /* hoechstens 2 Ziffern                    */
	 || lnpoi == call      /* Ziffer nicht am Anfang                  */
	 || cpoi - 1 == lnpoi  /* Ziffer nicht am Ende                    */
       )
      return (ERROR);
    else
      return (TRUE);
  }



/**************************************************************************\
*									   *
* "select monitor frame list"						   *
*									   *
* Monitorframes untersuchen, ob Anzeige erlaubt.			   *
*									   *
\**************************************************************************/

VOID selmfl()
  {
    MBHEAD     *fbp;
    char       *id1;
    char       *id2;

    while ((fbp = monfl.head) != &monfl) /* alle Monitorframes bearbeiten */
      {
	unlink(fbp);                     /* 1 Frame holen                 */
	if (ismonf(fbp) == TRUE)         /* Frame darf angezeigt werden   */
	  relink(fbp,smonfl.tail);       /* zur Liste guter Mon.-Frames   */
	else                             /* Frame wird nicht angezeigt    */
	  dealmb(fbp);                   /* also auf den Muell            */

      } /* end  while ((fbp = monfl.head) != &monfl) */
  }





/**************************************************************************\
*									   *
* "is monitor frame"							   *
*									   *
* Untersuchen, ob Frame angezeigt werden darf gemaess Monitorparametern	   *
* und Rufzeichenliste.							   *
*									   *
\**************************************************************************/

BOOLEAN ismonf(fbp)

MBHEAD *fbp;

  {
    if (!actch                     /* Monitorkanal oder                   */
	|| !lnkpoi->state          /* Linkkanal nicht aktiv oder          */
	|| (Mpar & MONC) != FALSE) /* Monitor auch auf aktivem Linkkanal  */
      {
	takfhd(fbp);                     /* Frame zerlegen                */
	if (!(rxfctl & L2CNOIM)          /* I-Frame                       */
	       && (Mpar & MONI) != 0     /* wenn erlaubt                  */
	     || (rxfctl & 3) == 1        /* RR-, REJ-, RNR-Frames         */
	       && (Mpar & MONS) != 0     /* wenn S-Frames erlaubt         */
	     || ((rxfctl & 3) == 3       /* SABM, DISC, UA, DM, FRMR      */
	       && rxfctl != L2CUI)
	       && (Mpar & MONS) != 0     /* wenn S-Frames erlaubt         */
	     || rxfctl == L2CUI          /* UI-Frames                     */
	       && (Mpar & MONU) != 0     /* wenn erlaubt                  */
	   )
	  {
	    if (mftsel != 0)                 /* Rufzeichenliste vorhanden */
	      if (    invial(mftidl,rxfhdr + L2IDLEN) == TRUE /* Absender */
		   || invial(mftidl,rxfhdr) == TRUE /* oder Empfaenger in */
		 )                           /* Rufzeichenliste           */
		{
		  if (mftsel == 2) /* Absender o. Empfaenger in Liste und */
		    return (FALSE);/* Liste NICHT anzeigen                */
		}
	      else
		{
		  if (mftsel == 1) /* Absender u. Empfaenger Nicht in     */
		   return (FALSE); /* Liste, aber NUR Liste anzeigen      */
		}
	    return (TRUE);         /* keine Rufzeichenliste - alles ok    */
	  }
      }
    return (FALSE);                /* aktiver Linkkanal                   */
  }





/**************************************************************************\
*									   *
* "message buffer count"						   *
*									   *
* Es wird die Anzahl der in der Liste vorhandenen Datenpuffer gezaehlt. Es *
* wird dabei entweder nur die Zahl der Infopuffer oder die Zahl der	   *
* Statuspuffer oder alles gezaehlt.					   *
*									   *
\**************************************************************************/

unsigned mbcnt(msgl,select)

LHEAD      *msgl;
unsigned    select;

  {
    unsigned    count;
    MBHEAD     *mb;

    for (count = 0, mb = msgl->head;
	 mb != msgl;
	 mb = mb->nextmh)
      if (    select == MBALL
	   || select == MBINFO    &&  mb->type == MBINFO
	   || select == MBSTATUS  &&  mb->type != MBINFO
	 ) ++count;
     return (count);
   }





/**************************************************************************\
*									   *
* "select message buffer"						   *
*									   *
* Naechsten Datenpuffer in Liste suchen. Es wird dabei unterschieden, ob   *
* nur Infopuffer, nur Statuspuffer oder alles gesucht ist.		   *
*									   *
\**************************************************************************/

MBHEAD *selmb(msgl,select)

LHEAD      *msgl;
unsigned    select;

  {
    MBHEAD *mb;

    for (mb = msgl->head; mb != msgl; mb = mb->nextmh)
      if (    select == MBALL
	   || select == MBINFO    &&  mb->type == MBINFO
	   || select == MBSTATUS  &&  mb->type != MBINFO
	 )
	return(mb);
    return (NULL);
  }





/**************************************************************************\
*									   *
* "in via list"								   *
*									   *
* Rufzeichen ID in Rufzeichenliste VIAL suchen.				   *
*									   *
\**************************************************************************/

BOOLEAN invial(vial,id)

char *vial;
char *id;

  {
    while (*vial != '\0')                /* Liste bis zum Ende absuchen   */
      if (cmpid(vial,id) == TRUE)        /* Call gefunden                 */
	return (TRUE);
      else                               /* Call noch nicht gefunden      */
	vial += L2IDLEN;                 /* naechstes Rufzeichen          */
    return (FALSE);                      /* Call ist nicht in Liste       */
  }





/**************************************************************************\
*									   *
* "next no space"							   *
*									   *
* Leerzeichen ueberspringen.						   *
*									   *
\**************************************************************************/

BOOLEAN nxtnos()
  {
    while (incnt != 0 && *inbufp == ' ')
      {
	++inbufp;
	--incnt;
      }
    return (incnt != 0);
  }





/**************************************************************************\
*									   *
* "is warm reset"							   *
*									   *
* Feststellen, ob Kaltstart oder Warmstart.				   *
*									   *
\**************************************************************************/

BOOLEAN iswarm()
  {
    return (magicn == MAGIC);
  }





/**************************************************************************\
*									   *
* "timer"								   *
*									   *
* 10ms-Timer hochzaehlen.						   *
*									   *
\**************************************************************************/

VOID timer()
  {
    ++ticks;
  }



/* Ende von TBC.C */
