/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    TBD.C	-   The Boxware, Teil 4					 *
*									 *
*    angelegt:      DF6LN aus TFD.C von DC4OX mit diversen Aenderungen	 *
*    modifiziert:							 *
*									 *
\************************************************************************/





/*								Includes  */
/**************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			  */
#include "tb.h"		/* Festlegungen/Datenstrukturen fuer TheBoxware   */
#include "l234.h"	/* Festlegungen/Datenstrukturen fuer Level 2 - 4  */
#include "tbext.h"	/* globale Variable / nicht int-Funktionen	  */





/**************************************************************************\
*									   *
* "host initialize"							   *
*									   *
\**************************************************************************/

VOID l7init()
  {
    unsigned n;

    inithd(&statml);
    inithd(&smonfl);
    for (n = 0; n < NUMCIR; ++n) inithd(&chnlml[n]);
    incnt       =
    isctlr      = (unsigned) (
    mifmbp      = (MBHEAD *) (
    ishmod      =
    hmstat      =
    actch       =
    ticks       =
    oldtic      =
    tic1s       = NULL ));
    if (!iswarm())
      {
	sdefpa();
	mftsel		=
	ch0via[0]	=
	mftidl[0]	= NULL;
	cpyid(ch0id,cqid);
	magicn		= MAGIC;
      }
  }





/**************************************************************************\
*									   *
* "host put input character"						   *
*									   *
\**************************************************************************/

VOID hpinch(ch)

unsigned ch;

  {
      if (!incnt && ch == 0x1b)		/* ESC (Befehl)?		  */
	hputs("* ");
      else
	if (ch >= ' ' || ch == BELL)
	  hputc(ch);
	else
	  {
	    hpcc(ch);
	  }
  }





/**************************************************************************\
*									   *
* "delete input character"						   *
*									   *
\**************************************************************************/

VOID delich()
  {
    unsigned ch;

    --incnt;
    ch = *--inbufp & 0xFF;
    if (!incnt && ch == 0x1b)		/* ESC (Befehl)?		  */
      {
	hpbsb();
	hpbsb();
      }
    else
	if (ch != BELL)
	  {
	    hpbsb();
	    if (ch < ' ') hpbsb();
	  }
	else
	  hputc(ch);
  }





/**************************************************************************\
*									   *
* "host put backspace space backspace"					   *
*									   *
\**************************************************************************/

VOID hpbsb()
  {
    hputs("\010 \010");
  }





/**************************************************************************\
*									   *
* "JHOST"-Befehl							   *
*									   *
* Es wird der Hostmodusstatus angezeigt oder aber der Hostmodus ein- bzw.  *
* ausgeschaltet.							   *
*									   *
\**************************************************************************/

VOID Jcmd()
  {
    unsigned par;

    if (incnt >= 4)                          /* noch mindestens 4 Zeichen */
      if (upcase(*inbufp++) == 'H')          /* fuer vollstaendigen	  */
	if (upcase(*inbufp++) == 'O')        /* Befehl			  */
	  if (upcase(*inbufp++) == 'S')
	    if (upcase(*inbufp++) == 'T')
	      {
		incnt -= 4;
		if (!nxtnos())     /* kein Parameter			  */
		  rsppar(ishmod);  /* derzeitigen Zustand anzeigen	  */
		else                        /* Aufruf mit Parameter	  */
		  if ((par = bgetp()) <= 1) /* Parameter holen, 0 oder 1  */
		    {
		      rspsuc();
		      ishmod = par;		/* neuen Parameter setzen */
		    }
		  else				/* falscher Parameter	  */
		    rspiv(par);
		return;
	      }
    rspic('J');                             /* Befehl war nicht 'JHOST'	  */
  }





/**************************************************************************\
*									   *
* "QRES"-Befehl								   *
*									   *
* Kaltstart ausfuehren.							   *
*									   *
\**************************************************************************/

VOID Qcmd()
  {
    if (incnt >= 3)			/* der Befehl besteht aus	  */
      if (upcase(*inbufp++) == 'R')	/* mindestens 3 weiteren	  */
	if (upcase(*inbufp++) == 'E')	/* Zeichen			  */
	  if (upcase(*inbufp++) == 'S')	/* nur 'QRES' ist gueltig	  */
	    {
	      magicn = 0;		/* Warmstart verhindern		  */
	      reset();			/* durchstarten			  */
	    }
    rspic('Q');				/* es war nicht 'QRES'		  */
  }








/**************************************************************************\
*									   *
* "list channel"							   *
*									   *
* Fuer den angegebenen Kanal wird die Gegenstation und der Digiweg         *
* angezeigt, gefolgt von der Zahl der Empfangsframes, der ungesendeten     *
* Sendeframes, der unbestaetigten Sendeframes, und der L2-Versuche.        *
*									   *
\**************************************************************************/

VOID listch(chnl)
unsigned chnl;
 {
  unsigned cstate;
  unsigned mbnmbr;
  unsigned unacked;
  CIRTYP  *cirp;
  BOOLEAN  accirc;

  if (chnl != 0)		/* Circuitkanal				  */
   {
    cirp = &cirtab[chnl - 1];	/* Circuitstate fuer diesen Kanal holen   */
    cstate = cirp->state4;
   }
  hputc(chnl == actch ? '+' : ' ');	/* aktuellen Kanal markieren	  */
  hputc('(');
  hputud(chnl);				/* Kanalnummer ausgeben		  */
  hputs(") ");
  if (!chnl)				/* Monitorkanal			  */
   {
    hputid(ch0id);			/* UI-Frameadresse mit Vialiste	  */
    hputv(FALSE,ch0via);		/* anzeigen			  */
   }
  else					/* Circuitkanal			  */
   {
    if (cstate != 0)			/* Kanal aktiv			  */
     {
      if (!cirp->dir)			/* selbst connected		  */
       {
	hputid(cirp->downca);		/* Zielcall anzeigen		  */
       }
      else				/* Connect von aussen		  */
       {
	hputid(cirp->upcall);		/* Usercall anzeigen		  */
	hputs(viasp);
	hputid(cirp->upnod);		/* auch Uplinkknoten		  */
	hputvl(FALSE, cirp->upnodv);	/* Uplink-Vialiste anzeigen	  */
       }
     }
   }
  if (!chnl) mbnmbr = mbcnt(&smonfl,MBALL);	/* Empfangsframes zaehlen */
  else mbnmbr = mbcnt(&chnlml[chnl - 1],MBALL);
  accirc = chnl != 0 && cstate != 0;
  if (mbnmbr != 0 || accirc)		/* Empfangsframes anzeigen, wenn  */
   {					/* vorhanden oder aktiver Circuit */
    hcrlf();
    hputs("      receive ");
    hputud(mbnmbr);
   }
  if (accirc)					/* aktiver Circuitkanal	  */
   {
    unacked = (((cirp->l4vs & 0xff)		  /* noch nicht gesendete */ 
		- (cirp->l4rxvs) & 0xff)) & 0x7f; /* Frames		  */
    hputs("   send ");
    hputud((cirp->numtx & 0xff - unacked) & 0xff);
    hputs("   unacked ");			  /* unbestaetigte Frames */
    hputud(unacked);
    hputs("   retries ");
    hputud(cirp->l4try & 0xff);
   }
  hcrlf();
 }





/**************************************************************************\
*									   *
* "buffer get via list"							   *
*									   *
* Digiliste aus Eingabepuffer holen und in VIAL kopieren.		   *
*									   *
\**************************************************************************/

bgetvl(check,vial)

unsigned    check;
char       *vial;

  {
    char        viabuf[L2VLEN + 1];
    char       *viabp;
    unsigned    n;
    unsigned    getres;

    skpvia();			/* 'VIA' ueberspringen, wenn vorhanden	  */
    for (n = 0, viabp = viabuf;	/* Digipuffer auf Anfang		  */
	 n < L2VNUM;		/* maximal 8 Digis			  */
	 ++n, viabp += L2IDLEN)	/* Puffer + 1 Rufzeichenlaenge		  */
      if ((getres = bgetid(check,viabp)) == ERROR) /* Fehler in Digiliste */
	return (ERROR);
      else
	if (!getres) break;	/* leeres Call				  */
    *viabp = '\0';		/* \0 als Endemarkierung		  */
    while (incnt != 0)		/* noch mehr eingegeben			  */
      if (*inbufp != ' ')	/* 'n paar Leerzeichen duerfen sein	  */
	return (ERROR);		/* nix anderes - Digiliste zu lang	  */
      else
	{
	  ++inbufp;
	  --incnt;
	}
    cpyidl(vial,viabuf);	/* Digiliste kopieren			  */
    return (*vial != '\0');
  }





/**************************************************************************\
*									   *
* "skip via"								   *
*									   *
* 'VIA' zu Beginn der Digiliste ueberspringen, wenn vorhanden.		   *
*									   *
\**************************************************************************/

VOID skpvia()
  {
    char        id[L2IDLEN];
    char       *bpsav;
    char       *idp;
    unsigned    cntsav;
    unsigned    n;
    unsigned    chr;

    bpsav = inbufp;		   /* Zeiger fuer Eingabepuffer merken	  */
    cntsav = incnt;		   /* Zeichenzaehler auch		  */
    if (bgetid(FALSE,id) == TRUE)  /* erstes Call holen und auf 'VIA'	  */
      {				   /* pruefen				  */
	idp = id;		   /* Zeiger auf Anfang			  */
	if (*idp++ == 'V')	   /* erstes Zeichen 'V'		  */
	  {			   /* Rest auch ueberpruefen		  */
	    for (n = 0;		   /* bis ID-Ende vergleichen		  */
		 n < L2CALEN - 1;
		 ++n)
	      if ((chr = *idp++ & 0xFF) != ' ')	   /* Space -> weiter	  */
		if (!((!n && chr == 'I')	   /* 2. Zeichen <> 'I'	  */
		       || (n == 1		   /* 3. Zeichen <> 'A'	  */
			   && chr == 'A'))) break; /* -> nicht 'VIA'	  */
	    if (n == L2CALEN - 1) return;     /* 'V' oder 'VI' oder 'VIA' */
	  }
      }					/* nicht 'VIA' eingegeben	  */
    inbufp = bpsav;			/* Zeiger wieder auf alten Wert	  */
    incnt = cntsav;			/* Zaehler auch			  */
  }





/**************************************************************************\
*									   *
* "buffer get ID"							   *
*									   *
* Rufzeichen aus Eingabepuffer holen. Das Callende wird bei Pufferende	   *
* oder ' ' oder ',' erreicht. Control-Zeichen fuehren zum Abbruch, ebenso  *
* ein zu langes Rufzeichen oder eine zu hohe Zahl fuer den SSID. Falls	   *
* noetig wird das Rufzeichen auf Gueltigkeit ueberprueft und in den	   *
* gewuenschten Puffer kopiert.						   *
*									   *
\**************************************************************************/

bgetid(check,gidp)

unsigned    check;
char       *gidp;

  {
    char        id[L2IDLEN];
    char       *idp;
    unsigned    innmbr;
    unsigned    n;
    unsigned    inchr;

    for (idp = id, n = 0; n < L2CALEN; ++n)	/* ID-Puffer loeschen	  */
      *idp++ = ' ';
    *idp = 0x60;			/* SSID erstmal 0		  */
    nxtnos();				/* Leerzeichen ignorieren	  */
    idp = id;				/* Zeiger auf Pufferanfang	  */
    n = 0;				/* noch kein Zeichen im Puffer	  */

    while (incnt != 0)			/* noch Zeichen im Eingabepuffer  */
      {
	if ((inchr = upcase(*inbufp & 0xFF)) == ' ' /* Ende bei Leer-	  */
	     || inchr == ',') break;		    /* zeichen oder Komma */
	if (inchr < ' ') return (ERROR);	    /* CTRL-Zeichen?	  */
	if (inchr == '-')			    /* SSID folgt	  */
	  {
	    if (n == 0 || incnt == 0)	/* kein Call oder kein SSID	  */
	      return (ERROR);
	    ++inbufp;			/* -> erstes Zeichen vom SSID	  */
	    --incnt;
	    if ((inchr = *inbufp & 0xFF) /* nur Ziffern sind gueltig	  */
		 < '0' || inchr > '9')
	      return (ERROR);
	    ++inbufp;				/* -> 2. Zeichen SSID	  */
	    --incnt;
	    innmbr = inchr - '0';		/* 1. Stelle merken	  */
	    if (incnt != 0)			/* noch Zeichen vorhanden */
	      if ((inchr = *inbufp & 0xFF)	/* noch eine Ziffer?	  */
		   >= '0' && inchr <= '9')
		{
		  innmbr *= 10;				/* 1. Stelle * 10 */
		  innmbr += (inchr - '0');		/* 2. Stelle dazu */
		  if (innmbr > 15) return (ERROR);	/* SSID ungueltig */
		  ++inbufp;
		  --incnt;
		}
	    id[L2IDLEN - 1] = (innmbr << 1) | 0x60;	/* SSID setzen	  */
	    break;
	  }
	else					/* noch kommt kein SSID	  */
	  {
	    if (n++ == L2CALEN) return (ERROR);	/* CALL zu lang		  */
	    *idp++ = inchr;
	    ++inbufp;
	    --incnt;
	  }
      } /* end while */

    while (incnt != 0)	/* Eingabezeiger hinter Trennungszeichen	  */
      {
	if (!((inchr = *inbufp & 0xFF) == ' ' || inchr == ',')) break;
	++inbufp;
	--incnt;
	if (inchr == ',') break;
      }

    if (!n) return (FALSE);				/* leeres Call	  */
    if (fvalca(check,id) == ERROR) return (ERROR);	/* Call ungueltig */
    cpyid(gidp,id);					/* Call kopieren  */
    return (TRUE);					/* Call OK melden */
  }





/**************************************************************************\
*									   *
* "host put fixed unsigned"						   *
*									   *
* Zahl als ASCII-String mit einer Laenge von 5 Zeichen anzeigen.	   *
*									   *
\**************************************************************************/

VOID hputfu(u)

unsigned u;

  {
    BOOLEAN    out;
    unsigned   div;
    unsigned   digit;
    unsigned   n;

    for (out = FALSE, div = 10000, n = 0; n < 5; ++n)
      {
	if ((digit = u/div) != 0 || out == TRUE || div == 1)
	  {
	    hputc0(digit);
	    out = TRUE;
	  }
	else
	  hputsp();		/* Leerzeichen statt fuehrender Null 	  */
	u  %= div;
	div /= 10;
      }
  }


/**************************************************************************\
*									   *
* "host put CONNECTED"							   *
*									   *
\**************************************************************************/

VOID hputco()
  {
    hputs(" CONNECTED");
  }



/* Ende von TBD.C */
