/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    TBE.C	-   The Boxware, Teil 5					 *
*									 *
*  angelegt:	DF6LN unter Verwendung von TNL7 von DF2AU		 *
*									 *
*  modifiziert:	DF6LN  270492 Beim P-Befehl werden die neu gesetzten	 *
*			      Werte nicht zurueckgemeldet		 *
*		DF6LN  280492 Beim @N-Befehl wird der geaenderte Eintrag *
*			      nicht zurueckgemeldet			 *
*		DF6LN  280492 Fehlermeldung beim P-Befehl wenn falsche	 *
*			      Daten eingegeben werden.			 *
*									 *
\************************************************************************/





/*								Includes  */
/**************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			  */
#include "tb.h"		/* Festlegungen/Datenstrukturen fuer The Boxware  */
#include "l234.h"	/* Festlegungen/Datenstrukturen fuer Level 2 - 4  */
#include "tbext.h"	/* glorale Variable / nicht int-Funktionen	  */


PARTYP	partab[] = 	/* Parameter Tabelle				  */
 {
  &maxdes, 1,	 200,	/* maximale Laenge der Destination Liste	  */
  &worqua, 0,	 255,	/* minimale Qualiatet fuer Autoupdate		  */
  &ch0qua, 0,	 255,	/* HDLC Kanal Qualitaet				  */
  &obcini, 0,	 255,	/* Anfangswert Knotenlebensdauer		  */
  &broint, 0, 0xffff,	/* Rundspruchintervall				  */
  &timliv, 0,	 255,	/* Anangswert Paketlebensdauer			  */
  &tratou, 5,	 600,	/* Timeout in Level4				  */
  &tratri, 2,	 127,	/* Versuche in Level4				  */
  &traack, 1,	  60,	/* Level4 Wartezeit bis ACK			  */
  &trabsy, 1,	1000,	/* Level4 Busy Wartezeit			  */
  &trawir, 1,	 127,	/* vorgeschlagene Fenstergroesse in Level4	  */
  &conctl, 1,	 127,	/* gebufferte Frames je Verbindung		  */
  &ininat, 0, 0xffff,	/* no-activity-timeout				  */
  &Ppar,   0,	 256,	/* Entschlossenheit fuer Sendung frei		  */
  &Wpar,   0,	 127,	/* Zeitschlitzbreite				  */
  &Fpar,   1,	  15,	/* Level2, Timer1				  */
  &Opar,   1,	   7,	/* Level2, Fenstergroesse			  */
  &Npar,   1,	 127,	/* Level2, Versuche				  */
  &T2par,  0,	6000,	/* Level2, Timer2				  */
  &T3par,  0, 0xffff,	/* Level2, Timer3				  */
  &VCpar,  0,	   1,	/* Calls pruefen				  */
  &Dpar,   0,	   1,	/* Full-Duplex j/n				  */
  &xFpar,  0,	   1,	/* Flags in den pausen j/n			  */
  &Xpar,   0,	   1,	/* Sendertastung freigeben			  */
  &Tpar,   0,	 127,	/* TX-Delay					  */
  &maxcir, 0, NUMCIR,	/* maximale Zahl Connects von aussen		  */
  &myqua,  0,	 255	/* eigene Qualitaet fuer Rundspruch		  */
 };

/**************************************************************************\
*									   *
* Parms-Befehl								   *
*									   *
* Parameter anzeigen bzw. aendern					   *
*									   *
\**************************************************************************/

VOID Pcmd()
 {
  unsigned	n;
  unsigned	parnum;
  unsigned	newval;
  PARTYP       *parpoi;

  if (!nxtnos())
   {
    rspini(HMRSMSG);
    for (n = 2, parnum =0, parpoi = partab;
	 parnum < (sizeof(partab) / sizeof(struct partyp));
	 ++parnum, ++parpoi)
     {
      if (!ishmod && (n > 72))		/* im Terminalmodus Zeilenende?	  */
       {
	hcrlf();			/* dann neue Zeile		  */
	n = 0;
       }
      else
       {
	hputsp();			/* sonst nur Trennungsleerzeichen */
	++n;				/* Leerzeichen mitzaehlen	  */
       }
      ++n;					/* Zahl min. 1 Zeichen	  */
      if ((newval = *(parpoi->paradr)) > 9) ++n;/* 1 Zeichen laenger	  */
      if (newval > 99) ++n;			/* noch 1 Zeichen laenger */
      if (newval > 999) ++n;			/* --------"------------- */
      if (newval > 9999) ++n;			/* --------"------------- */
      hputud(newval);				/* Wert anzeigen	  */
     }
    rspex();			/* fertig				  */
   }
  else				/* mit Parametern aufgerufen		  */
   {
    n = 0;				/* kein Fehler			  */
    for (parnum =0, parpoi = partab;
	 parnum < (sizeof(partab) / sizeof(struct partyp));
	 ++parnum, ++parpoi)
     {
      if (!nxtnos()) break;	/* wenn alle Parameter eingegeben	  */
      if (*inbufp != '*')			/* Wert aendern?	  */
       {
	newval = bgetp();			/* neuen Wert holen	  */
	if ((newval >= parpoi->minimal) &&	/* im gruenen Bereich?	  */
	    (newval <= parpoi->maximal))
	 {
	  *(parpoi->paradr) = newval;		/* neuen Wert setzen	  */
	 }
	else
	 {
	  incnt = 0;				/* Fehler! Rest vergessen */
	  ++n;
          break;
	 }
       }
      else					/* Wert uebernehmen ('*') */
       {
	--incnt;				/* Sternchen verbr`uchen  */
	++inbufp;
       }
     }
    inilks();		/* Links mit neuen Parametern initialisieren	  */
    if (Dpar == TRUE)	/* Bei Vollduplex Sender hoschtasten		  */
     {			/* der Einfachheit halber wird nicht geguckt, ob  */
      DIinc();		/* eventuell vorher schon Vollduplex eingeschal-  */
      pushtx();		/* tet war					  */
      decEI();
     }
    for (nbrpoi = (NBRTYP *) neigbl.head;
         nbrpoi != (NBRTYP *) &neigbl.head;
         nbrpoi = (NBRTYP *) nbrpoi->nbrlnk.head)
     {
      nbrpoi->pathqu = ch0qua;	/* Qualitaet zum Nachbarn auf aktuellen   */
     }				/* Wert setzen				  */
    if (n != 0)			/* falscher Wert?			  */
     {
      rspiv(parnum+1);		/* Fehlermeldung mit Nummer des falschen  */
     }				/* Parameters				  */
    else			/* alle eingegebenen Parameter ok	  */
     {
      rspsuc();			/* fertig				  */
     }
   }
 }



/**************************************************************************\
*									   *
* Nodes-Befehl @N							   *
*									   *
* Nodeseintraege anzeigen bzw. aendern					   *
*									   *
\**************************************************************************/

VOID ENcmd()
 {
  unsigned n;			/* Zaehler				  */
  unsigned nobc;		/* neuer Abwesenheitszaehler		  */
  unsigned wegcnt;		/* Zaehler fuer Wege			  */
  unsigned aender;		/* Aenderungsmode ('+' oder '-')	  */
  unsigned tmpcnt;		/* Zwischenspeicher fuer incnt		  */
  BOOLEAN  neupar;		/* Aufruf mit gueltigen Parametern	  */
  int	   ISCALL;		/* Ergebnis Test auf gueltiges Call	  */
  int	   isnode;		/* Ergebnis Test auf gueltigen Ident	  */
  WEGTYP  *actweg;		/* aktueller Weg fuer Ausgabe		  */
  NBRTYP  *nachbar;		/* aktueller Nachbar			  */
  char     newcal[L2IDLEN];	/* neues Call				  */
  char     niden[L2CALEN];	/* neuer Ident				  */
  char    *tmppoi;		/* Zwischenspeicher fuer inbufp		  */

  if (!nxtnos())		/* Kein Knoten angegeben?		  */
   {				/* dann ignorieren			  */
    rspsuc();
   }
  else
   {
    tmppoi = inbufp;			/* Eingabezeiger merken		  */
    tmpcnt = incnt;			/* Eingabezaehler auch		  */
    isnode = getide(niden);		/* Ident eingegeben?		  */
    inbufp = tmppoi;			/* Eingabezeiger zurueck	  */
    incnt = tmpcnt;			/* Eingabezaehler auch		  */
    ISCALL = bgetid(VCpar, newcal);	/* Call eingegeben?		  */
    inbufp = tmppoi;			/* Eingabezeiger zurueck	  */
    incnt = tmpcnt;			/* Eingabezaehler auch		  */
    ISCALL = bgetid(VCpar, newcal);	/* Call eingegeben?		  */
    inbufp = tmppoi;			/* Eingabezeiger zurueck	  */
    incnt = tmpcnt;			/* Eingabezaehler auch		  */
    while (incnt != 0)			/* Call bzw. Ident ueberlesen	  */
     {
      if (*inbufp == ' ') break; /* bei Leerzeichen fertig		  */
      ++inbufp;			 /* sonst Zeiger -> naechstes Zeichen	  */
      --incnt;			 /* 1 Zeichen weniger			  */
     }
    if ((ISCALL == TRUE) || (isnode != ERROR))	/* Eingabe brauchbar	  */
     {
      neupar = FALSE;			/* default: nix neues eingegeben  */
      if ((nxtnos() == TRUE)		/* weitere Parameter?		  */
	  && (ISCALL == TRUE))		/* dann Call zu Anfang!		  */
       {

/*============== Node Parameter aendern ==================================*/

	aender = *inbufp++ & 0xff;	/* als naechstes Aenderungsmodus  */
	--incnt;			/* ein Zeichen weniger		  */
	if ((aender == '+') 		/* Aenderungsmodus nur '+' oder	  */
            || (aender == '-'))		/* '-'				  */
	 {
	  if (nxtnos() == TRUE)		/* Leerzeichen ueberlesen	  */
	   {
	    isnode = getide(niden);	/* nun kommt der Ident		  */
	    if (isnode != ERROR)	/* Ident gueltig?		  */
	     {
	      if (getqua() == TRUE)	/* nun brauchbare Qualitaet?	  */
	       {
	        if (nxtnos() == TRUE)
		 {
		  if ((nobc = bgetp()) <= 255)	/* brauchbarer Abwesen-	  */
	           {				/* heitszaehler?	  */
		    if (nxtnos() == TRUE)
		     {
		      if (bgetid(VCpar, ncall) == TRUE)	/* gueltiges Call */
			neupar = TRUE;			/* Parameter ok	  */
		     }
		   }
	         }
	       }
	     }
	   }
	 }
       }

      if (neupar == TRUE)			/* Aenderung verlangt	  */
       {
	if (chgnod(aender, nobc, nquali, "\0", 	/* Update Knotenliste	  */
	     ncall, niden, newcal, 0) == FALSE)
	 {			 	/* Aenderung nicht moeglich	  */
	  rspini(HMRFMSG);
	  hputs("NODES TABLE FULL");
	  rspexb();
	 }
	else
	 {
	  rspsuc();			/* Aenderung erfolgreich	  */
	 }
	return;
       }

/*============== Nodeseintrag anzeigen ===================================*/

      if (((ISCALL == TRUE) && (iscall(newcal) == TRUE))  /* Call oder	  */
	|| ((isnode == TRUE) && (isidnt(niden) == TRUE))) /* Ident ok	  */
       {
	rspini(HMRSMSG);
	hputs("Routes to ");
	hputal(despoi->nodide);		/* Ident anzeigen, wenn vorhanden */
	hputid(despoi->nodcal);		/* jetzt das Rufzeichen anzeigen  */

	for (wegcnt = 0; wegcnt < despoi->wege; ++wegcnt) /* alle vorhan- */
	 {						  /* denen Wege	  */
	  actweg = &despoi->weg[wegcnt];	/* Aktiven Weg setzen	  */
	  nachbar = actweg->nachba;		/* Nachbar fuer den Weg	  */
	  hcrlf();				/* Weg in neue Zeile	  */
	  hputs((((despoi->actrou != 0)		/* ein Weg aktiv?	  */
		&& (despoi->wegnr == wegcnt))	/* dieser Weg?		  */
	  	? "> " : "  "));		/* aktiven Weg markieren  */
	  hpudsp((actweg->qualit) & 0xff);	/* Qualitaet anzeigen	  */
	  hputud((actweg->obscnt) & 0xff);	/* Abwesenheitszaehler	  */
	  putnbr(nachbar);			/* Nachbar anzeigen	  */
	 }
	if (!ishmod) hcrlf();		/* im Terminalmodus neue Zeile	  */
	else hputnu();			/* im Hostmodus nix		  */
	return;				/* fertig			  */
       }
      else				/* Knoten nicht gefunden	  */
       {
	noent();
       }
     }
   }
 }


/**************************************************************************\
*									   *
* hputal								   *
*									   *
* Identifier anzeigen, wenn vorhanden					   *
*									   *
\**************************************************************************/

VOID hputal(buffer)
char buffer[];
 {
  unsigned n;
  unsigned ch;

  if (buffer[0] != ' ')			/* Ident vorhanden?		  */
   {
    for (n = 0; n < L2CALEN; ++n)
     {
      ch = buffer[n];			/* Zeichen holen		  */
      if (ch == ' ') break;		/* bei Leerzeichen fertig	  */
      hputcc(ch);			/* sonst anzeigen		  */
     }
    hputc(':');				/* nach Ident ':'		  */
   }
 }

/**************************************************************************\
*									   *
* noent									   *
*									   *
* "No entry" anzeigen							   *
*									   *
\**************************************************************************/

VOID noent()
 {
  rspini(HMRFMSG);
  hputs("NO ENTRY");
  rspexb();
 }

/**************************************************************************\
*									   *
* getide								   *
*									   *
* Aus Eingabepuffer ein Ident holen.					   *
*									   *
* Rueckgabe:	FALSE = leerer Ident					   *
*		TRUE  = Ident gueltig					   *
*		ERROR = Ident ungueltig					   *
*									   *
\**************************************************************************/

int getide(buffer)
char	buffer[];
 {
  unsigned n;			/* Zaehler				  */
  char	  ident[L2CALEN];	/* Zwischenspeicher Ident		  */
  char	  ch;			/* Zwischenspeicher einzelnes Zeichen	  */

  cpycal(ident, nulide);	/* Zwischenspeicher loeschen		  */
  cpycal(buffer, nulide);
  nxtnos();

  for (n = 0; (n < L2CALEN) && (incnt != 0); ++n)
   {
    ch = upcase(*inbufp++);			/* Zeichen holen	  */
    --incnt;					/* ein Zeichen weniger	  */
    if (ch != ' ')				/* Ende bei Leerzeichen	  */
     {
      if (((ch >= 'A') && (ch <= 'Z'))		/* gueltiges Zeichen?	  */
	 || ((ch >= '0') && (ch <= '9'))
	 || ((ch > ' ') && (ch <= '&')))
       {
	ident[n] = ch;				/* Zeichen uebernehmen	  */
	continue;				/* naechstes Zeichen	  */
       }
      if ((n != 0)				/* ungueltiges Zeichen?	  */
	  || (ch != '*')) return(ERROR);	/* '*' zum uebernehmen ok */
     }
    break;
   }
  if ((n == L2CALEN)			/* Ident vollstaendig		  */
      && (incnt != 0)			/* aber es kommt noch mehr	  */
      && (*inbufp) != ' ')		/* ausser Leerzeichen		  */
    return (ERROR);			/* dann ist der Ident zu lang	  */
  if (valcal(ident) == TRUE)		/* Rufzeichen als Ident ungueltig */
    return(ERROR);
  cpycal(buffer, ident);		/* Ident ok - kopieren		  */
  return(ident[0] != ' ');
 }


/**************************************************************************\
*									   *
* getqua								   *
*									   *
* Aus Eingabepuffer Qualitaet fuer Ziel holen.				   *
*									   *
\**************************************************************************/

BOOLEAN	getqua()
 {
  if (!nxtnos()) return(FALSE);
  nquali = bgetp();
  return(nquali <= 255);
 }


/**************************************************************************\
*									   *
* putnbr								   *
*									   *
* Call eines Nachbarn ausgeben						   *
*									   *
\**************************************************************************/

VOID putnbr(neigb)
NBRTYP *neigb;
 {
  hputsi(neigb->nbrcal);
 }



/**************************************************************************\
*									   *
* hputsp								   *
*									   *
* ein Leerzeichen ausgeben						   *
*									   *
\**************************************************************************/

VOID hputsp()
 {
  hputc(' ');
 }


/**************************************************************************\
*									   *
* hputlf								   *
*									   *
* Linefeed ausgeben							   *
*									   *
\**************************************************************************/

VOID hputlf()
 {
  hputc(LF);
 }


/**************************************************************************\
*									   *
* hputH									   *
*									   *
* 'H' ausgeben								   *
*									   *
\**************************************************************************/

VOID hputH()
 {
  hputc('H');
 }


/**************************************************************************\
*									   *
* hputI									   *
*									   *
* 'I' ausgeben								   *
*									   *
\**************************************************************************/

VOID hputI()
 {
  hputc('I');
 }


/**************************************************************************\
*									   *
* hputfz								   *
*									   *
* Fragezeichen ausgeben							   *
*									   *
\**************************************************************************/

VOID hputfz()
 {
  hputc('?');
 }


/**************************************************************************\
*									   *
* hpmb									   *
*									   *
* Inhalt eines Puffers ausgeben						   *
*									   *
\**************************************************************************/

VOID hpmb(mbp)
MBHEAD *mbp;
 {
  while (morinb(mbp) != 0) hputc(getchr(mbp));
 }


/**************************************************************************\
*									   *
* hmpmb									   *
*									   *
* Inhalt eines Puffers im Hostmode ausgeben				   *
*									   *
\**************************************************************************/

VOID hmpmb(mbp)
MBHEAD *mbp;
 {
  hputc(morinb(mbp) -1);
  hpmb(mbp);
 }


/**************************************************************************\
*									   *
* hpudsp								   *
*									   *
* unsigned decimal + space ausgeben					   *
*									   *
\**************************************************************************/

VOID hpudsp(n)
unsigned n;
 {
  hputud(n);
  hputsp();
 }


/**************************************************************************\
*									   *
* hpccxb								   *
*									   *
\**************************************************************************/

VOID hpccxb(c)
unsigned c;
 {
  hputcc(c);
  rspexb();
 }


/**************************************************************************\
*									   *
* hpcc									   *
*									   *
\**************************************************************************/

VOID hpcc(c)
unsigned c;
 {
  hputc('^');
  hputc(c + '@');
 }


/**************************************************************************\
*									   *
* hpeoln								   *
*									   *
\**************************************************************************/

VOID hpeoln()
 {
  hputs(" *\7\15\12");
 }


/**************************************************************************\
*									   *
* hputc0								   *
*									   *
\**************************************************************************/

VOID hputc0(n)
unsigned n;
 {
  hputc(n + '0');
 }


/**************************************************************************\
*									   *
* hputbe								   *
*									   *
\**************************************************************************/

VOID hputbe()
 {
  hputc(BELL);
 }


/**************************************************************************\
*									   *
* hputnu								   *
*									   *
\**************************************************************************/

VOID hputnu()
 {
  hputc(0);
 }


/*****************************************************************************\
*									      *
* addbuff(dest,src)	Inhalt des Buffers src an den Inhalt des Buffers dest *
*			anhaengen					      *
*									      *
* parameter:	dest	dahin soll kopiert werden			      *
*		src	und von da kommt der zusaetzliche Krams		      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID addbuf(dest,src)
MBHEAD *dest;				/* Zielpuffer			     */
MBHEAD *src;				/* Quellpuffer			     */
 {
  while (morinb(src) != 0)		/* solange Zeichen im Quellpuffer    */
    putchr(getchr(src),dest);		/* diese kopieren		     */
 }

/* Ende von TBE.C */
