/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    TBV.C	-   The Boxware, globale Variable			 *
*									 *
*    angelegt:      DF6LN aus TFV.C von DC4OX				 *
*    modifiziert:							 *
*									 *
\************************************************************************/





/*								Includes  */
/**************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			  */
#include "tb.h"		/* Festlegungen/Datenstrukturen fuer TheBoxware   */
#include "l234.h"	/* Festlegungen/Datenstrukturen fuer Level 2 - 4  */
#include "l3v.c"


/*						statische Globals (ROM)	  */
/**************************************************************************/

char cqid[] = { 'C','Q',' ',' ',' ',' ',0x60 };	/* ID UI-Frame an CQ	  */
char l4tct[]  = "CONNECTED to ";		/* Strings fuer l4msgs	  */
char l4tdf[]  = "DISCONNECTED fm ";
char l4tbf[]  = "BUSY fm ";
char l4tlfw[] = "LINK FAILURE with ";


char *l4msgs[] =		/* Tabelle Stringadressen Statusmeldungen */
  {				/* entsprechend L4M... :		  */
    l4tct,			/*   L4MCONNT - 1			  */
    l4tdf,			/*   L4MDISCF - 2			  */
    l4tbf,			/*   L4MBUSYF - 3			  */
    l4tlfw			/*   L4MFAILW - 4			  */
  };

char viastr[] = " via";
char viasp[] = " via ";

extern extcmd();              /* Referenzen fuer cmdtab                   */
extern rspic();
extern rspsuc();
extern Ccmd();
extern Dcmd();
extern Gcmd();
extern Icmd();
extern Jcmd();
extern Lcmd();
extern Mcmd();
extern Pcmd();
extern Qcmd();
extern Scmd();
extern Ycmd();

VOID (*cmdtab[])() =	/* Tabelle der Kommandofunktionen :		  */
  {
    extcmd,		/* @   (B, N, S)				  */
    rspic,		/* A - gibts nicht				  */
    rspic,		/* B - gibts nicht				  */
    Ccmd,		/* C - Connect-Befehl				  */
    Dcmd,		/* D - Disconnect-Befehl			  */
    rspic,		/* E - gibts nicht				  */
    rspic,		/* F - gibts nicht				  */
    Gcmd,		/* G - TNC auslesen (im Hostmodus)		  */
    rspic,		/* H - gibts nicht				  */
    Icmd,		/* I - Identifier-Befehl			  */
    Jcmd,		/* J - JHOST-Befehl				  */
    rspic,		/* K - gibts nicht				  */
    Lcmd,		/* L - List-Befehl				  */
    Mcmd,		/* M - Monitor-Befehl				  */
    rspic,		/* N - gibts nicht				  */
    rspsuc,		/* O - Dummy-Befehl, nur fuer Reinhard		  */
    Pcmd,		/* P - Parms-Befehl				  */
    Qcmd,		/* Q - QRES - TNC-Reset				  */
    rspic,		/* R - gibts nicht				  */
    Scmd,		/* S - Stream-Befehl				  */
    rspic,		/* T - gibts nicht				  */
    rspic,		/* U - gibts nicht				  */
    rspic,		/* V - gibts nicht				  */
    rspic,		/* W - gibts nicht				  */
    rspic,		/* X - gibts nicht				  */
    Ycmd,		/* Y - maximale Zahl L4-Connects von Aussen	  */
    rspic		/* Z - gibts nicht				  */
  };


/*						dynamische Globals (RAM)  */
/**************************************************************************/

LHEAD	 monfl;		    /* "monitor frame list", Listenkopf der	  */
			    /* Monitor-Frameliste, bei der Firmware	  */
			    /* werden hier hintereinander alle		  */
			    /* empfangenen und gesendeten Frames	  */
			    /* abgelegt					  */
char	 ch0id[L2IDLEN];    /* ID unproto-Kanal 0, Call normal,		  */
			    /* SSID 1 Bit linksgeschoben		  */
char	 ch0via[L2VLEN+1];  /* via-ID's unproto-Kanal 0, 0-terminiert	  */
char	 hinbuf[HBUFLEN];   /* Host-Eingabebuffer			  */
char	*inbufp;	    /* Zeiger in den Host-Eingabebuffer		  */
char	 actch;		    /* aktueller Kanal (0..127)			  */
unsigned conctl;	    /* gepufferte Frames je Verbindung		  */
unsigned Apar;		    /* AUTOLF     0..1				  */
			    /* 1 = LF automatisch auf CR bei		  */
			    /* Hosteingaben, 0 kein automatisches LF	  */
unsigned Dpar;		    /* DUPLEX     0..1				  */
unsigned Epar;		    /* ECHO       0..1				  */
			    /* 1 = Echo ein bei Hosteingaben, 0 aus	  */
unsigned Mpar;		    /* Monitorparameter             M-Befehl	  */
			    /*   Bit 0 - I				  */
			    /*   Bit 1 - U				  */
			    /*   Bit 2 - S				  */
			    /*   Bit 3 - C				  */
			    /*   Bit 4 - nicht benutzt			  */
			    /*   Bit 5 - nicht benutzt			  */
			    /*   Bit 6 - nicht benutzt			  */
			    /*   Bit 7 - nicht benutzt			  */
unsigned Ppar;		    /* P-P-Wert   0..255			  */
unsigned Tpar;		    /* TXDELAY    10ms				  */
unsigned VCpar;		    /* Validate Callsign Parameter		  */
			    /* 1 = Rufzeichencheck ein, 0 = aus		  */
unsigned Wpar;		    /* WAIT       10ms				  */
unsigned xFpar;		    /* Flagsenden in Sendepausen, 1 = an, 0 aus	  */
unsigned Xpar;		    /* PTTON      0..1				  */
char	 mftsel;	    /* "monitor from/to select",		  */
			    /*   0 = nichts				  */
			    /*   1 = + (Monitor nur mftidl-Stationen)	  */
			    /*   2 = - (Monitor nicht mftidl-Stationen)	  */
char	 mftidl[L2VLEN+1];  /* "monitor from to id list", die ID's der	  */
			    /* Stationen fuer +/-, 0-terminiert		  */
char	 ishmod;	    /* 1 = Hostmode ist an, 0 sonst		  */
char	 hmstat;	    /* Zustand waehrend Hostmodeingabe (HMS...)	  */
char	 hmch;		    /* Hostmode-Kanal				  */
char	 hmcmd;		    /* Hostmode-Kommandobyte			  */
char	 hmlen;		    /* Laenge der Hostmode-Eingabe		  */
unsigned incnt;		    /* "in counter", Laenge einer Host-Eingabe	  */
unsigned isctlr;	    /* 1 = Control R war eingegeben, 0 sonst	  */
unsigned ticks;		    /* 10ms-Ticks, Systemtakt			  */
unsigned oldtic;	    /* alter ticks-Stand fuer Sekundentakt	  */
unsigned tic1s;		    /* 1-Sekunden-Ticker			  */
MBHEAD	*mifmbp;	    /* "monitor I frame message buffer pointer"	  */
			    /* Zeiger auf I-Frame, welches hinter einem	  */
			    /* Monitor-Header auf dem Monitorkanal	  */
			    /* ausgegeben werden soll als naechstes,	  */
			    /* 0 = kein solches I-Frame vorhanden	  */
LHEAD	 statml;	    /* "status message list",			  */
			    /* Listenkopf Statusmeldungsliste Kanal 0	  */
LHEAD	 smonfl;	    /* "selected monitor frame list",		  */
			    /* Listenkopf Monitorframeliste, nur Mpar	  */
			    /* entsprechende Frames			  */
LHEAD	 chnlml[NUMCIR];    /* "channel message list",			  */
			    /* Listenkoepfe fuer jeden Kanal fuer die	  */
			    /* Empfangsframes und Statusmedungen	  */
unsigned ininat;
char	 ncall[L2IDLEN];
char	 ndigi[L2VLEN+1];
unsigned nquali;
char	 stmem[STACKLEN-1]; /* Stackspeicher				  */
char	 stack;		    /* hoechste Speicherstelle des Stacks	  */
unsigned magicn;	    /* Magic Number fuer Warmstartfeststellung	  */

/* WICHTIG!! fremem MUSS als letzte RAM-Variable geladen werden!	  */

unsigned fremem;	    /* erste Speicherstelle des Freispeichers	  */


/* Ende von TBV.C */
