/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    ALL.H   -   Headerfile fuer alle C-Sources                            *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 07.05.91                                       *
*                   Wegen der Aenderungen fuer DAMA-Slave-Betrieb ist es   *
*                   nicht mehr sinnvoll das geaenderte L2-Paket fuer       *
*                   TheNet zu compilieren!!!                               *
*                                                                          *
*                   DAMA-Betrieb ist zunaechst nur fuer einen HDLC-Port    *
*                   programmiert, so dass fuer mehrere HDLC-Ports noch     *
*                   Aenderungen vorgenommen werden muessen!!               *
*                                                                          *
*                   DL8ZAW, 05.06.91                                       *
*                   #define UIPOLL, wenn UI-Frames mit gesetztem POLL-Bit  *
*                   ausgesendet werden sollen (s. L2B.C: sdui() ).         *
*                                                                          *
*                   DB2OS,  17.09.91                                       *
*                   #define UIPOLL ersetzt durch @U Befehl und Variable    *
*                   UIpoll.                                                *
*                                                                          *
*                   DG0FT, 27.10.91                                        *
*                   #define LOOPBACK, wenn gesendete Frames als empfangen  *
*                   betrachtet werden sollen, damit interne Connects       *
*                   moeglich sind                                          *
*                                                                          *
*                   DG0FT, 26.03.92                                        *
*                   #define DRSI, fuer DRSI kompatibles Verhalten          *
*                                                                          *
*                   DG0FT, 05.02.93                                        *
*                   Variable linknmbr gibt konfigurierbare Anzahl verfueg- *
*                   barer Kanaele an, LINKNMBR ist max. Wert fuer linknmbr *
*                                                                          *
*                   DG0FT, 27.06.93                                        *
*                   Anzahl freier Buffer (nmbfre) in ALL.H zusammengefasst *
*                                                                          *
*                   DG0FT, 15.01.95                                        *
*                   #define TIMESTAMP, um K-Befehl zu aktivieren           *
*                                                                          *
\**************************************************************************/

/*                                                         Festlegungen   */
/**************************************************************************/

#define TFPC                  /* TFPC-Version erzeugen                    */
#define DRSI                  /* DRSI kompatible Meldungen, Multiport     */
#define LOOPBACK              /* interne Connects ermoeglichen            */
#define TIMESTAMP             /* K-Befehl aktivieren                      */
#define FIRMWARE              /*   defined :  Compilieren TheFirmware     */

#ifdef DRSI
#define L2PNUM      8         /* DRSI Treiber : 8 Level-2-Ports           */
#define LINKNMBR    40        /* maximale Anzahl Links = Connect-Kanaele  */

#elif defined (FIRMWARE)
#define L2PNUM      1         /* TheFirmware :  1 Level-2-Port            */
#define LINKNMBR    10        /* maximale Anzahl Links = Connect-Kanaele  */

#else
#define L2PNUM      2         /* TheNet      :  2 Level-2-Ports           */
#define LINKNMBR    25
#endif

#define TRUE        1         /* BOOLEAN TRUE                             */
#define FALSE       0         /* BOOLEAN FALSE                            */
#define YES         1         /* TRUE-Synonym                             */
#define NO          0         /* FALSE-Synonym                            */
#define ERROR       (-1)      /* Fehler                                   */
#define LOOP        for(;;)   /* Endlosschleife                           */
#define STACKLEN    384       /* Anzahl Bytes fuer Systemstack            */
#define MAGIC       0x4D5A    /* "magic number", Warmstartfeststellung    */
                              /* (MSDOS laesst gruessen ...)              */

                              /* Portnummern :                            */
#define HDLCPORT    0         /*   Packet-Port                            */
#define ASYNPORT    1         /*   RS232 Crosslink-Port                   */

#define NULL        0         /* leerer Inhalt, leerer Zeiger,            */
                              /* sollte bei 8-Bit-Systemen 0, bei 16-Bit- */
                              /* Systemen 0L heissen, 0L weil NULL auch   */
                              /* als Parameter moeglich ist, 0L bei       */
                              /* 8-Bit-Systemen kann aber dazu fuehren,   */
                              /* dass die 32-Bit-Bibliothek geladen wird, */
                              /* ohne dass sie benutzt wird               */

                              /* Anzahl freier Buffer (nmbfre) bei:       */
#define BUFTXFRAME  64        /*  Senden eines Frames           (war  64) */
#define BUFBUSYON   80        /*  Connect Busy werden           (war  80) */
#define BUFBUSYOFF  112       /*  Connect Busy aufloesen        (war 112) */
#define BUFIGNLINE  128       /*  Zeile vom Host ignorieren     (war 128) */
#define BUFCONNECT  128       /*  Connect von aussen annehmen   (war 128) */
#define BUFTNCBUSY  176       /*  TNC Busy Zustand anzeigen     (war 176) */
#define BUFHEARD    196       /*  neuer Eintrag in Heardliste   (war 196) */
#define BUFMONITOR  256       /*  Frame an Monitor uebergeben   (war 256) */

#ifdef TFPC
#define DIinc()     { _asm pushf \
                      _asm cli   }
#define decEI()     { _asm popf  }
                              /* auf gleicher Stackebene aufrufen         */
#endif

#ifdef DRSI
#define L1NAME      0         /* L1 Infos                                 */
#define L1BAUD      4
#define L1ERR       5
#define L1CLR       6

#define TPAR        1         /* L1 Parameter                             */
#define PPAR        2
#define WPAR        3
#define TAPAR       4
#define DPAR        5
#endif

#ifdef TIMESTAMP
#define time        _time     /* Namenskonflikt mit C-Library umgehen     */
#endif

/*                                                       einfache Typen   */
/**************************************************************************/

typedef int        VOID;      /* Keine-Parameter-Zurueck-Funktion         */
typedef unsigned   BOOLEAN;   /* 1 = TRUE, 0 = FALSE                      */

/* Ende von ALL.H */
