;
; iface.asm
;
; The Firmware PC Extended (TFPCX)
;
; Copyright (C) 1997  Rene Stange, DG0FT, <stange@berlin.snafu.de>
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;

; ***************************************************************************

        .model  small,c

; *** Equates ***************************************************************

VERSION    = 215h
HOSTBUF    = 512
BUFTNCBUSY = 176

; *** Externals *************************************************************

        extrn   reset_intr      : proc
        extrn   level_x         : proc

        extrn   hibuf           : byte
        extrn   hobuf           : byte
        extrn   hihead          : word
        extrn   hohead          : word
        extrn   hotail          : word

        extrn   defInt          : byte
        extrn   l1ports         : byte
        extrn   rxinfo          : byte
        extrn   txinfo          : byte
        extrn   linknmbr        : word
        extrn   nmbfre          : word
        extrn   _psp            : word

; *** Data ******************************************************************

        .data

rand_num dw     0               ; current value

; *** Code ******************************************************************

        .code

; *** TFPC Interface ********************************************************

        public  iface_tfpc
iface_tfpc label far

        jmp     short @f

        db      'XN5NX'

@@:     sti
        push    bx
        push    ds
        push    cx
        push    dx
        push    es
        mov     bx,dgroup
        mov     ds,bx
        cld

        cmp     ah,1
        je      state
        cmp     ah,2
        je      input
        cmp     ah,3
        je      output

extend: cmp     ah,0fbh
        je      getpar
        cmp     ah,0fch
        je      trxinf
        cmp     ah,0fdh
        je      bufchk
        cmp     ah,0feh
        je      getver
        cmp     ah,0ffh
        je      unload

        mov     ax,0ffffh       ; invalid
        jmp     short exit

state:  mov     ax,hotail
        cmp     ax,hohead       ; prevent buffer overrun
        jne     @f
        call    level_x
        mov     ax,hotail
        sub     ax,hohead
        je      exit
@@:     mov     ax,1
        jmp     short exit

input:  mov     bx,hotail
        and     bx,HOSTBUF-1
        mov     al,hobuf[bx]
        mov     ah,0
        inc     hotail
        jmp     short exit

output: mov     bx,hihead
        and     bx,HOSTBUF-1
        mov     hibuf[bx],al
        inc     hihead
        call    level_x         ; process character
        mov     ah,0            ; DRSI: no input character
        jmp     short exit

getpar: mov     al,l1ports
        mov     ah,byte ptr linknmbr
        jmp     short exit

trxinf: mov     al,rxinfo
        mov     ah,txinfo
        jmp     short exit

bufchk: cmp     nmbfre,BUFTNCBUSY
        mov     ax,0
        jb      exit
        inc     al
        jmp     short exit

getver: mov     ax,VERSION
        jmp     short exit

unload: call    reset_intr
        mov     ax,_psp

exit:   pop     es
        pop     dx
        pop     cx
        pop     ds
        pop     bx
        iret

; *** DRSI Interface ********************************************************

        public  iface_drsi
iface_drsi label far

        push    bx              ; DRSI specific header
        push    ds
        mov     bx,dgroup
        mov     ds,bx
        test    ah,ah
        jz      drsiin          ; offset must be 20h

@@:     sti
        push    cx
        push    dx
        push    es
        cld

        cmp     ah,1
        je      output          ; see TFPC interface
        jmp     extend

        org     @b+20h          ; see above

drsiin: sti
        push    cx
        push    dx
        push    es
        cld

        mov     ax,hotail
        cmp     ax,hohead       ; prevent buffer overrun
        jne     @f
        call    level_x
        mov     ax,hotail
        sub     ax,hohead
        je      exit

@@:     mov     bx,hotail
        and     bx,HOSTBUF-1
        mov     al,hobuf[bx]
        mov     ah,1
        inc     hotail
        jmp     short exit

; *** Call TFPCX ************************************************************

@call_tfpcx proc pascal         ; _fastcall

        mov     bl,defInt
        mov     byte ptr cs:intr,bl
        jmp     short @f        ; clear prefetch queue
@@:     int     0
intr    equ     $-1
        ret

@call_tfpcx endp

; *** Chain *****************************************************************

chain proc

        sti
        add     sp,2            ; discard return address
        pop     cx              ; get offset to jump to
        pop     ax              ; get segment
        mov     sp,bp           ; restore SP to point on entry in handler
        xchg    cx,[bp+16]      ; put offset to jump to on stack, get CX
        xchg    ax,[bp+18]      ; put segment, get AX
        pop     es              ; restore saved registers
        pop     ds
        pop     di
        pop     si
        pop     bp
        add     sp,2            ; SP need not to be restored
        pop     bx
        pop     dx
        retf                    ; jump to old handler

chain endp

; *** Set Stack *************************************************************

set_stk proc

        pop     bx              ; return address
        pop     ax              ; new stack offset
        pop     cx              ; new stack segment
        mov     dx,ss           ; get old stack segment
        cli
        mov     ss,cx           ; set new stack segment
        xchg    ax,sp           ; set new stack offset and get old one
        sti
        sub     sp,4            ; caller discards arguments from stack
        jmp     bx

set_stk endp

; *** Random ****************************************************************

random proc

        mov     ax,rand_num
        test    ah,48h
        jpo     @f
        stc
@@:     rcl     ah,1
        mov     dl,al
        rcr     al,1
        and     ah,7fh
        test    dl,11h
        jpo     @f
        or      ah,80h
@@:     mov     rand_num,ax
        xor     al,ah           ; return value in al
        ret

random endp

; *** Multi Tasker **********************************************************

mtasker proc

        mov     ah,30h          ; get DOS version
        int     21h
        cmp     al,20           ; version 20 = OS/2 2.0
        je      @f

        mov     ax,1600h        ; check Windows 3.x Enhanced Mode
        int     2fh
        and     ax,7fh          ; 00h/80h -> no Windows
@@:     ret

mtasker endp

; ***************************************************************************

        end
