/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    L2.H   -   Headerfile Level 2                                         *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 27.04.91                                       *
*                   L2CDAMA = DAMA-Bit in SSID (0=DAMA-Master)             *
*                   LNKBLK: RTT, IRTT, SRTT fuer RTT-Messung zugefuegt     *
*                                                                          *
*                   DL8ZAW, 07.05.91                                       *
*                   L2FDPOLL = Im DAMA-Modus ersten Poll uebergehen        *
*                              (siehe L2A.C)                               *
*                                                                          *
*                   DG0FT, 26.06.92                                        *
*                   LNKENTRY = Eintrag in der Linkliste                    *
*                                                                          *
*                   DG0FT, 01.04.93                                        *
*                   LNKBLK: conport = diesem Kanal zugewiesender Port      *
*                                                                          *
\**************************************************************************/

/*                                                         Festlegungen   */
/**************************************************************************/

#define L2CALEN  6                      /* Laenge Call im Level 2         */
#define L2IDLEN  (L2CALEN + 1)          /* Laenge Call + SSID = ID        */
#define L2INUM   2                      /* Anzahl ID's im an/von-Feld     */
#define L2VNUM   8                      /* Anzahl ID's im via-Feld        */
#define L2ILEN   (L2INUM * L2IDLEN)     /* Laenge an/von-Feld             */
#define L2VLEN   (L2VNUM * L2IDLEN)     /* Laenge via-Feld                */
#define L2AFLEN  (L2ILEN + L2VLEN)      /* Laenge Level 2 Adressfeld      */
#define L2MFLEN  328                    /* maximale Framelaenge,          */
                                        /*   10 * 7 =    70 Bytes Adresse */
                                        /*            +   1 Byte Control  */
                                        /*            +   1 Byte PID      */
                                        /*            + 256 Byte Info     */
                                        /*            -----               */
                                        /*              328               */

                              /* "layer 2 state", (state, s.u.) :         */
#define L2SDSCED    0         /*    disconnected                          */
#define L2SLKSUP    1         /*    link setup                            */
#define L2SFRREJ    2         /*    frame reject                          */
#define L2SDSCRQ    3         /*    disconnect request                    */
#define L2SIXFER    4         /*    information transfer                  */
#define L2SRS       5         /*    REJ sent                              */
#define L2SWA       6         /*    waiting acknowledge                   */
#define L2SDBS      7         /*    device busy                           */
#define L2SRBS      8         /*    remote busy                           */
#define L2SBBS      9         /*    both busy                             */
#define L2SWADBS   10         /*    waiting ack and device busy           */
#define L2SWARBS   11         /*    waiting ack and remote busy           */
#define L2SWABBS   12         /*    waiting ack and both busy             */
#define L2SRSDBS   13         /*    REJ sent and device busy              */
#define L2SRSRBS   14         /*    REJ sent and remote busy              */
#define L2SRSBBS   15         /*    REJ sent and both busy                */

                              /* "layer 2 message", Status vom Level 2 :  */
#define L2MNIX     0          /*    keine Nachricht                       */
#define L2MCONNT   1          /*    CONNECTED to                          */
#define L2MDISCF   2          /*    DISCONNECTED from                     */
#define L2MBUSYF   3          /*    BUSY from                             */
#define L2MFAILW   4          /*    LINK FAILURE with                     */
#define L2MLRESF   5          /*    LINK RESET from                       */
#define L2MLREST   6          /*    LINK RESET to                         */
#define L2MFRMRF   7          /*    FRAME REJECT from                     */
#define L2MFRMRT   8          /*    FRAME REJECT to                       */
#define L2MBUSYT   9          /*    BUSY to                               */

                              /* "layer 2 control", Frametypen :          */
                              /*                                          */
                              /*                       Command/   Poll/   */
                              /*    Typ       Gruppe   Response   Final   */
                              /* ---------------------------------------- */
#define L2CI       0x00       /*      I         I         C         P     */
#define L2CUI      0x03       /*     UI         U        C/R       P/F    */
#define L2CSABM    0x2F       /*   SABM         U         C         P     */
#define L2CDISC    0x43       /*   DISC         U         C         P     */
#define L2CUA      0x63       /*     UA         U         R         F     */
#define L2CDM      0x0F       /*     DM         U         R         F     */
#define L2CFRMR    0x87       /*   FRMR         U         R         F     */
#define L2CRR      0x01       /*     RR         S        C/R       P/F    */
#define L2CREJ     0x09       /*    REJ         S        C/R       P/F    */
#define L2CRNR     0x05       /*    RNR         S        C/R       P/F    */

                              /* "layer 2 control", spezielle Bits :      */
#define L2CPF      0x10       /*   Poll/Final                             */
#define L2CCR      0x80       /*   Command/Response                       */
#define L2CH       0x80       /*   "has been repeated"                    */
#define L2CEOA     0x01       /*   End of Address                         */
#define L2CDAMA    0x20       /*   DAMA-Bit in SSID (0=DAMA Master)       */

                              /* "layer 2 control", Masken :              */
#define L2CNOIM    0x01       /*   "no I mask", kein I-Frame              */
#define L2CNOSM    0x02       /*   "no S mask", kein S-Frame              */

                              /* "layer 2 control", Protokollidentifier   */
#define L2CPID     0xF0       /*   PID                                    */

                              /* "layer 2 control", Flags (flag, s.u.) :  */
#define L2FDPOLL   0x10       /*   Nicht pollen, wenn T1 noch nicht       */
                              /*   abgelaufen                             */
#define L2FL3LNK   0x20       /*   Link ist Layer-3-Link                  */
#define L2FBUSY    0x40       /*   Device busy (ich !)                    */
#define L2FDSLE    0x80       /*   "disc if send list empty"              */

                              /* im Framebufferkopf (l2fflag, s.u.) :     */
#define L2FT1ST    0x01       /*   nach Aussendung ist T1 zu starten      */
#define L2FUS      0x02       /*   Sendeframe ist U- oder S-Frame (nicht  */
                              /*   digipeatet)                            */
#ifdef LOOPBACK
#define L2FRX      0x04       /*   Frame wurde empfangen                  */
#endif

#ifdef DRSI                   /* "connect port" (s. LNKBLK) :             */
#define L2PALL     0x40       /*   Connect von allen Ports moeglich       */
#define L2PNO      0x80       /*   kein Connect von aussen moeglich       */
#endif

/*                                                                Typen   */
/**************************************************************************/

typedef struct lhead          /* "list head", Listenkopf :                */
  {
    struct lhead   *head;     /*   Zeiger auf ersten Eintrag in Liste     */
    struct lhead   *tail;     /*   Zeiger auf letzten Eintrag in Liste    */
  } LHEAD;

typedef struct lehead         /* "list entry head", Kopf eines Eintrags   */
  {                           /* in Liste :                               */
    struct lehead   *nextle;  /*   Zeiger auf naechsten Listeneintrag     */
    struct lehead   *prevle;  /*   Zeiger auf vorherigen Listeneintrag    */
  } LEHEAD;

typedef struct lnkblk         /* "link block", fuer jeden Level-2-Link :  */
  {
    char     state;           /* Link-State, s.o. L2S...                  */
    char     srcid[L2IDLEN];  /* "source id", eigenes Call/SSID oder      */
                              /* Ident/SSID                               */
    char     dstid[L2IDLEN];  /* "destination id", Call/SSID Gegenstation */
    char     viaidl[L2VLEN+1];/* "via id list", Digipeaterstrecke,        */
                              /* 0-terminiert, Weg zur Gegenstation       */
#ifdef DRSI
    char     conport;         /* "connect port", Kanal ist nur auf diesem */
                              /* Port von aussen connectbar               */
#endif
    char     liport;          /* "link port" - 0 : HDLC, 1 : Crosslink    */
    char     VR;              /* "receive sequence variable", Sequenz-    */
                              /* nummer des naechsten zu empfangenden     */
                              /* I-Frames                                 */
    char     VS;              /* "send sequence variable", Sequenznummer  */
                              /* des naechsten zu sendenden I-Frames      */
    char     lrxdNR;          /* "last received N(R)", zuletzt            */
                              /* empfangenes N(R) = eigene gesendete      */
                              /* I-Frames bis lrxdNR-1 bestaetigt         */
    char     ltxdNR;          /* "last transmitted N(R)", zuletzt         */
                              /* gesendetes N(R) = empfangene I-Frames    */
                              /* bis ltxdNR-1 bestaetigt                  */
    char     tries;           /* aktuelle Anzahl Versuche (RETRY),        */
                              /* hochzaehlend                             */
    char     N2;              /* RETRY, maximale Anzahl Retries           */
    char     k;               /* MAXFRAME, maximale Anzahl unbestaetigter */
                              /* I-Frames                                 */
    char     V2link;          /* "version 2 link" - 0 : Version 1 Link    */
                              /*                    1 : Version 2 Link    */
    char     RStype;          /* "response supervisory frametype", nach   */
                              /* T2-Ablauf zu sendendes Antwortframe      */
                              /* (RR=0x01, RNR=0x05, REJ=0x09)            */
    char     frmr[3];         /* die 3 FRMR-Infobytes, Sendung u. Empfang */
                              /*   frmr[0] : zurueckgewies. Kontrollfeld  */
                              /*   frmr[1] : V(R) CR V(S) 0               */
                              /*   frmr[2] : 0000ZYXW                     */
    char     flag;            /* Flag (s.o. L2F... )                      */
                              /*   Bit 0 : nicht benutzt                  */
                              /*   Bit 1 : nicht benutzt                  */
                              /*   Bit 2 : nicht benutzt                  */
                              /*   Bit 3 : nicht benutzt                  */
                              /*   Bit 4 : 1 = bei DAMA nicht auf Sende-  */
                              /*           aufforderung vom Master mit    */
                              /*           Poll reagieren, falls T1 noch  */
                              /*           nicht abgelaufen               */
                              /*   Bit 5 : 1 = Link ist Level 3 Link      */
                              /*           (festgestellt anhand PID !)    */
                              /*   Bit 6 : 1 = (eigenes) Device busy      */
                              /*   Bit 7 : 1 = Link disconnecten, sobald  */
                              /*           Sendeliste (sendil) leer ist   */
    unsigned IRTT;            /* "Initial Round Trip Time" = Anfangswert  */
    unsigned RTT;             /* Round-Trip-Timer (10 ms)                 */
    unsigned SRTT;            /* Smoothed Round Trip Timer                */
                              /* SRTT = (Alpha x SRTT + RTT)/(Alpha + 1)  */
    unsigned T1;              /* Timer 1, "frame acknowledge interval",   */
                              /* Start :  SRTT,                           */
                              /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned T2;              /* Timer T2, "response delay timer",        */
                              /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned T3;              /* Timer T3, "inactive link timer",         */
                              /* 0 = inaktiv, 10 msec Downcounter         */
#ifndef FIRMWARE
    unsigned noatou;          /* "no activity timeout",                   */
                              /* nach Ablauf Link disconnecten,           */
                              /* 0 = inaktiv, 1 sec Downcounter           */
#endif
    unsigned rcvd;            /* "received", Anzahl empfangener I-Frames  */
                              /* in rcvdil                                */
    unsigned tosend;          /* Anzahl noch nicht gesendete oder         */
                              /* unbestaetigte Frames in sendil           */
    LHEAD    rcvdil;          /* "received info list", richtig            */
                              /* empfangene I-Frames, mit Header/PID      */
    LHEAD    sendil;          /* "send info list", zu sendende I-Frames,  */
                              /* ohne Header/PID, nur Info                */
  } LNKBLK;

#ifdef FIRMWARE

typedef struct timebl              /* "time block", Zeit/Datums-Stamp :   */
  {
    char             second;       /*   Zeit :    Sekunde   (0..59)       */
    char             minute;       /*             Minute    (0..59)       */
    char             hour;         /*             Stunde    (0..23)       */
    char             day;          /*   Datum :   Tag       (1..31)       */
    char             month;        /*             Monat     (1..12)       */
    char             year;         /*             Jahr      (0..99)       */
  } TIMEBL;

#endif

/* ACHTUNG: mbhead muss genauso lang sein wie mb !                        */

typedef struct mbhead         /* "message buffer head",                   */
  {                           /* Datenbuffer-Liste, Kopf :                */
    struct mbhead   *nextmh;  /*   naechster Eintrag in Liste             */
    struct mbhead   *prevmh;  /*   vorheriger Eintrag in Liste            */
    LHEAD            mbl;     /*   "message buffer list", Zeiger auf      */
                              /*   ersten Infobuffer dieser Message       */
    char            *mbbp;    /*   "message buffer buffer pointer",       */
                              /*   Zeiger auf aktuelles Zeichen in Buffer */
    unsigned         mbpc;    /*   "message buffer put count",            */
                              /*   Einschreibzaehler, aufwaertszaehlend   */
    unsigned         mbgc;    /*   "message buffer get count",            */
                              /*   Lesezaehler, aufwaertszaehlend         */
    struct lnkblk   *l2link;  /*   Zeiger auf assozierten Linkblock       */
    char             type;    /*   Typ des Buffers (User, Status)         */
                              /*          L2M...                          */
                              /*     oder MB...                           */
                              /*     oder 0 User, 2 Level-2, 4 Level-4    */
    char             l2fflg;  /*   Level 2 Frameflag / PID :              */
                              /*     RX: PID                              */
                              /*     TX: PID / s.o. T2FT1ST/T2FUS         */
    char             l2port;  /*   0 = HDLC, 1 = RS232-Crosslink          */
    char             morflg;  /*   "more follows flag" fuer Pakete, die   */
                              /*   durch zusaetzlichen Netzwerkheader zu  */
                              /*   lang wuerden und in 2 Frames           */
                              /*   aufgetrennt wurden                     */
                              /*     YES = das naechste Frame gehoert zu  */
                              /*           diesem Paket                   */
                              /*     NO  = sonst                          */
#ifdef FIRMWARE
    char             rsvd[10];/*   (damit insgesamt Laenge wie mb)        */
    TIMEBL           btime;   /*   Buffer-Time fuer Zeit/Datum-Stamps     */
#else
    char             rsvd[16];/*   (damit insgesamt Laenge wie mb)        */
#endif

  } MBHEAD;

/* ACHTUNG: mb muss genauso lang sein wie mbhead !                        */

typedef struct mb             /* "message buffer",                        */
  {                           /* allgemeiner Datenbuffer :                */
    struct mb *nextmb;        /*   naechster Eintrag in Liste             */
    struct mb *prevmb;        /*   vorheriger Eintrag in Liste            */
    char       data[32];      /*   Daten                                  */
  } MB;

typedef struct stentry        /* "state table entry",                     */
  {                           /* ein Eintrag in der State-Table :         */
    VOID       (* func)();    /*   Zustandsuebergangsfunktion             */
    char       newstate;      /*   neuer Zustand                          */
  } STENTRY;

#ifdef FIRMWARE

typedef struct heardb              /* "heard buffer", ein Eintrag         */
  {                                /* in der Heardliste :                 */
    struct heardb   *nexthb;       /*   Zeiger auf naechsten L.-Eintrag   */
    struct heardb   *prevhb;       /*   Zeiger auf vorherigen L.-Eintrag  */
    char             hid[L2IDLEN]; /*   ID der gehoerten Station          */
    TIMEBL           hfirst;       /*   zuerst gehoert                    */
    TIMEBL           hlast;        /*   zuletzt gehoert                   */
    unsigned         hIno;         /*   Anzahl gehoerte I-Frames          */
    unsigned         hRRno;        /*   Anzahl gehoerte RR-Frames         */
    unsigned         hREJno;       /*   Anzahl gehoerte REJ-Frames        */
    unsigned         hRNRno;       /*   Anzahl gehoerte RNR-Frames        */
    char             hrsvd[5];     /*   (reserviert)                      */
  } HEARDB;

#endif

#ifdef DRSI

typedef struct lnkentry       /* "link entry", ein Eintrag                */
  {                           /* in der Linkliste :                       */
    char     nbrid[L2IDLEN];  /* "neighbour id", Call/SSID Nachbarstation */
    char     nbrprt;          /* "neighbour port", Port des Nachbarn      */
  } LNKENTRY;

#endif

/* Ende von L2.H */
