/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    L2A.C   -   Level 2, Teil 1                                           *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 06.05.91, Aenderungen fuer DAMA-Betrieb        *
*                   l2tx():   I-Frames nur senden, wenn senden erlaubt     *
*                   l2rx():   DAMA-Modus einschalten, wenn Frame von       *
*                             DAMA-Master an mich gerichtet ist und        *
*                             Sendung freigeben                            *
*                   l2timr(): T1: bei DAMA nicht auf Ablauf warten,        *
*                                 sondern sofort nach Sendeaufforderung    *
*                                 vom DAMA-Master POLL senden.             *
*                                 IPOLL nach DK6PX eingebaut.              *
*                             T2: bei DAMA nur senden, wenn erlaubt.       *
*                             Bei DAMA Aussendung starten, wenn senden     *
*                             erlaubt und was zu senden da.                *
*                                                                          *
*                   DL8ZAW, 07.05.91                                       *
*                   Neues Flag fuer lnktbl.flag: L2FDPOLL                  *
*                   Im DAMA-Modus wird nach Sendeaufforderung vom DAMA-    *
*                   Master nicht auf Ablauf von T1 gewartet um zu pollen.  *
*                   Damit nicht sofort nach Setzen von T1 gepollt wird,    *
*                   wird mit L2FDPOLL angezeigt, dass bei ersten Aufruf    *
*                   von l2timr() nach Setzen von T1 nicht gepollt werden   *
*                   soll. L2FDPOLL wird am Ende von l2timr() geloescht.    *
*                                                                          *
*                   DL8ZAW, 19.05.91                                       *
*                   kicktx(0) geschuetzt gegen Interrupts.                 *
*                                                                          *
*                   DL8ZAW, 19.06.91                                       *
*                   Aenderung nach DL1MEN:                                 *
*                   l2timr(): Bei Link Failure DISC aussenden              *
*                                                                          *
*                   DL8ZAW, 23.07.91                                       *
*                   l2rx(): Einschalten des DAMA-Modus nur bei nicht       *
*                           disconnecteten Links                           *
*                                                                          *
*                   DL8ZAW, 23.07.91                                       *
*                   l2rx(): Beim Einschalten von DAMA Persistance auf 255  *
*                           und Slottime auf 0 setzen; alte Werte merken   *
*                   l2rest(): Beim Auschalten von DAMA Persistance und     *
*                             Slottime wieder auf alte Werte setzen        *
*                                                                          *
*                   DB2OS,  23.08.91                                       *
*                   l2rx(): Alte Werte fuer Persistence und Slottime       *
*                           nur merken, wenn DAMA nicht bereits aktiv war. *
*                                                                          *
*                   DL8ZAW/DB2OS, 28.08.91                                 *
*                   l2rx():  Auf das Freigeben der Sendung nach DCD-Abfall *
*                            mittels 'startx' wird ganz verzichtet. Statt- *
*                            dessen wird nach Empfang eines DAMA-Frames,   *
*                            dass an das eigene Call gerichtet ist, die    *
*                            Erlaubnis zu senden (sendok=1) SOFORT frei-   *
*                            gegeben.                       ------         *
*                            Sendok wird, wie bisher, wieder auf 0 gesetzt,*
*                            wenn alles gesendet ist (l2timr()), bzw. ein  *
*                            neues Frame empfangen wird (L2D.C, l1put()).  *
*                                                                          *
*                   DB2OS,  22.09.91                                       *
*                   Walt entfallen, auch bei DAMA Slottime/Deadtime aktiv. *
*                                                                          *
*                   DB2OS,  23.09.91                                       *
*                   l2rx():  Auf ein empfangenes SABM auch im DAMA-Mode    *
*                            _sofort_ antworten.                           *
*                                                                          *
*                   DG0FT, 26.10.91                                        *
*                   l2():    Die Zeit wird jetzt im Level 2 aktualisiert.  *
*                                                                          *
*                   DG0FT, 27.10.91                                        *
*                   Wenn LOOPBACK definiert wurde, werden gesendete Frames *
*                   nicht in stfl sondern in rxfl gehaengt, damit sind     *
*                   interne Connects moeglich                              *
*                                                                          *
*                   DG0FT, 25.03.92                                        *
*                   l2():  selmfl() wird jetzt im L2 gerufen.              *
*                                                                          *
*                   DG0FT, 16.05.92                                        *
*                   DAMA-Slave auf mehrere Ports erweitert, evtl. Probleme *
*                   mit L2FDPOLL, wenn mehrere DAMA-Master zugleich        *
*                                                                          *
*                   DG0FT, 05.07.92                                        *
*                   l2rx(): bei Connect von Auen MAXFRAME setzen          *
*                                                                          *
*                   DG0FT, 17.01.93                                        *
*                   l2tx(), l2rx(): Monitor nur wenn (nmbfre > 256)        *
*                                                                          *
*                   DG0FT, 22.03.93                                        *
*                   l1par()-Aufruf fuer KISS-Parameter                     *
*                                                                          *
*                   DG0FT, 01.04.93                                        *
*                   l2rx(): Connect nur wenn conport == rxfprt od. L2PALL  *
*                                                                          *
*                   DG0FT, 26.08.93                                        *
*                   l2timr(): Bei DAMA auf Ablauf von T1 warten, bevor     *
*                             gepollt wird (wegen Multiconnect-Problem).   *
*                                                                          *
*                   DG0FT, 27.08.93                                        *
*                   l2rx(): Loopback abschaltbar, gesendete Frames werden  *
*                           bei !loopback verworfen, neues Flag L2FRX      *
*                                                                          *
*                   DG0FT, 16.01.95                                        *
*                   l2rx(): empfangene FlexNet-Frames werden verworfen     *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "l2s.h"         /* Zugriff auf die State-Tabellen                */
#include "l2ext.h"       /* globale Variable / nicht int-Funktionen       */
#include "tfext.h"       /* time wird im Level 2 behandelt                */

/**************************************************************************\
*                                                                          *
* "level 2"                                                                *
*                                                                          *
* Der Level 2. Es werden alle Level-2-internen Aktionen ausgefuehrt und    *
* Meldungen an hoehere Level weitergegeben (Informationstransfer von/zum   *
* Level 2 und Kommandos an den Level 2 geschehen von ausserhalb).          *
*                                                                          *
*                                                                          *
* Der Level 2 laeuft wie folgt ab :                                        *
*                                                                          *
*   - Aufruf von l2init()                                                  *
*                                                                          *
*   - zyklisches Aufrufen von l2() und l2timr(ticks)                       *
*                                                                          *
*   Statusaenderungen im Level 2 (Connects, Disconnects, Failures, usw.)   *
*   werden hoeheren Leveln vom Level 2 aus ueber                           *
*                                                                          *
*     l2tolx(<status>)  ->  l2tol3(<status>), l2tol7(<status>,lnkpoi,2)    *
*                                                                          *
*   mitgeteilt.                                                            *
*                                                                          *
*   Ein Connectwunsch wird dem Level 2 ueber das Besetzen eines leeren     *
*   Linkblocks mit Quell- und Ziel- sowie Digicalls und Aufrufen von       *
*   newlnk() mitgeteilt (lnkpoi zeigt auf Linkblock !).                    *
*   Ein newlnk() auf einen bestehenden Link erzeugt einen Link Reset.      *
*                                                                          *
*   Ein Disconnectwunsch (oder bei mehrmaligem Aufruf der sofortige        *
*   Disconnect) wird ueber das Setzen von lnkpoi auf den jeweiligen        *
*   Linkblock und Aufruf von dsclnk() erreicht.                            *
*                                                                          *
*   Der Informationstransfer zum Level 2 geschieht von aussen durch        *
*   Aufruf von itolnk(...), vom Level 2 durch itolx(..), welches dann      *
*   fmlink() aus dem hoeheren Level aufruft.                               *
*                                                                          *
*   Ueber sdui(..) koennen unproto-Pakete (UI-Frames) gesendet werden.     *
*                                                                          *
*   Level-3-Pakete (Level-3-UI-Pakete oder Infopakete in Sequenz eines     *
*   Level-2-3-Links) werden ausgefiltert und in die Level-3-Frameliste     *
*   eingehaengt.                                                           *
*                                                                          *
\**************************************************************************/

VOID l2()
  {
    unsigned    newtic;
    unsigned    n;

    l2rx();                             /* der Empfaenger                 */
    l2tx();                             /* der Sender                     */
    l2rest();                           /* sonstiges                      */

    DIinc();
    newtic = ticks - oldtic;
    oldtic = ticks;
    decEI();

    if (newtic != 0)
      {
        l2timr(newtic);
        if ((sec100 += newtic) >= 100)
          {
            sec100 -= 100;
#ifdef DRSI
            for (n = 0; n < L2PNUM; n++)
              if (damati[n] > 0)
                --damati[n];
#else
            if (damati > 0)
              --damati;
#endif

#ifdef TIMESTAMP
            if (++time.second == 60)
              {
                time.second = 0;
                if (++time.minute == 60)
                  {
                    time.minute = 0;
                    if (++time.hour == 24)
                      {
                        time.hour = 0;
                        switch(time.month)
                          {
                            case  2 : if (time.year % 4)
                                        n = 29;
                                      else
                                        n = 30;
                                      break;

                            case  4 :
                            case  6 :
                            case  9 :
                            case 11 :   n = 31;   break;

                            case  1 :
                            case  3 :
                            case  5 :
                            case  7 :
                            case  8 :
                            case 10 :
                            case 12 :   n = 32;   break;
                          }
                        if (++time.day == n)
                          {
                            time.day = 1;
                            if (++time.month == 13)
                              {
                                time.month = 1;
                                if (++time.year == 100) time.year = 0;
                              }
                          }
                      }
                  }
              }
#endif
          }
      }
  }

/**************************************************************************\
*                                                                          *
* "level 2 transmitter"                                                    *
*                                                                          *
* Falls Infopakete zu senden sind, laut Sendefenster keine Infopakete      *
* ausstehen, und laut Sendestatus auch gesendet werden duerfen, diese      *
* senden.                                                                  *
* Im DAMA-Modus nur senden, wenn senden erlaubt.                           *
*                                                                          *
* Frames aus Gesendet-Liste holen und in die Monitorframeliste umhaengen   *
* (Firmware) oder deallokieren. Entsprechend dem Frameinhalt ggf. Timer 1  *
* starten (wenn LOOPBACK definiert ist geschied dies in l2rx()).           *
*                                                                          *
\**************************************************************************/

VOID l2tx()
  {
    unsigned    l2state;      /* aktueller Linkstate                      */
    unsigned    n;            /* Laufindex                                */
#ifndef LOOPBACK
    MBHEAD     *sfbp;         /* Sendeframebufferpointer                  */
#endif

    for (n = 0, lnkpoi = lnktbl; n < linknmbr; ++n, ++lnkpoi)
      if (    (l2state = lnkpoi->state) == L2SIXFER           /* duerfen  */
           ||                   l2state == L2SRS              /* wir was  */
           ||                   l2state == L2SDBS             /* senden ? */
           ||                   l2state == L2SRSDBS
         )
        if (lnkpoi->VS == lnkpoi->lrxdNR)         /* nichts ausstehend     */
          {
            sdi(lnkpoi->k);                       /* ...dann Infos senden  */
            lnkpoi->flag |= L2FDPOLL;             /* DAMA: zunaechst nicht */
          }                                       /*       pollen ...      */

#ifndef LOOPBACK
    while ((sfbp = stfl.head) != &stfl)           /* Gesendetliste        */
      {                                           /* aufraeumen :         */
        unlink(sfbp);                             /* Frame holen          */
        if ((sfbp->l2fflg & L2FT1ST) != NO)       /* ist T1 zu starten ?  */
          {                                       /* ja, Zeiger auf Link- */
            lnkpoi = sfbp->l2link;                /* block (zum Frame)    */
            setT1();                              /* und T1 starten       */
          }
#ifdef FIRMWARE
        if (nmbfre > BUFMONITOR)                  /* falls noch genug     */
          {
            relink(sfbp,monfl.tail);              /* Platz, Frame in den  */
            selmfl();                             /* Monitor, sofort ver- */
          }                                       /* arbeiten             */
        else
#endif
          dealmb(sfbp);                           /* oder deallokieren    */
      }
#endif
  }

/**************************************************************************\
*                                                                          *
* "level 2 receiver"                                                       *
*                                                                          *
* Alle Frames aus der RX-Frameliste holen und analysieren. Kopie an        *
* Monitorliste, digipeaten oder in Level-3-Liste, falls erforderlich.      *
* Auf UI-Frames antworten, falls erforderlich.                             *
*                                                                          *
* Reaktion entsprechend Protokoll, siehe unten.                            *
*                                                                          *
\**************************************************************************/

VOID l2rx()
  {
    char       *source;       /* Zeiger auf Quellrufzeichen/SSID          */
    unsigned    l2state;      /* aktueller Level 2 Linkstatus             */
    BOOLEAN     tome;         /* YES = Frame ist an mich                  */
    unsigned    n;            /* Laufindex                                */
    MBHEAD     *fbp;          /* Framebufferpointer lokal                 */
    LNKBLK     *lblkp;        /* Linkblockpointer lokal                   */

    while ((fbp = rxfl.head) != &rxfl)            /* solange empfangene   */
      {                                           /* Frames vorhanden     */
        unlink(fbp);                              /* eins aus Liste holen */

#ifdef LOOPBACK
        if ((fbp->l2fflg & L2FT1ST) != NO)        /* ist T1 zu starten ?  */
          {                                       /* ja, Zeiger auf Link- */
            lnkpoi = fbp->l2link;                 /* block (zum Frame)    */
            setT1();                              /* und T1 starten       */
          }
#endif

        if (!takfhd(fbp))                         /* Kopf analysieren,    */
          {                                       /* wenn nicht ok, dann  */
            dealmb(fbp);                          /* wegwerfen und zum    */
            continue;                             /* naechsten            */
          }

        fbp->type = 2;                            /* wir sind im Level 2  */

#ifdef FIRMWARE
        if (nmbfre > BUFMONITOR)                  /* wenn genug Platz,    */
          {
            relink(cpyfb(fbp),monfl.tail);        /* Kopie an Monitor     */
            selmfl();                             /* sofort verarbeiten   */
          }
#endif

        if (    rxfflx                            /* wenn FlexNet-Frame,  */
#ifdef LOOPBACK
             ||    !loopback                      /* oder kein Loopback   */
                && !(fbp->l2fflg & L2FRX)         /* und gesendeter Frame */
#endif
           )
          {
            dealmb(fbp);                          /* dann wegwerfen und   */
            continue;                             /* zum naechsten Frame  */
          }

        if (digipt(fbp) == YES) continue;         /* ... nur Digipeater   */

        if (rxfctl == L2CUI)                      /* UI-Frame,            */
          {                                       /* wenn an mich, und    */
            if (istome(rxfhdr) == YES)            /* Antwort erwuenscht,  */
              if (rxfPF != NO && rxfCR != NO)     /* entsprechend         */
                xdm();                            /* beantworten          */
            lnkpoi = NULL;                        /* fuer tol3sw()        */
            if (!tol3sw(fbp))                     /* Level 3 UI-Frame ?   */
              dealmb(fbp);                        /* nein -> weg damit    */
            continue;                             /* naechstes Frame      */
          }

        /* Haben wir einen zum Frame passenden Linkblock ?                */
        /*                                                                */
        /* Alle Linkbloecke durchgucken. Wenn ein aktiver Linkblock       */
        /* gefunden wurde, dessen Quellcall mit dem Framezielcall         */
        /* uebereinstimmt, tome auf TRUE setzen. Wenn auch noch Blockport */
        /* mit Frameport und Blockzielcall mit Framequellcall             */
        /* uebereinstimmen, dann ist der aktive passende Link gefunden,   */
        /* Schleife abbrechen.                                            */
        /*                                                                */
        /* Falls ein Link inaktiv ist, aber das Framezielcall an mich     */
        /* (Call + SSID oder Ident mit beliebiger SSID) ist, oder das     */
        /* Blockquellcall mit dem Framezielcall uebereinstimmt, dann      */
        /* Blockadresse in lblkp merken. Es wird nur der erste solche     */
        /* Block genommen.                                                */

        for ( tome = NO, lblkp = NULL, n = 0, lnkpoi = lnktbl;
              n < linknmbr;
              ++n, ++lnkpoi
            )
          if (lnkpoi->state != L2SDSCED)
            {
              if (cmpid(lnkpoi->srcid,rxfhdr) == TRUE)
                {
                  tome = YES;
                  if (    lnkpoi->liport == rxfprt
                       && cmpid(lnkpoi->dstid,rxfhdr + L2IDLEN) == TRUE
                     ) break;
                }
            }
          else
            if (    !lblkp
                 && (    (    *lnkpoi->srcid == '\0'
                           && istome(rxfhdr) == TRUE
                         )
                      || (    *lnkpoi->srcid != '\0'
                           && cmpid(lnkpoi->srcid,rxfhdr) == TRUE
                         )
                    )
               )
              {
#ifdef DRSI
                tome = YES;
                if (   lnkpoi->conport == L2PALL
                    || lnkpoi->conport == rxfprt)
#endif
                  lblkp = lnkpoi;
              }

        if (n == linknmbr)                   /* wenn kein aktiver Link    */
          if (lblkp)                         /* passst, aber inaktiver    */
            lnkpoi = lblkp;                  /* Link, dann diesen nehmen  */
          else
            {                                /* sonst, wenn trotzdem das  */
              if (    tome == YES            /* Frame an mich gerichtet   */
                   || istome(rxfhdr) == TRUE /* ist, reagieren :          */
                 )
                {
                  if (rxfctl == L2CSABM)     /* SABM mit DM beantworten   */
                    {                        /* und hoeheren Leveln       */
                      l2tolx(L2MBUSYT);      /* melden                    */
                      xdm();
                    }
                  else                       /* sonst nur antworten, wenn */
                    if (    rxfPF != 0       /* Command mit Poll, dann    */
                         && rxfCR != 0       /* mit DM antworten          */
                       ) xdm();
                    else                     /* oder wenn kein Command    */
                      if (rxfctl == L2CDISC) /* Poll, aber ein DISC, mit  */
                        xua();               /* UA antworten              */
                }
              dealmb(fbp);                   /* empfangenes Frame weg-    */
              continue;                      /* werfen und zum naechsten  */
            }

        /* Falls Timer 3 aktiv, diesen neu setzen, es ist wieder          */
        /* Aktivitaet auf dem Link                                        */

        if (lnkpoi->T3 != 0) setT3();

        /* Fuer nicht disconnectete Links:                                */
        /* Falls RX-Frame von DAMA-Master, DAMA Timer neu setzen und      */
        /* DAMA Modus einschalten und Sendung freigeben nach DCD-Abfall.  */

        if (    lnkpoi->state != L2SDSCED
             && (lnkpoi->dstid[L2IDLEN-1] & L2CDAMA) == 0
           )
          {
#ifdef DRSI
            if (damaok[rxfprt] == 0)    /* Nur wenn DAMA nicht bereits    */
            {                           /* aktiviert war...               */
                                        /* Alten P-Persistance-Wert merken*/
              Palt[rxfprt] = Ppar[rxfprt];
                                        /* P=255 -> immer sofort senden   */
              l1par(rxfprt,PPAR,Ppar[rxfprt] = 255);
            }

            damaok[rxfprt] = 1;         /* DAMA-Modus einschalten         */
            sendok[rxfprt] = 1;         /* sofort senden erlauben!        */
            damati[rxfprt] = DApar[rxfprt];
#else
            if (damaok == 0)            /* Nur wenn DAMA nicht bereits    */
            {                           /* aktiviert war...               */
              Palt = Ppar;              /* Alten P-Persistance-Wert merken*/
              Ppar = 255;               /* P=255 -> immer sofort senden   */
            }

            damaok = 1;                 /* DAMA-Modus einschalten         */
            sendok = 1;                 /* sofort senden erlauben!        */
            damati = DApar;
#endif
          }

        l2state = lnkpoi->state;        /* Linkstatus zur Abfrage         */

        if (!(rxfctl & L2CNOIM))        /* I-Frame ?                      */
          {

            /* I-Frame :                                                  */
            /*                                                            */
            /* Nur annehmen, wenn empfangene N(R) des Frames ok,          */
            /* srxdNR(), und das I-Frame das naechste erwartete in der    */
            /* Sequenz ist, isntxi().                                     */
            /* Wenn alles ok, Laenge pruefen und ggf. auf falsche Laenge  */
            /* mit Frame-Reject reagieren, sonst Antwort entsprechend     */
            /* Statetable und I-Frame verarbeiten.                        */

            if (    srxdNR() == TRUE                   /* N(R) ok ?       */
                 && isnxti() == TRUE                   /* erwartet ?      */
               )
              if (fbp->mbpc - fbp->mbgc <= 257)        /* Laengenpruefung */
                {

                  l2stma(!rxfPF ? stbl01 : stbl00);    /* Statetable      */

                  /* Linkzustand I-Transfer moeglich und nicht busy ? */

                  if (l2state >= L2SIXFER && !(lnkpoi->flag & L2FBUSY))
                    {

                      /* wenn Level-3-I-Paket, dann in Level-3-RX-Liste   */
                      /* einhaengen und Link als Level-3-Link markieren,  */
                      /* No-Activity-Timeout neu starten                  */

                      if (tol3sw(fbp) == YES)
                        {
                          lnkpoi->flag |= L2FL3LNK;
#ifndef FIRMWARE
                          lnkpoi->noatou = ininat;
#endif
                        }
                      else

                        /* wenn normales Level-2-I-Paket, wenn nicht Busy */
                        /* oder Level-3-Link, I annehmen und in           */
                        /* Linkempfangsliste einhaengen                   */

                        if (!(lnkpoi->flag & (L2FDSLE | L2FL3LNK)))
                          {
                            relink(fbp,lnkpoi->rcvdil.tail);
                            ++lnkpoi->rcvd;
                          }
                        else
                          dealmb(fbp);  /* ansonsten Paket wegwerfen      */
                      continue;         /* auf zum naechsten Paket        */
                    }
                }
              else                      /* Frame zu lang :                */
                sdfrmr(0x03);           /* "U/S-Frame mit unerlaubtem     */
                                        /* Infofeld"                      */
          }

        else                                 /* kein I-Frame :            */
          if (!(rxfctl & L2CNOSM))
            {

              /* S-Frame :                                                */
              /*                                                          */
              /* Nur annehmen, wenn empfangene N(R) des Frames ok,        */
              /* srxdNR(), und wenn das Frame kein Infofeld enthaelt.     */
              /*                                                          */
              /* Auf RR, RNR, REJ entsprechend Statetable antworten, auf  */
              /* andere mit Frame-Reject antworten.                       */

              if (srxdNR() == YES)                     /* N(R) ok ?       */
                {

                  if (fbp->mbgc == fbp->mbpc)          /* kein I-Feld ?   */
                    switch ((rxfctl >> 2) & 0x03)
                      {
                        case 0 :                       /* L2CRR >> 2      */
                          l2stma(   !rxfCR
                                  ? (!rxfPF ? stbl11 : stbl10)
                                  : (!rxfPF ? stbl03 : stbl02)
                                 );
                        break;

                        case 1 :                       /* L2CRNR >> 2     */
                          l2stma(   !rxfCR
                                  ? (!rxfPF ? stbl15 : stbl14)
                                  : (!rxfPF ? stbl07 : stbl06)
                                );
                        break;

                        case 2 :                       /* L2CREJ >> 2     */
                          l2stma(   !rxfCR
                                  ? (!rxfPF ? stbl13 : stbl12)
                                  : (!rxfPF ? stbl05 : stbl04)
                                );
                          if (l2state >= L2SIXFER) sdoi();
                        break;

                        default :
                          sdfrmr(0x01);   /* "Kontrollfeld falsch oder      */
                        break;            /* nicht implementiert"           */

                    } /* end switch ((rxfctl >> 2) & 0x03) */
                  else
                    sdfrmr(0x03);         /* "U/S-Frame mit unerlaubtem     */
                                          /* Infofeld"                      */
              }
            } /* end S-Frame */

          else                               /* kein I- oder S-Frame :    */
            if ((rxfctl & 0xFF) != L2CFRMR)

              /* Kein FRMR-Frame, Frame nur annehmen, wenn kein Infofeld  */
              /* vorhanden.                                               */
              /*                                                          */
              /* Frame auswerten, reagieren, nach Statetable antworten.   */

              if (fbp->mbgc == fbp->mbpc)
                switch (rxfctl)
                  {

                    case L2CSABM :             /* neuer Link / Linkreset  */
                      lnkpoi->V2link = rxfV2;  /* Protokollversion merken */
                      switch (l2state)
                        {                      /* neuer Link (Connect) ?  */
                          case L2SDSCED :
                            if (    fvalca(VCpar,rxfhdr + L2IDLEN) == TRUE
                                 && nmblks < Ypar
                                 && nmbfre > BUFCONNECT /* annehmbar ?    */
                               )
                              {
                                inilnk();              /* ja, Link init.  */
#ifdef DRSI                                            /* MAXFRAME setzen */
                                lnkpoi->k = Opar[lnkpoi->liport];
#endif
                                ++nmblks;              /* neuer Link      */
                                l2tolx(L2MCONNT);      /* melden          */
#ifdef DRSI
                                sendok[rxfprt] = 1;    /* DAMA: sofort UA */
#else
                                sendok = 1;            /* DAMA: sofort UA */
#endif
#ifndef FIRMWARE
                                lnkpoi->noatou = ininat;
#endif
                                break;                 /* -> Statetable   */
                              }
                            l2tolx(L2MBUSYT);          /* nein, melden    */
#ifdef DRSI
                            sendok[rxfprt] = 1;        /* DAMA: sofort..  */
#else
                            sendok = 1;                /* DAMA: sofort..  */
#endif
                            xdm();                     /* mit DM antwort. */
                            dealmb(fbp);               /* Frame vergessen */
                            continue;                  /* naechstes Paket */
                          break;

                          case L2SLKSUP :              /* beide connecten */

                            /* anderer Weg als selbst benutzt ? */

                            if ( !cmpidl(   cmpid(rxfhdr + L2IDLEN,
                                                  lnkpoi->srcid) == TRUE
                                          ? rxfhdr + L2ILEN
                                          : txfhdr + L2ILEN,
                                          lnkpoi->viaidl
                                        )
                               )
                              {
                                l2tolx(L2MBUSYF);           /* abbrechen  */
                                clrlnk();                   /* ja, alles  */
                                xdm();
                                lnkpoi->state = L2SDSCED;
                                dealmb(fbp);
                                continue;
                              }
                            else
                              {
                                reslnk();                   /* nein,      */
                                cpyid(lnkpoi->dstid,txfhdr);
                                l2tolx(L2MCONNT);           /* gelungener */
#ifndef FIRMWARE
                                lnkpoi->noatou = ininat;    /* Connect    */
#endif
                              }
                          break;

                          case L2SDSCRQ :         /* sind ge-disct, Link  */
                            mclrlk();             /* aufloesen und melden */
                          break;

                          default :               /* normaler Linkreset   */
#ifdef DRSI
                            sendok[rxfprt] = 1;   /* DAMA: sofort Antwort */
#else
                            sendok = 1;           /* DAMA: sofort Antwort */
#endif
                            inilnk();             /* an Partner           */
                            l2tolx(L2MLRESF);
                          break;

                        } /* end switch (l2state) */

                      l2stma(stbl08);             /* SABM EITHER COMMAND  */
                    break;

                    case L2CDISC :
                      if (!l2state)               /* Link aktiv ?         */
                        {
                          if (    rxfPF != 0      /* nein, wenn Command   */
                               && rxfCR != 0      /* mit Poll, dann mit   */
                             ) xdm();             /* DM antworten         */
                          else
                            xua();                /* sonst mit UA         */
                          dealmb(fbp);            /* Frame wegwerfen      */
                          continue;               /* naechstes Paket      */
                        }
                      else                        /* ja,                  */
                        if (l2state == L2SLKSUP)  /* wenn im Linkaufbau,  */
                          {                       /* dann Link sofort     */
                            l2tolx(L2MBUSYF);     /* aufloesen und melden */
                            clrlnk();
                          }
                        else                      /* sonst erst restliche */
                          {                       /* I-Frames an hoeheren */
                            i2tolx(YES);          /* Level geben und dann */
                            mclrlk();             /* Link loesen / melden */
                          }
                      l2stma(stbl09);             /* DISC EITHER COMMAND  */
                    break;

                    case L2CUA :
                      if (l2state < L2SRS)             /* V1-Zustand ?    */
                        {
                          if (l2state == L2SLKSUP)     /* ja, wenn im     */
                            {                          /* Link-Setup      */
                              lnkpoi->V2link = rxfV2;  /* Protokollvers.  */
                              reslnk();                /* uebernehmen,    */
                              cpyid(lnkpoi->dstid,txfhdr);
                              l2tolx(L2MCONNT);        /* Link neu und    */
#ifndef FIRMWARE
                              lnkpoi->noatou = ininat; /* melden          */
#endif
                            }
                          else                         /* sonst wenn im   */
                            if (l2state == L2SDSCRQ)   /* Disc-Request    */
                               mclrlk();               /* Link aufloesen  */
                        }
                      else
                        {
                          reslnk();                    /* nein, Linkreset */
                          l2tolx(L2MLREST);            /* ausf. / melden  */
                        }
                      l2stma(stbl16);             /* UA EITHER RESPONSE   */
                    break;

                    case L2CDM :
                      if (l2state)                /* wenn Link aktiv ...  */
                        if (l2state == L2SLKSUP)  /* wenn DM beim Link-   */
                          {                       /* Setup, dann Link     */
                            l2tolx(L2MBUSYF);     /* sofort aufloesen und */
                            clrlnk();             /* "Busy from" melden   */
                          }
                        else                      /* sonst Link aufloesen */
                          mclrlk();               /* mit Meldung          */
                      l2stma(stbl17);             /* DM EITHER RESPONSE   */
                    break;

                    default :           /* unbekanntes Kontrollfeld :     */
                      sdfrmr(0x01);     /* "Kontrollfeld falsch oder      */
                    break;              /* nicht implementiert"           */

                  } /* end switch (rxfctl) */
              else                                /* Frametyp unbekannt   */
                sdfrmr(0x03);                     /* "U/S-Frame mit un-   */
                                                  /* erlaubtem Infofeld"  */

            else /* from if (rxfctl != L2CFRMR) */
              {

                /* FRMR-Frame :                                           */
                /*                                                        */
                /* Wird nur im Frame-Reject-Zustand oder bei moeglichem   */
                /* Informationstransfer angenommen.                       */
                /* Es werden die FRMR-Infobytes gelesen, FRMR an die      */
                /* hoeheren Level gemeldet, nach Statetable geantwortet.  */

                if (l2state >= L2SIXFER || l2state == L2SFRREJ)
                  {
                    /* FRMR-Infobytes im Linkblock merken */
                    for (source = lnkpoi->frmr, n = 0; n < 3; ++n)
                      *source++ = (fbp->mbgc < fbp->mbpc) ? getchr(fbp) : 0;
                    l2tolx(L2MFRMRF);
                  }
                l2stma(stbl18);                   /* FRMR EITHER RESPONSE */

              }

        dealmb(fbp);          /* aktuelles Frame verarbeitet, wegwerfen   */

      } /* end while ((fbp = rxfl.head) != &rxfl) */
  }

/**************************************************************************\
*                                                                          *
* "level 2 rest"                                                           *
*                                                                          *
* Fuer alle aktiven Links Busyzustand pruefen/setzen/aufloesen, I-Pakete   *
* unter Beruecksichtigung der "Erstickungskontrolle" an hoehere Level      *
* weiterreichen. Fall Zustand "Disconnecten nach Uebertragung der          *
* restlichen I-Pakete" und keine I-Pakete mehr zu senden, Disconnect       *
* einleiten.                                                               *
* Muellbufferliste frei machen (aus Interruptroutinen entstandener Muell,  *
* der besser ausserhalb der Interrupts deallokiert wird aus Zeitgruenden). *
*                                                                          *
* Bei abgelaufenenem DAMA-Timer sofort DAMA-Modus abschalten und alle noch *
* zu sendenden Frames senden                                               *
*                                                                          *
\**************************************************************************/

VOID l2rest()
  {
    unsigned n;

    for (n = 0, lnkpoi = lnktbl; n < linknmbr; ++n, ++lnkpoi)
      if (lnkpoi->state != L2SDSCED)
        {

          /* fuer alle aktiven (= nicht disconnecteten) Links : */

          txfV2 = lnkpoi->V2link;                  /* Protokollversion    */

          /* wenn Zustand "nachdem alle restliche I's uebertragen wurden, */
          /* disconnecten" und alle I's uebertragen, DISC einleiten       */

          if (    ((lnkpoi->flag & L2FDSLE) != NO)
               && !lnkpoi->tosend
             ) disc();

          /* sonst empfangene I-Pakete an hoeheren Level uebertragen und  */
          /* Busy-Condition pruefen / setzen / aufheben                   */
          /*                                                              */
          /* "Busy werden"      -   weniger als 80 Freibuffer             */
          /*                        oder so viele I-Pakete empfangen und  */
          /*                        nicht abgeholt, wie                   */
          /*                        "Erstickungszaehler" conctl angibt    */
          /*                                                              */
          /* "Busy aufloesen"   -   wieder mehr als 112 Freibuffer        */
          /*                        und weniger als halb so viele         */
          /*                        empfangen und nicht abgeholt wie      */
          /*                        conctl angibt                         */

          else
            {
              i2tolx(NO);
              if (!(lnkpoi->flag & L2FBUSY))     /* nicht busy            */
                {
                  if (nmbfre < BUFBUSYON || lnkpoi->rcvd >= conctl)
                    {
                      lnkpoi->flag |= L2FBUSY;   /* busy werden           */
                      l2stma(stbl21);            /* STATION BECOMES BUSY  */
                    }
                }
              else
                if (nmbfre > BUFBUSYOFF && lnkpoi->rcvd < conctl/2)
                  {
                    lnkpoi->flag &= ~L2FBUSY;    /* "busy" aufloesen      */
                    l2stma(stbl22);              /* BUSY CONDITION CLEARS */
                  }
            }
        } /* end if (lnkpoi->state) */

    dealml(&trfl);                      /* Muellbufferliste frei machen   */

#ifdef DRSI
    for (n = 0; n < L2PNUM; n++)
      if (damaok[n] == 1 && damati[n] == 0) /* DAMA Timer abgelaufen ?    */
        {
          damaok[n] = 0;                /* DAMA Modus ausschalten         */
          l1par(n,PPAR,Ppar[n] = Palt[n]); /* P wieder auf alten Wert     */
          if (tosend[n] == 1)           /* noch was zu senden ?           */
            {
              DIinc();
              kicktx(n);                /* ja, dann sofort senden         */
              decEI();
              tosend[n] = 0;
            }
        }
#else
    if (damaok == 1 && damati == 0)     /* DAMA Timer abgelaufen ?        */
      {
        damaok = 0;                     /* DAMA Modus ausschalten         */
        Ppar = Palt;                    /* P wieder auf alten Wert        */
        if (tosend == 1)                /* noch was zu senden ?           */
          {
            DIinc();
            kicktx(0);                  /* ja, dann sofort senden         */
            decEI();
            tosend = 0;
          }
      }
#endif
  }

/**************************************************************************\
*                                                                          *
* "level 2 timer"                                                          *
*                                                                          *
* Ausfuehren der Level-2-Millisekundentimer 1, 2, 3 in allen aktiven       *
* Links (herunterzaehlen und bei Ablauf reagieren).                        *
* In ticks wird die Anzahl der vergangenen 10ms-Intervalle (Ticks) seit    *
* dem letzten Aufruf dieser Routine angegeben.                             *
*                                                                          *
* Bei eingeschaltetem DAMA-Modus:                                          *
* T1: nicht auf Ablauf von T1 warten, sondern nach Sendeaufforderung vom   *
*     DAMA-Master sofort POLL senden.                                      *
* T2: nur Bestaetigung senden, wenn senden erlaubt.                        *
*                                                                          *
\**************************************************************************/

VOID l2timr(ticks)

unsigned ticks;

  {
    unsigned n;
#ifdef DRSI
    BOOLEAN  flag;
#endif

    for (n = 0, lnkpoi = lnktbl; n < linknmbr; ++n, ++lnkpoi)
      if (lnkpoi->state != L2SDSCED)
        {

          /* fuer alle aktiven (= nicht disconnecteten) Links : */

          txfV2 = lnkpoi->V2link;       /* Merker ob Version-2-Protokoll  */

          if (lnkpoi->T1 != 0)          /* wenn Timer 1 aktiv ...         */
            if (   lnkpoi->T1 <= ticks  /*   ... und abgelaufen           */
#ifdef DRSI
                && (   !damaok[lnkpoi->liport]     /* und kein DAMA-Modus */
                    || (   sendok[lnkpoi->liport]  /* oder DAMA senden OK */
#else
                && (   !damaok                     /* und kein DAMA-Modus */
                    || (   sendok                  /* oder DAMA senden OK */
#endif
                        && !(lnkpoi->flag & L2FDPOLL)    /* und kein Flag */
                       )
                   )
               )
              {
                lnkpoi->T1 = 0;         /*   ... Timer 1 stoppen          */
                lnkpoi->RTT = 0;        /*   ... RTT-Messung stoppen      */
                setT3();                /*   Timer 3 neu starten          */
                ++lnkpoi->tries;        /*   Retryzaehler                 */
                if (    !lnkpoi->N2
                     || lnkpoi->tries < lnkpoi->N2 /* zu viele Retries ?  */
                   )
                  {
                    if (    lnkpoi->V2link == NO      /* nein, bei V1 oder */
                         && lnkpoi->state >= L2SIXFER /* V1-Status >=IXFER */
                       )                              /* ausstehende       */
                       sdoi();                        /* I's senden        */
                    else
                      {
                        /* IPOLL nach DK6PX:                              */
                        /* Wenn noch Info-Frames nicht bestaetigt sind,   */
                        /* L2-Status >= Info-Transfer, AX25L2V2 und       */
                        /* erstes noch nicht bestaetigtes I-Frame         */
                        /* richtige Laenge hat, dann dieses I-Frame mit   */
                        /* gesetzem POLL-Bit maximal 3-mal senden, sonst  */
                        /* laut State-Table verfahren.                    */

                        if (   lnkpoi->tosend > 0
                            && lnkpoi->state  >= L2SIXFER
                            && lnkpoi->V2link == YES
                            && ((MBHEAD *)lnkpoi->sendil.head)->mbpc < Ipar
                            && lnkpoi->tries < 3
                           )
                          sdipoll();
                        else
                          l2stma(stbl23);          /* Statet. T1 EXPIRES  */
                      }
                  }
                else
                  {                                /* zu viele Retries :  */
                    lnkpoi->tries = 0;             /* Retryzaehler leer   */
                    xdisc();                       /* DISC aussenden      */
                    l2tolx(L2MFAILW);              /* "Link failure"      */
                    clrlnk();                      /* Link sofort loesch. */
                    lnkpoi->state = L2SDSCED;      /* DISCONNECTED        */
                  }
              }
            else
              if (lnkpoi->T1 > ticks)
                lnkpoi->T1 -= ticks;    /*   sonst herunterzaehlen        */

          /* Wenn RTT-Messung freigegeben ist, dann RTT um ticks erhhen  */
          if (lnkpoi->RTT != 0)
            lnkpoi->RTT += ticks;

          if (lnkpoi->T2 != 0)          /* wenn Timer 2 aktiv ...         */
            if (lnkpoi->T2 <= ticks)    /*   wenn Timer 2 abgelaufen ...  */
              lnkpoi->T2 = 0;           /*   ... Timer 2 stoppen          */
            else
              lnkpoi->T2 -= ticks;      /*   sonst herunterzaehlen        */

          if (    !lnkpoi->T2           /* wenn Timer 2 abgelaufen ist    */
               && lnkpoi->RStype != 0   /* und Response zu senden ist     */
               && !iscd(lnkpoi->liport) /* und der Kanal frei ist         */
#ifdef DRSI
               && (   damaok[lnkpoi->liport] == 0 /* und kein DAMA-Modus  */
                   || sendok[lnkpoi->liport] == 1 /* oder DAMA            */
                  )                     /* und senden erlaubt             */
#else
               && (   damaok == 0       /* und kein DAMA-Modus            */
                   || sendok == 1       /* oder DAMA eingeschaltet        */
                  )                     /* und senden erlaubt             */
#endif
             )                          /* dann ...                       */
            {
              stxfad();                 /* ... Responseframe bauen        */
              txfCR = txfPF = 0;
              txfctl = setNR(   !(lnkpoi->flag & L2FBUSY)
                              ? lnkpoi->RStype
                              : L2CRNR
                           );
              sdl2fr(makfhd(L2FUS));    /* und senden                     */
              lnkpoi->RStype = 0;       /* Responsemodus loeschen         */
            }

          if (lnkpoi->T3 != 0)          /* wenn Timer 3 aktiv ...         */
            if (lnkpoi->T3 <= ticks)    /*   wenn Timer 3 abgelaufen ...  */
              {
                clrT3();                /*   ... Timer 3 stoppen und      */
                l2stma(stbl24);         /*       Statetable T3 EXPIRES    */
              }                         /*       ausfuehren               */
            else
              lnkpoi->T3 -= ticks;      /*   sonst herunterzaehlen        */

        }

#ifdef DRSI
    for (flag = FALSE, n = 0; n < L2PNUM; n++)
      if (damaok[n] == 1 && sendok[n] == 1 && tosend[n] == 1)
        {
          DIinc();
          kicktx(n);
          decEI();
          sendok[n] = 0;                /* senden nicht mehr erlaubt!     */
          tosend[n] = 0;
          flag = TRUE;
        }

    if (flag)                           /* auf mind. einem Port gesendet  */
      for (n = 0, lnkpoi = lnktbl; n < linknmbr; ++n, ++lnkpoi)
        if (lnkpoi->T1 != 0)
          lnkpoi->flag &= ~L2FDPOLL;
#else
    if (damaok == 1 && sendok == 1 && tosend == 1)
    {
      DIinc();
      kicktx(0);
      decEI();
      sendok = 0;                       /* senden nicht mehr erlaubt!     */
      tosend = 0;

      for (n = 0, lnkpoi = lnktbl; n < linknmbr; ++n, ++lnkpoi)
        if (lnkpoi->T1 != 0)
          lnkpoi->flag &= ~L2FDPOLL;
    }
#endif
  }

/* Ende von L2A.C */
