/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    L2EXT.H   -   Externals fuer Level 2                                  *
*                  (globale Variable und nicht-int-Funktionen)             *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*                                                                          *
*    modifiziert:   DL8ZAW, versch. Referenzen auf neue Variablen          *
*                   Erlaeuterung dazu: siehe C-Module                      *
*                                                                          *
\**************************************************************************/

/*                                                           Funktionen   */
/**************************************************************************/

extern char       *minmem();                      /* L1...                */
extern char       *maxmem();

extern BOOLEAN     digipt();                      /* L2...                */
extern BOOLEAN     tol3sw();
extern BOOLEAN     srxdNR();
extern BOOLEAN     isnxti();
extern BOOLEAN     splcpy();
extern unsigned    setNR();

#ifndef FIRMWARE
extern BOOLEAN     itolnk();
#endif

#ifdef FIRMWARE
extern MBHEAD     *cpyfb();
#endif

extern BOOLEAN     takfhd();
extern BOOLEAN     takflx();
extern BOOLEAN     getfid();
extern MBHEAD     *makfhd();
extern BOOLEAN     istome();
extern BOOLEAN     cmpcal();
extern BOOLEAN     cmpidl();
extern BOOLEAN     cmpid();
extern BOOLEAN     l1put();
extern unsigned    l1get();
extern LEHEAD     *allocb();
extern LEHEAD     *unlink();
extern LEHEAD     *relink();

extern BOOLEAN     fmlink();                      /* L3... / TF...        */

extern unsigned    nbrprt();                      /* L7... / TF...        */
extern BOOLEAN     isrout();
extern BOOLEAN     iswarm();

/*                                                             Variable   */
/**************************************************************************/

extern char        myid[];                        /* L2...                */
extern char        alias[];

#ifndef FIRMWARE
extern char        istraf[];
#endif

extern unsigned    linknmbr;
extern char        nmblks;
extern char        Ypar;
extern char        Vpar;
extern char        damaok[];
extern char        sendok[];
extern char        tosend[];
extern unsigned    damati[];
extern char        rxfhdr[];
extern char        rxfctl;
extern char        rxfPF;
extern char        rxfV2;
extern char        rxfCR;
extern char        rxfprt;
extern char        rxfflx;
extern char        txfhdr[];
extern char        txfctl;
extern char        txfPF;
extern char        txfV2;
extern char        txfCR;
extern char        txfprt;
extern char        Wpar[];
extern char        Ppar[];
extern char        Palt[];
extern char        UIpar;
extern unsigned    Opar[];
extern unsigned    Npar;
extern unsigned    T2par[];
extern unsigned    T2dama[];
extern unsigned    T3par;
extern unsigned    Rpar;
extern unsigned    T3par;
extern unsigned    Fpar;
extern unsigned    Ipar;
extern unsigned    A1par;
extern unsigned    A2par;
extern unsigned    A3par;
extern unsigned    DApar[];
extern unsigned    nmbfre;
extern LHEAD       freel;
extern LHEAD       rxfl;
extern LHEAD       stfl;
extern LHEAD       trfl;
extern LHEAD       txl2fl[];
extern MBHEAD     *rxfhd[];
extern MBHEAD     *txfhd[];
extern LNKBLK     *lnktbl;
extern LNKBLK     *lnkpoi;

#ifdef DRSI
extern unsigned    txfrms[];
extern unsigned    txifrms[];
extern unsigned    txiacks[];
extern unsigned    rxfrms[];
extern unsigned    rxifrms[];
extern unsigned    rxieff[];
#endif

extern LHEAD       l3rxfl;                        /* L3... / TF...        */
extern unsigned    ininat;
extern unsigned    conctl;

extern unsigned    VCpar;                         /* L7... / TF...        */

#ifdef FIRMWARE
extern LHEAD       monfl;
#endif

#ifdef LOOPBACK
extern BOOLEAN     loopback;
#endif

/* Ende von L2EXT.H */
