/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    L2V.C   -   Level 2, globale Variable                                 *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 25.04.91                                       *
*                   Globale Variable damaok = 1, wenn DAMA-Master erkannt  *
*                                           = 0, wenn kein DAMA-Master     *
*                                                                          *
*                   DL8ZAW, 27.04.91                                       *
*                   Variablen fuer RTT-Messung: A1par, A2par, Bpar, Fpar   *
*                                                                          *
*                   DL8ZAW, 04.05.91                                       *
*                   DAMA-Timer - Startwert: DApar in Sekunden              *
*                                                                          *
*                   DL8ZAW, 18.05.91                                       *
*                   Bpar ist nun A3par!                                    *
*                                                                          *
*                   DB2OS,  28.08.91                                       *
*                   Variable startx gibt es nicht mehr!                    *
*                                                                          *
*                   DB2OS,  17.09.91                                       *
*                   T2dama, neuer @T2-Parameter bei DAMA                   *
*                                                                          *
*                   DG0FT, 05.02.93                                        *
*                   lnktbl ist jetzt Zeiger auf Linktabelle                *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */

/*                                                              Globals   */
/**************************************************************************/

char        myid[L2IDLEN];    /* Call (normal) + SSID (1 Bit linksgesch.) */
#ifndef TFPC
char        alias[L2CALEN];   /* Ident der Station                        */
#endif

#ifndef FIRMWARE
char        istraf[L2PNUM];   /* != 0 -> Frame gesendet                   */
#endif

char        nmblks;           /* Anzahl aktiver Level-2-Links (1..127)    */
char        Ypar;             /* Anzahl moeglicher Links (Y-Befehl)       */
char        Vpar;             /* 0 = Linkaufbau mit Version 1 Protokoll   */
                              /* 1 = Linkaufbau mit Version 2 Protokoll   */
                              /* (V-Befehl)                               */
#ifdef DRSI
char        damaok[L2PNUM];   /* DAMA Betrieb ( 1 = ja, 0 = nein )        */
char        sendok[L2PNUM];   /* DAMA Betrieb ( 1 = senden erlaubt )      */
char        tosend[L2PNUM];   /* DAMA Betrieb ( 1 = was zu senden da)     */
unsigned    damati[L2PNUM];   /* DAMA Timer   ( 1 sec Downcounter)        */
#else
char        damaok;           /* DAMA Betrieb ( 1 = ja, 0 = nein )        */
char        sendok;           /* DAMA Betrieb ( 1 = senden erlaubt )      */
char        tosend;           /* DAMA Betrieb ( 1 = was zu senden da)     */
unsigned    damati;           /* DAMA Timer   ( 1 sec Downcounter)        */
#endif
                              /* empfangenes Frame :                      */
char        rxfhdr[L2AFLEN+1];/*   Header (Ziel/Quell/via-Id's), 0-term.  */
char        rxfctl;           /*   Kontrollbyte ohne P/F-Bit              */
char        rxfPF;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
char        rxfV2;            /*   0 = V1-Frame, 1 = V2-Frame             */
char        rxfCR;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x80 = Command-Frame         */
                              /*             0x00 = Response-Frame        */
char        rxfprt;           /*   0 = HDLC-Frame, 1 = Crosslink-Frame    */
char        rxfflx;           /*   0 = normaler Frame, 1 = FlexNet-Frame  */

                              /* zu sendendes Frame :                     */
char        txfhdr[L2AFLEN+1];/*   Header (Ziel/Quell/via-Id's), 0-term.  */
char        txfctl;           /*   Kontrollbyte ohne P/F-Bit              */
char        txfPF;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
char        txfV2;            /*   0 = V1-Frame, 1 = V2-Frame             */
char        txfCR;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x80 = Command-Frame         */
                              /*             0x00 = Response-Frame        */
char        txfprt;           /*   0 = HDLC-Frame, 1 = Crosslink-Frame    */

unsigned    Fpar;             /* IRTT       10 ms             F-Befehl    */
unsigned    A1par;            /* Alpha1     0..               @-A1-Befehl */
unsigned    A2par;            /* Alpha2     0..               @-A2-Befehl */
unsigned    A3par;            /* Alpha3     1..16             @-A3-Befehl */
unsigned    Ipar;             /* IPOLL      0..256            @-I-Befehl  */
unsigned    Npar;             /* RETRY      0..127            N-Befehl    */

#ifdef DRSI
unsigned    Opar[L2PNUM];     /* MAXFRAME   0..7              O-Befehl    */
unsigned    T2par[L2PNUM];    /* T2         10 ms             @-T2-Befehl */
unsigned    T2dama[L2PNUM];   /* T2 bei DAMA  "               @-T4-Befehl */
unsigned    DApar[L2PNUM];    /* DAMA Timer sec               B-Befehl    */
#else
unsigned    Opar;             /* MAXFRAME   0..7              O-Befehl    */
unsigned    T2par;            /* T2         10 ms             @-T2-Befehl */
unsigned    T2dama;           /* T2 bei DAMA  "               @-T4-Befehl */
unsigned    DApar;            /* DAMA Timer sec               B-Befehl    */
#endif

unsigned    T3par;            /* T3         10 ms             @-T3-Befehl */
unsigned    Rpar;             /* DIGION     0..1              R-Befehl    */
                              /* 1 = Digipeaten ein, 0 = aus              */
unsigned    nmbfre;           /* "number free", Anzahl freier 32-Byte-    */
                              /* Buffer (36 Byte mit Kopf)                */
LHEAD       freel;            /* "free list",                             */
                              /* Listenkopf Freibuffer                    */
LHEAD       rxfl;             /* "rx frame list",                         */
                              /* Listenkopf empfangene Frames             */
#ifndef LOOPBACK
LHEAD       stfl;             /* "sent frame list",                       */
                              /* Listenkopf gesendete Frames              */
#endif
LHEAD       trfl;             /* "trash frame list",                      */
                              /* Listenkopfe Frames fuer den Muelleimer   */
LHEAD       txl2fl[L2PNUM];   /* "tx level 2 frame list",                 */
                              /* Listenkoepfe (je Port einer) zu sendende */
                              /* Frames                                   */
MBHEAD     *rxfhd[L2PNUM];    /* "rx frame head",                         */
                              /* Zeiger (je Port einer) auf das gerade    */
                              /* aktuelle Frame waherend Empfang,         */
                              /* 0 = es wird gerade kein Frame empfangen  */
MBHEAD     *txfhd[L2PNUM];    /* "tx frame head",                         */
                              /* Zeiger (je Port einer) auf das gerade    */
                              /* aktuelle Frame waehrend Sendung,         */
                              /* 0 = es wird gerade kein Frame gesendet   */
LNKBLK     *lnktbl;           /* Zeiger auf "link table", fuer jeden      */
                              /* moeglichen Level-2-Link ein Eintrag      */
LNKBLK     *lnkpoi;           /* "link pointer", globaler Zeiger auf den  */
                              /* gerade aktuellen Linkblock (in lnktbl)   */
#ifdef DRSI
unsigned    txfrms[L2PNUM];   /* Anzahl der gesendeten Frames             */
unsigned    txifrms[L2PNUM];  /* Anzahl der gesendeten I-Frames           */
unsigned    txiacks[L2PNUM];  /* Anzahl der bestaetigten I-Frames         */
unsigned    rxfrms[L2PNUM];   /* Anzahl der empfangenen Frames            */
unsigned    rxifrms[L2PNUM];  /* Anzahl der empfangenen I-Frames          */
unsigned    rxieff[L2PNUM];   /* Anzahl der effektiv empfangenen I-Frames */
#endif

/* Ende von L2V.C */
