/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware.                     *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    TFA.C   -   The Firmware, Teil 1                                      *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 07.05.91                                       *
*                   Signon V 2.2 DAMA                                      *
*                   lx(): DAMA-Timer alle Sekunde runterzaehlen            *
*                         (gehoert eigentlich in L2!)                      *
*                                                                          *
*                   DL8ZAW, 05.06.91                                       *
*                   Signon V 2.2a DAMA/UI+                                 *
*                                                                          *
*                   DL8ZAW, 19.06.91                                       *
*                   Signon V 2.2b DAMA/UI+                                 *
*                   Aenderung gegenueber TF22a:                            *
*                   L2A.C, l2timr(): DISC senden bei Link-Failure          *
*                   L2B.C, clrlnk(): DAMA-Timer ruecksetzen, wenn alle     *
*                                    Links aufgeloest                      *
*                   TFB.C, Dcmd():   DISC senden bei ESC-D waehrend        *
*                                    LINK-SETUP                            *
*                                                                          *
*                   DK6PX, 20.07.91                                        *
*                   Signon V 2.2c DAMA/UI+                                 *
*                   Aenderung gegenueber TF22b:                            *
*                   L2B.C, sdi(): dynamisches MAXFRAME, je nach            *
*                                 Info-Framelaenge                         *
*                   TFL1.MAC:     DWAIT-Funktion nach DL4YBG               *
*                   TFKISS.MAC:   DWAIT-Funktion nach DL4YBG               *
*                                                                          *
*                   DL8ZAW, 25.07.91                                       *
*                   Signon V 2.2d DAMA/UI+                                 *
*                   Aenderung gegenueber TF22c:                            *
*                   L2A.C: Beim Einschalten von DAMA P auf 255 und W auf 0,*
*                          Beim Auschalten wieder auf alte Werte setzen.   *
*                          Fehler beim DAMA-Einschalten behoben            *
*                                                                          *
*                   DB2OS,  22.09.91                                       *
*                   Signon V 2.3b DAMA                                     *
*                                                                          *
*                   DG0FT, 26.10.91                                        *
*                   l2():  Die Zeit wird jetzt im Level 2 aktualisiert.    *
*                                                                          *
*                   DG0FT, 25.03.92                                        *
*                   l2():  selmfl() wird jetzt im L2 gerufen.              *
*                   l2tol7(): txfprt ausgeben                              *
*                   ch0prt: sdui() auf unproto-Port                        *
*                                                                          *
*                   DG0FT, 17.01.93                                        *
*                   fmlink(): Remotekommando //Q fr Disconnect eingebaut, *
*                             wenn kein Terminal aktiv (!ishmod && Upar)   *
*                                                                          *
*                   DG0FT, 13.08.93                                        *
*                   lx(): Extended Hostmode nach DG3DBI eingebaut          *
*                                                                          *
*                   DG0FT, 26.08.93                                        *
*                   fmlink(): //Q jetzt nur bei Upar == 2 wirksam          *
*                                                                          *
*                   DG0FT, 31.08.93                                        *
*                   l2tol7(): Bei L2MBUSYT wird der Port nun vor dem Call  *
*                             ausgegeben, wenn -DR aktiviert.              *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tf.h"          /* Festlegungen/Datenstrukturen fuer TheFirmware */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "tfext.h"       /* globale Variable / nicht int-Funktionen       */

/**************************************************************************\
*                                                                          *
* "main function"                                                          *
*                                                                          *
\**************************************************************************/

mainf()
  {
#ifndef TFPC
    unsigned    cs;
    char       *csp;

    DIinc();
    for (cs = 0, csp = (char *)0; csp < (char *)&p1end; cs += *csp++ & 0xFF) ;
    for (csp = (char *)&p2strt; csp < (char *)&end; cs += *csp++ & 0xFF) ;
#endif
    sl2par();
    l2init();
    l3init();
    lxinit();
#ifndef TFPC
    srand();
    decEI();
    hputs("\032\015\012The Firmware Version 2.3b DAMA (");
    hputud(linknmbr);
    hputs(" Channel)\015\012   Copyright by NORD><LINK, 23-Sep-91\015\012");
    hputs("      Free for non-commercial usage\015\012\015\012");
    hputs("Checksum (0000) = ");
    hputby(cs >> 8);
    hputby(cs);
    hputs("\015\012\012");
    LOOP
      {
        l2();
        l3();
        lx();
      }
#endif
  }

/**************************************************************************\
*                                                                          *
* "level 3"                                                                *
*                                                                          *
\**************************************************************************/

VOID l3()
  {
    dealml(&l3rxfl);
  }

/**************************************************************************\
*                                                                          *
* "level x"                                                                *
*                                                                          *
\**************************************************************************/

VOID lx()
  {
    unsigned    inchar;
    MBHEAD     *mbp;

#ifndef TFPC
    unsigned    n;

    DIinc();
    xonctl();
    decEI();

    CONled(        !ishmod
                && actch != 0
                && lnktbl[actch - 1].state == L2SLKSUP
            ? 0
            : nmblks != 0
          );

    for (n = 0; n < linknmbr; ++n)
      if (chnlml[n].head != &chnlml[n]) break;
    STAled(n != linknmbr);
#endif

    if (!ishmod)
      {
        if (actch != 0) lnkpoi = &lnktbl[actch - 1];

        if (   incnt == 0
#ifndef TFPC
            || !(Zpar & FZFLOW)
#endif
           )
          {

            while (!ishput() && (mbp = statml.head) != &statml)
               {
                unlink(mbp);
                trpmbb(mbp);
                dealmb(mbp);
              }
#ifndef TFPC
            while (!ishput() && hrdmbp != NULL)
              {
                rsphrd(hrdmbp,NO);
                if (    (hrdmbp = hrdmbp->nexthb) == &heardl
                     || ishget()
                   ) hrdmbp = NULL;
              }
#endif
            while (!ishput() && (mbp = smonfl.head) != &smonfl)
              {
                unlink(mbp);
                if (ismonf(mbp) == YES)
                  {
                    hcrlf();
                    frhmon(mbp);
                    hcrlf();
                    if (mbp->mbgc < mbp->mbpc)
                      {
                        hputmb(mbp);
                        hcrlf();
                      }
                  }
                dealmb(mbp);
              }

            if (actch != 0)
              while (    !ishput()
                      &&    (mbp = chnlml[actch-1].head)
                         != &chnlml[actch - 1]
                    )
                {
                  unlink(mbp);
                  if (!mbp->type)
                    hputmb(mbp);
                  else
                    trpmbb(mbp);
                  dealmb(mbp);
                }

          } /* end if (incnt == 0 || !(Zpar & FZFLOW)) */

        if (ishget() == YES && !ishput())
          {
            inchar = hgetc() & 0xFF;
            if (!isctlr || inchar == CONTROLR)
              {
                if (!incnt) inbufp = hinbuf;
                switch (inchar)
                  {

                    case CR :
                      if (Epar == YES)
                        {
                          hputc(inchar);
#ifndef TFPC
                          if (Apar == YES)
#endif
                            hputc(LF);
                        }
                      inbufp = hinbuf;
                      if (incnt != 0 && *inbufp == defESC)
                        {
#ifndef TFPC
                          hrdmbp = NULL;
#endif
                          ++inbufp;
                          --incnt;
                          cmd();
                        }
                      else
                        if (nmbfre > BUFIGNLINE)
                          {
                            (mbp = allocb())->l2fflg = L2CPID;
                            while (incnt--) putchr(*inbufp++,mbp);
                            putchr(CR,mbp);
                            rwndmb(mbp);
                            if (!actch || !lnkpoi->state)
                              {
                                if (myid[0] != ' ')
                                  sdui(ch0via,ch0id,myid,
#ifdef DRSI
                                       ch0prt,
#else
                                       HDLCPORT,
#endif
                                       mbp);
                                else
                                  rspnsc();
                                dealmb(mbp);
                              }
                            else
                              tolink(mbp);
                          }
                        else
                          rsplig();
                      incnt = 0;
                    break;

                    case BS  :
                    case DEL :
                      if (incnt != 0) delich();
                    break;

                    case CONTROLU :
                    case CONTROLX :
                      while (incnt != 0) delich();
                    break;

                    case CONTROLR :
                      if (!isctlr)
                        {
                          if (incnt != 0)
                            while (incnt != 0)
                              {
                                delich();
                                ++isctlr;
                              }
                        }
                      else
                        while (isctlr != 0)
                          {
                            hpinch(*inbufp++);
                            ++incnt;
                            --isctlr;
                          }
                    break;

                    default :
                      if (incnt < HBUFLEN - 1)
                        {
                          hpinch(inchar);
                          *inbufp++ = inchar;
                          ++incnt;
                        }
                      else
                        hputc(BELL);
                    break;

                  } /* end switch (inchar) */

              } /* end if (!isctlr || inchar == CONTROLR) */
            else
              hputc(BELL);

          } /* end if (ishget() == YES && !ishput()) */

      } /* end if (!ishmod) */
    else
      {
        actch = 0;

        while (ishget() == YES)
          {
            inchar = hgetc() & 0xFF;
            switch (hmstat)
              {

                case 0 :
                  hmch = inchar;
                  ++hmstat;
                break;

                case 1 :
                  hmcmd = inchar;
                  ++hmstat;
                break;

                case 2 :
                  hmlen = inchar;
                  ++hmstat;
                  inbufp = hinbuf;
                  incnt = 0;
                break;

                case 3 :
                  *inbufp++ = inchar;
                  ++incnt;
                  if (hmlen != 0)
                    --hmlen;
                  else
                    {
                      hmstat = 0;

                      /* Extended Hostmode nach DG3DBI */
                      /* G-Kommando an Kanal 255       */
                      if (   (actch = hmch)  == 255
                          && hmcmd           == YES
                          && upcase(*hinbuf) == 'G')
                        {
                          xGcmd();
                          return;
                        }

                      if (actch <= linknmbr)
                        {
                          if (actch != 0)
                            lnkpoi = &lnktbl[actch - 1];
                          inbufp = hinbuf;
                          if (hmcmd == YES)
                            cmd();
                          else

                            if (nmbfre > BUFIGNLINE)
                              {
                                (mbp = allocb())->l2fflg = L2CPID;
                                while (incnt--) putchr(*inbufp++,mbp);
                                rwndmb(mbp);
                                if (!actch)
                                  {
#ifndef TFPC
                                    if (hrdmbp != NULL)
                                      {
                                        hrdmbp = NULL;
                                        rspsuc();
                                      }
                                    else
#endif
                                        if (myid[0] != ' ')
                                          {
                                            sdui( ch0via,
                                                  ch0id,
                                                  myid,
#ifdef DRSI
                                                  ch0prt,
#else
                                                  HDLCPORT,
#endif
                                                  mbp
                                                );
                                            rspsuc();
                                          }
                                        else
                                          rspnsc();
                                    dealmb(mbp);
                                  }
                                else
                                  {
                                    if (lnkpoi->state != L2SDSCED)
                                      tolink(mbp);
                                    else
                                      dealmb(mbp);
                                    rspsuc();
                                  }
                              } /* end if (nmbfre > BUFIGNLINE) */
                            else
                              rsplig();
                        } /* end if ((actch = hmch) <= linknmbr) */
                      else
                        {
                          hmputr(HMRFMSG);
                          hputs("INVALID CHANNEL NUMBER");
                          hputc(0);
                        }
                      return;
                    } /* end else from if (hmlen != 0) */
                break;

              } /* end switch (hmstat) */
          } /* end if (ishget() == YES) */
      } /* end else from if (!ishmod) */
  }

/**************************************************************************\
*                                                                          *
* "level 2 to level 3"                                                     *
*                                                                          *
\**************************************************************************/

VOID l2tol3(msg)

char msg;

  {
  }

/**************************************************************************\
*                                                                          *
* "level 2 to level 7"                                                     *
*                                                                          *
\**************************************************************************/

VOID l2tol7(msg,lnk,sel)

char        msg;
LNKBLK     *lnk;
unsigned    sel;

  {
    char       *txt;
    MBHEAD     *mbp;

    switch (msg)
      {
        case L2MCONNT :
          if (Upar && *Utxt && !lnkpoi->state)
            {
              (mbp = allocb())->l2fflg = L2CPID;
              for (txt = Utxt; *txt;) putchr(*txt++,mbp);
              putchr(CR,mbp);
              rwndmb(mbp);
              tolink(mbp);
            }

        case L2MDISCF :
        case L2MBUSYF :
        case L2MFAILW :
        case L2MLRESF :
        case L2MLREST :
        case L2MFRMRF :
        case L2MFRMRT :
          sttoch(msg);
        break;

        case L2MBUSYT :
          mbp = allocb();
#ifdef DRSI
          if (!drmsg)
            putprt(txfprt,mbp);
#endif
          putstr("CONNECT REQUEST fm ",mbp);
#ifdef DRSI
          if (drmsg)
            putprt(txfprt,mbp);
#endif
          putid(txfhdr,mbp);
          putv(NO,txfhdr + L2ILEN,mbp);
#ifdef TIMESTAMP
          stampb(&mbp->btime);
#endif
          mbp->type = msg;
          relink(mbp,statml.tail);
        break;
      }
  }

/**************************************************************************\
*                                                                          *
* "from link"                                                              *
*                                                                          *
\**************************************************************************/

BOOLEAN fmlink(par,fbp)

unsigned    par;
MBHEAD     *fbp;

  {
    unsigned    savmbgc;
    char       *savmbbp;

    if (!ishmod && Upar == 2)
      {
        savmbgc = fbp->mbgc;
        savmbbp = fbp->mbbp;

        if (   fbp->mbpc - savmbgc >= 3
            &&        getchr(fbp)  == '/'
            &&        getchr(fbp)  == '/'
            && upcase(getchr(fbp)) == 'Q')

          fbp->l2link->flag |= L2FDSLE;

        fbp->mbgc = savmbgc;
        fbp->mbbp = savmbbp;
      }

    fbp->type = L2MNIX;
    relink(unlink(fbp),chnlml[fbp->l2link - lnktbl].tail);
    return(TRUE);
  }

/**************************************************************************\
*                                                                          *
* "to link"                                                                *
*                                                                          *
\**************************************************************************/

VOID tolink(mbp)

MBHEAD *mbp;

  {
    relink(mbp,lnkpoi->sendil.tail);
    ++lnkpoi->tosend;
  }

/**************************************************************************\
*                                                                          *
* "command"                                                                *
*                                                                          *
\**************************************************************************/

VOID cmd()
  {
    unsigned c;

    if (nxtnos() == YES)
      {
        c = upcase(*inbufp++ & 0xFF);
        --incnt;
        nxtnos();
        if (c >= '@' && c <= 'Z')
          (*cmdtab[c - '@'])(c);        /* "(c)" fuer rspcic() ...        */
        else
          rspic(c);
      }
    else
      rspsuc();
  }

/**************************************************************************\
*                                                                          *
* "info_avl"        (DG0FT)                                                *
*                                                                          *
\**************************************************************************/

#ifdef TFPC
BOOLEAN info_avl()
  {
    unsigned chan;

    if (statml.head != &statml)
      return TRUE;

    for (chan = 0; chan < linknmbr; chan++)
      if (chnlml[chan].head != &chnlml[chan])
        return TRUE;

    return FALSE;
  }
#endif

/* Ende von TFA.C */
