/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware.                     *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    TFB.C   -   The Firmware, Teil 2, Kommandos                           *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 04.05.91                                       *
*                   extcmd(): @A1 - setzen/anzeigen von A1                 *
*                                   (SRTT-Berechnung bei steigendem RTT)   *
*                             @A2 - setzen/anzeigen von A2                 *
*                                   (SRTT-Berechnung bei fallendem RTT)    *
*                             @B  - setzen/anzeigen von B                  *
*                                   (T1 = A3 x SRTT)                       *
*                             @I  - maximale Laenge der I-Frames fuer      *
*                                   IPOLL (0 = IPOLL abgeschaltet)         *
*                             @U  - freie Buffer anzeigen (war frueher @B) *
*                   Fcmd():   Anstelle FRACK in Sekunden jetzt Setzen von  *
*                             IRTT, bzw. Anzeigen vom aktuellen SRTT-Wert. *
*                                                                          *
*                   DL8ZAW, 18.05.91                                       *
*                   extcmd(): @A3 - setzen/anzeigen von A3par (war: @B)    *
*                             @B  - wieder anzeigen der freien Buffer      *
*                             @M  - Zeichen mit 7 bit im Terminal-Mode     *
*                                   maskieren, 1 = ja, 0 = nein            *
*                                                                          *
*                   DL8ZAW, 31.05.91                                       *
*                   Ypar():   Neue Form der Anzeige: "nmblks / Ypar"       *
*                             also: "aktive Links / max. zulaessige Links" *
*                                                                          *
*                   DL8ZAW, 19.06.91                                       *
*                   Aenderung nach DL1MEN:                                 *
*                   Dcmd(): Waehrend LINK SETUP bei ESC-D ein DISC senden  *
*                                                                          *
*                   DB2OS,  26.08.91                                       *
*                   Fcmd(): Keine Werte <16 zulassen, um Probleme mit der  *
*                           Inkompatibilitt zum ehemaligen FRACK zu       *
*                           beseitigen (z.B. alte Config-Files).           *
*                                                                          *
*                   DB2OS,  26.08.91                                       *
*                   Ycmd(): Anderes Format wegen Inkompatibiltsproblemen  *
*                           bei einigen Terminalprogrammen.                *
*                           Nun: "Ypar (nmblks)"                           *
*                                                                          *
*                   DB2OS,  03.09.91                                       *
*                   Pcmd(): Neues Format:  "Ppar (Palt)"                   *
*                   Wcmd(): Neues Format:  "Wpar (Walt)"                   *
*                           Bei DAMA-Betrieb werden nur Palt und Walt      *
*                           berschrieben und n i c h t Ppar und Wpar!     *
*                                                                          *
*                   DB2OS,  17.09.91                                       *
*                   extcmd(): @T4 Parameter fr T2dama.                    *
*                   extcmd(): @U  Parameter fur UIPOLL ein/aus.            *
*                                                                          *
*                   DB2OS,  22.09.91                                       *
*                   Wcmd(): Wieder altes Format, Walt entfallen.           *
*                           Auch bei DAMA 1mal Slottime/Deadtime warten.   *
*                                                                          *
*                   DG0FT, 02.11.91                                        *
*                   Ccmd(): wenn Station bereits connected, wird eigener   *
*                           SSID automatisch bis max. 15 erhoeht           *
*                   Fcmd(): wenn par < 16 dann par *= 100 / A3par, alle    *
*                           Werte ungleich 0 sind zulaessig, bei discon-   *
*                           necteten Link wird nun IRTT ausgegeben         *
*                   Pcmd(): es wird wieder nur der non-DAMA-Wert ausge-    *
*                           geben, weil die DAMA-Einstellung fest ist      *
*                                                                          *
*                   DG0FT, 16.11.91                                        *
*                   extcmd(): @A und @T verbessert, Bug beseitigt          *
*                                                                          *
*                   DG0FT, 26.03.92                                        *
*                   Ccmd(): ch0prt/liport wird jetzt gesetzt               *
*                   Pcmd(): wenn Par < L2PNUM werden DRSI Parameter ausge- *
*                           geben bzw. weitere Parameter ignoriert         *
*                   extcmd(): neues Kommando '@TA' fuer TXTail-Einstellung *
*                                                                          *
*                   DG0FT, 30.03.92                                        *
*                   extcmd(): '@C' mit Portabfrage                         *
*                                                                          *
*                   DG0FT, 27.06.92                                        *
*                   extLcmd(): Kommando '@L' zur Verwaltung der Linkliste  *
*                   Ccmd(): Port aus Linkliste, wenn nicht angegeben       *
*                                                                          *
*                   DG0FT, 02.07.92                                        *
*                   extcmd(): Kommando '@ST' zur Statusabfrage             *
*                                                                          *
*                   DG0FT, 05.07.92                                        *
*                   Pcmd(): bei DAMA wird T2dama ausgegeben                *
*                   Ccmd(): bei Connect MAXFRAME setzen                    *
*                   Ocmd(): lnkpoi->k wird jetzt beim Connect gesetzt      *
*                           (nicht mehr bei inilbl())                      *
*                                                                          *
*                   DG0FT, 22.07.92                                        *
*                   extcmd(): '@ST' jetzt mit verschiedenen Framezaehler,  *
*                             Loeschen der Zaehler mit '@ST-'              *
*                                                                          *
*                   DG0FT, 22.03.93                                        *
*                   l1par()-Aufruf fuer KISS-Parameter                     *
*                                                                          *
*                   DG0FT, 01.04.93                                        *
*                   extcmd(): '@PO' fuer Zuweisung von Ports zu Kanaelen   *
*                   Ccmd():   conport ist Default-Port                     *
*                                                                          *
*                   DG0FT, 13.08.93                                        *
*                   xGcmd(): Extended Hostmode nach DG3DBI eingebaut       *
*                                                                          *
*                   DG0FT, 26.08.93                                        *
*                   Fcmd(): Umrechnung fuer Sekundenparameter geaendert    *
*                                                                          *
*                   DG0FT, 03.09.93                                        *
*                   extcmd(): '@ST-' loescht jetzt auch die L1ERR-Zaehler  *
*                                                                          *
*                   DG0FT, 24.09.93                                        *
*                   extcmd(): maximaler Wert fuer @TA ist 6000             *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tf.h"          /* Festlegungen/Datenstrukturen fuer TheFirmware */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "tfext.h"       /* globale Variable / nicht int-Funktionen       */

/**************************************************************************\
*                                                                          *
*  Auswertung der '@'-Kommandos                                            *
*                                                                          *
\**************************************************************************/

VOID extcmd()
  {
    unsigned   par;
    unsigned   parnr;
    unsigned  *parptr;
    unsigned   cmdch;
#ifdef DRSI
    char       port;
#endif

    if (incnt != 0)
      {
        cmdch = upcase(*inbufp++ & 0xFF);
        --incnt;
        nxtnos();
        switch (cmdch)
          {
            case 'A' :
              if (incnt-- && '1' <= *inbufp && *inbufp <= '3')
                {
                  parnr = *inbufp++ & 0xFF;
                  if (!nxtnos())
                    switch (parnr)
                      {
                        case '1': rsppar(A1par); break;
                        case '2': rsppar(A2par); break;
                        case '3': rsppar(A3par); break;
                      }
                  else
                    {
                      par = bgetp();
                      switch (parnr)
                        {
                          case '1': A1par = par;
                                    rspsuc();
                                    break;
                          case '2': A2par = par;
                                    rspsuc();
                                    break;
                          case '3': if (par > 1 && par < 17)
                                      {
                                        A3par = par;
                                        rspsuc();
                                      }
                                    else
                                      rspiv(par);
                                    break;
                        }

                    }
                }
              else
                rspiec(cmdch);
            break;

            case 'B' :
              rsppar(nmbfre);
            break;

#ifdef TFPC
            case 'C' :
#ifdef DRSI
              port = bgetprt();
#endif
              if (!incnt)
#ifdef DRSI
                rsppar(Cpar[port]);
#else
                rsppar(Cpar);
#endif
              else
                if ((par = bgetp()) <= 63)
                  {
#ifdef DRSI
                    Cpar[port] = par;
#else
                    Cpar = par;
#endif
                    rspsuc();
                  }
                else
                  rspiv(par);
            break;
#endif

            case 'D' :
#ifdef DRSI
              port = bgetprt();
#endif
              if (!incnt)
#ifdef DRSI
                rsppar(Dpar[port]);
#else
                rsppar(Dpar);
#endif
              else
                if ((par = bgetp()) <= 1)
                  {
#ifdef DRSI
                    l1par(port,DPAR,Dpar[port] = par);
#else
                    Dpar = par;
#endif
#ifndef TFPC
                    if (Dpar == YES)
                      {
                        DIinc();
                        pushtx();
                        decEI();
                      }
#endif
                    rspsuc();
                  }
                else
                  rspiv(par);
            break;

#ifndef TFPC
            case 'F' :
              if (!incnt)
                rsppar(xFpar);
              else
                if ((par = bgetp()) <= 1)
                  {
                    xFpar = par;
                    rspsuc();
                  }
                else
                  rspiv(par);
            break;
#endif

            case 'I' :
              if (!incnt)
                rsppar(Ipar);
              else
                if ((par = bgetp()) >= 0 && par <= 256)
                  {
                    Ipar = par;
                    rspsuc();
                  }
                else
                  rspiv(par);
            break;

#ifndef TFPC
            case 'K' :
              if (ishmod == YES)                  /* im Hostmode ist @K   */
                rspiec('K');                      /* ungueltig            */
              else                                /* ansonsten            */
                {
                  numhrd = 0;                     /* Heardliste loeschen  */
                  inithd(&heardl);
                  kiss();                         /* und KISS einschalten */
                }
            break;
#endif

#ifdef DRSI
            case 'L' :
              extLcmd();                          /* Linkliste verwalten  */
            break;
#endif

            case 'M' :                            /* 7 bit maskieren ?    */
              if (!incnt)
                rsppar(M7par);
              else
                if ((par = bgetp()) <= 1)
                  {
                    M7par = par;
                    rspsuc();
                  }
                else
                  rspiv(par);
            break;

#ifdef DRSI
            case 'P' :
              if (incnt-- && upcase(*inbufp++) == 'O')
                extPOcmd();
              else
                rspiec(cmdch);
            break;
#endif

            case 'S' :
#ifdef DRSI
              if (incnt && upcase(*inbufp) == 'T')
                {
                  inbufp++;
                  incnt--;
                  port = bgetprt();

                  if (incnt && *inbufp == '-')
                    {
                      txfrms[port]  =
                      txifrms[port] =
                      txiacks[port] =
                      rxfrms[port]  =
                      rxifrms[port] =
                      rxieff[port]  = 0;
                      l1info(port,L1CLR);
                      rspsuc();
                    }
                  else
                    {
                      rspini(HMRSMSG);
                      hputuds(port);
                      hputs((char *)l1info(port,L1NAME));
                      hputs(" TX ");
                      hputuds(txfrms[port]);
                      hputuds(txifrms[port]);
                      hputuds(txiacks[port]);
                      hputs("RX ");
                      hputuds(rxfrms[port]);
                      hputuds(rxifrms[port]);
                      hputud(rxieff[port]);
                      if (par = l1info(port,L1ERR))
                        {
                          hputs(" ERR ");
                          hputud(par);
                        }
                      rspex();
                    }
                  return;
                }
#endif
              if (actch != 0)
                {
                  rsppar(lnkpoi->state);
                }
              else
                rspiec(cmdch);
            break;

            case 'T' :
              if (incnt--)
                {
                  switch(parnr = upcase(*inbufp++))
                  {
#ifdef DRSI
                    case '2': parptr = &T2par[bgetprt()];        break;
                    case '3': parptr = &T3par;                   break;
                    case '4': parptr = &T2dama[bgetprt()];       break;
                    case 'A': parptr = &TApar[port = bgetprt()]; break;
#else
                    case '2': parptr = &T2par;  break;
                    case '3': parptr = &T3par;  break;
                    case '4': parptr = &T2dama; break;
#ifdef TFPC
                    case 'A': parptr = &TApar;  break;
#endif
#endif
                    default:
                      rspiec(cmdch);
                      return;
                  }

                  if (nxtnos())
                    {
                      par = bgetp();
#ifdef DRSI
                      if (parnr == 'A')
                        if (par <= 6000)
                          l1par(port,TAPAR,par);
                        else
                          {
                            rspiv(par);
                            break;
                          }
#endif
                      *parptr = par;
                      rspsuc();
                    }
                  else
                    rsppar(*parptr);
                }
              else
                rspiec(cmdch);
            break;

            case 'U' :                            /* UIPOLL ein/aus?      */
              if (!incnt)
                rsppar(UIpar);
              else
                if ((par = bgetp()) <= 1)
                {
                  UIpar = par;
                  rspsuc();
                }
                else
                  rspiv(par);
            break;

            case 'V' :
              if (!incnt)
                rsppar(VCpar);
              else
                if ((par = bgetp()) <= 1)
                  {
                    VCpar = par;
                    rspsuc();
                  }
                else
                  rspiv(par);
            break;

            default :
              rspiec(cmdch);
            break;

          } /* end switch (cmdch) */
      } /* end if (incnt > 0) */
    else
      rspsuc();
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Ccmd()
  {
    char     src[L2IDLEN],dst[L2IDLEN],via[L2VLEN+1];
    LNKBLK  *linkp;
#ifdef DRSI
    unsigned port;
#endif

    if (!incnt)
      rspcs();
    else
      {
#ifdef DRSI
        if ((port = bgetport()) == ERROR)
          {
            if (actch)
              if (lnkpoi->state)
                port = lnkpoi->liport;
              else
                if (lnkpoi->conport < L2PNUM)
                  port = lnkpoi->conport;
          }
        else
          if (!actch && !incnt)
            {
              ch0prt = port;
              rspsuc();
              return;
            }
#endif
        if (bgetid(actch && VCpar,dst) != TRUE || bgetvl(VCpar,via) == ERROR)
          {
            rspics();
            return;
          }
#ifdef DRSI
        if (port == ERROR)
          port = nbrprt(*via ? via : dst,ch0prt);
#endif
        if (!actch)
          {
            cpyid(ch0id,dst);
            cpyidl(ch0via,via);
#ifdef DRSI
            ch0prt = port;
#endif
          }
        else
          {
            if (*myid == ' ')
              {
                rspnsc();
                return;
              }
            cpyid(src,*lnkpoi->srcid ? lnkpoi->srcid : myid);

            for (linkp = lnktbl; linkp < &lnktbl[linknmbr]; ++linkp)
              {
                if (linkp->state)
                  if (   cmpid(linkp->dstid,dst)
#ifdef DRSI
                      && linkp->liport == port
#endif
                     )
                    {
                      if (linkp != lnkpoi && cmpid(linkp->srcid,src))
                        {
                          /* SSID erhoehen, wenn 0 geworden abbrechen */
                          if ((src[L2CALEN] += 2) & 0x1E)
                            {
                              linkp = lnktbl;    /* von vorn beginnen */
                              continue;
                            }
                          rspini(HMRFMSG);
                          hputs("STATION");
                          rspalc();
                          return;
                        }
                    }
                  else
                    if (linkp == lnkpoi)
                      {
                        rspini(HMRFMSG);
                        hputs("CHANNEL");
                        rspalc();
                        return;
                      }
              }
            cpyid(lnkpoi->srcid,src);
            cpyid(lnkpoi->dstid,dst);
            cpyidl(lnkpoi->viaidl,via);
#ifdef DRSI
            lnkpoi->liport = port;
            lnkpoi->k      = Opar[port];
#else
            lnkpoi->liport = HDLCPORT;
#endif
            newlnk();
          } /* end else from if (!actch) */
        rspsuc();
      } /* end else from if (!incnt) */
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Dcmd()
  {
    unsigned lstate;

    if (actch != 0)
      if ((lstate = lnkpoi->state) != L2SDSCED)
        {
          if ((lnkpoi->flag & L2FDSLE) != NO)
            {
              reslnk();
              xdisc();
              lnkpoi->state = L2SDSCRQ;
            }
          else
            {
              if (lstate == L2SLKSUP || lstate == L2SDSCRQ)
                l2tolx(L2MDISCF);
              if (lstate == L2SLKSUP)   /* bei LINK SETUP ein DISC senden */
                xdisc();                /* um Link sicher zu trennen      */
              dsclnk();
            }
          rspsuc();
        }
      else
        {
          inilbl();
          rspini(HMRSMSG);
          hputs("CHANNEL NOT CONNECTED");
          rspex();
        }
    else
      rspic('D');
  }

/**************************************************************************\
*  Fcmd()    Setzen des IRTT bzw. Anzeigen des aktuellen SRTT.             *
*            Frher FRACK in Sekunden, nun IRTT in 10ms Schritten!         *
*            Eingaben < 16 werden umgerechnet auf neue Parameter           *
\**************************************************************************/

VOID Fcmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(!actch ? Fpar : (lnkpoi->state != L2SDSCED ? lnkpoi->SRTT :
                                                          lnkpoi->IRTT));
    else
      if (par = bgetp())                             /* darf nicht 0 sein */
        {
          if (par < 16)                       /* alte Parameter umrechnen */
            par = par * 100 / A3par;   /* wenn par in Sekunden eingegeben */

          if (!actch)
            {
              Fpar = par;
              inilks();
            }
          else
            {
              lnkpoi->IRTT = par;
              if (lnkpoi->state != L2SDSCED) setiSRTT();
            }
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
* action      :  G-Kommando (nur fuer Hostmode).                           *
*                                                                          *
*                Infoframedaten, Linkstatus-Meldungen, Monitorheader       *
*                und Monitorframeinfodaten im Hostmode abholen.            *
*                                                                          *
*                Kanal 0   :  G  - Linkstatus/Monitorheader/Monitorinfo    *
*                             G0 - Monitorheader/Monitorinfos              *
*                             G1 - Linkstatus                              *
*                                                                          *
*                Kanal > 0 :  G  - Linkstati/Infoframedaten                *
*                             G0 - Infoframedaten                          *
*                             G1 - Linkstati                               *
*                                                                          *
*                Im Kanal 0 ist die einzig moegliche Linkstatusmeldung ein *
*                nicht angenommener Connect-Request, in den anderen        *
*                Kanaelen werden keine Connect-Request-Meldungen           *
*                ausgegeben.                                               *
*                                                                          *
*                Es wird eine der Anforderung entsprechende Hostmode-      *
*                antwort ausgegeben.                                       *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  -                                                         *
*                                                                          *
* r/o globals :  ishmod  -  YES = wir sind im Hostmode, sonst Terminalmode *
*                incnt   -  Anzahl Zeichen hinter 'G' im Eingabebuffer     *
*                inbufp  -  Zeiger hinter 'G' in Eingabebuffer             *
*                actch   -  Kanal des Hostmodekommandos                    *
*                                                                          *
* r/w globals :  mifmbp  -  Zeiger auf Framekopf eines I/UI-Frames, von    *
*                           dem der Rumpf (die Daten) noch gemonitort      *
*                           werden muessen                                 *
*                statml  -  Liste der auszugebenden Statusmeldungen fuer   *
*                           Kanal 0 (Hostmode nur Connect-Requests)        *
*                smonfl  -  Liste der zu monitorenden Frames (Vorauswahl)  *
*                chnlml[] - Kanal-Frame/Meldungs-Listen                    *
*                rxf...  -  werden gesetzt, wenn neues Frame zu monitoren  *
*                rxfctl  -  wird gesetzt und abgefragt,  "  "  "  "  "     *
*                                                                          *
* locals      :  s.u.                                                      *
*                                                                          *
* returns     :  -                                                         *
*                                                                          *
\**************************************************************************/

VOID Gcmd()
  {
    unsigned    par;          /* Parameter n bei 'Gn', bei 'G' = MBALL    */
    BOOLEAN     done;         /* Flag "Hostmodeantwort ausgegeben"        */
    MBHEAD     *mbp;          /* Zeiger auf Kopf des aktuellen Frames     */

    if (ishmod == YES)                            /* im Hostmode ?        */
      {

        if (incnt != 0)                           /* ja, Parameter da ?   */
          {
            if ((par = bgetp()) > 1)              /* ja, holen            */
              {
                rspiv(par);                       /* ... falsch angegeben */
                return;
              }
          }
        else                                      /* kein Parameter, alle */
          par = MBALL;                            /* Typen sind gemeint   */

        /* G : par = MBALL   G0 : par = MBINFO   G1 : par = MBSTATUS */

        if (!actch)                               /* Monitorkanal ?       */
          if (    (   mifmbp != NULL              /* ja, noch alter Rest  */
#ifndef TFPC
                   || hrdmbp != NULL              /*     oder Heard sowie */
#endif
                  )
               && par != MBSTATUS                 /*     kein Status ?    */
             )
            if (mifmbp != NULL)                   /*     ja, Rest ...     */
              {
                hmputr(HMRMONI);
                hputc(mifmbp->mbpc - mifmbp->mbgc - 1);
                while (mifmbp->mbgc < mifmbp->mbpc) hputc(getchr(mifmbp));
                dealmb(mifmbp);
                mifmbp = NULL;                    /*     (kein Rest mehr) */
              }
            else
              {
#ifndef TFPC
                if (hrdmbp != NULL)               /*     ja, Heard ...    */
                  {
                    rsphrd(hrdmbp,NO);
                    if ((hrdmbp = hrdmbp->nexthb) == &heardl) hrdmbp = NULL;
                  }
#endif
              }
          else                                         /* ... oder        */
            if (    par != MBINFO                      /* Status/Alles    */
                 && (mbp = selmb(&statml,par)) != NULL /* angefordert     */
               )                                       /* und Status da ? */
              {
                unlink(mbp);                           /* ja, holen       */
                rwndmb(mbp);                           /* und ausgeben    */
                hmputr(HMRSTAT);                       /* (Antworttyp)    */
                hputmb(mbp);                           /* (Daten)         */
#ifdef TIMESTAMP
                if (stamp)
                  {
                    hputs(" - ");
                    hputbt(&mbp->btime);
                  }
#endif
                hputc(0);                              /* (Ende)          */
                dealmb(mbp);                           /* (freigeben)     */
              }
            else
              {
                if (par != MBSTATUS)                   /* ... oder        */
                  {                                    /* Info/Alles      */
                    done = NO;                         /* angefordert und */
                    while (    !done
                            && (mbp = selmb(&smonfl,MBALL)) != NULL
                          )
                      {                                /* da ?            */
                        unlink(mbp);                   /* ja, holen, und  */
                        if (ismonf(mbp) == YES)        /* ggf. monitoren  */
                          {
                            if (    (!(rxfctl & L2CNOIM) || rxfctl == L2CUI)
                                 && (mbp->mbpc - mbp->mbgc > 1)
                               )
                              {                        /* bei I/UI erst   */
                                hmputr(HMRMONIH);      /* Header und beim */
                                mifmbp = mbp;          /* naechsten G die */
                              }                        /* Daten (Rest)    */
                            else
                              hmputr(HMRMONH);         /* sonst nur Head. */
                            frhmon(mbp);               /* Header ausgeben */
                            hputc(0);
                            done = YES;
                          }
                        if (!mifmbp) dealmb(mbp);      /* war kein UI/I   */
                      } /* end while */
                    if (!done) rspsuc();               /* wenn nix getan  */
                  } /* end if (par != MBSTATUS) */
                else                                   /* Status angef.,  */
                  rspsuc();                            /* aber keiner da  */
              }
        else /* from if (!actch) */
          {                                       /* Kanal > 0, passendes */
            done = NO;
            while (!done && (mbp = selmb(&chnlml[actch - 1],par)) != NULL)
              {
                unlink(mbp);                      /* Frame/Meldung holen  */
                if (!mbp->type)
                  {                               /* ist Infoframe, wenn  */
                    if (mbp->mbgc < mbp->mbpc)    /* Daten drin, alle     */
                      {                           /* ausgeben             */
                        hmputr(HMRCONI);
                        hputc(mbp->mbpc - mbp->mbgc - 1);
                        while (mbp->mbgc < mbp->mbpc) hputc(getchr(mbp));
                        done = YES;
                      }
                  }
                else
                  {
                    rwndmb(mbp);                  /* ist Linkstatus-      */
                    hmputr(HMRSTAT);              /* meldung, diese       */
                    hputmb(mbp);                  /* ausgeben             */
#ifdef TIMESTAMP
                    if (stamp)
                      {
                        hputs(" - ");
                        hputbt(&mbp->btime);
                      }
#endif
                    hputc(0);
                    done = YES;
                  }
                dealmb(mbp);                      /* Buffer freigeben     */
              }
            if (!done) rspsuc();                  /* wenn nix getan ...   */
          } /* end else from if (!actch) */
      } /* end if (ishmod == YES) */
    else
      rspic('G');                                 /* T.-Mode: G ungueltig */
  }

/**************************************************************************\
*                                                                          *
* Extended Hostmode Kommando           nach DG3DBI, berarbeitet von DB2OS *
*                                                                          *
* Der Rechner sendet ein 'G'-Kommando an den Kanal 255 des TNC. Handelt es *
* sich um einen TNC ohne Erweiterung, so antwortet dieser dann mit der     *
* Fehlermeldung "INVALID CHANNEL NUMBER".                                  *
*                                                                          *
* Bei dem erweiterten Hostmode wird stattdessen ein Null-terminierter      *
* String zurckgeliefert, der eine Liste von Kanlen enthlt, bei denen    *
* noch Infos in den Buffern abholbereit sind. Dies gilt auch fr den       *
* Monitor-Kanal und Statusdaten. Die Kanalnummern im String sind wegen     *
* der Null-Terminierung um 1 erhht.                                       *
*                                                                          *
* Beispiele fr Antwort des TNC:                                           *
*                                                                          *
*     0xFF 0x01 0x00                - Keine Daten verfgbar.               *
*     0xFF 0x01 0x01 0x00           - Es sind Daten im Monitor-Buffer.     *
*     0xFF 0x01 0x01 0x03 0x04 0x00 - Es sind Daten im Monitor und         *
*                                     in den Kanlen 2 und 3.              *
*                                                                          *
\**************************************************************************/

VOID xGcmd()
  {
    unsigned n;

    hmputr(HMRSMSG);

    if (   mifmbp                       /* Ist was im Monitor-Buffer?     */
#ifndef TFPC
        || hrdmbp
#endif
        || smonfl.head != &smonfl
        || statml.head != &statml)
      hputc(1);

    for (n = 0; n < linknmbr; n++)      /* Haben wir etwas auf den Links? */
      if (chnlml[n].head != &chnlml[n])
        hputc(n+2);

    hputc(0);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Icmd()
  {
    if (!incnt)
      {
        rspini(HMRSMSG);
        hputid(   !actch
                ? myid
                : (lnkpoi->srcid[0] == '\0' ? myid : lnkpoi->srcid)
              );
        rspex();
      }
    else
      if (!actch)
        if (bgetid(VCpar,myid) == TRUE)
          {
            inilks();
            rspsuc();
          }
        else
          rspics();
      else
        if (!lnkpoi->state)
          if (bgetid(VCpar,lnkpoi->srcid) == TRUE)
            {
              if (myid[0] == ' ')
                {
                  cpyid(myid,lnkpoi->srcid);
                  inilks();
                }
              rspsuc();
            }
          else
            rspics();
        else
          rspnwc();
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Lcmd()
  {
    unsigned par;
    unsigned unacked;
    unsigned n;

    if (!ishmod)
      if (!incnt)
        for (n = 0; n < linknmbr + 1; ++n)
          listch(n);
      else
        if ((par = bgetp()) <= linknmbr)
          listch(par);
        else
          rspiv(par);
    else
      {
        hmputr(HMRSMSG);
        if (!actch)
          {
            hputud(mbcnt(&statml,MBALL));
            hputc(' ');
            hputud(mbcnt(&smonfl,MBALL));
          }
        else
          {
            hputud(mbcnt(&chnlml[actch - 1],MBSTATUS));
            hputc(' ');
            hputud(mbcnt(&chnlml[actch - 1],MBINFO));
            hputc(' ');
            unacked = (lnkpoi->VS - lnkpoi->lrxdNR) & 7;
            hputud(lnkpoi->tosend - unacked);
            hputc(' ');
            hputud(unacked);
            hputc(' ');
            hputud(   !lnkpoi->state
                    ? 0
                    : (!lnkpoi->T1 ? lnkpoi->tries : lnkpoi->tries + 1)
                  );
            hputc(' ');
            hputud(lnkpoi->state);
          }
        hputc(0);
      }
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Mcmd()
  {
    unsigned getres;
    unsigned flag;
    unsigned inchr;

    if (!incnt)
      {
        rspini(HMRSMSG);
        if ((Mpar & (MONI | MONU | MONS)) != NO)
          {
            if ((Mpar & MONI) != NO) hputc('I');
            if ((Mpar & MONU) != NO) hputc('U');
            if ((Mpar & MONS) != NO) hputc('S');
            if ((Mpar & MONC) != NO) hputc('C');
          }
        else
          hputc('N');
        if (mftsel != NO)
          {
            hputc(' ');
            hputc(!(mftsel - 1) ? '+' : '-');
            hputvl(NO,mftidl);
          }
        rspex();
      } /* end if (!incnt) */
    else
      {
        flag = 0;
        while (incnt != 0 && flag != 0xFFFF)
          {
            --incnt;
            if ((inchr = upcase(*inbufp++ & 0xFF)) == ' ' || inchr == ',')
              continue;
            if (inchr == 'N')
              {
                if (flag == 0x00FF) continue;
                if (!flag)
                  flag = 0x00FF;
                else
                  flag = 0xFFFF;
              }
            else
              if (inchr == '+' || inchr == '-')
                {
                  if ((getres = bgetvl(NO,mftidl)) != ERROR)
                    mftsel = !getres ? 0 : (inchr == '+' ? 1 : 2);
                }
              else
                if (flag != 0x00FF)
                  switch (inchr)
                    {
                      case 'I' :   flag |= MONI;   break;
                      case 'U' :   flag |= MONU;   break;
                      case 'S' :   flag |= MONS;   break;
                      case 'C' :   flag |= MONC;   break;
                      default  :   flag = 0xFFFF;
                    }
                else
                  flag = 0xFFFF;
          } /* end while */
        if (flag != 0xFFFF)
          {
            if (flag != 0) Mpar = (flag == 0x00FF) ? 0 : flag;
            rspsuc();
          }
        else
          rspipa();
      } /* end else from if (!incnt) */
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Ncmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(!actch ? Npar : lnkpoi->N2);
    else
      if ((par = bgetp()) <= 127)
        {
          if (!actch)
            {
              Npar = par;
              inilks();
            }
          else
            lnkpoi->N2 = par;
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Ocmd()
  {
    unsigned par;
#ifdef DRSI
    char    *parptr;
    unsigned port;

    if ((port = bgetport()) == ERROR)
      parptr = actch && lnkpoi->state ? &lnkpoi->k : &Opar[ch0prt];
    else
      parptr = &Opar[port];
#endif

    if (!incnt)
#ifdef DRSI
      rsppar(*parptr);
#else
      rsppar(!actch ? Opar : lnkpoi->k);
#endif
    else
      if ((par = bgetp()) >= 1 && par <= 7)
        {
#ifdef DRSI
          *parptr = par;
#else
          if (!actch)
            {
              Opar = par;
              inilks();
            }
          else
            lnkpoi->k = par;
#endif
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Pcmd()
  {
    unsigned par;
#ifdef DRSI
    char     port;

    port = bgetprt();
#endif

    if (!incnt)
#ifdef DRSI
      rsppar(Palt[port]);                 /* immer non-DAMA-Wert ausgeben */
#else
      rsppar(Palt);                       /* immer non-DAMA-Wert ausgeben */
#endif
    else
      if ((par = bgetp()) <= 255)
        {
#ifdef DRSI
          if (par < L2PNUM)
            {
              if (!nxtnos())
                {
                  rspini(HMRSMSG);
                  hputuds(par);
                  hputuds(Rpar);
                  hputuds(Palt[par]);
                  hputuds(Wpar[par]);
                  hputuds(!actch ? Fpar : (lnkpoi->state ? lnkpoi->SRTT
                                                         : lnkpoi->IRTT));
                  hputuds(actch && lnkpoi->state ? lnkpoi->k : Opar[par]);
                  hputuds(!actch ? Npar : lnkpoi->N2);
                  hputuds(damaok[par] ? T2dama[par] : T2par[par]);
                  hputuds(T3par);
                  hputuds(Tpar[par]);
                  hputuds(l1info(par,L1BAUD));
                  hputud(Dpar[par]);
                  rspex();
                }
              else
                rspsuc();
              return;
            }
#endif

#ifdef DRSI
          if (damaok[port] == 0)              /* Kein DAMA, beide ndern. */
            l1par(port,PPAR,Ppar[port] = Palt[port] = par);
#else
          if (damaok == 0)
            Ppar = Palt = par;                /* Kein DAMA, beide ndern. */
#endif
          else
#ifdef DRSI
            Palt[port] = par;  /* Es luft DAMA, Ppar nicht berschreiben */
#else
            Palt = par;        /* Es luft DAMA, Ppar nicht berschreiben */
#endif
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Rcmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(Rpar);
    else
      if ((par = bgetp()) <= 1)
        {
          Rpar = par;
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Scmd()
  {
    unsigned par;

    if (!ishmod)
      if (!incnt)
        rsppar(actch);
      else
        if ((par = bgetp()) <= linknmbr)
          {
            lnkpoi = &lnktbl[(actch = par) - 1];
            rspcs();
          }
        else
          rspiv(par);
    else
      rspic('S');
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Tcmd()
  {
    unsigned par;
#ifdef DRSI
    char     port;

    port = bgetprt();
#endif

    if (!incnt)
#ifdef DRSI
      rsppar(Tpar[port]);
#else
      rsppar(Tpar);
#endif
    else
      if ((par = bgetp()) <= 127)
        {
#ifdef DRSI
          l1par(port,TPAR,Tpar[port] = par);
#else
          Tpar = par;
#endif
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Wcmd()
  {
    unsigned par;
#ifdef DRSI
    char     port;

    port = bgetprt();
#endif

    if (!incnt)
#ifdef DRSI
      rsppar(Wpar[port]);
#else
      rsppar(Wpar);
#endif
    else
      if ((par = bgetp()) <= 127)
        {
#ifdef DRSI
          l1par(port,WPAR,Wpar[port] = par);
#else
          Wpar = par;
#endif
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Ycmd()
  {
    unsigned par;

    if (!incnt)
      {
        rspini(HMRSMSG);
        hputud(Ypar);                 /* Maximale Anzahl von Connects     */
        hputs(" (");
        hputud(nmblks);               /* Aktuelle Anzahl von Verbindungen */
        hputc(')');
        rspex();
      }
    else
      if ((par = bgetp()) <= linknmbr)
        {
          Ypar = par;
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

#ifdef DRSI
VOID extLcmd()
  {
    unsigned res, n;
    LNKENTRY *lnkp;

    if (!incnt)
      {
        if (*lnklst->nbrid)
          {
            rspini(HMRSMSG);
            for (lnkp = lnklst; *lnkp->nbrid;)
              {
                hputuds(lnkp->nbrprt);
                hputid(lnkp->nbrid);
                if (*(++lnkp)->nbrid) hputc(' ');
              }
            rspex();
          }
        else
          rspsuc();
      }
    else
      {
        if (*inbufp == '-')
          {
            *lnklst->nbrid = '\0';
            rspsuc();
            return;
          }

        for (lnkp = lnklst, n = 0;
             lnkp->nbrprt = bgetprt(),
             (res = bgetid(VCpar,lnkp->nbrid)) == TRUE && n++ < L2VNUM;
             lnkp++);

        *lnkp->nbrid = '\0';

        switch (res)
          {
            case FALSE: rspsuc(); return;
            case TRUE:  rspipa(); return;
            case ERROR: rspics(); return;
          }
      }
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID extPOcmd()
  {
    char    port, n;
    LNKBLK *lblkp;

    if (!nxtnos())
      {
        rspini(HMRSMSG);
        for (lblkp = lnktbl, n = linknmbr; n--; lblkp++)
          switch (port = lblkp->conport)
            {
              case L2PALL: hputc('*'); break;
              case L2PNO:  hputc('-'); break;

              default:     hputc('0' + port);
            }
        rspex();
      }
    else
      {
        for (lblkp = lnktbl, n = linknmbr; n-- && incnt--; lblkp++)
          switch (port = *inbufp++)
            {
              case '*': lblkp->conport = L2PALL; break;
              case '-': lblkp->conport = L2PNO;  break;
              case ' ': rspsuc(); return;

              default:
                if ((port -= '0') < L2PNUM)
                  lblkp->conport = port;
                else
                  {
                    rspipa();
                    return;
                  }
            }
        rspsuc();
      }
  }
#endif

/* Ende von TFB.C */
