/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware.                     *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    TFC.C   -   The Firmware, Teil 3, Utilities                           *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DF7ZE / 01.01.90 / modul selmfl                        *
*                   - bei voller heardliste ltesten eintrag berschreiben *
*                   DL8ZAW, 27.04.91                                       *
*                   frhmon(): [DAMA] bei DAMA-Master anzeigen              *
*                                                                          *
*                   DL8ZAW, 18.05.91                                       *
*                   hputmb(): M7par=0: 7Bit-Maske verwenden                *
*                                                                          *
*                   DG0FT, 26.03.92                                        *
*                   nbrprt(): zu digipeatendes Frame auf dem Port senden,  *
*                             auf dem es empfangen wurde                   *
*                   hputprt(),                                             *
*                   putprt(): Funktionen zur Ausgabe der Portnummer        *
*                   hputuds(): host put unsigned decimal space             *
*                   bgetprt(): Portnummer aus dem Eingabepuffer lesen      *
*                   frhmon(), rspcs(), sttoch(): Portnummer ausgeben       *
*                                                                          *
*                   DG0FT, 27.06.92                                        *
*                   nbrprt(): Port aus lnklst (defprt, wenn kein Eintrag)  *
*                   bgetport(): gibt ERROR zurck, wenn keine Portangabe   *
*                                                                          *
*                   DG0FT, 23.01.93                                        *
*                   hputmb(): M7par=1: keine Umwandlung von Steuerzeichen  *
*                                                                          *
*                   DG0FT, 22.07.93                                        *
*                   frhmon(): NET/ROM-Monitor entfernt                     *
*                                                                          *
*                   DG0FT, 31.08.93                                        *
*                   frhmon(): nach der Portnummer ein Space                *
*                             ausgeben, wenn -DR aktiviert                 *
*                                                                          *
*                   DG0FT, 15.01.95                                        *
*                   ismonf(): im Hostmode ist MONC immer aktiv             *
*                                                                          *
*                   DG0FT, 16.01.95                                        *
*                   frhmon(): bei SABM und UA ggf. FlexNet-QSO-Nummer      *
*                             ausgeben                                     *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tf.h"          /* Festlegungen/Datenstrukturen fuer TheFirmware */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "tfext.h"       /* globale Variable / nicht int-Funktionen       */

/**************************************************************************\
*                                                                          *
* "initialize links"                                                       *
*                                                                          *
\**************************************************************************/

VOID inilks()
  {
    unsigned    n;
    LNKBLK     *savelp;

    savelp = lnkpoi;
    for (n = 0, lnkpoi = lnktbl; n < linknmbr; ++n, ++lnkpoi)
      if (!lnkpoi->state) inilbl();
    lnkpoi = savelp;
  }

/**************************************************************************\
*                                                                          *
* "response invalid command"                                               *
*                                                                          *
\**************************************************************************/

VOID rspic(c)

unsigned c;

  {
    rspini(HMRFMSG);
    hputs("INVALID COMMAND: ");
    hputcc(c);
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response invalid extended command"                                      *
*                                                                          *
\**************************************************************************/

VOID rspiec(c)

unsigned c;

  {
    rspini(HMRFMSG);
    hputs("INVALID EXTENDED COMMAND: ");
    hputcc(c);
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response invalid value"                                                 *
*                                                                          *
\**************************************************************************/

VOID rspiv(value)

unsigned value;

  {
    rspini(HMRFMSG);
    hputs("INVALID VALUE: ");
    hputud(value);
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response invalid callsign"                                              *
*                                                                          *
\**************************************************************************/

VOID rspics()
  {
    rspini(HMRFMSG);
    hputs("INVALID CALLSIGN");
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response no source callsign"                                            *
*                                                                          *
\**************************************************************************/

VOID rspnsc()
  {
    rspini(HMRFMSG);
    hputs("NO SOURCE CALLSIGN");
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response already connected"                                             *
*                                                                          *
\**************************************************************************/

VOID rspalc()
  {
    hputs(" ALREADY CONNECTED");
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response not while connected"                                           *
*                                                                          *
\**************************************************************************/

VOID rspnwc()
  {
    rspini(HMRFMSG);
    hputs("NOT WHILE CONNECTED");
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response line ignored"                                                  *
*                                                                          *
\**************************************************************************/

VOID rsplig()
  {
    rspini(HMRFMSG);
    hputs("TNC BUSY - LINE IGNORED");
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "response invalid parameter"                                             *
*                                                                          *
\**************************************************************************/

VOID rspipa()
  {
    rspini(HMRFMSG);
    hputs("INVALID PARAMETER");
    rspexb();
  }

/**************************************************************************\
*                                                                          *
* "frame header monitor"                                                   *
*                                                                          *
\**************************************************************************/

VOID frhmon(fbp)

MBHEAD *fbp;

  {
#ifndef TFPC
    char        id[L2IDLEN];
    unsigned    l4opco;
    unsigned    pid;
    unsigned    n;
#endif
    unsigned    qso = 0xFFFF;

#ifdef DRSI
    hputprt(rxfprt);
    if (drmsg)
      hputc(' ');
#endif
    hputs("fm ");
    hputid(rxfhdr + L2IDLEN);
    hputs(" to ");
    hputid(rxfhdr);
    hputv(YES,rxfhdr + L2ILEN);
    hputs(" ctl ");

    if (!(rxfctl & L2CNOIM))
      hputc('I');
    else
      if (!(rxfctl & L2CNOSM))
        switch ((rxfctl >> 2) & 0x3)
          {
            case 0  :   hputs("RR");    break;
            case 1  :   hputs("RNR");   break;
            case 2  :   hputs("REJ");   break;
            default :
              hputc('?');
              hputby(rxfctl | rxfPF);
              hputc('H');
            break;
          }
      else
        switch (rxfctl & 0xFF)
          {
            case L2CUI   :   hputs("UI");     break;
            case L2CDM   :   hputs("DM");     break;
            case L2CDISC :   hputs("DISC");   break;
            case L2CSABM :
            case L2CUA   :
              hputs((rxfctl & 0xFF) == L2CSABM ? "SABM" : "UA");
              if (fbp->mbpc - fbp->mbgc == 2)
                qso = (getchr(fbp) << 8 | getchr(fbp)) & 0x3FFF;
            break;
            case L2CFRMR :
              hputs("FRMR");
              while (fbp->mbgc < fbp->mbpc) hputby(getchr(fbp));
            break;
            default      :
              hputc('?');
              hputby(rxfctl | rxfPF);
              hputc('H');
            break;
          }

    if ((rxfctl & 0x3) != 3)
      {
        hputud((rxfctl >> 5) & 0x7);
        if (!(rxfctl & L2CNOIM)) hputud((rxfctl >> 1) & 0x7);
      }

    if (rxfPF != 0)
      if (!rxfV2)
        hputc('!');
      else
        hputc(rxfCR != 0 ? '+' : '-');
    else
      if (rxfV2 == YES)
        hputc(rxfCR != 0 ? '^' : 'v');

    if (!(rxfctl & L2CNOIM) || rxfctl == L2CUI)
      {
        hputs(" pid ");
        hputby(
#ifndef TFPC
               pid =
#endif
               fbp->mbgc < fbp->mbpc ? getchr(fbp) : 0);
      }
#ifndef TFPC
    else
      pid = 0;
#endif

    if (qso != 0xFFFF)
      {
        hputs(" #");
        hputud(qso);
      }

    if ((rxfhdr[L2ILEN-1] & L2CDAMA) == 0)
      hputs(" [DAMA]");

#ifdef TIMESTAMP
    if (stamp == 2)
      {
        hputs(" - ");
        hputbt(&fbp->btime);
      }
#endif

#ifndef TFPC
    if (!ishmod && (pid & 0xFF) == 0xCF)
      if (rxfctl != L2CUI)
        {
          if (getfid(id,fbp) == TRUE)
            {
              hputs("\015\012(l3 ");
              hputid(id);
              if (getfid(id,fbp) == TRUE)
                {
                  hputc(' ');
                  hputid(id);
                  if (fbp->mbgc < fbp->mbpc)
                    {
                      hputc(' ');
                      hputby(getchr(fbp));
                    }
                  if (fbp->mbpc - fbp->mbgc >= 5)
                    {
                      hputs(" l4");
                      for (n = 0; n < 5; ++n)
                        {
                          hputc(' ');
                          hputby(l4opco = getchr(fbp));
                        }
                      l4opco &= 7;
                      if (l4opco == 1 || l4opco == 2)
                        if (fbp->mbgc < fbp->mbpc)
                          {
                            hputc(' ');
                            hputby(getchr(fbp));
                            if (l4opco == 1)
                              if (getfid(id,fbp) == TRUE)
                                {
                                  hputc(' ');
                                  hputid(id);
                                  if (getfid(id,fbp) == TRUE)
                                    {
                                      hputc(' ');
                                      hputid(id);
                                    }
                                }
                          }
                    }
                }
              hputc(')');
            }
        } /* end if (rxfctl != L2CUI) */
      else
        if (fbp->mbpc - fbp->mbgc >= L2IDLEN)
          {
            hcrlf();
            hputby(getchr(fbp));
            hputc(' ');
            for (n = 0; n < L2CALEN; ++n) hputcc(getchr(fbp));
            while (fbp->mbpc - fbp->mbgc >= 21)
              {
                if (getfid(id,fbp) == TRUE)
                  {
                    hcrlf();
                    hputid(id);
                    hputc(' ');
                    for (n = 0; n < L2CALEN; ++n) hputcc(getchr(fbp));
                    if (getfid(id,fbp) == TRUE)
                      {
                        hputc(' ');
                        hputid(id);
                        hputc(' ');
                        hputby(getchr(fbp));
                        continue;
                      }
                  }
                return;
              } /* end while */
          }
#endif
  }

/**************************************************************************\
*                                                                          *
* "terminal mode response message buffer bell"                             *
*                                                                          *
\**************************************************************************/

VOID trpmbb(mbp)

MBHEAD *mbp;

  {
    rwndmb(mbp);
    hputs("\015\012* ");
    hputmb(mbp);
#ifdef TIMESTAMP
    if (stamp)
      {
        hputs(" - ");
        hputbt(&mbp->btime);
      }
#endif
    hputs(" *\007\015\012");
  }

/**************************************************************************\
*                                                                          *
* "host put message buffer"                                                *
*                                                                          *
\**************************************************************************/

VOID hputmb(mbp)

MBHEAD *mbp;

  {
    unsigned    ch;
    MBHEAD     *copy;
    MBHEAD     *copy2;

    copy = allocb();
    while (mbp->mbgc < mbp->mbpc)
      {
        ch = getchr(mbp) & 0xFF;
#ifndef TFPC
        if (!M7par) ch &= 0x7F;
#endif
        if (!M7par && (ch == BS || ch == DEL))
          {
            if (copy->mbpc != 0)
              {
                --copy->mbpc;
                rwndmb(copy);
                copy2 = allocb();
                while (copy->mbgc < copy->mbpc) putchr(getchr(copy),copy2);
                dealmb(copy);
                copy = copy2;
              }
          }
        else
          putchr(ch,copy);
      }
    rwndmb(copy);
    while (copy->mbgc < copy->mbpc)
      if (    (ch = getchr(copy) & 0xFF) >= ' '
           || ch == BELL
           || ch == TAB
           || ch == LF
           || M7par
         )
        hputc(ch);
      else
        if (ch == CR)
          {
            hputc(ch);
#ifndef TFPC
            if (Apar == YES)
#endif
              hputc(LF);
          }
        else
          {
            hputc('^');
            hputc(ch + '@');
          }
    dealmb(copy);
  }

/**************************************************************************\
*                                                                          *
* "response channel status"                                                *
*                                                                          *
\**************************************************************************/

VOID rspcs()
  {
    rspini(HMRSMSG);
    if (!actch)
      {
#ifdef DRSI
        hputprt(ch0prt);
#endif
        hputid(ch0id);
        hputv(NO,ch0via);
      }
    else
      if (lnkpoi->state != L2SDSCED)
        {
#ifdef DRSI
          hputprt(lnkpoi->liport);
#endif
          hputid(lnkpoi->dstid);
          hputv(NO,lnkpoi->viaidl);
        }
      else
        hputs("CHANNEL NOT CONNECTED");
    rspex();
  }

/**************************************************************************\
*                                                                          *
* "host put via"                                                           *
*                                                                          *
\**************************************************************************/

VOID hputv(dmark,vial)

unsigned    dmark;
char       *vial;

  {
    if (*vial != '\0')
      {
        hputs(" via");
        hputvl(dmark,vial);
      }
  }

/**************************************************************************\
*                                                                          *
* "host put via list"                                                      *
*                                                                          *
\**************************************************************************/

VOID hputvl(dmark,vial)

unsigned    dmark;
char       *vial;

  {
    while (*vial != '\0')
      {
        hputc(' ');
        hputid(vial);
        if (dmark == YES)
          if ((vial[L2IDLEN - 1] & L2CH) != 0)
            if (!vial[L2IDLEN] || !(vial[L2ILEN - 1] & L2CH))
              {
                hputc('*');
                dmark = NO;
              }
        vial += L2IDLEN;
      }
  }

/**************************************************************************\
*                                                                          *
* "host put ID"                                                            *
*                                                                          *
\**************************************************************************/

VOID hputid(id)

char *id;

  {
    unsigned ssid;
    unsigned n;
    unsigned ch;

    for (n = 0; n < L2CALEN; ++n)
      if ((ch = *id++ & 0xFF) > ' ')
        hputc(ch);
      else
        if (ch < ' ')
          {
            hputc('^');
            hputc(ch + '@');
          }
   if ((ssid = (*id >> 1) & 0xF) != 0)
     {
       hputc('-');
       hputud(ssid);
     }
  }

/**************************************************************************\
*                                                                          *
* "host put port"                                                          *
*                                                                          *
\**************************************************************************/

#ifdef DRSI
VOID hputprt(port)

char port;

  {
    if (dxmsg)
      {
        hputc(port + '0');
        hputc(':');
      }
  }
#endif

/**************************************************************************\
*                                                                          *
* "response parameter"                                                     *
*                                                                          *
\**************************************************************************/

VOID rsppar(par)

unsigned par;

  {
    rspini(HMRSMSG);
    hputud(par);
    rspex();
  }

/**************************************************************************\
*                                                                          *
* "host put unsigned decimal"                                              *
*                                                                          *
\**************************************************************************/

VOID hputud(u)

unsigned u;

  {
    BOOLEAN    out;
    unsigned   div;
    unsigned   digit;
    unsigned   n;

    for (out = FALSE, div = 10000, n = 0; n < 5; ++n)
      {
        if ((digit = u/div) != 0 || out == TRUE || div == 1)
          {
            hputc(digit + '0');
            out = TRUE;
          }
        u  %= div;
        div /= 10;
      }
  }

/**************************************************************************\
*                                                                          *
* "host put unsigned decimal space"                                        *
*                                                                          *
\**************************************************************************/

#ifdef DRSI
VOID hputuds(u)

unsigned u;

  {
    hputud(u);
    hputc(' ');
  }
#endif

/**************************************************************************\
*                                                                          *
* "host put buffer time"                                                   *
*                                                                          *
\**************************************************************************/

#ifdef TIMESTAMP
VOID hput2d(c)

char c;

  {
    hputud((c & 0xff) / 10);
    hputud((c & 0xff) % 10);
  }

VOID hputbt(tbp)

TIMEBL *tbp;

  {
    if (eudate)
      {
        hput2d(tbp->day);
        hputc('.');
        hput2d(tbp->month);
        hputc('.');
      }
    else
      {
        hput2d(tbp->month);
        hputc('/');
        hput2d(tbp->day);
        hputc('/');
      }
    hput2d(tbp->year);
    hputc(' ');
    hput2d(tbp->hour);
    hputc(':');
    hput2d(tbp->minute);
    hputc(':');
    hput2d(tbp->second);
  }
#endif

/**************************************************************************\
*                                                                          *
* "host put byte"                                                          *
*                                                                          *
\**************************************************************************/

VOID hputby(byte)

unsigned byte;

  {
    hputni(byte >> 4);
    hputni(byte);
  }

/**************************************************************************\
*                                                                          *
* "host put nibble"                                                        *
*                                                                          *
\**************************************************************************/

VOID hputni(nibble)

unsigned nibble;

  {
    nibble &= 0xF;
    if (nibble > 9) nibble += 7;
    hputc(nibble + '0');
  }

/**************************************************************************\
*                                                                          *
* "response init"                                                          *
*                                                                          *
\**************************************************************************/

VOID rspini(r)

unsigned r;

  {
    if (!ishmod)
      hputs("* ");
    else
      hmputr(r);
  }

/**************************************************************************\
*                                                                          *
* "response success"                                                       *
*                                                                          *
\**************************************************************************/

VOID rspsuc()
  {
    if (ishmod == YES) hmputr(0);
  }

/**************************************************************************\
*                                                                          *
* "host mode put response"                                                 *
*                                                                          *
\**************************************************************************/

VOID hmputr(r)

unsigned r;

  {
    hputc(actch);
    hputc(r);
  }

/**************************************************************************\
*                                                                          *
* "response exit"                                                          *
*                                                                          *
\**************************************************************************/

VOID rspex()
  {
    if (!ishmod)
      hputs(" *\015\012");
    else
      hputc(0);
  }

/**************************************************************************\
*                                                                          *
* "response exit bell"                                                     *
*                                                                          *
\**************************************************************************/

VOID rspexb()
  {
    if (!ishmod)
      hputs(" *\007\015\012");
    else
      hputc(0);
  }

/**************************************************************************\
*                                                                          *
* "host carriage return linefeed"                                          *
*                                                                          *
\**************************************************************************/

VOID hcrlf()
  {
    hputs("\015\012");
  }

/**************************************************************************\
*                                                                          *
* "host put string"                                                        *
*                                                                          *
\**************************************************************************/

VOID hputs(str)

char *str;

  {
    while (*str != '\0') hputc(*str++);
  }

/**************************************************************************\
*                                                                          *
* "host put control character"                                             *
*                                                                          *
\**************************************************************************/

VOID hputcc(c)

unsigned c;

  {
    if (c >= ' ')
      hputc(c);
    else
      {
        hputc('^');
        hputc(c + '@');
      }
  }

/**************************************************************************\
*                                                                          *
* "status to channel"                                                      *
*                                                                          *
\**************************************************************************/

VOID sttoch(msg)

unsigned msg;

  {
    char     *frmrp;
    MBHEAD   *mbp;

    putchr('(',mbp = allocb());
    putudc((lnkpoi - lnktbl) + 1,mbp);
    putstr(") ",mbp);
    putstr(l2msgs[msg - 1],mbp);
    putchr(' ',mbp);
#ifdef DRSI
    putprt(lnkpoi->liport,mbp);
#endif
    putid(lnkpoi->dstid,mbp);
    putv(NO,lnkpoi->viaidl,mbp);
    if (msg == L2MFRMRF || msg == L2MFRMRT)
      {
        putstr(" (",mbp);
        frmrp = lnkpoi->frmr;
        putbyt(*frmrp++,mbp);
        putbyt(*frmrp++,mbp);
        putbyt(*frmrp++,mbp);
        putchr(')',mbp);
      }
#ifdef TIMESTAMP
    stampb(&mbp->btime);
#endif
    mbp->type = msg;
    relink( mbp,
              !ishmod && !Upar
            ? statml.tail
            : chnlml[lnkpoi-lnktbl].tail
          );
  }

/**************************************************************************\
*                                                                          *
* "put via ID's"                                                           *
*                                                                          *
\**************************************************************************/

VOID putv(dmark,vial,mbp)

unsigned    dmark;
char       *vial;
MBHEAD     *mbp;

  {
    if (*vial != '\0')
      {
        putstr(" via",mbp);
        while (*vial != '\0')
          {
            putchr(' ',mbp);
            putid(vial,mbp);
            if (dmark == YES)
              if ((vial[L2IDLEN - 1] & L2CH) != 0)
                if ((!vial[L2IDLEN] || !(vial[L2ILEN - 1] & L2CH)))
                  {
                    putchr('*',mbp);
                    dmark = NO;
                  }
            vial += L2IDLEN;
          }
      }
  }

/**************************************************************************\
*                                                                          *
* "put ID"                                                                 *
*                                                                          *
\**************************************************************************/

VOID putid(id,mbp)

char     *id;
MBHEAD   *mbp;

  {
    unsigned ssid;
    unsigned n;
    unsigned c;

    for (n = 0; n < L2CALEN; ++n)
      if ((c = *id++ & 0xFF) > ' ')
        putchr(c,mbp);
      else
        if (c < ' ')
          {
            putchr('^',mbp);
            putchr(c + '@',mbp);
          }
    if ((ssid = (*id >> 1) & 0xF) != 0)
      {
        putchr('-',mbp);
        putudc(ssid,mbp);
      }
  }

/**************************************************************************\
*                                                                          *
* "put port"                                                               *
*                                                                          *
\**************************************************************************/

#ifdef DRSI
VOID putprt(port,mbp)

char    port;
MBHEAD  *mbp;

  {
    if (dxmsg)
      {
        putchr(port + '0',mbp);
        putchr(':',mbp);
      }
  }
#endif

/**************************************************************************\
*                                                                          *
* "put unsigned decimal"                                                   *
*                                                                          *
\**************************************************************************/

VOID putudc(u,mbp)

unsigned    u;
MBHEAD     *mbp;

  {
    BOOLEAN    out;
    unsigned   div;
    unsigned   digit;
    unsigned   n;

    for (out = FALSE, div = 10000, n = 0; n < 5; ++n)
      {
        if ((digit = u/div) != 0 || out == TRUE || div == 1)
          {
            putchr(digit + '0',mbp);
            out = TRUE;
          }
        u %= div;
        div /= 10;
      }
  }

/**************************************************************************\
*                                                                          *
* "put byte"                                                               *
*                                                                          *
\**************************************************************************/

VOID putbyt(byte,mbp)

unsigned    byte;
MBHEAD     *mbp;

  {
    putnib(byte >> 4,mbp);
    putnib(byte,mbp);
  }

/**************************************************************************\
*                                                                          *
* "put nibble"                                                             *
*                                                                          *
\**************************************************************************/

VOID putnib(nibble,mbp)

unsigned    nibble;
MBHEAD     *mbp;

  {
    nibble &= 0xF;
    if (nibble > 9) nibble += 7;
    putchr(nibble + '0',mbp);
  }

/**************************************************************************\
*                                                                          *
* "put string"                                                             *
*                                                                          *
\**************************************************************************/

VOID putstr(str,mbp)

char     *str;
MBHEAD   *mbp;

  {
    while (*str != '\0') putchr(*str++,mbp);
  }

/**************************************************************************\
*                                                                          *
* "buffer get parameter"                                                   *
*                                                                          *
\**************************************************************************/

unsigned bgetp()
  {
    unsigned par;

    nxtnos();
    par = 0;
    while (incnt != 0 && *inbufp >= '0' && *inbufp <= '9')
      {
        --incnt;
        par *= 10;
        par += *inbufp++ - '0';
      }
    return (par);
  }

/**************************************************************************\
*                                                                          *
* "buffer get port"                                                        *
*                                                                          *
\**************************************************************************/

#ifdef DRSI
unsigned bgetport()
  {
    char port;

    nxtnos();

    if (incnt >= 2 && (port = inbufp[0] - '0') < L2PNUM && inbufp[1] == ':')
      {
        incnt  -= 2;
        inbufp += 2;
        nxtnos();

        return port;
      }

    return ERROR;
  }

char bgetprt()
  {
    unsigned port;

    return  (port = bgetport()) != ERROR
           ? port
           :  (actch && lnkpoi->state
             ? lnkpoi->liport
             : ch0prt);
  }
#endif

/**************************************************************************\
*                                                                          *
* "flagged validate callsign"                                              *
*                                                                          *
\**************************************************************************/

fvalca(check,call)

unsigned    check;
char       *call;

  {
    char       *lnpoi;
    char       *cpoi;
    unsigned    nmbn;
    unsigned    n;
    unsigned    c;

    if (*call == ' ') return(FALSE);
    if (!check) return(TRUE);
    for (nmbn = 0, n = 0, cpoi = call; n < L2CALEN; ++n, ++cpoi)
      {
        if ((c = *cpoi & 0xFF) == ' ') break;
        if (!(c >= 'A' && c <= 'Z'))
          if (c >= '0' && c <= '9')
            {
              ++nmbn;
              lnpoi = cpoi;
            }
          else
            return (ERROR);
      }
    if (    cpoi - call < 4
         || !nmbn
         || nmbn > 2
         || lnpoi == call
         || cpoi - 1 == lnpoi
       )
      return (ERROR);
    else
      return (TRUE);
  }

/**************************************************************************\
*                                                                          *
* "stamp buffer"                                                           *
*                                                                          *
\**************************************************************************/

#ifdef TIMESTAMP
VOID stampb(dtp)

char *dtp;

  {
    unsigned   n;
    char      *stp;

    for (stp = (char *)&time, n = 0; n < 6; ++n) *dtp++ = *stp++;
  }
#endif

/**************************************************************************\
*                                                                          *
* "select monitor frame list"                                              *
*                                                                          *
\**************************************************************************/

VOID selmfl()
  {
    MBHEAD     *fbp;
    HEARDB     *buf;

    while ((fbp = monfl.head) != &monfl)
      {
        unlink(fbp);
#ifdef TIMESTAMP
        stampb(&fbp->btime);
#endif
        if (ismonf(fbp) == YES)
          relink(fbp,smonfl.tail);
        else
          dealmb(fbp);

#ifndef TFPC
        if (heard)
          {
            buf = heardl.head;
            numhrd = ins_list(numhrd,maxhrd,buf);
          } /* end if (heard) */
#endif

      } /* end  while ((fbp = monfl.head) != &monfl) */
  }

/**************************************************************************\
*                                                                          *
* "insert into heard - list"                                               *
*  return new number of entries                                            *
*                                                                          *
\**************************************************************************/

#ifndef TFPC
ins_list(num,max,buf)
unsigned    num;
unsigned    max;
HEARDB     *buf;

  {
    HEARDB     *hbp;
    HEARDB     *nhbp;
    HEARDB     *xbp;
    char       *id1;
    char       *id2;
    unsigned    n;
    unsigned    m;
    unsigned    count;
    BOOLEAN     new;

    rxfhdr[L2ILEN - 1] &= 0x1E;
    new = FALSE;
    count = num;
    if (!count) new = YES;
    for ( hbp = buf, n = 0;
          n < count;
          ++n, hbp = hbp->nexthb
        )
      {
        for ( id1 = hbp->hid, id2 = rxfhdr + L2IDLEN, m = 0;
              m < L2IDLEN;
              ++m, ++id1, ++id2
            ) if (*id1 != *id2) break;
        if (m == L2IDLEN)
          {
            stampb(&hbp->hlast);
            if (!(rxfctl & L2CNOIM))
              ++hbp->hIno;
            else
              if (!(rxfctl & L2CNOSM))
                switch ((rxfctl >> 2) & 0x3)
                  {
                    case 0 :  ++hbp->hRRno;   break;
                    case 1 :  ++hbp->hRNRno;  break;
                    case 2 :  ++hbp->hREJno;  break;
                  }
            break;
          }
        if (*id1 > *id2)
          {
            new = YES;
            break;
          }
      } /* end 1. for ... */
    if (new || n == count)
       {
       if ((new || n == count) && count < max && nmbfre > BUFHEARD)
          new = YES;
       else
          new = FALSE;
       if (!new)
          {
          for (xbp = buf, nhbp = buf, n = 0;
               n < count;
               ++n, xbp = xbp->nexthb)
             {
             for (id1 = (char *)&xbp->hlast, id2 = (char *)&nhbp->hlast, m = 6;
                  m > 0;
                  --m)
                {
                if (id1[m-1] > id2[m-1]) break;
                if (id1[m-1] < id2[m-1])
                   {
                   nhbp = xbp;
                   break;
                   }
                }
             }
          unlink (nhbp);
          }
       if (new)
          stampb(&(nhbp = allocb())->hfirst);
       else
          stampb(&nhbp->hfirst);
       stampb(&nhbp->hlast);
       cpyid(nhbp->hid,rxfhdr + L2IDLEN);
       nhbp->hIno   =
       nhbp->hRRno  =
       nhbp->hREJno =
       nhbp->hRNRno = 0;
       relink(nhbp,hbp->prevhb);
       if (new) ++count;
       }
    return(count);
  }
#endif

/**************************************************************************\
*                                                                          *
* "is monitor frame"                                                       *
*                                                                          *
\**************************************************************************/

BOOLEAN ismonf(fbp)

MBHEAD *fbp;

  {
    if (ishmod || !actch || !lnkpoi->state || (Mpar & MONC) != NO)
      {
        takfhd(fbp);
        if (    !(rxfctl & L2CNOIM) && (Mpar & MONI) != 0
             || (rxfctl & 3) == 1 && (Mpar & MONS) != 0
             || ((rxfctl & 3) == 3 && rxfctl != L2CUI) && (Mpar & MONS) != 0
             || rxfctl == L2CUI && (Mpar & MONU) != 0
           )
          {
            if (mftsel != 0)
              if (    invial(mftidl,rxfhdr + L2IDLEN) == YES
                   || invial(mftidl,rxfhdr) == YES
                 )
                {
                  if (mftsel == 2) return (NO);
                }
              else
                {
                 if (mftsel == 1) return (NO);
                }
            return (YES);
          }
      }
    return (NO);
  }

/**************************************************************************\
*                                                                          *
* "message buffer count"                                                   *
*                                                                          *
\**************************************************************************/

unsigned mbcnt(msgl,select)

LHEAD      *msgl;
unsigned    select;

  {
    unsigned    count;
    MBHEAD     *mb;

    for (count = 0, mb = msgl->head; mb != msgl; mb = mb->nextmh)
      if (    select == MBALL
           || select == MBINFO    &&  mb->type == MBINFO
           || select == MBSTATUS  &&  mb->type != MBINFO
         ) ++count;
     return (count);
   }

/**************************************************************************\
*                                                                          *
* "select message buffer"                                                  *
*                                                                          *
\**************************************************************************/

MBHEAD *selmb(msgl,select)

LHEAD      *msgl;
unsigned    select;

  {
    MBHEAD *mb;

    for (mb = msgl->head; mb != msgl; mb = mb->nextmh)
      if (    select == MBALL
           || select == MBINFO    &&  mb->type == MBINFO
           || select == MBSTATUS  &&  mb->type != MBINFO
         )
        return(mb);
    return (NULL);
  }

/**************************************************************************\
*                                                                          *
* "in via list"                                                            *
*                                                                          *
\**************************************************************************/

BOOLEAN invial(vial,id)

char *vial;
char *id;

  {
    while (*vial != '\0')
      if (cmpid(vial,id) == TRUE)
        return (TRUE);
      else
        vial += L2IDLEN;
    return (FALSE);
  }

/**************************************************************************\
*                                                                          *
* "next no space"                                                          *
*                                                                          *
\**************************************************************************/

BOOLEAN nxtnos()
  {
    while (incnt != 0 && *inbufp == ' ')
      {
        ++inbufp;
        --incnt;
      }
    return (incnt != 0);
  }

/**************************************************************************\
*                                                                          *
* "neighbor port"                                                          *
*                                                                          *
\**************************************************************************/

#ifdef DRSI
unsigned nbrprt(id,defprt)

char *id;
char defprt;

  {
    LNKENTRY *lnkp;

    for (lnkp = lnklst; *lnkp->nbrid; lnkp++)   /* lnklst durchsuchen */
      if (cmpid (lnkp->nbrid, id))              /* Eintrag gefunden?  */
        return lnkp->nbrprt;                    /* dann Port zurck   */

    return defprt;                              /* sonst Default-Port */
  }
#endif

/**************************************************************************\
*                                                                          *
* "is warm reset"                                                          *
*                                                                          *
\**************************************************************************/

#ifndef TFPC
BOOLEAN iswarm()
  {
    return (magicn == MAGIC);
  }

/**************************************************************************\
*                                                                          *
* "timer"                                                                  *
*                                                                          *
\**************************************************************************/

VOID timer()
  {
    ++ticks;
  }
#endif

/* Ende von TFC.C */
