/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware.                     *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    TFD.C   -   The Firmware, Teil 4                                      *
*                                                                          *
*                Dieser Teil ist eine Zusammenfassung der                  *
*                zeitunkritischsten Funktionen und kann somit mit der      *
*                groessten Platzersparnis optimiert werden.                *
*                                                                          *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   DL8ZAW, 04.05.91                                       *
*                   sl2par(): Initialisieren von ...                       *
*                             Fpar:  IRTT in 10 ms - Schritten             *
*                             A1par: A1 fuer SRTT-Berechnung               *
*                                    (steigendes RTT)                      *
*                             A2par: A2 fuer SRTT-Berechnung               *
*                                    (fallendes RTT)                       *
*                             Bpar:  B fuer Setzen von T1 (T1 = B x SRTT)  *
*                             Ipar:  max. Framelaenge fuer I-Poll          *
*                             DApar: DAMA-Timer in Sekunden                *
*                                    (nach Ablauf wird DAMA-Modus          *
*                                     abgeschaltet)                        *
*                             ... mit Werten aus Eprom                     *
*                   Bcmd():   Setzen/anzeigen des DAMA-Timers (s. DApar)   *
*                                                                          *
*                   DL8ZAW, 18.05.91                                       *
*                   sl2par(): Bpar durch A3par erstezt. (B = A3)           *
*                             M7par - Maskieren mit 7 bit (Terminalmodus)  *
*                                                                          *
*                   DL8ZAW, 05.06.91                                       *
*                   Bcmd(): ohne Parameter Anzeige in der Form:            *
*                           "aktueller Wert / Anfangswert" vom DAMA-Timer  *
*                                                                          *
*                   DL8ZAW, 10.06.91                                       *
*                   Bcmd(): beim Setzen von DApar gleichzeitig damati      *
*                           auf Wert von DApar setzen.                     *
*                                                                          *
*                   DL8ZAW, 25.07.91                                       *
*                   sl2par(): Initialisieren von Walt und Palt:            *
*                             Werte fuer Slottime und P-Persistance vor    *
*                             dem automatischen Umschalten in den DAMA-    *
*                             Modus                                        *
*                                                                          *
*                   DB2OS,  30.08.91                                       *
*                   Bcmd(): ohne Parameter jetzt Anzeige in der Form:      *
*                           "Anfangswert (aktueller Wert)", wie Ycmd()     *
*                                                                          *
*                   DB2OS,  17.09.91                                       *
*                   T2dama: Neue Parameter fr @T2 bei DAMA.               *
*                   UIpar und defUIp fr UI+.                              *
*                                                                          *
*                   DB2OS,  22.09.91                                       *
*                   Walt gestrichen, Slottime/Deadtime auch bei DAMA.      *
*                                                                          *
*                   DG0FT, 29.11.91                                        *
*                   Ucmd(): Utcnt entfernt, Utxt jetzt mit '\0' beendet,   *
*                           Upar standartmig eingeschaltet               *
*                                                                          *
*                   DG0FT, 26.03.92                                        *
*                   lxinit(): ch0prt initialsieren                         *
*                   listch(): Port ausgeben                                *
*                   Qcmd():   nur Rcksetzen in Terminal-Mode              *
*                                                                          *
*                   DG0FT, 17.01.93                                        *
*                   delich(): Wenn Epar=0 wurde beim Lschen von ESC am    *
*                             Zeilenanfang 2 mal BS ausgegeben (behoben)   *
*                                                                          *
*                   DG0FT, 26.08.93                                        *
*                   Ucmd(): Eingabe von U = 2 moeglich (Default)           *
*                                                                          *
*                   DG0FT, 15.01.95                                        *
*                   Kcmd(): Fehlermeldung, wenn !stampok                   *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tf.h"          /* Festlegungen/Datenstrukturen fuer TheFirmware */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "tfext.h"       /* globale Variable / nicht int-Funktionen       */

/**************************************************************************\
*                                                                          *
* "set level 2 parameter"                                                  *
*                                                                          *
\**************************************************************************/

VOID sl2par()
  {
    unsigned n;

#ifndef TFPC
    if (!iswarm())
#endif
      {
        cpyid(myid,defIp);
#ifndef TFPC
        for (n = 0; n < L2CALEN; ++n) alias[n] = defID[n];
#endif
#ifdef DRSI
        for (n = 0; n < L2PNUM; ++n)
          {
            Opar[n]  = defOp;
            Ppar[n]  =
            Palt[n]  = defPp;
            Tpar[n]  = defTp;
            Wpar[n]  = defWp;
            DApar[n] = defDAp;
            T2par[n] = defT2p;
            T2dama[n]= defT2d;
          }
#else
        Opar  = defOp;
        Ppar  =
        Palt  = defPp;
        Tpar  = defTp;
        Wpar  = defWp;
        DApar = defDAp;
        T2par = defT2p;
        T2dama= defT2d;
#endif
        Ypar  = defYp;
        Npar  = defNp;
        Vpar  = defVp;
        T3par = defT3p;
        Rpar  = defRp;
        Fpar  = defFp;
        A1par = defA1p;
        A2par = defA2p;
        A3par = defA3p;
        Ipar  = defIPp;
        M7par = defM7p;
        UIpar = defUIp;
      }
  }

/**************************************************************************\
*                                                                          *
* "level 3 initialize"                                                     *
*                                                                          *
\**************************************************************************/

VOID l3init()
  {
    inithd(&l3rxfl);
  }

/**************************************************************************\
*                                                                          *
* "level x initialize"                                                     *
*                                                                          *
\**************************************************************************/

VOID lxinit()
  {
    unsigned n;

    inithd(&statml);
    inithd(&smonfl);
    for (n = 0; n < linknmbr; ++n) inithd(&chnlml[n]);
    sec100      =
    incnt       =
    isctlr      = (unsigned) (
#ifndef TFPC
    hrdmbp      = (HEARDB *) (
#endif
    mifmbp      = (MBHEAD *) (
    ishmod      =
    hmstat      =
    actch       =
    ticks       =
    oldtic      = NULL )
#ifndef TFPC
                  )
#endif
                  );
#ifndef TFPC
    if (!iswarm())
#endif
      {
#ifdef TFPC
#ifdef DRSI
        for (n = 0; n < L2PNUM; ++n)
          {
            Cpar[n]  = defCp;
            Dpar[n]  = defDp;
            TApar[n] = defTAp;
            Xpar[n]  = defXp;
          }
#else
        Cpar        = defCp;
        Dpar        = defDp;
        TApar       = defTAp;
        Xpar        = defXp;
#endif
#else
        Apar        = defAp;
        Dpar        = defDp;
        xFpar       = defxFp;
        Xpar        = defXp;
        Zpar        = defZp;
#endif
        Epar        = defEp;
        Mpar        = defMp;
        VCpar       = defVCp;
#ifndef TFPC
        numhrd      =
#endif
#ifdef TIMESTAMP
        eudate      =
        time.second =
        time.minute =
        time.hour   =
        time.day    =
        time.month  =
        time.year   =
#endif
        mftsel      =
        ch0via[0]   =
        mftidl[0]   =
        Utxt[0]     = NULL;
        Upar        = 2;
#ifdef DRSI
        ch0prt      = HDLCPORT;
#endif
        cpyid(ch0id,cqid);
#ifndef TFPC
        magicn      = MAGIC;
#endif
#ifdef TIMESTAMP
        stamp       = defxSp;
#endif
#ifndef TFPC
        heard       = defHp;
        maxhrd      = defHmp;
        inithd(&heardl);
#endif
      }
  }

/**************************************************************************\
*                                                                          *
* "host put input character"                                               *
*                                                                          *
\**************************************************************************/

VOID hpinch(ch)

unsigned ch;

  {
    if (Epar == YES)
      if (!incnt && ch == defESC)
        hputs("* ");
      else
        if (ch >= ' ' || ch == BELL)
          hputc(ch);
        else
          {
            hputc('^');
            hputc(ch + '@');
          }
  }

/**************************************************************************\
*                                                                          *
* "delete input character"                                                 *
*                                                                          *
\**************************************************************************/

VOID delich()
  {
    unsigned ch;

    --incnt;
    ch = *--inbufp & 0xFF;

    if (Epar == YES)
      if (ch != BELL)
        {
          hpbsb();
          if (ch < ' ') hpbsb();
        }
      else
        hputc(ch);
  }

/**************************************************************************\
*                                                                          *
* "host put backspace space backspace"                                     *
*                                                                          *
\**************************************************************************/

VOID hpbsb()
  {
    hputs("\010 \010");
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

#ifndef TFPC
VOID Acmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(Apar);
    else
      if ((par = bgetp()) <= 1)
        {
          Apar = par;
          rspsuc();
        }
      else
        rspiv(par);
  }
#endif

/**************************************************************************\
*                                                                          *
* Bcmd:  DAMA-Timer setzen/anzeigen (in Sekunden)                          *
*                                                                          *
* Nach Ablauf des DAMA-Timers wird der DAMA-Modus wieder ausgeschaltet,    *
* um Deadlocks bei schlechten Verbindungen zum DAMA-Master oder bei        *
* Absturz des DAMA-Masters zu vermeiden.                                   *
*                                                                          *
\**************************************************************************/

VOID Bcmd()
  {
    unsigned par;
#ifdef DRSI
    char     port;

    port = bgetprt();
#endif

    if (!incnt)
      {
        rspini(HMRSMSG);
#ifdef DRSI
        hputud(DApar[port]);
        hputs(" (");
        hputud(damati[port]);
#else
        hputud(DApar);
        hputs(" (");
        hputud(damati);
#endif
        hputc(')');
        rspex();
      }
    else
      if ((par = bgetp()) <= 600)
        {
#ifdef DRSI
          DApar[port] = par;
          damati[port] = par;
#else
          DApar = par;
          damati = par;
#endif
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Ecmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(Epar);
    else
      if ((par = bgetp()) <= 1)
        {
          Epar = par;
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

#ifndef TFPC
VOID Hcmd()
  {
    unsigned par;

    if (!incnt)
      {
        rspini(HMRSMSG);
        hrdmbp = (numhrd && !actch) ? heardl.head : NULL;
        hputud(heard);
        hputs(" - heard ");
        hputud(numhrd);
        hputs(" (max ");
        hputud(maxhrd);
        hputc(')');
        rspex();
      }
    else
      {
        switch(par = bgetp())
          {
            case 0  :  heard = 0;     break;
            case 1  :  heard = 1;     break;
            case 2  :  while (heardl.head != &heardl)
                         dealoc(unlink(heardl.head));
                       numhrd = (unsigned)(
                       hrdmbp = NULL);
                       break;
            default :  maxhrd = par;  break;
          }
        rspsuc();
      }
  }
#endif

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Jcmd()
  {
    unsigned par;

    if (incnt >= 4)
      if (upcase(*inbufp++) == 'H')
        if (upcase(*inbufp++) == 'O')
          if (upcase(*inbufp++) == 'S')
            if (upcase(*inbufp++) == 'T')
              {
                incnt -= 4;
                if (!nxtnos())
                  rsppar(ishmod);
                else
                  if ((par = bgetp()) <= 1)
                    {
                      rspsuc();
                      ishmod = par;
                    }
                  else
                    rspiv(par);
                return;
              }
    rspic('J');
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

#ifdef TIMESTAMP
VOID bgetti(p1,p2,p3)                                /* "buffer get time" */

char *p1;
char *p2;
char *p3;

  {
    *p1 = bgetp();
    --incnt;
    ++inbufp;
    *p2 = bgetp();
    --incnt;
    ++inbufp;
    *p3 = bgetp();
  }

VOID Kcmd()
  {
    unsigned   par;

#ifdef TFPC
    if (!stampok)
      {
        rspic('K');
        return;
      }
#endif

    if (!incnt)
      {
        rspini(HMRSMSG);
        hputud(stamp);
        hputc(' ');
        hputbt(&time);
        rspex();
      }
    else
      {
        par = bgetp();
        if (!incnt)
          {
            if (par <= 2)
              {
                stamp = par;
                rspsuc();
              }
            else
              rspiv(par);
          }
        else
          {
            par = *inbufp & 0xFF;
            incnt += 2;
            inbufp -= 2;
            switch (par)
              {
                case '.' :  eudate = YES;
                            bgetti(&time.day,&time.month,&time.year);
                            break;
                case '/' :  eudate = NO;
                            bgetti(&time.month,&time.day,&time.year);
                            break;
                case ':' :  bgetti(&time.hour,&time.minute,&time.second);
                            break;
              }
            rspsuc();
          }
      }
  }
#endif

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

#if !defined(TFPC) || defined(DRSI)
VOID Qcmd()
  {
    if (incnt >= 3)
      if (upcase(*inbufp++) == 'R')
        if (upcase(*inbufp++) == 'E')
          if (upcase(*inbufp++) == 'S')
            {
#ifndef DRSI
              magicn = 0;
              reset();
#else
              ishmod = incnt = 0;
              return;
#endif
            }
    rspic('Q');
  }
#endif

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Ucmd()
  {
    char       *txt;
    unsigned    par;
    unsigned    ch;

    if (!incnt)
      {
        rspini(HMRSMSG);
        hputud(Upar);
        if (*Utxt)
          {
            hputc(' ');
            for (txt = Utxt; *txt;)
              hputcc(*txt++);
          }
        rspex();
      }
    else
      if ((ch = *inbufp & 0xFF) >= '0' && ch <= '9')
        if ((par = bgetp()) <= 2)
          {
            nxtnos();
            if (incnt <= UTXTLEN)
              {
                Upar = par;
                if (incnt)
                {
                  for (txt = Utxt; incnt--;)
                      *txt++ = *inbufp++;
                  *txt = '\0';
                }
                rspsuc();
              }
            else
              {
                rspini(HMRFMSG);
                hputs("MESSAGE TOO LONG");
                rspexb();
              }
          }
        else
          rspiv(par);
      else
        rspipa();
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Vcmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(!actch ? Vpar + 1 : lnkpoi->V2link + 1);
    else
      if (!actch || !lnkpoi->state)
        if ((par = bgetp()) >= 1 && par <= 2)
          {
            if (!actch)
              {
                Vpar = par - 1;
                inilks();
              }
            else
              lnkpoi->V2link = par - 1;
            rspsuc();
          }
        else
          rspiv(par);
      else
        rspnwc();
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

VOID Xcmd()
  {
    unsigned par;
#ifdef DRSI
    char     port;

    port = bgetprt();
#endif

    if (!incnt)
#ifdef DRSI
      rsppar(Xpar[port]);
#else
      rsppar(Xpar);
#endif
    else
      if ((par = bgetp()) <= 1)
        {
#ifdef DRSI
          Xpar[port] = par;
#else
          Xpar = par;
#endif
          rspsuc();
        }
      else
        rspiv(par);
  }

/**************************************************************************\
*                                                                          *
*                                                                          *
*                                                                          *
\**************************************************************************/

#ifndef TFPC
VOID Zcmd()
  {
    unsigned par;

    if (!incnt)
      rsppar(Zpar);
    else
      if ((par = bgetp()) <= (FZFLOW | FZXONOFF))
        {
          Zpar = par;
          rspsuc();
        }
      else
        rspiv(par);
  }
#endif

/**************************************************************************\
*                                                                          *
* "list channel"                                                           *
*                                                                          *
\**************************************************************************/

VOID listch(chnl)

unsigned chnl;

  {
    unsigned    lstate;
    unsigned    mbnmbr;
    unsigned    unacked;
    LNKBLK     *linkp;

    if (chnl != 0)
      {
        linkp = &lnktbl[chnl - 1];
        lstate = linkp->state;
      }
    hputc(chnl == actch ? '+' : ' ');
    hputc('(');
    hputud(chnl);
    hputs(") ");
    if (!chnl)
      {
#ifdef DRSI
        hputprt(ch0prt);
#endif
        hputid(ch0id);
        hputv(NO,ch0via);
      }
    else
      if (lstate != L2SDSCED)
        {
#ifdef DRSI
          hputprt(linkp->liport);
#endif
          hputid(linkp->dstid);
          hputv(NO,linkp->viaidl);
        }
    if (    (mbnmbr = mbcnt(!chnl ? &smonfl : &chnlml[chnl - 1],MBALL)) != 0
         || (chnl != 0 && lstate != L2SDSCED)
       )
      {
        hcrlf();
        hputs("      receive ");
        hputud(mbnmbr);
      }
    if (chnl != 0 && lstate != L2SDSCED)
      {
        unacked = (linkp->VS - linkp->lrxdNR) & 0x7;
        hputs("   send ");
        hputud(linkp->tosend - unacked);
        hputs("   unacked ");
        hputud(unacked);
        if (    unacked != 0
             || lstate < L2SIXFER
             || linkp->T1 != 0
           )
          {
            hputs("   retries ");
            hputud(linkp->tries);
          }
      }
    hcrlf();
  }

/**************************************************************************\
*                                                                          *
* "buffer get via list"                                                    *
*                                                                          *
\**************************************************************************/

bgetvl(check,vial)

unsigned    check;
char       *vial;

  {
    char        viabuf[L2VLEN + 1];
    char       *viabp;
    unsigned    n;
    unsigned    getres;

    skpvia();
    for (n = 0, viabp = viabuf; n < L2VNUM; ++n, viabp += L2IDLEN)
      if ((getres = bgetid(check,viabp)) == ERROR)
        return (ERROR);
      else
        if (!getres) break;
    *viabp = '\0';
    while (incnt != 0)
      if (*inbufp != ' ')
        return (ERROR);
      else
        {
          ++inbufp;
          --incnt;
        }
    cpyidl(vial,viabuf);
    return (*vial != '\0');
  }

/**************************************************************************\
*                                                                          *
* "skip via"                                                               *
*                                                                          *
\**************************************************************************/

VOID skpvia()
  {
    char        id[L2IDLEN];
    char       *bpsav;
    char       *idp;
    unsigned    cntsav;
    unsigned    n;
    unsigned    chr;

    bpsav = inbufp;
    cntsav = incnt;
    if (bgetid(NO,id) == TRUE)
      {
        idp = id;
        if (*idp++ == 'V')
          {
            for (n = 0; n < L2CALEN - 1; ++n)
              if ((chr = *idp++ & 0xFF) != ' ')
                if (!((!n && chr == 'I') || (n == 1 && chr == 'A'))) break;
            if (n == L2CALEN - 1) return;
          }
      }
    inbufp = bpsav;
    incnt = cntsav;
  }

/**************************************************************************\
*                                                                          *
* "buffer get ID"                                                          *
*                                                                          *
\**************************************************************************/

bgetid(check,gidp)

unsigned    check;
char       *gidp;

  {
    char        id[L2IDLEN];
    char       *idp;
    unsigned    innmbr;
    unsigned    n;
    unsigned    inchr;

    for (idp = id, n = 0; n < L2CALEN; ++n) *idp++ = ' ';
    *idp = 0x60;
    nxtnos();
    idp = id;
    n = 0;

    while (incnt != 0)
      {
        if ((inchr = upcase(*inbufp & 0xFF)) == ' ' || inchr == ',') break;
        if (inchr < ' ') return (ERROR);
        if (inchr == '-')
          {
            if (n == 0 || incnt == 0) return (ERROR);
            ++inbufp;
            --incnt;
            if ((inchr = *inbufp & 0xFF) < '0' || inchr > '9') return (ERROR);
            ++inbufp;
            --incnt;
            innmbr = inchr - '0';
            if (incnt != 0)
              if ((inchr = *inbufp & 0xFF) >= '0' && inchr <= '9')
                {
                  innmbr *= 10;
                  innmbr += (inchr - '0');
                  if (innmbr > 15) return (ERROR);
                  ++inbufp;
                  --incnt;
                }
            id[L2IDLEN - 1] = (innmbr << 1) | 0x60;
            break;
          }
        else
          {
            if (n++ == L2CALEN) return (ERROR);
            *idp++ = inchr;
            ++inbufp;
            --incnt;
          }
      } /* end while */

    while (incnt != 0)
      {
        if (!((inchr = *inbufp & 0xFF) == ' ' || inchr == ',')) break;
        ++inbufp;
        --incnt;
        if (inchr == ',') break;
      }

    if (!n) return (FALSE);
    if (fvalca(check,id) == ERROR) return (ERROR);
    cpyid(gidp,id);
    return (TRUE);
  }

/**************************************************************************\
*                                                                          *
* "hpost put fixed unsigned"                                               *
*                                                                          *
\**************************************************************************/

#ifndef TFPC
VOID hputfu(u)

unsigned u;

  {
    BOOLEAN    out;
    unsigned   div;
    unsigned   digit;
    unsigned   n;

    for (out = FALSE, div = 10000, n = 0; n < 5; ++n)
      {
        if ((digit = u/div) != 0 || out == TRUE || div == 1)
          {
            hputc(digit + '0');
            out = TRUE;
          }
        else
          hputc(' ');
        u  %= div;
        div /= 10;
      }
  }

/**************************************************************************\
*                                                                          *
* "response heard"                                                         *
*                                                                          *
\**************************************************************************/

VOID rsphrd(hbp)

HEARDB *hbp;

  {
    unsigned    ssid;
    unsigned    n;
    unsigned    m;
    unsigned    ch;
    char       *id;

    if (ishmod)
      {
        if (hbp->nexthb != &heardl)
          hmputr(HMRMONIH);
        else
          hmputr(HMRMONH);
      }

    for (id = hbp->hid, m = 3, n = 0; n < L2CALEN; ++n)
      if ((ch = *id++ & 0xFF) > ' ')
        hputc(ch);
      else
        if (ch == ' ')
          ++m;
        else
          hputc('.');
    if ((ssid = (*id >> 1) & 0xF) != 0)
      {
        hputc('-');
        hputud(ssid);
        if (ssid < 10) ++m;
      }
    else
      m += 3;
    while (m--) hputc(' ');
    hputbt(&hbp->hfirst);
    hputs("  ");
    hputbt(&hbp->hlast);
    hputs("   ");
    hputfu(hbp->hIno);
    hputs("i ");
    hputfu(hbp->hRRno);
    hputs("r ");
    hputfu(hbp->hREJno);
    hputs("j ");
    hputfu(hbp->hRNRno);
    hputc('n');

    if (ishmod)
      hputc(0);
    else
      hcrlf();
  }

/**************************************************************************\
*                                                                          *
* "is routing buffer"                                                      *
*                                                                          *
* Routing-Buffer gibt es nur bei TheNet - hier wird auf Heardlistenbuffer  *
* getestet.                                                                *
*                                                                          *
\**************************************************************************/

BOOLEAN isrout(bp)

MBHEAD *bp;

  {
    MBHEAD *bp2;

    for (bp2 = heardl.head; bp2 != &heardl; bp2 = bp2->nextmh)
      if (bp == bp2) return (YES);
    return (NO);
  }
#endif

/* Ende von TFD.C */
