/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware.                     *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    TFV.C   -   The Firmware, globale Variable                            *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*                                                                          *
*    modifiziert:   DL8ZAW, 25.07.91                                       *
*                   Walt, Palt: Werte von Slottime und P-Persistance vor   *
*                               dem Umschalten in DAMA-Betrieb.            *
*                               Nach Ausschalten von DAMA werden diese     *
*                               Werte wieder uebernommen.                  *
*                                                                          *
*                   DB2OS,  17.09.91                                       *
*                   UIpar:  UI+ @U-Parameter.                              *
*                                                                          *
*                   DB2OS,  22.09.91                                       *
*                   Walt entfallen, auch bei DAMA Slottime 1mal warten.    *
*                                                                          *
*                   DG0FT, 26.03.92                                        *
*                   ch0prt: unproto-Port                                   *
*                                                                          *
*                   DG0FT, 26.06.92                                        *
*                   lnklst: Linkliste fr Nachbarstationen                 *
*                                                                          *
\**************************************************************************/

/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tf.h"          /* Festlegungen/Datenstrukturen fuer TheFirmware */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */

/*                                             dynamische Globals (RAM)   */
/**************************************************************************/

LHEAD       monfl;            /* "monitor frame list", Listenkopf der     */
                              /* Monitor-Frameliste, bei der Firmware     */
                              /* werden hier hintereinander alle          */
                              /* empfangenen und gesendeten Frames        */
                              /* abgelegt                                 */
#ifdef DRSI
LNKENTRY    lnklst[L2VNUM+1]; /* Linkliste mit Nachbarports, 0-terminiert */
char        ch0prt;           /* unproto-Port                             */
#endif

char        ch0id[L2IDLEN];   /* ID unproto-Kanal 0, Call normal, SSID 1  */
                              /* Bit linksgeschoben                       */
char        ch0via[L2VLEN+1]; /* via-ID's unproto-Kanal 0, 0-terminiert   */
char        hinbuf[HBUFLEN];  /* Host-Eingabebuffer                       */
char       *inbufp;           /* Zeiger in den Host-Eingabebuffer         */
#ifndef TFPC
char        Apar;             /* AUTOLF     0..1              A-Befehl    */
                              /* 1 = LF automatisch auf CR bei            */
                              /* Hosteingaben, 0 kein automatisches LF    */
#endif
char        Epar;             /* ECHO       0..1              E-Befehl    */
                              /* 1 = Echo ein bei Hosteingaben, 0 aus     */
char        M7par;            /* MASK7BIT   0..1              @M-Befehl   */
                              /* 0 = im Terminal-Modus 7Bit maskieren.    */
char        UIpar;            /* UIPOLL     0=UI  1=UI+       @U-Befehl   */
char        actch;            /* aktueller Kanal (0..127)                 */
#ifndef TFPC
char        Zpar;             /* FLOW       0..3              Z-Befehl    */
                              /*   0 = Flow aus, XON/XOFF aus             */
                              /*   1 = Flow ein, XON/XOFF aus             */
                              /*   2 = Flow aus, XON/XOFF ein             */
                              /*   3 = Flow ein, XON/XOFF ein             */
#else
#ifdef DRSI
char        Cpar[L2PNUM];     /* CARRIER    0..63            @C-Befehl    */
unsigned    TApar[L2PNUM];    /* TXTAIL     10ms            @TA-Befehl    */
#else
char        Cpar;             /* CARRIER    0..63            @C-Befehl    */
unsigned    TApar;            /* TXTAIL     10ms            @TA-Befehl    */
#endif
#endif
#ifdef DRSI
char        Dpar[L2PNUM];     /* DUPLEX     0..1             @D-Befehl    */
char        Ppar[L2PNUM];     /* P-P-Wert   0..255            P-Befehl    */
char        Palt[L2PNUM];     /* P-P-Wert   0..255 alter Wert vor DAMA    */
char        Tpar[L2PNUM];     /* TXDELAY    10ms              T-Befehl    */
char        Wpar[L2PNUM];     /* WAIT       10ms              W-Befehl    */
char        Xpar[L2PNUM];     /* PTTON      0..1              X-Befehl    */
#else
char        Dpar;             /* DUPLEX     0..1             @D-Befehl    */
char        Ppar;             /* P-P-Wert   0..255            P-Befehl    */
char        Palt;             /* P-P-Wert   0..255 alter Wert vor DAMA    */
char        Tpar;             /* TXDELAY    10ms              T-Befehl    */
char        Wpar;             /* WAIT       10ms              W-Befehl    */
char        Xpar;             /* PTTON      0..1              X-Befehl    */
#endif
char        Upar;             /* UMODE      0..2              U-Befehl    */
                              /* 1 = unattended Modus ein, 0 aus          */
                              /* 2 = zusaetzlich Remote-Kommando //Q ein  */
char        Utxt[UTXTLEN+1];  /* CTEXT fuer unattended Modus              */
char        Mpar;             /* Monitorparameter             M-Befehl    */
                              /*   Bit 0 - I                              */
                              /*   Bit 1 - U                              */
                              /*   Bit 2 - S                              */
                              /*   Bit 3 - C                              */
                              /*   Bit 4 - nicht benutzt                  */
                              /*   Bit 5 - nicht benutzt                  */
                              /*   Bit 6 - nicht benutzt                  */
                              /*   Bit 7 - nicht benutzt                  */
char        mftsel;           /* "monitor from/to select",                */
                              /*   0 = nichts                             */
                              /*   1 = + (Monitor nur mftidl-Stationen)   */
                              /*   2 = - (Monitor nicht mftidl-Stationen) */
char        mftidl[L2VLEN+1]; /* "monitor from to id list", die ID's der  */
                              /* Stationen fuer +/-, 0-terminiert         */
char        ishmod;           /* 1 = Hostmode ist an, 0 sonst             */
char        hmstat;           /* Zustand waehrend Hostmodeingabe (HMS...) */
char        hmch;             /* Hostmode-Kanal                           */
char        hmcmd;            /* Hostmode-Kommandobyte                    */
char        hmlen;            /* Laenge der Hostmode-Eingabe              */
unsigned    incnt;            /* "in counter", Laenge einer Host-Eingabe  */
unsigned    isctlr;           /* 1 = Control R war eingegeben, 0 sonst    */
unsigned    ticks;            /* 10ms-Ticks, Systemtakt                   */
unsigned    oldtic;           /* alter ticks-Stand fuer Sekundentakt      */
unsigned    VCpar;            /* Validate Callsign Parameter, @-V Befehl, */
                              /* 1 = Rufzeichencheck ein, 0 = aus         */
#ifndef TFPC
unsigned    magicn;           /* Magic Number fuer Warmstartfeststellung  */
#endif
MBHEAD     *mifmbp;           /* "monitor I frame message buffer pointer" */
                              /* Zeiger auf I-Frame, welches hinter einem */
                              /* Monitor-Header auf dem Monitorkanal      */
                              /* ausgegeben werden soll als naechstes,    */
                              /* 0 = kein solches I-Frame vorhanden       */
LHEAD       l3rxfl;           /* "level 3 rx frame list",                 */
                              /* Listenkopf Level-3-Pakete                */
LHEAD       statml;           /* "status message list",                   */
                              /* Listenkopf Statusmeldungsliste Kanal 0   */
LHEAD       smonfl;           /* "selected monitor frame list",           */
                              /* Listenkopf Monitorframeliste, nur Mpar   */
                              /* entsprechende Frames                     */
LHEAD       chnlml[LINKNMBR]; /* "channel message list",                  */
                              /* Listenkoepfe fuer jeden Kanal fuer die   */
                              /* Empfangsframes und Statusmedungen        */
#ifndef TFPC
LHEAD       heardl;           /* "heard list", Listenkopf der Liste aller */
                              /* gehoerten Stationen                      */
unsigned    numhrd;           /* Anzahl Eintraege in heardl               */
unsigned    maxhrd;           /* Anzahl Eintraege in heardl maximal       */
#endif
unsigned    sec100;           /* aktuelle Zeit :    1/100 Sekunde (0..99) */
#ifdef TIMESTAMP
TIMEBL      time;             /* aktuelle Zeit/Datum                      */
char        eudate;           /* Datumsausgabe :  europaeisch tt.mm.yy    */
                              /*                  amerikanisch mm/dd/yy   */
char        stamp;            /* Zeit/Datum-Stamp :                       */
                              /*   0 = Stamp aus                          */
                              /*   1 = bei Statusmeldungen                */
                              /*   2 = bei Status- und Monitormeldungen   */
#endif
#ifndef TFPC
char        xFpar;            /* Flagsenden in Sendepausen, 1 = an, 0 aus */
char        heard;            /* Heardliste, 0 aus, 1 ein                 */
HEARDB     *hrdmbp;           /* Zeiger auf naechsten auszugebenden       */
                              /* Heard-Buffer bei Ausgabe der Heardliste  */
char        stmem[STACKLEN-1];/* Stackspeicher                            */
char        stack;            /* hoechste Speicherstelle des Stacks       */
unsigned    fremem;           /* erste Speicherstelle des Freispeichers   */
#endif

/*                                              statische Globals (ROM)   */
/**************************************************************************/

char cqid[] = { 'C','Q',' ',' ',' ',' ',0x60 };   /* ID UI-Frame an CQ    */

#ifndef FIRMWARE
unsigned ininat = 900;        /* 15 Minuten No-Activity-Timeout fest      */
#endif
unsigned conctl = 128;        /* 128 Pakete Congestion-Control fest       */

extern char l2tct[];          /* forward-Referenzen fuer l2msgs           */
extern char l2tdf[];
extern char l2tbf[];
extern char l2tlfw[];
extern char l2tlrf[];
extern char l2tlrt[];
extern char l2tfrf[];
extern char l2tfrt[];

char *l2msgs[] =              /* Tabelle Stringadressen Statusmeldungen   */
  {                           /* entsprechend L2M... :                    */
    l2tct,                    /*   L2MCONNT - 1                           */
    l2tdf,                    /*   L2MDISCF - 1                           */
    l2tbf,                    /*   L2MBUSYF - 1                           */
    l2tlfw,                   /*   L2MFAILW - 1                           */
    l2tlrf,                   /*   L2MLRESF - 1                           */
    l2tlrt,                   /*   L2MLREST - 1                           */
    l2tfrf,                   /*   L2MFRMRF - 1                           */
    l2tfrt                    /*   L2MFRMRT - 1                           */
  };

extern extcmd();              /* Referenzen fuer cmdtab                   */
extern rspic();
extern Acmd();
extern Bcmd();
extern Ccmd();
extern Dcmd();
extern Ecmd();
extern Fcmd();
extern Gcmd();
extern Hcmd();
extern Icmd();
extern Jcmd();
extern Kcmd();
extern Lcmd();
extern Mcmd();
extern Ncmd();
extern Ocmd();
extern Pcmd();
extern Qcmd();
extern Rcmd();
extern Scmd();
extern Tcmd();
extern Ucmd();
extern Vcmd();
extern Wcmd();
extern Xcmd();
extern Ycmd();
extern Zcmd();

VOID (*cmdtab[])() =          /* Tabelle der Kommandofunktionen :         */
  {
    extcmd,                   /*   @   (T2, T3, B, D, K, S, V, ...)       */
#ifndef TFPC
    Acmd,
    Bcmd,
    Ccmd,
    Dcmd,
    Ecmd,
    Fcmd,
    Gcmd,
    Hcmd,
    Icmd,
    Jcmd,
    Kcmd,
    Lcmd,
    Mcmd,
    Ncmd,
    Ocmd,
    Pcmd,
    Qcmd,
    Rcmd,
    Scmd,
    Tcmd,
    Ucmd,
    Vcmd,
    Wcmd,
    Xcmd,
    Ycmd,
    Zcmd
#else
    rspic,
    Bcmd,
    Ccmd,
    Dcmd,
    Ecmd,
    Fcmd,
    Gcmd,
    rspic,
    Icmd,
    Jcmd,
#ifdef TIMESTAMP
    Kcmd,
#else
    rspic,
#endif
    Lcmd,
    Mcmd,
    Ncmd,
    Ocmd,
    Pcmd,
#ifdef DRSI
    Qcmd,
#else
    rspic,
#endif
    Rcmd,
    Scmd,
    Tcmd,
    Ucmd,
    Vcmd,
    Wcmd,
    Xcmd,
    Ycmd,
    rspic
#endif
  };

char l2tct[]  = "CONNECTED to";         /* die Strings fuer l2msgs        */
char l2tdf[]  = "DISCONNECTED fm";
char l2tbf[]  = "BUSY fm";
char l2tlfw[] = "LINK FAILURE with";
char l2tlrf[] = "LINK RESET fm";
char l2tlrt[] = "LINK RESET to";
char l2tfrf[] = "FRAME REJECT fm";
char l2tfrt[] = "FRAME REJECT to";

/* Ende von TFV.C */
