/*****************************************************************************\
*                                                                             *
*                                                                             *
*    *****                      *****                                         *
*      *****                  *****                                           *
*        *****              *****                                             *
*          *****          *****                                               *
*            *****      *****                                                 *
*              *****  *****                                                   *
*            *****      *****                                                 *
*          *****          *****          The Net.                             *
*        *****              *****        Portable. Compatible.                *
*      *****                  *****      Public Domain.                       *
*    *****                      *****    NORD><LINK.                          *
*                                                                             *
*                                                                             *
*                                                                             *
*    PATCH119.C -   zum Eingeben der EPROM-Parameter fuer TheNet 1.19         *
*                                                                             *
*    angelegt:      DF6LN  aus PATCH118.C	                              *
*    modifiziert:							      *
*                                                                             *
\*****************************************************************************/


#define QC			/* fuer QC	*/
/*#define TURBOC*/	 		/* fuer TurboC	*/

/* wenn der falsche Compiler definiert wurde, meckert er wohl irgendwann     */

#ifndef QC
#ifndef TURBOC
#error Entweder QC oder TURBOC muss definiert sein!
#endif
#endif

#ifdef QC
#ifdef TURBOC
#error TURBOC und QC definiert geht nicht!
#endif
#endif

#include <stdio.h>
#ifdef TURBOC
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#endif

#define TRUE 1
#define FALSE 0
#ifndef ERROR				/* ist bei QC in stdio.h definiert   */
#define ERROR -1
#endif
#define OFFSET 0x86			/* Offset Fileanfang - Patchbereich  */
#define L2CALEN 6			/* Laenge Rufzeichen/Ident (o. SSID) */
#define L2IDLEN L2CALEN+1		/* Laenge Rufzeichen + SSID	     */
#define FNSIZE 14			/* Laenge Filename		     */
#define OBJ_FN "TN119.EPR"		/* Datenfile Name ist festgelegt     */


typedef struct partyp			/* Struktur der Patametertabelle     */
 {
  unsigned normal;			/* Default Wert			     */
  unsigned minimal;			/* minimaler Wert		     */
  unsigned maximal;			/* maximaler Wert		     */
  char	  *parnam;			/* Bezeichnung des Parameters	     */
 } PARTYP;


FILE	*infile;		/* File aus dem Daten gelesen werden	     */
char	 infn[] = OBJ_FN;	/* Filename fuer infile			     */
FILE	*outfile;		/* in dieses File wird geschrieben	     */
char	 outfn[FNSIZE];		/* Filename fuer outfile		     */
char	 clilin[256];		/* Eingabezeile				     */
char	*clipoi;		/* Zeiger in Eingabezeile		     */
unsigned clicnt;		/* Laenge Eingabezeile			     */
#ifdef TURBOC
char	 daten[0x8000];		/* EPROM-Inhalt				     */
#else
char	*daten;			/* QC mag kein ARRAY von 0x8000 Bytes	     */
#endif
char	*datapoi;		/* Zeiger zu EPROM-Daten		     */
char	 call[L2IDLEN];		/* Rufzeichen				     */
char	 alias0[L2CALEN];	/* Identifier HDLC-Port			     */
char	 alias1[L2CALEN];	/* Identifier RS232-Port		     */

char	signon[] = "Patchprogramm fuer TheNet 1.19 by NORD><LINK (DF6LN)\n";

char	p1nam[]  = "Laenge Knotenliste / size of nodelist";
char	p2nam[]  = "minimale Qualitaet / min. quality";
char	p3nam[]  = "HDLC-Qualitaet / HDLC quality";
char	p4nam[]  = "RS232-Qualitaet / RS232 quality";
char	p5nam[]  = "Anfangswert Knotenlebensdauer / initial obsolescence count";
char	p6nam[]  = "Restlebensdauer fuer Rundspruch / min. obsolescence count for broadcast";
char	p7nam[]  = "Rundspruchintervall / broadcast interval";
char	p8nam[]  = "L3-Paketlebensdauer / network layer lifetime";
char	p9nam[]  = "Transport Timeout";
char	p10nam[] = "Transport Versuche / transport retries";
char	p11nam[] = "Transport Wartezeit bis Bestaetigung / transport acknowledge delay";
char	p12nam[] = "Transport Busy Wartezeit / transport busy delay";
char	p13nam[] = "Transport Fenstergroesse / transport window size";
char	p14nam[] = "gepufferte Frames je Verbindung / buffered frames per link";
char	p15nam[] = "User-Timeout";
char	p16nam[] = "Entschlossenheit fuer Sendung frei / p-persistance";
char	p17nam[] = "Zeitschlitzbreite / slot time";
char	p18nam[] = "Frack (Timer 1) HDLC-Port";
char	p19nam[] = "Maxframe HDLC-Port";
char	p20nam[] = "L2 Versuche / l2 retries";
char	p21nam[] = "L2 Timer 2 (Antwortzeit) fuer HDLC-Port / l2 response time";
char	p22nam[] = "L2 Timer 3";
char	p23nam[] = "L2 Digipeating Freigabe (0 = aus) / l2 digipeating (0 = off)";
char	p24nam[] = "Calls pruefen (1 = pruefen) / validate callsigns";
char	p25nam[] = "Bakenmodus / ID-beacon mode";
char	p26nam[] = "CQ-Bake (0 = aus) / CQ-beacon (0 = off)";
char	p27nam[] = "Vollduplex ein/aus (0 = aus) / full duplex (0 = off)";
char	p28nam[] = "Flags in Sendepausen (0 = keine Flags) / transmit flags during pause";
char	p29nam[] = "TxDelay";
char	p30nam[] = "System-Flags";
char	p31nam[] = "min. freie Buffer fuer Befehlsbearbeitung / min. free buffers for command interpretation";
char	p32nam[] = "Sonderzeichen fuer Texteingabe / escape character for INFO command";
char	p33nam[] = "eigene Qualitaet bei Rundspruch / own quality for broadcast";
char	p34nam[] = "Maximale Zahl L2-Links / max. number of l2-links";
char	p35nam[] = "Frack RS232-Port";
char	p36nam[] = "Timer 2 RS232-Port";
char	p37nam[] = "Maxframe RS232-Port";
char	p38nam[] = "Start time L2 modification";
char	p39nam[] = "End time L2 modification";

PARTYP partab[39] =
 {
     80, 1,	100, p1nam,
     30, 0,	255, p2nam,
     50, 0,	255, p3nam,
    150, 0,	255, p4nam,
      6, 0,	255, p5nam,
      5, 1,	255, p6nam,
    600, 0,  0xffff, p7nam,
     20, 1,	255, p8nam,
    300, 5,	600, p9nam,
      2, 2,	127, p10nam,
      6, 1,	 60, p11nam,
    180, 1,    1000, p12nam,
      4, 2,	127, p13nam,
      4, 1,	127, p14nam,
   2000, 0,  0xffff, p15nam,
     32, 0,	256, p16nam,
     10, 0,	255, p17nam,
      5, 1,	 15, p18nam,
      2, 1,	  7, p19nam,
     10, 0,	127, p20nam,
    100, 0,    6000, p21nam,
  18000, 0,  0xffff, p22nam,
      1, 0,	  1, p23nam,
      1, 0,	  1, p24nam,
      2, 0,	  2, p25nam,
      1, 0,	  1, p26nam,
      0, 0,	  1, p27nam,
      0, 0,	  1, p28nam,
     25, 0,     255, p29nam,
   1280, 0,  0xffff, p30nam,
     64, 0,	600, p31nam,
   '\\', 0,	127, p32nam,
    255, 0,	255, p33nam,
     25, 0,      25, p34nam,
      1, 1,      15, p35nam,
     10, 0,     600, p36nam,
      7, 1,       7, p37nam,
      0, 0,  0xffff, p38nam,
      0, 0,  0xffff, p39nam
 };


/*---------------------------------------------------------------------------*/
#ifdef QC
isltr(zeichen)
unsigned zeichen;
#else
isltr(unsigned zeichen)
#endif
 {
  return((zeichen >= 'A') && (zeichen <= 'Z'));
 }

/*---------------------------------------------------------------------------*/
#ifdef QC
isnum(zeichen)
unsigned zeichen;
#else
isnum(unsigned zeichen)
#endif
 {
  return ((zeichen >= '0') && (zeichen <= '9'));
 }

/*****************************************************************************\
*                                                                             *
* Rufzeichen auf Gueltigkeit ueberpruefen				      *
*                                                                             *
* TRUE = gueltiges Rufzeichen, FALSE = leeres Rufzeichen, ERROR = ungueltiges *
* Rufzeichen		(aus L7U.C)					      *
*                                                                             *
\*****************************************************************************/

#ifdef QC
int valcal(rufz)
char *rufz;
#else
int valcal(char *rufz)
#endif
  {
  char	   zeichen;		/* aktuelles Zeichen			     */
  unsigned numpos;		/* Position der Zahl im Call		     */
  unsigned zahl;		/* Zahlen im Call			     */
  unsigned cnt;			/* gepruefte Zeichen			     */

  zahl =			/* keine Zahl gefunden			     */
  cnt = 0;			/* nichts geprueft			     */
  do
   {
    if ((zeichen = rufz[cnt]) == ' ')	/* Ende des Calls?		     */
     {
      break;
     }
    if (!isltr(zeichen))		/* Alfa ist immer gut		     */
     {
      if (isnum(zeichen)	/* Zahl nur ok, wenn max. 3. Stelle	     */
	  && (cnt < 3))
       {
        ++zahl;			/* Zahlen zaehlen			     */
        numpos = cnt;		/* Position merken			     */
       }
      else
       {
        return(ERROR);		/* ungueltiges Zeichen im Call		     */
       }
     }
   } while (++cnt < L2CALEN);	/* maximal 6 Zeichen Call		     */

  if (
       (cnt < 4)		/* minimal 4 Zeichen			     */
    || ((zahl == 2)		/* nicht 2 Zahlen am Anfang		     */
	&& (numpos == 1))
    || (zahl - 1 > 1)		/* min. 1 Zahl, max. 2 Zahlen		     */
    || (!numpos)		/* wenn nur 1 Zahl, nicht an erster Stelle   */
    || (numpos == (cnt -1)))	/* mindestens 1 Buchstabe Suffix	     */
    return(ERROR);		/* Call ist ungueltig			     */
  else return(TRUE);		/* Call ist gueltig			     */
  }

/*****************************************************************************\
*									      *
* Eingabezeile auf naechstes Zeichen hinter Leerzeichen	(aus L7U.C)	      *
*									      *
\*****************************************************************************/

void nxtnos(void)		/* auf naechstes Zeichen != ' ' in CLI-Zeile */
 {				/* TRUE wenn noch Zeichen vorhanden	     */
  while ((clicnt != 0) && (*clipoi == ' '))
   {
    ++clipoi;
    --clicnt;
    }
 }



/*****************************************************************************\
*                                                                             *
* Rufzeichen aus Eingabezeile holen					      *
*                                                                             *
* TRUE = gueltiges Rufzeichen, FALSE = leeres Rufzeichen, ERROR = ungueltiges *
* Rufzeichen		(aus L7U.C)					      *
*                                                                             *
\*****************************************************************************/

int getcal(void) 		/* Call aus Buffer holen		     */
  {
  unsigned cnt;			/* Zaehler, Scratch			     */
  char	   binsid;		/* SSID, binaer				     */
  char	   *calpoi;		/* Pointer in Call			     */
  char	   zeichen;		/* Scratch				     */

  calpoi = call;			/* auf Anfang			     */
  for (cnt = 0; cnt < L2CALEN; ++cnt)	/* Zwischenspeicher loeschen	     */
    *calpoi++ = ' ';
  *calpoi = 0x60;		/* kein SSID				     */

  nxtnos();			/* auf erstes Zeichen != ' '		     */

  calpoi = call;		/* wieder nach vorn			     */
  cnt = 0;			/* gelesene Zeichen = 0			     */
  while (clicnt != 0)		/* so lange Zeichen da sind		     */
   {
    zeichen = toupper(*clipoi);			/* und gueltig		     */
    if (zeichen < ' ') return(ERROR);		/* keine Control-Zeichen!    */
    if (zeichen == '-')				/* Trennung zum SSID?	     */
     {
      if ((cnt == 0) || (clicnt == 0))
        return(ERROR);			/* Fehler: kein Call oder SSID	     */
      ++clipoi;				/* Trennung uebergehen		     */
      --clicnt;
      if (clicnt == 0) return (ERROR);	/* SSID angesagt, kommt aber nicht   */
      zeichen = *clipoi;		/* erste Ziffer SSID holen	     */
      if ((zeichen < '0')
	  || (zeichen > '9')) return(ERROR);	/* ungueltige Ziffer	     */
      ++clipoi;
      --clicnt;					/* Ziffer ist verbraucht     */
      binsid = (zeichen - '0');			/* Binaer merken	     */
      if (clicnt != 0)				/* noch Zeichen da?	     */
       {
        zeichen = *clipoi;				/* holen	     */
        if ((zeichen >= '0') && (zeichen <= '9'))	/* gueltige Ziffer?  */
	 {
          binsid *= 10;		    /* erste Ziffer eine Stelle nach links   */
          binsid += (zeichen -'0'); /* + neue Ziffer			     */
          if (binsid > 15)
	    return(ERROR);		/* ungueltiger SSID		     */
          ++clipoi;			/* letzte Ziffer verbrauchen	     */
          --clicnt;
          }
        }
      call[L2CALEN] = (binsid << 1) | 0x60; /* SSID merken		     */
      break;
      }
    else
     {				/* kein SSID, anderes Zeichen		     */
      if (cnt++ == L2CALEN)
        return(ERROR);		/* Call zu lang				     */
      *calpoi++ = zeichen;	/* Zeichen merken			     */
      ++clipoi;			/* Lesepointer rauf			     */
      --clicnt;
      }
    }
  if (cnt == 0) return(FALSE);			/* Call war leer	     */
  if (valcal(call) == ERROR) return(ERROR);	/* Call war ungueltig	     */
  return(TRUE);					/* ok melden		     */
  }



/*****************************************************************************\
*                                                                             *
* Identifier aus Eingabezeile holen					      *
*                                                                             *
* TRUE = gueltiger Identifer, FALSE = leerer Identifier, ERROR = ungueltiger  *
* Identifier		(aus L7U.C)					      *
*                                                                             *
\*****************************************************************************/

#ifdef QC
int getide(buffer)
char *buffer;
#else
int getide(char *buffer)
#endif
{
  unsigned cnt;			/* Zaehler, Scratch			     */
  char	   zeichen;		/* Scratch				     */

  for (cnt = 0; cnt < L2CALEN; ++cnt) buffer[cnt] = ' ';

  for (cnt = 0;
      (cnt < L2CALEN) && (clicnt-- != 0);
      ++cnt)
  {
    zeichen = toupper(*clipoi++);
    if (zeichen != ' ')			/* Schluss bei Trennzeichen	     */
    {
      if (((zeichen >= 'A') && (zeichen <= 'Z'))
         || ((zeichen >= '0') && (zeichen <= '9'))
         || (zeichen == '#'))		 	/* gueltiges Zeichen?	     */
      {
         buffer[cnt] = zeichen;
         continue;
      }
    }
    break;
  }

  if ((cnt == L2CALEN) && (clicnt != 0) && (*clipoi) != ' ')
    return(ERROR);			/* Ident zu lang? Fehler melden	     */

  if (valcal(buffer) == TRUE)
    return(ERROR);			/* Ident darf kein Call sein	     */

  return(buffer[0] != ' ');
  }

/*****************************************************************************\
*                                                                             *
* Ausgabe einer Fehlermeldung und Programm abbrechen.                         *
*                                                                             *
*   s1  -  Zeiger auf String des ersten Teils der Fehlermeldung               *
*   s2  -  Zeiger auf String des zweiten Teils der Fehlermeldung              *
*                                                                             *
* Ausgegeben wird "FATAL ERROR: ", dann die beiden Strings, dann CR/LF.       *
*                                                                             *
\*****************************************************************************/

#ifdef QC
void fatal(s1,s2)
char *s1;
char *s2;
#else
void fatal(char *s1,char *s2)
#endif
  {
    fprintf(stderr,"FATAL ERROR: %s%s\n",s1,s2);  /* Meldung ausgeben        */
    exit(1);                                      /* Programm abbrechen      */
  }




/*****************************************************************************\
*                                                                             *
*				Hauptprogramm				      *
*                                                                             *
\*****************************************************************************/

void main(void)
 {
  unsigned cnt;				/* allgemeiner Zaehler		     */
  char     c;
  unsigned z;
  unsigned z1;
  PARTYP  *parpoi;

  printf(signon);			  /* Startmeldung		     */
#ifdef QC
  if ((daten = malloc(0x8000)) == NULL)
      fatal("not enough memory","");
#endif
  datapoi = daten;			  /* Datenzeiger auf Anfang	     */
  if ((infile = fopen(infn,"rb"))== NULL) /* EPROM-File zum lesen oeffnen    */

    fatal(infn," not found");		/* wenn nicht gefunden ..	     */
#ifdef QC
  printf("reading data file ...\n");
#endif
  if (fread(datapoi,512,64,infile) != 64)	/* File zu kurz?	     */
    fatal(infn," - bad file length");	/* meckern		     */
  fclose(infile);
  do				/* Call holen fuer Ausgabe-Filenamen	     */
   {
    printf("Callsign: ");		/* als erstes Call holen	     */
    gets(clilin);			/* in clilin			     */
    clicnt = strlen(clilin);		/* wieviel Zeichen gueltig?	     */
    clipoi = clilin;			/* Zeiger auf Zeilenanfang	     */
   }
  while (getcal() != TRUE);		/* muss gueltig sein, sonst noch mal */
  for (cnt = 0; cnt < L2CALEN; ++cnt)	/* Rufzeichen -> clilin		     */
   {
    if (call[cnt] == ' ') break;
    clilin[cnt] = call[cnt];
   }
  clilin[cnt] = '\0';			/* Rufzeichenende markieren	     */
  sprintf(outfn,"%s%d.EPR",clilin,	/* Filenamen fuer EPROM-File bilden  */
	((call[L2CALEN] >> 1) & 0x0f));	/* aus Rufzeichen und SSID	     */
  printf("output file: %s ",outfn);	/* Filenamen melden		     */
  if ((outfile = fopen(outfn,"wb")) == NULL)	/* File gefunden?	     */
    fatal("file open error","");		/* nein - Abbruch	     */
  printf("\n");
  do					/* Identifier HDLC-Port holen	     */
   {
    printf("Identifier HDLC-Port: ");	/* das soll eingegeben werden	     */
    gets(clilin);			/* Eingabe holen		     */
    clicnt = strlen(clilin);		/* so viele Zeichen sind da	     */
    clipoi = clilin;			/* da gehts los			     */
   }
  while(getide(alias0) != TRUE);	/* Identifier muss gueltig sein	     */
  do					/* Identifier RS232-Port holen	     */
   {
    printf("Identifier RS232-Port: ");	/* das soll eingegeben werden	     */
    gets(clilin);			/* Eingabe holen		     */
    clicnt = strlen(clilin);		/* so viele Zeichen sind da	     */
    clipoi = clilin;                    /* da gehts los			     */
   }
  while(getide(alias1) != TRUE);	/* Identifier muss gueltig sein	     */
  datapoi = daten + OFFSET;		/* -> Rufzeichenanfang		     */
  for (cnt = 0; cnt < L2IDLEN; ++cnt)	/* Call + SSID in Datenbereich	     */
    *datapoi++ = call[cnt];		/* kopieren			     */
  for (cnt = 0; cnt < L2CALEN; ++cnt)	/* Identifier HDLC-Port kopieren     */
    *datapoi++ = alias0[cnt];
  for (cnt = 0; cnt < L2CALEN; ++cnt)	/* Identifier RS232-Port kopieren    */
    *datapoi++ = alias1[cnt];
  printf("modify parameters? (y/n) ");
  gets(clilin);
  clicnt = strlen(clilin);
  clipoi = clilin;
  nxtnos();
  if (((c = toupper(*clipoi)) == 'J')
     || (c == 'Y'))
   {
    for(parpoi = partab, cnt = 0;	/* fuer alle Parameter		     */
	cnt < (sizeof(partab) / sizeof(PARTYP));
	++parpoi, ++cnt)
     {
      printf("\nParameter %d %s", (cnt + 1), parpoi->parnam);
      printf("\nmin.  max.  default  new value (<ENTER> = default)");
      printf("\n%5u %5u %5u     ", parpoi->minimal,
				parpoi->maximal, parpoi->normal);
      gets(clilin);					/* neuen Wert holen  */
      clicnt = strlen(clilin);
      clipoi = clilin;
      nxtnos();
      if ((z = (*clipoi++ & 0xff) - '0') > 9)		/* wenn keine Ziffer */
	   z = parpoi->normal;				/* dann Default	     */
      else
	while ((z1 = (*clipoi++ & 0xff) - '0') <= 9)	/* weitere Ziffern   */
	 {
	  z = z * 10 + z1;		/* zusammenrechnen der Ziffern	     */
	 }
      if ((z < parpoi->minimal) || (z > parpoi->maximal)) /* Wert gueltig?   */
	z = parpoi->normal;		/* sonst Default		     */
      *datapoi++ = z & 0xff;		/* Daten merken - Bytes in richtiger */
      *datapoi++ = (z >> 8) & 0xff;	/* Reihenfolge speichern	     */
      printf("parameter %d: new value is %u\n",(cnt + 1), z); /* Wert zeigen */
     }
   }
  else					/* nix aendern, alles Default	     */
   {					/* Parameter aus EPROM-File	     */
    datapoi += 2 * (sizeof(partab)
		    / sizeof(PARTYP));
   }
  printf("enter password (length 80 characters, no space)\n");
  printf("<ENTER> = use password of TN119.EPR\n");
  gets(clilin);
  clipoi = clilin;			/* Zeiger auf Anfang Eingabe	     */
  if (*clipoi != '\0')
   {
    for (cnt = 0; cnt < 80; ++cnt)	/* 80 Zeichen max.		     */
     {
      if ((c = *clipoi++) == '\0') break;	/* Ende wenn Eingabe zu kurz 	     */
      *datapoi++ = c;			/* sonst in Datenbereich kopieren    */
     }
    while (cnt++ < 80) *datapoi++ = ' ';/* ggf. Rest mit Leerzeichen fuellen */
   }
#ifdef QC
  printf("writing output file ...\n");
#endif
  datapoi = daten;
  if (fwrite(datapoi,512,64,outfile) != 64)	/* passt alles auf die Disk? */
    fatal("\ndisk write error: ",outfn);
  fclose(outfile);				/* fertig		     */
 }
