/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*	ALL.H	-  Headerfile fuer alle C-Sources			 *
*									 *
*  angelegt:	DF6LN aus ALL.H v. DC4OX diverse Ergaenzungen f. Boxware *
*  modifiziert:								 *
*									 *
\************************************************************************/

/*							Festlegungen	*/
/************************************************************************/

#define BOXWARE		/* defined: TheBoxware compilieren - sonst:	*/
#ifndef BOXWARE		/* nicht BOXWARE und FIRMWARE gleichzeitig	*/
/*#define FIRMWARE*/	/*   defined: Compilieren TheFirmware		*/
#endif			/* undefined: Compilieren TheNet		*/

#ifdef BOXWARE
#define BOXFIRM
#endif

#ifdef FIRMWARE
#define BOXFIRM
#endif

#ifdef FIRMWARE
#define LINKNMBR	10	/* max. Zahl Links = Connect-Kanaele	*/
#else
#ifdef BOXWARE
#define LINKNMBR	4       /* 4 reicht - connected werden Circuits	*/
#else
#define LINKNMBR	25	/* TN = 25 Uplinks			*/
#endif
#endif

#define TRUE	1	/* BOOLEAN TRUE					*/
#define FALSE	0	/* BOOLEAN FALSE				*/
#define ERROR	0xFFFF	/* Fehler					*/
#define LOOP	for(;;)	/* Endlosschleife				*/

#define STACKLEN 512	/* Anzahl Bytes fuer Systemstack		*/
#define MAGIC	 0x4D5A	/* "magic number", Warmstartfeststellung	*/
			/* (MSDOS laesst gruessen ...)			*/

				/* Portnummern:				*/
#define HDLCPORT	0	/* Packet-Port				*/
#ifndef BOXFIRM			/* zusaetzlich fuer TheNet:		*/
#define ASYNPORT	1	/* RS232 Crosslink-Port			*/
#endif
#define NULL		0	/* leerer Zeiger			*/

#ifdef BOXWARE
#define Ypar	LINKNMBR
#endif

#ifndef FIRMWARE		/* AX.25-Version 1 kann nur bei		*/
#define Vpar	1		/* The Firmware geschaltet werden	*/
#endif

#ifdef	BOXWARE
#define NUMCIR	27		/* Anzahl der Hostkanaele		*/
#endif

#ifndef BOXFIRM
#define NUMCIR	20
#define MAXHST	1			/* Host Kanaele			*/
#define NUMPAT	NUMCIR+LINKNMBR+MAXHST	/* Laenge der Patchcord Liste	*/
#define MAXHRD	25			/* Laenge Heardliste		*/
#define CLILEN	230
#define PEVER	0
#define PFLG	1
#define PNEVER	2
#endif

/*							einfache Typen	*/
/************************************************************************/


typedef	int	 VOID;		/* Keine-Parameter-Zurueck-Funktion	*/
typedef	unsigned UWORD;
typedef unsigned BOOLEAN;	/* FALSE, TRUE moeglich			*/


/* Ende von ALL.H */
