/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*                                                                        *
*    L2.H   -   Headerfile Level 2                                       *
*                                                                        *
* ACHTUNG!!! Wenn hier Level-2-Strukturen geaendert werden, muessen auch *
* die Assembler-Routinen in L2D.C angepasst werden!			 *
*                                                                        *
*    angelegt:      DC4OX                                                *
*    modifiziert:   DF6LN  300990  Statetable komprimiert		 *
*                                                                        *
\************************************************************************/





/*                                                         Festlegungen   */
/**************************************************************************/

#ifndef BOXFIRM
#define L2PNUM   2                      /* TheNet      :  2 Level-2-Ports */
#endif

#define INFOLEN  256                    /* max. Laenge Infofeld im Frame  */
#define L2CALEN  6                      /* Laenge Call im Level 2         */
#define L2IDLEN  (L2CALEN + 1)          /* Laenge Call + SSID = ID        */
#define L2INUM   2                      /* Anzahl ID's im an/von-Feld     */
#define L2VNUM   8                      /* Anzahl ID's im via-Feld        */
#define L2ILEN   (L2INUM * L2IDLEN)     /* Laenge an/von-Feld             */
#define L2VLEN   (L2VNUM * L2IDLEN)     /* Laenge via-Feld                */
#ifndef L234INC
#ifndef L7INC
#define L2AFLEN  (L2ILEN + L2VLEN)      /* Laenge Level 2 Adressfeld      */
#define L2MFLEN (L2AFLEN + 2 + INFOLEN) /* maximale Framelaenge,          */
                                        /*   10 * 7 =    70 Bytes Adresse */
                                        /*            +   1 Byte Control  */
                                        /*            +   1 Byte PID      */
                                        /*            + 256 Byte Info     */
                                        /*            -----               */
                                        /*              328               */
#endif
#endif



                              /* "layer 2 state", (state, s.u.) :         */
#define L2SDSCED    0         /*    disconnected                          */
#define L2SLKSUP    1         /*    link setup                            */
#define L2SFRREJ    2         /*    frame reject                          */
#define L2SDSCRQ    3         /*    disconnect request                    */
#define L2SIXFER    4         /*    information transfer                  */
#ifndef L234INC
#ifndef L7INC
#define L2SRS       5         /*    REJ sent                              */
#define L2SWA       6         /*    waiting acknowledge                   */
#define L2SDBS      7         /*    device busy                           */
#define L2SRBS      8         /*    remote busy                           */
#define L2SBBS      9         /*    both busy                             */
#define L2SWADBS   10         /*    waiting ack and device busy           */
#define L2SWARBS   11         /*    waiting ack and remote busy           */
#define L2SWABBS   12         /*    waiting ack and both busy             */
#define L2SRSDBS   13         /*    REJ sent and device busy              */
#define L2SRSRBS   14         /*    REJ sent and remote busy              */
#define L2SRSBBS   15         /*    REJ sent and both busy                */
#endif
#endif


                              /* "layer 2 message", Status vom Level 2 :  */
#define L2MNIX     0          /*    keine Nachricht                       */
#define L2MCONNT   1          /*    CONNECTED to                          */
#define L2MDISCF   2          /*    DISCONNECTED from                     */
#define L2MBUSYF   3          /*    BUSY from                             */
#define L2MFAILW   4          /*    LINK FAILURE with                     */
#ifdef FIRMWARE
#define L2MLRESF   5          /*    LINK RESET from                       */
#define L2MLREST   6          /*    LINK RESET to                         */
#endif
#ifndef BOXWARE
#define L2MFRMRF   7          /*    FRAME REJECT from                     */
#define L2MFRMRT   8          /*    FRAME REJECT to                       */
#endif
#ifdef FIRMWARE
#define L2MBUSYT   9          /*    BUSY to                               */
#endif

#ifndef L234INC
#ifndef L7INC
                              /* "layer 2 control", Frametypen :          */
                              /*                                          */
                              /*                       Command/   Poll/   */
                              /*    Typ       Gruppe   Response   Final   */
                              /* ---------------------------------------- */
#define L2CI       0x00       /*      I         I         C         P     */
#endif
#define L2CUI      0x03       /*     UI         U        C/R       P/F    */
#define L2CSABM    0x2F       /*   SABM         U         C         P     */
#define L2CDISC    0x43       /*   DISC         U         C         P     */
#define L2CUA      0x63       /*     UA         U         R         F     */
#define L2CDM      0x0F       /*     DM         U         R         F     */
#define L2CFRMR    0x87       /*   FRMR         U         R         F     */
#ifndef L7INC
#define L2CRR      0x01       /*     RR         S        C/R       P/F    */
#define L2CREJ     0x09       /*    REJ         S        C/R       P/F    */
#define L2CRNR     0x05       /*    RNR         S        C/R       P/F    */

                              /* "layer 2 control", spezielle Bits :      */
#define L2CPF      0x10       /*   Poll/Final                             */
#define L2CCR      0x80       /*   Command/Response                       */
#endif
#define L2CH       0x80       /*   "has been repeated"                    */
#define L2CEOA     0x01       /*   End of Address                         */

                              /* "layer 2 control", Masken :              */
#define L2CNOIM    0x01       /*   "no I mask", kein I-Frame              */
#define L2CNOSM    0x02       /*   "no S mask", kein S-Frame              */
#ifndef L7INC
                              /* "layer 2 control", Flags (flag, s.u.) :  */
#define L2FL3LNK   0x20       /*   Link ist Layer-3-Link                  */
#define L2FBUSY    0x40       /*   Device busy (ich !)                    */
#define L2FDSLE    0x80       /*   "disc if send list empty"              */

                              /* im Framebufferkopf (l2fflag, s.u.) :     */
#define L2FT1ST    0x01       /*   nach Aussendung ist T1 zu starten      */
#define L2FUS      0x02       /*   Sendeframe ist U- oder S-Frame (nicht  */
                              /*   digipeatet)                            */
#endif
#endif
                              /* "layer 2 control", Protokollidentifier   */
#define L2CPID     0xF0       /*   PID                                    */





/*                                                                Typen   */
/**************************************************************************/



typedef struct lhead          /* "list head", Listenkopf :                */
  {
    struct lhead   *head;     /*   Zeiger auf ersten Eintrag in Liste     */ 
    struct lhead   *tail;     /*   Zeiger auf letzten Eintrag in Liste    */
  } LHEAD;



typedef struct lehead         /* "list entry head", Kopf eines Eintrags   */
  {                           /* in Liste :                               */
    struct lehead   *nextle;  /*   Zeiger auf naechsten Listeneintrag     */ 
    struct lehead   *prevle;  /*   Zeiger auf vorherigen Listeneintrag    */
  } LEHEAD;



typedef struct lnkblk         /* "link block", fuer jeden Level-2-Link :  */
  {
    char     state;           /* Link-State, s.o. L2S...                  */
    char     srcid[L2IDLEN];  /* "source id", eigenes Call/SSID oder      */
			      /* Ident/SSID                               */
    char     dstid[L2IDLEN];  /* "destination id", Call/SSID Gegenstation */
    char     viaidl[L2VLEN+1];/* "via id list", Digipeaterstrecke,        */
			      /* 0-terminiert, Weg zur Gegenstation       */
#ifndef BOXFIRM
    char     liport;          /* "link port" - 0 : HDLC, 1 : Crosslink    */
#endif
    char     VR;              /* "receive sequence variable", Sequenz-    */
			      /* nummer des naechsten zu empfangenden     */
			      /* I-Frames                                 */
    char     VS;              /* "send sequence variable", Sequenznummer  */
			      /* des naechsten zu sendenden I-Frames      */
    char     lrxdNR;          /* "last received N(R)", zuletzt            */
			      /* empfangenes N(R) = eigene gesendete      */
			      /* I-Frames bis lrxdNR-1 bestaetigt         */
    char     ltxdNR;          /* "last transmitted N(R)", zuletzt         */
			      /* gesendetes N(R) = empfangene I-Frames    */
			      /* bis ltxdNR-1 bestaetigt                  */
    char     tries;           /* aktuelle Anzahl Versuche (RETRY),        */
			      /* hochzaehlend                             */
#ifdef FIRMWARE
    char     N2;              /* RETRY, maximale Anzahl Retries           */
    char     k;               /* MAXFRAME, maximale Anzahl unbestaetigter */
			      /* I-Frames                                 */
    char     snglT1;          /* "single T1", T1 ohne Digikette = FRACK   */
#endif
    char     V2link;          /* "version 2 link" - 0 : Version 1 Link    */
			      /*                    1 : Version 2 Link    */
    char     RStype;          /* "response supervisory frametype", nach   */
			      /* T2-Ablauf zu sendendes Antwortframe      */
			      /* (RR=0x01, RNR=0x05, REJ=0x09)            */
    char     frmr[3];         /* die 3 FRMR-Infobytes, Sendung u. Empfang */
			      /*   frmr[0] : zurueckgewies. Kontrollfeld  */
			      /*   frmr[1] : V(R) CR V(S) 0               */
			      /*   frmr[2] : 0000ZYXW                     */
    char     flag;            /* Flag (s.o. L2F... )                      */
                              /*   Bit 0 : nicht benutzt                  */
                              /*   Bit 1 : nicht benutzt                  */
                              /*   Bit 2 : nicht benutzt                  */
                              /*   Bit 3 : nicht benutzt                  */
                              /*   Bit 4 : nicht benutzt                  */
                              /*   Bit 5 : 1 = Link ist Level 3 Link      */
                              /*           (festgestellt anhand PID !)    */
                              /*   Bit 6 : 1 = (eigenes) Device busy      */
                              /*   Bit 7 : 1 = Link disconnecten, sobald  */
                              /*           Sendeliste (sendil) leer ist   */
    unsigned initT1;          /* "initial T1", (2 * Anzahl Digis + 1) *   */
                              /* snglT1(= FRACK) * 100 in 1/100 sek       */
    unsigned T1;              /* Timer 1, "frame acknowledge interval",   */
			      /* Start :  initT1 + random(),              */
			      /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned T2;              /* Timer T2, "response delay timer",        */
			      /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned T3;              /* Timer T3, "inactive link timer",         */
			      /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned noatou;          /* "no activity timeout",                   */
			      /* nach Ablauf Link disconnecten,           */
			      /* 0 = inaktiv, 1 sec Downcounter           */
    unsigned rcvd;            /* "received", Anzahl empfangener I-Frames  */
			      /* in rcvdil                                */
    unsigned tosend;          /* Anzahl noch nicht gesendete oder         */
			      /* unbestaetigte Frames in sendil           */
    LHEAD    rcvdil;          /* "received info list", richtig            */
			      /* empfangene I-Frames, mit Header/PID      */
    LHEAD    sendil;          /* "send info list", zu sendende I-Frames,  */
			      /* ohne Header/PID, nur Info                */
  } LNKBLK;



/* ACHTUNG: mbhead muss genauso lang sein wie mb !                        */

typedef struct mbhead         /* "message buffer head",                   */
  {                           /* Datenbuffer-Liste, Kopf :                */
    struct mbhead   *nextmh;  /*   naechster Eintrag in Liste             */
    struct mbhead   *prevmh;  /*   vorheriger Eintrag in Liste            */
    LHEAD            mbl;     /*   "message buffer list", Zeiger auf      */
                              /*   ersten Infobuffer dieser Message       */
    char            *mbbp;    /*   "message buffer buffer pointer",       */
                              /*   Zeiger auf aktuelles Zeichen in Buffer */
    unsigned         mbpc;    /*   "message buffer put count",            */
                              /*   Einschreibzaehler, aufwaertszaehlend   */
    unsigned         mbgc;    /*   "message buffer get count",            */
                              /*   Lesezaehler, aufwaertszaehlend         */
    struct lnkblk   *l2link;  /*   Zeiger auf assozierten Linkblock       */
    char             type;    /*   Typ des Buffers (User, Status)         */
                              /*          L2M...                          */
                              /*     oder MB...                           */
                              /*     oder 0 User, 2 Level-2, 4 Level-4    */
    char             l2fflg;  /*   Level 2 Frameflag / PID :              */
                              /*     RX: PID                              */
                              /*     TX: PID / s.o. T2FT1ST/T2FUS         */
#ifndef BOXFIRM
    char             l2port;  /*   0 = HDLC, 1 = RS232-Crosslink          */
#endif
    char             morflg;  /*   "more follows flag" fuer Pakete, die   */
                              /*   durch zusaetzlichen Netzwerkheader zu  */
                              /*   lang wuerden und in 2 Frames           */
                              /*   aufgetrennt wurden                     */
                              /*    TRUE  = das naechste Frame gehoert zu */
                              /*            diesem Paket                  */
                              /*    FALSE = sonst                         */
    char             l4trie;  /*   Versuche in Level 4                    */
    unsigned         l4time;  /*   Timeout in Level 4                     */
#ifndef BOXFIRM
    char             rsvd[13];/*   (damit insgesamt Laenge wie mb)        */
#else
    char             rsvd[14];/*   (damit insgesamt Laenge wie mb)        */
#endif
  } MBHEAD;



/* ACHTUNG: mb muss genauso lang sein wie mbhead !                        */

typedef struct mb             /* "message buffer",                        */
  {                           /* allgemeiner Datenbuffer :                */
    struct mb *nextmb;        /*   naechster Eintrag in Liste             */
    struct mb *prevmb;        /*   vorheriger Eintrag in Liste            */
    char       data[32];      /*   Daten                                  */
  } MB;



typedef char STENTRY;         /* komprimierte Statetable                  */


typedef struct stent          /* "state table entry",                     */
  {                           /* ein Eintrag in der State-Table :         */
    VOID       (* func)();    /*   Zustandsuebergangsfunktion             */
    char       newstate;      /*   neuer Zustand                          */
  } STENT;




/* Ende von L2.H */
