/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    L234.H  -	  Headerfile mit Definitionen fuer L3 und L4		 *
*									 *
*    angelegt:	  DF6LN aus TNTYP.H von DF2AU - neue Typendeklarationen	 *
*		  passend zum L2					 *
*    modifiziert:							 *
*									 *
\************************************************************************/

#ifndef	L7INC
#define L234INC
#endif
#include "l2.h"


/*---------------------------------------------------------------------------*/

#define	L3CPID		0xcf	/* PID TheNet Layer 3 Frames		     */
#define	WEGE		2	/* Wege fuer Knoteneintrag		     */
#ifndef L7INC
#define L3HDRLEN (2*L2IDLEN+1)	/* L3-Header: 2 Calls + Lifetime	     */
#define L3FLOCKED	0x01	/* fuer Nachbareintrag blockiert	     */
#define L3FNBROK	0x02	/* L2-Link zum Nachbarn ist connected	     */

#define L4HDRLEN	5	/* (2 * Circuit-Id + -Index) + Opcode	     */
#endif

/* L4-Circuit-States aehnlich wie L2S...				     */

#define	L4SDSCED	0	/* disconnected - Circuit nicht belegt	     */
#define	L4SLKSUP	1	/* link setup				     */
#define	L4SCONN		2	/* connected				     */
#define	L4SDSCRQ	3	/* disconnect requested			     */

/* L4-Meldungen wie L2M...						     */

#define	L4MNIX		0	/* keine Meldung			     */
#ifndef L7INC
#define	L4MCONNT	1	/* CONNECTED to				     */
#define	L4MDISCF	2	/* DISCONNECTED from			     */
#define	L4MBUSYF	3	/* BUSY from				     */
#define	L4MFAILW	4	/* FAILURE with				     */

/* L4-Control wie L2C...						     */

#define	L4CCONREQ	0x01	/* Connect Request			     */
#define L4CCONACK	0x02	/* Connect Acknowledge			     */
#define L4CDISREQ	0x03	/* Disconnect Request			     */
#define L4CDISACK	0x04	/* Disconnect Acknowledge		     */
#define L4CINFTRA	0x05	/* Information Transfer			     */
#define L4CINFACK	0x06	/* Information Acknowledge		     */

/* L4-Control, spezielle Bits fuer Opcode				     */

#define L4CCHOKE	0x80	/* Choke				     */
#define L4CNOACK	0x40	/* No Acknowledge			     */
#define	L4CMORE		0x20	/* More Follows				     */

/* L4-Flags								     */

#define L4FRBS		0x20	/* Device Busy				     */
#define L4FDBS		0x40	/* Remote Device Busy			     */
#define	L4FDSLE		0x80	/* disconnect if send list empty	     */

#define L4FNXTACK	0	/* notwendige Antwort: ACK		     */
#define L4FNXTNAK	1	/* notwendige Antwort: NAK		     */
#define L4FNAKSENT	2	/* NAK wurde gesendet			     */
#endif

/* Typdefinitionen 							     */

typedef	struct	nbrtyp {		/* Nachbarliste			     */
	LHEAD	nbrlnk;			/* Link innerhalb der Liste	     */
	char	nbrcal[L2IDLEN];	/* Call				     */
	char	nbrdil[2*L2IDLEN+1];	/* 2 Digipeater			     */
#ifndef BOXWARE
	char	nbrpor;			/* Port				     */
#endif
	char	pathqu;			/* Qualitaet des Weges		     */
	char	nbrflg;			/* Flag: Eintrag gesperrrt j-n	     */
	UWORD	nbrrou;			/* Wege ueber diesen Nachbarn	     */
	LNKBLK	*nbrl2l;		/* Querverweis zur Level2 Tabelle    */
	} NBRTYP;

typedef	struct	wegtyp {
	char	qualit;		/* Qualitaet				     */
	char	obscnt;		/* Lebensdauer Zaehler			     */
	char	lifeti;		/* Restlebensdauer von L3-Frames	     */
	NBRTYP	*nachba;	/* Nachbar				     */
	} WEGTYP;

typedef	struct	nodtyp {	/* Nodeliste				     */
	LHEAD	nodlnk;		/* Link innerhalb der Liste		     */
	char	actrou;		/* aktive Wege zu diesem Ziel		     */
	char	nodide[L2CALEN];/* Ident dieses Zieles			     */
	char	nodcal[L2IDLEN];/* Call des Zieles			     */
	char	wegnr;		/* Nummer des aktiven Weges		     */
	char	wege;		/* moegliche Wege			     */
	WEGTYP	weg[WEGE];	/* Wegbeschreibungen			     */
	LHEAD	nodinf;		/* Frames fuer dieses Ziel		     */
        } NODTYP;

typedef	struct	cirtyp {	/* Level 4 Kontrollblock		     */
	char	state4;		/* Status: 0=leer, 1=ConReq, 2=Con, 3=DisReq */
	char	idxpar;		/* Partner Index			     */
	char	ideige;		/* eigener ID				     */
	char	idpart;		/* Partner ID				     */
	char	downca[L2IDLEN];/* Downlink Call			     */
	char	upcall[L2IDLEN];/* Uplink Call				     */
	char	window;		/* Fenstergroesse			     */
	char	l4rxvs;		/* letzte bestaetigte Framenummer	     */
	char	l4vs;		/* letzte gesendete Framenummer		     */
	char	l4vr;		/* letzte erhaltene Framenummer		     */
	char	l4rs;		/* notwendige Antwort: 0=ACK, 1=NAK, 2=NAKweg*/
	char	l4try;		/* Transport Versuche			     */
	char	l4flag;		/* DISC-req, selbst choked, Partner choked   */
	UWORD	traout;		/* Transport Timeout			     */
	UWORD	acktim;		/* Acknowledge Timer			     */
	UWORD	tranoa;		/* no-activity-Timeout			     */
	UWORD	numrx;		/* empfangene Frames			     */
	UWORD	numtx;		/* zu sendende Frames			     */
#ifndef BOXWARE
	MBHEAD   *fragme;	/* Fragment eines kommenden Frames	     */
#else
	char	dir;		/* 0=selbst connected, 1=Connect von aussen  */
#endif
	NODTYP	*l3node;	/* Node fuer diesen Circuit		     */
	LHEAD	mbhdrx;		/* Listenkopf empfangene Frames		     */
	LHEAD	mbhdtx;		/* Listenkopf zu sendende Frames	     */
	LHEAD	mbhdos;		/* Listenkopf: Frames ausserhalb der Folge   */
	char	upnod[L2IDLEN]; /* Uplinkknoten des Users		     */
	char	upnodv[L2VLEN+1];/* Digikette beim Uplink		     */
	} CIRTYP;

typedef struct	partyp		/* Parameter				     */
 {
  UWORD	*paradr;		/* Adresse des Parameters		     */
  UWORD	minimal;		/* Minimalwert				     */
  UWORD	maximal;		/* Maximalwert				     */
 } PARTYP;

/*--- Ende der Definitionen -------------------------------------------------*/
