/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*	L2A.C	- Level 2, Teil 1					 *
*									 *
*    angelegt:		DC4OX						 *
* modifiziert:	200391	DF6LN	Update MH-Liste bei TheNet		 *
*		301291	DF6LN	Kopie an Monitor nur wenn Monitor on	 *
*		150792	DF6LN	Reaktion auf S-Frames verkuerzt		 *
*		270892	DF6LN	I-Frames erst nach T2 senden		 *
*		270892	DF6LN	keine Reaktion auf UI mit Poll		 *
*									 *
\************************************************************************/


/*							Includes	*/
/************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			*/
#include "l2.h"		/* Festlegungen/Datenstrukturen fuer Level 2	*/
#include "l2s.h"	/* Zugriff auf die State-Tabellen		*/
#include "l2ext.h"	/* globale Variable / nicht int-Funktionen	*/





/************************************************************************\
*									 *
*	"level 2"							 *
*									 *
* Der Level 2. Es werden alle Level-2-internen Aktionen ausgefuehrt und	 *
* Meldungen an hoehere Level weitergegeben (Informationstransfer von/zum *
* Level 2 und Kommandos an den Level 2 geschehen von ausserhalb).	 *
*									 *
*									 *
* Der Level 2 laeuft wie folgt ab:					 *
*									 *
*   - Aufruf von l2init()						 *
*									 *
*   - zyklisches Aufrufen von l2() und l2timr(ticks)			 *
*									 *
*   Statusaenderungen im Level 2 (Connects, Disconnects, Failures, usw.) *
*   werden hoeheren Leveln vom Level 2 aus ueber			 *
*									 *									      *
*      l2tolx(<status>) -> l2tol3(<status>), lxtol7(<status>,lnkpoi,2)	 *
*									 *
*   mitgeteilt.								 *
*									 *
*   Ein Connectwunsch wird dem Level 2 ueber das Besetzen eines leeren	 *
*   Linkblocks mit Quell- und Ziel- sowie Digicalls und Aufrufen von	 *
*   newlnk() mitgeteilt (lnkpoi zeigt auf Linkblock !).	Ein Aufruf von	 *
*   newlnk() auf einen bestehenden Link erzeugt einen Link Reset.	 *
*									 *
*   Ein Disconnectwunsch (oder bei mehrmaligem Aufruf der sofortige	 *
*   Disconnect) wird ueber das Setzen von lnkpoi auf den jeweiligen	 *
*   Linkblock und Aufruf von dsclnk() erreicht.				 *
*									 *
*   Der Informationstransfer zum Level 2 geschieht von aussen durch	 *
*   Aufruf von itolnk(...), vom Level 2 durch itolx(..), welches dann	 *
*   fmlink() aus dem hoeheren Level aufruft.				 *
*									 *
*   Ueber sdui(..) koennen unproto-Pakete (UI-Frames) gesendet werden.	 *
*									 *
*   Level-3-Pakete (Level-3-UI-Pakete oder Infopakete in Sequenz eines	 *
*   Level-2-3-Links) werden ausgefiltert und in die Level-3-Frameliste	 *
*   eingehaengt.							 *
*									 *
\************************************************************************/

/* wird jetzt in mainf() erledigt					*/
/*VOID l2()
/* {
/*  l2tx();				/* der Sender			*/
/*  l2rx();				/* der Empfaenger		*/
/*  l2rest();				/* sonstiges			*/
/* }
*/

/************************************************************************\
*									 *
* "level 2 transmitter"							 *
*									 *
* Falls Infopakete zu senden sind, laut Sendefenster keine Infopakete	 *
* ausstehen, und laut Sendestatus auch gesendet werden duerfen, diese	 *
* senden.								 *
*									 *
* Frames aus Gesendet-Liste holen und in die Monitorframeliste umhaengen *
* (Firmware, Boxware) oder deallokieren. Entsprechend dem Frameinhalt	 *
* ggf. Timer 1 starten.							 *
*									 *
\************************************************************************/

VOID l2tx()
 {
  unsigned  l2state;		/* aktueller Linkstate			*/
  MBHEAD   *sfbp;		/* Sendeframebufferpointer	        */

  lnkpoi = lnktbl;
  do
   {
    if (((l2state = lnkpoi->state) == L2SIXFER	/* duerfen wir was senden?   */
           || l2state == L2SRS
           || l2state == L2SDBS
           || l2state == L2SRSDBS))
      {
      if ((lnkpoi->VS == lnkpoi->lrxdNR)	/* nichts ausstehend?	     */
#ifndef BOXFIRM
          && (!DLflag() ||  !(lnkpoi->T2))	/* T2 warten vorm senden     */
#endif
					  )
       {
#ifdef FIRMWARE
	sdi(lnkpoi->k);				/* dann Infos senden	     */
#else
#ifdef BOXWARE
	sdi(Opar);
#else
	sdi(lnkpoi->liport == HDLCPORT ? Opar : Opar1);
#endif
#endif
       }
     }
   } while (++lnkpoi < &lnktbl[LINKNMBR]);

  while ((sfbp = stfl.head) != &stfl)	/* Gesendetliste aufraeumen:	     */
   {
    unlink(sfbp);			/* Frame holen			     */
    if ((sfbp->l2fflg & L2FT1ST) != 0)	/* ist T1 zu starten?		     */
     {
      lnkpoi = sfbp->l2link;		/* ja, Zeiger auf Linkblock (zum     */
      setT1();				/* Frame) und T1 starten	     */
     }

#ifdef BOXFIRM
    if ((nmbfre > 64)			/* falls noch genug Platz und	     */
	&& (Mpar != 0))			/* Monitor eingeschaltet, Frame	     */
      relink(sfbp,monfl.tail);		/* in den Monitor		     */
    else
#endif

      dealmb(sfbp);			/* oder deallokieren		     */
   }
 }


STENTRY *sfrtab[8] = {	stbl11, stbl10, stbl03, stbl02,
			stbl15, stbl14, stbl07, stbl06 };


/*****************************************************************************\
*									      *
* "level 2 receiver"							      *
*									      *
* Alle Frames aus der RX-Frameliste holen und analysieren. Kopie an Monitor-  *
* liste, digipeaten oder in Level-3-Liste, falls erforderlich. Auf UI-Frames  *
* antworten, falls erforderlich.					      *
*									      *
* Reaktion entsprechend Protokoll, siehe unten. Oder eben nicht protokollge-  *
* maess, sondern verzoegert, bei eingeschalteter L2-Modifikation. Dann wird   *
* nach Aussendung eines I-Frames Timer2 gesetzt ohne anschliessende Antwort.  *
* Zusammen mit dem Wert von Timer 1 kann dann festgestellt werden, wie lange  *
* vor Aussendung eines neuen I-Frames gewartet werden muss, damit immer min-  *
* destens die fuer Timer 2 eingestellte Zeit gewartet wird, unabhaengig von   *
* der Reaktionszeit der Gegenstation.                                         *
*									      *
\*****************************************************************************/

VOID l2rx()
 {
  MBHEAD   *fbp;		/* Framebufferpointer lokal		     */
  unsigned  l2state;		/* aktueller Level 2 Linkstatus		     */
  BOOLEAN   tome;		/* TRUE = Frame ist an mich		     */
  LNKBLK   *lblkp;		/* Linkblockpointer lokal		     */
  unsigned  frtyp;
  char     *source;		/* Zeiger auf Quellrufzeichen/SSID	     */
  unsigned  n;

  while ((fbp = rxfl.head) != &rxfl) /* solange empfangene Frames vorhanden  */
   {
    unlink(fbp);		/* eins aus Liste holen */

    if (!takfhd(fbp))		/* Kopf analysieren, wenn nicht ok, dann     */
     {
      dealmb(fbp);		/* wegwerfen und zum naechsten Frame	     */
      continue;
     }

    fbp->type = 2;			/* wir sind im Level 2		     */
#ifndef BOXFIRM
    if (!(Flags & 2048)) updhrd();	/* Update MH-Liste		     */
#else
    if ((nmbfre > 64)			/* falls noch genug Platz und	     */
	&& (Mpar != 0))			/* Monitor eingeschaltet,	     */
      relink(cpyfb(fbp),monfl.tail);	/* Kopie an Monitor		     */
#endif
#ifndef BOXWARE
    if (digipt(fbp) == TRUE) continue;	/* ... nur Digipeater		     */
#endif
    if (rxfctl == L2CUI)		/* UI-Frame			     */
     {
/*      if (istome(rxfhdr) == TRUE)	/* wenn an mich ..		     */
/*       {
/*        if (rxfPF != FALSE		/* .. und Antwort gewuenscht ..	     */
/*	    && rxfCR != FALSE)
/*	 {
/*	  xdm();			/* beantworten mit DM		     */
/*
/* Dies ist ein Protokollverstoss! Nach AX.25-Protokoll soll auf ein UI-     */
/* Frame mit Poll nur dann mit DM geantwortet werden, wenn kein Link be-     */
/* steht. Wenn dagegen ein Link besteht, soll entsprechend Linkzustand	     */
/* geantwortet werden. Dies gibt aber gluecklicherweise kaum Probleme, da    */
/* nur eine aeltere Version der TAPR-Software ueberhaupt UI-Frames mit Poll  */
/* gesendet hat. Aus Platzgruenden wird vorerst darauf verzichtet, den Feh-  */
/* ler zu beseitigen. Statt dessen wird der Fehler so geaendert, dass auf    */
/* eine Reaktion hier vollkommen verzichtet wird. Manche Spielkinder hatten  */
/* ausserdem bemerkt, dass man einen Knoten abschiessen kann, wenn man ihm   */
/* in einer Aussendung beliebig viele UI-Frames mit Poll schickt. Dadurch    */
/* werden naemlich fuer die Antwort-Frames beliebig viele Buffer belegt, bis */
/* der Knoten einen Reset ausloest. Auch deshalb ist es guenstiger, hier auf */
/* eine Reaktion zu verzichten.						     */
/*	 }
/*       }
*/
      lnkpoi = NULL;			/* fuer tol3sw()		     */
      if (!tol3sw(fbp))			/* Level 3 UI-Frame?		     */
       {
        dealmb(fbp);			/* nein -> weg damit		     */
       }
      continue;				/* naechstes Frame		     */
     }


/* Haben wir einen zum Frame passenden Linkblock?			     */
/*									     */
/* Alle Linkbloecke durchgucken. Wenn ein aktiver Linkblock gefunden wurde,  */
/* dessen Quellcall mit dem Framezielcall uebereinstimmt, tome auf TRUE	     */
/* setzen. Wenn auch noch Blockport mit Frameport und Blockzielcall mit	     */
/* Framequellcall uebereinstimmen, dann ist der aktive passende Link gefun-  */
/* den, Schleife abbrechen.						     */
/*									     */
/* Falls ein Link inaktiv ist, aber das Framezielcall an mich (Call + SSID   */
/* oder Ident mit beliebiger SSID) ist, oder das Blockquellcall mit dem	     */
/* Framezielcall uebereinstimmt, dann Blockadresse in lblkp merken. Es wird  */
/* nur der erste solche Block genommen.					     */

    tome = FALSE;
    lblkp = NULL;
    lnkpoi = lnktbl;
    do
     {
      if (lnkpoi->state != L2SDSCED)
       {
        if ((cmpid(lnkpoi->srcid,rxfhdr) == TRUE)
#ifndef BOXFIRM
	   && (lnkpoi->liport == rxfprt)
#endif
						 )
         {
          tome = TRUE;
          if (cmpid(lnkpoi->dstid,rxfhdr + L2IDLEN) == TRUE)
           {
	    break;
           }
         }
       }
      else
       {
        if (!lblkp
            && ((*lnkpoi->srcid == '\0' && istome(rxfhdr) == TRUE)
                || (*lnkpoi->srcid != '\0'
		    && cmpid(lnkpoi->srcid,rxfhdr) == TRUE)
               )
           )
	 {
	  lblkp = lnkpoi;
	 }
       }
     } while (++lnkpoi < &lnktbl[LINKNMBR]);

    if (lnkpoi == &lnktbl[LINKNMBR])	/* wenn kein aktiver Link passt, ..  */
     {
      if (lblkp)			/* .. aber inaktiver Link, ..	     */
       {
        lnkpoi = lblkp;			/* .. dann diesen nehmen	     */
       }
      else				/* sonst, wenn alle Links belegt ..  */
       {
        if (tome == TRUE		/* .. und Frame trotzdem an mich ge- */
            || istome(rxfhdr) == TRUE)	/* richtet ist, reagieren:	     */
         {
          if (rxfctl == L2CSABM)	/* wenn SABM gekommen ist	     */
           {
#ifdef FIRMWARE
            l2tolx(L2MBUSYT);		/* hoeheren Leveln melden, dass mit  */
            				/* DM geantwortet werden musste	     */
#endif
	    xdm();
           }
          else				/* wenn nicht SABM		     */
           {
            if (rxfPF != 0 && rxfCR != 0) /* aber Command mit Poll, dann ..  */
	     {
	      xdm();			/* .. mit DM antworten		     */
             }
            else			/* oder wenn kein Command / Poll ..  */
             {
              if (rxfctl == L2CDISC)	/* .. aber ein DISC, .. 	     */
               {
                xua();			/* .. dann mit UA antworten	     */
               }
             }
           }
         }
        dealmb(fbp);			/* empfangenes Frame wegwerfen und   */
        continue;			/* zum naechsten		     */
       }
     }


/* Falls Timer 3 aktiv, diesen neu setzen, es ist wieder Aktivitaet auf dem  */
/* Link.								     */

    if (lnkpoi->T3 != 0) setT3();
    l2state = lnkpoi->state;		/* Linkstatus zur Abfrage	     */

    if (!(rxfctl & L2CNOIM))		/* I-Frame?			     */
     {

/* I-Frame:								     */
/*									     */
/* Nur annehmen, wenn empfangene N(R) des Frames ok, srxdNR(), und das I-    */
/* Frame das naechste erwartete in der Sequenz ist, isntxi().		     */
/* Wenn alles ok, Laenge pruefen und ggf. auf falsche Laenge mit Framereject */
/* reagieren, sonst Antwort entsprechend Statetable und I-Frame verarbeiten. */

      if (srxdNR() == TRUE			/* N(R) ok?		     */
          && isnxti() == TRUE)			/* erwartet?		     */
       {
	if (morinb(fbp) <= INFOLEN+1)		/* Laenge max. Info + PID    */
         {
          l2stma(stbl01);		    /* reagieren nach Statetable     */
          if (l2state >= L2SIXFER 	    /* nach Linkzustand I-Transfer   */
	      && !(lnkpoi->flag & L2FBUSY)) /* moeglich und nicht busy?	     */
           {
            if (tol3sw(fbp) == TRUE)	/* wenn Level-3-I-Frame, dann in     */
             {				/* Level-3-RX-Liste einhaengen	     */ 
              lnkpoi->flag |= L2FL3LNK;	/* und Link als L3-Link markieren    */
              snoato();			/* No-Activity-Timeout neu starten   */
             }
            else			/* normales Level-2-I-Frame	     */
             {
              if (!(lnkpoi->flag		/* wenn nicht busy oder	     */
	            & (L2FDSLE | L2FL3LNK)))	/* Level-3-Link, ..	     */
               {
                relink(fbp,lnkpoi->rcvdil.tail); /* I annehmen und in Link-  */
		++lnkpoi->rcvd;			 /* empfangsliste einhaengen */
               }
              else
               {
                dealmb(fbp);	/* ansonsten Frame wegwerfen		     */
               }
             }
            continue;		/* auf zum naechsten Frame		     */
           }
         }
        else			/* Frame zu lang:			     */
         {
          sfrmr3();		/* "U/S-Frame mit unerlaubtem Infofeld"	     */
         }
       } /* N(R) ok + erwartet */
     } /* I-Frame */

    else                                 /* kein I-Frame:		     */
     {
      if (!(rxfctl & L2CNOSM))
       {

/* S-Frame:								     */
/*									     */
/* Nur annehmen, wenn empfangene N(R) des Frames ok, srxdNR(), und wenn das  */
/* Frame kein Infofeld enthaelt. Auf RR, RNR, REJ entsprechend Statetable    */
/* antworten, auf andere mit Framereject antworten.			     */

	if (!morinb(fbp))			/* kein I-Feld?		     */
	 {
	  if ((frtyp = rxfctl & 0x0c) == 0x0c)	/* Kontrollfeld falsch oder  */
	   {					/* nicht implementiert	     */
	    sfrmr1();
           }
	  else
	   {

/* In frtyp wird jetzt ausser den 2 Bits des Kontrollfelds zusaetzlich das   */
/* C/R-Bit und das P/F-Bit eingebaut. Damit sind hier noch die Werte 0x00    */
/* bis 0x0b moeglich (0x0c und hoeher wurde schon mit frmr beantwortet).     */
/* Ausserdem werden REJ-Frames ueber die gleiche Statetabelle behandelt, wie */
/* RR-Frames, und damit sind fuer die zusaetzliche Tabelle mit den jeweils   */
/* bei l2stma zu verwendenden Daten nur noch 8 verschiedene Eintraege not-   */
/* wendig.								     */

	    if (rxfPF != 0) frtyp |= 1;
	    if (rxfCR != 0) frtyp |= 2;
            if (srxdNR() == TRUE)		/* N(R) ok?		     */
	     {
	      l2stma(sfrtab[frtyp & 0x07]);	/* L2CREJ wie L2CRR	     */
	      if ((frtyp & 0x0c) == 0x08)	/* wenn L2CREJ		     */
	       {
	        if (l2state >= L2SIXFER) sdoi();
	       }
	     }
           }
	 }
        else
         {
          sfrmr3();		/* "U/S-Frame mit unerlaubtem Infofeld"      */
	 }
       } /* end S-Frame */
      else				/* kein I- oder S-Frame:	     */
       {
        if ((rxfctl & 0xFF) != L2CFRMR)	/* Kein FRMR-Frame ..		     */
         {
	  if (!morinb(fbp))		/* .. nur annehmen ohne Infofeld!    */
           {
            switch (rxfctl)	/* auswerten u. nach Statetable antworten    */
             {
	      case L2CSABM:		/* neuer Link / Linkreset	     */
                lnkpoi->V2link = rxfV2;	/* Protokollversion merken	     */
                switch (l2state)
                 {
                  case L2SDSCED:			 /* neuer Link?	     */
                    if (fvalca(VCpar,			 /* Call ok?	     */
			       rxfhdr + L2IDLEN) == TRUE
                        && nmblks < Ypar		 /* Link frei?	     */
                        && nmbfre > 128)		 /* noch Platz?	     */
                     {
		      inilnk();		/* annehmbar - Link initialisieren   */
                      ++nmblks;		/* ein Link mehr		     */
                      l2tolx(L2MCONNT);	/* melden an hoehere Level	     */
                      snoato();		/* No-Activity-Timeout setzen	     */
                      break;		/* -> Statetable		     */
                     }
#ifdef FIRMWARE
                    l2tolx(L2MBUSYT);	/* nicht annehmbar - melden	     */
#endif
                    xdm();		/* mit DM antworten		     */
                    dealmb(fbp);	/* Frame vergessen		     */
                    continue;		/* naechstes Frame		     */
                  break;

                  case L2SLKSUP:			/* beide connecten   */
		    if (!cmpidl(cmpid(rxfhdr + L2IDLEN,	/* anderer Weg als   */
				      lnkpoi->srcid)	/* selbst benutzt?   */
			        == TRUE
                                ? rxfhdr + L2ILEN
                                : txfhdr + L2ILEN,
				lnkpoi->viaidl))
                      {
                       clrlnk();		/* ja, alles abbrechen	     */
                       l2tolx(L2MBUSYF);
                       xdm();
                       lnkpoi->state = L2SDSCED;
                       dealmb(fbp);
                       continue;
                      }
                     else
                      {
                       reslnk();	       /* nein, gelungener Connect   */
                       l2tolx(L2MCONNT);       /* melden an hoehere Level    */
                       snoato();	       /* No-Activity-Timeout setzen */
                      }
                  break;

                  case L2SDSCRQ:	/* sind disconnected, Link aufloesen */
                    mclrlk();		/* und melden			     */
                  break;

                  default:		/* normaler Linkreset vom Partner    */
                    inilnk();
#ifdef FIRMWARE
                    l2tolx(L2MLRESF);	/* an hoehere Level melden	     */
#endif
                  break;

                 } /* end switch (l2state) */
                l2stma(stbl08);			/* SABM EITHER COMMAND	     */
              break;

              case L2CDISC:
                if (!l2state)		/* Link aktiv?			     */
                 {
                  if (rxfPF != 0	/* nein, wenn Command mit Poll,	     */
                      && rxfCR != 0)	/* dann mit DM antworten	     */
	           {
	            xdm();
	           }
		  else			/* nicht Command + Poll		     */
	           {
                    xua();		/* also mit UA antworten	     */
	           }
                  dealmb(fbp);		/* Frame wegwerfen		     */
                  continue;		/* naechstes Frame		     */
                 }
                else				/* ja, Link aktiv	     */
	         {
                  if (l2state == L2SLKSUP)	/* wenn im Linkaufbau ..     */
                   {
                    clrlnk();		/* .. dann Link sofort aufloesen ..  */
                    l2tolx(L2MBUSYF);	/* .. und nach oben melden	     */
                   }
                  else			/* nicht Linkaufbau:		     */
                   {
                    i2tolx(TRUE);	/* erst restliche Info hochgeben     */
                    mclrlk();		/* Link loesen und nach oben melden  */
                   }
	         }
		l2stma(stbl09);		/* DISC EITHER COMMAND		     */
              break;

              case L2CUA:
                if (l2state < L2SRS)	    /* V1-Zustand?		     */
                 {
                  if (l2state == L2SLKSUP)  /* ja, wenn im Linksetup ..      */
                   {
                    lnkpoi->V2link = rxfV2; /* Protokollversion uebernehmen  */
                    reslnk();		    /* Link neu			     */
                    l2tolx(L2MCONNT);	    /* an hoehere Level melden	     */
                    snoato();		    /* No-Activity-Timeout setzen    */
                   }
                  else				/* nicht Linksetup	     */
	           {
                    if (l2state == L2SDSCRQ)	/* wenn Disc-Request	     */
                     {
                      mclrlk();			/* Link aufloesen	     */
                     }
                   }
                 }
                else				/* nicht V1-Zustand	     */
                 {
                  reslnk();			/* Linkreset ausfuehren	     */
#ifdef FIRMWARE
                  l2tolx(L2MLREST);		/* und melden		     */
#endif
                 }
                l2stma(stbl16);			/* UA EITHER RESPONSE	     */
              break;

              case L2CDM:
                if (l2state)			/* wenn Link aktiv ..	     */
                 {
                  if (l2state == L2SLKSUP)	/* wenn DM beim Linksetup .. */
                   {
                    clrlnk();			/* Link sofort aufloesen und */
                    l2tolx(L2MBUSYF);		/* "Busy from" melden	     */
                   }
                  else				/* sonst Link aufloesen	     */
                   {
                    mclrlk();			/* mit Meldung		     */
                   }
                 }
                l2stma(stbl17);			/* DM EITHER RESPONSE	     */
              break;

              default:		/* unbekanntes Kontrollfeld:		     */
                sfrmr1();	/* "Kontrollfeld falsch oder nicht	     */
              break;		/* implementiert"			     */

             } /* end switch (rxfctl) */
           }
          else			/* Frametyp unbekannt			     */
           {
            sfrmr3();		/* "U/S-Frame mit unerlaubtem Infofeld"	     */
           }
         }
        else /* zu if (rxfctl != L2CFRMR) */
         {

/* FRMR-Frame:								     */
/*									     */
/* Wird nur im Frame-Reject-Zustand oder bei moeglichem Informationstransfer */
/* angenommen. Es werden die FRMR-Infobytes gelesen, FRMR an die hoeheren    */
/* Level gemeldet, und nach Statetable geantwortet.			     */

#ifndef BOXWARE
	  if (l2state >= L2SIXFER || l2state == L2SFRREJ)
           {
#ifdef FIRMWARE
/* FRMR-Infobytes im Linkblock merken (wird nur bei TheFirmware ausgewertet) */
            for (source = lnkpoi->frmr, n = 0; n < 3; ++n)
	      *source++ = (morinb(fbp) != 0) ? getchr(fbp) : 0;
#endif
	    l2tolx(L2MFRMRF);
	   }
#endif
	  l2stma(stbl18);		/* FRMR EITHER RESPONSE		     */
         }
       } /* kein I- o. S-Frame */
     } /* kein I-Frame */
    dealmb(fbp);		/* aktuelles Frame verarbeitet, wegwerfen    */
   } /* end while */
 }




/*****************************************************************************\
*									      *
* "level 2 rest"							      *
*									      *
* Fuer alle aktiven Links Busyzustand pruefen/setzen/aufloesen, I-Frames      *
* unter Beruecksichtigung der "Erstickungskontrolle" an hoehere Level weiter- *
* reichen. Fall Zustand "Disconnecten nach Uebertragung der restlichen I-     *
* Frames" und keine I-Pakete mehr zu senden, Disconnect einleiten.	      *
* Muellbufferliste frei machen (aus Interruptroutinen entstandener Muell, der *
* besser ausserhalb der Interrupts deallokiert wird aus Zeitgruenden).	      *
*									      *
\*****************************************************************************/

VOID l2rest()
 {
  lnkpoi = lnktbl;
  do
   {
    if (lnkpoi->state != L2SDSCED)	/* fuer alle aktiven Links:	     */
     {
      getV2();				/* Protokollversion holen	     */

/* wenn Zustand "nachdem alle restliche I's uebertragen wurden,		     */
/* disconnecten" und alle I's uebertragen, DISC einleiten		     */

      if (((lnkpoi->flag & L2FDSLE) != FALSE)
          && !lnkpoi->tosend)
       {
	disc();
       }

/* sonst empfangene I-Pakete an hoeheren Level uebertragen und Busy-	     */
/* Condition pruefen / setzen / aufheben				     */
/*									     */
/* "Busy werden"	-	weniger als 80 Freibuffer oder so viele	     */
/*				I-Pakete empfangen und nicht abgeholt, wie   */
/*				"Erstickungszaehler" conctl angibt	     */
/*									     */
/* "Busy aufloesen"	-	wieder mehr als 112 Freibuffer und weniger   */
/*				als halb so viele empfangen und nicht abge-  */
/*				holt wie conctl angibt			     */

      else
       {
        i2tolx(FALSE);
        if (!(lnkpoi->flag & L2FBUSY))		/* nicht busy		     */
         {
          if (nmbfre < 80 || lnkpoi->rcvd >= conctl)
           {
            lnkpoi->flag |= L2FBUSY;		/* busy werden		     */
            l2stma(stbl21);			/* STATION BECOMES BUSY	     */
           }
         }
        else
         {
          if (nmbfre > 112 && lnkpoi->rcvd < conctl/2)
           {
            lnkpoi->flag &= ~L2FBUSY;		/* "busy" aufloesen	     */
            l2stma(stbl22);			/* BUSY CONDITION CLEARS     */
           }
         }
       }
     } /* end if (lnkpoi->state) */
   } while (++lnkpoi < &lnktbl[LINKNMBR]);
  dealml(&trfl);			/* Muellbufferliste frei machen	     */
 }





/*****************************************************************************\
*									      *
* "level 2 timer"							      *
*									      *
* Ausfuehren der Level-2-Millisekundentimer 1, 2, 3 in allen aktiven Links    *
* (herunterzaehlen und bei Ablauf reagieren).				      *
* In ticks wird die Anzahl der vergangenen 10ms-Intervalle (Ticks) seit dem   *
* letzten Aufruf dieser Routine angegeben.				      *
*									      *
* Reaktion bei Ablauf von T2 geaendert fuer L2-Modifikation, so dass auch mit *
* gesetztem Final-Bit reagiert werden kann.				      *
*									      *
\*****************************************************************************/

VOID l2timr(ticks)
unsigned ticks;
 {
  lnkpoi = lnktbl;
  do
   {
    if (lnkpoi->state != L2SDSCED)	/* fuer alle aktiven Links:	     */
     {
      getV2();				/* Merker ob Version-2-Protokoll     */

      if (lnkpoi->T1 != 0)		/* wenn Timer 1 aktiv ..	     */
       {
        if (lnkpoi->T1 <= ticks)	/* wenn Timer 1 abgelaufen ..	     */
         {
          lnkpoi->T1 = 0;		/* .. Timer 1 stoppen		     */
          setT3();			/*	Timer 3 neu starten	     */
          ++lnkpoi->tries;		/*	Retryzaehler		     */
#ifdef FIRMWARE
          if (!lnkpoi->N2
              || lnkpoi->tries < lnkpoi->N2)	/* zu viele Retries?	     */
#else
          if (!Npar || lnkpoi->tries < Npar)
#endif
           {
            if (lnkpoi->V2link == TRUE		/* nein, bei V2 oder	     */
                || lnkpoi->state < L2SIXFER)	/* V1-Status < IXFER	     */
	     {
              l2stma(stbl23);			/* Statettable T1 EXPIRES    */
	     }
            else		/* sonst ausstehende I's senden		     */
	     {
	      sdoi();
	     }
           }
          else				/* zu viele Retries:		     */
           {
            lnkpoi->tries = 0;		/* Retryzaehler leer		     */
            clrlnk();			/* Link sofort loeschen		     */
            l2tolx(L2MFAILW);		/* "Link failure" melden	     */
            lnkpoi->state = L2SDSCED;	/* DISCONNECTED			     */
           }
         }
        else
	 {
          lnkpoi->T1 -= ticks;		/* sonst herunterzaehlen	     */
         }
       } /* Timer 1 aktiv */

      if (lnkpoi->T2 != 0)		/* wenn Timer 2 aktiv ..	     */
       {
        if (lnkpoi->T2 <= ticks)	/* wenn Timer 2 abgelaufen ..	     */
	 {
          lnkpoi->T2 = 0;		/* .. Timer 2 stoppen		     */
         }
        else
	 {
	  lnkpoi->T2 -= ticks;		/* sonst herunterzaehlen	     */
	 }
       }

      if (!lnkpoi->T2			/* wenn Timer 2 abgelaufen ist	     */
          && lnkpoi->RStype != 0	/* und Response zu senden ist	     */
#ifndef BOXFIRM
	  && !iscd(lnkpoi->liport))	/* und der Kanal frei ist ..	     */
#else
	  && !iscd())			/* und der Kanal frei ist ..	     */
#endif
       {
#ifdef BOXFIRM
        stxfad();			/* .. dann Responseframe aufbauen    */
        txfCR = txfPF = 0;
        txfctl = setNR(!(lnkpoi->flag & L2FBUSY)
                       ? lnkpoi->RStype
                       : L2CRNR);
        sdmkfh(L2FUS);			/* und senden			     */
/*	lnkpoi->RStype = 0;		das ist zu lang .. ->		     */
	clrT2();			/* Responsemodus loeschen	     */
#else
	if ((lnkpoi->RStype != L2CRR)
	    || (!lnkpoi->tosend))
	 {
          stxfad();			/* .. dann Responseframe aufbauen    */
          txfCR = 0;
	  txfPF = lnkpoi->RStype & L2CPF;
          txfctl = setNR(!(lnkpoi->flag & L2FBUSY)
                         ? (lnkpoi->RStype & ~L2CPF)
                         : L2CRNR);
          sdmkfh(L2FUS);			/* und senden		     */
/*	  lnkpoi->RStype = 0;		das ist zu lang .. ->		     */
	  clrT2();			/* Responsemodus loeschen	     */
	 }
#endif
       }

      if (lnkpoi->T3 != 0)		/* wenn Timer 3 aktiv ..	     */
       {
        if (lnkpoi->T3 <= ticks)	/* wenn Timer 3 abgelaufen ..	     */
         {
          clrT3();			/* .. Timer 3 stoppen und	     */
          l2stma(stbl24);		/* Statetable T3 EXPIRES ausfuehren  */
         }
        else
	 {
	  lnkpoi->T3 -= ticks;		/* sonst herunterzaehlen	     */
	 }
       } /* Timer 3 aktiv */
     } /* Link aktiv */
   } while (++lnkpoi < &lnktbl[LINKNMBR]);
 }


/* Ende von L2A.C */
