/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*                                                                        *
*    L2E.C   -   Level 2, Teil 5                                         *
*                                                                        *
*                Dieser Teil ist eine Zusammenfassung der                *
*                zeitunkritischsten Funktionen und kann somit mit der    *
*                groessten Platzersparnis optimiert werden.              *
*                                                                        *
*                                                                        *
*    angelegt:      DC4OX                                                *
*    modifiziert:   DF6LN  291291 minmem() und maxmem() aus L1 gestrichen*
*		    DF6LN  240192 Infotext etc. auf Buffer umgestellt	 *
*                                                                        *
\************************************************************************/





/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "l2.h"          /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "l2s.h"         /* Zugriff auf die State-Tabellen                */
#include "l2ext.h"       /* globale Variable / nicht int-Funktionen       */





/**************************************************************************\
*                                                                          *
* action      :  "level 2 initialize"                                      *
*                                                                          *
*                Initialisieren des dynamischen Freispeichers sowie        *
*                aller Level-2-spezifischer Listen- und Framekoepfe.       *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  -                                                         *
*                                                                          *
* r/o globals :  (Routing-Table)                                           *
*                                                                          *
* r/w globals :  lnkpoi   - Zeiger in lnktbl                               *
*                rxfl     - "leere Liste"                                  *
*                monfl    - "leere Liste"                                  *
*                stfl     - "leere Liste"                                  *
*                trfl     - "leere Liste"                                  *
*                freel    - Liste freier 32-Byte-Buffer dynam. Speicher,   *
*                           jeder Buffer ist initialisiert :  mbpc, mbgc   *
*                           geloescht, mbbp initialisiert, mbl             *
*                           "leere Liste", Buffer der Routing-Table        *
*                           werden nicht neu allokiert bei Warmstart       *
*                nmblks   - 0                                              *
*                nmbfre   - Anzahl freie 32-Byte-Buffer dynam. Speicher    *
*                txl2fl[] - alle Listenkoepfe "leere Liste"                *
*                rxfhd[]  - alle Eintrage NULL                             *
*                txfhd[]  - alle Eintrage NULL                             *
*                lnktbl   - alle Linkbloecke werden initialisiert          *
*                           (rcvdil, sendil, rcvd, tosend, state, srcid    *
*                           loeschen, snglT1, k, N2, V2link setzen,        *
*                           reslnk() wird aufgerufen)                      *
*                                                                          *
* locals      :  s.u.                                                      *
*                                                                          *
* returns     :  -                                                         *
*                                                                          *
\**************************************************************************/

VOID l2init()
  {
#ifndef BOXFIRM
    unsigned    n;            /* Laufindex                                */
#endif
    char       *actbp;        /* Zeiger auf aktuellen Freibuffer          */
    char       *nextbp;       /* Zeiger auf naechsten Freibuffer          */

    inithd(&rxfl);            /* diverse Listenkoepfe = "leere Liste"     */
#ifdef BOXFIRM
    inithd(&monfl);           /* Monitor nur bei Firmware und Boxware     */
#endif
    inithd(&stfl);
    inithd(&trfl);
    inithd(&freel);

    nmblks = nmbfre = 0;      /* keine Links aktiv, noch keine Freibuffer */
    actbp = &fremem;	      /* niedrigste nutzbare Freispeicherstelle   */

    while (    ((nextbp = actbp + sizeof(MB) - 1) <= ramtop)
            && (nextbp >= &fremem)
          )                                  /* solange Buffer in Frei-   */
      {                                      /* speicher passen, es keine */
        if (!iswarm() 			     /* Routingtablebuffer sind   */
#ifdef BOXFIRM
	    || !isrout(actbp))
#else
	    || (!isrout(actbp)		     /* oder zu einem Text	  */
	       && !istxt(actbp)))	     /* gehoeren		  */
#endif
          dealoc(actbp);                     /* oder Kaltstart, diese     */
        actbp = nextbp + 1;                  /* initialisieren und in     */
      }                                      /* Freispeicherliste haengen */

#ifndef BOXFIRM
    n = 0;
    do
     {                                       /* listen "leer", RX- und    */
      inithd(&txl2fl[n]);                    /* TX-Framekoepfe unbesetzt  */
      rxfhd[n] = txfhd[n] = (MBHEAD *)NULL;
     } while (++n < L2PNUM);
    istraf = FALSE;			     /* noch nichts gesendet      */
#else
    inithd(&txl2fl);			     /* TX-Framekoepfe unbesetzt  */
    rxfhd = txfhd = (MBHEAD *)NULL;
#endif

    lnkpoi = lnktbl;
    do
      {
        lnkpoi->state = lnkpoi->rcvd = lnkpoi->tosend = NULL;
        inithd(&lnkpoi->rcvdil);
        inithd(&lnkpoi->sendil);
        inilbl();
#ifdef FIRMWARE
        reslnk();
#endif
      } while (++lnkpoi < &lnktbl[LINKNMBR]);

  }





/**************************************************************************\
*                                                                          *
* "send frame reject"                                                      *
*                                                                          *
* Wenn Linkzustand des aktuellen Linkblocks (lnkpoi) nicht Disconnectet/   *
* Linksetup/Disconnectrequest/Framereject ist, FRMR-Zustand einnehmen      *
* (state), FRMR den hoeheren Leveln melden, FRMR-Infobytes aufbauen mit    *
* den Flags ZYXW und merken im Linkblock (frmr), FRACK-Timer abschalten,   *
* FRMR senden.                                                             *
*                                                                          *
\**************************************************************************/

VOID sdfrmr(ZYXW)

char ZYXW;

  {
    char *frmrip;             /* Zeiger in Linkblock-FRMR-Infobytes       */

    if (lnkpoi->state >= L2SIXFER)           /* nur ausfuehren, wenn s.o. */
      {
        frmrip = lnkpoi->frmr;               /* Zeiger auf FRMR-Infobytes */
        *frmrip++ = rxfctl | rxfPF;          /* die FRMR-Infobytes        */
        *frmrip++ =   lnkpoi->VR << 5        /* aufbauen                  */
                    | (!rxfCR ? 0x10 : 0)
                    | lnkpoi->VS << 1;
        *frmrip   = ZYXW;
        lnkpoi->state = L2SFRREJ;            /* Linkzustand: Framereject  */
        clrT1();                             /* FRACK-Timer abschalten    */
#ifndef BOXWARE
        l2tolx(L2MFRMRT);                    /* FRMR melden               */
#endif
        xfrmr();                             /* FRMR aussenden            */
      }
  }





/**************************************************************************\
*                                                                          *
* FRMR senden mit den im aktuellen Linkblock (lnkpoi) gegebenen            *
* Parametern (frmr). Die txf...-Parameter muessen gesetzt sein bis auf     *
* txfctl.                                                                  *
*                                                                          *
\**************************************************************************/

VOID xfrmr()
  {
    char     *frmrip;         /* Zeiger in Linkblock-FRMR-Infobytes       */
    MBHEAD   *fbp;            /* Framemessageheader fuer Frameaufbau      */

    txfctl = L2CFRMR;                   /* FRMR-Frame !                   */
    fbp = makfhd(L2FUS | L2FT1ST);      /* Buffer holen, Framekopf bauen  */
    frmrip = lnkpoi->frmr;              /* Zeiger auf FRMR-Infobytes      */
    putchr(*frmrip++,fbp);              /* FRMR-Infobytes in Frame        */
    putchr(*frmrip++,fbp);
    putchr(*frmrip  ,fbp);
    sdl2fr(fbp);                        /* Frame aussenden                */
  }


VOID sfrmr1()
 {
  sdfrmr(0x01);
 }

VOID sfrmr3()
 {
  sdfrmr(0x03);
 }

VOID sdmkfh(fflg)
unsigned fflg;
 {
  sdl2fr(makfhd(fflg));
 }

/* Ende von L2E.C */
