/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    L3.C	-   The Net, The Boxware. Level 3, Routing		 *
*									 *
*    angelegt:      DF6LN aus TNL3.C von DF2AU mit diversen Aenderungen	 *
*    modifiziert:   DF6LN 050292 L3RTT-Frame zurueck an Absender	 *
*		    DF6LN 100792 l3tol4 zusaetzlich			 *
*		    DF6LN 190792 Broadcast nur fuer Eintraege mit	 *
*				 connectetem Nachbarn			 *
*		    DF6LN 090892 Lifetime im Broadcast zusaetzlich	 *
*		    DF6LN 100193 l3serv aufgeteilt in l3rx, l3tx, l3rest *
*									 *
\************************************************************************/

#include "all.h"		/* Definition von Konstanten		     */
#include "l234.h"		/* Definition der Typen			     */
#include "l3e.h"		/* externe Deklarationen		     */


/*---------------------------------------------------------------------------*/
VOID	l3init()		/* Level 3 initialisieren		     */
  {
   union			/* Pointer aus Platzgruenden zusammengefasst */
    {				/* VORSICHT BEI AENDERUNGEN!!		     */
     NODTYP *despoi;		/* Pointer auf Zielknoten		     */
     NBRTYP *nbrpoi;		/* Pointer auf Nachbarn			     */
    } mulpoi;

  numdes = 0;			/* Ziel Liste ist leer			     */
  brotim = broint - 30;		/* Uhr fuer Rundsprueche ruecksetzen	     */
  inithd(&l3rxfl);		/* Liste empfangene Frames loeschen	     */
  inithd(&l3txl);		/* Liste zu sendende Frames loeschen	     */

  if (!iswarm())		/* nur im Kaltstart			     */
    {
      inithd(&destil);		/* Liste Ziele loeschen			     */
      inithd(&neigbl);		/* Liste Nachbarn loeschen		     */
    }
  else						    /* Warmstart	     */
    {
      for (mulpoi.despoi  = (NODTYP *) destil.head; /* Nodesliste bearbeiten */
	   mulpoi.despoi != (NODTYP *) &destil.head;
	   mulpoi.despoi  = (NODTYP *) mulpoi.despoi->nodlnk.head)
	{
	  if (mulpoi.despoi->nodcal[0] != 0)	/* Eintrag belegt?	     */
	    {
	      ++numdes;				/* ein Ziel mehr	     */
	      mulpoi.despoi->actrou = 0;	/* kein aktiver Weg	     */
	      inithd(&mulpoi.despoi->nodinf);	/* keine Info fuer dies Ziel */
	    }
	  else				/* leerer Eintrag		     */
	    {
	      unlink((mulpoi.despoi =
			(NODTYP *)mulpoi.despoi->nodlnk.tail)->nodlnk.head);
	    }
	}

    for (mulpoi.nbrpoi  = (NBRTYP *) neigbl.head;	/* Nachbarn Liste    */
	 mulpoi.nbrpoi != (NBRTYP *) &neigbl.head;	/* bearbeiten	     */
	 mulpoi.nbrpoi  = (NBRTYP *) mulpoi.nbrpoi->nbrlnk.head)
      {
	mulpoi.nbrpoi->nbrl2l = NULL;	   /* Querverweis in L2Link loeschen */
	mulpoi.nbrpoi->nbrflg &= ~L3FNBROK;/* Route ist (noch) unbrauchbar   */
      }
    }
  }

/*---------------------------------------------------------------------------*/
VOID	l3rx()			/* Level 3 Empfangs-Service		     */
 {
  MBHEAD   *mbhd;		/* Kopf des aktuellen Frames		     */
  unsigned cnt;			/* Scratch Zaehler			     */
  char	   orgnod[L2IDLEN];	/* Call des Quellknotens		     */
  char	   desnod[L2IDLEN];	/* Call des Zielknotens			     */
  char	   beaide[L2CALEN];	/* Ident des Rundspruch sendenden Knotens    */
  char	   nbrcal[L2IDLEN];	/* Call des Nachbarn			     */
  char	   *rxnxt;		/* erstes Zeichen im Frame		     */
  char	   *nxtsav;		/* Zwischenspeicher fuer erstes Zeichen	     */
  BOOLEAN  destin;		/* aktuelles Ziel			     */
  unsigned chaqua;		/* Qualitaet des aktuellen Kanals	     */
  unsigned rxgetc;		/* Getcount des Frames			     */
  unsigned getsav;		/* Zwischenspeicher fuer Getcount	     */
  unsigned l3lt;		/* Restlebensdauer des Frames		     */
  char     nodlt[12];		/* Restlebensdauer der Knoteneintraege	     */
  unsigned cnt1;		/* Zaehler fuer Knoteneintraege im Broadcast */
  WEGTYP   *wegptr;

/*=== empfangene Frames verarbeiten bis Liste leer ==========================*/

  while ((mbhd = (MBHEAD *) l3rxfl.head) != (MBHEAD *) &l3rxfl)
   {
    unlink(mbhd);			/* Frame aus Kette loesen	     */
    if ((mbhd->l2fflg & 0xff) == L3CPID)/* TheNet-PID stimmt?		     */
     {
      rxnxt = mbhd->mbbp;	/* erstes Zeichen des Frames und	     */
      rxgetc = mbhd->mbgc;	/* Getcount merken			     */
      takfhd(mbhd);		/* Link-Parameter setzen (rxfhdr etc.)	     */
      mbhd->mbbp = rxnxt;	/* 1. Zeichen des Frames und Getcount wieder */
      mbhd->mbgc = rxgetc;	/* auf alten Wert			     */

      if (mbhd->l2link != NULL)	/* wenn NULL, ist es ein UI-Frame, sonst ein */

/*****************************************************************************\
*									      *
*			Level-3-INFO-Frame				      *
*									      *
* Level 3 Header untersuchen. Frames fuer L3RTT an den Absender zuruecksenden *
* (fuer Laufzeitmessung bei TheNetNode), falls ausreichende L3-Lifetime. Ist  *
* es kein L3RTT-Frame, wird zunaechst der Absenderknoten in die Nodesliste    *
* aufgenommen, wenn noetig. Danach werden Frames fuer den eigenen Knoten an   *
* den Level 4 weitergegeben. Andere Frames werden an den gewuenschten Ziel-   *
* knoten weitergeleitet ueber den gemaess Nodeslisteneintrag zustaendigen     *
* Nachbarknoten.							      *
*									      *
\*****************************************************************************/

       {
	if ((getfid(orgnod, mbhd) == TRUE) /* Call des Quellknotens holen    */
	  &&(getfid(desnod, mbhd) == TRUE) /* Call des Zielknotens holen     */
	  && morinb(mbhd) != 0)		   /* Info im Frame?		     */
	 {
	  --*(mbhd->mbbp);	/* Restlebensdauer reduzieren		     */
	  l3lt = getchr(mbhd);	/* Restlebensdauer holen		     */

/*****************************************************************************\
*									      *
* L3RTT Testframe wieder an OriginNode zuruecksenden fuer TheNetNode Auto-    *
* qualityberechnung	(nach DB2OS)					      *
*									      *
\*****************************************************************************/

	  if (cmpid(desnod,l3rttc)		/* L3RTT-Frame?		     */
	      &&(!cmpmyc(orgnod))		/* kein eigenes Frame	     */
	      &&(l3lt != 0))			/* noch Restlebensdauer?     */
           {
            mbhd->mbbp = rxnxt;			/* auf Transportheader	     */
            mbhd->mbgc = rxgetc;

	    if (iscall(orgnod) != FALSE)	 /* Absender in Nodesliste?  */
	     {
              todest(mbhd);			 /* dann Info umhaengen	     */
              continue;
	     }
	   } /* L3RTT-Frame vom Nachbarn */

/*****************************************************************************\
*									      *
* Damit eine Antwort an den Absenderknoten zurueckgeschickt werden kann, muss *
* der Absenderknoten in der Nodesliste eingetragen sein. Falls der Eintrag    *
* noch fehlt, wird versucht, den Absender ueber den empfangenen Weg in die    *
* Nodesliste einzutragen. Ist dies nicht moeglich, wird die empfangene Info   *
* vernichtet.								      *
*                                                                             *
\*****************************************************************************/


	  if ((!cmpmyc(orgnod))			/* kein eigenes Frame	     */
	      &&(isgood() == TRUE)		/* und gute Qualitaet	     */
	      &&((!(destin = iscall(orgnod)))	/* Absender noch unbekannt   */
		 ||(istweg(&txfhdr[2*L2IDLEN],
#ifndef BOXWARE
			   &rxfhdr[L2IDLEN], rxfprt) == ERROR)))
	   {
	    if (!chgnod('+', obcini, 0, rxfprt,
#else
			   &rxfhdr[L2IDLEN]) == ERROR)))
	   {
	    if (!chgnod('+', obcini, 0,
#endif
		   &txfhdr[2*L2IDLEN], /* Nodesliste auf neuen Stand bringen */
		   &rxfhdr[L2IDLEN],
		   !destin ? hidide : despoi->nodide, orgnod, l3lt+1))
	     {
	      dealmb(mbhd);	/* Eintrag in Nodesliste war nicht moeglich  */
	      continue;		/* Frame auf den Muell und auf zum Naechsten */
             }
	   }

/*****************************************************************************\
*									      *
* Aus dem empfangenen Frame ist die L3-Lifetime bekannt. Daher wird sie fuer  *
* die naechste Aussendung der Nodes-Bake in die Nodesliste eingetragen.	      *
*									      *
\*****************************************************************************/

	  wegptr = &(despoi->weg[istweg(&txfhdr[2*L2IDLEN],
#ifndef BOXWARE
					&rxfhdr[L2IDLEN], rxfprt)]);
#else
					&rxfhdr[L2IDLEN])]);
#endif
	  wegptr->lifeti = l3lt+1;

/*****************************************************************************\
*									      *
* Wenn das Frame fuer mich ist, wird es zur L4-Empfangsliste umgehaengt.      *
*									      *
\*****************************************************************************/

	  if (cmpmyc(desnod) == TRUE)		/* Frame fuer mich?	     */
	   {
	    relink(mbhd, l4rxfl.tail);		/* dann an Level 4 geben     */
	    continue;				/* naechstes Frame	     */
	   }

/*****************************************************************************\
*									      *
* Frame ist nicht fuer mich, also soll es weitergeleitet werden. Dies ist     *
* aber nur moeglich, wenn der Zielknoten bekannt ist und die Restlebensdauer  *
* noch nicht bei 0 angekommen ist. Falls das Frame von dem Nachbarn empfangen *
* wurde, an den es nach Nodesliste zurueckgeschickt werden muesste, wird dies *
* als Fehler in der Nodesliste markiert, damit Frames moeglichst nicht mehr   *
* ueber diesen Nachbarn an den Zielknoten geschickt werden. Das Frame wird    *
* dann an den Zielknoten weitergeleitet.				      *
*									      *
\*****************************************************************************/

	  if ((iscall(desnod) == TRUE)		/* Ziel bekannt?	     */
	      && (l3lt != 0))			/* noch Restlebensdauer?     */
	   {
	    mbhd->mbbp = rxnxt;			/* auf Transportheader	     */
	    mbhd->mbgc = rxgetc;
	    if ((despoi->actrou != 0)	/* Weg zum Ziel = Weg der Info?	     */
		&&(mbhd->l2link ==
		   despoi->weg[despoi->wegnr].nachba->nbrl2l))
	     {
	      despoi->actrou =			/* Fehler aufgetreten, neuen */
		(despoi->actrou & ~0x07) | 0x02;/* Weg nehmen, wenn moeglich */
	     }
	    if (!cmpmyc(orgnod)			    /* nicht mein Frame und  */
		&& !((despoi->actrou & 0x07) == 2)) /* kein Routingfehler    */
	     {
	      todest(mbhd);   		/* Info absetzen                     */
	      continue;
	     }				/* Info kann abgesetzt werden	     */
	   }				/* Ziel ist bekannt		     */
	 }				/* Info ist im Frame		     */
       }				/* es ist ein I-Frame		     */
      else


/*****************************************************************************\
*									      *
*			Level-3-UI-Frame				      *
*									      *
* Bisher sind fuer TheNet nur Nodes-Broadcasts als UI-Frame definiert, alles  *
* andere wird verworfen. Die im empfangenen Broadcast gemeldeten Knoten wer-  *
* den bei ausreichender Qualitaet in die eigene Nodesliste uebernommen.	      *
*									      *
\*****************************************************************************/

       {
#ifdef BOXWARE
	if ((worqua != 0) && (myid[0] != ' '))	/* darf Auswertung erfolgen? */
#else
	if (worqua != 0)			/* darf Auswertung erfolgen? */
#endif
	 {
	  if (isgood() == TRUE)/* nur bei ausreichender Qualitaet auswerten  */
	   {
	    if ((morinb(mbhd) != 0)			/* Info im Frame?    */
		&&((getchr(mbhd) & 0xff) == 0xff)	/* stimmt Signatur?  */
		&&(ge6chr(beaide, mbhd) == TRUE))	/* Ident des Knotens */
							/* der Sendung holen */

/*****************************************************************************\
*									      *
* Broadcast-Protokollerweiterung:					      *
*									      *
* Nach den einzelnen Knoteneintraegen folgt 1 Byte 00 und danach die Rest-    *
* Lebensdauer von L3-Frames ueber diesen Weg und zwar zuerst 1 Byte fuer die  *
* eigene Restlebensdauer und danach fuer die anderen ausgesendeten Knoten.    *
* Falls der Absenderknoten aeltere Software verwendet, also ohne Aussendung   *
* der Rest-Lifetime, wird 00 fuer die Rest-Lifetime gespeichert.	      *
*									      *
\*****************************************************************************/

	     {
	      nodlt[0] = 0;		/* Rest-Lifetime mit 0 belegen fuer  */
	      moveb(11,nodlt+1,nodlt);	/* alle Eintraege		     */
	      cnt1 = 1;			/* 1. Eintrag = Absenderknoten	     */
	      nxtsav = mbhd->mbbp;      /* 1. Zeichen Broadcast + Getcount   */
	      getsav = mbhd->mbgc;	/* merken			     */

/*****************************************************************************\
*									      *
* Zunaechst wird das Ende der Knoteneintraege gesucht. Dabei werden auch die  *
* Eintraege in diesem Frame gezaehlt.					      *
*									      *
\*****************************************************************************/

	      while (morinb(mbhd)		/* weiterer Eintrag	     */
		     >= 2*L2IDLEN+L2CALEN+1)	/* moeglich?		     */
	       {
		++cnt1;				/* 1 Eintrag mehr	     */
		cnt = 0;			/* 1 Eintrag uebergehen	     */
		do
		 {
		  getchr(mbhd);				/* bis zum Ende des  */
		 } while (++cnt < 2*L2IDLEN+L2CALEN+1);	/* Eintrags lesen    */
	       }

	      if (morinb(mbhd) > 1)		/* Lifetimeliste moeglich?   */
	       {
		if (getchr(mbhd) == 0)		/* naechstes Byte ist 0	     */
		 {
		  cnt = 0;			/* Lifetimeliste lesen	     */
		  do
		   {
		    if (!morinb(mbhd))		/* Liste zu frueh beendet?   */
		      break;
		    nodlt[cnt] = getchr(mbhd) & 0xff;	/* Lifetime holen    */
		   } while(++cnt < cnt1);
		 }
	       }
	      mbhd->mbbp = nxtsav;	/* zurueck auf 1. Zeichen Broadcast  */
	      mbhd->mbgc = getsav;
	     }
#ifndef BOXWARE
	    if (chgnod('+', obcini, qualty, rxfprt,
#else
	    if (chgnod('+', obcini, qualty,
#endif
			  &txfhdr[2*L2IDLEN],		/* Absenderknoten in */
			  &rxfhdr[L2IDLEN], beaide,	/* die Nodesliste    */
			  &rxfhdr[L2IDLEN],		/* eintragen	     */
			  nodlt[0]) == TRUE)

/*****************************************************************************\
*									      *
* Wenn der Absenderknoten in die Nodesliste eingetragen werden konnte, wird   *
* der Rest des Frames bearbeitet.					      *
*									      *
\*****************************************************************************/

	     {
	      cnt = 0;
	      while ((getfid(desnod, mbhd) == TRUE)	/* Call holen	     */
		      && (ge6chr(beaide, mbhd) == TRUE) /* ID holen	     */
		      && (getfid(nbrcal, mbhd) == TRUE) /* Nachbar holen     */
		      && (morinb(mbhd) != 0))		/* Qualitaet da?     */
	       {
		++cnt;				/* 1 Eintrag mehr	     */
		chaqua = getchr(mbhd) & 0xff;	/* Qualitaet beim Nachbarn   */
		if ((!cmpmyc(desnod))		/* selbst Ziel?		     */
		    && (!cmpmyc(nbrcal))	/* selbst Nachbar?	     */
		    && (beaide[0] != '#'))	/* keine #-Knoten	     */
		 {
		  if ((chaqua = ((chaqua * qualty) >> 8)) >= worqua)
		   {
#ifndef BOXWARE
		    chgnod('+', obcini, chaqua, rxfprt, &txfhdr[2*L2IDLEN],
#else
		    chgnod('+', obcini, chaqua, &txfhdr[2*L2IDLEN],
#endif
			&rxfhdr[L2IDLEN], ((!chaqua)
					   && (iscall(desnod) == TRUE)) ?
			despoi->nodide : beaide, desnod,nodlt[cnt]);
		   } /* Qualitaet gut genug fuer Update */
		 } /* nicht selbst das Ziel */
	       }/* end while */

	      if ((nbrpoi != NULL)	/* Nachbar definiert?		     */
		  && ((nbrpoi->nbrflg	/* Nachbar ist connected	     */
		      & L3FNBROK) != 0))
	       {


/*****************************************************************************\
*									      *
* Fuer jeden Eintrag in der Nodesliste pruefen, ob jetzt ein besserer Weg     *
* ueber den Nachbarn empfangen wurde, oder ob der ueber diesen Nachbarn ver-  *
* wendete Weg jetzt schlechter ist als der beste bekannte Weg. Wenn ja, wird  *
* der beste Weg in Zukunft verwendet.					      *
*									      *
\*****************************************************************************/

		for (despoi  = (NODTYP *) destil.head;
		     despoi != (NODTYP *) &destil.head;
		     despoi  = (NODTYP *) despoi->nodlnk.head)
		 {
		  if (despoi->actrou != 0)	/* aktiver Weg zum Ziel?     */
		   {
		    cnt = 0;
		    do
		     {
		      if (despoi->weg[cnt].nachba == nbrpoi)
		       {	/* fuehrt der Weg ueber diesen Nachbarn?     */
			if (despoi->wegnr > cnt)
			 {		       /* existiert besserer Weg?    */
			  despoi->wegnr = cnt;
			  makrou();	       /* diesen Weg versuchen       */
			 }		       /* es gibt einen besseren Weg */
			break;
		       }		/* Weg fuehrt ueber diesen Nachbarn  */
		     } while (++cnt < despoi->wege);/* dieser Weg bearbeitet */

		   }			/* aktiver Weg existiert	     */
		 }			/* dieses Ziel bearbeitet	     */
	       }			/* Weg geht ueber einen Nachbarn     */
	     }				/* Signatur ist gut		     */
	   }				/* Qualitaet des Kanals stimmt	     */
	 }				/* Auswertung zulaessig		     */
       }				/* ist UI Frame			     */
     }					/* PID stimmt			     */
    dealmb(mbhd);			/* Frame ist bearbeitet, wegwerfen   */
   }					/* Frames in der Kette		     */
 }

/*---------------------------------------------------------------------------*/
VOID	l3tx()			/* Level 3 Sende-Service		     */
 {
  MBHEAD   *mbhd;		/* Kopf des aktuellen Frames		     */
  unsigned rxgetc;		/* Getcount des Frames			     */

/*=== zu sendende Frames verarbeiten bis Liste leer =========================*/

  while ((mbhd = (MBHEAD *) l3txl.head) != (MBHEAD *) &l3txl.head)
   {
    unlink(mbhd);			/* Frame aushaengen		     */
    despoi = (NODTYP *) mbhd->l2link;	/* Pointer auf Zielknoten	     */

    if ((despoi->nodcal[0] != 0)	/* Ziel definiert		     */
	&& (nmbfre > 64)) 		/* und Platz im Speicher	     */
     {
      rwndmb(mbhd);			/* alle Pointer auf Ausgangsstellung */
      getchr(mbhd);			/* alles initialisieren		     */
      --mbhd->mbbp;
      rxgetc = mbhd->mbpc;		/* Framelaenge merken		     */
      mbhd->mbpc = 1;			/* auf Anfang			     */
      putfid(myid, mbhd);		/* Absender ins Frame		     */
      putfid(despoi->nodcal, mbhd);	/* Ziel ins Frame		     */
      *(mbhd->mbbp -1) |= 1;		/* Ende der Adresse setzen	     */
      putchr(timliv, mbhd);		/* Lebensdauer setzen		     */
      mbhd->mbpc = rxgetc;		/* Putcount zurueck		     */
      rwndmb(mbhd);			/* Pointer wieder aufziehen	     */
      todest(mbhd);			/* weg damit			     */
     }
    else
     dealmb(mbhd);			/* geht nicht, Frame vernichten	     */
   }
 }

/*---------------------------------------------------------------------------*/
VOID	l3rest()		/* Level 3 - sonstige Funktionen	     */
 {
  MBHEAD   *mbhd;		/* Kopf des aktuellen Frames		     */

/*=== sonstige Funktionen ===================================================*/

  for (despoi  = (NODTYP *) destil.head;	/* Nodesliste bearbeiten     */
       despoi != (NODTYP *) &destil.head;
       despoi  = (NODTYP *) despoi->nodlnk.head)
   {
    switch (despoi->actrou & 0x07) 	/* ueber Wegstatus verzweigen	     */
     {

/*****************************************************************************\
*									      *
* Es ist ein Routingfehler aufgetreten, d.h. der Zielknoten ist nicht mehr    *
* ueber den verwendeten Nachbarn zu erreichen. Es wird nun versucht, einen    *
* anderen Weg zu nehmen. Sind alle Wege erfolglos probiert worden, so werden  *
* die bisher gespeicherten Frames fuer den Zielknoten vernichtet.	      *
*                                                                             *
\*****************************************************************************/

      case 2:
	if (++despoi->wegnr >= despoi->wege)
	 {
	  if ((despoi->actrou & 0x80) == 0)	/* schonmal ein Weg erfolg-  */
	   {					/* reich verwendet?	     */
	    despoi->wegnr = 0;			/* dann ersten Weg nehmen    */
	   }
	  else                  /* alle Wege probiert, keiner geht	     */
	   {
	    destot();		/* Ziel nicht erreichbar, Frames wegwerfen   */
	    break;
	   }
	 }
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*	makrou();	/* durchfallen -> case 4 spart Platz		     */
/*      break;		/* VORSICHT BEI AENDERUNGEN!!			     */
/*___________________________________________________________________________*/

/*****************************************************************************\
*									      *
* Der bisher verwendete Nachbar wird gerade disconnected. Daher Weg neu auf-  *
* bauen.								      *
*                                                                             *
\*****************************************************************************/

      case 4:
	makrou();		/* Weg aufbauen				     */
      break;

/*****************************************************************************\
*									      *
* Der Zielknoten ist (wahrscheinlich) ueber den Nachbarn zu erreichen, also   *
* darf Info uebertragen werden. Alle vorhandenen Infoframes fuer den Ziel-    *
* knoten werden an den Linkblock des Nachbarn umgehaengt.		      *
*                                                                             *
\*****************************************************************************/

      case 3:
	while ((mbhd = (MBHEAD *) despoi->nodinf.head)	/* solange Frames    */
		!= (MBHEAD *) &despoi->nodinf)		/* vorhanden	     */
	 {
	  unlink(mbhd);				/* Frame aus Kette holen     */
	  mbhd->l2fflg = L3CPID;		/* PID setzen		     */
	  lnkpoi = despoi->weg[despoi->wegnr].nachba->nbrl2l;
	  relink(mbhd,lnkpoi->sendil.tail);	/* Frame in L2 umhaengen     */
	  ++lnkpoi->tosend;			/* ein Frame mehr senden     */
	  lnkpoi->noatou = ininat; 		/* Timeout setzen	     */
	 }
      break;

/*****************************************************************************\
*									      *
* Zum Zielknoten besteht kein aktiver Link bzw. der Link wird noch aufgebaut. *
* Also erstmal abwarten.						      *
*                                                                             *
\*****************************************************************************/

      default:
      break;
     }
   }
 }

/*---------------------------------------------------------------------------*/
VOID	l2tol3(status)	/* Level 2 meldet neuen Status: 0 = nicht verwendet, */
unsigned status;	/* 1 = connected, 2 = disconnected, 3 = busy,	     */
			/* 4 = failure (s. Level 2)			     */
 {
  union                 	/* Pointer aus Platzgruenden zusammengefasst */
   {				/* VORSICHT BEI AENDERUNGEN!!		     */
    NODTYP    *despoi;		/* Pointer auf Zielknoten		     */
    NBRTYP    *nbrpoi;		/* Pointer auf Nachbarn			     */
   } mulpoi;
  unsigned  wegsts;		/* Status des aktuellen Weges		     */

  for (mulpoi.despoi  = (NODTYP *) destil.head;	/* gemeldeten Link suchen    */
       mulpoi.despoi != (NODTYP *) &destil.head;
       mulpoi.despoi  = (NODTYP *) mulpoi.despoi->nodlnk.head)
   {
    if (((wegsts = mulpoi.despoi->actrou & 0x07) != 0)	/* aktiver Weg?	     */
	&& ((mulpoi.despoi->weg[mulpoi.despoi->wegnr].
				nachba)->nbrl2l == lnkpoi))
     {
      if (status == 1)		       /* Connect gemeldet		     */
       {
        if (wegsts == 1)	       /* und war auch gefordert	     */
         {
          mulpoi.despoi->actrou = 3;   /* neuer Status des Zieles: connected */
         }
       }
      else
       {
	if (wegsts != 4)		/* wenn nicht Disconnect gefordert   */
	 {				/* disconnected / busy / failure     */
	  mulpoi.despoi->actrou =		    /* anderen Weg nehmen    */
	    (mulpoi.despoi->actrou & ~0x07) | 0x02;
	 }
       }
     }
   }

  if (status != 1)			/* bei Disconnected / Busy / Failure */
   {
    for (mulpoi.nbrpoi  = (NBRTYP *) neigbl.head;		 /* Nachbarn */
	 mulpoi.nbrpoi != (NBRTYP *) &neigbl.head;		 /* Liste    */
	 mulpoi.nbrpoi  = (NBRTYP *) mulpoi.nbrpoi->nbrlnk.head) /* absuchen */
     {
      if (mulpoi.nbrpoi->nbrl2l == lnkpoi)
       {
	mulpoi.nbrpoi->nbrl2l = NULL;		/* Querverweis loeschen	     */
	mulpoi.nbrpoi->nbrflg &= ~L3FNBROK;	/* Nachbar nicht connected   */
       }
     }
   }
 }

#ifndef BOXWARE
/*---------------------------------------------------------------------------*/
myqset()
 {
  return(myqua == 0 ? 1 : 2);
 }
#endif

/*---------------------------------------------------------------------------*/
VOID	l3timr()	/* Rundspruchservice - wird jede Sekunde aufgerufen  */
 {
  union				/* Pointer aus Platzgruenden zusammengefasst */
  {				/* VORSICHT BEI AENDERUNGEN!!		     */
   MBHEAD  *mbhd;		/* Buffer fuer Meldung			     */
   MB	   *np;			/* freigewordener Nodesbuffer		     */
   NBRTYP  *nbrpoi;
  } mulpoi;
  unsigned cnt;			/* Zaehler				     */
  WEGTYP   *route;		/* aktueller Weg			     */
#ifndef BOXWARE
  unsigned port;		/* Port fuer Rundspruch			     */
#endif
  char     ch;
  NODTYP   *desp;
  char     nodlt[12];
  LNKBLK   *l2l;

/****************************************************************************\
*									     *
* L3 zuerst aufraeumen							     *
*									     *
* Die Nodesliste wird von freigewordenen Eintraegen gesaeubert. Dies ist     *
* wegen des Programmaufbaus nicht gleich moeglich, wenn die Buffer frei	     *
* werden. Bisher wurde dies nur beim Warmstart (oder Kaltstart) durchge-     *
* fuehrt. Dies macht sich im praktischen Betrieb immer dann bemerkbar, wenn  *
* die zulaessige Groesse der Nodesliste (Parameter 1 = maxdes) verkleinert   *
* wird und mehr Eintraege belegt waren, als mit der neuen Einstellung	     *
* erlaubt sind.								     *
*									     *
* Ausserdem werden bei TheNet die Identifier der belegten Eintraege so bear- *
* beitet, dass beim Broadcast userfreundliche Identifier entstehen, die beim *
* Connect-Befehl an einen TheNet-Knoten statt des Rufzeichens verwendet wer- *
* den koennen. Dafuer ist keine Kleinschrift zulaessig und Bit 7 muss ge-    *
* loescht sein. Allerdings werden Satzzeichen wie z.B. '-' hier nicht besei- *
* tigt.									     *
*									     *
\****************************************************************************/

  for (desp  = (NODTYP *) destil.head;		/* Nodesliste ansuchen nach */
       desp != (NODTYP *) &destil.head;		/* unbelegten Eintraegen    */
       desp  = (NODTYP *) desp->nodlnk.head)
   {
    if (desp->nodcal[0] == 0)			/* Eintrag frei?	     */
     {
      mulpoi.np = (MB *) desp;			/* Buffer merken	     */
      desp = (NODTYP *) desp->nodlnk.tail;	/* desp 1 Eintrag zurueck    */
      dealoc(unlink(mulpoi.np));		/* freien Eintrag entfernen  */
      --numdes;					/* 1 Nodeseintrag weniger    */
     }
#ifndef BOXWARE
    else					/* Eintrag belegt	     */
     {
      cnt = 0;				     /* Ident des Knotens bearbeiten */
      do
       {				     /* Kleinschrift mag ich nicht   */
	desp->nodide[cnt] =		     /* und Bit 7 gehoert geloescht  */
	  upcase(desp->nodide[cnt] & 0x7f);
       } while (++cnt < L2CALEN);
     }
#endif
   }

/*****************************************************************************\
*									      *
* Alle Nachbarn ueberpruefen: Wenn noch kein L2-Link besteht, diesen anfor-   *
* dern. Wenn der Nachbar schon connected ist, diesen als brauchbar fuer	      *
* Nodes-Broadcast markieren.						      *
*									      *
\*****************************************************************************/

  for (mulpoi.nbrpoi  = (NBRTYP *) neigbl.head;	/* Nachbarn Liste bearbeiten */
       mulpoi.nbrpoi != (NBRTYP *) &neigbl.head;
       mulpoi.nbrpoi  = (NBRTYP *) mulpoi.nbrpoi->nbrlnk.head)
   {
    if ((l2l = mulpoi.nbrpoi->nbrl2l) == NULL)	/* Nachbar nicht connected   */
     {
      if ((mulpoi.nbrpoi->nbrrou != 0)		/* Knoten ueber Nachbarn be- */
        && (mulpoi.nbrpoi->pathqu >= worqua))	/* kannt und nicht gesperrt  */
       {
        connbr(mulpoi.nbrpoi);			/* Nachbarn connecten	     */
       }
     }
    else				/* Nachbar ist/wird connected	     */
     {
      if (l2l->state >= L2SIXFER)		/* Link steht schon	     */
       {
	mulpoi.nbrpoi->nbrflg |= L3FNBROK;	/* Nachbar brauchbar	     */
       }
      else					/* Connect laeuft noch	     */
       {
	mulpoi.nbrpoi->nbrflg &= ~L3FNBROK;	/* Nachbar nicht brauchbar   */
       }
     }
   }


/*****************************************************************************\
*									      *
* Wenn Broadcast zulaessig, auf allen L2-Ports NODES-Bake aussenden.	      *
*									      *
\*****************************************************************************/

#ifdef BOXWARE
  if ((broint != 0) && (myid[0] != ' '))	/* Rundspruch erlaubt?	     */
#else
  if (broint != 0)				/* Rundspruch erlaubt?	     */
#endif
   {
    if (++brotim >= broint) 	/* Zeit zum Senden gekommen?		     */
     {
      brotim = 0;		/* Uhr ruecksetzen			     */
      if (obcini != 0)	 	/* wenn Abwesenheitszaehler gefuehrt wird,   */
	cntdwn();		/* diesen fuer alle Eintraege bearbeiten     */
#ifndef BOXWARE
      port = 0;					/* fuer alle L2-Ports	     */

/*****************************************************************************\
*									      *
* Broadcast-Protokollerweiterung:					      *
*									      *
* Fuer jeden zu sendenden Knoten wird die Rest-Lifetime untersucht. Ist sie   *
* 00, so verwendet der Absenderknoten (oder einer auf dem Weg) aeltere Soft-  *
* ware. Ist sie > 1, wird der Eintrag mit ausgesendet.			      *
*									      *
\*****************************************************************************/

      do
       {
        if ((port + 1) & (Flags >> 4)) continue;/* wenn NODES-Bake gesperrt  */
	mulpoi.mbhd = brobuf(port);		/* Puffer mit eigenem Ident  */
	cnt = myqset();
	nodlt[0] = nodlt[1] = timliv;
	for (desp  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
	   desp != (NODTYP *) &destil.head;
	   desp  = (NODTYP *) desp->nodlnk.head)
	 {
	  if (desp->nodcal[0] != 0)		/* Eintrag belegt?	     */
	   {
	    if (((route = desp->weg)->qualit != 0) /* Qualitaet muss sein    */
		 &&((route->obscnt == 0)	   /* Eintrag permanent oder */
		   || ((route->obscnt & 0xff) >= obcbro))) /* gut genug	     */
	     {
	      if (mulpoi.mbhd == NULL)	/* ggfs neuen Buffer besorgen	     */
	       {
		mulpoi.mbhd = brobuf(port);
		cnt = myqset();
	       }

/****************************************************************************\
*									     *
* Knoten mit '#' am Anfang des Ident und solche ohne Ident werden nicht mehr *
* weitergemeldet. Knoten werden nur dann weitergemeldet, wenn der dazugehoe- *
* rende Nachbar connected ist (verhindert, dass Knotenwege ueber nicht	     *
* erreichbare Wege weitergemeldet werden) und wenn die L3-Lifetime des Kno-  *
* tens ausreicht fuer die Verbindung zu einem weiteren Knoten.		     *
*									     *
\****************************************************************************/

	      if (((ch = desp->nodide[0])	/* #-Knoten oder ganz ohne   */
		       != '#')			/* Ident nicht weitermelden  */
		  && (ch != ' ')
		  && ((route->nachba->nbrflg	/* Nachbar connected?	     */
		      & L3FNBROK) != 0))
	       {
		nodlt[cnt] = route->lifeti;
		if ((nodlt[cnt] - 1 != 0)	/* Lifetime ausreichend?     */
		    && !((port + 1)		/* Aussendung auf dem Port   */
			 & (Flags >> 6)))	/* zulaessig?		     */
		 {

/*****************************************************************************\
*									      *
* Wenn die L3-Lifetime des Knotens bis hierher bekannt ist (!= 0), wird der   *
* Wert um 1 vermindert weitergemeldet.					      *
*									      *
\*****************************************************************************/

		  if (nodlt[cnt] != 0) --nodlt[cnt];

		  ++cnt;				    /* 1 Knoten mehr */
		  putfid(desp->nodcal, mulpoi.mbhd);	    /* Ziel-Call     */
		  pu6chr(desp->nodide, mulpoi.mbhd);	    /* Ziel-Ident    */
		  putfid(route->nachba->nbrcal,mulpoi.mbhd);/* Ziel-Nachbar  */
		  putchr(route->qualit, mulpoi.mbhd);	   /* Ziel-Qualitaet */
		  if (mulpoi.mbhd->mbpc
		       > INFOLEN-(2*L2IDLEN+L2CALEN+1))
		   {

/*****************************************************************************\
*									      *
* Es passt kein weiterer Nodeseintrag ins Frame. Frame aussenden und Buffer   *
* als unbelegt kennzeichnen.						      *
*									      *
\*****************************************************************************/

		    sdbufr(mulpoi.mbhd,port,nodlt,cnt);	/* Buffer senden     */
		    mulpoi.mbhd = NULL;		        /* Buffer ist weg    */
		   }
		 }
	       }
	     }
	   }
	 }
	if (mulpoi.mbhd != NULL)		/* noch Reste im Buffer?     */
	  sdbufr(mulpoi.mbhd,port,nodlt,cnt);	/* dann senden		     */
       } while (++port < L2PNUM);
#else

/****************************************************************************\
*									     *
* Bei Boxware keine Eintraege aus Nodesliste weitermelden (spart Platz!)     *
*									     *
\****************************************************************************/

      sdbufr(brobuf());
#endif
     }
   }
 }

/*****************************************************************************\
*									      *
* cntdwn()	zaehlt fuer alle nicht fest eingetragenen Knoten Obscount     *
*		runter und loescht den entsprechenden Eintrag, wenn Obscount  *
*		bei 0 angekommen ist.					      *
*									      *
* parameter:	-							      *
*									      *
* return:	-							      *
*									      *
\*****************************************************************************/

VOID cntdwn()
 {
  unsigned cnt;			/* Zaehler				     */
  WEGTYP   *route;		/* aktueller Weg			     */

  for (despoi  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
       despoi != (NODTYP *) &destil.head;
       despoi  = (NODTYP *) despoi->nodlnk.head)
   {
    if (despoi->nodcal[0] != 0)			/* Eintrag belegt?	     */
     {
      cnt = 0;
      do
       {
	if (((route = &despoi->weg[cnt])->obscnt != 0)	/* gueltig?	     */
	    &&(--(route->obscnt) == 0))			/* gerade auf 0?     */
	 {
	  delrou(cnt);					/* dann loeschen     */
	  --cnt;					/* ein Weg weniger   */
	 }
       } while (++cnt < despoi->wege);			/* alle Wege testen  */
     }
   }
 }


/****************************************************************************\
*									     *
* brobuf - Buffer fuer Rundspruch besorgen				     *
*									     *
* In jeden Broadcast wird am Anfang der eigene Knoten mit einer einstell-    *
* baren Qualitaet ausgesendet (myqua), wenn diese nicht 0 ist. Damit kann    *
* und sollte z.B. ein Mailboxknoten seine eigene Qualitaet so weit redu-     *
* zieren, dass er nicht uebers gesamte Netz bekannt ist. Dadurch wird	     *
* Mailbox-DX zumindest ein wenig reduziert.				     *
*			(von DL2LAY veraendert uebernommen)		     *
*									     *
\****************************************************************************/

#ifdef BOXWARE
MBHEAD	*brobuf()
 {
  MBHEAD	*mbhd;			/* Buffer fuer Meldung		     */

  putchr(0xff,(mbhd = allocb()));	/* Buffer besorgen, Signatur rein    */
  pu6chr(alias, mbhd);			/* Ident in Buffer		     */
  if (myqua != 0)      			/* mit eigener Qualitaet	     */
   {
    putfid(myid, mbhd);			/* eigenes Call			     */
    pu6chr(alias, mbhd);		/* Ident in Buffer		     */
    putfid(myid, mbhd);			/* eigenes Call als Nachbar	     */
    putchr(myqua, mbhd);		/* eigene Qualitaet		     */
   }
  return(mbhd);				/* Buffer als Rueckgabe		     */
 }

#else
MBHEAD	*brobuf(port)		/* Buffer fuer Rundspruch besorgen	     */
unsigned port;			/* Portnummer fuer Ident		     */
 {
  MBHEAD    *mbhd;		/* Buffer fuer Meldung			     */

  putchr(0xff,(mbhd = allocb()));	/* Buffer besorgen, Signatur rein    */
  pu6chr(!port ? alias0 : alias1, mbhd);	/* Ident in Buffer	     */
  if (myqua != 0)
   {
    putfid(myid, mbhd);
    pu6chr(!port ? alias0 : alias1, mbhd);	/* Ident in Buffer	     */
    putfid(myid, mbhd);
    putchr(myqua, mbhd);
   }
  return(mbhd);				/* Buffer als Rueckgabe		     */
 }
#endif

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
VOID	sdbufr(mbhd,port,nodlt,nodcnt)	/* Buffer als Rundspruch senden	     */
MBHEAD	*mbhd;
unsigned port;
char	*nodlt;
unsigned nodcnt;
 {
  unsigned cnt;

  mbhd->l2fflg = L3CPID;				/* PID = Level3	     */

/*****************************************************************************\
*									      *
* Broadcast-Protokollerweiterung:					      *
*									      *
* Nach den einzelnen Knoteneintraegen folgt 1 Byte 00 und danach die Rest-    *
* Lebensdauer von L3-Frames ueber die einzelnen Wege.			      *
*									      *
\*****************************************************************************/

  putchr(0,mbhd);
  cnt = 0;
  do
   {
    putchr(nodlt[cnt],mbhd);
   } while (++cnt < nodcnt);
  sdui(brodil, brodes, myid, port, mbhd); 	/* L2 sendet		     */
  dealmb(mbhd);			/* Buffer wieder freigeben		     */
 }
#else
/*========= fuer die Boxware etwas kuerzer ==================================*/
VOID	sdbufr(mbhd)		/* Buffer als Rundspruch senden		     */
MBHEAD	*mbhd;
 {
  mbhd->l2fflg = L3CPID;			/* PID = Level3		     */

/*****************************************************************************\
*									      *
* Broadcast-Protokollerweiterung:					      *
*									      *
* Nach den einzelnen Knoteneintraegen folgt 1 Byte 00 und danach die Rest-    *
* Lebensdauer von L3-Frames ueber die einzelnen Wege.			      *
*									      *
\*****************************************************************************/

  putchr(0,mbhd);
  putchr(timliv,mbhd);
  if (myqua != 0)
   {
    putchr(timliv,mbhd);
   }

  sdui(brodil, brodes, myid, mbhd);		/* L2 sendet		     */
  dealmb(mbhd);					/* Buffer wieder freigeben   */
 }
#endif

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
BOOLEAN	chgnod(mode, obci, quali, port, digis, nachb, iden, call, nodlt)
#else
BOOLEAN	chgnod(mode, obci, quali, digis, nachb, iden, call, nodlt)
#endif
				/* Zieleintrag aendern			     */
unsigned mode;			/* '+'=neuer Eintrag, '-'=Eintrag loeschen   */
unsigned obci;			/* Abwesenheitszaehler, Initialisierung	     */
unsigned quali;			/* Qualitaet des Weges			     */
#ifndef BOXWARE
unsigned port;			/* Port zum Ziel			     */
#endif
char	 *digis;		/* Digipeaterliste			     */
char	 *nachb;		/* Nachbar zum Ziel			     */
char	 *iden;			/* Ident des Zieles			     */
char	 *call;			/* Rufzeichen des Zieles		     */
unsigned nodlt;
				/* Rueckgabe:				     */
				/* TRUE: loeschen verlangt, kein Eintrag da  */
				/*       aendern war erfolgreich	     */
				/* FALSE: Liste voll			     */
 {
  union				/* Pointer aus Platzgruenden zusammengefasst */
   {				/* VORSICHT BEI AENDERUNGEN!!		     */
    NODTYP   *zielpt;		/* Pointer auf Ziel			     */
    NBRTYP   *nbrptr;		/* Pointer auf Nachbarn			     */
   } mulpoi;
  unsigned cnt;			/* Scratch Zaehler			     */
  char     *id1poi;		/* Pointer fuer Call-Ident Vergleich	     */
  char	   *id2poi;		/* Pointer fuer Call-Ident Vergleich	     */
  unsigned rout;		/* aktueller Weg			     */
  unsigned  neuweg;		/* Position des neuen Weges in Liste	     */
  WEGTYP    *wegptr;		/* Pointer auf Weg			     */

#ifndef BOXWARE
  if ((isinbl(call) == TRUE)	/* Call in Black List uns soll neu aufgenom- */
      && (mode == '+'))		/* men werden? (loeschen geht trotzdem)	     */
    return(FALSE);		/* dann gleich zurueck - geht nicht	     */
#endif

  mulpoi.zielpt = NULL;
  for (despoi  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
       despoi != (NODTYP *) &destil.head;
       despoi  = (NODTYP *) despoi->nodlnk.head)
    {
    if (despoi->nodcal[0] != 0)				/* Eintrag belegt?   */
     {
      if (cmpid(despoi->nodcal, call) == TRUE) break;	/* und passt?	     */
     }
    else						/* freier Eintrag    */
     {
      if (mulpoi.zielpt == NULL)	/* ersten freien Eintrag merken	     */
       {
	mulpoi.zielpt = despoi;
       }
     }
   }
  if ((NODTYP *) &destil.head == despoi)	/* passender Eintrag?	     */
   {
    if (mode == '+')				/* hinzufuegen?		     */
     {
      if (mulpoi.zielpt == NULL)		/* kein freier Platz bisher? */
       {
	if (numdes < maxdes)			/* Liste hat noch Platz?     */
         {
	  mulpoi.zielpt = (NODTYP *) allocb();	/* initialisieren	     */
	  mulpoi.zielpt->actrou =
	  mulpoi.zielpt->wege = 0;		/* kein Weg bekannt	     */
	  inithd(&mulpoi.zielpt->nodinf);	/* keine Info in Schlange    */
	  relink(mulpoi.zielpt, destil.tail);	/* in Nodesliste haengen     */
	  ++numdes;				/* Liste 1 laenger geworden  */
	 }
	else
	 {
	  return (FALSE);			/* Liste ist voll	     */
         }
       }
      despoi = mulpoi.zielpt;		 /* freien (neuen) Platz nehmen	     */
      cpyid(mulpoi.zielpt->nodcal,call); /* Call eintragen, Rest spaeter     */
     }
    else
     {
      return (TRUE);	/* loeschen verlangt, Eintrag existiert nicht	     */
     }
   }

/*------------------------------ passender Eintrag existiert (CALL)	     */
  cpycal(despoi->nodide, iden);		/* Ident umkopieren		     */
  unlink(despoi);			/* Eintrag aus Kette loesen	     */

  for (mulpoi.zielpt  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
       mulpoi.zielpt != (NODTYP *) &destil.head;
       mulpoi.zielpt  = (NODTYP *) mulpoi.zielpt->nodlnk.head)
    {
      id1poi = (char *) mulpoi.zielpt->nodide;
      id2poi = (char *) despoi->nodide;

      cnt = 0;		/* Nodes-Liste sortieren nach Identifier und Call    */
      do
       {
	if (*id1poi == *id2poi)
	 {
	  ++id1poi;
	  ++id2poi;
	 }
	else break;
       } while (++cnt < L2IDLEN+L2CALEN);	/* Call und Ident verglichen */

      if (*id1poi > *id2poi) break;
    }						/* Nodesliste abgesucht	     */
  relink(despoi, mulpoi.zielpt->nodlnk.tail);	/* Knoten hier einhaengen    */
#ifndef BOXWARE
  if ((rout = istweg(digis, nachb, port)) == ERROR)
#else
  if ((rout = istweg(digis, nachb)) == ERROR)	/* Nachbar unbekannt?	     */
#endif
    {
      if (mode == '+')                  /* Eintrag neu setzen		     */
       {
        rouhin();			/* alle Wege in Arbeitsspeicher	     */
        wegptr = &routmp[despoi->wege];	/* auf neuen Weg. wege zaehlt 1-2-3! */
        wegptr->qualit = quali;		/* Qualitaet des neuen Weges	     */
        wegptr->obscnt = obci;		/* Anwesenheitszaehler		     */
        wegptr->lifeti = nodlt;
	wegptr->nachba = (NBRTYP *) ERROR; /* Zeiger auf Nachbarn loeschen   */
        neuweg = srtrou(despoi->wege++);   /* Wege sortieren		     */
        rouher();			   /* Wege zurueck in Liste	     */
        if (neuweg < WEGE)		   /* ist der neue Weg in der Liste? */
         {
#ifndef BOXWARE
	  mulpoi.nbrptr = updnbr(digis,	   /* Nachbarnliste neuer Stand	     */
			   nachb, port);
#else
	  mulpoi.nbrptr = updnbr(digis,	nachb);	/* Nachbarnliste neuer Stand */
#endif
	  ++mulpoi.nbrptr->nbrrou;	/* 1 Weg mehr ueber diesen Nachbarn  */
          despoi->weg[neuweg].nachba =
			mulpoi.nbrptr;  /* Nachbarn als Node eintragen */
         }
        if (despoi->wege > WEGE)     /* nun mehr Wege vorhanden als erlaubt? */
         {
          --despoi->wege;	   /* darf nicht sein			     */
          if (neuweg < WEGE)	   /* wurde neuer Weg aufgenommen?	     */
            decrcn(&routmp[WEGE]); /* dann muss ein anderer entfernt werden  */
         }
        if ((despoi->actrou != 0)	/* besteht ein aktiver Weg?	     */
            && (despoi->wegnr > WEGE-1))/* und ist es der nun schlechteste?  */
         {
          despoi->wegnr = 0;	/* dann den besten nehmen		     */
          makrou();		/* und Link neu aufbauen		     */
         }
       }
    }
  else
    {
      if (mode == '-')
	delrou(rout);
      else
	{
          wegptr = &(despoi->weg[rout]);
	  if (nodlt != 0)
	   {
	    wegptr->lifeti = nodlt;
           }
          if (wegptr->obscnt != 0)
           {
            wegptr->qualit = quali;	/* Qualitaet			     */
            wegptr->obscnt = obci;	/* und Anwesenheitszaehler setzen    */
            rouhin();			/* auslagern in Arbeitsspeicher	     */
            srtrou(-1);			/* sortieren			     */
            rouher();			/* zurueck in Liste		     */
           }
	}
    }
  return (TRUE);
  }

/*---------------------------------------------------------------------------*/
VOID	delrou(nummer)		/* Weg aus Liste streichen		     */
unsigned nummer;		/* Nummer des Eintrages			     */
  {
  WEGTYP *wegptr;		/* Pointer auf Weg			     */

  decrcn(wegptr = &(despoi->weg[nummer])); /* Weg in Nachbarnliste loeschen  */
  if (despoi->wege > 1) {	/* nun noch Wege fuer dieses Ziel vorhanden? */
    wegptr->nachba = NULL;	/* ja - dieser Weg ist ungueltig	     */
    rouhin();			/* Wege in Arbeitsspeicher		     */
    srtrou(-1);			/* sortieren				     */
    rouher();			/* wieder in Liste zurueck		     */
    }
  else {			/* den letzten Weg entfernt		     */
    l3tol4();			/* an L4 melden, dass Knoten entfernt wird   */
    destot();			/* Ziel existiert nicht mehr		     */
    despoi->nodcal[0] = 0;	/* Eintrag ist wieder frei		     */
    }
  if ((despoi->wegnr >= --despoi->wege) /* aktiven Weg geloescht?	     */
    && (despoi->actrou != 0)) {
    despoi->wegnr = 0;		/* neuen Weg suchen			     */
    makrou();
    }
  }

/*---------------------------------------------------------------------------*/
VOID	decrcn(weg)		/* Weg aus Nachbarn-Liste streichen	     */
WEGTYP	*weg;			/* zu loeschender Weg			     */
  {
  NBRTYP *nbrptr;		/* Pointer auf Nachbarn			     */

  if ((--(nbrptr = weg->nachba)->nbrrou == 0) /* den letzten Weg geloescht?  */
    && !(nbrptr->nbrflg & L3FLOCKED))	      /* und Eintrag nicht gesperrt  */
      dealoc(unlink(nbrptr));	   /* dann Nachbarn komplett loeschen	     */
  }

/*---------------------------------------------------------------------------*/
VOID	rouhin()		/* Wege in Arbeitsspeicher auslagern	     */
  {
  moveb(WEGE * sizeof(WEGTYP),routmp, despoi->weg);
  }

/*---------------------------------------------------------------------------*/
VOID	rouher()		/* Wege aus Arbeitsspeicher holen	     */
  {
  moveb(WEGE * sizeof(WEGTYP), despoi->weg, routmp);
  }

/*---------------------------------------------------------------------------*/
unsigned srtrou(wegneu)		/* Wegeliste in routmp sortieren	     */
int	wegneu;			/* Position des neuen Weges in routmp	     */
				/* Rueckgabe: Position des neuen Weges	     */
  {
  unsigned akt;			/* aktuell untersuchter Weg (Nummer)	     */
  unsigned wegcnt;		/* Zahl der Wege in routmp		     */
  unsigned waktiv;		/* aktiver Weg dieses Zieles		     */
  unsigned nxt;			/* naechster zu untersuchender Weg (Nummer)  */
  WEGTYP   *wakt;		/* aktueller Weg			     */
  WEGTYP   *wnxt;		/* naechster Weg			     */

  wegcnt = despoi->wege;	/* Zahl der Wege holen			     */
  waktiv = despoi->wegnr;	/* aktiven Weg merken			     */
  for (wakt = &routmp[akt = 0];	/* Bubble Sort ueber routmp		     */
       (wegcnt-1) > akt;
       ++akt, ++wakt) {
    for (wnxt = &routmp[nxt = akt + 1];
	 nxt < wegcnt;
	 ++nxt, ++wnxt) {
      if ((! wakt->nachba)	/* der Weg muss einen Nachbarn haben	     */
	|| ((wakt->qualit & 0xff) < (wnxt->qualit & 0xff))) { /* und besser  */
	moveb(sizeof(WEGTYP), &rouwrk, wakt); /* als der vorherige sein		     */
	moveb(sizeof(WEGTYP), wakt, wnxt);	/* dann die Wege tauschen		     */
	moveb(sizeof(WEGTYP), wnxt, &rouwrk);
	if (wegneu == akt) wegneu = nxt; /* neuen Weg merken		     */
	else if (wegneu == nxt) wegneu = akt;
	if (waktiv == akt) waktiv = nxt; /* aktiven Weg merken		     */
	else if (waktiv == nxt) waktiv = akt;
    } } }
  despoi->wegnr = waktiv;	/* aktiven Weg in Liste korrigieren	     */
  return(wegneu);		/* mit Position des neuen Weges zurueck	     */
  }

/*---------------------------------------------------------------------------*/
VOID	todest(mbhd)			/* Info in Zielliste haengen	     */
MBHEAD	*mbhd;				/* Info Header			     */
  {
  relink(mbhd, despoi->nodinf.tail);	/* Info umhaengen		     */
  if (despoi->actrou == 0) {		/* kein aktiver Weg da?		     */
    despoi->wegnr = 0;			/* mit dem besten Weg beginnend	     */
    makrou();				/* Link aufbauen		     */
    }
  }

/*---------------------------------------------------------------------------*/
VOID	makrou()		/* Weg zu einem Ziel aufbauen		     */
  {
  NBRTYP    *nbrpoi;		/* Pointer auf Nachbarn			     */

  if (despoi->nodinf.head != (LHEAD *) &despoi->nodinf.head)    /* Info?     */
   {
    despoi->actrou &= ~0x07;			/* Status: kein aktiver Weg  */
    nbrpoi = despoi->weg[despoi->wegnr].nachba;	/* aktuellen Nachbarn holen  */
    lnkpoi = nbrpoi->nbrl2l;			/* dazu passenden L2-Link    */
    if (lnkpoi == NULL)				/* noch kein L2-Link?	     */
     {
      connbr(nbrpoi);				/* dann Nachbarn connecten   */
     }
    if (nbrpoi->nbrl2l == NULL)			/* kein freier Link	     */
     {
      despoi->actrou |= 0x02;			/* Fehler markieren	     */
      return;					/* Abbruch		     */
     }

    if (lnkpoi->state == L2SLKSUP)	/* Status = Connect laeuft?	     */
      despoi->actrou |= 0x01;		/* in Nachbarnliste so markieren     */
    else
      {
	if (lnkpoi->state == L2SDSCRQ)	/* Status: Disc-Requested?	     */
	  despoi->actrou |= 0x04;
	else
	  despoi->actrou = 3;	/* sonst Status = connected		     */
      }
    if ((despoi->actrou == 1)	/* Connect laeuft und			     */
      && (despoi->wegnr == 0))	/* noch kein Weg probiert		     */
      despoi->actrou |= 0x80;	/* markieren				     */
    }
  else despoi->actrou = 0;	/* keine aktive Route			     */
  }

/*---------------------------------------------------------------------------*/
VOID connbr(nbrpoi)	/* Nachbarn, auf den nbrpoi zeigt connecten	     */
NBRTYP    *nbrpoi;	/* Pointer auf Nachbarn				     */
 {
  LNKBLK    *l2poi;		/* Pointer auf Level2 Kontrollblock	     */
  LNKBLK    *l2poi2;

  l2poi = NULL;
  l2poi2 = lnktbl;
  do
   {
    if (l2poi2->state != L2SDSCED)			/* Eintrag belegt    */
     {
      if ((cmpid(nbrpoi->nbrcal, l2poi2->dstid) == TRUE)
#ifndef BOXWARE
	  &&(l2poi2->liport == nbrpoi->nbrpor)
#endif
	  &&(cmpmyc(l2poi2->srcid) == TRUE))
	break;				/* passt er zufaellig? Dann benutzen */
     }
    else				/* Eintrag ist frei		     */
     {
      if ((l2poi == NULL)
	  && (l2poi2->srcid[0] == 0))
	l2poi = l2poi2;		  	/* ersten freien Eintrag merken      */
     }
   } while (++l2poi2 < &lnktbl[LINKNMBR]);

  if ((lnkpoi = l2poi2) 	/* kein passender Eintrag gefunden?  */
	== &lnktbl[LINKNMBR])
   {
    if (l2poi != NULL)		/* freier Eintrag vorhanden?		     */
     {
      lnkpoi = l2poi;				/* dann nehmen wir ihn       */
      cpyid(l2poi->srcid, myid); 		/* Quellcall eintragen       */
      cpyid(l2poi->dstid, nbrpoi->nbrcal);	/* Zielcall eintragen	     */
      cpyidl(l2poi->viaidl, nbrpoi->nbrdil);	/* Digiliste eintragen       */
#ifndef BOXWARE
      l2poi->liport = nbrpoi->nbrpor; 		/* Port eintragen	     */
#endif
      newlnk();					/* L2-Verbindung bestellen   */
     }
   }

  nbrpoi->nbrl2l = lnkpoi;	/* in Nachbarnliste Querverweis eintragen    */
 }

/*---------------------------------------------------------------------------*/
VOID	destot()		/* Ziel ist nicht mehr erreichbar	     */
  {
  dealml(&despoi->nodinf);	/* Info fuer das Ziel wegwerfen		     */
  despoi->actrou = 0;		/* kein aktiver Weg 			     */
  }

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
BOOLEAN isgood()		/* Entscheidung ueber Qualitaet des Weges    */
  {				/* TRUE: Qualitaet ist gut fuer Speicherung  */
    return (			/* FALSE: schlechter Weg		     */
      (qualty = (
      (nbrpoi = getnei(&txfhdr[2*L2IDLEN],
		       &rxfhdr[L2IDLEN],
		       rxfprt))			/* welcher Nachbar?	     */
	== NULL)?				/* existiert er ueberhaupt?  */
	(!rxfprt ? ch0qua : ch1qua) :	/* Portqualitaet, wenn nicht da	     */
	(nbrpoi->pathqu & 0xff))	/* sonst aus Nachbarliste	     */
      >= worqua);			/* vergleichen mit Minimalqualitaet  */
  }
#else
BOOLEAN isgood()   /* bei Boxware immer Portqualitaet, da kein ROUTES-Befehl */
  {
   return ((qualty = ch0qua) >= worqua);
  }
#endif


/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
NBRTYP	*updnbr(digis, nachb, port) /* Nachbarnliste auf neuen Stand bringen */
#else
NBRTYP	*updnbr(digis, nachb)	    /* Nachbarnliste auf neuen Stand bringen */
#endif
  char	   *digis;		    /* Digiliste zum Nachbarn		     */
  char     *nachb;		    /* Call des Nachbarn		     */
#ifndef BOXWARE
  unsigned port;		    /* Port zum Nachbarn		     */
#endif
  {
  NBRTYP   *nbrbuf;			/* Buffer fuer Eintrag		     */

#ifndef BOXWARE
  if ((nbrbuf = getnei(digis, nachb, port)) == NULL)
#else
  if ((nbrbuf = getnei(digis, nachb)) == NULL)
#endif
    {					/* Eintrag existiert noch nicht	     */
      nbrbuf = (NBRTYP *) allocb();	/* Buffer beschaffen		     */
      cpyid(nbrbuf->nbrcal, nachb);	/* Call eintragen		     */
      digis[2*L2IDLEN] = 0;		/* nur 2 Digis			     */
      cpyidl(nbrbuf->nbrdil, digis);	/* Digiliste eintragen		     */
#ifdef BOXWARE
      nbrbuf->pathqu = ch0qua;
#else
      nbrbuf->pathqu = !(nbrbuf->nbrpor = port) ? ch0qua : ch1qua;
#endif
      nbrbuf->nbrflg =
      nbrbuf->nbrrou = 0;
      nbrbuf->nbrl2l = NULL;
      relink(nbrbuf, neigbl.tail);
    }
  return(nbrbuf);			/* mit Pointer auf Eintrag zurueck   */
  }

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
NBRTYP	*getnei(digis, name, port)	/* Nachbarn suchen		     */
#else
NBRTYP	*getnei(digis, name)		/* Nachbarn suchen		     */
#endif
  char	   *digis;
  char	   *name;
#ifndef BOXWARE
  unsigned port;
#endif
  {
  NBRTYP   *nachb;

    for (nachb  = (NBRTYP *) neigbl.head;
	 nachb != (NBRTYP *) &neigbl.head;
	 nachb  = (NBRTYP *) nachb->nbrlnk.head)
      {
#ifndef BOXWARE
	if (isneig(digis, name, port, nachb) == TRUE) return (nachb);
#else
	if (isneig(digis, name, nachb) == TRUE) return (nachb);
#endif
      }
    return(NULL);
  }

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
unsigned nbrprt(call)			/* Port fuer Ziel "call" suchen	     */
char *call;
 {
  NBRTYP *nachb;			/* aktueller Nachbar		     */

  for (nachb  = (NBRTYP *) neigbl.head;
       nachb != (NBRTYP *) &neigbl.head;
       nachb  = (NBRTYP *) nachb->nbrlnk.head)
   {
    if ((cmpid(call, nachb->nbrcal) == TRUE) 
	|| ((isidnt(call) == TRUE) 
	   && (cmpid(nachb->nbrcal,despoi->nodcal) == TRUE)))
     {
      return(nachb->nbrpor);
     }
   }
  return(HDLCPORT);			/* wenn kein Eintrag gefunden	     */
 }
#endif

/*---------------------------------------------------------------------------*/
BOOLEAN	iscall(call)		/* ist Call als Ziel eingetragen?	     */
char	*call;
  {
  for (despoi  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
       despoi != (NODTYP *) &destil.head;
       despoi  = (NODTYP *) despoi->nodlnk.head) {
    if (despoi->nodcal[0] != 0) { /* Eintrag definiert?			     */
      if (cmpid(call, despoi->nodcal) == TRUE) /* dann testen		     */
	return(TRUE);
    } }
  return(FALSE);
  }

/*---------------------------------------------------------------------------*/
BOOLEAN	isidnt(ident)		/* ist Ident als Ziel eingetragen?	     */
char	*ident;
  {
  for (despoi  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
       despoi != (NODTYP *) &destil.head;
       despoi  = (NODTYP *) despoi->nodlnk.head) {
    if (despoi->nodcal[0] != 0) { /* Eintrag definiert?			     */
      if (cmpcal(ident, despoi->nodide) == TRUE) /* dann testen		     */
	return(TRUE);
    } }
  return(FALSE);
  }

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
istweg(digis, call, port)		/* Test, ob ein Weg existiert	     */
#else
istweg(digis, call)			/* Test, ob ein Weg existiert	     */
#endif
  char	   *digis;			/* Digiliste			     */
  char	   *call;			/* Call des Nachbarn		     */
#ifndef BOXWARE
  char	   port;			/* Port fuer den Weg		     */
#endif
  {					/* Rueckgabe: Weg-Nummer	     */
  unsigned cnt;				/* Scratch Zaehler		     */

  for (cnt = 0;
       cnt < despoi->wege;
       ++cnt)				/* alle Wege zum Ziel testen	     */
    {
#ifndef BOXWARE
      if (isneig(digis, call, port, despoi->weg[cnt].nachba) == TRUE)
#else
      if (isneig(digis, call, despoi->weg[cnt].nachba) == TRUE)
#endif
	return(cnt);
    }
  return(ERROR);			/* Fehler, nicht gefunden	     */
  }

/*---------------------------------------------------------------------------*/
BOOLEAN	isrout(buffer)		/* Test, ob buffer in Weglisten ist	     */
NBRTYP	*buffer;
 {
  union				/* Pointer aus Platzgruenden zusammengefasst */
   {				/* VORSICHT BEI AENDERUNGEN!!		     */
    NBRTYP *nachb;
    NODTYP *despoi;
   } mulpoi;

  for (mulpoi.nachb  = (NBRTYP *) neigbl.head;	/* Nachbarnliste absuchen    */
       mulpoi.nachb != (NBRTYP *) &neigbl.head;
       mulpoi.nachb  = (NBRTYP *) mulpoi.nachb->nbrlnk.head)
    {
      if (mulpoi.nachb == buffer) return(TRUE);
    }
  for (mulpoi.despoi  = (NODTYP *) destil.head;	/* Nodesliste absuchen	     */
       mulpoi.despoi != (NODTYP *) &destil.head;
       mulpoi.despoi  = (NODTYP *) mulpoi.despoi->nodlnk.head) 
   {
    if (mulpoi.despoi == (NODTYP *) buffer) return(TRUE);
   }
  return(FALSE);		/* nicht gefunden			     */
  }

/*---------------------------------------------------------------------------*/
#ifndef BOXWARE
BOOLEAN	isneig(digis, call, port, nachb) /* Test, ob Daten in Nachbarliste   */
#else
BOOLEAN	isneig(digis, call, nachb)	 /* Test, ob Daten in Nachbarliste   */
#endif
char	*digis;			/* Digipeaterliste			     */
char	*call;			/* Call					     */
#ifndef BOXWARE
char	port;			/* Port					     */
#endif
NBRTYP	*nachb;			/* Pointer auf vermuteten Eintrag in Liste   */
  {
#ifndef BOXWARE
  return((nachb->nbrpor == port)
      && (cmpid(nachb->nbrcal, call) == TRUE)
      && (cmpidl(nachb->nbrdil, digis) == TRUE));
#else
  return((cmpid(nachb->nbrcal, call) == TRUE)
      && (cmpidl(nachb->nbrdil, digis) == TRUE));
#endif
  }

/*---------------------------------------------------------------------------*/
BOOLEAN	ge6chr(buffer, mbhd)	/* 6 Zeichen aus mbhd nach Buffer	     */
char	*buffer;		/* Rueckgabe: TRUE=hat funktioniert	     */
MBHEAD	*mbhd;
  {
  unsigned cnt;					/* Zaehler		     */

  if (morinb(mbhd) >= L2CALEN)			/* genug Zeichen da?	     */
   {
    cnt = 0;
    do
     {
      *buffer++ = upcase(getchr(mbhd) & 0x7f);	/* Zeichen holen, ablegen    */
     } while (++cnt < L2CALEN);
    return(TRUE);		/* Erfolg melden			     */
   }
  else return(FALSE);		/* nicht genug Zeichen im mbhd		     */
 }

/*---------------------------------------------------------------------------*/
VOID	pu6chr(buffer, mbhd)	/* 6 Zeichen aus Buffer in mbhd		     */
char	*buffer;
MBHEAD	*mbhd;
  {
  unsigned cnt;			/* Zaehler				     */

  cnt = 0;
  do
   {
    putchr(*buffer++, mbhd);
   } while (++cnt < L2CALEN);
 }

/*---------------------------------------------------------------------------*/
VOID delcal(call)	/* Call (o. SSID) mit Leerzeichen ueberschreiben     */
char *call;
 {
  cpycal(call,nulide);
 }

/*- Ende Level 3 ------------------------------------------------------------*/
