/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
\************************************************************************/


#include "all.h"
#include "l234.h"

#define CTXT2	0
#define CTXT4	1
#define DTXT	2
#define ITXT	3
#define ATXT	4
#define COTXT	5
#define CQTXT	6
#define DLTXT	7
#define TEXTE	8

/* Typdefinitionen fuer L7						     */

typedef	struct	usrtyp {	/* User Kontroll Block			     */
	struct usrtyp *unext;	/* doppelt verkettete Liste		     */
	struct usrtyp *uprev;
	char	status;		/* 0=leer, 1=am CCP, 2=ConReq, 3=Passworteing*/
	LNKBLK	*cblk_u;	/* eigener Kontrollblock		     */
	char	typ_u;		/* eigener Typ				     */
	LNKBLK	*cblk_p;	/* Partner Kontrollblock		     */
	char	typ_p;		/* Partner Typ				     */
	char	sysflg;		/* SYSOP Flag				     */
	char	errcnt;		/* CCP Fehlerzaehler			     */
	char	paswrd[5];	/* gegebene Passwort Stellen		     */
	MBHEAD	*mbhd;		/* eingelaufene Frames fuer User	     */
				/* Rest noch undefiniert		     */
        } USRTYP;

typedef	struct	ptctyp {	/* Patchcord Liste			     */
	LNKBLK	*luserl;	/* Level2 Link des Users		     */
	char	lusert;		/* Typ des Users			     */
	char	recflg;		/* TRUE = Reconnect erlaubt		     */
        } PTCTYP;		/* es gehoeren immer 2 Eintraege zusammen    */

typedef	union ctyp {		/* allgemeiner Kontrollblock		     */
	LNKBLK	l2blk;
	CIRTYP	l3blk;
        } CTYP;
        
typedef struct	cmdtyp {
        char	*cmdstr;
	UWORD	(*cmdfun)();
        } CMDTYP;

typedef	struct	hrdtyp {		/* Eintrag in Heardliste	     */
	char	 hrdcal[L2IDLEN];	/* gehoertes Rufzeichen		     */
	unsigned min;			/* zuletzt gehoert: Minute	     */
	unsigned hour;			/* zuletzt gehoert: Stunde	     */
	} HRDTYP;

/*--- Ende der Definitionen -------------------------------------------------*/
