/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
\************************************************************************/

/* Level 7A, Dataswitch							     */
/* Version 1.01  							     */
/* Hans Georg Giese, DF2AU, Hinter dem Berge 5, 3300 Braunschweig	     */
/* 05-MAY-88								     */

/* Aenderungen:                                                              */
/*             191288 DF6LN: Call und Alias werden beim Einschalten immer    */
/*                           aus Eprom geladen (erspart Reset mit neusetzen  */
/*                           der Parameter)                                  */
/*                           Versionsbezeichnung -> 1.01a                    */
/*             281288 DF6LN: Uplink bei #-Knoten unmoeglich                  */
/*             080189 DF6LN: RESTART-Befehl zusaetzlich                      */
/*             041289 DL2LAY: V1.01c                                         */
/*                           - Liste der fernsteuerbaren Parameter erweitert */
/*                           - Parameterumspeicherung geaendert (Block-Move  */
/*                             ueber alle incl. Passwort).                   */
/*                           - Uplink-Sperre ueber Flags.2 anstelle von #ID  */
/*                           - 'Invalid command'-Ausgabe eigene Funktion     */
/*                           - Bakenmeldung gibt zusaetzlich auch offizielles*/
/*                             Call mit aus.                                 */
/*                           - neue Befehle 'CLINFO' und 'TEST' definiert    */
/*	       150391 DF6LN: C!-Befehl zusaetzlich (Connect o. Reconnect)    */
/*	       160391 DF6LN: Uhrzeit					     */
/*	       200391 DF6LN: MHeard-befehl, Heard-Liste			     */
/*	       180192 DF6LN: partab -> L7B.C				     */
/*	       230192 DF6LN: Texte umgestellt auf Buffer		     */
/*	       230192 DF6LN: CTEXT- und DTEXT-Befehl entfaellt,		     */
/*			     AKTUELL-Befehl zusaetzlich			     */
/*	       010892 DF6LN: Bestaetigungstext bei CONNECT und CQ	     */
/*	       010892 DF6LN: Black List					     */

#include "l7.h"
#include "l7ae.h"

/*---------------------------------------------------------------------------*/
char	beades[] = { 'I','D',' ',' ',' ',' ','\140' }; /* Call fuer Bake     */
/*char	beadil[] = "";				    /* Digiliste fuer Bake   */
#define beadil nulstr
char	cqdest[] = { 'C','Q',' ',' ',' ',' ','\140' }; /* Call fuer CQ-Ruf   */
/*char	cqdil[]  = "";				    /* Digiliste fuer CQ-Ruf */
#define cqdil nulstr

char	nulstr[] = "";

/* FOLGENDE 3 TEXTE NICHT AENDERN!!!
   Die meisten Terminalprogramme leben davon !!!                             */

char	dmmsg[]  = "Busy from ";		    /* DM Meldung	     */
char	conmsg[] = "Connected to ";		    /* Connect Meldung	     */
char    recmsg[] = "> Reconnected to ";             /* ReConnect Meldung     */
char	failmsg[] = "Failure with ";


char	signon[] = "TheNet 1.19.3 by NORD><LINK (";	/* Kopfmeldung	     */
char	badcmd[] =
  "\15Invalid Command: (A)ktuell (C)onnect (CQ) (I)nfo (M)heard (N)odes (U)sers (Q)uit";

/*---------------------------------------------------------------------------*/
char	ccpcm1[] = "AKTUELL";   /* Aktuell-Text abrufen (DF6LN)		     */
char	ccpcm2[] = "CONNECT";
char	ccpcm3[] = "CQ";
char	ccpcm4[] = "C!";	/* Connect o. Reconnect (DF6LN)		     */
char	ccpcm5[] = "INFO";
char	ccpcm6[] = "MHEARD";    /* Heardliste abfragen (DF6LN)		     */
char	ccpcm7[] = "NODES";
char    ccpcm8[] = "PARMS";
char	ccpcm9[] = "QUIT";
char	ccpc10[] = "ROUTES";
char	ccpc11[] = "USERS";
char    ccpc13[] = "FLAG";      /* DL2LAY                                    */
char    ccpc14[] = "ID";	/* DL2LAY                                    */
char	ccpc15[] = "K";		/* Uhrzeit setzen (DF6LN)		     */
char	ccpc16[] = "LED";
char    ccpc17[] = "RESTART";   /* Warmstart (DF6LN)			     */  
char	ccpc18[] = "RESET";
char	ccpc19[] = "SYSOP";
char    ccpc20[] = "TEST";      /* DL2LAY                                    */
char	ccpc21[] = "BL";	/* BlackList (DF6LN)			     */

CMDTYP	cmdtab[] = {		/* Befehlstabelle			     */
        ccpcm1, ccpakt,
	ccpcm2, ccpcon,
	ccpcm3, ccpcq,
	ccpcm4, ccpc0,
	ccpcm5, ccpinf,
	ccpcm6, ccpmh,
	ccpcm7, ccpnod,
	ccpcm8, ccppar,
	ccpcm9, ccpqui,
	ccpc10, ccprou,
	ccpc11,	ccpuse,
	ccpc13, ccpflg,
	ccpc14, ccpide,
        ccpc15, ccpclk,
        ccpc16, ccpled,
        ccpc17, ccprst,
        ccpc18, ccpres,
        ccpc19, ccpsys,
	ccpc20, ccptst,
	ccpc21, ccpbl,
	NULL, NULL
        };

/*---------------------------------------------------------------------------*/
mainf()				/* Einsprung vom Assembler Teil nach Init    */
 {
  DIinc();			/* Interrupts aus			     */
  l7init();			/* Variable initialisieren		     */
  l4init();			/* Level 4      "			     */
  l3init();			/* Level 3      "			     */
  l2init();			/* Level 2      "        		     */
  magicn = MAGIC;
  srand();			/* Zufallsgenerator initialisieren	     */
  decEI();			/* Interrupts wieder an			     */
  LOOP				/* ewige Schleife			     */
   {
/*    l2();			/* Level 2				     */
/*    l3();			/* Level 3				     */
/*    l4();			/* Level 4				     */
/*    l7();			/* Timerservice				     */
    l2rx();
     l3rx();
      l4rx();
       l7();
       l4rest();
       l3rest();
       l2rest();
      l4tx();
     l3tx();
    l2tx();
   }
 }

/*---------------------------------------------------------------------------*/
VOID	l7init()		/* Variable initialisieren		     */
 {
  unsigned cnt;			/* Scratch Zaehler			     */
  PTCTYP   *ptcp;

  inithd(&usccpl);		/* CCP User Liste initialisieren	     */
  inithd(&userhd);		/* User Liste initialisieren		     */

/* Patchcordliste aufbauen		     */

  ptcp = ptcrdl;		/* Pointer in Patchcordliste auf Anfang	     */
  do
   {
    ptcp->luserl = 0;
   } while (++ptcp < &ptcrdl[NUMPAT]);


  stunde = ERROR;		/* Uhr nicht gesetzt			     */
  sec = minute =
  tic10 =			/* loeschen: 10ms Timer			     */
  lastic =			/* letzte Ablesung bei 0		     */
  tic1s =			/* Sekundenzaehler			     */
  beatim = 0;			/* Bakenuhr				     */

/* Heard-Liste initialisieren						     */

  cnt = 0;
  do
   {
    *(hrdlis[cnt].hrdcal) = ' ';
   } while (++cnt < MAXHRD);

  if (!iswarm()) 		/* nur im Kaltstart			     */
   {
     sdefpa();			/* Parameter und Passwort aus EPROM holen    */

/* Black List (Liste gesperrter Calls) loeschen				     */

    blklis[0] =

/* Texte (Info-, Connect-, Disconnect-, Aktuell-Text, usw. ) loeschen	     */

    cnt = 0;
    do
     {
      text[cnt] = NULL;
     } while (++cnt < TEXTE);
   }
 }

/*---------------------------------------------------------------------------*/
VOID	l7()		/* zeitabhaengige Funktionen, Befehlsverarbeitung    */
  {

  MBHEAD  *mhdp;		/* Pointer auf aktuelles Frame		     */
  unsigned cnt;			/* Scratch Zaehler			     */
  char	   *usnxtc;		/* naechstes Zeichen im Frame		     */
  char	   *cmdnam;		/* Befehlsname				     */
  unsigned zeit;		/* Zeit in 10ms seit letztem Service	     */
  unsigned usget;		/* Getcount				     */
  unsigned zeichen;		/* Scratch fuer gelesene Zeichen	     */
  MBHEAD  *usrmhd;		/* User MBHD Kopie			     */
  CMDTYP  *cmdpoi;		/* Pointer in Befehlstabelle		     */

  DIinc();			/* Interrupts aus			     */
  zeit = tic10 - lastic;	/* vergangene Zeit seit letztem Service	     */
  lastic = tic10;		/* neuen Nullpunkt merken		     */
  decEI();			/* Interrupts wieder frei		     */

  if (zeit != 0)		/* nicht zu oft...			     */
   {
    l2timr(zeit);			/* an Level2 melden		     */
    if ((tic1s +=zeit) >= 100)	/* alle Sekunde:		     */
     {
      tic1s -=100;		/* Uebertrag merken			     */

      if (stunde != ERROR)
       {
	if (++sec > 59)
	 {
	  sec = 0;
	  if (++minute > 59)
	   {
	    minute = 0;
	    if (++stunde > 23) stunde = 0;
	   }
	 }
       }
      chknoa();		/* Nichtstuer ueberwachen			     */
      l3timr();		/* L3-Timer (Rundsprueche, Nodesliste aufraeumen)    */
      l4timr();		/* Level4 Service				     */
      l7timr();		/* ID-Bake					     */
     }
   }

/*=== eingelaufene Info Frames fuer den CCP verarbeiten			  ===*/
  while ((mhdp = (MBHEAD *) userhd.head) != (MBHEAD *) &userhd.head)
   {                                        	/* Info Frames fuer CCP	     */
    unlink(mhdp);				/* Info aushaengen	     */

    for (userpo = (USRTYP *) usccpl.head;	/* User zur Info suchen	     */
        (USRTYP *) &usccpl != userpo;		/* gesamte Liste absuchen    */
        userpo = userpo->unext)
     {
      if ((mhdp->type == userpo->typ_u) 	/* Usertyp und Kontrollblock */
        && (mhdp->l2link == userpo->cblk_u))	/* muessen passen	     */
       {
        break;					/* dann gefunden	     */
       }
     }

    if ((USRTYP *) &usccpl == userpo)		/* kein User gefunden	     */
     {
      dealmb(mhdp);
      continue;
     }

/*=== eingelaufene Info Frames fuer User verarbeiten			  ===*/
    if (!(usrmhd = userpo->mbhd))
      userpo->mbhd = mhdp;
    else
     {
      addinf(usrmhd,mhdp);
     }
    while ((userpo != 0)		/* existiert der User noch?	     */
      && ((mhdp = userpo->mbhd) != NULL)/* ist Info da?			     */
      && (getlin(mhdp) == TRUE))	/* ist es mindestens 1 ganze Zeile?  */
     {
      clipoi = clilin;			/* Zeile als leer definieren	     */
      clicnt = 0;
      while ((morinb(mhdp) != 0)	/* so lange Zeichen vorhanden sind   */
        && ((zeichen = getchr(mhdp) & 0x7f) != 0x0d))	/* und kein <CR>     */
       {
        if ((zeichen == 0x08) || (zeichen == 0x7f))	/* Backspace	     */
         {
          if (clicnt != 0)			/* und Delete aussortieren   */
	   {
            --clipoi;
            --clicnt;
           }
         }
        else
	 {
          if ((zeichen != 0x0a)		/* Linefeed zaehlt nicht mit	     */
            && (clicnt < CLILEN))	/* Zeilenueberlauf beachten	     */
	   {
            *clipoi++ = zeichen;	/* Zeichen merken		     */
            ++clicnt;			/* mitzaehlen			     */
           }
         }
       }
      if (!morinb(mhdp))		/* wenn nun alle Zeichen verbraucht  */
       {
        dealmb(mhdp);		/* Buffer wieder freigeben		     */
        userpo->mbhd = NULL;	/* und "keine Info mehr da" markieren	     */
       }

/*=== Zeile vom User auswerten						  ===*/
    if (nmbfre > minbuf)                                             /* 116g */
    {

      clipoi = clilin;		/* zum Auswerten Pointer nach vorn	     */
      if (userpo->status == 3) { /* warten auf Passwort?		     */
        cnt = 0;
	do
	 {
          if (!nxtnos())		/* noch was da?			     */
            break;		/* nein, dann Ende			     */
          zeichen = *clipoi;	/* sonst Zeichen holen			     */
          nxtcli();
          if (defPWD[userpo->paswrd[cnt] & 0xff] != zeichen) /* stimmt?      */
            break;
          } while (++cnt < 5);		/* 5 Zeichen als Antwort	     */

        if (cnt == 5)			/* 5 Richtige?			     */
          userpo->sysflg = 1;
        userpo->status = 1;		/* neuer Status: warten auf Befehl   */
        }
      else {

        if (waicon() == TRUE)	  /* warten auf Connect?		     */
	 {
          disusr(userpo->cblk_p, userpo->typ_p); /* dann beenden	     */
          userpo->status = 1;	/* neuer Status: warten auf Befehl	     */
         }

        if (nxtnos() == TRUE) { 	/* noch was in der Zeile?	     */
          usnxtc = clipoi;
          usget = clicnt;	/* Position in der Zeile merken		     */
          cmdpoi = cmdtab;	/* Eingabe mit Tabelle vergleichen	     */
          do
           {
            clipoi = usnxtc;
            clicnt = usget;	/* fuer jeden Test auf Zeilenanfang	     */
            cmdnam = cmdpoi->cmdstr;
            while ((clicnt != 0) && (*clipoi != ' '))
	     {
              if (upcase(*clipoi) != *cmdnam) break; /* Abbruch bei ungleich */
              nxtcli();
              ++cmdnam;
             }
            if ((clicnt == 0) || (*clipoi == ' ')) break; /* passt das Wort? */
           } while ((++cmdpoi)->cmdstr != NULL); 	  /* Ende ist NULL   */

          if (cmdpoi->cmdfun != NULL)	/* auf Tabellenende gelaufen?	     */
	   {
            userpo->errcnt = 0;		/* nein, Fehlerzaehler ruecksetzen   */
            nxtnos(); 			/* vorruecken auf Argument	     */

/* ----- ggf. Uplink sperren ------------------------- DF6LN  DL2LAY ------  */

	    if ((userpo->sysflg == 0)		/* wenn nicht Sysop	     */
	       && (userpo->typ_u == 2)		/* aber Uplink		     */
	       && (cmdpoi->cmdfun != ccpsys)	/* und nicht SYSOP-Befehl?   */
	       && (Flags&4))			/* nur wenn Uplink gesperrt  */
	     {
	      disco();				/* LUEMMEL! rausschmeissen!  */
	     }
	    else
	     {
	      (*cmdpoi->cmdfun)();		/* sonst Befehl ausfuehren   */
             }

/* ------------------------------------------------------------------------  */

	   }
          
         else nocmd(); 

} } } } } }


/*---------------------------------------------------------------------------*/
VOID	nocmd()
 {
  putmsg(badcmd);
  if (++userpo->errcnt == 5)		/* Fehler zaehlen		     */
   {
    disco();
   }
 } 

/*---------------------------------------------------------------------------*/
VOID disco()
 {
  disusr(userpo->cblk_u, userpo->typ_u);
  kilusr();
 }


/*****************************************************************************\
*									      *
*  auf Link- bzw. Circuit-Statusaenderungen reagieren			      *
*									      *
\*****************************************************************************/

VOID	lxtol7(msg, link, typ)
unsigned msg;			/* LxMCONNT, LxMDISCF, LxMBUSYF, LxMFAILW    */
LNKBLK	 *link;			/* Kontrollblock			     */
unsigned typ;			/* User Typ				     */
 {
  PTCTYP *ptcp;
  unsigned cnt;			/* Scratch Zaehler			     */
  MBHEAD *bufpoi;		/* DF3AV 1.1-e */

  if (msg == L2MCONNT)		/* Meldung "Connected to"	     */
   {
    for (userpo = (USRTYP *) usccpl.head;	/* User in CCP-Liste suchen  */
         (USRTYP *) &usccpl != userpo;
         userpo = userpo->unext)
     {
      if ((waicon() == TRUE) /* Status des Users: "SABM gegeben"?	     */
	   && (userpo->typ_p == typ)	/* Partner mus erwarteter Typ sein   */
	   && (userpo->cblk_p == link)) /* Kontrollblock passt?		     */
       {
        msgfrm('D', link, typ, conmsg);	   /* Erfolg melden	     */
        for (ptcp = ptcrdl;		/* Platz in Patchcordliste suchen    */
             ptcp->luserl != NULL;
             ptcp += 2);
        ptcp->luserl = userpo->cblk_u;	/* beide User eintragen	     */
        ptcp->lusert = userpo->typ_u;		/* Kontrollblock und Typ     */
	ptcp->recflg = userpo->status != 4;	/* Reconnectflag setzen	     */
        (++ptcp)->luserl = link;
        ptcp->lusert = typ;
        kilusr();				/* User aus CCP entfernen    */
	return;
       }
     }

/* neuer User - wenn kein Nachbar, in Userliste aufnehmen und ggf. Ctext     */
/* schicken.								     */

    if ((typ == 4)				/* Wenn Meldung vom Level 4  */
	|| ((typ == 2)				/* oder vom Level 2 aber     */
	    && !getnei(link->viaidl,		/* nicht von eingetragenem   */
		   link->dstid,			/* Nachbarknoten	     */
		   link->liport)))
     {
      newusr();				/* dann ist es ein neuer Teilnehmer  */
      userpo->typ_u = typ;		/* Typ setzen	     		     */
      userpo->cblk_u = link; 		/* Kontrollblock setzen		     */
      takusr();
      bufpoi = puttxt(typ == 2 ? CTXT2
			       : CTXT4); /* Connect-Text fuer L2 bzw. L4     */
      if (!(Flags&256)			 /* wenn kein User-Prompt	     */
	 && (!bufpoi->mbpc))		 /* und kein Connect-Text	     */
       {
        dealmb(bufpoi);
       }
      else			/* Connect-Text und/oder User-Prompt	     */
       {
        seteo1(bufpoi,PFLG);
       }
     }
    return;
   } /* msg == L2MCONNT */

  cnt = 0;
  ptcp = ptcrdl;		/* DISC oder DM erhalten		     */
  do
   {
    if ((ptcp->lusert == typ)
        && (ptcp->luserl == link))   
     {
      ptcp->luserl = NULL;	/* Eintrag loeschen			     */
      cnt ^= 1;   		/* auf andere Seite der Verbindung	     */
      ptcp = &ptcrdl[cnt];

/*---------------------------------------------------------------------------*/
/*-------- RECONNECT ----- de DL8ZAW (Idee: DB2OS)---- eingebaut DL2LAY -----*/
/*---------------------------------------------------------------------------*/

      if ((cnt % 2 == 0) && (Flags&1024) && (ptcp->recflg == TRUE))
       {
        newusr();				     /* User neu aufnehmen   */
        userpo->cblk_u = (LNKBLK *) ptcp->luserl;  /* Kontrollblock setzen */
	userpo->typ_u = ptcp->lusert;	     	     /* Typ setzen	     */
	takusr();

        bufpoi = newbuf();
	paltid(bufpoi);
	putid(myid,putstr(recmsg,bufpoi));
        prompt(bufpoi);
       }
      else
	
/*---------------------------------------------------------------------------*/
       {
        disusr(ptcp->luserl, ptcp->lusert);	/* Partner		     */
       }
      ptcp->luserl = NULL;			/* Eintrag loeschen	     */
      return;					/* fertig		     */
     }
    ++ptcp;
   } while (++cnt < NUMPAT);


  for (userpo = (USRTYP *) usccpl.head;	/* muss CCP User sein	     */
       (USRTYP *) &usccpl != userpo;	/* Tabelle absuchen		     */
       userpo = userpo->unext)
   {
    if ((userpo->typ_u == typ)
        && (userpo->cblk_u == link))
     {
      if (waicon() == TRUE) 		/* User hat Connect gefordert?	     */
       {
        disusr(userpo->cblk_p, userpo->typ_p); /* Partner abwerfen	     */
       }
      kilusr();			/* und User selbst abwerfen		     */
      return;			/* fertig				     */
     }
    if (waicon() == TRUE)  /* User hat Connect gefordert		     */
     {
      if ((userpo->typ_p == typ) /* und Antwort kam vom Partner	     */
          && (userpo->cblk_p == link))
       {
        msgfrm('D', link, typ, (msg == 3) ? dmmsg : failmsg);
        userpo->status = 1;	/* neuer Status ist "warten auf Befehl"	     */
/*        return;*/
       }
     }
   }
 }

/*---------------------------------------------------------------------------*/
VOID newusr()
 {
  userpo = (USRTYP *) allocb();		/* User neu aufnehmen		     */
  userpo->mbhd = NULL;			/* keine Info			     */
  userpo->sysflg =			/* erstmal nicht Sysop		     */
  userpo->errcnt = 0;			/* bisher keine Fehler		     */
  userpo->status = 1;			/* am CCP, Befehl kommt		     */
 }

/*---------------------------------------------------------------------------*/
VOID takusr()
 {
  relink(userpo, usccpl.tail);			/* User in Kette haengen     */
 }

/*---------------------------------------------------------------------------*/
VOID	disusr(link, typ)	/* User abwerfen			     */
CTYP	 *link;			/* Kontrollblock			     */
unsigned typ;			/* User Typ				     */
  {
  LNKBLK *cblk2;		/* Kopien der Kontrollblockpointer	     */
  CIRTYP *cblk4;

  if (typ == 4)
   {
     cblk4 = cirpoi;
     cirpoi = (CIRTYP *) link;
     discir();
     cirpoi = cblk4;
   }
  else
   {
     cblk2 = lnkpoi;
     lnkpoi = (LNKBLK *) link;
     dsclnk();
     lnkpoi = cblk2;
   }
  }

/*---------------------------------------------------------------------------*/
BOOLEAN	sndmsg(typ,cflg,buf)	/* Frame an User weiterreichen		     */
MBHEAD	*buf;			/* Info					     */
BOOLEAN	cflg;			/* Congestion Flag			     */
unsigned typ;			/* User-Typ				     */
 {
  return((typ == 4) ? itocir(cflg, buf)
		    : itolnk(cflg, buf));
 }

/*---------------------------------------------------------------------------*/
BOOLEAN	fmlink(conflg, bufpoi)	/* Frame an User o. CCP weiterreichen	     */
MBHEAD	*bufpoi;		/* Info					     */
BOOLEAN	conflg;			/* Congestion Flag			     */
 {
  unsigned cnt;			/* Scratch Zaehler			     */
  PTCTYP   *ptcp;

  if (bufpoi->type != 4)
    bufpoi->morflg = 0;
  cnt = 0;
  ptcp = ptcrdl;		/* Patchcordliste absuchen		     */
  do
   {
    if ((bufpoi->type == ptcp->lusert) /* Usertyp			     */
     && (bufpoi->l2link == ptcp->luserl)) /* und Kontrollblock gleich?     */
     {
      cnt ^= 1;   		/* auf andere Seite der Verbindung	     */
      ptcp = &ptcrdl[cnt];
      bufpoi->l2link = ptcp->luserl;/* Kontrollblock des Partners eintragen*/
      return(sndmsg(ptcp->lusert,conflg,bufpoi));
      }
     ++ptcp;
    } while (++cnt < NUMPAT);		/* ob User connected ist zu Partner	     */

  relink(unlink(bufpoi), userhd.tail);		/* User ist im CCP	     */
  return(TRUE);
  }

/*---------------------------------------------------------------------------*/
VOID	prompt(bufpoi)		/* Ende Kennung an Frame anhaengen	     */
MBHEAD	*bufpoi;
 {
  seteom(bufpoi,PFLG);
 }

/*---------------------------------------------------------------------------*/
VOID	seteom(bufpoi,i)	/* Ende Kennung an Frame anhaengen mit CR    */
MBHEAD	*bufpoi;
unsigned i;			/* PFLG:   1: Userprompt gemaess Flags.8
				   PNEVER: 2: generell kein Userprompt	     */
 {
  putcr(bufpoi);			/* Zeilenende			     */
  seteo1(bufpoi,i);
 }

/*---------------------------------------------------------------------------*/
VOID	seteo1(bufpoi,i)	/* wie seteom, aber ohne CR am Anfang - und  */
MBHEAD	*bufpoi;		/* das alles nur fuer den CTEXT ..	     */
unsigned i;
 {
  LHEAD	   mbhd1;		/* LHEAD spart etliche Bytes auf dem Stack   */
  LHEAD    mbhd2;		/* gegenueber frueher MBHEAD - dabei reicht  */
  MBHEAD  *fbp;			/* LHEAD aus zum relinken ..		     */

  if ((Flags&256) && (i != PNEVER))
   {
    putcal(calofs('U', userpo->cblk_u, userpo->typ_u),bufpoi); /* Usercall   */
    putid(myid,putstr(" de ",bufpoi));
    if (stunde != ERROR)		/* ist die Uhr gestellt?	     */
     {					/* dann Uhrzeit in Prompt	     */
      puttim(stunde,minute,
		putstr(" (",bufpoi));	/* Stunde + Minute in Buffer	     */
      putstr(" UTC)",bufpoi);		/* Zeitangabe hinterher		     */
     }
    putchr('>',bufpoi);			/* Promptende			     */
   }

  inithd(&mbhd1);			/* Header fuer Restinfo		     */
  inithd(&mbhd2);			/* Header fuer abzusendende Info     */
  rwndmb(bufpoi);			/* Info auf Anfang		     */
  relink(bufpoi, (MBHEAD *) &mbhd1);	/* Info muss angehaengt sein	     */
  do
   {
    relink(fbp = newbuf(),		/* Buffer holen fuer abzusendende    */
		(MBHEAD *) &mbhd2);	/* Info				     */
    splcpy(userpo->typ_u == 4		/* Paclen an Usertype anpassen	     */
	   ? INFOLEN-L3HDRLEN-L4HDRLEN	/* wenn User = Circuit max 236 Bytes */
           : INFOLEN,			/* sonst 256 Bytes Teilinfo -> fbp,  */
	   fbp,(MBHEAD *) mbhd1.head);  /* Rest in neuen Buffer -> mbhd1.tail*/
    rwndmb(fbp);			/* Teilinfo -> Anfang		     */
    sndmsg(userpo->typ_u,TRUE,fbp);	/* muss uebernommen werden!	     */
    dealmb(unlink(mbhd1.head));		/* erster Teil der Info ist weg	     */
   } while ((MBHEAD *) mbhd1.head	/* weiter, bis alles weg	     */
		!= &mbhd1);
 }


/*---------------------------------------------------------------------------*/
VOID	l7timr()					/* Bakenservice	     */
 {
  MBHEAD  *bufpoi;				/* Buffer fuer Frame	     */

  if (((beacen&3) != 0) && (nmbfre > 128))  	/* Bake frei und Platz?	     */
   {
    if (++beatim >= 600) 			/* alle 10 min		     */
     {
      beatim = 0;
      bufpoi = putalf(signon, PNEVER);		/* Meldung in neuen Buffer   */
      bufpoi->l2fflg = L2CPID;
      paltid(bufpoi);				/* Ident in Buffer	     */
      putstr(")\15", bufpoi);			/* Frame schliessen	     */
      if (((beacen&3) == 2) || (istraf == TRUE))
       {
        sdui(beadil, beades, myid, HDLCPORT, bufpoi); 	/* als UI senden     */
        istraf = FALSE;					/* Bake erledigt     */
       }
      dealmb(bufpoi);				/* Buffer wieder freigeben   */
     }
   }
 } 

/*--- Ende Level 7a ---------------------------------------------------------*/
