/************************************************************************\
*									 *
*									 *
*    *****			*****					 *
*      *****		      *****					 *
*	 *****		    *****					 *
*	   *****	  *****						 *
*	     *****	*****		The Firmware.			 *
*	       *****  *****		The Net.			 *
*	     *****	*****		The Boxware.			 *
*	   *****	  *****		Software for Ham Radio.		 *
*	 *****		    *****	Portable. Compatible.		 *
*      *****		      *****	General Public Licensed.	 *
*    *****			*****	By NORD><LINK.			 *
*									 *
*									 *
*    TBB.C	-   The Boxware, Teil 2, Kommandos			 *
*									 *
* angelegt:	DF6LN aus TFB.C von DC4OX mit diversen Aenderungen	 *
*									 *
* modifiziert:	DF6LN  280492 Antwort auf I-Befehl ohne Parameter bei	 *
*			      fehlendem Call				 *
*		DF6LN  080493 Y-Befehl zusaetzlich			 *
*									 *
\************************************************************************/





/*								Includes  */
/**************************************************************************/

#include "all.h"	/* allgemeine Festlegungen			  */
#include "tb.h"		/* Festlegungen/Datenstrukturen fuer TheBoxware   */
#include "l234.h"	/* Festlegungen/Datenstrukturen fuer Level 2 - 4  */
#include "tbext.h"	/* globale Variable / nicht int-Funktionen	  */





/**************************************************************************\
*									   *
* "Extended Command"							   *
*									   *
* Befehle @B und @S sind von The Firmware als einzige uebrig geblieben.	   *
* Neu hinzugekommen: @N - Nodesliste					   *
*									   *
* Beim Aufruf zeigt inbufp auf das zweite Zeichen des Befehls.		   *
*									   *
\**************************************************************************/

VOID extcmd()
 {
  unsigned cmdch;
  unsigned n;

  if (incnt != 0)			/* 2. Zeichen vorhanden?	  */
   {
    cmdch = upcase(*inbufp++ & 0xFF);	/* 2. Befehlszeichen holen	  */
    --incnt;
    nxtnos();				/* Leerzeichen ignorieren	  */
    switch (cmdch)			/* was fuer ein Zeichen?	  */
     {

      case 'B':				/* @B - freie Puffer anzeigen	  */
	rsppar(nmbfre);
      break;

      case 'N':				/* @N - Nodesbefehl		  */
	ENcmd();
      break;

      case 'S':				/* @S - Linkstatus		  */
	if (actch != 0)			/* nur auf Circuitkanal		  */
	 {
	  n = cirpoi->state4;		/* Circuitstatus holen		  */
	  if (n == L4SCONN)		/* und in Linkstatus umrechnen	  */
	    n = L2SIXFER;		/* fuer Kompatibilitaet mit	  */
	  rsppar(n);			/* TheFirmware			  */
	 }
	else
	  rsppar(numdes);	/* auf Monitorkanal Anzahl Nodeseintraege */
      break;

      default:				/* unbekannter Befehl		  */
	rspiec(cmdch);
      break;

     } /* end switch (cmdch) */
   } /* end if (incnt > 0) */
  else					/* kein 2. Befehlszeichen	  */
    rspsuc();                           /* ignorieren			  */
 }




/**************************************************************************\
*									   *
* "Connect"-Befehl                                                         *
*									   *
* Wird der Connect-Befehl ohne Parameter aufgerufen, wird der Connect-Weg  *
* fuer den jeweiligen Kanal angezeigt. Beim Aufruf mit nachfolgendem Call  *
* wird auf dem Monitorkanal der L2-Pfad fuer L2-UI-Frames gesetzt. Auf	   *
* einem Circuitkanal wird ueberprueft, ob fuer das auf den Befehl folgende *
* Rufzeichen in der Nodesliste ein Eintrag existiert. Wenn ein Eintrag	   *
* existiert, wird ein Circuit zu diesem Knoten aufgebaut. Ist das Rufzei-  *
* chen nicht in der Nodesliste eingetragen, wird "NO ENTRY" als Fehler ge- *
* meldet. Ausserdem wird aus Kompatibilitaetsgruenden Link-Failure gemel-  *
* det.									   *
*									   *
\**************************************************************************/

VOID Ccmd()
 {
  char     id[L2IDLEN];
  char    *idp;
  unsigned n;
  LNKBLK  *linkp;
  MBHEAD   *mbp;


  if (!incnt)					/* Aufruf ohne Parameter  */
    rspcs();					/* Connect-Call anzeigen  */
  else						/* Aufruf mit Parameter	  */
   {
    if (!actch)					/* Monitorkanal		  */
     {
      if (bgetid(FALSE,id) == TRUE &&		/* Parameter brauchbar?	  */
	  bgetvl(VCpar,ch0via) != ERROR)
       {
	cpyid(ch0id,id);			/* UI-Zielweg kopieren	  */
	rspsuc();
	return;
       }
     }
    else				/* Circuitkanal			  */
     {
      if (myid[0] == ' ')		/* kein eigenes Call vorhanden?	  */
       {
	rspnsc();			/* meckern			  */
	return;
       }
      if (cirpoi->state4 != 0)		/* Kanal belegt?		  */
       {
	rspini(HMRFMSG);
	hputs("CHANNEL ALREADY");
	hputco();
	rspexb();
	return;
       }
      if (bgetid(VCpar,id) == TRUE)	/* legales Call			  */
       {
	if (iscall(id) == TRUE)		/* Call in Nodesliste?		  */
	 {
	  cpyid(cirpoi->downca,id);	/* Zielcall kopieren		  */
	  cirpoi->l3node = despoi;	/* Eintrag Knotenliste fuer L3	  */
	  newcir();			/* Circuit starten		  */
	  rspsuc();
	  return;
	 }
	else				/* kein Eintrag			  */
	 {
	  noent();
	  putchr('(',mbp = allocb());	/* Puffer holen			  */
	  putudc(actch,mbp);		/* Kanalnummer anzeigen		  */
	  putstr(") ",mbp);
	  putstr(l4tlfw,mbp);		/* Failure-Text			  */
	  putid(id,mbp);
	  mbp->type = 4;
	  relink(mbp, !ishmod		/* Im Terminalmodus immer, im	  */
	      ? statml.tail		/* Hostmodus nur auf angewaehl-	  */
	      : chnlml[actch-1].tail);	/* tem Kanal anzeigen		  */
	  return;
	 }
       }
     } /* end else from if (!actch) */
    rspics();				/* irgendwo falsches Call	  */
   } /* end else from if (!incnt) */
 }




/**************************************************************************\
*									   *
* "Disconnect"-Befehl                                                      *
*									   *
* Bei aktivem Circuit Disconnect einleiten. Nach Beenden des Circuit wird  *
* das eigene Rufzeichen neu gesetzt.					   *
*									   *
\**************************************************************************/

VOID Dcmd()
 {
  unsigned cstate;

  if (actch != 0)			/* Circuitkanal			  */
   {
    if ((cstate = cirpoi->state4) != 0)	/* Circuit war bisher aktiv	  */
     {
      discir();				/* Disconnect einleiten		  */
      rspsuc();
     }
    else
     {
      inicir(L4MNIX);			/* Circuit initialisieren	  */
      rspini(HMRSMSG);
      hputs("CHANNEL NOT");
      hputco();
      rspex();
     }
   }
  else                   /* Monitorkanal kann nicht disconnected werden */
    rspic('D');          /* Fehlermeldung!                              */
 }




/**************************************************************************\
*									   *
* action      :  G-Kommando (nur fuer Hostmode).                           *
*									   *
*		 Infoframedaten, Linkstatus-Meldungen, Monitorheader       *
*		 und Monitorframeinfodaten im Hostmode abholen.            *
*									   *
*		 Kanal 0   :  G  - Linkstatus/Monitorheader/Monitorinfo    *
*			      G0 - Monitorheader/Monitorinfos              *
*			      G1 - Linkstatus                              *
*									   *
*		 Kanal > 0 :  G  - Linkstati/Infoframedaten                *
*			      G0 - Infoframedaten                          *
*			      G1 - Linkstati                               *
*									   *
*		 Im Kanal 0 ist die einzig moegliche Linkstatusmeldung ein *
*		 nicht angenommener Connect-Request, in den anderen        *
*		 Kanaelen werden keine Connect-Request-Meldungen           *
*		 ausgegeben.                                               *
*									   *
*		 Es wird eine der Anforderung entsprechende Hostmode-      *
*		 antwort ausgegeben.                                       *
*									   *
 **************************************************************************
*									   *
* parameter   :  -                                                         *
*									   *
* r/o globals :  ishmod  -  TRUE = im Hostmode, sonst Terminalmode         *
*		 incnt   -  Anzahl Zeichen hinter 'G' im Eingabebuffer     *
*		 inbufp  -  Zeiger hinter 'G' in Eingabebuffer             *
*		 actch   -  Kanal des Hostmodekommandos                    *
*									   *
* r/w globals :  mifmbp  -  Zeiger auf Framekopf eines I/UI-Frames, von    *
*			    dem der Rumpf (die Daten) noch gemonitort      *
*			    werden muessen                                 *
*		 statml  -  Liste der auszugebenden Statusmeldungen fuer   *
*			    Kanal 0 (Hostmode nur Connect-Requests)        *
*		 smonfl  -  Liste der zu monitorenden Frames (Vorauswahl)  *
*		 chnlml[] - Kanal-Frame/Meldungs-Listen                    *
*		 rxf...  -  werden gesetzt, wenn neues Frame zu monitoren  *
*		 rxfctl  -  wird gesetzt und abgefragt,  "  "  "  "  "     *
*									   *
* locals      :  s.u.                                                      *
*									   *
* returns     :  -                                                         *
*									   *
\**************************************************************************/

VOID Gcmd()
  {
    unsigned    par;          /* Parameter n bei 'Gn', bei 'G' = MBALL    */
    BOOLEAN     done;         /* Flag "Hostmodeantwort ausgegeben"        */
    MBHEAD     *mbp;          /* Zeiger auf Kopf des aktuellen Frames     */

    if (ishmod == TRUE)                           /* im Hostmode ?        */
      {

	if (incnt != 0)                           /* ja, Parameter da ?   */
	  {
	    if ((par = bgetp()) > 1)              /* ja, holen            */
	      {
		rspiv(par);                       /* ... falsch angegeben */
		return;
	      }
	  }
	else                                      /* kein Parameter, alle */
	  par = MBALL;                            /* Typen sind gemeint   */


	/* G : par = MBALL   G0 : par = MBINFO   G1 : par = MBSTATUS */

	if (!actch)                               /* Monitorkanal ?       */
	  if (    (   mifmbp != NULL)             /* ja, noch alter Rest  */
	       && par != MBSTATUS)                /*     kein Status ?    */
	   {
	    if (mifmbp != NULL)                   /*     ja, Rest ...     */
	      {
		hmputr(HMRMONI);
		hmpmb(mifmbp);
		dealmb(mifmbp);
		mifmbp = NULL;                    /*     (kein Rest mehr) */
	      }
	   }
	  else                                         /* ... oder        */
	    if (    par != MBINFO                      /* Status/Alles    */
		 && (mbp = selmb(&statml,par)) != NULL /* angefordert     */
	       )                                       /* und Status da ? */
	      {
		unlink(mbp);                           /* ja, holen       */
		rwndmb(mbp);                           /* und ausgeben    */
		hmputr(HMRSTAT);                       /* (Antworttyp)    */
		hputmb(mbp);                           /* (Daten)         */
		hputnu();                              /* (Ende)          */
		dealmb(mbp);                           /* (freigeben)     */
	      }
	    else
	      {
		if (par != MBSTATUS)                   /* ... oder        */
		  {                                    /* Info/Alles      */
		    done = FALSE;                      /* angefordert und */
		    while (    !done
			    && (mbp = selmb(&smonfl,MBALL)) != NULL
			  )
		      {                                /* da ?            */
			unlink(mbp);                   /* ja, holen, und  */
			if (ismonf(mbp) == TRUE)       /* ggf. monitoren  */
			  {
			    if (    (!(rxfctl & L2CNOIM) || rxfctl == L2CUI)
				 && (morinb(mbp) > 1)
			       )
			      {                        /* bei I/UI erst   */
				hmputr(HMRMONIH);      /* Header und beim */
				mifmbp = mbp;          /* naechsten G die */
			      }                        /* Daten (Rest)    */
			    else
			      hmputr(HMRMONH);         /* sonst nur Head. */
			    frhmon(mbp);               /* Header ausgeben */
			    hputnu();
			    done = TRUE;
			  }
			if (!mifmbp) dealmb(mbp);      /* war kein UI/I   */
		      } /* end while */
		    if (!done) rspsuc();               /* wenn nix getan  */
		  } /* end if (par != MBSTATUS) */
		else                                   /* Status angef.,  */
		  rspsuc();                            /* aber keiner da  */
	      }
	else /* from if (!actch) */
	  {                                       /* Kanal > 0, passendes */
	    done = FALSE;
	    while (!done && (mbp = selmb(&chnlml[actch - 1],par)) != NULL)
	      {
		unlink(mbp);                      /* Frame/Meldung holen  */
		if (!mbp->type)
		  {                               /* ist Infoframe, wenn  */
		    if (morinb(mbp) != 0)	  /* Daten drin, alle     */
		      {                           /* ausgeben             */
			hmputr(HMRCONI);
			hmpmb(mbp);
			done = TRUE;
		      }
		  }
		else
		  {
		    rwndmb(mbp);                  /* ist Linkstatus-      */
		    hmputr(HMRSTAT);              /* meldung, diese       */
		    hputmb(mbp);                  /* ausgeben             */
		    hputnu();
		    done = TRUE;
		  }
		dealmb(mbp);                      /* Buffer freigeben     */
	      }
	    if (!done) rspsuc();                  /* wenn nix getan ...   */
	  } /* end else from if (!actch) */
      } /* end if (ishmod == TRUE) */
    else
      rspic('G');                                 /* T.-Mode: G ungueltig */
  }





/**************************************************************************\
*									   *
* "Identifier"-Befehl                                                      *
*									   *
* Bei Aufruf ohne Parameter wird das verwendete Rufzeichen des jeweiligen  *
* Kanals angezeigt. Wird als erstes Zeichen hinter dem Befehl ein '?'	   *
* eingegeben, wird auf dem Monitorkanal ausserdem der Ident ausgegeben.	   *
* Auf einem Circuitkanal wird in diesem Fall zusaetzlich der Uplinkknoten  *
* sowie gegebenenfalls die Uplink-Vialiste angezeigt. Wenn auf dem Moni-   *
* torkanal noch kein Call (incl. Ident) gesetzt ist, wird immer die Feh-   *
* lermeldung 'NO SOURCE CALLSIGN' ausgegeben.				   *
*									   *
* Zum Setzen des Eigenen Rufzeichens muss auf dem Monitorkanal ausser dem  *
* Rufzeichen auch ein gueltiger Ident angegeben werden. Dies dient als	   *
* Sicherheit, denn das eigene Rufzeichen wird schliesslich in der Nodes-   *
* liste verbreitet. Wird das eigene Rufzeichen geaendert, werden alle	   *
* bestehenden Circuits beendet, denn das alte Rufzeichen wuerde nicht mehr *
* vom L4 erkannt werden. Dadurch sind sofort saemtliche Kanaele wieder	   *
* frei. Ausserdem werden alle L2-Links disconnected, um auch dort das neue *
* Rufzeichen zu uebernehmen.						   *
*									   *
* Soll nur der Ident geaendert werden, gilt die gleiche Syntax wie fuer	   *
* eine Rufzeichenaenderung. Es muss das weiterhin zu verwendende Call vor  *
* dem neuen Ident eingegeben werden. Bestehende Circuits oder Links werden *
* nicht beendet.							   *
*									   *
* Auf einem Circuitkanal wird das zu verwendende User-Rufzeichen als Para- *
* meter eingegeben. Anschliessend kann ein Uplinkknoten und eine dazuge-   *
* hoerende Uplink-Vialiste eingegeben werden, die dann bei einem Connect   *
* weitergemeldet werden.						   *
*									   *
\**************************************************************************/

VOID Icmd()
 {
  unsigned n;
  char	   newcal[L2IDLEN];
  char	   nvial[L2VLEN+1];
  char	   nalias[L2CALEN];
  BOOLEAN  showal;

  if (!incnt          			/* Aufruf ohne Parameter oder	  */
      || (showal = (*inbufp == '?')))	/* Ident bzw. Uplinkknoten anz.   */
   {					/* nur anzeigen			  */
    if (myid[0] == ' ')			/* Call nicht gesetzt?		  */
     {
      rspnsc();				/* melden: kein Call		  */
      return;				/* das wars			  */
     }
    rspini(HMRSMSG);
    if (!actch)					/* auf Monitorkanal	  */
     {
      if (showal == TRUE) hputal(alias);	/* ggf. Ident anzeigen	  */
      hputid(myid);				/* eingenes Call anzeigen */
     }
    else					/* Circuit-Kanal	  */
     {
      hputid(cirpoi->upcall);			/* Usercall		  */
      if (showal == TRUE)			/* Uplinkknoten auch?	  */
       {
	hputsi(cirpoi->upnod);			/* Uplinkknoten		  */
	hputv(FALSE,cirpoi->upnodv);		/* Uplink-Vialiste	  */
       }
     }
    rspex();
   }
  else						/* Aufruf mit Parameter	  */
   {
    if (bgetid(VCpar,newcal) == TRUE)	/* Call holen und ueberpruefen	  */
     {
      if (!actch)	/* auf Monitor-Kanal Mycall + Ident setzen	  */
       {
	if (nxtnos() ==  TRUE)		/* kommt noch mehr?		  */
	 {
	  if (getide(nalias) == TRUE)	/* Ident holen und pruefen	  */
	   {
	    cpycal(alias,nalias);	/* Ident uebernehmen		  */
	    if (!cmpid(myid, newcal))	/* Call o. SSID geaendert	  */
	     {
	      cpyid(myid,newcal);	  /* gueltiges Call uebernehmen	  */
	      for (n = 0, cirpoi = cirtab;
		   n < NUMCIR; ++n, ++cirpoi)	/* alle Circuits	  */
	       {
		do
		 {
		  discir();	/* sofort beenden = neues Call uebernehmn */
		 }
		while (cirpoi->state4 != L4SDSCED);
	       }
	      cirpoi = cirtab;			/* wieder Monitorkanal	  */
	      for (n = 0, lnkpoi = lnktbl;
		   n < LINKNMBR; ++n, ++lnkpoi)	/* alle L2-Links	  */
	       {
		dsclnk();	/* disconnecten (und damit automatisch	  */
	       }		/* neues Call uebernehmen)		  */
	     } /* end if (!cmpid(myid,newcal) */
	   } /* end if (getide(nalias) == TRUE) */
	 } /* end if (nxtnos() == TRUE) */
       } /* end if (!actch) */
      else					/* Circuit-Kanal	  */
       {
	if (cirpoi->state4 != L4SDSCED)		/* nur auf freiem Kanal	  */
	 {
	  rspini(HMRFMSG);			/* meckern:		  */
	  hputs("NOT WHILE");			/* NOT WHILE CONNECTED	  */
	  hputco();
	  rspexb();
	  return;				/* das wars		  */
	 }
	resupn();
	cpyid(cirpoi->upcall, newcal);		/* Usercall setzen	  */
	if (bgetid(VCpar, newcal) == TRUE)	/* Uplink-Knoten holen	  */
	 {
	  cpyid(cirpoi->upnod, newcal);		/* Uplinkknoten setzen	  */
	 }
	if (bgetvl(VCpar, cirpoi->upnodv)	/* Uplink-Vialiste holen  */
		== ERROR)			/* ok?			  */
	 {
	  *cirpoi->upnodv = '\0';		/* bei Fehler loeschen	  */
	 }
       } /* end else von if (!actch) */
      rspsuc();					/* ist ok		  */
     } /* end if (bgetid... */
    else rspics();		/* Call oder Ident falsch - meckern       */
   }
 }
 




/**************************************************************************\
*									   *
* "List"-Befehl                                                            *
*									   *
* Im Terminalmodus wird fuer einen oder alle Kanaele bei aktivem Circuit   *
* angezeigt, mit welcher Gegenstation ein Circuit besteht und wieviele     *
* Empfangs- und Sendeframes gespeichert sind sowie die Zahl der unbestae-  *
* tigten Frames und die Zahl der Wiederholungen.                           *
*									   *
* Im Hostmodus wird fuer den gewuenschten Kanal die Zahl der Status-       *
* meldungen, die Zahl der noch nicht abgeholten Empfangsframes, die Zahl   *
* der ungesendeten Tx-Frames, die Zahl der unbestaetigten Frames und die   *
* Zahl der Wiederholungen ausgegeben, sowie der Circuitstatus des Kanals.  *
* Um Kompatibilitaet zur Firmware zu wahren, wird der Circuitstatus	   *
* 'Connected' umgewandelt in den Linkstatus 'Information-Transfer'. Die	   *
* anderen Werte stimmen zufaellig, daher wurde hier auf eine Uebersetzung  *
* aus Platzgruenden verzichtet.						   *
*									   *
\**************************************************************************/

VOID Lcmd()
  {
    unsigned n;
    unsigned par;
    unsigned unacked;

    if (!ishmod)                              /* im Terminalmodus         */
      if (!incnt)                             /* Aufruf ohne Parameter    */
	for (n = 0; n < NUMCIR + 1; ++n)      /* fuer alle Kanaele zeigen */
	  listch(n);
      else                               /* Aufruf mit Parameter          */
	if ((par = bgetp()) <= NUMCIR)   /* Kanalnummer holen und pruefen */
	  listch(par);
	else                             /* Kanalnummer zu gross          */
	  rspiv(par);                    /* meckern                       */
    else                                 /* Hostmodus                     */
      {
	hmputr(HMRSMSG);
	if (!actch)                       /* Monitorkanal                 */
	  {
	    hpudsp(mbcnt(&statml,MBALL)); /* Statusmsgs zaehlen + zeigen  */
	    hputud(mbcnt(&smonfl,MBALL)); /* Monitorframes zaehlen und    */
	  }                               /* zeigen                       */
	else                              /* Linkkanal                    */
	  {
	    hpudsp(mbcnt(&chnlml[actch - 1],MBSTATUS)); /* Statusmsgs     */
	    hpudsp(mbcnt(&chnlml[actch - 1],MBINFO));   /* Rx-I-Frames    */
	    unacked =                              /* unbestaetigte Tx-I- */
	      (cirpoi->l4vs - cirpoi->l4rxvs) & 127; /* Frames merken     */
	    hpudsp(cirpoi->numtx - unacked);     /* noch nicht gesendete  */
						 /* I-Frames              */
	    hpudsp(unacked);                     /* unbestaetigte Frames  */
	    hpudsp(!cirpoi->state4
		   ? 0                           /* 0 wenn disconnected   */
		   : cirpoi->l4try);     /* Zahl der Wiederholungen sonst */
	    if ((n = cirpoi->state4) == L4SCONN) /* Circuitstatus ->	  */
	      n = L2SIXFER;			 /* Linkstatus umrechnen  */
	    hputud(n);
	  }
	hputnu();
      }
  }





/**************************************************************************\
*									   *
* "Monitor"-Befehl                                                         *
*									   *
* Die Monitorparameter sowie die Rufzeichenliste fuer Monitorstationen     *
* werden angezeigt oder neu gesetzt.                                       *
*									   *
\**************************************************************************/

VOID Mcmd()
  {
    unsigned flag;
    unsigned getres;
    unsigned inchr;

    if (!incnt)                                  /* Aufruf ohne Parameter */
      {                                          /* Istzustand anzeigen   */
	rspini(HMRSMSG);
	if ((Mpar & (MONI | MONU | MONS)) != FALSE)
	 {                                       /* Monitor eingeschaltet */
	 if ((Mpar & MONI) != FALSE) hputI();    /* I-Frames              */
	 if ((Mpar & MONU) != FALSE) hputc('U'); /* U-Frames              */
	 if ((Mpar & MONS) != FALSE) hputc('S'); /* S-Frames              */
	 if ((Mpar & MONC) != FALSE) hputc('C'); /* Monitor auch auf      */
	 }                                       /* aktivem Linkkanal     */
	else                                     /* Monitor ausgeschaltet */
	  hputc('N');
	if (mftsel != 0)	   /* Rufzeichenliste aktiv		  */
	  {
	    hputsp();		   /* Space zum trennen                   */
	    hputc(!(mftsel - 1)    /* Calls aus Rufzeichenliste anzeigen  */
		  ? '+' : '-');    /* bzw. ausblenden                     */
	    hputvl(FALSE,mftidl);  /* Calls anzeigen                      */
	  }
	rspex();
      } /* end if (!incnt) */
    else                        /* Aufruf mit Parameter                   */
      {
	flag = 0;                            /* noch nix gefunden         */
	while (incnt != 0 && flag != ERROR)  /* Parameter holen           */
	  {
	    --incnt;
	    if ((inchr = upcase(*inbufp++ & 0xFF)) == ' ' || inchr == ',')
	      continue;                    /* Trennungszeichen ignorieren */
	    if (inchr == 'N')              /* Monitor aus                 */
	      {
		if (flag == 0x00FF) continue; /* 'N' vorher - weiter      */
		if (!flag)        /* bisher nix eingeschaltet             */
		  flag = 0x00FF;  /* jetzt 'M N'                          */
		else              /* vorher etwas eingeschaltet           */
		  flag = ERROR;   /* FEHLER!                              */
	      }
	    else                                /* nicht 'N'              */
	      if (inchr == '+' || inchr == '-') /* Rufzeichenliste folgt  */
		{
		  if ((getres = bgetvl(FALSE,mftidl)) != ERROR)
		    mftsel = !getres         /* ohne Calls   : 0          */
		      ? 0 : (inchr == '+'    /* '+' und Calls: 1          */
			? 1 : 2);            /* '-' und Calls: 2          */
		}
	      else                           /* nicht 'N' o. '+' o. '-'   */
		if (flag != 0x00FF)          /* vorher kein 'N'           */
		  switch (inchr)             /* FLAG entsprechend setzen  */
		    {
		      case 'I' :   flag |= MONI;   break;
		      case 'U' :   flag |= MONU;   break;
		      case 'S' :   flag |= MONS;   break;
		      case 'C' :   flag |= MONC;   break;
		      default  :   flag = ERROR;	  /* Fehler!      */
		    }
		else              /* vorher schonmal 'N'                  */
		  flag = ERROR;   /* nun nix anderes mehr erlaubt         */
	  } /* end while */
	if (flag != ERROR)	  /* kein Eingabefehler                   */
	  {
	    if (flag != 0)
	      Mpar = (flag == 0x00FF) ? 0 : flag; /* Parameter neu setzen */
	    rspsuc();
	  }
	else                                      /* Eingabefehler        */
	  rspipa();                               /* meckern              */
      } /* end else from if (!incnt) */
  }





/**************************************************************************\
*									   *
* "Stream"-Befehl                                                          *
*									   *
* Im Terminalmodus wird der aktive Kanal angezeigt bzw. neu gesetzt.       *
*									   *
\**************************************************************************/

VOID Scmd()
 {
  unsigned par;

  if (!ishmod)			/* nur im Terminalmodus			  */
   {
    if (!incnt) rsppar(actch);	/* ohne Parameter Kanal anzeigen	  */
    else			/* mit Parameter			  */
     {
      if ((par = bgetp()) <= NUMCIR)		/* Parameter holen und	  */
       {					/* pruefen		  */
	cirpoi = &cirtab[(actch = par) - 1];	/* Circuitpointer auf	  */
	rspcs();				/* neuen Kanal setzen	  */
       }
      else rspiv(par);		/* ungueltige Kanalnummer - meckern	  */
     }
   }
  else rspic('S');		/* im Hostmodus kein S-Befehl		  */
  }

/**************************************************************************\
*									   *
* "Y"-Befehl								   *
*									   *
* Einstellen bzw. anzeigen der maximalen Zahl L4-Connects von Aussen	   *
*									   *
\**************************************************************************/

VOID Ycmd()
 {
  unsigned par;

  if (!incnt)				/* ohne Parameter		  */
    rsppar(maxcir);			/* nur momentanen Wert anzeigen	  */
  else					/* mit Parameter		  */
    if ((par = bgetp()) <= NUMCIR)	/* Parameter holen und pruefen	  */
     {					/* wenn Parameter OK		  */
      maxcir = par;			/* neuen Wert uebernehmen	  */
      rspsuc();				/* das war's			  */
     }
    else				/* Eingabe falsch		  */
      rspiv(par);			/* meckern!			  */
 }


/* Ende von TBB.C */
