/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l3b.c (maintained by: ???)                                  */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2000 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

static char     orgnod[L2IDLEN];    /* Call des Quellknotens            */
static char     desnod[L2IDLEN];    /* Call des Zielknotens             */
static char     time_to_live;       /* Restlebensdauer des Frames       */

/* lokale Funktionen */
static void     init_network(void);
static void     flexnet_rx(PEER *);
static int      rtt2qual(ULONG rtt);
static int      qual2rtt(unsigned);
static void     fastlearn(PEER *, char *);
static void     propagate_node_update(INDEX);
static void     netrom_rx(PEER *);
static void     rx_l3rtt_frame(PEER *, MBHEAD *, char huge *, WORD);
static void     rx_ui_broadcast(PEER *, MBHEAD *);
static void     rx_broadcast(PEER *, MBHEAD *);
static void     sdl3ui(PEER *, MBHEAD *);
static void     add_netrom_info(MBHEAD **, NODE *, PEER *, PEER *, unsigned);
static void     add_thenet_info(MBHEAD **, NODE *, PEER *, PEER *, unsigned);
static void     addbro(MBHEAD **, NODE *, PEER *, PEER *, unsigned,
                       unsigned, int);
static BOOLEAN  check_destot(INDEX);
static void     check_all_destot(void);
static void     newnbr(PEER *);
static void     disnbr(PEER *);
static PEER    *ispeer(void);
static void     netrom_status(PEER *, WORD);
static void     rxneig(PEER *, MBHEAD *);
static void     putnod(NODE *, int, MBHEAD *);
static void     show_nodes(const char *, int);
static BOOLEAN  isneig(const char *, const char *, int, PEER *);
static WORD     nodprm(char *, WORD, UBYTE *, UWORD *, UBYTE *);
static BOOLEAN  rx_inp_broadcast(PEER *, MBHEAD *);
static void     request_nrr(char *, UID);
static void     nrr2usr(NRRLIST *);
static void     send_nrr_frame(NRRLIST *);
static void     nrr_rx(MBHEAD *, PEER *);
static void     dump_options(NODE *, MBHEAD *);
static BOOLEAN  update_options(INDEX, const char *, ULONG, UBYTE, MBHEAD *);
static void     mstatus(PEER *, WORD status);
void            send_l3srtt_frame(PEER *);
void            discnbp(PEER *);
void            clear_dests(void);
void            brosnd(MBHEAD **, PEER *);
void            inform_peer(PEER *, int);
void            changealias(int, char *, char *);
void            add_inp_info(MBHEAD **, NODE *, PEER *, unsigned,
                             unsigned, int);

int             max_nodes = MAX_NODES;  /* Default-Werte fuer den       */
                                        /* Network-Heap                 */
int             max_peers = MAX_PEERS;
UWORD           max_lt = 30;          /* Maximale LT                    */
int             num_nodes_max = 0;    /* bisher max. registrierte Nodes */

#define DIRTY   60001U

/************************************************************************\
*                                                                        *
* Netzwerk-Heap initialisieren                                           *
*                                                                        *
\************************************************************************/
static void
init_network(void)
{
  char *s;

  if ((s = getenv("TNNCFG")) != NULL)
    sscanf(s, "%d,%d", &max_nodes, &max_peers);

  max_nodes = max(max_nodes, 1);
  max_peers = max(max_peers, 1);
  if (!register_network(max_peers, get_next_prim(max_nodes)))
    memerr();
  xprintf("*** NETWORK startup, %d Nodes, %d Neighbours\n",
          netp->max_nodes, netp->max_peers);
}

/************************************************************************\
*                                                                        *
* Initialisierung des Level 3                                            *
*                                                                        *
* FlexNet und Net/ROM Router intialisieren, Ziellisten loeschen.         *
*                                                                        *
\************************************************************************/
void
l3init(void)                    /* Level 3 initialisieren               */
{
  inithd(&l3rxfl);              /* Liste empfangene Frames loeschen     */
  inithd(&l3txl);               /* Liste zu sendende Frames loeschen    */
  init_network();
}

/************************************************************************/
/*                                                                      */
/* Informationstransfer von Level3 zum Level2                           */
/* Uebergeben werden reine Datenpackete ohne AX.25-Header. Diese werden */
/* dann an den angegebenen Link gehaengt und mit der gewuenschten PID   */
/* gesendet. Grosse Frames (> 256 Bytes) werden fragmentiert und mit    */
/* PID 0x08 gesendet (die gewuenschte PID wird im 1. Fragment ueber-    */
/* mittelt).                                                            */
/*                                                                      */
/************************************************************************/
void
i3tolnk(UBYTE pid, LNKBLK *linkp, MBHEAD *imbp)
{
  int           anz_frag,
                info;
  MBHEAD       *tmpmbp;
  BOOLEAN       frame1 = TRUE;

  info = imbp->mbpc - imbp->mbgc;
  ptctab[g_uid(linkp, L2_USER)].infotx += info;
  linkp->noatou = ininat;                       /* wieder Aktivitaet    */
  if (info < 257)
  {
    imbp->l2fflg = pid;                         /* PID uebernehmen      */
    imbp->repeated = 0;
    relink((LEHEAD *)imbp,                      /* -> ab in den Link    */
           (LEHEAD *)linkp->sendil.tail);
    ++linkp->tosend;                            /* ein Sendepaket mehr  */
  }
  else
  {
/* fuer grosse Packete generieren wir AX25-Fragmente                    */
    anz_frag = info / 255;              /* wieviele Folgefragmente?     */
    if (anz_frag > 127)                 /* zu gross geht nicht          */
    {
      dealmb(imbp);
      return;
    }
    do
    {
      tmpmbp = (MBHEAD *)allocb(ALLOC_MBHEAD);  /* Buffer holen         */
      tmpmbp->l2fflg = L2CFRAG;         /* wir senden mit PID 08        */
      tmpmbp->repeated = 0;
      if (frame1)
      {
        putchr(anz_frag | 0x80, tmpmbp);/* es folgen n Fragmente        */
        putchr(pid, tmpmbp);            /* mit pid                      */
        frame1 = FALSE;
      }
      else
        putchr(anz_frag, tmpmbp);       /* es folgen n Fragmente        */
      while (tmpmbp->mbpc < 256)        /* max. 256 Bytes im Fragment   */
      {
        if (!(imbp->mbpc - imbp->mbgc)) /* Frameende                    */
          break;
        putchr(getchr(imbp), tmpmbp);   /* Daten umkopieren             */
      }
      rwndmb(tmpmbp);                       /* zurueckspulen            */
      relink((LEHEAD *)tmpmbp,              /* in die Sendeliste damit  */
             (LEHEAD *)linkp->sendil.tail);
      ++linkp->tosend;                      /* ein Frame mehr zu senden */
    } while (anz_frag-- > 0);
/* wir sind fertig                                                      */
    dealmb(imbp);
  }
}

/************************************************************************\
*                                                                        *
* Informationstransfer von Level2 zum FlexNet-Router                     *
* Fuer jedes empfangene Packet wird die Flexnet-Behandlungsroutine       *
* aus src/l3c.c aufgerufen.                                              *
*                                                                        *
\************************************************************************/
static void
flexnet_rx(PEER *pp)
{
  MBHEAD *mbp;

  /* Zunaechst empfangene Frames verarbeiten, bis Liste leer...         */
  while (   (mbp = (MBHEAD *)(pp->rxfl.head))
         != (MBHEAD *)&(pp->rxfl))
  {
    ulink((LEHEAD *)mbp);           /* Packet aus der Liste aushaengen  */
    flex_rx(pp, mbp);               /* Auswertung durchfuehren          */
    dealmb(mbp);                    /* fertig, Buffer freigeben         */
  }
}

/************************************************************************\
*                                                                        *
* Das Frame mit der gewuenschten Kennung vergleichen. Wenn ja,           *
* wird sie ueberlesen, sonst wird mbbp/mbgc restauriert.                 *
*                                                                        *
\************************************************************************/
BOOLEAN
match(MBHEAD *fbp, const char *text)
{
  char huge *mbbp;                  /* Sicherung von mbbp               */
  UWORD      mbgc;                  /* Sicherung von mbgc               */

  mbbp = fbp->mbbp;                 /* Position im Frame (mbbp,mbgc)    */
  mbgc = fbp->mbgc;                 /* merken, falls kein Erfolg        */
  while (*text)
  {                                 /* die Kennung durchgehen           */
    if (getchr(fbp) != *text++)
    {                               /* Abweichung!                      */
      fbp->mbbp = mbbp;             /* auf die alte Position im Frame   */
      fbp->mbgc = mbgc;             /* zurueckgehen                     */
      return (FALSE);               /* Kennung stimmt nicht             */
    }
  }
  return (TRUE);                    /* Kennung stimmt                   */
}

/************************************************************************/
/*                                                                      */
/* Umrechnung NETROM-Qualitaet <-> Laufzeit                             */
/*                                                                      */
/************************************************************************/
static int
rtt2qual(ULONG rtt)                 /* Laufzeit zu Qualitaet            */
{
  int qual;

  if (rtt)
  {
    qual = 255 - (unsigned)(rtt / autoqual);
    if (qual > 254)
      qual = 254;
    if (qual < 3)
      qual = 3;
    return (qual);
  }
  return (0);                       /* ausgefallen                      */
}

static int
qual2rtt(unsigned qual)             /* Qualitaet zu Laufzeit            */
{
  if (qual < 2)
    return (0);                     /* unerreichbar                     */
  return ((256 - qual) * autoqual);
}

/************************************************************************/
/*                                                                      */
/* Die Absenderknoten muessen in der Nodesliste stehen, damit wir       */
/* Antworten zurueckschicken koennen. Ist ein Absender noch nicht       */
/* bekannt, wird dieser mit einer Laufzeit von 599,99s eingetragen.     */
/*                                                                      */
/************************************************************************/
static void
fastlearn(PEER *pp, char *id)
{
  INDEX index = find_node_this_ssid(id);
  char  notify_call1[10];
  char  notify_call2[10];

  if (index != NO_INDEX)            /* Node bekannt und Qualitaet gut   */
    if (pp->routes[index].quality)  /* dann nicht lernen                */
      return;
  if ((index = add_route(pp, id, LEARN)) != NO_INDEX)
  {
    update_lt(pp, index, DEFAULT_LT);
    call2str(notify_call1, orgnod);
    call2str(notify_call2, pp->l2link->call);
    notify(7, "fastlearn %s via %s",
           notify_call1, notify_call2);
  }
}

/************************************************************************/
/*                                                                      */
/* Eine Bake senden mit Informationen zur erfolgten Laufzeitmessung     */
/*                                                                      */
/************************************************************************/
void
rtt_metric(PEER *pp, long rtt)
{
  BEACON    *beapoi;            /* Zeiger auf einen Baken-Eintrag       */
  int        i;
  MBHEAD    *mbp;
  struct tm *p;
  LNKBLK    *lp;
  PTCENT    *ptcp;
  int        telemetrie;

  p = localtime(&sys_time);

  /* fuer alle Ports, bei denen die Bake freigegeben ist.. */
  for (i = 0, beapoi = beacon; i < L2PNUM; ++beapoi, ++i)
  {
    if ((telemetrie = beapoi->telemetrie) >= 2)
    {
      (mbp = (MBHEAD *)allocb(ALLOC_MBHEAD))->l2fflg = L2CPID;
      lp = pp->nbrl2l;
      ptcp = ptctab + g_uid(lp, L2_USER);
      if (telemetrie != 2)       /* Format fuer automatische Auswertung */
      {
        mbp->l4time = mbp->mbpc;
        putid(pp->l2link->call, mbp);         /* Node Call              */
        putspa(10, mbp);
        putprintf(mbp, "%2d %02d.%02d.%02d %02d:%02d:%02d",
                  lp->liport,
                  p->tm_mday, p->tm_mon + 1, p->tm_year % 100,
                  p->tm_hour, p->tm_min, p->tm_sec);
        putprintf(mbp, " %7lu", rtt * 10L);

        if (pp->quality > 9999)
        {
          putprintf(mbp, " %2lumin", pp->quality / 6000);
        }
        else
          putprintf(mbp, " %5lu", pp->quality * 10L);

        if (pp->my_quality > 9999)
        {
          putprintf(mbp, " %2lumin", pp->my_quality / 6000);
        }
        else
          putprintf(mbp, " %5lu", pp->my_quality * 10L);

        if (pp->his_quality > 9999)
        {
          putprintf(mbp, " %2lumin", pp->his_quality / 6000);
        }
        else
          putprintf(mbp, " %5lu", pp->his_quality * 10L);

        putprintf(mbp, " %7lu %lu\r",
                  lp->SRTT * 10L,
                  ptcp->inforx + ptcp->infotx);
      }
      else
      {
        putprintf(mbp, "%02d.%02d.%02d %02d:%02d:%02d ",
                  p->tm_mday, p->tm_mon + 1, p->tm_year % 100,
                  p->tm_hour, p->tm_min, p->tm_sec);
        putid(pp->l2link->call, mbp);         /* Node Call              */
        putprintf(mbp, "(%02d)\rL3RTT=%lums L3SRTT=%lums (%lums/%lums) "
                       "L2SRTT=%lums SUM=%lu\r",
                  lp->liport,
                  rtt * 10L,
                  pp->quality * 10L,
                  pp->my_quality * 10L,
                  pp->his_quality * 10L,
                  lp->SRTT * 10L,
                  ptcp->inforx + ptcp->infotx);
      }
      rwndmb(mbp);
      sdui(beapoi->beadil, "METRIC\140", myid, i, mbp);
      dealmb(mbp);                   /* Telemetrie-Frame kann jetzt weg */
    } /* Telemetrie */
  } /* alle Ports */
}

/************************************************************************/
/*                                                                      */
/* Wenn sich die Info zu einem Node aendert, werden alle INP-Routes zur */
/* Aktualisierung ausgeschrieben.                                       */
/*                                                                      */
/************************************************************************/
static void
propagate_node_update(INDEX index)
{
  PEER  *pp;
  ROUTE *rp;
  int    max_peers = netp->max_peers;
  int    i;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
  {
    if (!pp->used)
      continue;
    if (pp->typ != INP)
      continue;
    rp = pp->routes + index;
    if (rp->reported_quality)           /* nur wenn wir gemeldet hatten */
      rp->reported_quality = DIRTY;
  }
}

/************************************************************************\
*                                                                        *
* Informationstransfer von Level2 zum NET/ROM-Router                     *
*                                                                        *
* Die empfangenen Frames vom Nachbarn werden ausgewertet und ggf. an den *
* eigenen L4 (Verbindungsebene) oder an einen anderen Nachbarn           *
* weitergeleitet.                                                        *
*                                                                        *
\************************************************************************/
static void
netrom_rx(PEER *rxpp)
{
  MBHEAD     *mbp;              /* Buffer fuer ein Frame                */
  char huge  *savmbbp;          /* mbbp-Sicherung                       */
  WORD        savmbgc;          /* mbgc-Sicherung                       */
  NODE       *srcnod;
  NODE       *dstnod;
  PEER       *pp;
  MHEARD     *mhp;
  int         mask;
  char        notify_call1[10];
  char        notify_call2[10];
  char        notify_call3[10];

/* Zunaechst empfangene Frames verarbeiten, bis Liste leer...           */
  while (   (mbp = (MBHEAD *)(rxpp->rxfl.head))
         != (MBHEAD *)&(rxpp->rxfl))
  {
    ulink((LEHEAD *)mbp);               /* 1 Frame aus der Liste holen  */
    if (mbp->l2link == NULL)
      rx_ui_broadcast(rxpp, mbp);       /* ist UI-Broadcast             */
    else                                /* Info Frame                   */
    {
      if (rx_inp_broadcast(rxpp, mbp))  /* INP Broadcast?               */
      {
        dealmb(mbp);
        continue;
      }
      savmbbp = mbp->mbbp;              /* Position im Frame merken     */
      savmbgc = mbp->mbgc;              /* fuer Weiterleitung           */
      if (   (getfid(orgnod, mbp))      /* Call des Quellknotens holen  */
          && (getfid(desnod, mbp))      /* Call des Zielknotens holen   */
          && (mbp->mbgc < mbp->mbpc))   /* und Info im Frame?           */
      {
        if (   valcal(orgnod) == ERRORS /* Absender und Zielrufzeichen  */
            || valcal(desnod) == ERRORS /* pruefen                      */
           )
        {
          call2str(notify_call1, orgnod);
          call2str(notify_call2, desnod);
          call2str(notify_call3, rxpp->l2link->call);
          notify(3, "invalid node %s>%s from %s (flushed)",
                 notify_call1, notify_call2, notify_call3);
                                        /* wir sagens dem Sysop         */
          dealmb(mbp);                  /* Frame wegwerfen              */
          continue;                     /* ... und zum naechsten Frame  */
        }
        --(*(mbp->mbbp));               /* Restlebensdauer um 1 runter  */
        time_to_live = getchr(mbp);     /* Restlebensdauer lesen        */

        if ((mbp->mbpc - mbp->mbgc) >= 5)  /* ist es lang genug ?       */
        {
/* Frames, die von einem Knoten kommen, der noch nicht in unsere        */
/* Knoten-Liste eingetragen ist, fuehren zu einem Eintrag des Quell-    */
/* Knotens mit Qualitaet 59999 in unsere Nodes-Liste (Fast-Learn)       */

          if (   !cmpid(myid, orgnod)           /* kein eigenes Frame   */
              && !cmpid(myid, rxpp->l2link->call))
            fastlearn(rxpp, orgnod);

          l4hdr0 = getchr(mbp);         /* Header holen                 */
          l4hdr1 = getchr(mbp);         /* ist eigentlich Sache des L4, */
          l4hdr2 = getchr(mbp);         /* aber der L3 verschickt auch  */
          l4hdr3 = getchr(mbp);         /* L4-Messframes, deswegen      */
          l4hdr4 = getchr(mbp);         /* wird das schon hier er-      */
          l4opco = l4hdr4 & L4OPMASK;   /* ledigt.                      */

          if (l4opco == L3TCPUDP && l4hdr0 == 0 && l4hdr1 == 1)  /* NRR */
          {
            nrr_rx(mbp, rxpp);
            dealmb(mbp);                 /* Frame wegwerfen             */
            continue;                    /* ... und zum naechsten Frame */
          }

/*----- Auswertung der eigenen und fremden L3RTT Frames ----------------*/
          if (   cmpid(desnod, "L3RTT \140")  /* Ziel und Inhalt OK!    */
              && (   cmpid(orgnod, rxpp->l2link->call)
                  || cmpid(orgnod, myid)))    /* und von dem Nachbarn   */
          {                                   /* oder eigenes           */
            rx_l3rtt_frame(rxpp, mbp, savmbbp, savmbgc);
            continue;
          }

/* L3-MH-Liste fuehren                                                  */
          if ((mhp = mh_lookup(&l3heard, orgnod)) == NULL)
            mhp = mh_add(&l3heard);
          if (mhp)
          {                                /* Eintrag vorhanden?        */
            mh_update(&l3heard, mhp, orgnod, mbp->l2port);
            mhp->rx_bytes += (mbp->mbpc - mbp->mbgc);
          }

/*----------------- Frame ist fuer mich --------------------------------*/
          if (cmpid(myid, desnod))
          {
#ifdef IPROUTE
            if (l4opco == L3TCPUDP)
            {                              /* L3 TCP/UDP-Frame          */
              mbp->l2fflg = L2CIP;         /* es ist ein IP-Frame       */
              relink((LEHEAD *)mbp, (LEHEAD *)iprxfl.tail);
              continue;                    /* Frame verarbeitet         */
            }
#endif
            mbp->l3_typ = L3NORMAL;        /* kein LOCAL und kein L3RTT */
            if (iscall(orgnod, &srcnod, NULL, DG))     /* Absender-Node */
            {
              l4rx(srcnod, NULL, mbp);     /* Frame an Level 4 geben    */
              continue;                    /* naechstes Frame           */
            }
            call2str(notify_call1, orgnod);
            notify(5, "unreachable source node %s", notify_call1);
            dealmb(mbp);                   /* Frame entsorgen           */
            continue;
          }

/* MH-Liste Senderichtung                                               */
          if ((mhp = mh_lookup(&l3heard, desnod)) != NULL)
            mhp->tx_bytes += (mbp->mbpc - mbp->mbgc);

/*---- nur CONREQ kann auf L2 umgeroutet werden */
          if ((l4opco == L4CONREQ) || (l4istome(orgnod, desnod)))
            mask = DG | VC | VC_FAR;
          else
            mask = DG;

/*---- Level 3 Frame nicht fuer mich, sondern weiterleiten -----*/
          if (iscall(desnod, &dstnod, &pp, mask))
          {                                         /* Ziel erreichbar? */
/* wenn das Ziel nicht im DG-Mode erreicht werden kann, dann muessen    */
/* wir umsetzen.                                                        */
            if ((pp->options & DG) == 0)
            {
              mbp->l3_typ = L3LOCAL;
              mbp->l2link = (LNKBLK *)dstnod;             /* Ziel-Node  */
              if (iscall(orgnod, &srcnod, NULL, DG))      /* Absender   */
              {
                l4rx(srcnod, dstnod, mbp);
                continue;                  /* naechstes Frame           */
              }
              call2str(notify_call1, orgnod);
              notify(5, "unreachable source node %s", notify_call1);
              dealmb(mbp);                 /* Frame entsorgen           */
              continue;
            }

            if (time_to_live)
            {                              /* noch Restlebensdauer?     */
              mbp->mbbp = savmbbp;
              mbp->mbgc = savmbgc;

              if (cmpid(myid, orgnod))  /* eigenes Frame gehoert, weg   */
              {                         /* damit                        */
                call2str(notify_call1, desnod);
                call2str(notify_call2, rxpp->l2link->call);
                notify(5, "own frame to %s received fm %s (loop)",
                       notify_call1, notify_call2);
                dealmb(mbp);
                continue;
              }

/* Falls wir ein Frame ueber den Nachbarn zurueckschicken               */

              if (rxpp == pp)        /* wuerden, dann vernichten wir es */
              {
                call2str(notify_call1, orgnod);
                call2str(notify_call2, desnod);
                call2str(notify_call3, rxpp->l2link->call);
                notify(5, "frame fm %s to %s via %s flushed (neigb loop)",
                       notify_call1, notify_call2, notify_call3);
                dealmb(mbp);
                continue;
              }

              toneig(pp, mbp);          /* Info absetzen                */
              continue;
            }                           /* noch Restlebensdauer         */
          }                             /* Ziel bekannt                 */
        }                               /* Laenge ok                    */
      }                                 /* Info ist im Frame            */
    }                                   /* es ist ein I-Frame           */
    dealmb(mbp);
  }
}

/************************************************************************/
/*                                                                      */
/* L3RTT-Frames auswerten: Entweder sind es Messframes fuer Laufzeit-   */
/* messungen oder aber NODES-Meldungen bei ON5ZS-Routing                */
/*                                                                      */
/************************************************************************/
static void
rx_l3rtt_frame(PEER *rxpp, MBHEAD *mbp, char huge *savmbbp, WORD savmbgc)
{
  char        rx_alias[L2IDLEN]; /* Ident des Nachbarn (wenn bekannt)   */
  char        ver[12];           /* Version des Nachbarn                */
  WORD        i,
              j;                /* Zaehler                              */
  char        buffer[150];      /* Speicher fuer RTT String-Operationen */
  char       *bp;
  char        version[4];       /* TNN-Version                          */
  ULONG       prev_tic10;       /* Zeitpunkt der RTT Messung in 10ms    */
  ULONG       prev_l3srtt;      /* letzter SRTT (smoothed RTT)          */
  ULONG       prev_l3rtt;       /* letzter gemessener RTT-Wert          */
  PEER       *rtt_pp;           /* Pointer auf Nachbarliste             */
  char        buf2[8];
  ULONG       rtt;
  MBHEAD     *inpmbp;
  NODE        node;
  INDEX       index;
  ULONG       maxtime;

  if (l4opco == L4INFTRA)               /* Info-Transfer                */
  {
    if (match(mbp, "BROAD"))            /* BROAD Kennung ?              */
    {
      if (cmpid(rxpp->l2link->call, orgnod) == TRUE)
        if (rxpp->typ == TNN)           /* kann der andere Info?        */
          rx_broadcast(rxpp, mbp);      /* dann auswerten               */
        dealmb(mbp);                    /* Buffer entsorgen             */
        return;
    }

    if (match(mbp, "L3RTT:"))           /* L3RTT Kennung ?              */
    {
      for (i = 0; ((i < 110) && (mbp->mbgc < mbp->mbpc)); i++)
        buffer[i] = getchr(mbp);
      strcpy(&buffer[i], " 1 2 3 4 5 6 \n\0");

      sscanf(&buffer[0], "%lu %lu %lu %lu %6s %11s %6s",
             &prev_tic10,
             &prev_l3srtt,
             &prev_l3rtt,
             (long *)&rtt_pp,
             rx_alias,
             ver,
             buf2);
      *version = NUL;
      if (!strncmp(buf2, "TNN", 3))
        strcpy(version, &buf2[3]);

      for (i = j = 0; i < L2CALEN; i++)
        if (rx_alias[i] == 0x00 || j == 1)
        {
          rx_alias[i] = ' ';            /* mit Leerzeichen fuellen      */
          j = 1;
        }

/* .................................................................... */
/* Eigenes Frame auswerten                                              */
/* .................................................................... */
      if (cmpid(orgnod, myid))               /* selbst Absender         */
      {
        if ((rtt_pp == rxpp))                /* passender Nachbar       */
          if (   tic10 > prev_tic10          /* Uhr nicht uebergelaufen */
              && rxpp->rttstart == prev_tic10   /* richtige Messung     */
              && ((tic10 - prev_tic10) < 10000))/* nicht zu lang!       */
          {                                     /* gemessene L3-RTT     */
            rtt = (tic10 - prev_tic10) + 2;
            update_peer_quality(rxpp, rtt / 2, DONT_CHANGE_QUAL);

/* Falls das Timeout auf einer Route mal abfaellt, melden wir hier      */
/* wieder die Routen-Qualitaet hoch.                                    */
            if ((index = add_route(rxpp, rxpp->l2link->call, 1))
                       != NO_INDEX)
              update_lt(rxpp, index, 1);
            rtt_metric(rxpp, (long)rtt);
            rxpp->rttstart = 0L;
            rxpp->rtt_time = L3_RTT_TIME;
          }
        dealmb(mbp);
        return;
      } /* eigenes L3RTT-Frame */

/* Fremdes L3RTT-Frame auswerten, und an Nachbarn zurueck               */
      if (cmpid(rxpp->l2link->call, orgnod) == TRUE)
      {
        if (time_to_live >= 1)
        {                               /* noch Restlebenszeit..        */
          mbp->mbbp = savmbbp;
          mbp->mbgc = savmbgc;
          toneig(rxpp, mbp);
          if (strnicmp("LEVEL3_V2.1", ver, 11) == 0)
          {
            if (rxpp->typ == NETROM)
              set_peer_typ(rxpp, TNN);
            rxpp->version = atoi(version);
            cpyals(rxpp->l2link->alias, rx_alias);
          }
          else
            cpyals(rx_alias, rxpp->l2link->alias);

          if (strstr(buffer, "$N"))
          {
            if (rxpp->typ != INP)
            {
              set_peer_typ(rxpp, INP);
              cpyid(node.id, myid);
              cpyals(node.alias, alias);
              node.ipa = 0L;
              node.bits = 0;
              node.options = NULL;
              inpmbp = NULL;
              add_inp_info(&inpmbp, &node, rxpp, 1, 0, 1);
              brosnd(&inpmbp, rxpp);
            }
          }

          if (rxpp->typ == INP)
          {
            if ((bp = strstr(buffer, "$M")) != NULL)
            {
              sscanf(bp + 2, "%lu", &maxtime);
              rxpp->maxtime = (UWORD)maxtime;
            }
            else
              rxpp->maxtime = 0;
          }

          if (prev_l3srtt >= 5L)
            update_peer_quality(rxpp, DONT_CHANGE_QUAL, prev_l3srtt);

          if ((index = add_route(rxpp, rxpp->l2link->call, 1)) != NO_INDEX)
          {
            update_lt(rxpp, index, 1);
            if (update_alias(index, rx_alias))
              propagate_node_update(index);
          }
          return;
        }
      }
    } /* L3RTT: */
  } /* L4-Info-Frame */
  dealmb(mbp);
}

/************************************************************************/
/*                                                                      */
/* L3 UI-Frame (Broadcast)                                              */
/*                                                                      */
/************************************************************************/
static void
rx_ui_broadcast(PEER *rxpp, MBHEAD *mbp)
{
  char  alias[L2CALEN];         /* Alias Rundspruch sendender Knoten    */
  INDEX index;

  if (worqua != 0)                      /* darf Auswertung erfolgen?    */
  {
    if (   mbp->mbgc < mbp->mbpc        /* Info im Frame?               */
        && (getchr(mbp) & 0xFF) == 0xFF /* stimmt Signatur              */
        && ge6chr(alias, mbp))          /* Alias des Absender-Knotens   */
    {
      cpyals(rxpp->l2link->alias, alias);
      if ((index = add_route(rxpp, rxpp->l2link->call, 1)) != NO_INDEX)
      {
        update_lt(rxpp, index, 1);
        if (update_alias(index, alias))
          propagate_node_update(index);
        rx_broadcast(rxpp, mbp);
      }
    }
  } /* Signatur ist gut */
} /* Auswertung zulaessig */


/*----------------------------------------------------------------------*/
/* l3rx()           Empfangene Frames der Nachbarn verarbeiten.         */
/*----------------------------------------------------------------------*/
void
l3rx(void)
{
  PEER *pp;
  int   max_peers = netp->max_peers;
  int   i;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
  {
    if (!pp->used)
      continue;
    switch (pp->typ)
      {
        case FLEXNET:
          flexnet_rx(pp);
          break;
        case NETROM:
        case TNN:
        case THENET:
        case INP:
          netrom_rx(pp);
          break;
      }
  }
}

/*----------------------------------------------------------------------*/
static void
rx_broadcast(PEER *rxpp, MBHEAD *mbp)
{
  char   desnod[L2IDLEN];
  char   beaide[L2CALEN];
  char   nbr_call[L2IDLEN];
  int    rx_qual;
  INDEX  index;
  PEER  *pp;
  char   notify_call1[10];
  char   notify_call2[10];
  char   notify_call3[10];

  if (rxpp->typ == INP)
    return;

  while (   (getfid(desnod, mbp))
         && (valcal(desnod))
         && (ge6chr(beaide, mbp))
         && (getfid(nbr_call, mbp))
         && (valcal(nbr_call))
         && (mbp->mbgc < mbp->mbpc))
  {
    rx_qual = getchr(mbp) & 0xFF;

    call2str(notify_call1, rxpp->l2link->call);
    call2str(notify_call2, desnod);
    call2str(notify_call3, nbr_call);
    notify(9, "%-9.9s>%-6.6s:%-9.9s Q%u v %-9.9s",
           notify_call1, beaide, notify_call2, rx_qual, notify_call2);

    if (   cmpid(myid, nbr_call) == TRUE  /* er wuerde an mich senden,  */
        || rx_qual == LEARNQUAL           /* oder er kennt keinen Weg,  */
        || beaide[0] == '#')              /* oder Ziel (jetzt) "hidden" */
      rx_qual = 0;                        /* also den Weg austragen     */

    if (cmpid(myid, desnod) == TRUE)                /* nicht uns selber */
      continue;

    switch (rxpp->typ)
      {
        case NETROM:
        case THENET:
          if (rx_qual < worqua)
            rx_qual = 0;                                 /* ausgefallen */
          break;
        case TNN:
          if (rx_qual < 2)
            rx_qual = 0;                                 /* ausgefallen */
          break;
      }

    if ((index = add_route(rxpp, desnod, qual2rtt(rx_qual))) != NO_INDEX)
    {
      update_lt(rxpp, index, DEFAULT_LT);

      if (!cmpcal(netp->nodetab[index].alias, nulide))
        if (find_best_qual(index, &pp, DG) > 0)     /* beste Qualitaet  */
          if (pp != rxpp)
            continue;

      if (update_alias(index, beaide))      /* Alias hat sich geaendert */
        propagate_node_update(index);
    }
  }
}

/*----------------------------------------------------------------------*/
static BOOLEAN
rx_inp_broadcast(PEER *rxpp, MBHEAD *mbp)
{
  char    desnod[L2IDLEN];
  char    beaide[L2CALEN],
         *bp;
  int     lt;
  int     qual;
  INDEX   index;
  int     tag;
  int     len,
          i,
          ch;
  PEER   *pp;
  char    notify_call1[10];
  char    notify_call2[10];
  MBHEAD *options;
  ULONG   ip_adr;
  UBYTE   bits;

  if (*mbp->mbbp != 0xFF)               /* Kennung INP-Routing-Paket?   */
    return (FALSE);

  getchr(mbp);                                   /* Kennung uebergehen  */

  while (mbp->mbpc - mbp->mbgc > 10)
  {
/* einen Nodeseintrag lesen ggf. incl. Alias, IP-Nr./Subnet und anderen */
/* INP-Options                                                          */
    cpyals(beaide, DONT_CHANGE_ALIAS);          /* Default: kein Alias  */
    ip_adr = 0L;                                /* und keine IP-Adresse */
    bits = 0;
    options = NULL;                             /* sowie keine Options  */

    if (!getfid(desnod, mbp))
      break;
    if (valcal(desnod) == ERRORS)
      break;

    if (rxpp->version > 170 && rxpp->version < 176)
    {
      qual = get16(mbp);
      lt = getchr(mbp);
    }
    else
    {
      lt = getchr(mbp);
      qual = get16(mbp);
    }

    if (lt == 0)                /* LT 0 darf nie gesendet werden, hier  */
      lt = DEFAULT_LT;          /* korrigieren                          */
    else
      lt++;

    if (rxpp->version > 170 && rxpp->version < 175)
    {
      /* fehlerhafte Versionen */
      while (   ((tag = getchr(mbp)) != 0)
             && (mbp->mbpc - mbp->mbgc > 1))
      {
        len = getchr(mbp);
        if (mbp->mbpc - mbp->mbgc < len)
          return (TRUE);
        switch (tag)
        {
          case 1:                                       /* ALIAS_ID     */
            for (i = 0, bp = beaide; i < len; i++)
            {
              ch = getchr(mbp);
              if ((ch < ' ') || (ch > 127))
              {
                call2str(notify_call1, rxpp->l2link->call);
                notify(3, "invalid alias from %s (flushed)",
                       notify_call1);
                return (TRUE);
              }
              *bp++ = ch;
            }
            for (; i < L2CALEN; i++)
              *bp++ = ' ';
            break;
          default:
            while (len-- > 0)
              getchr(mbp);
        }
      }
    }
    else
    {                                 /* (halbwegs) korrektes Protokoll */
/* Endekriterium fuer den Nodeseintrag ist das EOP-Byte (0x00) am Ende  */
/* des RIP-Blocks. Danach koennen weitere Nodeseintraege folgen.        */
      while (mbp->mbpc > mbp->mbgc)
      {
/* Einzelnen Options-Eintrag lesen und auswerten, falls Typ bekannt     */
        if ((len = getchr(mbp)) == 0)   /* EOP-Byte                     */
          break;
        len--;                          /* Laengenbyte selbst abziehen  */

        if (mbp->mbpc - mbp->mbgc < len)                /* INP-Fehler!  */
        {
/* Der Fehler wird ggf. gemeldet, die fehlerhaften Options werden       */
/* komplett verworfen, damit wir keinen Muell weitermelden.             */
          call2str(notify_call1, rxpp->l2link->call);
          notify(1, "INP: frame error received from %s, "
                    "len = %u, left = %u", notify_call1, len,
                    (int)(mbp->mbpc - mbp->mbgc));
          if (options != NULL)
          {
            dealmb(options);
            options = NULL;
          }
          break;
        }

        len--;                                  /* Laenge tag abziehen  */
        switch (tag = getchr(mbp))
        {
          case INP_ALIAS:
            for (i = 0, bp = beaide; i < len; i++)
            {
              ch = getchr(mbp);
              if ((ch < ' ') || (ch > 127) || (len > L2CALEN))
              {
                call2str(notify_call1, rxpp->l2link->call);
                notify(3, "invalid alias from %s (flushed)",
                          notify_call1);
                if (options != NULL)
                  dealmb(options);
                return (TRUE);
              }
              *bp++ = ch;
            }
            for (; i < L2CALEN; i++)    /* auffuellen mit ' '           */
              *bp++ = ' ';
            break;
          case INP_IPA:
            if (len == 5)
            {
              ip_adr = get32(mbp);
              bits = getchr(mbp);
            }
            else
            {
              call2str(notify_call1, rxpp->l2link->call);
              notify(3, "invalid ipa from %s (flushed)",
                        notify_call1);
              if (options != NULL)
                dealmb(options);
              return (TRUE);
            }
            break;
          default:
/* unbekannte Option - in Buffer speichern                              */
            if (options == NULL)
              options = (MBHEAD *)allocb(ALLOC_INPOPT);
            putchr(len + 2, options);
            putchr(tag, options);
            while (--len >= 0)
              putchr(getchr(mbp), options);
        }
      }
    }

    if (cmpid(myid, desnod) || iscall(desnod, NULL, NULL, VC))
    {
      call2str(notify_call1, myid);
      call2str(notify_call2, rxpp->l2link->call);
      notify(3, "destination %s received from %s (ignored)",
             notify_call1, notify_call2);
      if (options != NULL)
      {
        dealmb(options);
        options = NULL;
      }
      continue;
    }

    call2str(notify_call1, rxpp->l2link->call);
    call2str(notify_call2, desnod);
    notify(9, "%-9.9s>%-6.6s:%-9.9s Q%u LT%u",
           notify_call1, beaide, notify_call2, qual, lt);

    if (lt > max_lt)                    /* Nach Laufzeit runterzwingen  */
      qual = 0;

    if (cmpid(rxpp->l2link->call, desnod))      /* der Nachbar selbst   */
      qual = lt = 1;

    if ((index = add_route(rxpp, desnod, qual)) != NO_INDEX)
    {
      update_lt(rxpp, index, lt);

      if (!cmpcal(netp->nodetab[index].alias, nulide))
        if (find_best_qual(index, &pp, DG) > 0)     /* beste Qualitaet  */
          if (pp != rxpp)
          {
            if (options != NULL)
            {
              dealmb(options);
              options = NULL;
            }
            continue;
          }
/* Der primaere Weg hat sich geaendert, wir uebernehmen Node-Info       */
/* sofern vorhanden (Alias, IP-Nr., Options). Wird keine Zusatzinfo     */
/* gemeldet, bleibt die bisher bekannte Info erhalten.                  */
      if (update_options(index, beaide, ip_adr, bits, options))
      {
        propagate_node_update(index);
        options = NULL;
      }
    }
  } /* bis Frameende */
  return (TRUE);
}

/************************************************************************/
/*                                                                      */
/* Uebernehmen neuer Zusatzinfos zu einem Node (Alias, IP-Nr./Subnet,   */
/* weitere unbekannte Options). Wird nichts gemeldet, bleiben bekannte  */
/* Daten gespeichert. Wird etwas neu gemeldet, muessen ALLE Daten neu   */
/* gemeldet werden. Alles was nicht mehr gemeldet wird, wird geloescht. */
/*                                                                      */
/************************************************************************/
static BOOLEAN
update_options(INDEX index, const char *alias,
               ULONG ip_adr, UBYTE bits, MBHEAD *options)
{
  NODE    *np;
  BOOLEAN  res = FALSE;
  int      len;

  if (   !cmpcal(alias, nulide)         /* nur wenn ueberhaupt INP-     */
      || ip_adr != 0L                   /* Options uebertragen wurden   */
      || options != NULL)               /* kann sich etwas aendern      */
  {
/* Es wurden Options uebertragen - also muessen alle Options auf den    */
/* neuen Wert gesetzt werden, oder geloescht, falls nicht mehr gemeldet */
    np = netp->nodetab + index;
    res = !cmpcal(np->alias, alias);
    cpyals(np->alias, alias);

    if (   ip_adr != np->ipa
        || bits != np->bits)
      res = TRUE;
    np->ipa = ip_adr;
    np->bits = bits;

    if (options == NULL)                /* keine unbekannten Options?   */
    {
      if (np->options != NULL)          /* war aber was bekannt?        */
      {
        dealmb(np->options);
        np->options = NULL;
        res = TRUE;
      }
      return (res);
    }
    if (np->options == NULL)            /* bisher nix bekannt           */
    {
      np->options = options;
      return (TRUE);
    }
    if ((len = options->mbpc) == np->options->mbpc)
    {
/* alte und neue Options sind gleich lang - also vergleichen, ob sich   */
/* etwas geaendert hat (wir gehen mal davon aus, dass die Reihenfolge   */
/* unveraendert bleibt)                                                 */
      rwndmb(options);
      rwndmb(np->options);
      while (--len >= 0)
      {
        if (getchr(options) != getchr(np->options))
          break;
      }
      if (len < 0)
      {
        dealmb(options);                  /* keine neuen Options          */
        return (res);
      }
    }
    dealmb(np->options);                  /* alte Options vergessen       */
    np->options = options;                /* neue merken                  */
    return (TRUE);                        /* Aenderung                    */
  }
  return (res);
}

static void
dump_options(NODE *np, MBHEAD *mbp)
{
  MBHEAD *op;
  int     len,
          i;
  UBYTE   tag;
  char    buf[256];

  if (np->options == NULL)
    return;
  op = np->options;
  rwndmb(op);
  putstr("\rINP-Options:", mbp);
  while (op->mbpc > op->mbgc)
  {
    len = getchr(op);
    tag = getchr(op);
    for (i = 0; i < len - 2; i++)
      buf[i] = getchr(op);
    buf[i] = NUL;
    putprintf(mbp, "\rlen = %d, tag = 0x%02x\r", len, tag);
    for (i = 0; i < len - 2; i++)
      putprintf(mbp, "%02x%c", buf[i], ((i % 16) == 0) ? CR : ' ');
  }
  putchr(CR, mbp);
}

/*..................................................................... */
/*..  Empfangsliste abgearbeitet, nun zu sendende Frames verarbeiten .. */
/*..................................................................... */
void
l3tx(void)                      /* Level 3 Service                      */
{
  UWORD   rxgetc;               /* Getcount des Frames                  */
  MBHEAD *mbp;                  /* Pointer auf aktuellen Framekopf      */
  NODE   *dstnod;
  PEER   *bestpp;
  MHEARD *mhp;

  /* solange L3-Sende-Liste nicht leer    */
  while (   (mbp = (MBHEAD *)l3txl.head)
         != (MBHEAD *)&l3txl.head)
  {
    ulink((LEHEAD *)mbp);                   /* Frame aushaengen         */
    dstnod = (NODE *)mbp->l2link;           /* Pointer auf Nachbarn     */

    if (   nmbfre > 14                      /* Platz im Speicher?       */
        && (valcal(dstnod->id) == YES)
        && find_best_qual((int)(dstnod - netp->nodetab),
                          &bestpp, DG) > 0)
    {
      rwndmb(mbp);                      /* Pointer auf Ausgangsstellung */
      getchr(mbp);                      /* alles initialisieren         */
      --mbp->mbbp;
      rxgetc = mbp->mbpc;               /* Framelaenge merken           */
      mbp->mbpc = 1;                    /* auf Anfang                   */
      putfid(myid, mbp);                /* Absender ins Frame           */
      putfid(dstnod->id, mbp);          /* Ziel ins Frame               */
      *(mbp->mbbp - 1) |= 1;            /* Ende der Adresse setzen      */
      putchr(timliv, mbp);              /* Lebensdauer setzen           */
      mbp->mbpc = rxgetc;               /* Putcount zurueck             */
      rwndmb(mbp);                      /* Pointer wieder aufziehen     */
      toneig(bestpp, mbp);              /* Frame an besten Nachbarn     */
      /* MH-Liste                     */
      if ((mhp = mh_lookup(&l3heard, dstnod->id)) != NULL)
        mhp->tx_bytes += (mbp->mbpc);
    }
    else                                /* kein Ziel def. o. kein Platz */
      dealmb(mbp);                      /* Frame wegwerfen              */
  }
}

/*..................................................................... */
/*....  sonstige Funktionen abarbeiten  ............................... */
/*..................................................................... */
void
l3rest(void)
{
}

/*----------------------------------------------------------------------*/
/* Nachbarn disconnecten                                                */
/* Wir brauchen nicht den disconnect weiterzumelden, das macht der L2,  */
/* wenn alle Infos gesendet sind.                                       */
/*----------------------------------------------------------------------*/
void
discnbp(PEER *nbpx)
{
  LNKBLK         *save_lp;

  save_lp = lnkpoi;
  if ((lnkpoi = nbpx->nbrl2l) != NULL)
    dsclnk();                           /* disconnect link, dealml ...  */
  lnkpoi = save_lp;
}

static void
sdl3ui(PEER *pp, MBHEAD *mbp)            /* UI-Broadcast senden         */
{
  if (pp->l2link->digil[0] == 0)       /* direkter Nachbar              */
    sdui("",                           /* Level 2 senden                */
         "NODES \140",                 /* an das Ziel "NODES"           */
         myid,
         pp->l2link->port,
         mbp);
  else
    sdui(pp->l2link->digil,            /* Level 2 senden                */
         pp->l2link->call,
         myid,
         pp->l2link->port,
         mbp);
  dealmb(mbp);                         /* Buffer wieder freigeben       */
}

/*----------------------------------------------------------------------*/
void
brosrv(void)
{
  static int  tim60 = 1;
  INDEX       index;
  NODE       *np;
  ROUTE      *rp;
  PEER       *pp;
  int         i;
  int         max_peers = netp->max_peers;
  int         max_nodes = netp->max_nodes;
  static int  tim10 = 1;
  int         broint;

  flexsrv();                        /* Time-Server der anderen Module   */
  localsrv();

  if (++tim60 > 60)                 /* eine Minute vorbei               */
    tim60 = 0;

  if (++tim10 > 10)
  {                                 /* 10 Sekunden vorbei               */
    drop_unreachable_nodes();
    tim10 = 0;
  }

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
  {
    if (!pp->used)
      continue;

    if (tim60 == 0)                 /* am Anfang jeder Minute           */
      for (index = 0, np = netp->nodetab, rp = pp->routes;
           index < max_nodes;
           index++, np++, rp++)
        if (np->id[0])
        {
          if (rp->lt > max_lt)
            update_route(pp, index, 0);
            if (rp->timeout)
            {
              if (--rp->timeout == 0)
                update_route(pp, index, 0);
            }
            else
              if (!pp->secured)
                rp->timeout = ROUTE_TIMEOUT;
        }
    if (pp->typ > NETROM)
      continue;

    if (nmbfre < 300)               /* nicht mehr genug Speicher        */
      continue;

    if (pp->nbrl2l == NULL)
    {                             /* noch kein Link                     */
      /* den grossen UI-Broadcast sparen wir uns, uns hoert ja          */
      /* eh keiner.                                                     */
      continue;
    }

    /* wenn der Link sich noch im Aufbau befindet oder ziemlich         */
    /* verstopft ist, wird die Nodes-Information zurueckgehalten.       */
    if (   pp->nbrl2l->state < L2SIXFER
        || pp->nbrl2l->tosend > 20)             /* Link ist voll        */
      continue;

    /* Bei INP senden wir erst los, wenn beide Messungen da sind.       */
    if (pp->typ == INP)
      if (!pp->my_quality || !pp->his_quality)
        continue;

    if (tim10 == 0 && pp->typ != THENET)
      inform_peer(pp, CHANGES);     /* nur die Aenderungen durchsagen   */

    if (pp->typ != INP)
    {
      broint = (pp->typ == TNN) ? broint_i : broint_ui;

      if (++pp->brotim > broint)
      {                             /* Broadcast anfordern              */
        pp->brotim = 0;
        inform_peer(pp, ALL);       /* und weg damit                    */
      }
    }
    else
      pp->brotim = 0;
  }
}

/************************************************************************/
/*                                                                      */
/* "send broadcast"                                                     */
/*                                                                      */
/* Ein Broadcast-Frame auf die Reise schicken. Es wird je nach Nachbar- */
/* typ als UI oder als I-Frame gesendet. "nodemb" wird auf NULL ge-     */
/* setzt, um einen fehlenden Node-Buffer zu signalisieren. Der naechste */
/* Aufruf von addbro() erzeugt dann ein neues Broadcast-Frame.          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void
brosnd(MBHEAD **mbpp, PEER *pp)
{
  if (*mbpp == NULL)
  {
    if (pp->typ == THENET || pp->typ == NETROM)
    {
      (*mbpp = (MBHEAD *)allocb(ALLOC_MBHEAD))->l3_typ = L2CUI;
      putchr(0xFF, *mbpp);
      pu6chr(alias, *mbpp);
      notify(1, "brosnd");
    }
    else
      return;
  }

  rwndmb(*mbpp);                /* vor dem Senden Buffer zurueckspulen  */

  if ((*mbpp)->l3_typ == L2CI)  /* Als I-Frame ueber den Link senden    */
    toneig(pp, *mbpp);
  else
  {
    (*mbpp)->l2fflg = L2CNETROM;/* Als UI-Bake rausschicken an "NODES"  */
    sdl3ui(pp, *mbpp);          /* PID = Level 3                        */
  }
  *mbpp = NULL;                 /* und Buffer loeschen                  */
}

/************************************************************************/
/*                                                                      */
/* "add broadcast"                                                      */
/*                                                                      */
/* Einen Weg zu dem Broadcast-Frame fuer einen Nachbarn hinzufuegen.    */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
static void
add_netrom_info(MBHEAD **mbpp, NODE *node, PEER *topp,
                PEER *viapp, unsigned qualit)
{
  int qual = rtt2qual(qualit);

  /* schlechte Wege werden unterdrueckt, abmelden kennt NETROM nicht    */
  if (qual <= worqua)
    return;

  if (*mbpp)
    if (((*mbpp)->mbpc + 21) > 256)      /* bis Frame voll              */
      brosnd(mbpp, topp);

  if (*mbpp == NULL)
  {                                      /* neues Frame holen           */
    (*mbpp = (MBHEAD *)allocb(ALLOC_MBHEAD))->l3_typ = L2CUI;
    putchr(0xFF, *mbpp);
    pu6chr(alias, *mbpp);
  }

  putfid(node->id, *mbpp);               /* Call des Zieles             */
  pu6chr(node->alias, *mbpp);            /* Ident des Zieles            */
  if (qualit && viapp)
    putfid(viapp->l2link->call, *mbpp);  /* Nachbar des Zieles          */
  else
    putfid(myid, *mbpp);                 /* Nachbar geloescht           */
  putchr(rtt2qual(qualit), *mbpp);
}

/************************************************************************/
/*                                                                      */
/* Einen Weg zu dem Infocast-Frame fuer einen Nachbarn hinzufuegen.     */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
static void
add_thenet_info(MBHEAD **mbpp, NODE *node, PEER *topp,
                PEER *viapp, unsigned qualit)
{
  if (*mbpp)
    if (((*mbpp)->mbpc + 21) > 256)      /* bis Frame voll              */
      brosnd(mbpp, topp);

  if (*mbpp == NULL)
  {                                      /* neues Frame holen           */
    (*mbpp = (MBHEAD *)allocb(ALLOC_MBHEAD))->l3_typ = L2CI;
    putfid(myid, *mbpp);                 /* von eigenes Call            */
    putfid("L3RTT \140", *mbpp);         /* an Pseudo-Destination       */
    *((*mbpp)->mbbp - 1) |= 1;           /* EOA setzen                  */
    putchr(0x02, *mbpp);                 /* Lifetime = 2                */
    putchr(0x00, *mbpp);                 /* Circuit-Index               */
    putchr(0x00, *mbpp);                 /* Circuit-ID                  */
    putchr(0x00, *mbpp);                 /* TX-Sequence-Number          */
    putchr(0x00, *mbpp);                 /* RX-Sequence-Number          */
    putchr(0x05, *mbpp);                 /* OpCode & Flags              */
    putstr("BROAD", *mbpp);              /* Framekennung                */
  }

  putfid(node->id, *mbpp);               /* Call des Zieles             */
  pu6chr(node->alias, *mbpp);            /* Ident des Zieles            */
  if (qualit && viapp)
    putfid(viapp->l2link->call, *mbpp);  /* Nachbar des Zieles          */
  else
    putfid(myid, *mbpp);                 /* Nachbar geloescht           */
  putchr(rtt2qual(qualit), *mbpp);
}

/************************************************************************/
/*                                                                      */
/* "add internode protocol route information"                           */
/*                                                                      */
/* Einen Weg zu dem Routing-Info-Frame fuer einen Nachbarn hinzufuegen. */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void
add_inp_info(MBHEAD **mbpp, NODE *node, PEER *topp, unsigned qualit,
             unsigned last_qualit, int lt)
{
  char  buf[256],
       *bp,
       *bp2;
  int   len;

  bp = buf;

  if (qualit == 0)
    qualit = HORIZONT;

  if (topp->version > 170 && topp->version < 176)
  {
    *bp++ = qualit >> 8;
    *bp++ = qualit & 0xFF;
    *bp++ = lt;
  }
  else
  {
    *bp++ = lt;
    *bp++ = qualit >> 8;
    *bp++ = qualit & 0xFF;
  }

  if (   (qualit && last_qualit == 0)
      || last_qualit == DIRTY)
  {
    if (topp->version > 170 && topp->version < 175)
    {                                                   /* fehlerhaft   */
      *bp++ = 1;                                        /* ALIAS_ID     */
      *bp++ = L2CALEN;
      cpyals(bp, node->alias);
      bp += L2CALEN;
    }
    else
    {
/* (halbwegs) richtige Implementierung                                  */
      for (len = 0; len < L2CALEN; len++)
        if (node->alias[len] == ' ')
          break;
      if (len != 0)
      {
        *bp++ = len + 2;
        *bp++ = INP_ALIAS;
        memcpy(bp, node->alias, (size_t)len);
        bp += len;
      }
      if (node->ipa != 0L)
      {
        *bp++ = 7;
        *bp++ = INP_IPA;
        *bp++ = node->ipa >> 24;
        *bp++ = (node->ipa >> 16) & 0xff;
        *bp++ = (node->ipa >> 8) & 0xff;
        *bp++ = node->ipa & 0xff;
        *bp++ = node->bits;
      }
      if (node->options != NULL)
      {
        rwndmb(node->options);
        while (node->options->mbpc > node->options->mbgc)
          *bp++ = getchr(node->options);
      }
    }
  }
  *bp++ = 0;                             /* Ende der Meldung (EOP)      */
  len = (int)(bp - buf) + L2IDLEN;       /* Laenge berechnen            */

  if (*mbpp)
    if ((*mbpp)->mbpc + len > 256)       /* passt nicht mehr ?          */
      brosnd(mbpp, topp);

  if (*mbpp == NULL)
  {                                      /* neues Frame holen           */
    (*mbpp = (MBHEAD *)allocb(ALLOC_MBHEAD))->l3_typ = L2CI;
    putchr(0xFF, *mbpp);                 /* Kennung                     */
  }

  putfid(node->id, *mbpp);
  for (bp2 = buf; bp2 < bp; bp2++)
    putchr(*bp2, *mbpp);
}

static void
addbro(MBHEAD **mbpp, NODE *node, PEER *topp, PEER *viapp,
       unsigned qualit, unsigned lastqual, int lt)
{
  switch (topp->typ)
    {
      case THENET:
      case NETROM:
        add_netrom_info(mbpp, node, topp, viapp, qualit);
        break;
      case TNN:
        add_thenet_info(mbpp, node, topp, viapp, qualit);
        break;
      case INP:
        add_inp_info(mbpp, node, topp, qualit, lastqual, lt);
        break;
    }
}

/*----------------------------------------------------------------------*/
/* Broadcast fuer einen Nachbarn                                        */
void
inform_peer(PEER *pp, int kind_of)
{
  INDEX     index;
  int       max_nodes = netp->max_nodes;
  NODE     *np = netp->nodetab;
  ROUTE    *rp = pp->routes;
  PEER     *bestpp;
  unsigned  quality;
  unsigned  reported_quality;
  unsigned  diff;
  int       timeout;
  MBHEAD   *mbp = NULL;                       /* noch kein Buffer offen */
  BOOLEAN   old_netrom = (pp->typ == NETROM || pp->typ == THENET);
  UWORD     maxtime;

  for (index = 0; index < max_nodes; index++, np++, rp++)
  {
    if (np->id[0] == 0)                         /* kein Eintrag         */
      continue;

    if (cmpid(np->id, pp->l2link->call))        /* der Nachbar          */
      continue;

/************************************************************************/
/**** HACK: wird nur benoetigt, solange wir nur die Flexnet Nachbarn ****/
/**** und nicht deren Ziele melden wollen                            ****/
    if (   ((quality = find_best_qual(index, &bestpp, VC | VC_FAR | DG))
            != 0)
        && (bestpp->options == VC_FAR)
        && (cmpid(bestpp->l2link->call, np->id)))
    {
    }
    else
/************************************************************************/

/** An Nachbarn, die das gleiche Call haben, wie der beste Weg (also    */
/* auch der beste Weg selbst) melden wir 0.                             */
      quality = find_best_qual(index, &bestpp, HOST_MASK);
    if (cmpid(bestpp->l2link->call, pp->l2link->call))
      quality = 0;

/*** Alternativ:                                                      ***/
/*** quality = find_best_notvia(index, pp, &bestpp, HOST_MASK);       ***/

    reported_quality = rp->reported_quality;
    if (np->alias[0] == '#')            /* versteckter Node             */
    {
      if (!reported_quality)            /* hatten wir gemeldet?         */
        continue;                       /* nein, also auch jetzt nicht  */
      quality = 0;                      /* ja, also abmelden            */
    }
    if (kind_of == ALL)
    {
      /* gesicherten Nachbarn brauchen wir nur Ziele zu uebertragen,    */
      /* die wir schon mal gemeldet hatten                              */
      if (!old_netrom && !reported_quality)
        continue;
      /* wir senden alle Routen ohne Timeout und diejenigen, die noch   */
      /* mindestens 30% des Timeouts uebrig haben                       */
      timeout = rp->timeout;
      if (   (timeout == 0)
          || (timeout >= (ROUTE_TIMEOUT / 3)))
      {
        addbro(&mbp, netp->nodetab + index, pp, bestpp, quality,
               reported_quality, bestpp->routes[index].lt);
        rp->reported_quality = quality;/* merken was wir gemeldet haben */
      }
    }
    else
    {
/* Die maximal zulaessige Laufzeit fuer Meldungen ist entweder 600s     */
/* oder ein vom Nachbarn vorgegebener kleinerer Wert. Hat der Nachbar   */
/* eine max. Laufzeit gemeldet, so wird diese beruecksichtigt.          */
      maxtime = pp->maxtime;
      if (!maxtime || maxtime > HORIZONT)
        maxtime = HORIZONT;
/* Zusaetzliches Filter: Bei der ersten Meldung eines Zieles darf die   */
/* Laufzeit hoechstens die Haelfte des Maximalwertes betragen, damit    */
/* wir nicht schon bei der ersten Verschlechterung das Ziel wieder      */
/* abmelden muessen.                                                    */
      if (!reported_quality)                    /* noch nix gemeldet?   */
        if (quality > maxtime / 2)              /* zu schlecht?         */
          continue;

      if (reported_quality != DIRTY)
      {
        if (quality == reported_quality)
          continue;                                  /* keine Aenderung */

/* Wenn ein Ziel ausfaellt oder neu gemeldet wird, dann brauchen wir    */
/* nicht zu kontrollieren, ob die Meldung unterdrueckt werden kann.     */
/* Diese Meldungen sind zwingend.                                       */
        if (quality && reported_quality)
        {
/* Verbesserungen werden nur gemeldet, wenn Sie mindestens um 50% von   */
/* der letzten Meldung abweichen. Ebenfalls nicht gemeldet werden sehr  */
/* geringe Verbesserungen (<= 100ms) bei sehr schnellen Links           */
/* (Aenderung z.B. von 50ms auf 90ms wird nicht gemeldet, obwohl es 60% */
/* sind). Die Verbesserung muss mindestens ueber der halben Laufzeit    */
/* zum empfangenden Segment liegen. Die Verbesserung wird nur gemeldet  */
/* wenn der Link nicht verstopft ist!                                   */
          if (quality < reported_quality)
          {
            diff = reported_quality - quality;
            if (diff < reported_quality / 2)  /* Filter 1:              */
              continue;                       /*       50% Verbesserung */
            if (diff < 10)                    /* Filter 2:              */
              continue;                       /*       mindestens 100ms */
            if (diff < pp->quality / 2)       /* Filter 3:              */
              continue;                       /*    adaptiv nach Zielr. */
            if (pp->nbrl2l->tosend > 7)       /* Filter 4:              */
              continue;                       /*        Link verstopft? */
          }
          else
          {
/* Verschlechterungen muessen immer sofort uebertragen werden! Wir      */
/* senken die Qualitaet bei der Meldung vorbeugend um 12.5% ab und      */
/* zusaetzlich um die 1/2 Laufzeit zu diesem Nachbarn. Bei weiterem     */
/* Abfall sollen weitere hektische Meldungen dadurch vermieden werden.  */
            quality += quality / 8 + pp->quality / 2;
/* Ist die neue Laufzeit groesser als der Nachbar wuenscht, wird das    */
/* Ziel abgemeldet.                                                     */
            if (quality > maxtime)
              quality = 0;
          }
        }
      }

      addbro(&mbp, netp->nodetab + index, pp, bestpp, quality,
             reported_quality, bestpp->routes[index].lt);

      rp->reported_quality = quality;  /* merken was wir gemeldet haben */
    }
  }
  brosnd(&mbp, pp);
}

/************************************************************************/
/* L3-RTT-Service                                                       */
/* erzeugt einen Frame mit L3-Header, bei dem Ziel und Absender         */
/* der eigene Knoten ist. Dieses Frame wird dann an den Nachbarn        */
/* gesendet. Die vorhergehende Messung wird dem Nachbarn mitgeteilt.    */
/* im Frame wird die vergangene Zeit in 10ms-Schritten seit Programm-   */
/* start mitgegeben.                                                    */
/* Automatische Qualitaetsberechnung aus dem L3SRTT, DB2OS 06/04/93     */
/*----------------------------------------------------------------------*/
void
l3rtt_service(void)
{
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;
  MBHEAD *mbp;
  INDEX   index;
  char    notify_call[10];

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
  {
    if (!pp->used)
      continue;
    if (pp->typ > NETROM)
      continue;
    if (pp->nbrl2l == NULL)
    {
/* Der Nachbar, auf den pp zeigt, bekommt eine L3-Mini-Broadcast-Bake   */
/* von uns. Diese ist notwendig, da einige aeltere Versionen von TheNet */
/* und andere NET/ROM-Implementierungen den Nachbarn nur annehmen, wenn */
/* vorher bereits eine L3-Bake empfangen wurde. Anschliessend wird eine */
/* Verbindung zum Nachbarn hergestellt.                                 */
      mbp = (MBHEAD *)allocb(ALLOC_MBHEAD);     /* Buffer besorgen      */
      putchr(0xFF, mbp);
      pu6chr(alias, mbp);         /* Ident in Buffer                    */
      mbp->l2fflg = L2CNETROM;    /* PID = Level 3                      */
      rwndmb(mbp);                /* Pointer aufziehen                  */
      sdl3ui(pp, mbp);            /* UI-Broadcast senden                */
      if (connbr(pp))
        pp->nbrl2l->tries = portpar[pp->nbrl2l->liport].retry - 1;
      continue;
    }
    if (pp->nbrl2l->state < L2SIXFER)
      continue;
    if (pp->rttstart)
    {
      if (tic10 - pp->rttstart >= 18000L)  /* maximal 180 Sekunden      */
      {
        call2str(notify_call, pp->l2link->call);
        notify(1, "%s: l3rtt too high: %ld", notify_call,
               tic10 - pp->rttstart);
        discnbp(pp);
      }
      continue;
    }
    if (pp->rtt_time == 0)
    {                             /* Messung ist faellig                */
      if (pp->typ == THENET)
      {                           /* der kann nicht messen              */
        update_peer_quality(pp, pp->nbrl2l->SRTT * 4L, DONT_CHANGE_QUAL);
        /* Falls das Timeout auf einer Route mal abfaellt,    */
        /* melden wir hier wieder die Routen-Qualitaet hoch.  */
        if ((index = add_route(pp, pp->l2link->call, 1)) != NO_INDEX)
          update_lt(pp, index, 1);
        rtt_metric(pp, pp->nbrl2l->SRTT * 4L);
        pp->rtt_time = L3_RTT_TIME;
      }
      else
        send_l3srtt_frame(pp);    /* Neue Messung starten               */
    }
    else
      pp->rtt_time--;             /* Messintervall runterzaehlen        */
  }
}

/*----------------------------------------------------------------------*/
void
send_l3srtt_frame(PEER *pp)
{
  MBHEAD *mbp;
  int     mtu;

  if (pp->typ > NETROM)                   /* nur bei NET/ROM erlaubt    */
    return;

  if (pp->nbrl2l)
  {                                       /* nur aktiver mit L2-Link..  */
    mbp = (MBHEAD *)allocb(ALLOC_MBHEAD); /* Buffer besorgen            */
    putfid(myid, mbp);                    /* von eigenes Call           */
    putfid("L3RTT \140", mbp);            /* an Pseudo-Destination      */
    *(mbp->mbbp - 1) |= 1;                /* EOA setzen                 */
    putchr(0x02, mbp);                    /* Lifetime = 2               */
    putchr(0x00, mbp);                    /* Circuit-Index              */
    putchr(0x00, mbp);                    /* Circuit-ID                 */
    putchr(0x00, mbp);                    /* TX-Sequence-Number         */
    putchr(0x00, mbp);                    /* RX-Sequence-Number         */
    putchr(0x05, mbp);                    /* OpCode & Flags             */
    putstr("L3RTT:", mbp);                /* Framekennung               */
    pp->rttstart = tic10;                 /* Startzeit merken           */
    putlong(tic10, TRUE, mbp);            /* 10ms Ticks seit Softstart  */
    putlong((ULONG)pp->quality, TRUE, mbp);  /* aktueller L3-SRTT Wert  */
    putlong((ULONG)pp->my_quality, TRUE, mbp);  /* letzter L3-RTT Wert  */
    putlong((ULONG)pp, TRUE, mbp);        /* Pointer als ID             */
    putchr(' ', mbp);
    pu6chr(alias, mbp);
    putstr(" LEVEL3_V2.1 ", mbp);         /* L3-Version                 */
    putstr(infostr, mbp);                 /* TNN-Version                */
    if (mymaxtime != 0)
      putprintf(mbp, " $M%u", mymaxtime);
    putstr(" $N\r", mbp);
    mtu = portpar[pp->l2link->port].mtu;
    while (mbp->mbpc < mtu)               /* Buffer voll machen         */
      putchr(' ', mbp);
    rwndmb(mbp);                          /* Frame aufziehen            */
    toneig(pp, mbp);                      /* Frame an den Nachbarn      */
  }
}

/*----------------------------------------------------------------------*/
/* Feststellen, ob zu einem Node noch ein Weg existiert. Wenn es keinen */
/* aktiven Weg mehr gibt, wird dies dem L4 gemeldet. Dieser traegt dann */
/* alle aktiven L4-Verbindungen aus.                                    */
/* Da wir die Wege nach der Qualitaet sortieren, reicht es zu pruefen,  */
/* ob der beste Weg ausgefallen ist. In diesem Fall erfolgt die Meldung */
/* an den L4.                                                           */
/* Diese Routine wird nach jeder Veraenderung der Qualitaet eines Weges */
/* aufgerufen.                                                          */
/*----------------------------------------------------------------------*/
static BOOLEAN
check_destot(INDEX index)       /* ueberprueft, ob es noch verwendbare  */
{                               /* Wege zu einem Ziel gibt              */
  if (find_best_qual(index, NULL, DG) == 0)
  {
    destot(index);
    return (TRUE);
  }
  return (FALSE);
}

/*----------------------------------------------------------------------*/
static void
check_all_destot(void)
{
  INDEX index;
  int   max_nodes = netp->max_nodes;

  for (index = 0; index < max_nodes; index++)
    check_destot(index);
}

/*----------------------------------------------------------------------*/
/* Ein Frame an einen Nachbarn senden.                                  */
void
toneig(PEER *pp, MBHEAD *mbp)
{
  if ((lnkpoi = pp->nbrl2l) != NULL)     /* L2-Link vorhanden?          */
    i3tolnk(L2CNETROM, pp->nbrl2l, mbp);
  else
    dealmb(mbp);                         /* sonst wegwerfen             */
}

/*----------------------------------------------------------------------*/
void
destot(INDEX index)             /* Ziel ist nicht mehr erreichbar       */
{
  MBHEAD *mbp,
         *nextmbp;
  NODE   *totnod = netp->nodetab + index;

  l3tol4(totnod);               /* an L4 melden: Knoten wird entfernt   */

  for (mbp = (MBHEAD *)l3txl.head;              /* L4 Sendeliste        */
       mbp != (MBHEAD *)&l3txl.head;            /* durchgehen           */
       mbp = nextmbp)
  {
    nextmbp = (MBHEAD *)mbp->nextmh;
    if ((NODE *)mbp->l2link == totnod)
    {                                           /* dieser Node?         */
      ulink((LEHEAD *)mbp);
      dealmb(mbp);
    }
  }
}

/* den besten Weg zu einem Segment feststellen (wenn es mehrere gibt)   */
void
update_primary_peer(char *id)
{
  PEER  *peertab = netp->peertab;       /* Segment-Tabelle              */
  PEER  *pp;
  PEER  *bestpp = NULL;
  ULONG  quality;
  ULONG  bestqual = 0;

  /* den primaeren Weg suchen und merken */
  for (pp = peertab; pp < &peertab[netp->max_peers]; pp++)
    if (pp->used)
    {
      if (cmpid(pp->l2link->call, id))
      {
        if (bestpp)
        {
          quality = pp->quality;
          if ((quality && quality < bestqual) || !bestqual)
          {
            bestpp = pp;
            bestqual = quality;
          }
        }
        else
        {
          bestpp = pp;
          bestqual = pp->quality;
        }
      }
    }

  /* und dann in allen Wegen (zu dem Nachbarn) eintragen */
  for (pp = peertab; pp < &peertab[netp->max_peers]; pp++)
    if (pp->used)
      if (cmpid(pp->l2link->call, id))
        pp->primary = bestpp;
}

/* einen Nachbarn austragen                                             */
void
unregister_neigb(const char *id, const char *via, int port)
{
  char  digi_list[2 * L2IDLEN + 1];
  PEER *pp;                        /* Buffer fuer Eintrag               */

  cpyidl2(digi_list, via);         /* nur maximal 2 Digipeater!         */
  pp = getnei(digi_list, id, port);
  if (!pp)
    return;

  update_peer_quality(pp, 0L, 0L); /* als ausgefallen melden            */

  if (pp->nbrl2l)                  /* noch connected?                   */
    discnbp(pp);

  dealoc((MBHEAD *)pp->l2link);
  unregister_peer(pp);
}

/* einen neuen Nachbarn eintragen                                       */
PEER *
register_neigb(const char *id, const char *via, const char *alias,
               int port, int typ)
{
  L2LINK *p;
  char    digi_list[2 * L2IDLEN + 1];
  PEER   *pp;
  INDEX   index;

  switch (typ)
  {                              /* werden automatisch erkannt          */
    case TNN:
    case INP:
      typ = NETROM;
  }

  cpyidl2(digi_list, via);        /* nur maximal 2 Digipeater!          */
  pp = getnei(digi_list, id, port);

  if (pp != NULL)
  {                                /* wir kennen den Nachbarn           */
    index = find_node_this_ssid(id);
    if (update_alias(index, alias))     /* Alias hat sich geaendert     */
    {
      p = pp->l2link;
      cpyals(p->alias, alias);
      propagate_node_update(index);
    }
    return (pp);                   /* Eintrag liefern                   */
  }

  if ((pp = register_peer()) == NULL)
    return (NULL);

  p = pp->l2link = (L2LINK *)allocb(ALLOC_L2LINK); /* Platz f. L2-Link  */

/* Diese beiden Eintraege werden sofort von aussen neu gesetzt.         */
/* Bei NET/ROMs wird der alias selbstaendig bestimmt, die Qualitaet     */
/* ist nur fuer ungemessene Links der Vorgabe-Wert.                     */

  cpyid(p->call, id);              /* Call eintragen                    */
  cpyidl2(p->digil, digi_list);    /* maximal 2 Digis eintragen         */
  cpyals(p->alias, alias);         /* Alias eintragen                   */
  p->port = port;                  /* Port eintragen                    */
  p->ssid_high = SSID(id);         /* noch keine Grenze bekannt         */

  set_peer_typ(pp, typ);
  pp->nbrl2l = NULL;               /* kein L2 Link vorhanden            */
  pp->version = 0;                 /* unbekannte Version                */
  pp->rttstart = 0;                /* keine Messung unterwegs           */
  pp->rtt_time = 0;                /* schnell messen                    */
  pp->brotim = 0;                  /* Broadcast Timer                   */
  pp->options = (typ <= NETROM) ?  /* Datagramm oder VirtualConnect     */
                DG :
                (typ == FLEXNET) ? /* FlexNet oder Local?               */
                VC_FAR : VC;
  inithd(&(pp->rxfl));             /* Empfangsliste                     */

  if (typ == LOCAL)
  {                                /* erste Messung simulieren          */
    if ((index = add_route(pp, id, 400)) != NO_INDEX)
    {
      update_alias(index, alias);
      update_lt(pp, index, 1);
    }
    pp->quality = 1;               /* Messung simulieren                */
  }
  update_primary_peer(pp->l2link->call);

  return (pp);                     /* mit Pointer auf Eintrag zurueck   */
}

/************************************************************************/
/*                                                                      */
/* Eine neue Verbindung zum Nachbarn herstellen.                        */
/*                                                                      */
/************************************************************************/
BOOLEAN
connbr(PEER *pp)
{
  char id[L2IDLEN];
  char notify_call[10];

  cpyid(id, myid);
  if (pp->typ == LOCAL_M)
    id[L2IDLEN - 1] = (testid << 1) | 0x60;

  lnkpoi = getlnk(pp->l2link->port, id, pp->l2link->call, pp->l2link->digil);

  if (lnkpoi)
  {                                 /* gabs noch einen freien Eintrag?  */
    if (lnkpoi->state == L2SDSCED)
    {
      newlnk();                     /* Verbindung erstellen             */
      pp->nbrl2l = lnkpoi;
      return (TRUE);
    }
    call2str(notify_call, pp->l2link->call);
    notify(1, "%s: dsclnk in connbr", notify_call);
    dsclnk();
  }
  return (FALSE);
}

/*----------------------------------------------------------------------*/
/* Nachbarn in Nachbarliste suchen                                      */
/*----------------------------------------------------------------------*/
PEER *
getnei(const char *digil, const char *call, int port)
{
  PEER *pp;
  int   i;
  int   max_peers = netp->max_peers;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used)
      if (isneig(digil, call, port, pp))
        return (pp);
  return (NULL);
}

unsigned
getquality(unsigned route_qual, PEER *pp)
{
  ULONG qual;

  if (route_qual == 0 || pp->quality == 0)
    return (0);
  if (pp->typ <= NETROM)
  {
    qual = ((ULONG)route_qual) + pp->quality;
    if (qual > HORIZONT)
      qual = HORIZONT;
    return ((unsigned)qual);
  }
  else
    return (route_qual);
}

/* Qualitaet des besten Weges (immer >= 1)                              */
unsigned
do_find_best_qual(INDEX index, PEER *notthis, PEER **retpp, int options)
{
  int       i;
  PEER     *pp = netp->peertab,
           *bestpp = NULL;
  ROUTE    *rp;
  unsigned  bestqual = 0;
  unsigned  quality;

  for (i = netp->max_peers; i--; pp++)
  {
    if (!pp->used)
      continue;
    if (pp == notthis)
      continue;
    if ((pp->options & options) == 0)
      continue;
    rp = pp->routes + index;
    quality = getquality(rp->quality, pp);
    if ((quality && quality < bestqual) || !bestqual)
    {
      bestpp = pp;                             /* Route und Peer merken */
      bestqual = quality;
    }
  }
  if (retpp)
    *retpp = bestpp;                 /* besten Nachbarn liefern         */
  return (bestqual);                 /* und Qualitaet als Rueckgabewert */
}

/* Kennen wir das Ziel als Ident?                                       */
INDEX
find_alias(char *ident)
{
  NODE *np = netp->nodetab;            /* NET/ROM-Tabelle durchsuchen   */
  INDEX i;
  int   max_nodes = netp->max_nodes;

  for (i = 0; i < max_nodes; i++, np++)
    if (np->id[0])                      /* Eintrag existiert?           */
      if (cmpals(ident, np->alias))
        return (i);
  return (NO_INDEX);                    /* nix gefunden                 */
}

/* Rufzeichen suchen                                                    */
BOOLEAN
iscall(char *id, NODE **retnp, PEER **bestpp, int options)
{
  INDEX index;

/* Call ueber genaues Ziel oder/und ueber SSId suchen                   */
  if ((index = find_node_this_ssid(id)) == NO_INDEX)
    index = find_node_ssid_range(id);
  if (index != NO_INDEX)
  {
    if (retnp)
      *retnp = netp->nodetab + index;
    return (find_best_qual(index, bestpp, options) != 0); /* beste Qual */
  }
  return (FALSE);                   /* nix gefunden                     */
}

/*----------------------------------------------------------------------*/
/* Stimmen Digipeaterliste (digis), Rufzeichen (call) und Port mit dem  */
/* Eintrag in die Nachbarnliste (nachp) ueberein?                       */
/* Rueckgabe: TRUE=ja,  FALSE=nein                                      */
/*----------------------------------------------------------------------*/
static BOOLEAN
isneig(const char *digis, const char *call, int port, PEER *pp)
{
  if (pp->l2link->port != port)
    return (FALSE);
  if (cmpid(pp->l2link->call, call) == FALSE)
    return (FALSE);
  if (cmpidl(digis, pp->l2link->digil) == FALSE)
    return (FALSE);

  return (TRUE);
}

/*----------------------------------------------------------------------*/
/* 6 Zeichen aus Message-Puffer lesen und nach Buffer schreiben         */
/* Rueckgabe: TRUE = hat funktioniert                                   */
/*----------------------------------------------------------------------*/
BOOLEAN
ge6chr(char *buffer, MBHEAD *mbp)
{
  int i,
      ch;

  for (i = 6;
       (mbp->mbpc > mbp->mbgc) && i;    /* noch Zeichen da?             */
       i--)
  {
    *buffer++ = ch = getchr(mbp);
    if (ch < ' ')
      return (FALSE);                   /* ungueltiges Zeichen          */
    if (ch > 127)
      return (FALSE);
  }
  return (i == 0);                      /* waren genug Zeichen da?      */
}

/*----------------------------------------------------------------------*/
/* 6 Zeichen aus Buffer in Message-Puffer schreiben                     */
/*----------------------------------------------------------------------*/
void
pu6chr(char *buffer, MBHEAD *mbp)
{
  WORD i;

  for (i = 0; i < 6; ++i)
    putchr(*buffer++, mbp);
}

/*----------------------------------------------------------------------*/
/* Den aktuellen Nachbarn als connected eintragen.                      */
/*----------------------------------------------------------------------*/
static void
newnbr(PEER *pp)
{
  pp->nbrl2l = lnkpoi;                      /* Link eintragen           */
  ptctab[g_uid(lnkpoi, L2_USER)].state = PEERLINK;
}

/*----------------------------------------------------------------------*/
/* Den aktuellen Nachbarn als disconnected eintragen.                   */
/*----------------------------------------------------------------------*/
static void
disnbr(PEER *pp)
{
  if (pp->nbrl2l == NULL)
    return;
  ptctab[g_uid(pp->nbrl2l, L2_USER)].state = 0;
  if (pp->nbrl2l)
  {
    pp->nbrl2l = NULL;
    dealml((LEHEAD *)&pp->rxfl);            /* nur rx loeschen, den     */
                                            /* Rest macht die Abmeldung */
  }
}

/*----------------------------------------------------------------------*/
/* Ist der neue Link ein erlaubter Nachbar ?                            */
/* Wenn ja: Pointer auf die Nachbarstruktur zurueck, sonst NULL.        */
/*----------------------------------------------------------------------*/
static PEER *
ispeer(void)
{
  L2LINK *p;
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;
  char   *srcid;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used)
    {
      p = pp->l2link;             /* Pointer auf den eingetragenen Link */
      if (lnkpoi)
      {
        if (pp->nbrl2l == lnkpoi)
          return (pp);
        if (   !cmpid(p->call, lnkpoi->dstid)
            || !cmpidl(p->digil, lnkpoi->viaidl)
            || (p->port != lnkpoi->liport))
          continue;
      }
      else
      {
        if (   !cmpid(p->call, &rxfhdr[L2IDLEN])
            || !cmpidl(p->digil, &txfhdr[L2ILEN])
            || (rxfprt != p->port))
          continue;
        return ((pp->typ <= NETROM) ? pp : NULL);
      }

      srcid = (lnkpoi == NULL) ? rxfhdr : lnkpoi->srcid;
      if (pp->typ != LOCAL)
      {
        if (cmpcal(myid, srcid))
        {
          if (pp->typ == LOCAL_M)
          {
            if (srcid[L2IDLEN - 1] == ((testid << 1) | 0x60))
              return (pp);
          }
          else
          {
            if (srcid[L2IDLEN - 1] == myid[L2IDLEN - 1])
              return (pp);
          }
        }
      }
    }
  return (NULL);
}

/************************************************************************/
/* Eine Status-Aenderung fuer NET/ROM behandeln                         */
/************************************************************************/
static void
netrom_status(PEER *pp, WORD status)
{
  if (pp->typ <= NETROM)
  {                                         /* nur NET/ROM interessiert */
    switch (status)
    {
      case L2MCONNT:
        connect_peer(pp);
        break;

      case L2MLREST:
      case L2MLRESF:
        reset_peer(pp);
        break;

      default:
        disconnect_peer(pp);
        update_peer_quality(pp, 0, DONT_CHANGE_QUAL);
        check_all_destot();
        break;
    }
    pp->rttstart = 0;
    pp->rtt_time = 0;
    switch (pp->typ)
    {
      case TNN:
      case INP:
        set_peer_typ(pp, NETROM);
    }
    pp->brotim = 0;                         /* mit Broadcast beginnen   */
  }
}

/*----------------------------------------------------------------------*/
/* eine Status-Aenderung an alle L3-Module senden                       */
/* Die Module muessen selber darauf achten, das sie die Meldung nur     */
/* annehmen, wenn der Typ des pp stimmt!                                */
/*----------------------------------------------------------------------*/
static void
mstatus(PEER *pp, WORD status)
{
  netrom_status(pp, status);                /* neuen Status melden      */
  flex_status(pp, status);                  /* an NETROM & FlexNet      */
  local_status(pp, status);                 /* und unsere Locals        */
}

/*----------------------------------------------------------------------*/
/* Neue Status-Meldung verarbeiten                                      */
/* 0=nicht verwendet, 1=connectet, 2=disconnectet, 3=busy, 4=Failure    */
/*----------------------------------------------------------------------*/
BOOLEAN
l2tol3(WORD status)
{
  PEER *pp;
  char  notify_call[10];

  switch (status)
    {
      case L2MCONNT:                        /* CONNECTED to             */
      case L2MLREST:                        /* LINK RESET to            */
        if ((pp = ispeer()) == NULL)
          return (l2toip(status));          /* der L7 ist dran          */
        newnbr(pp);                         /* Nachbar eintragen        */
        mstatus(pp, status);                /* Status melden            */
        return (TRUE);                      /* Status verarbeitet       */

      case L2MLRESF:                        /* LINK RESET from          */
        if ((pp = ispeer()) == NULL)
          return (l2toip(status));          /* der L7 ist dran          */
        mstatus(pp, status);                /* Status melden            */
        disnbr(pp);                         /* Nachbar inaktiv          */
        newnbr(pp);                         /* Nachbar eintragen        */
        mstatus(pp, status);                /* Status melden            */
        call2str(notify_call, rxfhdr + L2IDLEN);
        notify(3, "Linkreset %6s", notify_call);
        return (TRUE);                      /* Status verarbeitet       */

      case L2MDISCF:                        /* DISCONNECTED from        */
      case L2MBUSYF:                        /* BUSY from                */
      case L2MFAILW:                        /* LINK FAILURE with        */
        if ((pp = ispeer()) == NULL)
          return (l2toip(status));          /* der L7 ist dran          */
        mstatus(pp, status);                /* melden                   */
        disnbr(pp);                         /* Nachbar inaktiv          */
        return (TRUE);                      /* nicht in den L7          */

      case L2MFRMRF:                        /* FRAME REJECT from        */
      case L2MFRMRT:                        /* FRAME REJECT to          */
        if ((pp = ispeer()) == NULL)
          return (l2toip(status));          /* der L7 ist dran          */
        return (TRUE);                      /* Status verarbeitet       */

      case L2MBUSYT:                        /* BUSY to                  */
        return (TRUE);                      /* hier abfangen            */
    }

  return (FALSE);                           /* ungueltige Meldung       */
}

/************************************************************************\
*                                                                        *
* "rx frame to neigbour"                                                 *
*                                                                        *
* Ein L3-Frame wurde empfangen und wird hier an den entsprechenden       *
* Nachbarpointer zur weiteren verarbeitung angehaengt.                   *
*                                                                        *
\************************************************************************/
static void
rxneig(PEER *pp, MBHEAD *fbp)
{
  relink((LEHEAD *)fbp, (LEHEAD *)pp->rxfl.tail); /* ok->weiter         */
}

/************************************************************************\
*                                                                        *
* "to level 3 switch"                                                    *
*                                                                        *
* Aus I- oder UI-Frame (Framekopf fbp, Getzeiger/Zaehler auf 1. Byte     *
* hinter Level-2-Adressfeld) PID holen, falls vorhanden. Falls es nicht  *
* Level-2-PID ist, das Paket an die Level-3-Empfangsframeliste l3rxfl    *
* haengen. Im Framekopf wird in jedem Fall l2fflg auf PID, wenn          *
* vorhanden, oder 0 gesetzt, l2link auf den aktuellen Link (lnkpoi).     *
* Fuer Level-3-Frames wird der Nachbar bestimmt.                         *
*                                                                        *
* Return:  TRUE -  das I/UI-Frame hat ein Nicht-Level-2-PID und wurde an *
*                  die Level-3-Empfangsframeliste gehaengt               *
*          FALSE - Frame hat Standard-Level-2-PID                        *
*                                                                        *
\************************************************************************/
BOOLEAN
tol3sw(MBHEAD *fbp)
{
  PEER  *pp;
  UBYTE  pid;
  int    state;
  int    filter_ip_frame;

  pid = fbp->l2fflg;

  fbp->l2link = lnkpoi;           /* Linkverbindung von diesem Frame    */
  fbp->l2port = rxfprt;           /* Auf diesem Port kam das Frame      */

  if (lnkpoi)
  {
    state = ptctab[g_uid(lnkpoi, L2_USER)].state;
    filter_ip_frame = (state == D_IPLINK || state == U_IPLINK);
  }
  else
    filter_ip_frame = TRUE;

/* Protokolle, die nicht an einen Nachbarn gebunden sind, direkt        */
/* abfangen                                                             */
  switch (pid)
    {
#ifdef IPROUTE
      case L2CIP:
        if (filter_ip_frame)
        {
          if (fbp->l2link)        /* fuer Level 2 Links Info zaehlen    */
            ptctab[g_uid(fbp->l2link, L2_USER)].inforx
                         += (fbp->mbpc - fbp->mbgc);

          relink((LEHEAD *)fbp, (LEHEAD *)iprxfl.tail);
          return (TRUE);          /* Frame verarbeitet                  */
        }
        else
          break;

      case L2CARP:
        if (filter_ip_frame)
        {
          if (fbp->l2link)        /* fuer Level 2 Links Info zaehlen    */
            ptctab[g_uid(fbp->l2link, L2_USER)].inforx
                         += (fbp->mbpc - fbp->mbgc);

          relink((LEHEAD *)fbp, (LEHEAD *)arprxfl.tail);
          return (TRUE);          /* Frame verarbeitet                  */
        }
        else
          break;
#endif

#ifdef L2PROFILER
      case 0x12:                  /* Spielzeug fuer DB7KG (PID 12)      */
        dealmb(fbp);
        return (TRUE);
#endif
    }

  if ((pp = ispeer()) == NULL)    /* kein Frame fuer einen Nachbarn?    */
    return (FALSE);               /* zum Level 7 durchlassen            */

/* Hier landen nur Frames, die zu einem bestimmten Nachbarn gehoeren.   */
/* Nun muss noch Protokoll-ID und Protokoll verglichen werden.          */

  if (fbp->l2link)                /* fuer Level 2 Links Info zaehlen    */
    ptctab[g_uid(fbp->l2link, L2_USER)].inforx
                 += (fbp->mbpc - fbp->mbgc);

  switch (fbp->l2fflg)
    {
/* Protokoll/Nachbartyp feststellen                                     */
/* NET/ROM-Protokoll fuer TheNet, TheNetNode, TNX1J(TexNet)             */
/* KA9Q und Devirate, Wampes, Linux usw., BPQ, andere Switches          */
      case L2CTEXNET:             /* fuer TexNet/TheNetX1J              */
      case L2CNETROM:
        if (pp->typ > NETROM)
          break;                  /* nicht richtiger Nachbar-Typ?       */
        rxneig(pp, fbp);          /* Frame zur Nachbar-Bearbeitung      */
        return (TRUE);            /* ... und fertig                     */

                                  /* Flexnet Protokoll fuer             */
      case L2CFLEXNET:            /* Flexnet eben, BayCom, Digiware     */
        if (pp->typ != FLEXNET)
          break;
        if (lnkpoi == NULL)
          break;                  /* UI-Frames sind verboten            */
        rxneig(pp, fbp);          /* FlexNet-Internode-Frame            */
        return (TRUE);            /* toL7: Frame verarbeitet            */

#ifdef IPROUTE                    /* IP/ARP auf Interlink ist erlaubt   */
      case L2CIP:
        relink((LEHEAD *)fbp, (LEHEAD *)iprxfl.tail);
        return (TRUE);            /* Frame verarbeitet                  */

      case L2CARP:
        relink((LEHEAD *)fbp, (LEHEAD *)arprxfl.tail);
        return (TRUE);            /* Frame verarbeitet                  */
#endif
    }
  dealmb(fbp);                  /* unpassende/unbekannte PID, falscher  */
                                /* Nachbar, Fehler...                   */
  return (TRUE);
}

/*----------------------------------------------------------------------*/
void
cpyidl2(char *dest, const char *source)
{
  int count = 2;

  while (*source != '\0' && count-- > 0)
  {
    memcpy(dest, source, L2IDLEN);
    source += L2IDLEN;
    dest += L2IDLEN;
  }
  *dest = '\0';
}

/* Rufzeichen eines Node ausgeben, wahlweise Alias und SSID-Bereich     */
static void
putnod(NODE *np, int options, MBHEAD *mbp)
{
  if (!(options & OPT_SSID_RANGE))      /* Anzeige als Node             */
  {
    if (*np->alias != ' ')              /* Alias ist vorhanden, dann    */
      options |= OPT_ALIAS;             /* auch anzeigen                */
  }
  if (options & OPT_ALIAS)
  {
    putide(np->alias, mbp);
    putchr(':', mbp);              /* ":" als Trennung zum Rufzeichen   */
  }
  if (options & OPT_SSID_RANGE)
  {
    putprintf(mbp, "%6.6s %2d-%-2d", np->id, SSID(np->id), np->ssid_high);
  }
  else
    putid(np->id, mbp);
}

/*----------------------------------------------------------------------*/
/*  NODES                                                               */
/*  -----------                                                         */
/*  clipoi zeigt auf das naechste Zeichen der Komandozeile.             */
/*  Wenn clicnt == 0 ist diese zu ende.                                 */
/*  nodprm() operiert nur auf einer KOPIE von clicnt/clipoi !           */
/*----------------------------------------------------------------------*/
static void
show_nodes(const char *name,     /* Name (Nodes,Destinations,Locals)    */
           int options)          /* Optionen fuer die Ausgabe           */
{
  char      newcal[L2IDLEN];     /* neues Call                          */
  char      niden[L2CALEN];      /* neuer Alias                         */
  char     *cpoisa;              /* temp fuer clipoi                    */
  BOOLEAN   alles;               /* versteckte Nodes auch zeigen        */
  BOOLEAN   plus_quality;        /* mit Qualitaet etc. zeigen           */
  TRILLIAN  callok;              /* Ergebnis Test auf gueltiges Call    */
  TRILLIAN  isnode;              /* Ergebnis Test auf gueltigen Alias   */
  WORD      ccntsa;              /* temp fuer clicnt                    */
  MBHEAD   *mbp;                 /* Buffer fuer Meldung an User         */
  WORD      is_mask_or_qual;     /* Qualitaet / Wildcards angegeben     */
  UBYTE     mask[MAXMASK];
  UWORD     qual;
  UBYTE     nbrcal[L2IDLEN];
  int       j;
  INDEX     index;
  int       max_peers = netp->max_peers;
  unsigned  route_quality;
  unsigned  quality = 0;
  PEER     *pp;
  PEER     *bestpp;
  NODE     *np;
  ROUTE    *rp;
  int       width;
  int       len;
  BOOLEAN   all_routes;
  char      buf[40];
  char      call1[15];
  char      call2[15];
  int       maske = OPTIONS_MASK;

  if (!ismemr())                 /* Nicht genuegend Buffer !!!          */
    return;

  alles =                        /* default: keine versteckten Nodes    */
    plus_quality = FALSE;        /* default: ohne Qualitaet etc.        */

/* Wenn Befehlszeile leer, Qualitaet nicht beruecksichtigen; bei Aufruf */
/* mit Parametern, pruefen, ob Qualitaet / Wildcards angegeben          */

  is_mask_or_qual = clicnt ? nodprm(clipoi, clicnt, mask, &qual, nbrcal) : 0;

  if ((!is_mask_or_qual) && clicnt)         /* nur 1 Node gefragt       */
  {
    cpoisa = clipoi;                        /* Befehlszeile merken      */
    ccntsa = clicnt;
    if (options & OPT_ALIAS)
    {
      isnode = getide(&clicnt, &clipoi, niden);  /* Test auf gueltigen  */
                                                 /* Alias               */
      clipoi = cpoisa;                       /* Befehlszeile zurueck    */
      clicnt = ccntsa;
    }
    else
      isnode = NO;
    callok = getcal(&clicnt, &clipoi, TRUE, newcal);  /* Rufzeichen?   */

    if (callok == YES || isnode != ERRORS) /* einzelner Eintrag gefragt */
    {
      if (   !(options & OPT_ALIAS)
          || !(isnode)
          || ((index = find_alias(niden)) == NO_INDEX))
      {

/* Bei Nodes gibt es nur eine SSID. Nur Flex kann mehrere haben. Darum   */
/* erstmal auf genaues Ziel testen.                                      */
/* Wenn das genaue Ziel nicht gefunden wurde, koennen wir noch nach dem  */
/* SSID-Bereich ueber Flexnet-Nachbarn suchen                            */

        if (callok == YES)
        {
          if ((index = find_node_this_ssid(newcal)) == NO_INDEX)
          {
/* Da das genaue Ziel nicht gefunden wurde, koennen wir noch nach dem   */
/* SSID-Bereich ueber Flexnet-Nachbarn suchen                           */
            if ((index = find_node_ssid_range(newcal)) != NO_INDEX)
            {
/* Wir haben einen Flexnet-Weg gefunden - dann duerfen wir nachher auch */
/* nur einen Flexnet-Weg anzeigen                                       */
              maske = VC | VC_FAR;
            }
          }
        }
        else
          index = NO_INDEX;
      }

      if (index != NO_INDEX)
      {
        np = netp->nodetab + index;
        find_best_qual(index, &bestpp, options & maske);
        mbp = getmbp();             /* Buffer holen fuer Antwort        */
        putstr("Routes to ", mbp);
        if (!(maske & DG))              /* Flex-Ziel ueber SSID-Bereich */
          putid(newcal, mbp);
        else
        {
          putnod(np, (options & ~OPT_ALIAS), mbp);
/* bei "n alias" wird kein Call uebergeben                              */
          cpyid(newcal,np->id);
          if (np->ipa != 0L)
            putprintf(mbp, " (%u.%u.%u.%u/%u)",
                           (unsigned)(np->ipa >> 24),
                           (unsigned)((np->ipa >> 16) & 0xff),
                           (unsigned)((np->ipa >> 8) & 0xff),
                           (unsigned)(np->ipa & 0xff),
                           (unsigned)np->bits);
        }
        putstr("\r---T[ms]----RxT----TxT--LT-Mode-Obc-----"
               "RTT-Po-Route------------------------", mbp);

        all_routes = (strchr((char *)clipoi, '*') != NULL);

        for (pp = netp->peertab, j = 0;       /* alle Wege anzeigen     */
             j < max_peers; j++, pp++)
        {
          if (!pp->used)
            continue;
          if (!(pp->options & (options & OPTIONS_MASK)))
            continue;
          if (!(maske & DG))
            if (pp->typ != FLEXNET)
              continue;

          mbp->l4time = mbp->mbpc;

          rp = pp->routes + index;
          route_quality = rp->quality;
          quality = getquality(route_quality, pp);

          if (!quality && !all_routes)
            continue;

          if (pp->typ == FLEXNET)
            putstr(rp->reported_quality ? "\r- " : "\r> ", mbp);
          else
            putstr(quality ? pp == bestpp ? "\r> " : "\r  " : "\r- ", mbp);

          putspa(2, mbp);
          putprintf(mbp, "%6lu %6lu ",
                    ((ULONG)quality) * 10L,
                    ((ULONG)route_quality) * 10L);
          if (rp->reported_quality != DIRTY)
            putprintf(mbp, "%6lu ",
                      ((ULONG)rp->reported_quality) * 10L);
          else
            putstr("UPDATE ", mbp);
          putprintf(mbp, "%3u %4s %3u %7lu %2u",
                    (int)rp->lt,
                    pp->typ <= NETROM ? "DG" : "VC",
                    rp->timeout,
                    ((ULONG)pp->quality * 10),
                    pp->l2link->port);

          putspa(48, mbp);
          putid(pp->l2link->call, mbp);         /* Nachbarcall fuer Weg */
          putdil(pp->l2link->digil, mbp);       /* Digiweg zum Nachbarn */
        }
        putchr('\r', mbp);            /* Antwort abschliessen           */
        dump_options(np, mbp);
        call2str(call1, myid);
        if (quality && bestpp->typ >= LOCAL)
        {
          putchr('\r', mbp);
          putalt(alias, mbp);
          putid(myid, mbp);
          putprintf(mbp, "> %s <local>\r\r", call1);
        }
        prompt(mbp);
        seteom(mbp);                  /* Antwort abschicken             */

/* Routentest abhaengig vom Typ des besten Weges (LOCAL / LOCAL_M wurde */
/* schon vorher behandelt)                                              */
        if (bestpp->typ <= NETROM)
          request_nrr(np->id, userpo->uid);
        else
          if (bestpp->typ == FLEXNET)
          {
            call2str(call2, newcal);            /* das gesuchte Call    */
            sprintf(buf, "6!%5u%s %s", userpo->uid, call1, call2);
            if (clipoi[clicnt-1] == '>')/* Routentest um Laufzeitangabe */
              buf[2] = buf[2] | 0x60;   /* der Einzellinks erweitert    */
            flex_route_query(buf);
          }
        return;                       /* fertig                         */
      }
      else
      {
        mbp = putals("No entry for: ");
        strupr((char *)cpoisa);
        putstr((char *)cpoisa, mbp);
        putchr('\r', mbp);
        prompt(mbp);
        seteom(mbp);
        return;
      }
    }
  }

/* ========================== Nodestabelle anzeigen =================== */

  mbp = putals(name);               /* Kopfzeile                        */
  putnum(netp->num_nodes, mbp);     /* Zahl Nodeseintraege anzeigen     */
  putchr('/', mbp);                 /* Maximalanzahl ausgeben           */
  putnum(num_nodes_max, mbp);
  putstr("):\r", mbp);              /* Zeile abschliessen               */

  width = 0;

  if (is_mask_or_qual)              /* wenn Wildcards, alle untersuchen */
    alles = plus_quality = TRUE;

  for (np = (NODE *)netp->nodelis.head;
       np != (NODE *)&netp->nodelis;/* sortierte Nodes-Liste durchgehen */
       np = np->next)
  {
    index = (INDEX)(np - netp->nodetab);        /* Index berechnen      */
    if ((np->alias[0] != '#') || (alles == TRUE))
    {                        /* Eintrag kein #-Node oder alles anzeigen */
      quality = find_best_qual(index, &bestpp, options & OPTIONS_MASK);
      if (bestpp == NULL)
        continue;
      rp = bestpp->routes + index;
      if (is_mask_or_qual)              /* nur eine Auswahl bitte ...   */
      {

/* wird nach Routes eines bestimmten Nachbarn gesucht?                  */

        if (   (is_mask_or_qual & ISNBRCALL)
            && (!cmpid(bestpp->l2link->call, nbrcal)))
          continue;

        if (is_mask_or_qual & ISCALLMASK)        /* Call mit Wildcards? */
        {

/* wenn Call mit Wildcards nicht passt und nicht Alias mit Wildcards    */
/* gefragt wurde oder auch nicht passt, naechsten Eintrag testen        */

          if (   !c6mtch((UBYTE *)np->id, mask)
              && (   !(is_mask_or_qual & ISIDENTMASK)
                  || !c6mtch((UBYTE *)np->alias, mask)))
            continue;
        }

/* wenn Alias mit Wildcards gefragt, aber nicht passt, naechsten        */
/* Eintrag                                                              */

        else if (   (is_mask_or_qual & ISIDENTMASK)
                 && !c6mtch((UBYTE *)np->alias, mask))
          continue;

        if (quality > 0)
        {                                      /* aktiver Weg zum Node? */

/* wenn untere Qualitaetsgrenze angegeben, aber die Qualitaet fuer den  */
/* aktiven Weg zu gering ist, naechsten Eintrag testen                  */

          if (   (is_mask_or_qual & ISMINQUAL)
              && (quality < qual))
            continue;

/* wenn obere Qualitaetsgrenze angegeben, aber die Qualitaet fuer den   */
/* aktiven Weg zu hoch ist, naechsten Eintrag testen                    */

          if (   (is_mask_or_qual & ISMAXQUAL)
              && (quality > qual))
            continue;
        }
      }
      else if (quality == 0)
        continue;
    }

    mbp->l4time = mbp->mbpc;         /* Zaehler merken fuer putspa()    */
    putnod(np, options, mbp);
    if (options & OPT_SSID_RANGE)
      putspa(12, mbp);
    else
    {
      if (options & OPT_ALIAS)
        putspa(16, mbp);
      else
        putspa(9, mbp);
    }

    if (plus_quality == TRUE)        /* Qualitaet etc. auch anzeigen?   */
    {
      if (quality > 0)
      {                              /* wenn aktiver, diesen anzeigen   */
        if (quality > 6000)          /* mehr als eine Minute?           */
          putprintf(mbp, " %2umin", quality / 6000);
        else
          putprintf(mbp, " %5lu", ((ULONG)quality) * 10L);
        if (bestpp)
        {
          putchr('/', mbp);
          putprintf(mbp, "%2d ", bestpp->l2link->port);
        }
        else
          putstr("    ", mbp);
      }
      else                           /* kein aktiver Weg                */
        putstr("     -/ - ", mbp);
    }

    len = (mbp->mbpc - mbp->l4time); /* Laenge eines Eintrages          */
    width += len;
    if (width + len < 79)
    {                                /* einer passt noch in die Zeile   */
      len = (79 % len) / (79 / len);
      while (len--)
        putchr(' ', mbp);
    }
    else
    {
      putchr('\r', mbp);
      width = 0;
    }
  }
  putchr('\r', mbp);             /* Antwort abschliessen                */
  prompt(mbp);
  seteom(mbp);                   /* und abschicken                      */
}

/*----------------------------------------------------------------------*/
/* nodprm() - Parameter des erweiterten NODE Befehls auswerten          */
/* testet ob p ein Wort mit Wildcard enthaelt, kopiert dieses nach mp   */
/* Case-Conversion! Nod*E wird NOD*E                                    */
/* n MUSS > 0 sein                                                      */
/*----------------------------------------------------------------------*/
static WORD
nodprm(char *p,                        /* parameter des node befehls    */
       WORD n,                         /* restlaenge der parameterzeile */
       UBYTE *mp,                      /* nimmt die maske auf           */
       UWORD *qp,                      /* nimmt die quality auf         */
       UBYTE *nc)                      /* nimmt das nachbarcall auf     */
{
  WORD i;
  WORD ret = ISMINQUAL;
  WORD matchok;
  WORD c;

  if (*p == '-')
  {
    n--;
    p++;
    ret = ISMAXQUAL;
  }
  if ((*qp = (UWORD)(nxtlong(&n, &p) / 10L)) == 0)
  {
    ret = 0;
  }

  if (*p == '<')
  {
    n--;
    p++;
    if (getcal(&n, &p, TRUE, nc) == YES)
      ret |= ISNBRCALL;
  }

  if (skipsp(&n, &p))
  {
    matchok = FALSE;
    for (i = 0; i < (MAXMASK - 1);)
    {
      if (!n || ((c = *p++) == ' '))
        break;
      n--;
      if (c == ':')
      {
        if (i == 0)
        {
          ret |= ISCALLMASK;
          continue;
        }
        else
        {
          ret &= ~ISCALLMASK;
          ret |= ISIDENTMASK;
          break;
        }
      }
      if ((c == MATCHMANY) || (c == MATCHONE))
      {
        matchok = TRUE;
      }
      mp[i++] = isascii(c) ? toupper(c) : MATCHONE;
    }
    mp[i] = MATCHEND;
    if (matchok)
    {
      if (!(ret & (ISCALLMASK | ISIDENTMASK)))
      {
        ret |= (ISCALLMASK | ISIDENTMASK);
      }
    }
    else
    {
      ret &= ~(ISCALLMASK | ISIDENTMASK);
    }
  }
  return (ret);
}

/*----------------------------------------------------------------------*/
void
ccpnod(void)                     /* Nodes ausgeben                      */
{
  show_nodes("Nodes (", OPT_ALIAS | OPT_DGTEST | VC | VC_FAR | DG);
}

/*----------------------------------------------------------------------*/
void
ccpdest(void)                    /* Destinations ausgeben               */
{
  show_nodes("Destinations (", OPT_SSID_RANGE | OPT_VCTEST | VC | VC_FAR | DG);
}

/*----------------------------------------------------------------------*/
/* Diese Routine bereitet das Senden des NRR-Requestframes vor          */
static void
request_nrr(char *id, UID uid)
{
  NRRLIST list[2];

  cpyid(desnod, id);                                         /* L3-Teil */
  cpyid(orgnod, myid);
  time_to_live = timliv;

  l4hdr0 = 0;                                                /* L4-Teil */
  l4hdr1 = 1;

  l4hdr2 = uid >> 8;
  l4hdr3 = uid & 0xFF;
  l4hdr4 = 0;

  cpyid(list[0].id, myid);                                   /* Daten   */
  list[0].lt = time_to_live + 1;
  list[1].id[0] = NUL;

  send_nrr_frame(list);
}

static const char *reason[] =
{"no route", "local", "flexgate", "", "loop"};

/* Die Antwort wird hier etwas leserlicher gemacht und an den User      */
/* geschickt                                                            */
static void
nrr2usr(NRRLIST *l)
{
  char    buffer[512],
         *bp,
          call[10];
  int     llt,
          lt,
          err;
  UID     uid;
  USRBLK *up;
#define LT_MASK   0x7F
#define ECHO_FLAG 0x80

  bp = buffer;
  llt = l->lt & LT_MASK;

  while (*l->id)
  {                                         /* Liste abarbeiten         */
    *bp++ = ' ';
    lt = l->lt & LT_MASK;
    while (llt > lt)
    {                                       /* fehlende Digis markieren */
      *bp++ = '?';
      *bp++ = ' ';
      llt--;
    }
    call2str(call, l->id);
    bp += sprintf(bp, "%s", call);
    if (l->lt & ECHO_FLAG)
    {                                       /* Echoflag anzeigen        */
      *bp++ = '*';
      err = l->id[L2CALEN] >> 5;            /* Fehlercode extrahieren   */
      if (err < 5 && err != 3)              /* und anzeigen             */
        bp += sprintf(bp, "<%s>", reason[err]);
    }
    llt--;
    l++;
  }
  *bp++ = ' ';
  time_to_live++;
  while (llt > time_to_live)
  {
    *bp++ = '?';
    *bp++ = ' ';
    llt--;
  }
  call2str(call, myid);
  bp += sprintf(bp, "%s", call);

  uid = (l4hdr2 << 8) | l4hdr3;                /* User suchen           */
  if (uid > 0 && uid < NUMPAT)
    if ((up = ptctab[uid].ublk) != NULL)
      send_async_response(up, "Route (DG):", buffer);
}

/* Hier wird das NRR-Frame zusammengebastelt und verschickt             */
static void
send_nrr_frame(NRRLIST *l)
{
  PEER   *pp;
  NODE   *dstnod;
  MBHEAD *mbp;

  if (iscall(desnod, &dstnod, &pp, DG))
  {
    mbp = (MBHEAD *)allocb(ALLOC_MBHEAD);

    putfid(orgnod, mbp);
    putfid(desnod, mbp);
    putchr(time_to_live, mbp);
    putchr(l4hdr0, mbp);
    putchr(l4hdr1, mbp);
    putchr(l4hdr2, mbp);
    putchr(l4hdr3, mbp);
    putchr(l4hdr4, mbp);
    while (*l->id)
    {
      putfid(l->id, mbp);
      putchr(l->lt, mbp);
      l++;
    }
    rwndmb(mbp);
    toneig(pp, mbp);
  }
}

#define TO       0      /* dir */
#define BACK     1

#define NOTKNOWN 1      /* tome und ret */
#define ISLOCAL  2
#define VIAFLEX  3
#define DIRECT   4
#define LOOPED   5

/* Diese Funktion analysiert die empfangenen NRR-Frames.                */
/* Etliche Fehler werden erkannt und entsprechend reagiert.             */
/*                                                                      */
/* tome   gibt an, ob mich das Frame was angeht                         */
/* ret    besagt, ob das Frame zurueckgeschickt werden soll und wieso   */
/* dir    gibt die NRR-Richtung an                                      */
/* looped ist wahr, wenn unsere ID im Hinweg vorkam und dir gleich TO   */
static void
nrr_rx(MBHEAD *mbp, PEER *rxpp)
{
  NRRLIST  list[30],
          *l;
  int      nlist,
           ret,
           tome,
           dir;
  BOOLEAN  looped;
  PEER    *topp;

  if (!time_to_live)                           /* zuspaet               */
    return;

  looped = tome = ret = FALSE;
  dir = TO;
  topp = NULL;

  if (cmpid(desnod, myid))                     /* das geht uns an...    */
    tome = DIRECT;
  else if (iscall(desnod, NULL,                /* sonst den besten Weg  */
                  &topp, DG | VC | VC_FAR))
  {                                            /* bestimmen             */
    if (topp->options & VC)                    /* ein local von uns     */
      tome = ISLOCAL;
    else if (topp->options & VC_FAR)           /* wuerde via flex gehen */
      tome = VIAFLEX;
  }

  nlist = 0;
  l = list;
  while (mbp->mbpc - mbp->mbgc >= L2IDLEN + 1)
  {                                                /* Eintrag da?       */
    if (getfid(l->id, mbp) == TRUE)
    {
      l->lt = getchr(mbp);
      if (l->lt & ECHO_FLAG)
      {                                        /* EchoFlag              */
        dir = BACK;
        looped = FALSE;
      }
      if (dir == TO && cmpid(l->id, myid))     /* Loop in Hin-Liste     */
        looped = TRUE;
      nlist++;
      l++;
    }
  }
  l->id[0] = '\0';                             /* Liste beenden         */

  if (   !nlist                                /* leere Liste           */
      || rxpp == topp)                         /* Loop in den Nodes     */
    return;

  if (cmpid(list[0].id, myid))
  {                                            /* das ist meine Anwort  */
    nrr2usr(list);
    return;
  }

  if (dir == BACK && (   topp == NULL          /* Ziel unbekannt        */
                      || tome == VIAFLEX))     /* bzw. Flex im Rueckweg */
    return;

  if (topp == NULL && !tome)                   /* Ziel unbekannt        */
    ret = NOTKNOWN;
  else if (looped)                             /* Loop in der Liste     */
    ret = LOOPED;
  else if (tome)                               /* wir sind das Ziel     */
    ret = tome;

  if (ret)
  {                                            /* Weg umdrehen          */
    cpyid(desnod, orgnod);
    cpyid(orgnod, myid);
  }

  if (nlist < 29)
  {                                            /* wir passen noch dran  */
    cpyid(l->id, myid);
    l->lt = time_to_live + 1;
    if (ret)
    {
      l->id[L2CALEN] &= 0x1f;
      l->id[L2CALEN] |= (ret - 1) << 5;        /* Fehler in SSID-Feld   */
      l->lt |= ECHO_FLAG;
    }
    l++;
    l->id[0] = '\0';                           /* Liste beenden         */
  }

  send_nrr_frame(list);
}

/* End of src/l3b.c */
