/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l3inp.c (maintained by: ???)                                */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2003 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"
#include "l3local.h"


static BOOLEAN  update_options(INDEX, const char *, ULONG, UBYTE, MBHEAD *);
UWORD           max_lt = 30;          /* Maximale LT                    */

/************************************************************************/
/*                                                                      */
/* Wenn sich die Info zu einem Node aendert, werden alle INP-Routes zur */
/* Aktualisierung ausgeschrieben.                                       */
/*                                                                      */
/************************************************************************/
void
propagate_node_update(INDEX index)
{
  PEER  *pp;
  ROUTE *rp;
  int    max_peers = netp->max_peers;
  int    i;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
  {
    if (!pp->used)
      continue;
    if (pp->typ != INP)
      continue;
    rp = pp->routes + index;
    if (rp->reported_quality)           /* nur wenn wir gemeldet hatten */
      rp->reported_quality = DIRTY;
  }
}

/*----------------------------------------------------------------------*/
BOOLEAN
rx_inp_broadcast(PEER *rxpp, MBHEAD *mbp)
{
  char     desnod[L2IDLEN];
  char     beaide[L2CALEN],
          *bp;
  int      lt;
  unsigned qual;
  INDEX    index;
  int      tag;
  int      len,
           i,
           ch;
  PEER    *pp;
  MBHEAD  *options;
  ULONG    ip_adr;
  UBYTE    bits;
#if MAX_TRACE_LEVEL > 0
  char     notify_call1[10];
#if MAX_TRACE_LEVEL > 2
  char     notify_call2[10];
#endif
#endif

  if (*mbp->mbbp != 0xFF)               /* Kennung INP-Routing-Paket?   */
    return (FALSE);

  getchr(mbp);                                   /* Kennung uebergehen  */

  while ((mbp->mbpc - mbp->mbgc) > 10)
  {
/* einen Nodeseintrag lesen ggf. incl. Alias, IP-Nr./Subnet und anderen */
/* INP-Options                                                          */
    cpyals(beaide, DONT_CHANGE_ALIAS);          /* Default: kein Alias  */
    ip_adr = 0L;                                /* und keine IP-Adresse */
    bits = 0;                                   /* keine IP-Subnetzbits */
    options = NULL;                             /* sowie keine Options  */
    lt = 0;                                     /* Lifetime             */
    qual = 0;                                   /* Laufzeit             */

    if (!getfid(desnod, mbp))
      break;
    if (valcal(desnod) == ERRORS)
      break;

    if (rxpp->version > 170 && rxpp->version < 176)
    {
      qual = get16(mbp);
      lt = getchr(mbp);
    }
    else
    {
      lt = getchr(mbp);
      qual = get16(mbp);
    }

    if (lt == 0)                /* LT 0 darf nie gesendet werden, hier  */
      lt = DEFAULT_LT;          /* korrigieren                          */
    else
      lt++;

    if (rxpp->version > 170 && rxpp->version < 175)
    {
      /* fehlerhafte Versionen */
      while (   ((tag = getchr(mbp)) != 0)
             && (mbp->mbpc - mbp->mbgc > 1))
      {
        len = getchr(mbp);
        if (mbp->mbpc - mbp->mbgc < len)
          return (TRUE);
        switch (tag)
        {
          case 1:                                       /* ALIAS_ID     */
            for (i = 0, bp = beaide; i < len; i++)
            {
              ch = getchr(mbp);
              if ((ch < ' ') || (ch > 127))
              {
#if MAX_TRACE_LEVEL > 2
                call2str(notify_call1, rxpp->l2link->call);
                notify(3, "invalid alias from %s (flushed)",
                       notify_call1);
#endif
                return (TRUE);
              }
              *bp++ = ch;
            }
            for (; i < L2CALEN; i++)
              *bp++ = ' ';
            break;
          default:
            while (len-- > 0)
              getchr(mbp);
        }
      }
    }
    else
    {                                 /* (halbwegs) korrektes Protokoll */
/* Endekriterium fuer den Nodeseintrag ist das EOP-Byte (0x00) am Ende  */
/* des RIP-Blocks. Danach koennen weitere Nodeseintraege folgen.        */
      while (mbp->mbpc > mbp->mbgc)
      {
/* Einzelnen Options-Eintrag lesen und auswerten, falls Typ bekannt     */
        if ((len = getchr(mbp)) == 0)   /* EOP-Byte                     */
          break;
        len--;                          /* Laengenbyte selbst abziehen  */

        if (mbp->mbpc - mbp->mbgc < len)                /* INP-Fehler!  */
        {
/* Der Fehler wird ggf. gemeldet, die fehlerhaften Options werden       */
/* komplett verworfen, damit wir keinen Muell weitermelden.             */
#if MAX_TRACE_LEVEL > 0
          call2str(notify_call1, rxpp->l2link->call);
          notify(1, "INP: frame error received from %s, "
                    "len = %u, left = %u", notify_call1, len,
                    (int)(mbp->mbpc - mbp->mbgc));
#endif
          if (options != NULL)
          {
            dealmb(options);
            options = NULL;
          }
          break;
        }

        len--;                                  /* Laenge tag abziehen  */
        switch (tag = getchr(mbp))
        {
          case INP_ALIAS:
            for (i = 0, bp = beaide; i < len; i++)
            {
              ch = getchr(mbp);
              if ((ch < ' ') || (ch > 127) || (len > L2CALEN))
              {
#if MAX_TRACE_LEVEL > 2
                call2str(notify_call1, rxpp->l2link->call);
                notify(3, "invalid alias from %s (flushed)", notify_call1);
#endif
                if (options != NULL)
                  dealmb(options);
                return (TRUE);
              }
              *bp++ = ch;
            }

            if (beaide[0] == '#')
            {
#if MAX_TRACE_LEVEL > 2
                call2str(notify_call1, rxpp->l2link->call);
                call2str(notify_call2, desnod);
                notify(3, "%s sent secret node %s", notify_call1, notify_call2);
#endif
                /* XNet hat derzeit einen Fehler der massenweise Nodes mit dem */
                /* Geheim-Alias #temp sendet. Da diese Nodes nicht wirklich    */
                /* geheim sind nehmen wir sie trotzdem, loeschen aber ihre     */
                /* Aliasse. */

                if (   (beaide[1] != 't')
                    && (beaide[2] != 'e')
                    && (beaide[3] != 'm')
                    && (beaide[4] != 'p'))
                {
                    /* ein ganz normaler Secret, normal behandeln */
                    if (options != NULL)
                        dealmb(options);

#if MAX_TRACE_LEVEL > 2
                    notify(3, "secret node flushed");
#endif
                    return (TRUE);
                }
                else
                {
                    /* fehlerhaften Alias loeschen */
                    cpyals(beaide, DONT_CHANGE_ALIAS); /* Alias loeschen */
                    i = L2CALEN;        /* brauchen wir nicht mehr auffuellen */
#if MAX_TRACE_LEVEL > 2
                    notify(3, "not real secret node, corrected");
#endif
                }
            }

            for (; i < L2CALEN; i++)    /* auffuellen mit ' '           */
              *bp++ = ' ';
            break;
          case INP_IPA:
            if (len == 5)
            {
              ip_adr = get32(mbp);
              bits = getchr(mbp);
            }
            else
            {
#if MAX_TRACE_LEVEL > 2
              call2str(notify_call1, rxpp->l2link->call);
              notify(3, "invalid ipa-length from %s (flushed)",
                        notify_call1);
#endif
              if (options != NULL)
                dealmb(options);
              return (TRUE);
            }

            /* rudimentaerer Check der Subnetz-Bits, sind diese falsch */
            /* wird die IP fuer diesen Node nicht uebernommen, die IP  */
            /* wird an anderer Stelle je nach Einstellung ueberprueft  */
            if ((bits <= 0) || (bits > 32))
            {
              ip_adr = 0L;
              bits = 0;
#if MAX_TRACE_LEVEL > 2
              call2str(notify_call1, desnod);
              notify(3, "invalid subnet-bits for %s, ip not stored, deleted",
                        notify_call1);
#endif
            }
            break;
          default:
          /* unbekannte Option - in Buffer speichern */
            if (options == NULL)
              options = (MBHEAD *)allocb(ALLOC_INPOPT);
            putchr(len + 2, options);
            putchr(tag, options);
            while (--len >= 0)
              putchr(getchr(mbp), options);
        }
      }
    }

    if (cmpid(myid, desnod) || iscall(desnod, NULL, NULL, VC))
    {
#if MAX_TRACE_LEVEL > 2
      call2str(notify_call1, myid);
      call2str(notify_call2, rxpp->l2link->call);
      notify(3, "destination %s received from %s (ignored)",
             notify_call1, notify_call2);
#endif
      if (options != NULL)
      {
        dealmb(options);
        options = NULL;
      }
      continue;
    }

#if MAX_TRACE_LEVEL > 8
    call2str(notify_call1, rxpp->l2link->call);
    call2str(notify_call2, desnod);
    notify(9, "%-9.9s>%-6.6s:%-9.9s Q%u LT%u",
           notify_call1, beaide, notify_call2, qual, lt);
#endif

    if (lt > max_lt)                    /* Nach Lifetime runterzwingen  */
      qual = 0;                         /* Knoten nicht annehmen        */

    if (cmpid(rxpp->l2link->call, desnod))      /* der Nachbar selbst   */
      qual = lt = 1;                          /* immer ein Hop entfernt */

    if ((index = add_route(rxpp, desnod, qual)) != NO_INDEX)
    {
      /* Ziele mit diesen Laufzeiten sollen abgemeldet werden, Lifetime = 0 */
      if ((qual == 60000L) || (qual == 0))
        update_lt(rxpp, index, 0);
      else
      /* alle anderen Laufzeiten normale Lifetime */
        update_lt(rxpp, index, lt);

      if (!cmpcal(netp->nodetab[index].alias, nulide))
      {
        if (find_best_qual(index, &pp, DG) > 0)     /* beste Qualitaet  */
        {
          if (pp != rxpp)
          {
            if (options != NULL)
            {
              dealmb(options);
              options = NULL;
            }
            continue;
          }
        }
      }
      /* Der primaere Weg hat sich geaendert, wir uebernehmen Node-Info   */
      /* sofern vorhanden (Alias, IP-Nr., Options). Wird keine Zusatzinfo */
      /* gemeldet, bleibt die bisher bekannte Info erhalten.              */
      if (update_options(index, beaide, ip_adr, bits, options))
      {
        propagate_node_update(index);
        options = NULL;
      }
    }
  } /* bis Frameende */
  return (TRUE);
}

/************************************************************************/
/*                                                                      */
/* Uebernehmen neuer Zusatzinfos zu einem Node (Alias, IP-Nr./Subnet,   */
/* weitere unbekannte Options). Wird nichts gemeldet, bleiben bekannte  */
/* Daten gespeichert. Wird etwas neu gemeldet, muessen ALLE Daten neu   */
/* gemeldet werden. Alles was nicht mehr gemeldet wird, wird geloescht. */
/*                                                                      */
/************************************************************************/
static BOOLEAN
update_options(INDEX index, const char *alias,
               ULONG ip_adr, UBYTE bits, MBHEAD *options)
{
  NODE    *np;
  BOOLEAN  res = FALSE;
  BOOLEAN  ip_valid = TRUE;
  int      len;
  char     temp[1];
  ipaddr   host;

  temp[0] = 0;                         /* damit arp_add() zufrieden ist */

  if (   !cmpcal(alias, nulide)         /* nur wenn ueberhaupt INP-     */
      || ip_adr != 0L                   /* Options uebertragen wurden   */
      || options != NULL)               /* kann sich etwas aendern      */
  {
/* Es wurden Options uebertragen - also muessen alle Options auf den    */
/* neuen Wert gesetzt werden, oder geloescht, falls nicht mehr gemeldet */
    np = netp->nodetab + index;
    res = !cmpcal(np->alias, alias);
    cpyals(np->alias, alias);

    if (   ip_adr != np->ipa
        || bits != np->bits)
      res = TRUE;

/* ARP- und IPR-Eintrag erneuern                                        */
/* nur austragen wenn schon was eingetragen gewesen ist und die         */
/* automatische Modifikation erlaubt                                    */
    if (np->ipa != 0L && autoipr != 0)
    {
      arp_drop(np->ipa, NETROM_PORT, TRUE);
      rt_drop(np->ipa, np->bits, TRUE);
    }

/* neue Eintraege nur machen wenn nicht leer gemeldet und wir selber    */
/* eine IP-Adresse haben und wir das ueberhaupt duerfen (Param. 12)     */
    if (ip_adr != 0L && my_ip_addr != 0L && autoipr != 0)
    {
/* bevor wir die IP uebernehmen erst mal pruefen wenn wir das sollen    */
      if (autoipr >= 2)
      {
/* elementare Pruefung immer machen                                     */
        if (((ip_adr & 0xFF) == 0L) || ((ip_adr & 0xFF) == 0xFF))
          ip_valid = FALSE;

/* nur IPs uebernehmen, die im gleichen Netz sind                       */
        if (   (autoipr >= 3)
            && ((ip_adr & 0xFF000000L) != (my_ip_addr & 0xFF000000L)))
          ip_valid = FALSE;
      }

      if (ip_valid)
      {
        arp_add(ip_adr, NETROM_PORT, np->id, temp, 0, 0, FALSE, TRUE);
        host = ip_adr;
        host >>= (32 - bits);
        host <<= (32 - bits);
        rt_add(host, bits, ip_adr, NETROM_PORT, 0, 0, 0, TRUE);
      }
    }

    np->ipa = ip_adr;
    np->bits = bits;

    if (options == NULL)                /* keine unbekannten Options?   */
    {
      if (np->options != NULL)          /* war aber was bekannt?        */
      {
        dealmb(np->options);
        np->options = NULL;
        res = TRUE;
      }
      return (res);
    }
    if (np->options == NULL)            /* bisher nix bekannt           */
    {
      np->options = options;
      return (TRUE);
    }
    if ((len = options->mbpc) == np->options->mbpc)
    {
/* alte und neue Options sind gleich lang - also vergleichen, ob sich   */
/* etwas geaendert hat (wir gehen mal davon aus, dass die Reihenfolge   */
/* unveraendert bleibt)                                                 */
      rwndmb(options);
      rwndmb(np->options);
      while (--len >= 0)
      {
        if (getchr(options) != getchr(np->options))
          break;
      }
      if (len < 0)
      {
        dealmb(options);                  /* keine neuen Options          */
        return (res);
      }
    }
    dealmb(np->options);                  /* alte Options vergessen       */
    np->options = options;                /* neue merken                  */
    return (TRUE);                        /* Aenderung                    */
  }
  return (res);
}

/************************************************************************/
/*                                                                      */
/* "add internode protocol route information"                           */
/*                                                                      */
/* Einen Weg zu dem Routing-Info-Frame fuer einen Nachbarn hinzufuegen. */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void
add_inp_info(MBHEAD **mbpp, NODE *node, PEER *topp, unsigned qualit,
             unsigned last_qualit, int lt)
{
  char  buf[256],
       *bp,
       *bp2;
  int   len;

  bp = buf;

  if (qualit == 0)
    qualit = HORIZONT;

  if (topp->version > 170 && topp->version < 176)
  {
    *bp++ = qualit >> 8;
    *bp++ = qualit & 0xFF;
    *bp++ = lt;
  }
  else
  {
    *bp++ = lt;
    *bp++ = qualit >> 8;
    *bp++ = qualit & 0xFF;
  }

  if (   (qualit && last_qualit == 0)
      || last_qualit == DIRTY)
  {
    if (topp->version > 170 && topp->version < 175)
    {                                                   /* fehlerhaft   */
      *bp++ = 1;                                        /* ALIAS_ID     */
      *bp++ = L2CALEN;
      cpyals(bp, node->alias);
      bp += L2CALEN;
    }
    else
    {
/* (halbwegs) richtige Implementierung                                  */
      for (len = 0; len < L2CALEN; len++)
        if (node->alias[len] == ' ')
          break;
      if (len != 0)
      {
        *bp++ = len + 2;
        *bp++ = INP_ALIAS;
        memcpy(bp, node->alias, (size_t)len);
        bp += len;
      }
      if (node->ipa != 0L)
      {
        *bp++ = 7;
        *bp++ = INP_IPA;
        *bp++ = node->ipa >> 24;
        *bp++ = (node->ipa >> 16) & 0xff;
        *bp++ = (node->ipa >> 8) & 0xff;
        *bp++ = node->ipa & 0xff;
        *bp++ = node->bits;
      }
      if (node->options != NULL)
      {
        rwndmb(node->options);
        while (node->options->mbpc > node->options->mbgc)
          *bp++ = getchr(node->options);
      }
    }
  }
  *bp++ = 0;                             /* Ende der Meldung (EOP)      */
  len = (int)(bp - buf) + L2IDLEN;       /* Laenge berechnen            */

  if (*mbpp)                             /* noch ein Buffer in Arbeit ? */
    if ((*mbpp)->mbpc + len > 256)       /* passt nicht mehr ?          */
      brosnd(mbpp, topp);                /* dann senden                 */

  /* war der Buffer voll so wurde er gesendet und entsorgt, */
  /* *mbpp ist jetzt NULL, das hat brosnd() erledigt        */

  if (*mbpp == NULL)                     /* noch kein Buffer besorgt    */
  {                                      /* neues I-Frame holen         */
    (*mbpp = (MBHEAD *)allocb(ALLOC_MBHEAD))->l3_typ = L2CI;
    putchr(0xFF, *mbpp);                 /* Kennung                     */
  }

  putfid(node->id, *mbpp);
  for (bp2 = buf; bp2 < bp; bp2++)
    putchr(*bp2, *mbpp);
}

/* End of src/l3inp.c */
