/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File os/linux/ax25ip.c (maintained by: DG1KWA)                       */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2000 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/*                                                                      */
/* AX25IP.C V1.05 01.9.98 by DG1KWA / Andreas                           */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

#ifdef AX25IP

/* Defines */
#define NO_MODE  0
#define IP_MODE  1
#define UDP_MODE 2
#define IPPROTO_AX25 93
#define DEFAULT_UDP_PORT 10093
#define CONFIG_FILE "ax25ip.cfg"
#define NOT_LAST(p)     (((*(p+6))&0x01)==0)
#define NOTREPEATED(p)  (((*(p+6))&0x80)==0)
#define NO_DIGIS(f)     (((*(f+13))&0x01)!=0)
#define MAX_FRAME  2048
#define TABLE_SIZE  128
#define LOGL1 if(loglevel>0)(void)write_log
#define LOGL2 if(loglevel>1)(void)write_log
#define LOGL3 if(loglevel>2)(void)write_log
#define LOGL4 if(loglevel>3)(void)write_log

/* Variablen */
static LHEAD  *l2flp;
static DEVICE *l1pp;
static int     ax25ip_port;
static BOOLEAN ax25ip_active = FALSE;
static BOOLEAN sockopt_keepalive = FALSE;
static BOOLEAN sockopt_throughput = FALSE;
static WORD    mode;
static struct  sockaddr_in udpbind;
static struct  sockaddr_in to;
static struct  sockaddr_in from;
static fd_set  rmask;
unsigned short my_udp;
static struct timeval timevalue;
int            route_tbl_top = 0;
int            loglevel = 0;

struct route_table_entry {
   unsigned char callsign[7];           /* the callsign and ssid */
   unsigned char padcall;               /* always set to zero */
   unsigned char ip_addr[4];            /* the IP address */
   unsigned short udp_port;             /* the port number if udp */
   unsigned char pad1;
   unsigned char pad2;
};

struct route_table_entry route_tbl[TABLE_SIZE];
struct route_table_entry default_route;

/* Funktionsprototypen */
static void        ax25ip_send(void);
static void        ax25ip_recv(void);
static void        route_add(unsigned char *, unsigned char *, int, int);
void               route_init(void);
void               add_crc(unsigned char *buf, int l);
int                addrmatch(unsigned char *a, unsigned char *b);
void               add_ax25crc(unsigned char *buf, int l);
unsigned short int compute_crc(unsigned char *buf, int l);
int                config_read(void);
int                parse_line(char *buf);
int                a_to_call(char *text, unsigned char *tcall);
char              *call_to_a(unsigned char *tcall);
unsigned char     *call_to_ip(unsigned char *call);
unsigned char     *next_addr(unsigned char *f);
void               write_log(const char *format, ...);
int                ok_crc(unsigned char *buf, int l);

/*************************************************************************/
void ax25ip(void)
{
  if (!ax25ip_active)
    return;
  ax25ip_recv();
  ax25ip_send();
}


/************************************************************************/
BOOLEAN ax25ip_l1init(int l2port)
{
  if (ax25ip_active == TRUE)
    return(TRUE);

  ax25ip_port = l2port;
  l1pp = &l1port[l1ptab[l2port]];
  l2flp = (LHEAD *) &txl2fl[l2port];

  route_init();
  if (config_read() == FALSE) return(FALSE);

  /* Socketstrukturen initialisieren */
  bzero((char*)&udpbind, sizeof(udpbind));
  bzero((char*)&to, sizeof(to));
  bzero((char*)&from, sizeof(from));

  /* IP-Mode */
  if (mode == IP_MODE)
  {
     l1pp->kisslink = socket(AF_INET, SOCK_RAW, IPPROTO_AX25);

     if (l1pp->kisslink < 0)
     {
        xprintf("IP-Mode:cannot create socket: %s\n", strerror(errno));
        LOGL2("IP-Mode:cannot create socket: %s\n", strerror(errno));
        return(FALSE);
     }

     if (fcntl(l1pp->kisslink, F_SETFL, FNDELAY) < 0)
     {
        xprintf("IP-Mode: cannot set non-blocking I/O on ip-raw socket");
        LOGL2("IP-Mode: cannot set non-blocking I/O on ip-raw socket");
        return(FALSE);
     }

     /* Socket-Optionen fuer RAW-IP einstellen */

     /* SO_KEEPALIVE einschalten */
     if (sockopt_keepalive == TRUE)
     {
       int iFlag = 1;

       if (setsockopt(l1pp->kisslink, SOL_SOCKET, SO_KEEPALIVE,
                      &iFlag, sizeof(int)) < 0)
       {
         xprintf("IP-Mode: cannot set socketoption SO_KEEPALIVE: %s\n",
                 strerror(errno));
         LOGL2("IP-Mode: cannot set socketoption SO_KEEPALIVE: %s\n",
                 strerror(errno));
       }
     }

     /* Socket auf max. Durchsatz */
     if (sockopt_throughput == TRUE)
     {
       int iFlag = IPTOS_THROUGHPUT;

       if (setsockopt(l1pp->kisslink, IPPROTO_IP, IP_TOS,
           &iFlag, sizeof(IPTOS_THROUGHPUT)) < 0)
       {
         xprintf("IP-Mode: cannot set socketoption IPTOS_THROUGHPUT: %s\n",
                 strerror(errno));
         LOGL2("IP-Mode: cannot set socketoption IPTOS_THROUGHPUT: %s\n",
               strerror(errno));
       }
     }

     udpbind.sin_family = AF_INET;
     udpbind.sin_addr.s_addr = INADDR_ANY;
  }

  /* UDP-Mode */
  if (mode == UDP_MODE)
  {
     l1pp->kisslink = socket(AF_INET, SOCK_DGRAM, 0);

     if (l1pp->kisslink < 0)
     {
        xprintf("UDP-Mode: cannot create socket: %s\n", strerror(errno));
        LOGL2("UDP-Mode: cannot create socket: %s\n", strerror(errno));
        return(FALSE);
     }

     if (fcntl(l1pp->kisslink, F_SETFL, FNDELAY) < 0)
     {
        xprintf("UDP-Mode: cannot set non-blocking I/O on ip-raw socket");
        LOGL2("UDP-Mode: cannot set non-blocking I/O on ip-raw socket");
        return(FALSE);
     }

     /* Socket-Optionen fuer UDP einstellen */

     /* SO_KEEPALIVE einschalten */
     if (sockopt_keepalive == TRUE)
     {
       int iFlag = 1;

       if (setsockopt(l1pp->kisslink, SOL_SOCKET, SO_KEEPALIVE,
                      &iFlag, sizeof(int)) < 0)
       {
         xprintf("UDP-Mode: cannot set socketoption SO_KEEPALIVE: %s\n",
                 strerror(errno));
         LOGL2("UDP-Mode: cannot set socketoption SO_KEEPALIVE: %s\n",
               strerror(errno));
       }
     }

     /* Socket auf max. Durchsatz */
     if (sockopt_throughput == TRUE)
     {
       int iFlag = IPTOS_THROUGHPUT;

       if (setsockopt(l1pp->kisslink, IPPROTO_IP, IP_TOS,
           &iFlag, sizeof(IPTOS_THROUGHPUT)) < 0)
       {
         xprintf("UDP-Mode: cannot set socketoption IPTOS_THROUGHPUT: %s\n",
                 strerror(errno));
         LOGL2("UDP-Mode: cannot set socketoption IPTOS_THROUGHPUT: %s\n",
               strerror(errno));
       }
     }

     udpbind.sin_addr.s_addr = INADDR_ANY;
     udpbind.sin_port = my_udp;
     udpbind.sin_family = AF_INET;
     if (bind(l1pp->kisslink, (struct sockaddr *)&udpbind, sizeof udpbind) < 0)
     {
        xprintf("cannot bind udp socket\n");
        LOGL2("cannot bind udp socket\n");
        return(FALSE);
     }
  }

  ax25ip_active = TRUE;
  return(TRUE);
}

/*************************************************************************/
static void ax25ip_recv(void)
{
 struct  iphdr *ipptr;
 int     l = 0;
 int     i = 0;
 int     fromlen = 0;
 int     hdr_len = 0;
 UBYTE   buf[MAX_FRAME];
 UBYTE  *bufptr;
 MBHEAD *rxfhd;

  FD_ZERO(&rmask);
  FD_SET(l1pp->kisslink, &rmask);

  timevalue.tv_usec = 0;
  timevalue.tv_sec = 0;
  select(FD_SETSIZE, &rmask, NULL, NULL, &timevalue);

  if (FD_ISSET(l1pp->kisslink, &rmask)) {
    /* RX fuer IP-Mode */
    if (mode == IP_MODE) {
       l = recvfrom(l1pp->kisslink, (UBYTE *) (bufptr = buf), MAX_FRAME, 0,
                   (struct sockaddr *) &from, &fromlen);

       if (l > 0) {
          ipptr = (struct iphdr *)buf;
          hdr_len = 4 * ipptr->ihl;

          if (!ok_crc(buf+hdr_len, l-hdr_len)) { /* stimmt die CRC ? */
             LOGL2("CRC-Error");
             return; /* Fehler */
          }

          l = l - 2; /* CRC abschneiden */

          if (l < 15) {
             LOGL2("from_ip: dumped - length wrong !");
             return;
          }

          (rxfhd = (MBHEAD *)allocb(ALLOC_MBHEAD))->l2port = ax25ip_port;
          for (i = hdr_len; i < l; i++)
             putchr(buf[i], rxfhd); /* Buffer umkopieren */

          relink((LEHEAD *)rxfhd, (LEHEAD *)rxfl.tail);
       }
    }

    /* RX fuer UDP-Mode */
    if (mode == UDP_MODE) {
       l = recvfrom(l1pp->kisslink, (UBYTE *) (bufptr = buf), MAX_FRAME, 0,
                   (struct sockaddr *) &from, &fromlen);

       if (l > 0) {
          if (!ok_crc(buf, l)) { /* stimmt die CRC ? */
             LOGL2("CRC-Error");
             return; /* Fehler */
          }

          l = l - 2; /* CRC abschneiden */

          if (l < 15) {
             LOGL2("from ip: dumped length wrong !");
             return;
          }

          (rxfhd = (MBHEAD *)allocb(ALLOC_MBHEAD))->l2port = ax25ip_port;
          for (i = 0; i < l; i++)
             putchr(buf[i], rxfhd); /* Buffer umkopieren */

          relink((LEHEAD *)rxfhd, (LEHEAD *)rxfl.tail);
       }
    }
  }
}


/*************************************************************************/
static void ax25ip_send(void)
{
  char           buf[MAX_FRAME];
  int            len = 0;
  MBHEAD        *txfhdl;
  unsigned char *targetip;
  unsigned char *call;

  if (kick[ax25ip_port]) { /* haben wir was zu senden ? */
     ulink((LEHEAD *)(txfhdl = (MBHEAD *) l2flp->head));/*Zeiger holen*/

     while (txfhdl->mbgc < txfhdl->mbpc) /* solange Daten vorhanden sind */
        buf[len++] = getchr(txfhdl);

     relink((LEHEAD *)txfhdl,          /* als gesendet betrachten und in */
            (LEHEAD *)stfl.tail);      /* die gesendet Liste umhaengen   */

     kick[ax25ip_port] = ((LHEAD *)l2flp->head != l2flp);

     call = next_addr(buf);

     targetip = call_to_ip(call);

     if (targetip == NULL) { /* wir kennen Ziel nicht */
        LOGL2("unknown Target-IP-Adress %s", call_to_a(call));
       return;
     }

     add_ax25crc(buf, len);

     len = len + 2; /* die CRC ist dazugekommen */

     memcpy((char *) &to.sin_addr, targetip, 4);
     memcpy((char *) &to.sin_port, &targetip[4], 2);
     to.sin_family = AF_INET;

     /* UDP-Mode */
     if (mode == UDP_MODE) {
       if (to.sin_port) {
         if (sendto(l1pp->kisslink, (char *)buf, len, 0,
                   (struct sockaddr *)&to, sizeof(to)) < 0) {
            LOGL2("error sendto_UDP(l1pp->kisslink)");
            return;
         }
       }
     }

     /* IP-Mode */
     if (mode == IP_MODE) {
       if (sendto(l1pp->kisslink, (char *)buf, len, 0,
                 (struct sockaddr *)&to, sizeof(to)) < 0) {
          LOGL2("error sendto_IP(l1pp->kisslink)");
          return;
       }
     }
   }
}


/*************************************************************************/
void ax25ip_l1exit(void)
{
  if (ax25ip_active == FALSE)
    return;
  close(l1pp->kisslink);
  ax25ip_active = FALSE;
  l1pp->kisslink = -1;
}


void ax25ip_l1ctl(int req, int port)
{
}

void ax25ip_hwstr(int port, MBHEAD *mbp)
{
}

BOOLEAN ax25ip_dcd(int port)
{
  return(FALSE);
}


/* routing.c    Routing table manipulation routines
 *
 * Copyright 1991, Michael Westerhof, Sun Microsystems, Inc.
 * This software may be freely used, distributed, or modified, providing
 * this header is not removed.
 *
 */



/* Initialize the routing table */
void route_init(void)
{
   default_route.callsign[0] = '\0';    /* set to non-zero if valid */
}

/* Add a new route entry */
static void route_add(unsigned char *ip, unsigned char *call, int udpport,
                      int default_rt)
{
   int i = 0;

   if (ip == NULL) return;

   if (default_rt) {
      for (i = 1; i < 7 ;i++)
        default_route.callsign[i] = 0;
      default_route.padcall = 0;
      (void)memcpy(default_route.ip_addr, ip, 4);
      default_route.udp_port = htons(udpport);
      default_route.pad1 = 0;
      default_route.pad2 = 0;
      default_route.callsign[0] = 1;            /* mark valid */
      return;
   }

   if (call == NULL) return;

   if (route_tbl_top >= TABLE_SIZE) {
      xprintf("Routing table is full; entry ignored.\n");
      LOGL2("Routing table is full; entry ignored");
   }

   for (i = 0; i < 6; i++)
     route_tbl[route_tbl_top].callsign[i] = call[i] & 0xfe;

   route_tbl[route_tbl_top].callsign[6] = (call[6] & 0x1e) | 0x60;
   route_tbl[route_tbl_top].padcall = 0;
   (void)memcpy(route_tbl[route_tbl_top].ip_addr, ip, 4);
   route_tbl[route_tbl_top].udp_port = htons(udpport);
   route_tbl[route_tbl_top].pad1 = 0;
   route_tbl[route_tbl_top].pad2 = 0;
   route_tbl_top++;
   return;
}

/*
 * Return an IP address and port number given a callsign.
 * We return a pointer to the address; the port number can be found
 * immediately following the IP address. (UGLY coding; to be fixed later!)
 */

unsigned char *call_to_ip(unsigned char *call)
{
   int i = 0;
   unsigned char mycall[7];

   if (call == NULL) {
      return(NULL);
   }

   for (i = 0; i < 6; i++)
     mycall[i] = call[i] & 0xfe;

   mycall[6] = (call[6] & 0x1e) | 0x60;

   for (i = 0; i < route_tbl_top; i++) {
      if (addrmatch(mycall , route_tbl[i].callsign)) {
         return(route_tbl[i].ip_addr);
      }
   }

   if (default_route.callsign[0]) {
      return(default_route.ip_addr);
   }

   return(NULL);
}

/*
 * tack on the CRC for the frame.  Note we assume the buffer is long
 * enough to have the two bytes tacked on.
 */
void add_ax25crc(unsigned char *buf, int l)
{
   unsigned short int u = 0;

   u = compute_crc(buf, l);
   buf[l] = u & 0xff;              /* lsb first */
   buf[l + 1] = (u >> 8) & 0xff;   /* msb next */
}


/*
 **********************************************************************
 * The following code was taken from Appendix B of RFC 1171
 * (Point-to-Point Protocol)
 *
 * The RFC credits the following sources for this implementation:
 *
 *   Perez, "Byte-wise CRC Calculations", IEEE Micro, June, 1983.
 *
 *   Morse, G., "Calculating CRC's by Bits and Bytes", Byte,
 *   September 1986.
 *
 *   LeVan, J., "A Fast CRC", Byte, November 1987.
 *
 *
 * The HDLC polynomial: x**0 + x**5 + x**12 + x**16
 */

/*
 * u16 represents an unsigned 16-bit number.  Adjust the typedef for
 * your hardware.
 */
typedef unsigned short u16;


/*
 * FCS lookup table as calculated by the table generator in section 2.
 */
static u16 fcstab[256] = {
   0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf,
   0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7,
   0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e,
   0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876,
   0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd,
   0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5,
   0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c,
   0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974,
   0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb,
   0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3,
   0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
   0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72,
   0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9,
   0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1,
   0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738,
   0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70,
   0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7,
   0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff,
   0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036,
   0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e,
   0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5,
   0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
   0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134,
   0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c,
   0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3,
   0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb,
   0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232,
   0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a,
   0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1,
   0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9,
   0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330,
   0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78
};

#define PPPINITFCS      0xffff  /* Initial FCS value */
#define PPPGOODFCS      0xf0b8  /* Good final FCS value */

/*
 * Calculate a new fcs given the current fcs and the new data.
 */
u16 pppfcs(register u16, register unsigned char *, register int);

u16 pppfcs(fcs, cp, len)
    register u16 fcs;
    register unsigned char *cp;
    register int len;
{

    while (len--)
       fcs = (fcs >> 8) ^ fcstab[(fcs ^ *cp++) & 0xff];

    return(fcs);
}

/*
 * End code from Appendix B of RFC 1171
 **********************************************************************
 */

/*
 *  The following routines are simply convenience routines...
 *  I'll merge them into the mainline code when suitably debugged
 */

/* Return the computed CRC */
unsigned short int compute_crc(unsigned char *buf, int l)
{
   int fcs = 0;

   fcs = PPPINITFCS;
   fcs = pppfcs(fcs, buf, l);
   fcs ^= 0xffff;
   return(fcs);
}

/* Return true if the CRC is correct */
int ok_crc(unsigned char *buf, int l)
{
   int fcs = 0;

   fcs = PPPINITFCS;
   fcs = pppfcs(fcs, buf, l);
   return(fcs == PPPGOODFCS);
}

/* return true if the addresses supplied match */
int addrmatch(unsigned char *a, unsigned char *b)
{
   if ((*a == '\0') || (*b == '\0')) return(0);

   if ((*a++ ^ *b++) & 0xfe) return(0);   /* "K" */
   if ((*a++ ^ *b++) & 0xfe) return(0);   /* "A" */
   if ((*a++ ^ *b++) & 0xfe) return(0);   /* "9" */
   if ((*a++ ^ *b++) & 0xfe) return(0);   /* "W" */
   if ((*a++ ^ *b++) & 0xfe) return(0);   /* "S" */
   if ((*a++ ^ *b++) & 0xfe) return(0);   /* "B" */
   if ((*a++ ^ *b++) & 0x1e) return(0);   /* ssid */
   return(1);
}

/* return pointer to the next station to get this packet */
unsigned char *next_addr(unsigned char *f)
{
   unsigned char *a;

   /* If no digis, return the destination address */
   if (NO_DIGIS(f)) return(f);

   /* check each digi field.  The first one that hasn't seen it is the one */
   a = f + 7;
   do {
      a += 7;
      if (NOTREPEATED(a)) return(a);
   } while (NOT_LAST(a));

/* all the digis have seen it.  return the destination address */
   return(f);
}

/* Open and read the config file */
int config_read(void)
{
   FILE *cf;
   char buf[256], cbuf[256];
   int errflag = 0;
   int e = 0;
   int lineno = 0;
   char cfgfile[256];

   strcpy(cfgfile, confpath);
   strcat(cfgfile, CONFIG_FILE);

   if ((cf = fopen(cfgfile, "r")) == NULL)
   {
#ifdef INIPATH
     strcpy(cfgfile, INIPATH);
     strcat(cfgfile, CONFIG_FILE);

     if ((cf = fopen(cfgfile, "r")) == NULL)
     {
#endif
        xprintf("Config file %s not found or could not be opened\n",
                CONFIG_FILE);
        return(FALSE);
#ifdef INIPATH
     }
#endif
   }

   while (fgets(buf, 255, cf) != NULL) {
      (void)strcpy(cbuf, buf);
      lineno++;
      if ((e = parse_line(buf)) < 0) {
         xprintf("Config error at line %d: ", lineno);
            if (e == -1) xprintf("Missing argument\n");
            else if (e == -2) xprintf("Bad callsign format\n");
            else if (e == -3) xprintf("Bad option - on/off\n");
            else if (e == -4) xprintf("Bad option - tnc/digi\n");
            else if (e == -5) xprintf("Host not known\n");
            else if (e == -6) xprintf("Unknown command\n");
            else if (e == -7) xprintf("Text string too long\n");
            else if (e == -8) xprintf("Bad option - every/after\n");
            else if (e == -9) xprintf("Bad option - ip/udp\n");
            else xprintf("Unknown error\n");
            xprintf("%s", cbuf);
            errflag++;
        }
    }
    if (errflag) exit(1);

    if (mode == NO_MODE) {
       xprintf("Must specify ip and/or udp sockets\n");
       return(FALSE);
    }

   return(TRUE);

}


/* Process each line from the config file.  The return value is encoded. */
int parse_line(char *buf)
{
   char *p, *q;
   unsigned char tcall[7], tip[4];
   struct hostent *he;
   int i = 0;
   int j = 0;
   int uport = 0;
   int dfalt = 0;

   p = strtok(buf, " \t\n\r");

   if (p == NULL) return(0);
   if (*p == '#') return(0);

   if (strcmp(p, "socket") == 0)
   {
     q = strtok(NULL, " \t\n\r");
     if (q == NULL) return(-1);

     if (strcmp(q, "ip") == 0)
     {
        mode = IP_MODE;
     }
     else if (strcmp(q, "udp") == 0)
     {
        mode = UDP_MODE;
        my_udp = htons(DEFAULT_UDP_PORT);
        q = strtok(NULL, " \t\n\r");

        if (q != NULL)
        {
           i = atoi(q);
           if (i > 0) my_udp = htons(i);
        }
     }
     else return(-9);
     return(0);

   }
   else if (strcmp(p, "socketoption") == 0)
     {
       q = strtok(NULL, " \t\n\r");
       if (q == NULL)
         return(-1);

       if (strcmp(q, "SO_KEEPALIVE") == 0)
       {
          sockopt_keepalive = TRUE;
       }
       else if (strcmp(q, "IPTOS_THROUGHPUT") == 0)
       {
          sockopt_throughput = TRUE;
       }
       else return(-9);

     return(0);

    } else if (strcmp(p, "loglevel") == 0) {
      q = strtok(NULL, " \t\n\r");
      if (q == NULL) return(-1);
      loglevel = atoi(q);
      return(0);

   } else if (strcmp(p, "route") == 0) {
      uport = 0;
      dfalt = 0;

      q = strtok(NULL, " \t\n\r");
      if (q == NULL) return(-1);
      if (strcmp(q, "default") == 0) dfalt = 1;
      else {
         if (a_to_call(q, tcall) != 0) return(-2);
      }

      q = strtok(NULL, " \t\n\r");
      if (q == NULL) return(-1);
      he = gethostbyname(q);
      if (he != NULL) {
        (void)memcpy(tip, he->h_addr_list[0], 4);
      } else {                  /* maybe user specified a numeric addr? */
         j = inet_addr(q);
         if (j == -1) return(-5);  /* if -1, bad deal!                    */
         (void)memcpy(tip, (char *)&j, 4);
      }

      q = strtok(NULL, " \t\n\r");
      if (q != NULL) {
         if (strcmp(q, "udp") == 0) {
            uport = DEFAULT_UDP_PORT;
            q = strtok(NULL, " \t\n\r");
            if (q != NULL) {
              i = atoi(q);
              if (i > 0) uport = i;
            }
         }
      }

      route_add(tip, tcall, uport, dfalt);
      return(0);
   }
   return(-999);
}


/* Convert ascii callsign to internal format */
int a_to_call(char *text, unsigned char *tcall)
{
   int           i = 0;
   int           ssid = 0;
   unsigned char c;

   if (strlen(text) == 0) return(-1);

   for (i = 0; i < 6; i++) {
      tcall[i] = (' ' << 1);
   }
   tcall[6] = '\0';

   for (i = 0; i < strlen(text); i++) {
      c = text[i];
      if (c == '-') {
         ssid = atoi(&text[i + 1]);
         if (ssid > 15) return(-1);
         tcall[6] = (ssid << 1);
         return(0);
      }
      if (islower(c)) c = toupper(c);
      if (i > 5) return(-1);
      tcall[i] = (c << 1);
   }
   return(0);
}

/* Convert internal callsign to printable format */
char *call_to_a(unsigned char *tcall)
{
   int i = 0;
   int ssid = 0;
   char *tptr;
   static char t[10];

   for (i = 0, tptr = t; i < 6; i++) {
      if (tcall[i] == (' ' << 1)) break;
      *tptr = tcall[i] >> 1;
      tptr++;
   }

   ssid = (tcall[6] >> 1) & 0x0f;
   if (ssid > 0) {
      *tptr = '-';
      tptr++;
      if (ssid > 9) {
         *tptr = '1';
         tptr++;
         ssid -= 10;
      }
   *tptr = '0' + ssid;
   tptr++;
   }

   *tptr = '\0';
   return(&t[0]);
}


void write_log(const char *format, ...)
{
  FILE *fp;
  va_list arg_ptr;
  struct tm *lt;

  fp = fopen("ax25ip.log", "a+");

   if (fp != NULL) {
     lt = localtime(&sys_time);
     fprintf(fp, "%16.16s:", ctime(&sys_time));
     va_start(arg_ptr, format);
     vfprintf(fp, format, arg_ptr);
     va_end(arg_ptr);
     fprintf(fp, "\n");
     fclose(fp);
  }
}

#endif

/* End of os/linux/ax25ip.c */
