/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/l7cmds.c (maintained by: ???)                               */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2003 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

#ifdef ALIASCMD
CMDALIAS *aliaslist;
#endif


static void put_pcnf(WORD, MBHEAD *);

#ifdef ALIASCMD
/************************************************************************/
/* alias-management                                                     */
/*----------------------------------------------------------------------*/
void ccpalias(void)
{
  int i;
  char aliastmp[MAXALIASLEN + 1];
  CMDALIAS *ap = aliaslist, *ap2;
  MBHEAD *mbp;

  if (issyso())       /* only Sysop may use this */
  {
    mbp = putals("");

    if (clicnt == 0) /* no parameters given, then show all aliasses*/
    {
      if (ap != NULL)
      {
        /* print all elements in the list */
        putstr("Currently defined aliasses:\r", mbp);

        for ( ; ap != NULL; ap = ap->next)
          putprintf(mbp, "%s -> %s\r", ap->alias, ap->cmd);

      }
      else
        putstr("No aliasses defined\r", mbp);
    }
    else  /* handling if called with parameters */
    {
      /* read alias first */
      i = 0;
      while (clicnt > 0 && *clipoi != ' ' && i < MAXALIASLEN)
      {
        aliastmp[i++] = toupper(*clipoi++);
        clicnt--;
      }
      aliastmp[i] = '\0';

      /* check its length */
      if (clicnt > 0 && *clipoi != ' ')
      {
        putprintf(mbp, "Alias too long, max. %u characters.\r", MAXALIASLEN);
        prompt(mbp);
        seteom(mbp);
        return;
      }

      for (ap2 = NULL ; ap != NULL; ap = ap->next)
      {
        if (!strcmp(aliastmp, ap->alias))     /* aendern */
          break;

        ap2 = ap;
      }

      /* are there any more characters ? */
      if (skipsp(&clicnt, &clipoi))
      {
        if (clicnt > MAXALIASCMDLEN)
        {
          putprintf(mbp, "Command too long, max. %u characters.\r", MAXALIASCMDLEN);
          prompt(mbp);
          seteom(mbp);
          return;
        }

        /*strupr(clipoi); wenns denn unbedingt noetig ist */

        if (ap != NULL)     /* aendern */
        {
          strcpy(ap->cmd, clipoi);
          putstr("Alias stored.\r", mbp);
          prompt(mbp);
          seteom(mbp);
          return;
        }

        /* nicht gefunden, also neu */
        ap = (CMDALIAS *)calloc(1, sizeof(CMDALIAS));
        if (ap == NULL)
        {
          putstr("Can't store, no memory.\r", mbp);
          prompt(mbp);
          seteom(mbp);
          return;
        }

        strcpy(ap->alias, aliastmp);
        strcpy(ap->cmd, clipoi);
        if (aliaslist == NULL)     /* erster Eintrag */
          aliaslist = ap;
        else                       /* in Liste */
          ap2->next = ap;

        putstr("Alias stored.\r", mbp);
      }
      else /* no more parameters than alias-name */
      {
        if (ap != NULL)           /* loeschen */
        {
          if (ap == aliaslist)
            aliaslist = ap->next;
          else
            ap2->next = ap->next;

          free(ap);

          putstr("Alias deleted.\r", mbp);
          prompt(mbp);
          seteom(mbp);
          return;
        }

        /* no match */
        putstr("No such alias defined, can't delete.\r", mbp);
      }
    }
    prompt(mbp);
    seteom(mbp);
  }
  else
    invmsg();
}
#endif

/************************************************************************/
/* Programm starten                                                     */
/*----------------------------------------------------------------------*/
void ccpstart(void)
{
  if (issyso()) {
    tnnexec((char *)clipoi);
#ifndef MC68302                     /* da gibs mehrere Fehlermeldungen */
    putmsg("Invalid program!\r");
#endif
  }
}

/************************************************************************/
/* Parameter anzeigen/aendern                                           */
/*----------------------------------------------------------------------*/
void ccppar(void)
{
  ccp_par("Parms:\r", partab, partablen);
}

/**************************************************************************/
/* RESET                                                                  */
/*------------------------------------------------------------------------*/
void ccpres(void)
{
  MBHEAD *mbp;
  WORD    port;

  if (issyso()) {
    if (strnicmp((char *)clipoi,"SYSTEM",6) == 0)
      HALT("sysop");
    if (getport(&clicnt, &clipoi, &port)) {
      mbp = putals("RESET Port ");
      putnum(port, mbp);
      putchr('\r', mbp);
      prompt(mbp);
      seteom(mbp);
      l1ctl(L1CRES, port);
    } else
      putmsg("Invalid Port!\r");
  } else
    invmsg();
}

/************************************************************************/
/* PROMPT                                                               */
/*----------------------------------------------------------------------*/
void ccpprompt(void)
{
  MBHEAD *mbp;
  WORD i;

  if (issyso() && *clipoi == '=') {
    if (clicnt > 0)
    {
      clicnt--;
      clipoi++;
    }
    for (i = 0; i < 79 && clicnt--; promptstr[i++] = *clipoi++);
    promptstr[i] = 0;
  }
  mbp = putals("Prompt: ");
  putstr(promptstr, mbp);
  putchr('\r', mbp);
  prompt(mbp);
  seteom(mbp);
}

#ifdef MC68302
/************************************************************************/
/* DELETE - Befehl (Dateien loeschen)                                   */
/*----------------------------------------------------------------------*/
void ccpdelete(void)
{
  MBHEAD *mbp;
  char file[128];

  if (issyso()) {
    strcpy(file, clipoi);
    mbp = putals(file);
    if (remove(file))
      putstr(" not deleted!\r", mbp);
    else
    {
      compact();
      putstr(" deleted.\r", mbp);
    }
    prompt(mbp);
    seteom(mbp);
  }
  else
    invmsg();
}

/************************************************************************/
/* ccpcopy                                                              */
/************************************************************************/
void ccpcopy(void)
{
  FILE *f1;
  FILE *f2;
  size_t n;
  char buf[512];
  char buf2[40];
  char file1[80];
  char file2[80];
  MBHEAD *mbp;

  if (issyso())
  {
    if (clicnt > 0)
    {
      skipsp(&clicnt, &clipoi);
      *file1 = *file2 = '\0';
      sscanf(clipoi, "%s %s", file1, file2);

      if (*file1 && *file2)
      {
        mbp = getmbp();
        strcpy(buf2, "OK\r");
        if ((f1 = fopen(file1, "rb")) != NULL)
        {
          if ((f2 = fopen(file2, "wb")) != NULL)
          {
            while ((n = fread(buf, 1, 512, f1)) > 0)
            {
              if (fwrite(buf, 1, n, f2) != n)
              {
                strcpy(buf2, "write error !\r");
                remove(file2);
                break;
              }
            }
            fclose(f1);
            fclose(f2);
            compact();
          }
          else
          {
            sprintf(buf2, "can't create %s !\r", file2);
          }
        }
        else
        {
          sprintf(buf2, "can't open %s !\r", file1);
        }
        putstr(buf2, mbp);
        prompt(mbp);
        seteom(mbp);
      }
    }
  }
  else
    invmsg();
}

/************************************************************************/
/* ccpdir                                                               */
/************************************************************************/
void ccpdir(void)
{
  char file[128];
  MBHEAD *mbp;
  struct ffblk fblock;
  int lastentry;
  struct tm *ftime;
  int einfach, cnt;

  einfach = FALSE;
  if (userpo->sysflg != 0) {            /* Benutzer ist Sysop           */
    strcpy(file, textpath);             /* Verzeichnis der Texte        */
    if (clicnt > 0) {                   /* Parameter folgen             */
      skipsp(&clicnt, &clipoi);         /* Nachfolgende Leerzeichen     */
      if (strncmp(strlwr(clipoi), "/w", 2) == 0) { /* Einfache Ausgabe  */
      nextspace(&clicnt, &clipoi);
      skipsp(&clicnt, &clipoi);         /* Nachfolgende Leerzeichen     */
      if (clicnt > 0)                   /* vorhandene Dateimaske        */
        strcat(file, clipoi);           /* an Pfad dranhaengen          */
      else                              /* sonst:                       */
        strcat(file, "*.*");            /* alles auswaehlen             */
      einfach = TRUE;
      }
      else {
        strcat(file, clipoi);
      }
    }
    else {
      strcat(file,"*.*");
    }
    mbp = getmbp();
    cnt = 0;
    lastentry = findfirst(file, &fblock, 0);
    while (!lastentry) {
      if (einfach) {
        putprintf(mbp,"%15s", fblock.ff_name);
        if (++cnt == 5) {
          putchr('\r', mbp);
          cnt = 0;
        }
      } else {
        ftime = localtime(&fblock.ff_ftime);
        putprintf(mbp,"%12s %8ld Bytes  %2.2d.%02d.%02d %2.2d:%02d:%02d\r",
            fblock.ff_name, fblock.ff_fsize,
            ftime->tm_mday, (ftime->tm_mon)+1, ftime->tm_year%100,
            ftime->tm_hour, ftime->tm_min, ftime->tm_sec);
      }
      lastentry = findnext(&fblock);
    }
    if (einfach) putstr("\r", mbp);
    compact();
    putprintf(mbp,"%lu Bytes free\r", coreleft());
    prompt(mbp);
    seteom(mbp);
  }
  else
    invmsg();
}
#endif

#ifndef MC68302
/************************************************************************/
/* SHELL/DOS/TOS                                                        */
/*----------------------------------------------------------------------*/
void ccpshell(void)
{
  char sysline[MAXPATH+1];

  if (issyso())                         /* darf nur ein Sysop           */
  {
    strncpy(sysline, (char *)clipoi, MAXPATH);
    sysline[MAXPATH] = 0;
    if (tnnshell(sysline) == TRUE) return;      /* und ausfuehren       */
    /* tnnshell() liefert in sysline den Namen der temporaeren Datei,   */
    /* die die Ausgabe der Shell enthaelt.                              */
    if (*sysline) {
      userpo->fname = strdup(sysline);
      ccpread(sysline);                 /* Ergebnis dem User sagen      */
    }
    else
      invmsg();
  }
  else
    invmsg();
}
#endif

/* Commandotabelle fuer die Porteinstellung, alles was hier nicht erscheint,
   wird als Geraetename interpretiert und an l1attach() uebergeben. */
#define PO_DETACH 1
#define PO_NAME   2
#define PO_TXD    3
#define PO_MODE   4
#define PO_MAXF   5
#define PO_CTEXT  6
#define PO_SYSOP  7
#define PO_MH     8
#define PO_DAMA   9
#define PO_MAXC  10
#define PO_TAIL  11
#define PO_EAXMF 12
#define PO_EAXBH 13

PORTCMD portcmd[] = {    /* nicht aktivierte Pars werden ueberlesen */
  {"OFF",             PO_DETACH },
  {"NAME",            PO_NAME   },
  {"TXDELAY",         PO_TXD    },
  {"MODE",            PO_MODE   },
  {"MAXFRAME",        PO_MAXF   },
  {"CTEXT",           PO_CTEXT  },
  {"SYSOP",           PO_SYSOP  },
  {"MH",              PO_MH     },
  {"DAMA",            PO_DAMA   },
  {"MAXCON",          PO_MAXC   },
  {"TAILTIME",        PO_TAIL   },
  {"EAXMAXFR",        PO_EAXMF  },
  {"EAXMODE",         PO_EAXBH  },
  {NULL,              0         }
};

/************************************************************************/
/*                                                                      */
/*----------------------------------------------------------------------*/
#ifdef MC68302
void hsbus_stat(MBHEAD *);
#endif

void
ccpport(void)
{
  MBHEAD    *mbp;                       /* message-buffer-pointer       */
  WORD       port;                      /* Port-Nummer (0..L2PNUM-1)    */
  char       buf[80];
  PORTCMD   *pc;
  char      *bps;
  WORD       bcs, found;
  ULONG      lbaud;
  L1MODETAB *mtp;
  PORTINFO  *p;
  WORD       begport = 0;
  WORD       endport = L2PNUM - 1;

  skipsp(&clicnt, &clipoi);

  if (*clipoi == '*' || *clipoi == '+')    /* Ausgabe der Autoparameter */
  {
    mbp = putals("Port Parameters:\r");
    putstr("              TX-                  Max-  L2-         ", mbp);
#ifdef SETTAILTIME
    putstr("  Tail", mbp);
#endif
#ifdef USERMAXCON
    putstr(" Max", mbp);
#endif
#ifdef EAX25
    putstr(" EAX- EAX-", mbp);
#endif
    putstr("\r"
           "-#-Port-------Delay-Pers-Slot-IRTT-Frame-Retry-Timer2", mbp);
#ifdef SETTAILTIME
    putstr("--Time", mbp);
#endif
#ifdef USERMAXCON
    putstr("-Con", mbp);
#endif
#ifdef EAX25
    putstr("-MaxF-Mode", mbp);
#endif
    putchr(CR, mbp);

    for (port = 0, p = portpar; port < L2PNUM; p++, port++)
    {
      if (!portenabled(port))
        continue;
      putprintf(mbp, "%2u:%-10s  %3u   %3u %3u  %4u   "
                     "%1u%c    %2u   %4u ",
                     port,
                     p->name,
                     p->txdelay,
                     p->persistance,
                     p->slottime,
                     p->IRTT,
                     p->maxframe,
                     automaxframe(port) ? 'a' : ' ',
                     p->retry,
                     p->T2);
#ifdef SETTAILTIME
      putprintf(mbp, " %5u", p->tailtime);
#endif
#ifdef USERMAXCON
      putprintf(mbp, "  %2u", p->maxcon);
#endif
#ifdef EAX25
      putprintf(mbp, "  %2u   %2u", p->maxframe_eax, p->eax_behaviour);
#endif
      putchr(CR, mbp);
    }
    prompt(mbp);
    seteom(mbp);
    return;
  }
#ifdef MC68302
  if (*clipoi == '?')       /* Ausgabe der Inquiry (vorerst nur hskiss) */
  {
    mbp = putals("Port-Inquiry:\r"
                 "Po. Software-Version                 TxD "
                 "Per Slt  Tail Dup DAMA    Baud Duo\r");
    hsbus_stat(mbp);
    prompt(mbp);
    seteom(mbp);
    return;
  }
#endif

  if (issyso() && clicnt)
  {
    port = nxtnum(&clicnt, &clipoi);
    if (port >= 0 && port < L2PNUM && skipsp(&clicnt, &clipoi))
    {
      p = &portpar[port];
      l1ctl(L1CCMD, port);                      /* HB9PAE/DB7KG         */
      do
      {
        *buf = NUL;
        bps = buf;
        if (skipsp(&clicnt, &clipoi))
        {
          while (*clipoi && isalnum(*clipoi))
          {
            *bps++ = toupper(*clipoi++);
            --clicnt;
          }
          *bps = NUL;
        }
        if (!*buf)
        {
          clicnt = 0;
          break;
        }
        bcs = (WORD)strlen(buf);

        for (pc = portcmd, found = 0;
             !found && pc->cmdstr != NULL;
             ++pc)
        {
          if (!strncmp(pc->cmdstr, buf, (size_t)bcs))
            found = pc->cmdpar;
        }

        if (found)
        {
          switch (found)
          {
            case PO_DETACH:
              l1detach(port);
              break;

            case PO_NAME:
              if (clicnt > 1)
              {
                clipoi++;
                clicnt--;
                if (sscanf((char *) clipoi,"%10s", buf) == 1)
                {
                  strcpy(p->name, buf);
                  bcs = (WORD)strlen(buf);
                  clipoi += bcs;
                  clicnt -= bcs;
                }
              }
              break;

            case PO_TXD:
              p->txdelay = getparam(&clicnt, &clipoi, 0, 255, 25);
              l1ctl(L1CCMD, port);
              autopar(port);
              break;

            case PO_MODE:
              if (clicnt > 1)
              {
                clipoi++;
                clicnt--;
                *buf = 0;

                if (isdigit(*clipoi))
                {
                  lbaud = nxtlong(&clicnt, &clipoi);
                  if (lbaud > 4915200L)
                    p->speed = 49152U;
                  else if (lbaud < 300L)
                    p->speed = 3;
                  else
                    p->speed = (UWORD) (lbaud/100L);
                }

                *buf = 0;
                if (*clipoi && *clipoi != ' ')
                {
                  sscanf((char *) clipoi,"%8s", buf);
                  strlwr(buf);
                  nextspace(&clicnt, &clipoi);
                }
                CLR_L1MODE(port);
                for (mtp = l1modetab; mtp->ch; mtp++)
                  if (strchr(buf, mtp->ch))
                    SET_L1MODE(port, mtp->mode);

                l1ctl(L1CCMD, port);
              }
              break;

            case PO_MAXF:
              if (clicnt > 1)
              {
                p->maxframe = getparam(&clicnt, &clipoi, 1, 7, 2);
                if (clicnt != 0 && toupper(*clipoi) == 'A')
                  p->l2mode |= MODE_am;
                else
                  p->l2mode &= ~MODE_am;
                nextspace(&clicnt, &clipoi);
              }
              break;

            case PO_CTEXT:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_x;
              else
                p->l2mode &= ~MODE_x;
              break;

            case PO_SYSOP:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_s;
              else
                p->l2mode &= ~MODE_s;
              break;

            case PO_MH:
              if (getparam(&clicnt, &clipoi, 0, 1, 0))
                p->l2mode |= MODE_h;
              else
                p->l2mode &= ~MODE_h;
              break;

            case PO_DAMA:
/* Es darf nur auf DAMA-Master oder DAMA-Slave geschaltet werden.       */
/* DAMA-Slave wird mit "DAMA S" (oder "DAMA=S") gewaehlt.               */
              if (clicnt > 1 && toupper(clipoi[1]) == 'S')
              {
                clipoi++;
                clicnt--;
#ifdef DAMASLAVE
                p->l2mode |= MODE_ds;           /* DAMA-Slave ON        */
                p->dch = DAMA_CH;               /* DAMA-Master OFF      */
                p->l2mode &= ~MODE_a;
#endif
                nextspace(&clicnt, &clipoi);
                break;
              }
#ifdef DAMASLAVE
              p->l2mode &= ~MODE_ds;            /* DAMA-Slave OFF       */
#endif
              p->dch = getparam(&clicnt, &clipoi, 0, DAMA_CH, DAMA_CH);
              if (p->dch > 0)
              {
                p->dch -= 1;
                p->l2mode |= MODE_a;
              }
              else
              {
                p->dch = DAMA_CH;
                p->l2mode &= ~MODE_a;
              }
              break;

            case PO_MAXC:
#ifdef USERMAXCON
              p->maxcon = getparam(&clicnt, &clipoi, 0, 15, 0);
#else
              nextspace(&clicnt, &clipoi);
#endif
              break;

            case PO_TAIL:
#ifdef SETTAILTIME
              p->tailtime = getparam(&clicnt, &clipoi, 0, 32700, TAILTIME);
              l1ctl(L1CCMD, port);
#else
              nextspace(&clicnt, &clipoi);
#endif
              break;

            case PO_EAXMF:
#ifdef EAX25
              p->maxframe_eax = getparam(&clicnt, &clipoi, 1, 32, 16);
#else
              nextspace(&clicnt, &clipoi);
#endif
              break;

            case PO_EAXBH:
#ifdef EAX25
              p->eax_behaviour = getparam(&clicnt, &clipoi, 0, 2, 1);
#else
              nextspace(&clicnt, &clipoi);
#endif
              break;
          } /* switch */
        }   /* if     */
        else
          l1attach(port, buf);
      } while (clicnt > 0);
      autopar(begport = endport = port);       /* Auto-Parameter setzen */
    }
  }

  mbp = putals("Link-Interface Ports:\r");     /* Konfiguration zeigen  */
  putstr("-#-Name----------Speed/Mode-Max-TXD-DA"
         "----------------Hardware--\r", mbp);
  for (port = begport; port <= endport; port++)
    put_pcnf(port, mbp);
  prompt(mbp);
  seteom(mbp);
}

/*----------------------------------------------------------------------*/
static void
put_pcnf(WORD port, MBHEAD *mbp)
{
  char          mode[16], *cp;
  ULONG         baud;
  L1MODETAB    *mtp;
  PORTINFO     *p = &portpar[port];

  if (!portenabled(port))
    return;

  putprintf(mbp, "%2d %-10s", port, p->name);

  cp = mode;
  for (mtp = l1modetab; mtp->ch; mtp++)
    if (p->l1mode & mtp->mode)
      *cp++ = mtp->ch;
  *cp = 0;

  baud = ((ULONG)p->speed) * 100L;
  putprintf(mbp, " %8lu%-5s  %1u%c %3u ", baud, mode, p->maxframe,
                 automaxframe(port) ? 'a' : ' ', p->txdelay);

#ifdef DAMASLAVE
  if ((p->l2mode & MODE_ds) || (p->l2mode & MODE_a))
  {
    if (p->l2mode & MODE_ds)
      putstr(" s ", mbp);
    else
      if (p->l2mode & MODE_a)
        putprintf(mbp, "%2u ", p->dch + 1);
  }
#else
  if (p->l2mode & MODE_a)
    putprintf(mbp, "%2u ", p->dch + 1);
#endif
  else
    putstr("   ", mbp);
  putstr(p->l2mode & MODE_x ? "CTEXT " : "      ", mbp);
  putstr(p->l2mode & MODE_s ? "SYSOP " : "      ", mbp);
  putstr(p->l2mode & MODE_h ? "MH "    : "   ",    mbp);

  l1hwstr(port, mbp);
  putchr(CR, mbp);
}

/************************************************************************/
/* HELP                                                                 */
/*----------------------------------------------------------------------*/
void ccphelp(void)                              /* HELP - Befehl        */
{
  struct ffblk fb;
  char tmp[9];
  MBHEAD *mbp;
  char file[80];
  char *cp;
  WORD i,j;
  WORD next = 0;
  WORD       cnt;
  char      *poi;
#ifndef MC68K
  BOOLEAN found = FALSE;
#endif

  poi = clipoi;
  cnt = clicnt;

  clipoi = clilin;
  clicnt = strlen(clilin);

#ifndef MC68K
  if (issyso())                /* HELP.EXE fuer Sysops (OHS) suchen        */
    found = !do_file(sysopexepath);
  if (!found)                  /* HELP.EXE fuer User (OHU) suchen          */
    found = !do_file(userexepath);

  if (found)                   /* wenn es HELP.EXE gibt, sind wir fertig   */
    return;
#endif

  clipoi = poi;                /* die alte Hilfe                           */
  clicnt = cnt;

  if (clicnt == 0)             /* Kein Argument angegegen, kurzer HELP.TXT */
  {
    strcpy(file,textpath);
    strcat(file,"HELP.TXT");
    ccpread(file);
  }
  else
  {
    if (strnicmp((char *)clipoi, "INDEX", 5) == 0) /* Hilfe-Index ausgeben */
    {
      mbp = putals("HELP - Index:\r");
      strcpy (file,textpath);
      strcat (file,"*.HLP");
      if (xfindfirst(file, &fb, 0) == 0)
      {
        while (next == 0)
        {
          for (i = 0; i < 7; i++)
          {
            for (cp = fb.ff_name, j = 0; j < 8 && *cp != '.'; cp++, j++)
            {
              tmp[j] = *cp;
            }
            tmp[j] = '\0';
            putstr(tmp, mbp);
            for ( ; j < 10; j++)
              putchr(' ', mbp);
            if ((next = xfindnext(&fb)) != 0)
              break;
          }
          putchr('\r', mbp);
        }
      }

      prompt(mbp);
      seteom(mbp);
    }
    else
    { /* HILFE-Info fuer angegebenen Befehl suchen und ausgeben */

      for (cp = tmp, i = 0; clicnt-- && i < 8 && isalnum(*clipoi); ++i)
        *cp++ = (char) toupper(*clipoi++);
      if (i < 8)
        *cp++ = '*';
      *cp = '\0';

      if (userpo->sysflg != 0)
      {
        sprintf(file, "%s%s.SLP", textpath, tmp);
        if (i && !xfindfirst(file, &fb, 0)) {
           strcpy(file, textpath);
           strcat(file, fb.ff_name);
           ccpread(file);
           return;
         }
      }

      sprintf(file, "%s%s.HLP", textpath, tmp);
      if (i && !xfindfirst(file, &fb, 0)) {
        strcpy(file, textpath);
        strcat(file, fb.ff_name);
        ccpread(file);
        return;
      }

      mbp = putals("No HELP available for \'");
      putstr(strtok(file,"*."), mbp);
      putstr("\'.\r",mbp);
      prompt(mbp);
      seteom(mbp);
    }
  }
}

/************************************************************************/
/* SUSPEND - Befehl                                                     */
/*----------------------------------------------------------------------*/
void ccpsusp(void)
 {
  SUSPEND *suspoi;
  MBHEAD  *mbp;
  char     call[L2IDLEN];
  WORD     i;
  WORD     port;
  int      mode;

  if (!issyso()) {                  /* nur der Sysop darf SUSPEND       */
    invmsg();
    return;
  }

  if (skipsp(&clicnt, &clipoi)) {
    mode = *clipoi++;
    clicnt--;
    port = nxtnum(&clicnt, &clipoi);
    if (getcal(&clicnt, &clipoi, FALSE, call) == YES)
      for (suspoi = sustab, i = 0; i < MAXSUSPEND; suspoi++, i++) {
        if (   suspoi->port == port
            && cmpcal(suspoi->call, call)) /* erstmal austragen */
          suspoi->call[0] = '\0';
        if (   mode == '+'
            && suspoi->call[0] == '\0') {
          memcpy(suspoi->call, call, L2CALEN);
          suspoi->port = port;
          suspoi->okcount = nxtnum(&clicnt,&clipoi);
          break;
        }
      }
  }

  mbp = putals("Suspended are\r");
  for (suspoi = sustab, i = 0; i < MAXSUSPEND; suspoi++, i++)
  {
    if (*suspoi->call != '\0') {
      putcal(suspoi->call, mbp);
      putstr(" is restricted ", mbp);
      switch (suspoi->port) {
        case 253: putstr("to Access denied\r", mbp);
                  break;
        case 254: putstr("to level-2 access\r", mbp);
                  break;
        case 255: putstr("to max ", mbp);
                  putnum(suspoi->okcount,mbp);
                  putstr(" simultanous connections\r", mbp);
                  break;
        default:  putstr("from using Port ", mbp);
                  putnum(suspoi->port, mbp);
                  putchr('\r', mbp);
      }
    }
  }
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/* READB - Datei lesen (binaer)                                  DL1XAO   */
/*------------------------------------------------------------------------*/
#ifdef MC68K
LONG swaplong(LONG)0x4840;     /* SWAP.L D0    */
#endif

void
ccpreadb(void)
{
  char    buf[1024];
  char    fn[14];
  char   *cp;
  WORD    i;
  UWORD   crc;
  LONG    pos;
  LONG    len;
  MBHEAD *mbp;

  if (issyso() && userpo->convers == NULLCONNECTION)    /* darf er ?    */
  {
    mbp = getmbp();
    i = 0;
    for (cp = buf; clicnt-- && i < 128; i++)
      *cp++ = (char) toupper(*clipoi++);
    *cp = NUL;
    userpo->fp = (i == 0) ? NULL : xfopen(buf, "rb");

    if (userpo->fp != NULL)
    {
#ifndef MC68302
      getftime(fileno(userpo->fp), (struct ftime *)&pos);
#else
      getftime(buf, (struct ftime *)&pos);
#endif
#ifdef MC68K
      pos = swaplong(pos);
#endif
      if ((cp = strrchr(buf, FILE_SEP)) != NULL)/* Dateinamen isolieren */
        cp++;
      else
        cp = buf;
      strncpy(fn, cp, 12);
      fn[12] = NUL;
      len = 0L;
      crc = 0;                 /* CRC errechnen und Laenge bestimmen */
      while ((i = (WORD)fread(buf, 1, 1024, userpo->fp)) > 0)
      {
        len += i;
        for (cp = buf; i--; cp++)
          crc = crctab[crc >> 8] ^ ((crc << 8) | (UWORD)*cp);
      }

      if (len != 0)
      {
        putprintf(mbp, "\r#BIN#%ld#|%u#$%08lX#%s\r", len, crc, pos, fn);
        send_msg(TRUE, mbp);
        fseek(userpo->fp, 0L, SEEK_SET);
        userpo->status = US_SBIN;
        return;
      }

      putstr("File has no length!\r", mbp);
    }
    else
      putstr("File not found!\r", mbp);
    prompt(mbp);
    seteom(mbp);
  }
  else
    invmsg();
}

/************************************************************************/
/*                                                                      */
/* ESC Befehl  (nach einer Idee von DL9HCJ)                             */
/*             (Implementation: DL2LAY)                                 */
/*                                                                      */
/* Funktion : Ermoeglicht den Sysops den Remote-Zugriff auf Konsolen-   */
/*            ESC-Befehle                                               */
/* Syntax   : ESC <esc-befehl>                                          */
/*----------------------------------------------------------------------*/
void ccpesc(void)
{
  MBHEAD *mbp;
  char    esctab[] = "@CITVY";

  if (issyso())
   {
    if (clicnt != 0)
     {
      if (strchr(esctab, toupper(*clipoi)))
       {
        blipoi = (char *)clipoi;
        blicnt = clicnt;
        hstcmd(mbp = (MBHEAD *) allocb(ALLOC_MBHEAD));
        mbp->l2link = g_ulink(userpo->uid);
        mbp->type   = g_utyp(userpo->uid);
        prompt(mbp);
        seteom(mbp);
       }
      else
        putmsg("Invalid Hostcommand\r");
     }
   }
  else
    invmsg();
}

/************************************************/
/* L2-QSO killen                                */
/************************************************/
void ccpkill(void) {
  #define ALLPORTS 255

  MBHEAD  *mbp, *msg;
  WORD    what = 0, i;
  char    call[L2IDLEN];
  char    syscall[L2IDLEN];
  UBYTE   mask[MAXMASK], port = 128;
  LNKBLK  *savlp = lnkpoi;
  BOOLEAN kill = 0;
  UWORD   kill_zaehler = 0;

  if (issyso())
  {
    mbp = getmbp();
    cpyid (syscall,calofs(UPLINK, userpo->uid));

    /* schaun ob ein Port angegeben wurde, wenn ja, dann diesen merken */

    if ((*clipoi >= '0') && (*clipoi <= '9' ))
    {
      if ((port = nxtnum(&clicnt, &clipoi)) <= L2PNUM) what = 3; /* Port angegeben ? */
      else port = 128;
    }

    if (*clipoi == '*')
    {
      if (*clipoi != 0) clipoi++;
      if (*clipoi != 0) clipoi++;
      port = ALLPORTS;         /* alle Ports killen ? */
      what = 3;
    }

    if ((port == 128) && (strlen ((char *)clipoi) > 3)) /* Call killen ? */
    {
      getcal(&clicnt, &clipoi, FALSE, call);
      what = 1;
      port = ALLPORTS;        /* Call auf allen Ports abwerfen */
    }

    if (what)
    {
        skipsp(&clicnt, &clipoi);

        /* nun die L2-Liste durchsehen und User ggfs abwerfen */

        for (lnkpoi = lnktbl, i = 0;i < LINKNMBR; ++lnkpoi, ++i)
        {
          if  (lnkpoi->state  &&
              ((lnkpoi->liport == port) || (port == ALLPORTS)))
          {
              switch (what)
              {
                  case 1 : kill = (!strncmp (call, lnkpoi->srcid,7) ||
                                   !strncmp (call, lnkpoi->dstid,7));
                           break;
                  case 2 : kill = (c6mtch(lnkpoi->srcid, mask) ||
                                   c6mtch(lnkpoi->dstid, mask) );
                           break;
                  case 3 : if (!cmpid (lnkpoi->dstid,syscall))
                                               /* nicht den Sysop killen !  */
                                  kill = TRUE; /* jeden auf dem Port */
                              else
                                  kill = FALSE;
              }
              if (kill)
              {
                /*dealml((LEHEAD *)&lnkpoi->sendil);*/ /* clear send liste */
                /*lnkpoi->tosend = 0;               */ /* alles weg        */
                /*siehe Hinweis in L2DAMA           */
                if (   *clipoi
                    && lnkpoi->state >= L2SIXFER)   /* Msg ?            */
                {
                  msg = (MBHEAD *) allocb(ALLOC_MBHEAD); /* Buffer besorgen */
                  msg->l2link = lnkpoi;
                  msg->type = 2;
                  putprintf(msg, "\r*** Msg from Sysop: %s ***\r", clipoi);
                  seteom(msg);
                }
                kill_zaehler++;    /* zaehlen      */
#ifdef DEBUG
                newlnk();
#else
                dsclnk();          /* und DISC     */
#endif
              }
           }
         }
         if (!kill_zaehler)
           putstr("No L2-link found.\r", mbp);
         else
          putprintf(mbp, "%3u link(s) disconnected.\r",kill_zaehler);
    }
    else
    {
      putstr("Syntax: KILL [Port] [Msg]\r", mbp);
      putstr("        KILL [Call] [Msg]\r", mbp);
      putstr("        KILL *      [Msg]\r", mbp);
    }

    lnkpoi = savlp;  /* Pointer restaurieren */
    prompt(mbp);     /* Prompt */
    seteom(mbp);     /* senden.... */
  }
  else invmsg();
}

/*----------------------------------------------------------------------*/
/* Save Befehl                                                          */
/*                                                                      */
/* Funktion : speichert die Parameter-Datei, generiert eine Text-Datei, */
/*            die als TNNxxx.TNB benutzt werden kann (PARMS.TNB)        */
/* Syntax   : SPARAM                                                    */
/*----------------------------------------------------------------------*/
void ccpsave(void)
{
  MBHEAD    *mbp;

  if (!issyso())
  {
     invmsg();
     return;
  }

  save_stat();   /* Stat speichern */
  save_parms();  /* Parameter      */
  save_mh();     /* und MH-Liste   */
#ifdef GRAPH
  save_graph();
#endif

  mbp = getmbp();
  putstr("PARMS.TNB saved...\r", mbp);
  prompt(mbp);
  seteom(mbp);
}

/**************************************************************************/
/*                                                                        */
/* TRACE-Befehl                                                           */
/*                                                                        */
/* Funktion : Einloggen zur Systemueberwachung.                           */
/*                                                                        */
/*------------------------------------------------------------------------*/
void ccptrace(void)
{
  MBHEAD  *mbp;

  /* Bestehendes Monitoring wird ausgeschaltet */
  if (monitor) {
    if (userpo->monitor) {
      moncmd(NULL, userpo->monitor, "N", 1); /* Monitor abschalten */
      dealoc((MBHEAD *)userpo->monitor);
      userpo->monitor = NULL;
    }
  }
  userpo->auditlevel = 0;

  if (issyso()) {

    /* Audit-Level und Monitor setzen */
    userpo->auditlevel = nxtnum(&clicnt, &clipoi);
    if (skipsp(&clicnt, &clipoi)) {
      userpo->monitor = (MONBUF *)allocb(ALLOC_MONBUF);
      moncmd(NULL, userpo->monitor, clipoi, clicnt);
      if (!userpo->monitor->Mpar) { /* er ist nicht angegangen */
        dealoc((MBHEAD *)userpo->monitor);
        userpo->monitor = NULL;
      }
    }

    /* ... zur Kontrolle anzeigen */
    mbp = putals("Trace");
    if (userpo->auditlevel)
      putlong(userpo->auditlevel, FALSE, mbp);
    else
      putstr(" is off", mbp);
    if (userpo->monitor) /* Monitor-Status zeigen */
      moncmd(mbp, userpo->monitor, "", 0);
    else
      putchr('\r', mbp);
#if MAX_TRACE_LEVEL < 9
    if (userpo->auditlevel > MAX_TRACE_LEVEL)
      putprintf(mbp, "Warning: max. trace level of this TNN version is %d\r",
                     MAX_TRACE_LEVEL);
#endif
    prompt(mbp);
    seteom(mbp);     /* senden.... */
  } else
    invmsg();
}

/************************************************************************/
/*                                                                      */
/* RUNBATCH                                                             */
/*                                                                      */
/* Funktion : Batch ausfuehren (nur als Sysop)                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void ccprun(void)
{
  if (issyso()) {                   /* nur der Sysop darf               */
    if (skipsp(&clicnt, &clipoi))
      putmsg(runbatch((char*)clipoi) ? "OK\r" : "File not found\r");
    else
      putmsg("Syntax: RUNBATCH FILENAME.TNB\r");
  } else
    invmsg();
}

/**************************************************************************/
/*                                                                      */
/* DCD                                                                  */
/*                                                                      */
/* Funktion : Status der DCD pro Port anzeigen (fuer alle)              */
/*                                                                      */
/*----------------------------------------------------------------------*/
void ccpdcd(void)
{
  MBHEAD  *mbp;
  int      port;
  PORTINFO *p;
  int      dcd;

  mbp = putals("Data carrier detect:\r");
  for (port = 0; port < L2PNUM; port++) {
    putprintf(mbp, "P%02u", port);
    if (port <= 15) putchr(' ', mbp);
  }
  putchr('\r', mbp);
  for (port = 0, p = portpar; port < L2PNUM; p++, port++) {
    mbp->l4time = mbp->mbpc;
    if (portenabled(port)) {
      if ((dcd = iscd(port)) & DCDFLAG)
            putstr(dcd & RXBFLAG ? "R" : "r", mbp);
      if (dcd & PTTFLAG)
            putstr(dcd & TXBFLAG ? "T" : "t", mbp);
    } else
      putstr("OFF", mbp);
    if (port <= 15) putspa(4, mbp);
  }
  putchr('\r', mbp);
  prompt(mbp);
  seteom(mbp);
}

#ifdef BUFFER_DEBUG
void ccpbuf(void)
{
  MBHEAD          *mbp;
  MAX_BUFFER huge *actbp;
  ULONG            i, n;
  ULONG            used[ALLOC_MAXELEMENTE + 1];

  mbp = putals("Buffer Usage:\r");
  for (i = 0; i < ALLOC_MAXELEMENTE + 1; i++)
    used[i] = 0;
  actbp = (MAX_BUFFER *)RAMBOT;
  n = (ULONG)((RAMTOP - RAMBOT) / sizeof(MAX_BUFFER));
  putprintf(mbp, "\rAllBuffer : %lu (%lu) a %lu Bytes\r", n, nmbfre_max,
            sizeof(MAX_BUFFER));

  while (n--)
  {
    if ((UBYTE) ((USRBLK *)actbp)->owner >= ALLOC_MAXELEMENTE)
    {
      used[ALLOC_MAXELEMENTE]++;
      putprintf(mbp,"Wrong Owner: Buffer:%lu Wert:%d\r", n,
                (UBYTE) ((USRBLK *)actbp)->owner);
    }
    else
      used[(UBYTE) ((USRBLK *)actbp)->owner]++;
    actbp++;
  }
  putprintf(mbp, "FreeBuffer: %lu (%lu)\r", used[ALLOC_NO_OWNER], nmbfre);
  putprintf(mbp, "LEHEAD : %lu\r", used[ALLOC_LEHEAD]);
  putprintf(mbp, "MBHEAD : %lu\r", used[ALLOC_MBHEAD]);
  putprintf(mbp, "USRBLK1: %lu\r", used[ALLOC_USRBLK1]);
  putprintf(mbp, "USRBLK2: %lu\r", used[ALLOC_USRBLK2]);
  putprintf(mbp, "L2LINK : %lu\r", used[ALLOC_L2LINK]);
  putprintf(mbp, "MB     : %lu\r", used[ALLOC_MB]);
  putprintf(mbp, "MONBUF : %lu\r", used[ALLOC_MONBUF]);
  putprintf(mbp, "CQBUF  : %lu\r", used[ALLOC_CQBUF]);
  putprintf(mbp, "IPROUTE: %lu\r", used[ALLOC_IP_ROUTE]);
  putprintf(mbp, "ARPTAB : %lu\r", used[ALLOC_ARP_TAB]);
  putprintf(mbp, "MHEARD : %lu\r", used[ALLOC_MHEARD]);
  putprintf(mbp, "PACSAT : %lu\r", used[ALLOC_PACSATBLK]);
  putprintf(mbp, "INPOPT : %lu\r", used[ALLOC_INPOPT]);
  if (used[0] != 0L)
    putprintf(mbp, "???    : %lu\r", used[0]);
  putprintf(mbp, "Errors : %lu\r", used[ALLOC_MAXELEMENTE]);
  prompt(mbp);
  seteom(mbp);
}
#endif

/* End of src/l7cmds.c */
