/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/mh.c (maintained by: ???)                                   */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998 - 2001 NORD><LINK e.V. Braunschweig               */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/*----------------------------------------------------------------------*/

MHTAB l2heard, l3heard;

static BOOLEAN  load_table(MHTAB *);
static void     save_table(char *, MHTAB *);
static void     ccp_mh(MHTAB *);

/* MHEARD-Liste in den Speicher laden
 */
static BOOLEAN
load_table(MHTAB *mh)
{
  FILE *fp;
  MHEARD *mhp;
  char file[128];               /* Puffer fuer Filenamen                */
  char *ptr;
  WORD  cnt;

  strcpy(file, confpath);
  strcat(file, mh->name);
  if ((fp = xfopen(file, "rt")) != NULL)
  {
    while (fgets(file, 120, fp) != NULL)
    {
      if (*file == ':')
      {
        sscanf(file + 1, "%ld", (long *) &mh->mhstart);
        continue;
      }
      mhp = (MHEARD *)allocb(ALLOC_MHEARD);
      ptr = file;
      cnt = strlen(ptr) - 1;                           /* \n uebersehen */
      mhp->heard = nxtlong(&cnt, &ptr);
      mhp->rx_bytes = nxtlong(&cnt, &ptr);
      mhp->tx_bytes = nxtlong(&cnt, &ptr);
      mhp->port = nxtnum(&cnt, &ptr);
      mhp->damawarn = nxtnum(&cnt, &ptr);
      mhp->rx_rej = nxtlong(&cnt, &ptr);
      mhp->tx_rej = nxtlong(&cnt, &ptr);
      if (getcal(&cnt, &ptr, TRUE, mhp->id) == YES)
      {
        mh->act++;
        relink((LEHEAD *)mhp, (LEHEAD *)(mh->heardl.tail));
        continue;
      }
      else
        dealoc((MBHEAD *)mhp);
    }
    fclose(fp);
    return(TRUE);
  }
  return(FALSE);
}

/*----------------------------------------------------------------------*/

/*
 *  MHEARD-Liste abspeichern
 */

static void
save_table(char *path, MHTAB *mh)
{
  FILE *fp;
  MHEARD huge *mhp;
  char file[128];               /* Puffer fuer Filenamen                */
  char call[12];

  strcpy(file, path);
  strcat(file, mh->name);
  if ((fp = xfopen(file, "wt")) != NULL)
  {
    for (mhp  = (MHEARD *)mh->heardl.head;
         mhp != ((MHEARD huge *)&(mh->heardl));
         mhp  = mhp->next)
    {
      call2str(call, mhp->id);
      fprintf(fp, "%lu %lu %lu %u %u %lu %lu %s\n",
              (long)mhp->heard, mhp->rx_bytes, mhp->tx_bytes,
              mhp->port, mhp->damawarn, mhp->rx_rej, mhp->tx_rej, call);
    }
    fprintf(fp, ":%ld\n", (long) mh->mhstart);
    fclose(fp);
  }
}

/*----------------------------------------------------------------------*/
void save_mh(void)
{
#ifdef ST
  char *mcp;
#endif

  save_table(confpath, &l2heard);
#ifdef ST
  if ((mcp = getenv("MHTOPPATH")) != NULL)
    save_table(mcp, &l2heard);
#endif

  save_table(confpath, &l3heard);
}

/*----------------------------------------------------------------------*/
MHEARD *mh_lookup(MHTAB *mh, char *id)
{
  MHEARD *mhp;
  LHEAD  *heardl = &mh->heardl;

  for (mhp  = (MHEARD *)heardl->tail;
       mhp != (MHEARD *)heardl;
       mhp  = mhp->prev)
    if (cmpid(id, mhp->id))
      return(mhp);
  return(NULL);
}

/*----------------------------------------------------------------------*/
/* Call auf dem richtigen Port suchen */
MHEARD *mh_lookup_port(MHTAB *mh, char *id, UWORD port)
{
  MHEARD *mhp;
  LHEAD  *heardl = &mh->heardl;

  for (mhp  = (MHEARD *)heardl->tail;
       mhp != (MHEARD *)heardl;
       mhp  = mhp->prev)
    if ((cmpid(id, mhp->id)) && (port == mhp->port))
      return(mhp);
    if (cmpid(id, mhp->id))
      return(mhp);
  return(NULL);
}

/*----------------------------------------------------------------------*/
void mh_update(MHTAB *mh, MHEARD *mhp, char *id, UWORD port)
{
  mhp->heard = sys_time;
  cpyid(mhp->id, id);
  mhp->via[0] = NUL;
  mhp->port = port;
  ulink((LEHEAD *)mhp);
  relink((LEHEAD *)mhp, (LEHEAD *)(mh->heardl.tail));
}

/*----------------------------------------------------------------------*/
void mh_clear(MHEARD *mhp)
{
  mhp->tx_bytes =
  mhp->rx_bytes =
  mhp->tx_rej =
  mhp->rx_rej = 0L;
  mhp->damawarn = 0;
}

/*----------------------------------------------------------------------*/
MHEARD *mh_add(MHTAB *mh)
{
  MHEARD *mhp;

  if (mh->max == 0) return(NULL);
  while (mh->act >= mh->max) {
    dealoc((MBHEAD *)ulink((LEHEAD *)mh->heardl.head));
    mh->act--;
  }
  relink((LEHEAD *)(mhp = ((MHEARD *)allocb(ALLOC_MHEARD))),
         (LEHEAD *)(mh->heardl.head));
  mh->act++;
  mh_clear(mhp);
  return(mhp);
}

static void
ccp_mh(MHTAB *mh)
{
  MHEARD        *prevmhp;
  MHEARD        *mhp;
  char           call[L2IDLEN];
  char          *cpoisa;
  WORD           ccntsa;
  WORD           num,i,n;
  WORD           what = 0;
  UBYTE          mask[MAXMASK];
  WORD           comp(const void *, const void *);
  char           tmp1[10];
  char           tmp2[10];
  FILE           *fp;
  char           *tmpfile;
  struct         tm *ts;
  BOOLEAN        show_counter = FALSE;

  /* parameter auswerten */
  num = 10;

  if (clicnt)
  {
    cpoisa = clipoi;
    ccntsa = clicnt;

    do
    {
      if (*cpoisa == '+')
      {
        show_counter = TRUE;
        *cpoisa = 32;
      }
      cpoisa++;
    } while (--ccntsa > 0);

    if (issyso() == TRUE && *clipoi == '=')
    {
      clipoi++;
      clicnt--;
      num = nxtnum(&clicnt, &clipoi);
      num = min(5000, num);
      num = max(0, num);
      mh->max = num;
      while (mh->act > mh->max)
      {
        dealoc((MBHEAD *)ulink((LEHEAD *)mh->heardl.head));
        mh->act--;
      }
    }

    if (issyso() == TRUE && *clipoi == '-')
    {
      clipoi++;
      if (--clicnt == 0)
      {
        for (mhp  = (MHEARD *)mh->heardl.tail;
             mhp != (MHEARD *)&(mh->heardl);
             mhp  = prevmhp)
        {
          prevmhp  = mhp->prev;

          if (mhp->tx_bytes + mhp->rx_bytes == 0)
          {
            dealoc((MBHEAD *)ulink((LEHEAD *)mhp));
            mh->act--;
          }
          else
            mh_clear(mhp);
        }
        mh->mhstart = sys_time;
      }
      else
      {
        if (getcal(&clicnt, &clipoi, FALSE, call) != YES)
        {
          putmsg("Invalid Call");
          return;
        }
        for (mhp  = (MHEARD *)mh->heardl.tail;
             mhp != (MHEARD *)&(mh->heardl);
             mhp  = prevmhp)
        {
          prevmhp  = mhp->prev;

          if (!cmpcal(call,mhp->id))
            continue;
          dealoc((MBHEAD *)ulink((LEHEAD *)mhp));
          mh->act--;
        }
      }
    }
    else
    {
      cpoisa = clipoi;
      ccntsa = clicnt;

      if ((num = nxtnum(&clicnt, &clipoi)) == 0)
      {
        clipoi = cpoisa;
        clicnt = ccntsa;
        num = 10;
      }

      if (mhprm(clipoi, clicnt, mask) == TRUE)
      {
        what = 2;
        num = mh->max;
      }
      else
        if (getcal(&clicnt, &clipoi, FALSE, call) == YES)
        {
          what = 1;
          num = mh->max;
        }
    }
  }
  else
    num = 10;

  if ((tmpfile = tempnam(textpath, "mh")) == NULL)
    return;

  if ((fp = xfopen(tmpfile, "wt")) == NULL)
  {
    putmsg("Sri, can't open tempfile...\r");
    free(tmpfile);
    return;
  }

  call2str(tmp1, myid);
  for (i = 0; alias[i] != ' ' && i < L2CALEN; ++i)
    fprintf(fp, "%c", alias[i]);
  fprintf(fp, ":%s> MHEARD (%d/%d)\n", tmp1, mh->act, mh->max);

  /* kommando ausfuehren */
  for (n = 0, mhp  = (MHEARD *)mh->heardl.tail;
              mhp != (MHEARD *)&(mh->heardl) && n < num;
              mhp  = mhp->prev, n++)
  {
    if (mhp->heard == 0L)
      continue;

    switch (what)
    {
      case 0:  break;

      case 1:  if (! cmpcal(call,mhp->id))
                 continue;
               break;

      case 2:  if (! c6mtch(mhp->id, mask))
                 continue;
               break;

      default: continue;
    }

    call2str(tmp2, mhp->id);
    ts = localtime(&mhp->heard);

    fprintf(fp, "%02d.%02d.%02d %02d:%02d ", ts->tm_mday,
                                             ts->tm_mon+1,
                                             ts->tm_year%100,
                                             ts->tm_hour,
                                             ts->tm_min);

    if (mh == &l2heard)
    {
      if (show_counter)
      {
        fprintf(fp, "P%2u [%10lu,%10lu] %-9s %6lur %6lut %6ud\n",
                    mhp->port,
                    mhp->rx_bytes,
                    mhp->tx_bytes,
                    tmp2,
                    mhp->rx_rej,
                    mhp->tx_rej,
                    mhp->damawarn);
      }
      else
      {
        fprintf(fp, "(%s)%.*s [%10lu,%10lu] %s\n",
                    portpar[mhp->port].name,
                    10 - (WORD)strlen(portpar[mhp->port].name),
                    "          ",
                    mhp->rx_bytes,
                    mhp->tx_bytes,
                    tmp2);
      }
    }
    else
    if (mh == &l3heard)
      fprintf(fp, "P%2u [%10lu,%10lu] %-9s\n",
                  mhp->port,
                  mhp->rx_bytes,
                  mhp->tx_bytes,
                  tmp2);
  }


  fclose(fp);               /* Temporaeres File schliessen */
  userpo->fdefblk = (MB *) allocb(ALLOC_MB);
  strcpy(userpo->fdefblk->data, tmpfile);
  relink((LEHEAD *)userpo->fdefblk,(LEHEAD *)fdfl.tail);
  free(tmpfile);
  ccpread(userpo->fdefblk->data);
}

/**************************************************************************/
/*  ccpmh()   Erweiterter MHEARD-Befehl mit Wildcards wie bei NODES       */
/*            Beispiel: "MHEARD D?5*"              04.06.91  DG5OJ/DB2OS  */
/*            Special Counter Erweiterung, DB7KG                          */
/*------------------------------------------------------------------------*/
void ccpl2mh(void)
{
  ccp_mh(&l2heard);
}

void ccpl3mh(void)
{
  ccp_mh(&l3heard);
}

/*........................................................................*/
/*  mhprm()   Parameter des erweiterten MHEARD-Befehls auswerten,         */
/*            testet ob 'p' ein Wort mit Wildcards enthaelt und kopiert   */
/*            dieses nach 'mp'.  Case-Conversion:  db*E wird zu DB*E      */
/*            Parameter 'n' muss > 0 sein!          04.06.91 DB5OJ/DB2OS  */
/*........................................................................*/
BOOLEAN mhprm(char *p, WORD n, UBYTE *mp)
{
  WORD   i, c, ret;

  ret = FALSE;

  if (skipsp(&n, &p))
  {
    for (i = 0; i < (MAXMASK - 1); )
    {
      if (!n || ((c = *p++) == ' '))
        break;

      n--;

      if ((c == MATCHMANY) || (c == MATCHONE))
        ret = TRUE;

      mp[i++] = isascii(c) ? toupper(c) : MATCHONE;
    }
    mp[i] = MATCHEND;
  }
  return(ret);
}

/*----------------------------------------------------------------------*/
void init_mh(void)
{
  l2heard.mhstart =
  l3heard.mhstart = sys_time;
  l2heard.act =
  l3heard.act = 0;
  l2heard.max =
  l3heard.max = 10;
  l2heard.name = "MHEARD.TAB";
  l3heard.name = "L3HEARD.TAB";
  inithd(&l2heard.heardl);
  inithd(&l3heard.heardl);
  load_table(&l2heard);
  load_table(&l3heard);
}

/*----------------------------------------------------------------------*/
void exit_mh(void)
{
  save_mh();
}

/* End of src/mh.c */
