/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File include/typedef.h (maintained by: ???)                          */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#ifndef __TYPEDEF_H
#define __TYPEDEF_H

typedef signed char      BYTE;                                /* 8 Bit  */
typedef signed short     WORD;                                /* 16 Bit */
typedef signed long      LONG;

typedef unsigned short  UWORD;                                /* 16 Bit */
typedef unsigned char   UBYTE;                                /* 8 Bit  */
typedef unsigned long   ULONG;                                /* 32 Bit */

typedef unsigned short  UID;

enum boolean {FALSE = 0, TRUE};
typedef enum boolean BOOLEAN;

enum trillian {ERRORS = -1, NO, YES};
typedef enum trillian TRILLIAN;

enum linktyp {EMPTY = 0, DOWNLINK, UPLINK, U_IPLINK, D_IPLINK,
              PEERLINK, CQ_LINK};
typedef enum linktyp LINKTYP;

typedef struct lhead        /* "list head", Listenkopf :                */
{
  struct lhead *head;       /* Zeiger auf ersten Eintrag in Liste       */
  struct lhead *tail;       /* Zeiger auf letzten Eintrag in Liste      */
} LHEAD;


typedef struct lehead       /* "list entry head", Kopf eines Eintrags   */
{                           /* in Liste :                               */
  struct lehead *nextle;    /*   Zeiger auf naechsten Listeneintrag     */
  struct lehead *prevle;    /*   Zeiger auf vorherigen Listeneintrag    */
} LEHEAD;


typedef struct lnkblk       /* "link block", fuer jeden Level-2-Link :  */
{
  struct lnkblk *next;      /* Naechster Listeneintrag                  */
  struct lnkblk *prev;      /* Vorheriger Listeneintrag                 */
  UBYTE    state;           /* Link-State, s.o. L2S...                  */
  char     srcid[L2IDLEN];  /* "source id", eigenes Call/SSID oder      */
                            /* Ident/SSID                               */
  char     dstid[L2IDLEN];  /* "destination id", Call/SSID Gegenstation */
  char     viaidl[L2VLEN+1];/* "via id list", Digipeaterstrecke,        */
                            /* 0-terminiert, Weg zur Gegenstation       */
  char    *realid;          /* Zeiger auf Rufzeichen des "echten"       */
                            /* Senders                                  */
  UWORD    RTT;             /* Round-Trip-Timer (10 ms)                 */
  UWORD    SRTT;            /* Smoothed Round Trip Timer                */
                            /* SRTT = (Alpha x SRTT + RTT)/(Alpha + 1)  */
  char     RTTvs;           /* VS bei der die Messung gestartet wurde   */
  UWORD    T1;              /* Timer 1, "frame acknowledge interval",   */
                            /* Start :  SRTT,                           */
                            /* 0 = inaktiv, 10 msec Downcounter         */
  UWORD    T2;              /* Timer T2, "response delay timer",        */
                            /* 0 = inaktiv, 10 msec Downcounter         */
  UWORD    T3;              /* Timer T3, "inactive link timer",         */
                            /* 0 = inaktiv, 10 msec Downcounter         */
  UWORD    noatou;          /* "no activity timeout",                   */
                            /* nach Ablauf Link disconnecten,           */
                            /* 0 = inaktiv, 1 sec Downcounter           */
  UWORD    rcvd;            /* "received", Anzahl empfangener I-Frames  */
                            /* in rcvdil                                */
  UWORD    tosend;          /* Anzahl noch nicht gesendete oder         */
                            /* unbestaetigte Frames in sendil           */
  LHEAD    rcvdil;          /* "received info list", richtig            */
                            /* empfangene I-Frames, mit Header/PID      */
  LHEAD    sendil;          /* "send info list", zu sendende I-Frames,  */
                            /* ohne Header/PID, nur Info                */
  LHEAD    damail;          /* DAMA - Sendeframeliste                   */
  UBYTE    damapm;          /* DAMA - Prioritaetsmerker                 */
                            /* 0=hoechste Prioritaet, 10=niedrigste     */
  UWORD    damapc;          /* DAMA - Prioritaetszaehler in 10ms        */
  UWORD    liport;          /* "link port", 0..L2PNUM-1                 */
  char     VR;              /* "receive sequence variable", Sequenz-    */
                            /* nummer des naechsten zu empfangenden     */
                            /* I-Frames                                 */
  char     VS;              /* "send sequence variable", Sequenznummer  */
                            /* des naechsten zu sendenden I-Frames      */
  char     lrxdNR;          /* "last received N(R)", zuletzt            */
                            /* empfangenes N(R) = eigene gesendete      */
                            /* I-Frames bis lrxdNR-1 bestaetigt         */
  UBYTE    ltxdNR;          /* "last transmitted N(R)", zuletzt         */
                            /* gesendetes N(R) = empfangene I-Frames    */
                            /* bis ltxdNR-1 bestaetigt                  */
  UBYTE    tries;           /* aktuelle Anzahl Versuche (RETRY),        */
                            /* hochzaehlend                             */
  UBYTE    RStype;          /* "response supervisory frametype", nach   */
                            /* T2-Ablauf zu sendendes Antwortframe      */
                                     /* (RR=0x01, RNR=0x05, REJ=0x09)            */
  char     frmr[3];         /* die 3 FRMR-Infobytes, Sendung u. Empfang */
                            /*   frmr[0] : zurueckgewies. Kontrollfeld  */
                            /*   frmr[1] : V(R) CR V(S) 0               */
                            /*   frmr[2] : 0000ZYXW                     */
  UWORD    flag;            /* Flag (s.o. L2F... )                      */
                            /*   Bit 0 : benutzt fuer DAMA-Kennung      */
                            /*   Bit 1 : benutzt fuer DAMA-Kennung      */
                            /*   Bit 2 : nicht benutzt                  */
                            /*   Bit 3 : nicht benutzt                  */
                            /*   Bit 4 : nicht benutzt                  */
                            /*   Bit 5 : nicht benutzt                  */
                            /*   Bit 6 : 1 = (eigenes) Device busy      */
                            /*   Bit 7 : 1 = Link disconnecten, sobald  */
                            /*           Sendeliste (sendil) leer ist   */
                            /*   Bit 8 : 1 = Link sofort abwerfen       */
                            /*   Bit 9 : 1 = Verbindung noch HTH        */
  UWORD    indx;            /* MultiConnect: Indizes (nicht SSIDs)      */
  UWORD    anzl;            /* Anzahl der MultiConnects des Users..     */
  UWORD    zael;            /* MultiConnect: aktueller Zaehlerstand     */
  UBYTE    pollcnt;         /* Anzahl verbotener Polls vom DAMA-User    */
  WORD     priold;          /*<=== DAMA-Merker/Flag Link-Prioritaet     */
  struct mbhead *tmbp;      /* RX-Liste empfangene Fragmente            */
} LNKBLK;

typedef struct mbhead       /* "message buffer head",                   */
{                           /* Datenbuffer-Liste, Kopf :                */
  struct mbhead *nextmh;    /* doppelt verkettete Liste                 */
  struct mbhead *prevmh;
  LHEAD            mbl;     /*   "message buffer list", Zeiger auf      */
                            /*   ersten Infobuffer dieser Message       */
  char huge       *mbbp;    /*   "message buffer buffer pointer",       */
                            /*   Zeiger auf aktuelles Zeichen in Buffer */
  UWORD            mbpc;    /*   "message buffer put count",            */
                            /*   Einschreibzaehler, aufwaertszaehlend   */
  UWORD            mbgc;    /*   "message buffer get count",            */
                            /*   Lesezaehler, aufwaertszaehlend         */
  LNKBLK          *l2link;  /*   Zeiger auf assozierten Linkblock       */
  WORD             type;    /*   Typ des Buffers (User, Status)         */
                            /*          L2M...                          */
                            /*     oder MB...                           */
                            /*     oder 0 User, 2 Level-2, 4 Level-4    */
  UBYTE            l2fflg;  /*   Level 2 Frameflag / PID :              */
                            /*     RX: PID                              */
                            /*     TX: PID / s.o. T2FT1ST/T2FUS         */
  UWORD            l2port;  /*   Level-2-Port (0..L2PNUM-1)             */
  UBYTE            morflg;  /*   "more follows flag" fuer Pakete, die   */
                            /*   durch zusaetzlichen Netzwerkheader zu  */
                            /*   lang wuerden und in 2 Frames           */
                            /*   aufgetrennt wurden                     */
                            /*     YES = das naechste Frame gehoert zu  */
                            /*           diesem Paket                   */
                            /*     NO  = sonst                          */
  UWORD            l4time;  /* Timeout in Level 4                       */
  UBYTE            l4trie;  /* Versuche in Level 4                      */
  UBYTE            l4type;  /* Typ des L4-Paketes                       */
#define L4TNORMAL  0        /* Normales L4-Info-Frame                   */
#define L4TSTATUS  1        /* L3-Status-Frame, beschleunigt senden     */
#define L4TPRIOR   2        /* Eiliges L3-Status-Frame                  */
  UBYTE            tx;      /* 0 = empfangenes, 1 = gesendetes Frame    */
  UBYTE            l3_typ;  /* Spezielle Frames des Level3 ab TNN V1.55 */
#define L3NORMAL 0x00       /* Standard L3-Frame                        */
#define L3LOCAL  0x01       /* Local-Connect                            */
#define L3RTTF   0xFF       /* L3RTT-Messframe                          */
  time_t           btime;   /* Zeit                                     */
} MBHEAD;

typedef struct mb           /* "message buffer",                        */
{                           /* allgemeiner Datenbuffer :                */
  struct mb *nextmb;        /*   naechster Eintrag in Liste             */
  struct mb *prevmb;        /*   vorheriger Eintrag in Liste            */
  char       data[64];      /* wird bis MAX_BUFFERS-8 gefuellt          */
} MB;

/*---------------------conversd-Strukturen--------------------------*/

#define NAMESIZE 16

typedef struct clist {
  WORD channel;                 /* channel number */
  WORD channelop;               /* channel operator status */
  time_t time;                  /* join time */
  struct clist *next;           /* pointer to next entry */
} CLIST;

#define NULLCLIST ((CLIST *) NULL)

typedef struct connection {
  WORD type;                     /* Connection type */
#define CT_UNKNOWN      0
#define CT_USER         1
#define CT_HOST         2
#define CT_CLOSED       3
  char name[NAMESIZE];          /* Name of user or host */
  char host[NAMESIZE];          /* Name of host where user is logged on */
  char rev[NAMESIZE];           /* revision of software (CT_HOST) */
  /*WORD oldaway;*/             /* old away feature */
  struct connection *via;       /* Pointer to neighbor host */
  WORD channel;                 /* current channel number */
  CLIST *chan_list;             /* linked list of joined channels */
  time_t time;                  /* Connect time */
  WORD locked;                  /* Set if mesg already sent */
  MBHEAD *mbout;                /* Output queue */
  LONG received;                /* Number of bytes received */
  LONG xmitted;                 /* Number of bytes transmitted */
  char *away;                   /* Away string */
  time_t atime;                 /* time of last "away" state change */
  time_t mtime;                 /* time of last message receive */
  char *pers;                   /* Personal string */
  WORD verbose;                 /* verbose mode */
  char prompt[4];               /* prompt mode */
  char query[NAMESIZE];         /* name of queried user */
  char *notify;                 /* List of calls you like to be notified */
  char *filter;                 /* List of calls you like to filter */
  WORD charset_in;              /* charset - default ISO (ansi) */
  WORD charset_out;             /* charset - default ISO (ansi) */
  WORD channelop;               /* channel operator of current channel ? */
  WORD operator;                /* convers operator */
  WORD invitation_channel;      /* last invitation was from this channel */
  WORD width;                   /* user screen width */
  struct usrblk *up;            /* parent-userblk of this connection */
  struct connection *next;      /* Linked list pointer */
} CONNECTION;

#define CM_UNKNOWN   (1 << CT_UNKNOWN)
#define CM_USER      (1 << CT_USER)
#define CM_HOST      (1 << CT_HOST)
#define CM_CLOSED    (1 << CT_CLOSED)

#define NULLCONNECTION  ((CONNECTION *) NULL)

typedef struct permlink {
  char cname[8];                /* Internal name of host */
  char name[NAMESIZE];          /* Name of host */
  CONNECTION *connection;       /* Pointer to associated connection */
  time_t statetime;             /* Time of last (dis)connect */
  WORD tries;                   /* Number of connect tries */
  time_t waittime;              /* Time between connect tries */
  time_t retrytime;             /* Time of next connect try */
  time_t testwaittime;          /* Time between tries */
  time_t testnexttime;          /* Time of next test */
  time_t rxtime;                /* rtt by other side */
  time_t txtime;                /* rtt found out by me */
  WORD locked;                  /* test for a loop blocker */
  WORD nlcks;                   /* lock-counter */
  UWORD port;                   /* Neighbour port                       */
  char  call[L2IDLEN];          /* Call of host                         */
  char  via[L2VLEN+1];          /* 0-term. via-list                     */
} PERMLINK;

#define NULLPERMLINK  ((PERMLINK *) NULL)

typedef struct destination {
  char name[NAMESIZE];          /* destination name */
  char rev[NAMESIZE];           /* revision of software (CT_HOST) */
  PERMLINK *link;               /* link to this destination */
  time_t rtt;                   /* round trip time to this host */
  time_t last_sent_rtt;         /* last donwnstream sent rtt */
  struct destination *next;     /* a one dimansional list is ok for now :-) */
} DESTINATION;

#define NULLDESTINATION  ((DESTINATION *) NULL)

typedef struct channel {
  char *topic;                  /* topic of channel */
  time_t time;                  /* when was the topic set ? */
  WORD chan;                    /* integer value of channel (<32768 !) */
  WORD flags;                   /* channel flags */
#define M_CHAN_S 0x01           /* secret channel - number invisible */
#define M_CHAN_P 0x02           /* private channel - only join by invitation */
#define M_CHAN_T 0x04           /* topic settable by operator only */
#define M_CHAN_I 0x08           /* invisible channel - only sysops can see */
#define M_CHAN_M 0x10           /* moderated channel - operators may talk */
#define M_CHAN_L 0x20           /* local channel - no forwarding */
  struct channel *next;         /* linked list again */
} CHANNEL;

#define NULLCHANNEL  ((CHANNEL *) NULL)

/*---------------Ende der conversd-Strukturen-----------------------*/


typedef struct stentry      /* "state table entry",                     */
{                           /* ein Eintrag in der State-Table :         */
  void  (*func)(void);      /*   Zustandsuebergangsfunktion             */
  UBYTE newstate;           /*   neuer Zustand                          */
  UBYTE msg;                /*   Meldung                                */
} STENTRY;

typedef struct mfentry      /* "message function entry",                */
{                           /* ein Eintrag in der State-Table :         */
  void  (*func)(void);      /*   Meldungsfunktion                       */
} MFENTRY;

typedef struct pacsatblk    /* PACSAT-Server V1.12                      */
{
  char    *tempfile;        /* Temporaer-Name beim Upload               */
  FILE    *tempfp;          /* File beim Upload                         */
  BOOLEAN  check_pwd;       /* bei BOX Passwort verlangen ?             */
  time_t   login;           /* Loginzeit fuer Passwort                  */
  WORD     row, col;        /*                                          */
} PACSATBLK;

typedef struct monbuf {             /* Struktur fuer einen Monitor      */
  UBYTE Mpar;                       /* Flags fuer den Monitor           */
  UWORD Mport;                      /* Port fuer den Monitor            */
  UBYTE mftsel;                     /* Rufzeichen an/aus/alle?          */
  char  mftidl[L2VLEN+1];           /* Platz fuer 8 Rufzeichen          */
} MONBUF;

#define HOST_USER  0
#define L2_USER    2
#define L4_USER    4
#define CQ_USER    42

#define NO_UID     (0xFFFFU)

typedef struct  usrblk
{
  struct usrblk *unext;   /* doppelt verkettete Liste                   */
  struct usrblk *uprev;
  UID         uid;        /* eigene User-ID                             */
  UID         p_uid;      /* Partner User-ID                            */
  MBHEAD     *mbhd;       /* eingelaufene Frames fuer User              */
  FILE       *fp;         /* File fuer Read                             */
  MB         *fdefblk;    /* Pointer auf Dateistruktur fuer Read        */
  CONNECTION *convers;    /* Pointer auf Convers-Struktur               */
  PACSATBLK  *pacsat;     /* Zeiger auf den PACSAT-Block                */
  MONBUF     *monitor;    /* Zeiger auf den Monitor-Filter-Buffer       */
  int         auditlevel;
  char        talkcall[11];
  UBYTE       status;     /* USER-Status                                */
#define US_NULL 0         /* leer/dummy                                 */
#define US_CCP  1         /* CCP-User                                   */
#define US_CREQ 2         /* Connect-Request                            */
#define US_WPWD 3         /* Warte auf Passwort                         */
#define US_RTXT 4         /* Empfange Textdatei                         */
#define US_WBIN 5         /* Warte auf #BIN#                            */
#define US_SBIN 6         /* Sende Binaerdaten                          */
#define US_RBIN 7         /* Empfange Binaerdaten                       */
#define US_CHST 8         /* ConversHost                                */
#define US_TALK 9         /* TALK-Mode                                  */
#define US_DIG  10        /* User muss weitergereicht werden            */
#define US_EXTP 12        /* externes Programm laeuft (Linux)           */
#define US_CQ   13        /* User ruft CQ                               */
#ifdef __LINUX__
  pid_t   child_pid;
  UWORD   child_timeout;
  char    fnsav[9];       /* Filename Temp-File bei externen Programm   */
#endif
  UBYTE   sysflg;         /* SYSOP Flag                                 */
  UBYTE   errcnt;         /* CCP Fehlerzaehler                          */
  UBYTE   convflag;       /* wenn != 0 soll nicht in den ccp zurueck    */
                          /* 1 = CVSHOST von aussen 2= CVSHOST von uns  */
  UBYTE   paswrd[5];      /* gegebene Passwort Stellen                  */
} USRBLK;

typedef struct            /* Zum Host connectete User                   */
{
  char    call[L2IDLEN];  /* Call des Users                             */
  char    conflg;         /* User ist connected Flag                    */
  char    disflg;         /* Flag: Verbindung trennen, wenn Info weg    */
  char    direction;      /* 0 = Conn. von aussen; 1 = Conn. zum Knoten */
  UWORD   noacti;         /* Timer fuer keine Aktivitaet                */
  UWORD   inlin;          /* eingelaufene Zeilen                        */
  UWORD   outlin;         /* auszugebende Zeilen                        */
  UWORD   outsta;         /* auszugebende Meldung                       */
  LHEAD   inbuf;          /* Listenkopf Eingabebuffer                   */
  LHEAD   outbuf;         /* Listenkopf Ausgabebuffer                   */
} HOSTUS;

typedef struct l2_link
{
  char call[L2IDLEN];           /* Rufzeichen                           */
  char alias[L2CALEN];          /* Alias                                */
  char digil[15];               /* Digiliste                            */
// wieso 15??
  UWORD port;                   /* L2-Port                              */
  UWORD ssid_high;              /* SSID oben fuer Flexnet               */
} L2LINK;

#define INP     0 /* Knoten nach INP-Protokoll */
#define TNN     1 /* neuer TNN-Typ  */
#define THENET  2 /* Nachbar, der nicht auf Messung reagiert */
#define NETROM  3 /* unser guter alter Netrom */
/* alles <= NETROM wird als NETROM behandelt! */
#define FLEXNET 4 /* an FlexNet ist Flix nix */
#define LOCAL   5 /* Local */
#define LOCAL_M 6 /* Local mit Messung */

#define SSID(x) ((x[L2CALEN]>>1)&0x0F)
#define MAX_SSIDs 16

typedef struct                      /* Weginformation                      */
{
  unsigned  reported_quality;       /* letzte gemeldete Qualitaet          */
  unsigned  quality;                /* letzte empfangene Qualitaet         */
  int       timeout;                /* Timeout (> 0 wenn aktiv)            */
  char      lt;                     /* Hops seit dem Ziel                  */
} ROUTE;

typedef struct peer          /* ein Segment ("Nachbar")                    */
{
  ROUTE  *routes;            /* Liste mit Weginformationen                 */

                             /* alle Qualitaeten in ms Schritten           */
  unsigned long quality;     /* geglaettete Qualitaet zum Segment          */
  unsigned long my_quality;  /* meine Messung                              */
  unsigned long his_quality; /* seine Messung                              */

  BOOLEAN used;              /* frei?                                      */

  BOOLEAN locked;            /* feste Route, nicht loeschen                */
  int     options;

  int     num_routes;        /* Anzahl der Routen                          */

  struct peer *primary;      /* Flag: == 0 primaerer Weg                   */
                             /*       != 0 der besten Weg dorthin          */

  L2LINK *l2link;            /* vorgegebener Link-Weg                      */
  WORD    rtt_time;          /* Messintervalle fuer L3RTT                  */
  ULONG   rttstart;          /* Laufzeitmessung, Startzeit                 */

  LHEAD   rxfl;              /* Neigbour Frame List                        */

  WORD    tosend;            /* Frames fuer den Nachbarn                   */

  LNKBLK  *nbrl2l;           /* Querverweis zur Level2 Tabelle             */
  UBYTE   tries;             /* Anzahl der Connectversuche                 */
  char    typ;               /* Nachbar Typ                                */
  BOOLEAN secured;
  WORD    version;           /* TNN-Version                                */
  UBYTE   token;             /* Flexnet, wer hat das Token?                */
  BOOLEAN brotim;            /* Broadcast Timer                            */
} PEER;

typedef struct node                 /* Nodes-Liste                         */
{
  struct node *next;                /* doppelt verkettete Liste            */
  struct node *prev;
  char         id[L2IDLEN];         /* Rufzeichen des Nodes                */
  char         alias[L2CALEN];      /* Alias dieses Zieles                 */
#define OPTLEN 8
  int          opt[OPTLEN];
  int          optlen;
  char         ssid_high;           /* oberer SSID-Bereich                 */
} NODE;

typedef struct network              /* ein Netzwerk                        */
{
  PEER   *peertab;                  /* Segment-Tabelle                     */
  NODE   *nodetab;                  /* Nodes-Tabelle                       */
  LHEAD   nodelis;                  /* sortierte Nodes-Liste               */
  int     max_peers;                /* max. Anzahl der Segmente            */
  int     num_peers;                /* Anzahl der aktiven Segmente         */
  int     max_nodes;                /* max. Anzahl der Nodes               */
  int     num_nodes;                /* Anzahl der aktiven Nodes            */
} NETWORK;

typedef struct {           /* ein Netrom Route Record Eintrag           */
  char id[L2IDLEN];
  char lt;
} NRRLIST;

typedef struct ptcent      /* Patchcord Liste                           */
{
  ULONG    inforx;         /* Empfangene Info-Bytes                     */
  ULONG    infotx;         /* Gesendete Info-Bytes                      */
  ULONG    lastrx;         /* letzter Stand der Info-Bytes              */
  ULONG    lasttx;         /* letzter Stand der Info-Bytes              */
  ULONG    contime;        /* Connect-Zeit                              */
  ULONG    rxbps;          /* Empfangsbaudrate                          */
  ULONG    txbps;          /* Sendebaudrate                             */
  BOOLEAN  recflg;         /* Nach einem DISCONNECT reconnect in CCP?   */
  UID      p_uid;          /* Partner User-ID                           */
  USRBLK  *ublk;           /* Zugehoeriger User-Block (p_uid==CCP_USER) */
  LINKTYP  state;          /* Ist das der Uplink?                       */
  UBYTE    local;
#define PTC_NORMAL 0
#define PTC_LOCAL  1
} PTCENT;                  /* es gehoeren immer 2 Eintraege zusammen    */

typedef struct cirblk      /* Level 3 Kontrollblock                     */
{
  struct cirblk *head;     /* doppelt verkettete Liste                  */
  struct cirblk *tail;
  char    state;           /* Status: 0=leer, 1=ConReq, 2=Con, 3=DisReq */
  char    idxpar;          /* Partner Index                             */
  char    ideige;          /* eigener ID                                */
  char    idpart;          /* Partner ID                                */
  char    destca[L2IDLEN]; /* Zielrufzeichen (wenn != myid -> LOCAL)    */
  char    downca[L2IDLEN]; /* Downlink Call                             */
  char    upcall[L2IDLEN]; /* Uplink Call                               */
  char    window;          /* Fenstergroesse                            */
  char    l4rxvs;          /* letzte bestaetigte Framenummer            */
  char    l4vs;            /* letzte gesendete Framenummer              */
  char    l4vr;            /* letzte erhaltene Framenummer              */
  char    l4rs;            /* notwendige Antwort: 0=ACK, 1=NAK, 2=NAKweg*/
  UBYTE   l4try;           /* Transport Versuche                        */
  char    l4flag;          /* DISC-req, selbst choked, Partner choked   */
  UWORD   RTT;             /* Round-Trip-Timer (10 ms)                  */
  UWORD   SRTT;            /* Smoothed Round Trip Timer                 */
                           /* SRTT = (Alpha x SRTT + RTT)/(Alpha + 1)   */
  char    RTTvs;           /* RTT gestartet bei dieser Framenummer      */
  UWORD   traout;          /* Transport Timeout                         */
  UWORD   acktim;          /* Acknowledge Timer                         */
  UWORD   tranoa;          /* no-activity-Timeout                       */
  UWORD   numrx;           /* empfangene Frames                         */
  UWORD   numtx;           /* zu sendende Frames                        */
  MBHEAD *fragme;          /* Fragment eines kommenden Frames           */
  NODE   *l3node;          /* Node fuer diesen Circuit                  */
  LHEAD   mbhdrx;          /* Listenkopf empfangene Frames              */
  LHEAD   mbhdtx;          /* Listenkopf zu sendende Frames             */
  LHEAD   mbhdos;          /* Listenkopf: Frames ausserhalb der Folge   */
  UWORD   ll4txNR;         /* last level 4 tx NR  (on5zs)               */
  char    upnod[L2IDLEN];  /* Uplinkknoten                              */
  char    upnodv[L2VLEN+1];/* Digipeaterkette beim Uplink               */
} CIRBLK;

typedef struct param            /* Parameter                            */
{
  UWORD *paradr;                /* Adresse des Parameters               */
  UWORD  minimal;               /* Minimalwert                          */
  UWORD  maximal;               /* Maximalwert                          */
  const char *parstr;           /* Name des Parameters                  */
} PARAM;

typedef struct command          /* Befehls-Struktur                     */
{
  const char *cmdstr;           /* Befehlsname                          */
  void (*cmdfun)(char *);       /* auszufuehrende Funktion              */
  char *cmdpar;                 /* Zeiger auf Parameter                 */
} COMAND;
/* WICHTIG!: bei ST gibts eine Struktur COMMAND schon (os-headers) */

typedef struct hostcomand       /* Funktionen nur fuer Console          */
{
  const char *cmdstr;           /* Funktionsname                        */
  void (*cmdfun)(void);         /* auszufuehrende Funktion              */
} HOSTCMD;

typedef struct statistik        /* Fuer Statistik                       */
{
  char    call[8];              /* Rufzeichen                           */
// wieso 8???
  time_t  hfirst;               /* zuerst gehoert                       */
  time_t  hlast;                /* zuletzt gehoert                      */
  ULONG   rxByte;               /* Anzahl empfangener Bytes             */
  ULONG   rxIno;                /* Anzahl empfangener I-Frames          */
  ULONG   rxRRno;               /* Anzahl empfangener RR-Frames         */
  ULONG   rxREJno;              /* Anzahl empfangener REJ-Frames        */
  ULONG   rxRNRno;              /* Anzahl empfangener RNR-Frames        */
  ULONG   txByte;               /* Anzahl gesendeter Bytes              */
  ULONG   txIno;                /* Anzahl gesendeter I-Frames           */
  ULONG   txRRno;               /* Anzahl gesendeter RR-Frames          */
  ULONG   txREJno;              /* Anzahl gesendeter REJ-Frames         */
  ULONG   txRNRno;              /* Anzahl gesendeter RNR-Frames         */
} STAT;

typedef struct mhtab {          /* MHEARD-Tabelle                       */
    const char *name;
    time_t      mhstart;
    LHEAD       heardl;
    UWORD       max;
    UWORD       act;
} MHTAB;

typedef struct  mheard          /* Direkt am Digi-Standort geohoerte    */
{                               /* L2-Frames                            */
  struct mheard *next;          /* doppelt verkettete Liste             */
  struct mheard *prev;
  time_t         heard;         /* Zeitpunkt des Empfangs               */
  ULONG          tx_bytes;      /* Gesendete Info-Bytes zum User        */
  ULONG          rx_bytes;      /* Empfangene Info-Bytes vom User       */
  ULONG          tx_rej;        /* wieviele rej gesendet ?              */
  ULONG          rx_rej;        /* wieviele empfangen                   */
  UWORD          port;          /* TNC, an dem das Frames gehoert wurde */
  char           id[L2IDLEN];   /* Rufzeichen                           */
  char           via[L2IDLEN];  /* via einer Station?                   */
  UWORD          damawarn;      /* Meckermeldungen/DISC's vom Knoten    */
} MHEARD;

typedef struct cqbuf            /* Eintrag fuer User im CQ-Modus        */
{
  struct cqbuf *next;           /* doppelt verkettete Liste             */
  struct cqbuf *prev;
  char          id[7];          /* Rufzeichen                           */
  UID           uid;            /* User ID                              */
  UID           p_uid;
} CQBUF;

typedef struct portinfo         /* Alle L1 Parameter fuer einen Port    */
{
  char  name[11];               /* Pseudoname des Ports                 */
  UWORD speed;                  /* Port Speed (z.Z. nur fuer Vanessa    */

  WORD  reset_port;             /* Diesen Port resetten ?               */
  UWORD nmblks;                 /* Anzahl Links auf dem Port            */
  UWORD nmbstn;                 /* Anzahl Stationen auf dem Port        */

  UWORD txdelay;                /* Txdelay auf diesem Port              */
  UWORD mtu;                    /* Maximum Transmition Units (I-Feld)   */

  UWORD persistance;            /* AUTOPAR: Persistance                 */
  UWORD slottime;               /* AUTOPAR: Slottime                    */

  UWORD IRTT;                   /* AUTOPAR: IRTT (T1)                   */
  UWORD T2;                     /* AUTOPAR: T2                          */
  UWORD retry;                  /* AUTOPAR: retry                       */

  UWORD maxframe;               /* MANUELL: maxframe                    */

  UWORD l1mode;                 /* Mode-Flags                           */
  UWORD l2mode;                 /* Mode-Flags                           */
/* Masken fuer den Mode-Parameter */
#define MODE_h   0x2000         /* MH Flag (an=HEARD fuehren/aus)       */
#define MODE_s   0x1000         /* SYSOP Flag (an=nur mit PRIV/aus)     */
#define MODE_a   0x0800         /* DAMA Flag (an/aus)                   */
#define MODE_x   0x0400         /* CTEXT Flag (an/aus)                  */
#define MODE_m   0x0200         /* Multibaud Flag (Kanalkopplung)       */
#define MODE_e   0x0100         /* externer Takt Vanessa                */
#define MODE_d   0x0080         /* Vollduplex                           */
#define MODE_r   0x0040         /* externer RX-Takt                     */
#define MODE_t   0x0020         /* externer TX-Takt                     */
#define MODE_z   0x0010         /* NRZ statt NRZI bei SCC               */
#define MODE_c   0x0002         /* CRC bei KISS, DCD bei SER12          */
#define MODE_off 0x0001         /* Special: Wenn 1, Kanal abgeschaltet  */
#define CLR_L1MODE(port) portpar[port].l1mode = 0
#define SET_L1MODE(port,mode) portpar[port].l1mode |= mode
  UWORD l1_tx_timer;            /* Verzoegerung fuer Sendertastung      */

  int     major;
  #define NO_MAJOR 0
  int     minor;
  #define NO_MINOR (-1)

} PORTINFO;

#define portenabled(port)  (portpar[port].major != NO_MAJOR)

#define dama(port)         (portpar[port].l2mode & MODE_a)
#define updmheard(port)    (portpar[port].l2mode & MODE_h)
#define sysoponly(port)    (portpar[port].l2mode & MODE_s)
#define ctextenabled(port) (portpar[port].l2mode & MODE_x)

#define fullduplex(port)   (portpar[port].l1mode & MODE_d)
#define extclock(port)     (portpar[port].l1mode & MODE_e)
#define multibaud(port)    (portpar[port].l1mode & MODE_m)

typedef struct l1modetab {
  char ch;
  int  mode;
} L1MODETAB;

#define DCDFLAG 0x0001          /* Kanal-Zustaende fuer iscd()          */
#define PTTFLAG 0x0002
#define RXBFLAG 0x0004
#define TXBFLAG 0x0008

#define L1CRES 1                /* Requests fuer l1_ctl()               */
#define L1CCMD 2
#define L1CTST 3

typedef struct portcmd          /* Port-Befehls-Struktur                */
{
  const char *cmdstr;           /* Befehlsname                          */
  const char  cmdpar;           /* Zeiger auf Parameter           DB7KG */
} PORTCMD;

typedef struct portstat
{
  UWORD reset_count;   /* Anzahl der Resets ?                           */

  ULONG rx_bytes;      /* Anzahl bisher empfangener Bytes               */
  ULONG tx_bytes;      /* Anzahl bisher gesendeter Bytes                */

  ULONG last_rx;       /* letzter Zaehlerstand empfangene Bytes         */
  ULONG last_tx;       /* letzter Zaehlerstand gesendeter Bytes         */

  ULONG rx_baud;       /* Empfangsbaudrate (MAC)                        */
  ULONG tx_baud;       /* Sendebaudrate (MAC)                           */

  ULONG rx_overhead;   /* empfangener Protokolloverhead                 */
  ULONG tx_overhead;   /* gesendeter Protokolloverhead                  */

  UWORD invalid[4];    /* Invalid Frames + 1 in Reserve                 */
} PORTSTAT;

#define INV_FRAME(port, type) portstat[port].invalid[type]++
#define INVF_ADR 0              /* Addressfehler (L2)                   */
#define INVF_ALN 1              /* Addressfeldlaenge (L2)               */
#define INVF_CTL 2              /* Controlfeldfehler (L2)               */

typedef struct major {          /* Layer 1 Geraetestruktur              */
  char         *name;
  int         (*istome)(int, char *);
  void        (*init)(void);
  void        (*exit)(void);
  void        (*handle)(void);
  void        (*ctl)(int, int);
  WORD        (*dcd)(PORTINFO *);
  int         (*attach)(int, int, BOOLEAN);
  int         (*detach)(int);
  void        (*info)(int, int, MBHEAD *);
  void        (*timer)(UWORD);
#define HW_INF_IDENT  1
#define HW_INF_INFO   2
#define HW_INF_STAT   3
#define HW_INF_CLEAR  4
} MAJOR;

typedef struct devtable {       /* Layer 1 Geraeteliste                 */
  char        *name;
  int          major;           /* Major des Treiber nach der reg.      */
  int         (*reg_func)(void);
} DEVTABLE;
#define REGISTER_DEVICE(a,b) {a,0,b}

typedef struct suspend          /* Liste gesperrter Rufzeichen          */
{
  char  call[L2CALEN];          /* gesperrtes Rufzeichen                */
  UWORD port;                   /* Port auf dem gesperrt ist            */
  UBYTE okcount;                /* Anzahl zulaessiger Links             */
} SUSPEND;

typedef struct bake
{
  char beades[L2IDLEN];         /* Zielrufzeichen fuer Bake             */
  char beadil[L2VLEN+1];        /* Digiliste fuer Bake                  */
  WORD interval;                /* Zeitinterval in Minuten              */
  WORD beatim;                  /* Minuten-Zaehler                      */
  WORD telemetrie;              /* Telemetrie mitsenden                 */
  char text[80];                /* Bakentext                            */
} BEACON;

typedef struct
{
  char   call[L2IDLEN];         /* Rufzeichen incl. SSID                */
  char   via[L2VLEN+1];
  WORD   port;                  /* Port                                 */
  char   typ;
  char   nbrcal[L2IDLEN];
  NODE  *np;
  UID    uid;
} DEST;

typedef union max_buffer        /* sizeof() -> groesster Buffer         */
{
  MB               mb;
  MBHEAD           mbhead;
  MHEARD           mheard;
  USRBLK           usrblk;
  L2LINK           l2link;
} MAX_BUFFER;

#define sizeof_MBDATA (sizeof(MAX_BUFFER)-sizeof(void*)*2)

#ifdef GRAPH
typedef struct tgraphpeak
{
  ULONG max;
  ULONG ave;
  ULONG min;
} TGRAPHPEAK;

typedef struct tgraphelement
{
  TGRAPHPEAK circuit;
  TGRAPHPEAK freebuffer;
  TGRAPHPEAK l2link;
  TGRAPHPEAK node;
  TGRAPHPEAK roundpsec;
  TGRAPHPEAK throughput;
} TGRAPHELEMENT;

typedef struct tgraph
{
  BOOLEAN enabled;
  int hour_pos;                     /* Position des aktuellen Elementes */
  int day_pos;
  int week_pos;
  int hour_slot;      /* Anzahl der gespeicherten Werte im akt. Element */
  int day_slot;
  int week_slot;
  TGRAPHELEMENT hour[GRAPH_STD_ELEMENTS];
  TGRAPHELEMENT day [GRAPH_DAY_ELEMENTS];
  TGRAPHELEMENT week[GRAPH_WEK_ELEMENTS];
} TGRAPH;
#endif                                                   /* ifdef graph */

#ifdef MC68302
struct ftime
{
    unsigned ft_tsec:   5;
    unsigned ft_min:    6;
    unsigned ft_hour:   5;
    unsigned ft_year:   7;
    unsigned ft_month:  4;
    unsigned ft_day:    5;
};
#endif

#endif

/* End of include/typedef.h */
