/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File os/linux/init.c (maintained by: DF6LN)                          */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

/* tfkiss: TNC-emulation for Linux
   Copyright (C) 1995-96 by Mark Wahl
   Procedures for initialization (init.c)
   created: Mark Wahl DL4YBG 95/09/17
   updated: Mark Wahl DL4YBG 96/03/11
*/

#include "tnn.h"

static int
analyse_value(char str1[], char str2[])
{
  int tmp;

  if (stricmp(str1, "tnn_dir") == 0) {
    strcpy(tnn_dir, str2);
    tmp = strlen(tnn_dir);
    if (tnn_dir[tmp-1] != '/') {
      tnn_dir[tmp] = '/';
      tnn_dir[tmp+1] = '\0';
    }
    return(0);
  }
  else if (stricmp(str1, "tnn_errfile") == 0) {
    strcpy(tnn_errfile, str2);
    return(0);
  }
  else if (stricmp(str1, "tnn_procfile") == 0) {
    strcpy(tnn_procfile, str2);
    return(0);
  }
  else if (stricmp(str1, "buffers") == 0) {
    if (sscanf(str2, "%lu", &tnn_buffers) != 1) return(1);
    return(0);
  }
  else if (strcmp(str1, "tnn_socket") == 0) {
    if (!use_socket) {
      strcpy(tnn_socket, str2);
      use_socket = TRUE;
    }
    return(0);
  }
  else if (stricmp(str1, "device") == 0) {
    if (max_device >= L1PNUM-1) return(1);
    strcpy(l1port[++max_device].device, str2);
    return(0);
  }
  else if (stricmp(str1, "tnn_lockfile") == 0) {
    if (max_device < 0) return(1);
    strcpy(l1port[max_device].tnn_lockfile, str2);
    return(0);
  }
  else if (stricmp(str1, "speed") == 0) {
    if (max_device < 0) return(1);
    if (sscanf(str2, "%d", &tmp) != 1) return(1);
    l1port[max_device].speedflag = 0;
    switch (tmp) {
    case 0:
      l1port[max_device].speed = B0;
      return(0);
    case 9600:
      l1port[max_device].speed = B9600;
      return(0);
    case 19200:
      l1port[max_device].speed = B19200;
      return(0);
    case 38400:
      l1port[max_device].speed = B38400;
      return(0);
    case 57600:
      l1port[max_device].speed = B38400;
      l1port[max_device].speedflag = ASYNC_SPD_HI;
      return(0);
    case 115200:
      l1port[max_device].speed = B38400;
      l1port[max_device].speedflag = ASYNC_SPD_VHI;
      return(0);
    default:
      return(1);
    }
  }
  else if (stricmp(str1, "kisstype") == 0) {
    if (max_device < 0) return(1);
    if (sscanf(str2, "%d", &tmp) != 1) return(1);
    if ((tmp < KISS_NORMAL) || (tmp > KISS_AXIP)) return(1);
#ifndef AX_IPX
    if (tmp == KISS_IPX) return(1);
#endif
#ifndef AX25IP
    if (tmp == KISS_AXIP) return(1);
#endif
#ifndef VANESSA
    if (tmp == KISS_VAN) return(1);
#endif
    if ((tmp == KISS_TOK) && (max_device != 0)) return(1);
    l1port[max_device].kisstype = tmp;
    if (tmp == KISS_TOK)
     {
      tkcom = 1;
      switch (l1port[0].speed)
       {
        case B9600:   tkbaud = 96;
                      break;
        case B19200:  tkbaud = 192;
                      break;
        case B38400:  tkbaud = 384;
                      if (l1port[0].speedflag == ASYNC_SPD_HI)
                        tkbaud = 576;
                      if (l1port[0].speedflag == ASYNC_SPD_VHI)
                        tkbaud = 1152;
                      break;
       }
     }
    return(0);
  }
  else if (stricmp(str1, "port") == 0) {
    if (max_device < 0) return(1);
    if (sscanf(str2, "%d", &tmp) != 1) return(1);
    if ((tmp < 0) || (tmp > L2PNUM)) return(1);
    if (l1port[max_device].kisstype < 0) return(1);
    if (l1port[max_device].kisstype == KISS_TOK)
     {
      if (++tokenring_ports >= L2PNUM) return(1);
      l1ptab[tmp] = 0;
      l2ptab[max_device] = -1;
      ++used_l1ports;
     }
    else
     {
      if (++used_l1ports >= L2PNUM) return(1);
      l1ptab[tmp] = max_device;
      l2ptab[max_device] = tmp;
     }
/* hier koennte noch eine Pruefung eingebaut werden, dass keine Port-   */
/* nummer doppelt angegeben wurde ...                                   */
/* Evtl. sollte auch geprueft werden, ob die Zuordnung der Vanessa-     */
/* ports konsistent ist.                                                */
    return(0);
  }
  else {
    return(1);
  }
}

void
add_tnndir(char *str)
{
  char temp[80];

  if (str[0] == '\0')
    return;
  if (str[0] != '/') {
    strcpy(temp, tnn_dir);
    strcat(temp, str);
    strcpy(str, temp);
  }
}

BOOLEAN
read_init_file(int argc, char *argv[])
{
  FILE *init_file_fp;
  int file_end;
  int file_corrupt;
  char line[82];
  char str1[82];
  char str2[82];
  char tmp_str[80];
  int rslt;
  int warning;
  int wrong_usage;
  char *str_ptr;
  int scanned;
  int i;
#ifdef AX_IPX
  int axipx_ports = 0;
#endif
#ifdef AX25IP
  int ax25ip_ports = 0;
#endif

  tnn_buffers = TNN_BUFFERS;
  max_device = -1;
  tokenring_ports = -1;
  used_l1ports = -1;
  kiss_active = FALSE;
  use_socket = FALSE;
  tnn_socket[0] = '\0';
  for (i = 0; i < L1PNUM; i++)
   {
    strcpy(l1port[i].device, "");
    strcpy(l1port[i].tnn_lockfile, "");
    l1port[i].speed = 0;
    l1port[i].speedflag = 0;
    l1port[i].kisstype = KISS_NIX;
    l1port[i].kisslink = -1;
    l1port[i].port_active = FALSE;
    l2ptab[i] = -1;
   }
  for (i = 0; i < L2PNUM; i++)
   {
    l1ptab[i] = -1;
    CLR_L1MODE(i);
    SET_L1MODE(i, MODE_off);
   }
  strcpy(tnn_initfile, "tnn.ini");
  wrong_usage = 0;
  scanned = 1;
  unlock = 0;
  while ((scanned < argc) && (!wrong_usage)) {
    if (strcmp(argv[scanned], "-i") == 0) {
      scanned++;
      if (scanned < argc) {
        strcpy(tnn_initfile, argv[scanned]);
      }
      else wrong_usage = 1;
    }
    else if (strcmp(argv[scanned], "-s") == 0) {
      scanned++;
      if (scanned < argc) {
        strcpy(tnn_socket, argv[scanned]);
        use_socket = TRUE;
      }
      else wrong_usage = 1;
    }
    else if (strcmp(argv[scanned], "-u") == 0) {
      unlock = 1;
    }
    else {
      wrong_usage = 1;
    }
    scanned++;
  }
  if (wrong_usage) {
    printf("Usage : tnn [-i <init-file>] [-s <tnn-socket>] [-u]\n");
    return(TRUE);
  }

  warning = 0;
  if (!(init_file_fp = fopen(tnn_initfile, "r"))) {
    str_ptr = getenv("HOME");
    if (str_ptr != NULL) {
      strcpy(tmp_str, str_ptr);
      strcat(tmp_str, "/");
      strcat(tmp_str, tnn_initfile);
      if (!(init_file_fp = fopen(tmp_str, "r"))) {
        warning = 1;
      }
    }
    else warning = 1;
  }
  if (warning) {
    printf("ERROR: %s not found\n\n", tnn_initfile);
    return(TRUE);
  }
  file_end = 0;
  file_corrupt = 0;
  while (!file_end) {
    if (fgets(line, 82, init_file_fp) == NULL) {
      file_end = 1;
    }
    else {
      if (strlen(line) == 82) {
        file_end = 1;
        file_corrupt = 1;
      }
      else {
        if (line[0] != '#') { /* ignore comment-lines */
          rslt = sscanf(line, "%s %s", str1, str2);
          switch (rslt) {
          case EOF: /* ignore blank lines */
            break;
          case 2:
            if (analyse_value(str1, str2)) {
              file_end = 1;
              file_corrupt = 1;
            }
            break;
          default:
            file_end = 1;
            file_corrupt = 1;
            break;
          }
        }
      }
    }
  }
  fclose(init_file_fp);
  if (file_corrupt) {
    if (line == NULL) line[0] = '\0';
    printf("ERROR: %s is in wrong format, wrong line:\n%s\n\n",
           tnn_initfile, line);
    return(TRUE);
  }
  else {

    for (i = 0; i < L1PNUM; i++)
     {
 #ifdef AX_IPX
      if (l1port[i].kisstype == KISS_IPX)
       {
        if (axipx_ports == 0)
         {
          ++axipx_ports;
         }
        else
         {
          l1port[i].kisstype = KISS_NIX;
         }
       }
#endif
 #ifdef AX25IP
      if (l1port[i].kisstype == KISS_AXIP)
       {
        if (ax25ip_ports == 0)
         {
          ++ax25ip_ports;
         }
        else
         {
          l1port[i].kisstype = KISS_NIX;
         }
       }
#endif
      if (*(l1port[i].tnn_lockfile) != '\0')
        add_tnndir(l1port[i].tnn_lockfile);
     }
    add_tnndir(tnn_errfile);
    add_tnndir(tnn_procfile);
    add_tnndir(tnn_socket);

    if (used_l1ports >= 0) kiss_active = TRUE;
    return(FALSE);
  }
}

BOOLEAN
init_proc(void)
{
  FILE *fp;
  pid_t pid;

  fp = fopen(tnn_procfile, "r");
  if (fp != NULL)                       /* altes tnn.pid vorhanden?     */
   {
    if (fscanf(fp, "%d", &pid) == 1)     /* alte PID lesen               */
     {
      if (kill(pid, 0) != -1)           /* lebt das alte Programm noch? */
       {
        fclose(fp);
        return(FALSE);                  /* lebt noch, also ENDE!        */
       }
     }
    fclose(fp);
   }
  fp = fopen(tnn_procfile, "w+");
  if (fp == NULL) {
    printf("ERROR: Can't create process file\n");
    return(FALSE);
  }
  pid = getpid();
  fprintf(fp, "%d", pid);
  fclose(fp);
  return(TRUE);
}

void
exit_proc(void)
{
  unlink(tnn_procfile);
}

