/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File src/main.c (maintained by: ???)                                 */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

#include <assert.h>

#ifdef __GO32__
#define ptrdiff_t int
#endif

extern int console_login_status;

static void     initvar(void);
static void     main_loop(void);
static void     mainf(void);

static void initvar(void)
{
  int       port, i;
  PORTINFO  *p;
  BEACON   *b;

  memset(mh, 0, sizeof(STAT)*MAXSTAT);

  memset(portstat, 0, sizeof(PORTSTAT)*L2PNUM);

  for (port = 0, p = &portpar[0], b = &beacon[0];
       port < L2PNUM;
       port++, p++, b++)
  {
    sprintf(p->name, "Port%u", port);          /* Portnamen eintragen */

    p->mtu = 256;

    p->l1mode =
    p->l2mode = 0;
    p->l1_tx_timer = 0;
    p->txdelay = 25;
    p->persistance = 128;
    p->slottime = 10;

    p->IRTT = 500;
    p->T2 = 150;
    p->maxframe = 2;
    p->retry = 15;

    p->nmblks =
    p->nmbstn = 0;

#ifdef PACSAT
    pacsat_enabled[port] = FALSE;
#endif
    cpyid(b->beades, "QST   \140");
    b->beadil[0] = b->text[0] = 0;
    b->interval = b->beatim = b->telemetrie = 0;
  }

  for (i = 0; i < MAXSUSPEND; i++)
    *sustab[i].call = 0;

#ifdef GRAPH
  graphclear();
#endif
}


void memerr(void) {
  hputs("*** ERROR: Not enough Memory!\n");
  exit(10);
}

void main(int argc, char *argv[])
{
#if defined(__GO32__) || defined(__DOS16__) || defined(__WIN32__)
  static char *line;
  char drive[MAXDRIVE];
  char path[MAXDIR];
  char name[MAXFILE];
  char ext[MAXEXT];
#endif

  /* Hardwarespezifische Sachen (Uhr nachstellen, UTC ins Enviroment,   */
  /* Kommandozeile auswerten steht jetzt in init_hardware().            */

  if (init_hardware(argc, argv))        /* Hardwarespezifische Sachen   */
    exit(1);

  time(&start_time);                    /* Startzeit merken             */
  clear_time = start_time;

  /**********************************************************************/
  /* Speicher besorgen                                                  */
  /**********************************************************************/

  lnktbl = (LNKBLK *) malloc (sizeof(LNKBLK) * (LINKNMBR ));
  cirtab = (CIRBLK *) malloc (sizeof(CIRBLK) * (NUMCIR   ));
  ptctab = (PTCENT *) malloc (sizeof(PTCENT) * (NUMPAT   ));
  hstubl = (HOSTUS *) malloc (sizeof(HOSTUS) * (MAXHST   ));

  if (lnktbl == NULL ||
      cirtab == NULL ||
      ptctab == NULL ||
      hstubl == NULL
     ) memerr();

  initvar();                            /* Variablen Initialisieren     */

  /**********************************************************************/
  /* Configuration laden                                                */
  /**********************************************************************/
  *confpath = '\0';
#if defined(__GO32__) || defined(__DOS16__) || defined(__WIN32__)
  fnsplit(argv[0],drive,path,name,ext); /* Pfad zu TNN.EXE ermitteln,   */
  strcpy(confpath,drive);               /* dort auch die .cfg Dateien!  */
  strcat(confpath,path);
  strcpy(exename, argv[0]);             /* Name der EXE merken          */
  normfname(exename);                   /* normieren                    */
#endif

  /* wird aus dem aktuellen Verzeichniss gestartet, dann ist das der    */
  /* ConfPath (Dose gibt "" zurueck !)                                  */
#ifndef MC68302                                      /* DL1HAZ 01.02.95 */
  if (*confpath == '\0')             /* sonst wie Atari                 */
    getcwd(confpath,MAXPATH);        /* Aktuelles Verzeichnis, Suchpfad */
  addslash(confpath);
#endif

  if (load_configuration() == FALSE)    /* Configuration laden          */
     hprintf("*** WARNING: Error reading %s.PAS ***\n",cfgfile);
  if (load_stat() == FALSE)             /* Statistik laden              */
     hprintf("*** WARNING: Error reading %s.STA ***\n",cfgfile);

#ifdef MC68302
  strcpy(confpath, textpath);
  strcpy(msgpath, textpath);
#else

  xchdir(textpath);                     /* Aktuelles Laufwerk und Pfad  */
#if defined(__GO32__) || defined(__DOS16__) || defined(__WIN32__)
  line = malloc(MAXPATH);               /* Pfad zu den Konfigurations-  */
  strcpy(line,"CONFPATH=");             /* dateien                      */
  strcat(line,confpath);
  if (putenv(line) == -1)
    printf("*** WARNING: Enviroment full ***\n");
  line = malloc(MAXPATH);               /* Temporaerpfad umleiten       */
  strcpy(line,"TMP=");
  strcat(line,textpath);
  if (putenv(line) == -1)
    printf("*** WARNING: Enviroment full ***\n");
#ifdef __GO32__
  line = malloc(MAXPATH);               /* Temporaerpfad umleiten        */
  strcpy(line,"TMPDIR=");
  strcat(line,textpath);
  if (putenv(line) == -1)
    printf("*** WARNING: Enviroment full ***\n");
#endif
#endif
  if (getenv("MSGPATH") == NULL) {
#if defined(__GO32__) || defined(__DOS16__) || defined(__WIN32__)
     line = malloc(MAXPATH);
     strcpy(line,"MSGPATH=");            /* MSGPATH auf TEXTPATH setzten */
     strcat(line,textpath);
     if (putenv(line) == -1)
       printf("*** WARNING: Enviroment full ***\n");
#endif
  }
  else
    strcpy(msgpath,getenv("MSGPATH"));

#endif

#ifndef MC68302
  init_rs232();                         /* Schnittstellen               */
  init_host();                          /* Host-Schnittstelle           */
  init_timer();                         /* Timer initialisieren         */
#else
  init_host();                          /* Host-Schnittstelle           */
  init_timer();                         /* Timer initialisieren         */
  mem_init();
#endif

  /**********************************************************************/
  /* Software initialisieren                                            */
  /**********************************************************************/

  l1init();                             /* Level 1 initialisieren       */
  l2init();                             /* L2                           */
  l3init();                             /* L3                           */
  initl4();                             /* L4                           */
  initl7();                             /* L7                           */
#ifdef PACSAT
  pacsat_init();                        /* PACSAT-Broadcast             */
#endif
#ifdef IPROUTE
  ipinit();                             /* IP-Router initialisieren     */
#endif
  init_mh();                            /* MHEARD Liste laden           */

  mainf();                              /* ab in die Hauptschleife      */

  exit(0);                              /* hierhin kommen wir niemals!  */
}

#ifdef ST
char *wowarich;
#endif

/************************************************************************/
/* die Hauptschleife                                                 ---*/
/*----------------------------------------------------------------------*/
static void main_loop(void)
{
  dbg("l2"); l2();
   dbg("l3rx"); l3rx();
     dbg("l7rx"); l7rx();
      dbg("timsrv"); timsrv();
#ifdef PACSAT
      dbg("pacsrv"); pacsrv();
#endif
#ifdef IPROUTE
      dbg("ipserv"); ipserv();
#endif
      dbg("l4rest"); l4rest();
      dbg("l3rest"); l3rest();  /* derzeit Leerfunktion! */
     dbg("l7tx"); l7tx();
   dbg("l4tx"); l4tx();
  dbg("l3tx"); l3tx();
  dbg("l1rxtx"); l1rxtx();
#ifndef MC68K
  dbg("timer"); update_timer();
#endif
}

/************************************************************************/
/* das Programm persoenlich...                                       ---*/
/*----------------------------------------------------------------------*/
static void mainf(void)
{
  /* Startup-Schleife nur fuer die Start-TNB */
  while (startup_running)
  {
      l1rxtx();
#ifndef MC68K
      update_timer();
#endif
      hostsv();
      hostim();
      l7rx();
      l7tx();
     dealml((LEHEAD*)&rxfl); /* waehrend dem Start-Batch sind wir taub */
  }

  hprintf("%s",signon);
  hputid(myid);
  hprintf(")\r"
          "Copyright by NORD><LINK e.V. (c)1998\r"
          "This version is compiled for %d Ports. "
          "Maximum %d L2-Links and %d Circuits.\r"
          "conversd %5.5s-pp (c) dc6iq/dk5sg, TNN-Version by DL1XAO\r\r",
          L2PNUM, LINKNMBR, NUMCIR, strchr(REV, ':')+2);
  hputs("password: ");

/* Die Start-TNB wurde geladen, jetzt koennen wir anfangen */

  LOOP
    main_loop();
}

/************************************************************************/
/* Programm Ende, aufraeumen                                            */
/************************************************************************/
void quit_program(int exit_code)
{
  if (   console_login_status
      || exit_code == -1
#ifdef ST
      || exit_code == 2
#endif
     ) {
    exit_mh();                          /* MH-Liste sichern             */
    save_stat();
#ifndef MC68302                         /*hier nur noch auf Anforderung */
#ifndef DEBUG
    save_parms();                       /* Braucht 500 Buffer!          */
#endif
    personalmanager(SAVE,NULL,NULL);    /* Pers. Daten fuer Convers     */
    exit_timer();                       /* Timer in Ursprungszustand    */
    l1exit();                           /* L1 zuruecksetzen!            */
    exit_hardware();                    /* Andere Hardware in Ursprungs.*/
    exit_host();                        /* Console schliessen           */
#else
    personalmanager(SAVE,NULL,NULL);    /* Pers. Daten fuer Convers     */
    exit_hardware();                    /* Andere Hardware in Ursprungs.*/
#endif

    /* Speicher freigeben */
    free (lnktbl);
    free (cirtab);
    free (ptctab);
    free (hstubl);

    /* und tschuess.... */
    exit(exit_code);
  }
}

/* End of src/main.c */
