/************************************************************************/
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* File include/l3.h (maintained by: ???)                               */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998, 1999 NORD><LINK e.V. Braunschweig                */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig   */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschluss vertrieben, aus-       */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer Amateur-   */
/* funk Software) beigelegen haben, wenden Sie sich bitte an            */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/************************************************************************/

#define L3_RTT_TIME 180        /* Messintervall in Sekunden-Schritten   */
#define MINQUALEDGE 10         /* Aenderungen um diesen Wert fuehren    */
                               /* zum Infocast                          */
#define L3TRIES 3              /* 3 Connectversuche, dann ist Ruhe bis  */
                               /* wir wieder was vom Nachbarn hoeren    */
#define LEARN (59999U)         /* Lernqualitaet                         */
#define HORIZONT (60000U)      /* alles darueber ist ausgefallen        */
#define BCST_ALPHA 10
#define ROUTE_TIMEOUT 21       /* 21 Minuten                            */

#define MESSTIME 180
#define DEFAULT_LT  10         /* fuer alle unbekannten Ziele           */

/* Layer 3 Mode Flags --------------------------------------------------*/

#define DG 1
#define VC 2
#define VC_FAR 4
#define OPTIONS_MASK (DG+VC+VC_FAR)
#ifdef FLEXHOST                /* Hosting auch fuer FlexNet-Fernziele?  */
#define HOST_MASK (VC+VC_FAR+DG)
#else
#define HOST_MASK (VC+DG)
#endif

/* Layer 3 Nodes Options -----------------------------------------------*/

#define OPT_SSID_RANGE 0x100       /* SSID-Bereich anzeigen             */
#define OPT_ALIAS      0x200       /* ALIAS ausgeben                    */
#define OPT_VCTEST     0x400       /* VC Routentest                     */
#define OPT_DGTEST     0x800       /* DG Routentest (NRR)               */

#define MATCHONE        '?'             /* NODES-Befehl Masken          */
#define MATCHMANY       '*'
#define MATCHEND        0x0
#define MAXMASK         12
#define ISCALLMASK      (1<<0)
#define ISIDENTMASK     (1<<1)
#define ISMINQUAL       (1<<2)
#define ISMAXQUAL       (1<<3)
#define ISNBRCALL       (1<<4)

/* Layer 3 Broadcast Typs ----------------------------------------------*/

#define ALL 1                  /* alle Nodes broadcasten                */
#define CHANGES 2              /* nur Aenderungen broadcasten           */

void flex_status(PEER *, WORD);
void local_status(PEER *, WORD);

#define LEARNQUAL    2      /* Qualitaet eines Fastlearns            */

#define DONT_CHANGE_QUAL 65535U     /* Qualitaet nicht aendern       */
#define DONT_CHANGE_SSID (-1)       /* SSID nicht aendern            */
#define DONT_CHANGE_ALIAS (nulide)  /* Alias nicht aendern           */
#define DONT_CHANGE_LT   (-1)       /* LT nicht aendern              */

/* INP Option Codes                                                  */

#define INP_ALIAS       0               /* Alias                        */
#define INP_IPA         1               /* IP-Adresse + Subnet          */

/* Kennung fuer IP-Frames ueber Netrom                                  */

#define L3TCPUDP 0

/* End of include/l3.h */
