/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1996  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* ALAS (Allgemeine Lizenz fr Amateurfunk Software).                   */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braundschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"
#include "hardware.h"

#ifdef EXTDEV

#include "api.h"

unsigned dev_irq = 0;

/* den Device-API call durchfhren */
void call_api(struct dev_data far *d)
{
    void far (*call_device)(struct dev_data far *);
    char far *cptr;

    cptr = (char far *) getvect(dev_irq);
    call_device = (void far *) (*((unsigned long far *)(cptr+8)));
    call_device(d);
}

/* Anzahl der Kanaele holen */
int l1_enum_ports(void)
{
    struct dev_data api_d;
    api_d.api_code = API_NEXTCHAN;
    call_api(&api_d);
    return api_d.return1;
}

/* einen Kanal initialisieren */
int l1_init_port(unsigned port, unsigned baud, unsigned mode)
{
    struct dev_data api_d;
    api_d.api_code = API_INITCHAN;
    api_d.channel = port;
    api_d.arg2 = baud;
    api_d.arg4 = mode;
    call_api(&api_d);
    return api_d.return1;
}

/* das naechste Frame empfangen */
void far *l1_rx_frame(void)
{
    struct dev_data api_d;
    api_d.api_code = API_RXFRAME;
    call_api(&api_d);
    return MK_FP(api_d.return2, api_d.return1);
}

/* einen Sende-Buffer holen */
L1FRAME far *l1_get_txbuf(unsigned port)
{
    struct dev_data api_d;
    api_d.api_code = API_GETBUF;
    api_d.channel = port;
    call_api(&api_d);
    return MK_FP(api_d.return2, api_d.return1);
}

/* den Sender anstossen */
void l1_kick(void)
{
    struct dev_data api_d;
    api_d.api_code = API_TXFRAME;
    call_api(&api_d);
}

/* Calibrierung durchfuehren */
void l1_calibrate(unsigned port, unsigned minutes)
{
    struct dev_data api_d;
    api_d.api_code = API_TXCALIB;
    api_d.channel = port;
    api_d.arg2 = minutes;
    call_api(&api_d);
}

/* den Kanal-Status abfragen */
unsigned l1_state(unsigned port)
{
    struct dev_data api_d;
    api_d.api_code = API_GETSTATE;
    api_d.channel = port;
    call_api(&api_d);
    return api_d.return1;
}

/* die Kanal"skalierung" abfragen */
unsigned l1_scale(unsigned port)
{
    struct dev_data api_d;
    api_d.api_code = API_GETSCALE;
    api_d.channel = port;
    call_api(&api_d);
    return api_d.return1;
}

/* den Hardwarenamen eines Kanals holen */
char far *l1_ident(unsigned port)
{
    struct dev_data api_d;
    api_d.api_code = API_GETIDENT;
    api_d.channel = port;
    call_api(&api_d);
    return MK_FP(api_d.return2, api_d.return1);
}

/* ist dieser Kanal aktiv? */
int l1_active(unsigned port)
{
    struct dev_data api_d;
    api_d.api_code = API_ISACTIVE;
    api_d.channel = port;
    call_api(&api_d);
    return api_d.return1;
}

/* die L1-Statistik lesen bzw lschen */
L1STATISTICS far *l1_stat(unsigned port, int del)
{
    struct dev_data api_d;
    api_d.api_code = API_GETSTAT;
    api_d.channel = port;
    api_d.arg2 = del;
    call_api(&api_d);
    return MK_FP(api_d.return2, api_d.return1);
}

int find_devirq(void)
{
    char far *p;
    unsigned irq;

    for (irq = 0x60; irq <= 0xF0; irq++) { /* freien IRQ suchen */
        if ((p = (char far *)getvect(irq)) != NULL) {
            if (_fmemcmp(p,(char far*)"FlexNet",7)==0)
            {   /* schon installiert */
                dev_irq = irq;
                return 1;
            }
        }
    }
    return 0;
}

#endif

/* End of API.C */
