/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

char orgnod[7];                     /* Call des Quellknotens            */
char desnod[7];                     /* Call des Zielknotens             */
char time_to_live;                  /* Restlebensdauer des Frames       */

/* lokale Funktionen */
void send_l3srtt_frame(PEER *);
void discnbp(PEER *);
void mstatus(PEER *, WORD status);
void clear_dests(void);
void brosnd(MBHEAD **, PEER *);
void flexsrv(void);
void localsrv(void);
void inform_peer(PEER *, int);
void changealias(int, char *, char *);
static WORD nodprm(char *, WORD, UBYTE *, UWORD *, UBYTE *);
static BOOLEAN rx_inp_broadcast(PEER *, MBHEAD *);
static void request_nrr(char *, UID);
static void nrr2usr(NRRLIST *);
static void send_nrr_frame(NRRLIST *);
static void nrr_rx(MBHEAD *, PEER *);
void add_inp_info(MBHEAD **mbpp, NODE *node, PEER *topp, unsigned qualit,
unsigned last_qualit, int lt);

void memerr(void);

int max_nodes = MAX_NODES;      /* Default-Werte fuer den Network-Heap  */
int max_peers = MAX_PEERS;
UWORD max_lt    = 30;           /* Maximale LT                          */
int num_nodes_max = 0;          /* bisher max. registrierte Nodes       */

#define DIRTY   60001U

/************************************************************************\
*                                                                        *
* Netzwerk-Heap initialisieren                                           *
*                                                                        *
\************************************************************************/
void init_network(void) {
  char *s;

  if ((s = getenv("TNNCFG")) != NULL)
    sscanf(s, "%d,%d", &max_nodes, &max_peers);

  max_nodes = max(max_nodes, 1);
  max_peers = max(max_peers, 1);
  if (!register_network(max_peers, get_next_prim(max_nodes)))
    memerr();
  xprintf("*** NETWORK startup, %d Nodes, %d Neigbours\n",
      netp->max_nodes, netp->max_peers);
}

/************************************************************************\
*                                                                        *
* Initialisierung des Level 3                                            *
*                                                                        *
* FlexNet und Net/ROM Router intialisieren, Ziellisten loeschen.         *
*                                                                        *
\************************************************************************/
void l3init(void)               /* Level 3 initialisieren               */
{
  inithd(&l3rxfl);              /* Liste empfangene Frames loeschen     */
  inithd(&l3txl);               /* Liste zu sendende Frames loeschen    */
  init_network();
}

/************************************************************************\
*                                                                        *
* Informationstransfer von Level3 zum Level2                             *
* Uebergeben werden reine Datenpackete ohne AX.25-Header. Diese werden   *
* dann an den angegebenen Link gehaengt und mit der gewuenschten PID     *
* gesendet.                                                              *
*                                                                        *
\************************************************************************/
void i3tolnk(UBYTE pid, LNKBLK *linkp, MBHEAD *imbp)
{
  imbp->l2fflg = pid;               /* PID uebernehmen                  */
  relink((LEHEAD *)imbp,            /* -> ab in den Link                */
         (LEHEAD *)linkp->sendil.tail);
  ++linkp->tosend;                  /* ein Sendepaket mehr              */
  linkp->noatou = ininat;           /* wieder Aktivitaet                */
  ptctab[g_uid(linkp, L2_USER)].infotx += imbp->mbpc;
  return;
}

/************************************************************************\
*                                                                        *
* Informationstransfer von Level2 zum FlexNet-Router                     *
* Fuer jedes empfangene Packet wird die Flexnet-Behandlungsroutine       *
* aus FLEXNET.C aufgerufen.                                              *
*                                                                        *
\************************************************************************/
void flexnet_rx(PEER *pp)
{
  MBHEAD *mbp;

  /* Zunaechst empfangene Frames verarbeiten, bis Liste leer...         */
  while (  (mbp = (MBHEAD *) (pp->rxfl.head))
         != (MBHEAD *) &(pp->rxfl)) {
    ulink((LEHEAD *)mbp);           /* Packet aus der Liste aushaengen  */
    flex_rx(pp, mbp);               /* Auswertung durchfuehren          */
    dealmb(mbp);                    /* fertig, Buffer freigeben         */
  }
}

/************************************************************************\
*                                                                        *
* Das Frame mit der gewuenschten Kennung vergleichen. Wenn ja,           *
* wird sie ueberlesen, sonst wird mbbp/mbgc restauriert.                 *
*                                                                        *
\************************************************************************/
BOOLEAN match(MBHEAD *fbp, char *text)
{
  char huge *mbbp;                  /* Sicherung von mbbp               */
  UWORD      mbgc;                  /* Sicherung von mbgc               */

  mbbp = fbp->mbbp;                 /* Position im Frame (mbbp,mbgc)    */
  mbgc = fbp->mbgc;                 /* merken, falls kein Erfolg        */
  while (*text) {                   /* die Kennung durchgehen           */
    if (getchr(fbp) != *text++) {   /* Abweichung!                      */
      fbp->mbbp = mbbp;             /* auf die alte Position im Frame   */
      fbp->mbgc = mbgc;             /* zurueckgehen                     */
      return (FALSE);               /* Kennung stimmt nicht             */
    }
  }
  return (TRUE);                    /* Kennung stimmt                   */
}

int rtt2qual(unsigned long rtt) {   /* Lautzeit zu Qualitaet            */
  int qual;

  if (rtt) {
    qual = 255-(unsigned)(rtt/autoqual);
    if (qual > 254) qual = 254;
    if (qual < 3) qual = 3;
    return (qual);
  }
  return (0);                       /* ausgefallen                      */
}

int qual2rtt(unsigned qual) {       /* Qualitaet zu Laufzeit            */
  if (qual < 2) return (0);         /* unereichbar                      */
  return (256-qual)*autoqual;
}

void fastlearn(PEER *pp,            /* FASTLEARN eines Zieles           */
char *id) {                         /* (wenn noetig)                    */
  int index = find_node_this_ssid(id);
  char notify_call1[10];
  char notify_call2[10];

  if (index != -1)                  /* Node bekannt und Qualitt gut    */
    if (pp->routes[index].quality)  /* dann nicht lernen                */
      return;
  if ((index = add_route(pp, id, LEARN)) != -1) {
    update_lt(pp, index, DEFAULT_LT);
    call2str(notify_call1, orgnod);
    call2str(notify_call2, pp->l2link->call);
    notify(7, "fastlearn %s via %s",
           notify_call1, notify_call2);
  }
}

void rtt_metric(PEER *pp, long rtt) {
  BEACON   *beapoi;             /* Zeiger auf einen Baken-Eintrag       */
  int       i;
  MBHEAD   *mbp;
  struct    tm *p;
  LNKBLK   *lp;
  PTCENT   *ptcp;
  int       telemetrie;

  p = localtime(&sys_time);

  /* fuer alle Ports, bei denen die Bake freigegeben ist.. */
  for (i=0, beapoi=beacon; i<L2PNUM; ++beapoi, ++i) {
    if ((telemetrie = beapoi->telemetrie) >= 2) {
      (mbp = (MBHEAD *) allocb())->l2fflg = 0xF0;
      lp = pp->nbrl2l;
      ptcp = ptctab + g_uid(lp, L2_USER);
      if (telemetrie != 2) { /* Format fuer automatische Auswertung */
          mbp->l4time = mbp->mbpc;
          putid(pp->l2link->call, mbp);   /* Node Call              */
          putspa(10, mbp);
          putprintf(mbp,"%2d %02d.%02d.%02d %02d:%02d:%02d ",
                        lp->liport,
                        p->tm_mday, p->tm_mon+1, p->tm_year % 100,
                        p->tm_hour, p->tm_min, p->tm_sec);
          putprintf(mbp, "%7lu %7lu %7lu %7lu %7lu %lu\r",
                         rtt*10L,
                         pp->quality*10L,
                         pp->my_quality*10L,
                         pp->his_quality*10L,
                         lp->SRTT*10L,
                         ptcp->inforx+ptcp->infotx);
      } else {
          putprintf(mbp, "%02d.%02d.%02d %02d:%02d:%02d ",
                         p->tm_mday, p->tm_mon+1, p->tm_year % 100,
                         p->tm_hour, p->tm_min, p->tm_sec);
          putid(pp->l2link->call, mbp);   /* Node Call              */
          putprintf(mbp, "(%02d)\rL3RTT=%lums L3SRTT=%lums (%lums/%lums) L2SRTT=%lums SUM=%lu\r",
                     lp->liport,
                     rtt*10L,
                     pp->quality*10L,
                     pp->my_quality*10L,
                     pp->his_quality*10L,
                     lp->SRTT*10L,
                     ptcp->inforx+ptcp->infotx);
      }
      rwndmb(mbp);
      sdui(beapoi->beadil, "METRIC\140", myid, i, mbp);
      dealmb(mbp); /* Telemetrie-Frame kann jetzt weg */
    }      /*Telemetrie*/
  }        /*alle Ports*/
}

/* Wenn sich die Info zu einem Node ndert, werden alle INP-Routes
 * zur Aktualisierung ausgeschrieben.
 */
void propagate_node_update(int index)
{
  PEER  *pp;
  ROUTE *rp;
  int    max_peers = netp->max_peers;
  int    i;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++) {
    if (!pp->used) continue;
    if (pp->typ != INP) continue;
    rp = pp->routes + index;
    if (rp->reported_quality) /* nur wenn wir gemeldet hatten */
      rp->reported_quality = DIRTY;
  }
}

/************************************************************************\
*                                                                        *
* Informationstransfer von Level2 zum NET/ROM-Router                     *
* Die empfangenen Frames fuer den Nachbarn werden ausgewertet und        *
* an den eigenen L4 (Verbindungsebene) oder an einen anderen Nachbarn    *
* weitergeleitet.                                                        *
* Bestimmte Ausnahmesituationen wie Link-Schleifen und aehnliches        *
* werden erkannt und Gegenmassnahmen eingeleitet.                        *
* - wird ein eigenes Packet von einem Nachbarn zurueckgeschickt, dann    *
*   wird der Weg zu dem Node ueber diesen Nachbarn fuer ungueltig        *
*   erklaert, bis der Nachbar uns einen neuen Weg meldet.                *
* - wenn wir ein Frame an den gleichen Nachbarn zurueckschicken wuerden, *
*   von dem es gekommen ist, wird das Frame vernichtet und unser         *
*   Weg fuer ungueltig erklaert.                                         *
* Linkausfaelle und diese Ausnahmesituationen werden durch einen         *
* on-demand Broadcast sofort Netzweit bekanntgemacht.                    *
* Im Gegensatz zu anderen NET/ROM-Implementierungen uebertraegt          *
* TheNetNode die Broadcast-Informationen wahlweise auch in Info-         *
* Frames.                                                                *
* Der Router unterstuetzt parallele Lastenverteilung auf mehrere Routen, *
* dabei wird die Linkqualitaet und der Belastungsgrad des Links          *
* beruecksichtigt.                                                       *
* Um immer Moeglichst viele alternativen Wege zu einem Ziel zu haben,    *
* verwendet TheNetNode __NICHT__ das von DL1GJI vorgeschlagene Poison    *
* Reverse, sondern meldet seinen Nachbarn immer den besten der           *
* alternativen Wege zurueck. Die Vorteile dieses Verfahrens wurden       *
* von DB7KG in DP[45]TNN veroeffentlicht.                                *
* Die 1. Implementierung und viele Ideen fuer den verbesserten L3        *
* stammen von Daniel, ON5ZS.                                             *
* Diese wurde um einige wesentliche Details von DB7KG und DG1KWA         *
* erweitert. Hierzu gehoert eine Broadcast-Daempfung (MINQUALEDGE),      *
* ein verbessertes Verhalten bei instabilen Links durch die getrennte    *
* Speicherung von empfangener und aktueller Qualitaet und einem          *
* nach Prioritaeten arbeitender L3-Packetvermittlung.                    *
* Das RxQ/TxQ/Qua/PathQ-Konzept ersetzt das von DL1GJI vorgeschlagene    *
* Konzept der Schattentabelle und bietet neben einer hoeheren            *
* Integritaet der Qualitaets-Werte (keine Verzoegerung durch das         *
* Update-Interval) auch ein besseres Verhalten bei schnell aendernden    *
* Linksituationen sowie eine hoehere Transparenz fuer den Sysop.         *
*                                                                        *
* RxQ bezeichnet die letzte empfangene Qualitaet eines Weges             *
*                                                                        *
* TxQ bezeichnet die letzte gesendete Qualitaet dieses Weges             *
*                                                                        *
* Qua bezeichnet die aktuelle eigene Qualitaet des Weges. Dieser Wert    *
*     entscheidet ueber den on-event-Broadcast eines Nodes. Steigt       *
*     oder faellt die Qualitaet um mehr als MINQUALENDE (3) Punkte,      *
*     wird ein sofortiger Broadcast ausgeloest. Das tendenzielle         *
*     steigen und sinken der Wegqualitaet wird in der N <call> Ausgabe   *
*     durch ein +/-/  in der Wegzeile angezeigt.                         *
*                                                                        *
\************************************************************************/
void netrom_rx(PEER *rxpp)
{
  char      beaide[6];          /* Ident Rundspruch sendender Knoten    */
  char      rx_alias[7];        /* Ident des Nachbarn (wenn bekannt)    */
  char      ver[12];            /* Version des Nachbarn                 */
  WORD      i,j;                /* Zaehler                              */
  MBHEAD    *mbp;               /* Buffer fuer ein Frame                */
  char      buffer[150];        /* Speicher fuer RTT String-Operationen */
  char      version[4];         /* TNN-Version                          */
  ULONG     prev_tic10;         /* Zeitpunkt der RTT Messung in 10ms    */
  ULONG     prev_l3srtt;        /* letzter SRTT (smoothed RTT)          */
  ULONG     prev_l3rtt;         /* letzter gemessener RTT-Wert          */
  PEER     *rtt_pp;             /* Pointer auf Nachbarliste             */
  char huge *savmbbp;           /* mbbp-Sicherung                       */
  WORD      savmbgc;            /* mbgc-Sicherung                       */
  char      buf2[8];
  ULONG     rtt;
  NODE     *srcnod;
  NODE     *dstnod;
  PEER     *pp;
  MBHEAD   *inpmbp;
  NODE      node;
  MHEARD   *mhp;
  int       mask;
  int       index;
  char      notify_call1[10];
  char      notify_call2[10];
  char      notify_call3[10];

  /* Zunaechst empfangene Frames verarbeiten, bis Liste leer...         */
  while (   (mbp = (MBHEAD *) (rxpp->rxfl.head))
         != (MBHEAD *) &(rxpp->rxfl)) {
    ulink((LEHEAD *)mbp);        /* ein Frame aus der Liste holen       */
    savmbbp = mbp->mbbp;         /* Position im Frame merken (mbbp,     */
    savmbgc = mbp->mbgc;         /* mbgc sichern)                       */
    if (mbp->l2link) {           /* Info Frame ?                        */
      if (rx_inp_broadcast(rxpp, mbp)) { /* INP Broadcast?              */
        dealmb(mbp);
        continue;
      }
      if (   (getfid(orgnod, mbp))      /* Call des Quellknotens holen  */
          && (getfid(desnod, mbp))      /* Call des Zielknotens holen   */
          && (mbp->mbgc < mbp->mbpc)    /* und Info im Frame?           */
         ) {
        if (   valcal(orgnod) == ERRORS /* Absender und Zielrufzeichen  */
            || valcal(desnod) == ERRORS /* pruefen, es koennte ein XNET */
           ) {                          /* in der Naehe sein :-)        */
          call2str(notify_call1, orgnod);
          call2str(notify_call2, desnod);
          call2str(notify_call3, rxpp->l2link->call);
          notify(3,"invalid node %s>%s from %s (flushed)",
                 notify_call1, notify_call2, notify_call3);
                            /* wir sagens dem Sysop         */
          dealmb(mbp);                  /* Frame wegwerfen              */
          continue;                     /* ... und zum naechsten Frame  */
        }
        --(*(mbp->mbbp));               /* Restlebensdauer um 1 runter  */
        time_to_live = getchr(mbp);     /* Restlebensdauer lesen        */

        if ((mbp->mbpc - mbp->mbgc) >= 5)/* ist es lang genug ?         */
        {
          l4hdr0 = getchr(mbp);          /* Header holen                */
          l4hdr1 = getchr(mbp);          /* ist eigentlich Sache des L4,*/
          l4hdr2 = getchr(mbp);          /* aber der L3 verschickt auch */
          l4hdr3 = getchr(mbp);          /* L4-Messframes, deswegen     */
          l4hdr4 = getchr(mbp);          /* wird das schon hier er-     */
          l4opco = l4hdr4 & L4OPMASK;    /* ledigt.                     */

          if (l4opco == L4TCPUDP && l4hdr0 == 0 && l4hdr1 == 1)  /* NRR */
          {
            nrr_rx(mbp, rxpp);
            dealmb(mbp);                 /* Frame wegwerfen             */
            continue;                    /* ... und zum naechsten Frame */
          }

          /*----- Auswertung der eigenen und fremden L3RTT Frames ------*/
          if (   cmpid(desnod,"L3RTT \140")   /* Ziel und Inhalt OK!    */
              && (  cmpid(orgnod,rxpp->l2link->call)
                  || cmpid(orgnod,myid)       /* und von dem Nachbarn   */
                 )
             )
          {                                   /* oder eigenes           */
            if (   (l4opco == L4INFTRA)   )   /* Info-Transfer          */
            {
              if (match(mbp, "BROAD")) {      /* BROAD Kennung ?        */
                if (cmpid(rxpp->l2link->call,orgnod) == TRUE)
                  if (rxpp->typ == TNN)       /* kann der andere Info?  */
                    rx_broadcast(rxpp,mbp);   /* dann auswerten         */
                dealmb(mbp);                  /* Buffer entsorgen       */
                continue;                     /* ... und der naechste   */
              }

              if (match(mbp, "L3RTT:")) {     /* L3RTT Kennung ?        */
                for (i=0;((i<110) && (mbp->mbgc < mbp->mbpc));i++)
                  buffer[i] = getchr(mbp);
                strcpy(&buffer[i] ," 1 2 3 4 5 6 \n\0");

                sscanf(&buffer[0],"%lu %lu %lu %lu %6s %11s %6s",
                       &prev_tic10,
                       &prev_l3srtt,
                       &prev_l3rtt,
                       (long *) &rtt_pp,
                        rx_alias,
                        ver,
                        buf2);
                *version = '\0';
                if(!strncmp(buf2, "TNN", 3))
                  strcpy(version, &buf2[3]);

                for (i=j=0;i<6;i++)
                  if (rx_alias[i] == 0x00 || j == 1 ) {   /* Leerzeichen */
                    rx_alias[i] = ' ';
                    j = 1;
                  }

                /*..........................................................*/
                /* Eigenes Frame auswerten                                  */
                /*..........................................................*/
                if (cmpid(orgnod,myid)) {              /* eigener Absender  */
                  if ( (rtt_pp == rxpp) )              /* passender Nachbar */
                    if (   tic10 > prev_tic10 /* Uhr ist nicht uebergelaufen*/
                        && rxpp->rttstart == prev_tic10/* richtige Messung  */
                        && ((tic10 - prev_tic10) < 10000)/* nicht zu lang!  */
                      )
                    {                                    /* gemessene L3-RTT*/
                      rtt = (tic10 - prev_tic10) + 2;
                      update_peer_quality(rxpp,rtt/2,DONT_CHANGE_QUAL);
                      /* Falls das Timeout auf einer Route mal abfaellt,    */
                      /* melden wir hier wieder die Routen-Qualitaet hoch.  */
                      if ((index = add_route(rxpp,rxpp->l2link->call,1)) != -1)
                        update_lt(rxpp, index, 1);
                      rtt_metric(rxpp,rtt);
                      rxpp->rttstart = 0L;
                      rxpp->rtt_time = L3_RTT_TIME;
                    }
                  dealmb(mbp);
                  continue;
                } /* eigenes L3RTT-Frame */

                /*..........................................................*/
                /* Fremdes L3RTT-Frame auswerten, bzw. an Nachbarn zurueck  */
                /*..........................................................*/
                if (cmpid(rxpp->l2link->call,orgnod) == TRUE ) {
                  if (time_to_live >= 1 ) {         /* noch Restlebenszeit.. */

                    mbp->mbbp = savmbbp;
                    mbp->mbgc = savmbgc;

                    toneig(rxpp, mbp);

                    if (prev_l3srtt > 9999) /* XNET macht falsche Wert! */
                      prev_l3srtt = 9999;   /* nach Oben begrenzen      */

                    if (strnicmp("LEVEL3_V2.1",ver,11) == 0) {
                      if (rxpp->typ == NETROM)
                        set_peer_typ(rxpp, TNN);
                      rxpp->version = atoi(version);
                      cpyals(rxpp->l2link->alias, rx_alias);
                    } else
                      cpyals(rx_alias, rxpp->l2link->alias);

                    if (strstr(buffer, "$N")) {
                      if (rxpp->typ != INP) {
                        set_peer_typ(rxpp, INP);
                        cpyid(node.id, myid);
                        cpyals(node.alias, alias);
                        node.optlen = 0;
                        inpmbp = NULL;
                        add_inp_info(&inpmbp, &node, rxpp, 1, 0, 1);
                        brosnd(&inpmbp, rxpp);
                      }
                    }

                    if (prev_l3srtt >= 5L)
                      update_peer_quality(rxpp,DONT_CHANGE_QUAL,prev_l3srtt);

                    if ((index = add_route(rxpp,rxpp->l2link->call, 1)) != -1) {
                      update_lt(rxpp, index, 1);
                      if (update_alias(index, rx_alias))
                        propagate_node_update(index);
                    }

                    continue;
                  }
                }
              } /* L3RTT: */
            } /* L4-Info-Frame */
            dealmb(mbp);
            continue;
          } /* desnod = L3RTT ... */

          /*............................................................*/
          /*....  Fastlearn eines neuen Knotens  .......................*/
          /*............................................................*/
          /* Frames, die von einem Knoten kommen, der noch nicht in     */
          /* unsere Knoten-Liste eingetragen ist, fuehren zu einem Ein- */
          /* trag des Quell-Knotens mit Qualitaet 2 in unsere Nodes-    */
          /* Liste (Quick-Learn)                 ===                    */

          if (   !cmpid(myid, orgnod)           /* kein eigenes Frame   */
              && !cmpid(myid, rxpp->l2link->call)
             )
            fastlearn(rxpp, orgnod);

                                           /* MH-Liste                  */
          if ((mhp = mh_lookup(&l3heard, orgnod)) == NULL)
            mhp = mh_add(&l3heard);
          if (mhp) {                       /* Eintrag vorhanden?        */
            mh_update(&l3heard, mhp, orgnod, mbp->l2port);
            mhp->rx_bytes += (mbp->mbpc - mbp->mbgc);
          }

          /*----------------- Frame ist fuer mich ----------------------*/
          if (cmpid(myid, desnod)) {       /* Frame an Level 4 geben    */
#ifdef IPROUTE
            if (l4opco == L4TCPUDP) {      /* L3 TCP/UDP-Frame          */
              mbp->l2fflg = L2CIP;         /* es ist ein IP-Frame       */
              relink((LEHEAD *)mbp, (LEHEAD *)iprxfl.tail);
              continue;                    /* Frame verarbeitet         */
            }
#endif

            mbp->l3_typ = L3NORMAL;        /* kein LOCAL und kein L3RTT */
            if (iscall(orgnod,&srcnod,NULL,DG) > 0) /* Absender-Node    */
            {
              l4rx(srcnod, NULL, mbp);
              continue;                    /* naechstes Frame           */
            }
            call2str(notify_call1, orgnod);
            notify(5,"unreachable source node %s", notify_call1);
            dealmb(mbp);                   /* Frame entsorgen           */
            continue;
          }

                                           /* MH-Liste Senderichtung      */
          if ((mhp = mh_lookup(&l3heard, desnod)) != NULL)
            mhp->tx_bytes += (mbp->mbpc - mbp->mbgc);

          /*---- nur CONREQ kann auf L2 umgeroutet werden */
          if ((l4opco == L4CONREQ) || (l4istome(orgnod, desnod)))
              mask = DG|VC|VC_FAR;
          else
              mask = DG;

          /*---- Level 3 Frame nicht fuer mich, sondern weiterleiten -----*/
          if (iscall(desnod, &dstnod, &pp, mask) > 0){ /* Ziel erreichbar? */
            /* wenn das Ziel nicht im DG-Mode erreicht werden kann, dann  */
            /* muessen wir umsetzen.                                      */
            if ((pp->options & DG) == 0) {
              mbp->l3_typ = L3LOCAL;
              mbp->l2link = (LNKBLK*)dstnod; /* Ziel-Node                 */
              if (iscall(orgnod, &srcnod, NULL, DG) > 0)    /* Absender   */
              {
                l4rx(srcnod, dstnod, mbp);
                continue;                    /* naechstes Frame           */
              }
              call2str(notify_call1, orgnod);
              notify(5,"unreachable source node %s", notify_call1);
              dealmb(mbp);                   /* Frame entsorgen           */
              continue;
            }

            if (time_to_live) {              /* noch Restlebensdauer?     */
              mbp->mbbp = savmbbp;
              mbp->mbgc = savmbgc;

              if (cmpid(myid, orgnod))    /* eigenes Frame gehoert, weg   */
              {                           /* damit                        */
                call2str(notify_call1, desnod);
                call2str(notify_call2, rxpp->l2link->call);
                notify(5, "own frame to %s received fm %s (loop)",
                        notify_call1, notify_call2);
                dealmb(mbp);
                continue;
              }

                                          /* Falls wir ein Frame ueber    */
                                          /* den Nachbarn zurckschicken  */
              if (rxpp == pp)             /* wrden, dann vernichten wir  */
              {                            /* es                           */
                call2str(notify_call1, orgnod);
                call2str(notify_call2, desnod);
                call2str(notify_call3, rxpp->l2link->call);
                notify(5,"frame fm %s to %s via %s flushed (neigb loop)",
                       notify_call1, notify_call2, notify_call3);
                dealmb(mbp);
                continue;
              }

              toneig(pp, mbp);           /* Info absetzen                */
              continue;
            }                            /* noch Restlebensdauer         */
          }                              /* Ziel bekannt                 */
        }                                /* Laenge ok                    */
      }                                  /* Info ist im Frame            */
    }                                    /* es ist ein I-Frame           */
    else
    /*...................................................................*/
    /*.  Kein Info-Frame, sondern ein L3 UI-Frame (Broadcast)  ..........*/
    /*.  Erweiterung: Wenn eine Nodes-Bake (Broadcast) gehoert      .....*/
    /*.  wurde und kein L2 Link besteht, dann Verbindung aufbauen! ......*/
    /*...................................................................*/
    {                                    /* UI-Frame                     */
      if (worqua != 0)
      {                                  /* darf Auswertung erfolgen?    */
        if (   mbp->mbgc < mbp->mbpc               /* Info im Frame?     */
            && (getchr(mbp) & 0xFF) == 0xFF        /* stimmt Signatur    */
            && ge6chr(beaide, mbp)                 /* Ident des Knotens  */
           ) {
          int index;

          cpyals(rxpp->l2link->alias, beaide);
          if ((index = add_route(rxpp, rxpp->l2link->call, 1)) != -1) {
            update_lt(rxpp, index, 1);
            if (update_alias(index, beaide))
              propagate_node_update(index);
            rx_broadcast(rxpp, mbp);
          }
        }
      }                             /* Signatur ist gut                  */
    }                               /* Auswertung zulaessig              */
    dealmb(mbp);
  }
}

/*----------------------------------------------------------------------*/
/* l3rx()           Empfangene Frames der Nachbarn verarbeiten.         */
/*----------------------------------------------------------------------*/
void l3rx(void)
{
  PEER *pp;
  int   max_peers = netp->max_peers;
  int   i;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++) {
    if (!pp->used) continue;
    switch (pp->typ) {
      case FLEXNET :
        flexnet_rx(pp);
        break;
      case NETROM  :
      case TNN     :
      case THENET  :
      case INP     :
        netrom_rx(pp);
        break;
    }
  }
}

/*------------------------------------------------------------------------*/
void rx_broadcast(PEER *rxpp, MBHEAD *mbp)
{
  char     desnod[7];
  char     beaide[6];
  char     nbr_call[7];
  int      rx_qual;
  int      index;
  PEER    *pp;
  char     notify_call1[10];
  char     notify_call2[10];
  char     notify_call3[10];

  if (rxpp->typ == INP)
    return;

  while (   (getfid(desnod, mbp))
         && (valcal(desnod))
         && (ge6chr(beaide, mbp))
         && (getfid(nbr_call, mbp))
         && (valcal(nbr_call))
         && (mbp->mbgc < mbp->mbpc)
    ) {
    rx_qual = getchr(mbp) & 0xFF;

    call2str(notify_call1, rxpp->l2link->call);
    call2str(notify_call2, desnod);
    call2str(notify_call3, nbr_call);
    notify(9,"%-9.9s>%-6.6s:%-9.9s Q%u v %-9.9s",
           notify_call1, beaide, notify_call2, rx_qual, notify_call2);

    if (   cmpid(myid, nbr_call) == TRUE  /* nicht ber mich */
        || rx_qual == LEARNQUAL
        || beaide[0] == '#'
       )
      continue;

    if ( cmpid(myid, desnod) == TRUE)     /* nicht uns selber */
      continue;

    switch (rxpp->typ) {
      case NETROM :
      case THENET :
        if (rx_qual < worqua) rx_qual = 0; /* ausgefallen */
        break;
      case TNN    :
        if (rx_qual < 2) rx_qual = 0;      /* ausgefallen */
        break;
    }

    if ((index = add_route(rxpp, desnod, qual2rtt(rx_qual))) != -1) {
      update_lt(rxpp, index, DEFAULT_LT);

      if (!cmpcal(netp->nodetab[index].alias, nulide))
        if (find_best_qual(index, &pp, DG) > 0) /* beste Qualitaet  */
          if (pp != rxpp)
            continue;

      if (update_alias(index, beaide))       /* Alias hat sich gendert */
        propagate_node_update(index);
    }
  }
}

/*------------------------------------------------------------------------*/
BOOLEAN rx_inp_broadcast(PEER *rxpp, MBHEAD *mbp)
{
  char     desnod[7];
  char     beaide[6], *bp;
  int      lt;
  int      qual;
  int      index;
  int      tag;
  int      len, i, ch;
  PEER    *pp;
  char     opt[OPTLEN], *op;
  int      optlen;
  char     notify_call1[10];
  char     notify_call2[10];

  if (*mbp->mbbp != 0xFF)                /* ist es fuer uns?    */
    return (FALSE);

  getchr(mbp);                           /* Kennung uebergehen  */

  while (mbp->mbpc - mbp->mbgc > 10) {

    cpyals(beaide, DONT_CHANGE_ALIAS);   /* Default: kein Alias */

    if (!getfid(desnod, mbp)) break;
    if (valcal(desnod) == ERRORS) break;

    if (rxpp->version > 170 && rxpp->version < 176) {
      qual = get16(mbp);
      lt   = getchr(mbp);
    } else {
      lt   = getchr(mbp);
      qual = get16(mbp);
    }

    /* LT 0 darf nie gesendet werden, hier korrigieren */
    if (lt == 0)
      lt = DEFAULT_LT;
    else
      lt++;

    optlen = 0;
    op     = opt;

    if (rxpp->version > 170 && rxpp->version < 175) {
      /* fehlerhafte Versionen */
      #define ALIAS_ID  1
      while (   ((tag = getchr(mbp)) != 0)
         && (mbp->mbpc - mbp->mbgc > 1)) {
        len = getchr(mbp);
        if (mbp->mbpc - mbp->mbgc < len) return (TRUE);
        switch (tag) {
          case ALIAS_ID :
            for (i = 0, bp = beaide; i < len; i++) {
              ch = getchr(mbp);
              if ((ch < ' ') || (ch > 127))
               {
                call2str(notify_call1, rxpp->l2link->call);
                notify(3,"invalid alias from %s (flushed)",
                          notify_call1);
                return (TRUE);
               }
              *bp++ = ch;
            }
            for (; i < L2CALEN; i++)
              *bp++ = ' ';
            break;
          default :
            while (len-- > 0) getchr(mbp);
        }
      }
    } else { /* korrektes Protokoll */
      /* Das Endkriterium ist hier einfach, wenn weniger Bytes folgen
         als im LEN-Feld angegeben. */
      while (mbp->mbgc < mbp->mbpc) {

        if ((len = getchr(mbp)) > 0)
          len--; /* Lngenbyte selbst abziehen */

        if (mbp->mbpc - mbp->mbgc < len) {
          notify(3, "INP: frame error, len = %u, left = %u",
                    len, (int) (mbp->mbpc - mbp->mbgc));
          break;
        }

        if (len-- < 1)
          break;

        switch (tag = getchr(mbp)) {
          case 0 : /* ALIAS */
            for (i = 0, bp = beaide; i < len; i++) {
              ch = getchr(mbp);
              if ((ch < ' ') || (ch > 127) || (len > L2CALEN))
               {
                call2str(notify_call1, rxpp->l2link->call);
                notify(3,"invalid alias from %s (flushed)",
                          notify_call1);
                return(TRUE);
               }
              *bp++ = ch;
            }
            for (; i < L2CALEN; i++)
              *bp++ = ' ';
            break;
          default :
            if (optlen + len + 2 < OPTLEN) { /* es ist noch Platz */
              optlen += len + 2;
              *op++ = len;
              *op++ = tag;
              while (len-- > 0)
                *op++ = getchr(mbp);
            } else {
              optlen = OPTLEN+1;
              while (len-- > 0) getchr(mbp); /* Optionen ignorieren */
            }
        }
      }
    }

    if (cmpid(myid, desnod))
     {
      call2str(notify_call1, myid);
      call2str(notify_call2, rxpp->l2link->call);
      notify(3,"destination %s received from %s (ignored)",
             notify_call1, notify_call2);
      continue;
     }

    call2str(notify_call1, rxpp->l2link->call);
    call2str(notify_call2, desnod);
    notify(9,"%-9.9s>%-6.6s:%-9.9s Q%u LT%u",
           notify_call1, beaide, notify_call2, qual, lt);

    if (lt > max_lt)                 /* Nach Laufzeit runterzwingen  */
      qual = 0;

    if (optlen > OPTLEN)             /* Option passte nicht, dann    */
      optlen = 0;                    /* ganz vergessen.              */

    if (cmpid(rxpp->l2link->call, desnod))   /* der Nachbar selbst   */
      qual = lt = 1;

    if ((index = add_route(rxpp, desnod, qual)) != -1) {
      update_lt(rxpp, index, lt);

      if (!cmpcal(netp->nodetab[index].alias, nulide))
        if (find_best_qual(index, &pp, DG) > 0) /* beste Qualitaet  */
          if (pp != rxpp)
            continue;
      /* Der primre Weg hat sich gendert, wir bernehmen Node-Info
         sofern vorhanden (Alias, Options). Leere Options oder Alias
         lschen nicht den letzten Wert. */
      if (   update_alias(index, beaide)
          || update_opt(index, opt, optlen)
         ) propagate_node_update(index);
    }
  }                       /* bis Frameende                           */
  return (TRUE);
}


/*......................................................................*/
/*..  Empfangsliste abgearbeitet, nun zu sendende Frames verarbeiten  ..*/
/*......................................................................*/
void l3tx(void)                 /* Level 3 Service                      */
{
  UWORD   rxgetc;               /* Getcount des Frames                  */
  MBHEAD *mbp;                  /* Pointer auf aktuellen Framekopf      */
  NODE   *dstnod;
  PEER   *bestpp;
  MHEARD *mhp;

                                /* solange L3-Sende-Liste nicht leer    */
  while (   (mbp = (MBHEAD *) l3txl.head)
         != (MBHEAD *) &l3txl.head
        ) {
    ulink((LEHEAD *)mbp);                   /* Frame aushaengen         */
    dstnod = (NODE *) mbp->l2link;          /* Pointer aus Nachbarn     */

    if (   nmbfre > 14                      /* Platz im Speicher?       */
        && (valcal(dstnod->id) == TRUE)
        && find_best_qual((int)(dstnod-netp->nodetab), &bestpp, DG) > 0
       ) {
      rwndmb(mbp);                      /* Pointer auf Ausgangsstellung */
      getchr(mbp);                      /* alles initialisieren         */
      --mbp->mbbp;
      rxgetc = mbp->mbpc;               /* Framelaenge merken           */
      mbp->mbpc = 1;                    /* auf Anfang                   */
      putfid(myid, mbp);                /* Absender ins Frame           */
      putfid(dstnod->id, mbp);          /* Ziel ins Frame               */
      *(mbp->mbbp -1) |= 1;             /* Ende der Adresse setzen      */
      putchr(timliv, mbp);              /* Lebensdauer setzen           */
      mbp->mbpc = rxgetc;               /* Putcount zurueck             */
      rwndmb(mbp);                      /* Pointer wieder aufziehen     */
      toneig(bestpp, mbp);              /* Frame an besten Nachbarn     */
                                        /* MH-Liste                     */
      if ((mhp = mh_lookup(&l3heard, dstnod->id)) != NULL)
        mhp->tx_bytes += (mbp->mbpc);
    }
    else                                /* kein Ziel def. o. kein Platz */
      dealmb(mbp);                      /* Frame wegwerfen              */
  }
}

/*......................................................................*/
/*....  sonstige Funktionen abarbeiten  ................................*/
/*......................................................................*/
void l3rest(void)
{
}

/*----------------------------------------------------------------------*/
/* Nachbarn disconnecten                                                */
/* Wir brauchen nicht den disconnect weiterzumelden, das macht der L2,  */
/* wenn alle Infos gesendet sind.                                       */
/*----------------------------------------------------------------------*/
void discnbp(PEER *nbpx)
{
  LNKBLK *save_lp;

  save_lp = lnkpoi;
  if ((lnkpoi = nbpx->nbrl2l) != NULL)
    dsclnk();                       /* disconnect link, dealml ...      */
  lnkpoi = save_lp;
}

void sdl3ui(PEER *pp, MBHEAD *mbp)      /* UI-Broadcast senden           */
{
  if (pp->l2link->digil[0] == 0)        /* direkter Nachbar              */
    sdui("",                            /* Level 2 senden                */
     "NODES \140",                      /* an das Ziel "NODES"           */
     myid,
     pp->l2link->port,
     mbp);
  else
    sdui(pp->l2link->digil,             /* Level 2 senden                */
     pp->l2link->call,
     myid,
     pp->l2link->port,
     mbp);
  dealmb(mbp);                          /* Buffer wieder freigeben       */
}

/*-----------------------------------------------------------------------*/
void brosrv(void)
{
  static int tim60 = 1;
  int        index;
  NODE      *np;
  ROUTE     *rp;
  PEER      *pp;
  int        i;
  int        max_peers = netp->max_peers;
  int        max_nodes = netp->max_nodes;
  static int tim10 = 1;
  int        broint;

  flexsrv();                        /* Time-Server der anderen Module   */
  localsrv();

  if (++tim60 > 60)                 /* eine Minute vorbei               */
    tim60 = 0;

  if (++tim10 > 10) {               /* 10 Sekunden vorbei               */
    drop_unreachable_nodes();
    tim10 = 0;
  }

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++) {
    if (!pp->used) continue;

    if (tim60 == 0)                 /* am Anfang jeder Minute           */
      for (index = 0, np = netp->nodetab, rp = pp->routes;
           index < max_nodes;
           index++, np++, rp++)
        if (np->id[0]) {
          if (rp->lt > max_lt)
            update_route(pp, index, 0);
          if (pp->secured) {        /* wurde auf "sicher" geschaltet    */
            rp->timeout = 0;
          } else {
            if (rp->timeout) {
              if (--rp->timeout == 0)
                update_route(pp, index, 0);
            } else
              rp->timeout = ROUTE_TIMEOUT;
          }
        }
    if (pp->typ > NETROM)
      continue;

    if (nmbfre < 300)               /* nicht mehr genug Speicher        */
      continue;

    if (pp->nbrl2l == NULL) {     /* noch kein Link                     */
      /* den grossen UI-Broadcast sparen wir uns, uns hoert ja          */
      /* eh keiner.                                                     */
      continue;
    }

    /* wenn der Link sich noch im Aufbau befindet oder total            */
    /* verstopft ist, wird die Nodes-Information zurueckgehalten.       */
    if (   pp->nbrl2l->state < L2SIXFER
        || pp->nbrl2l->tosend > 40 /* Link ist voll                     */
       )
      continue;

    /* Bei INP senden wir erst los, wenn beide Messungen da sind.       */
    if (pp->typ == INP)
      if (!pp->my_quality || !pp->his_quality)
        continue;

    if (tim10 == 0 && pp->typ != THENET)
      inform_peer(pp,CHANGES);      /* nur die Aenderungen durchsagen   */

    if (pp->typ != INP) {
      broint = (pp->typ == TNN) ? broint_i : broint_ui;

      if (++pp->brotim > broint) {  /* Broadcast anfordern              */
        pp->brotim = 0;
        inform_peer(pp,ALL);        /* und weg damit                    */
      }
    } else
      pp->brotim = 0;
  }
}

/************************************************************************/
/*                                                                      */
/* "send broadcast"                                                     */
/*                                                                      */
/* Ein Broadcast-Frame auf die Reise schicken. Es wird je nach Nachbar- */
/* typ als UI oder als I-Frame gesendet. "nodemb" wird auf NULL ge-     */
/* setzt, um einen fehlenden Node-Buffer zu signalisieren. Der naechste */
/* Aufruf von addbro() erzeugt dann ein neues Broadcast-Frame.          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void brosnd(MBHEAD **mbpp, PEER *pp)
{
  if (*mbpp==NULL) return;

  rwndmb(*mbpp);               /* vor dem Senden Buffer zurueckspulen  */

  if ((*mbpp)->l3_typ == L2CI) /* Als I-Frame ueber den Link senden    */
    toneig(pp, *mbpp);
  else {
    (*mbpp)->l2fflg=L2CNETROM; /* Als UI-Bake rausschicken an "NODES"  */
    sdl3ui(pp, *mbpp);         /* PID = Level 3                        */
  }
  *mbpp = NULL;                /* und Buffer loeschen                  */
}

/************************************************************************/
/*                                                                      */
/* "add broadcast"                                                      */
/*                                                                      */
/* Einen Weg zu dem Broadcast-Frame fuer einen Nachbarn hinzufuegen.    */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void add_netrom_info(MBHEAD **mbpp, NODE *node, PEER *topp, PEER *viapp,
unsigned qualit) {
  int qual = rtt2qual(qualit);

  /* schlechte Wege werden unterdrckt, aber abgemeldet.                */
  if (   qual <= worqua
      && qual > 0)
    return;

  if (*mbpp)
    if ( ((*mbpp)->mbpc + 21) > 256 )    /* bis Frame voll              */
      brosnd(mbpp, topp);

  if (*mbpp == NULL) {                   /* neues Frame holen           */
    (*mbpp = (MBHEAD *)allocb())->l3_typ = L2CUI;
    putchr(0xFF, *mbpp);
    pu6chr(alias, *mbpp);
  }

  putfid(node->id, *mbpp);               /* Call des Zieles             */
  pu6chr(node->alias, *mbpp);            /* Ident des Zieles            */
  if (qualit && viapp)
    putfid(viapp->l2link->call, *mbpp);  /* Nachbar des Zieles          */
  else
    putfid(myid, *mbpp);                 /* Nachbar geloescht           */
  putchr(rtt2qual(qualit), *mbpp);
}

/************************************************************************/
/*                                                                      */
/* "add thenet broadcast"                                               */
/*                                                                      */
/* Einen Weg zu dem Infocast-Frame fuer einen Nachbarn hinzufuegen.     */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void add_thenet_info(MBHEAD **mbpp, NODE *node, PEER *topp, PEER *viapp,
unsigned qualit)
{
  if (*mbpp)
    if ( ((*mbpp)->mbpc + 21) > 256 )    /* bis Frame voll              */
      brosnd(mbpp, topp);

  if (*mbpp == NULL) {                   /* neues Frame holen           */
    (*mbpp = (MBHEAD *)allocb())->l3_typ = L2CI;
    putfid(myid, *mbpp);                 /* von eigenes Call            */
    putfid("L3RTT \140", *mbpp);         /* an Pseudo-Destination       */
    *((*mbpp)->mbbp -1) |= 1;            /* EOA setzen                  */
    putchr(0x02, *mbpp);                 /* Lifetime = 2                */
    putchr(0x00, *mbpp);                 /* Circuit-Index               */
    putchr(0x00, *mbpp);                 /* Circuit-ID                  */
    putchr(0x00, *mbpp);                 /* TX-Sequence-Number          */
    putchr(0x00, *mbpp);                 /* RX-Sequence-Number          */
    putchr(0x05, *mbpp);                 /* OpCode & Flags              */
    putstr("BROAD", *mbpp);              /* Framekennung                */
  }

  putfid(node->id, *mbpp);               /* Call des Zieles             */
  pu6chr(node->alias, *mbpp);            /* Ident des Zieles            */
  if (qualit && viapp)
    putfid(viapp->l2link->call, *mbpp);  /* Nachbar des Zieles          */
  else
    putfid(myid, *mbpp);                 /* Nachbar geloescht           */
  putchr(rtt2qual(qualit), *mbpp);
}

/************************************************************************/
/*                                                                      */
/* "add internode protocol route information"                           */
/*                                                                      */
/* Einen Weg zu dem Routing-Info-Frame fuer einen Nachbarn hinzufuegen. */
/* Das Frame wird gesendet, sobald es voll ist oder in brosrv() wenn    */
/* der Timeout abgelaufen ist.                                          */
/*                                                                      */
/*----------------------------------------------------------------------*/
void add_inp_info(MBHEAD **mbpp, NODE *node, PEER *topp, unsigned qualit,
unsigned last_qualit, int lt)
{
  char buf[128], *bp, *bp2;
  int  len;

  bp = buf;

  if (qualit == 0)
    qualit = HORIZONT;

  if (topp->version > 170 && topp->version < 176) {
    *bp++ = qualit >> 8;
    *bp++ = qualit & 0xFF;
    *bp++ = lt;
  } else {
    *bp++ = lt;
    *bp++ = qualit >> 8;
    *bp++ = qualit & 0xFF;
  }

  if (   (qualit && last_qualit == 0)
      || last_qualit == DIRTY) {
    if (topp->version > 170 && topp->version < 175) { /* fehlerhaft */
      *bp++ = ALIAS_ID;
      *bp++ = L2CALEN;
      cpyals(bp, node->alias); bp += L2CALEN;
    } else {
      /* richtige Implementierung */
      for (len = 0; len < L2CALEN; len++)
        if (node->alias[len] == ' ') break;
      *bp++ = len + 2;
      *bp++ = 0;
      memcpy(bp, node->alias, len); bp += len;
      memcpy(bp, node->opt, node->optlen); bp += node->optlen;
    }
  }
  *bp++ = 0;                             /* Ende der Meldung            */
  len = (int) (bp - buf) + L2IDLEN;      /* Laenge berechnen            */

  if (*mbpp)
    if ((*mbpp)->mbpc + len > 256)       /* passt nicht mehr ?          */
      brosnd(mbpp, topp);

  if (*mbpp == NULL) {                   /* neues Frame holen           */
    (*mbpp = (MBHEAD *)allocb())->l3_typ = L2CI;
    putchr(0xFF, *mbpp);                 /* Kennung                     */
  }

  putfid(node->id, *mbpp);
  for (bp2 = buf; bp2 < bp; bp2++)
    putchr(*bp2, *mbpp);
}

void addbro(MBHEAD **mbpp, NODE *node, PEER *topp, PEER *viapp,
unsigned qualit, unsigned lastqual, int lt) {
  switch (topp->typ) {
    case THENET :
    case NETROM :
      add_netrom_info(mbpp,node,topp,viapp,qualit);
      break;
    case TNN :
      add_thenet_info(mbpp,node,topp,viapp,qualit);
      break;
    case INP :
      add_inp_info(mbpp,node,topp,qualit,lastqual,lt);
      break;
  }
}

/*------------------------------------------------------------------------*/
/* Broadcast fuer einen Nachbarn                                          */
void inform_peer(PEER *pp, int kind_of)
{
  int       index;
  int       max_nodes = netp->max_nodes;
  NODE     *np = netp->nodetab;
  ROUTE    *rp = pp->routes;
  PEER     *bestpp;
  unsigned  quality;
  unsigned  reported_quality;
  unsigned  diff;
  int       timeout;
  MBHEAD   *mbp = NULL;                   /* noch kein Buffer offen */
  BOOLEAN   old_netrom = (pp->typ == NETROM || pp->typ == THENET);

  for (index = 0; index < max_nodes; index++, np++, rp++) {
    if (   (np->id[0] == 0)             /* kein Eintrag           */
        || (np->alias[0] == '#'))       /* oder ein versteckter   */
      continue;

    if (cmpid(np->id, pp->l2link->call)) continue;

/**********************************************************************/
/*** HACK: wird nur benoetigt, solange wir nur die Flexnet Nachbarn ***/
/*** und nicht deren Ziele melden wollen                            ***/
    if (   ((quality = find_best_qual(index, &bestpp, VC|VC_FAR|DG)) != 0)
        && (bestpp->options == VC_FAR)
        && (cmpid(bestpp->l2link->call, np->id))
       ) {
    } else
/**********************************************************************/

    /**
     * An Nachbarn, die das gleiche Call haben, wie der beste Weg (also
     * auch der beste Weg selbst) melden wir 0.
     */
    quality = find_best_qual(index, &bestpp, HOST_MASK);
    if (cmpid(bestpp->l2link->call, pp->l2link->call))
        quality = 0;

/** Alternativ:                                                      **/
/** quality = find_best_notvia(index, pp, &bestpp, HOST_MASK);       **/

    reported_quality = rp->reported_quality;
    if (kind_of == ALL) {
      /* gesicherten Nachbarn brauchen wir nur Ziele zu uebertragen,
     die wir schon mal gemeldet hatten */
      if (!old_netrom && !reported_quality)
        continue;
      /* wir senden alle Routen ohne Timeout und diejenigen, die noch
         mindestens 30% des Timeouts uebrig haben */
      timeout = rp->timeout;
      if (   (timeout == 0)
          || (timeout >= (ROUTE_TIMEOUT/3))
         ) {
        addbro(&mbp, netp->nodetab+index, pp, bestpp, quality,
               reported_quality, bestpp->routes[index].lt);
        rp->reported_quality = quality; /* merken was wir gemeldet haben */
      }
    } else {
      if (reported_quality != DIRTY) {
        if (quality == reported_quality) continue; /* keine Aenderung */
        /*
         * Wenn ein Ziel ausfaellt oder neu gemeldet wird, dann brauchen
         * wir nicht zu kontrollieren, ob die Meldung unterdrueckt werden
         * kann. Diese Meldungen sind zwingend.
         */
        if (quality && reported_quality) {
          /*
           * Verbesserungen werden nur gemeldet, wenn Sie mindestens um
           * 25% von der letzten Meldung abweichen. Ebenfalls nicht gemeldet
           * werden sehr geringe Verbesserungen (<= 100ms) bei sehr
           * schnellen Links (Aenderung z.B. von 50ms auf 90ms wird nicht
           * gemeldet, obwohl es 60% sind).
           * NEU: Die Verbesserung muss mindestens ber der halben Laufzeit
           * zum empfangenden Segment liegen.
           */
          if (quality < reported_quality) {
            diff = reported_quality - quality;
            if (diff < reported_quality/4) /* Filter 1: 25% Verbesserung    */
              continue;
            if (diff < 10)                 /* Filter 2: mindestens 100ms    */
              continue;
            if (diff < pp->quality/2)      /* Filter 3: adaptiv nach Zielr. */
              continue;
          } else
          /*
           * Verschlechterungen muessen immer sofort uebertragen werden.
           * Wir senken die Qualitaet bei der Meldung zusaetzlich um 12.5% ab,
           * um bei weiterem Abfall nicht sofort wieder melden zu muessen.
           */
            quality += quality/8;
        }
      }

      addbro(&mbp, netp->nodetab+index, pp, bestpp, quality,
             reported_quality, bestpp->routes[index].lt);

      rp->reported_quality = quality; /* merken was wir gemeldet haben */
    }
  }
  brosnd(&mbp, pp);
}

/************************************************************************/
/* L3-RTT-Service                                                       */
/* erzeugt einen Frame mit L3-Header, bei dem Ziel und Absender         */
/* der eigene Knoten ist. Dieses Frame wird dann an den Nachbarn        */
/* gesendet. Die vorhergehende Messung wird dem Nachbarn mitgeteilt.    */
/* im Frame wird die vergangene Zeit in 10ms-Schritten seit Programm-   */
/* start mitgegeben.                                                    */
/* Neu: Automatische Qualitaetsberechnung aus dem L3SRTT, DB2OS 06/04/93*/
/* neu?? ist doch 5 jahre alt! (df6ln 12.07.98)                         */
/*----------------------------------------------------------------------*/
void l3rtt_service(void)
{
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;
  MBHEAD *mbp;
  int     index;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++) {
    if (!pp->used) continue;
    if (pp->typ > NETROM) continue;
    if (pp->nbrl2l == NULL) {
      mbp = (MBHEAD *)allocb();     /* Buffer besorgen                    */
      putchr(0xFF, mbp);
      pu6chr(alias, mbp);           /* Ident in Buffer                    */
      mbp->l2fflg = L2CNETROM;      /* PID = Level 3                      */
      rwndmb(mbp);                  /* Pointer aufziehen                  */
      sdl3ui(pp, mbp);              /* UI-Broadcast senden                */
      connbr(pp);
      continue;
    }
    if (pp->nbrl2l->state < L2SIXFER)
      continue;
    if (pp->rttstart) {
      if (tic10-pp->rttstart >= 12000L) /* maximal 120 Sekunden           */
        discnbp(pp);
      continue;
    }
    if ( pp->rtt_time == 0) {       /* Messung ist faellig                */
      if (pp->typ == THENET) {      /* der kann nicht messen              */
        update_peer_quality(pp,pp->nbrl2l->SRTT*4L,DONT_CHANGE_QUAL);
        /* Falls das Timeout auf einer Route mal abfaellt,    */
        /* melden wir hier wieder die Routen-Qualitaet hoch.  */
        if ((index = add_route(pp,pp->l2link->call,1)) != -1)
          update_lt(pp, index, 1);
        rtt_metric(pp,pp->nbrl2l->SRTT*4L);
        pp->rtt_time = L3_RTT_TIME;
      } else
        send_l3srtt_frame(pp);      /* Neue Messung starten               */
    } else pp->rtt_time--;          /* Messintervall runterzhlen         */
  }
}

/*----------------------------------------------------------------------*/
void send_l3srtt_frame(PEER *pp)
{
  MBHEAD *mbp;
  int     mtu;

  if (pp->typ > NETROM)                   /* nur bei NET/ROM erlaubt    */
    return;

  if (pp->nbrl2l ) {                      /* nur aktiver mit L2-Link..  */
    mbp = (MBHEAD *)allocb();             /* Buffer besorgen            */
    putfid(myid,mbp);                     /* von eigenes Call           */
    putfid("L3RTT \140",mbp);             /* an Pseudo-Destination      */
    *(mbp->mbbp -1) |= 1;                 /* EOA setzen                 */
    putchr(0x02, mbp);                    /* Lifetime = 2               */
    putchr(0x00, mbp);                    /* Circuit-Index              */
    putchr(0x00, mbp);                    /* Circuit-ID                 */
    putchr(0x00, mbp);                    /* TX-Sequence-Number         */
    putchr(0x00, mbp);                    /* RX-Sequence-Number         */
    putchr(0x05, mbp);                    /* OpCode & Flags             */
    putstr("L3RTT:",mbp);                 /* Framekennung               */
    pp->rttstart = tic10;                 /* Startzeit merken           */
    putlong(tic10,TRUE,mbp);              /* 10ms Ticks seit Softstart  */
    putlong((ULONG) pp->quality,TRUE,mbp); /* aktueller L3-SRTT Wert    */
    putlong((ULONG) pp->my_quality, TRUE,mbp); /* letzter L3-RTT Wert   */
    putlong((ULONG) pp, TRUE,mbp);        /* Pointer als ID             */
    putchr(' '            , mbp);
    pu6chr(alias          , mbp);
    putstr(" LEVEL3_V2.1 ", mbp);         /* L3-Version                 */
    putstr(infostr        , mbp);         /* TNN-Version                */
    putstr(" $N\n",mbp);
    mtu = portpar[pp->l2link->port].mtu;
    while (mbp->mbpc < mtu)               /* Buffer voll machen         */
      putchr(' ', mbp);
    rwndmb(mbp);                          /* Frame aufziehen            */
    toneig(pp, mbp);                      /* Frame an den Nachbarn      */
  }
}

/*----------------------------------------------------------------------*/
/* Feststellen, ob zu einem Node noch ein Weg existiert. Wenn es keinen */
/* aktiven Weg mehr gibt, wird dies dem L4 gemeldet. Dieser traegt dann */
/* alle aktiven L4-Verbindungen aus.                                    */
/* Da wir die Wege nach der Qualitaet sortieren, reicht es zu pruefen,  */
/* ob der beste Weg ausgefalle ist. In diesem Fall erfolgt die Meldung  */
/* an den L4.                                                           */
/* Diese Routine wird nach jeder Veraenderung der Qualitaet eines Weges */
/* aufgerufen.                                                          */
/*----------------------------------------------------------------------*/
BOOLEAN check_destot(int index)         /* berprft, ob es noch        */
{                                       /* verwendbare Wege zu einem    */
                                        /* Ziel gibt                    */
  if (find_best_qual(index, NULL, DG) == 0) {
    destot(index);
    return (TRUE);
  }
  return (FALSE);
}

/*----------------------------------------------------------------------*/
void check_all_destot(void) {
  int index;
  int max_nodes = netp->max_nodes;

  for (index = 0; index < max_nodes; index++)
    check_destot(index);
}

/*----------------------------------------------------------------------*/
/* Ein Frame an einen Nachbarn senden.                                  */
void toneig(PEER *pp, MBHEAD *mbp)
{
  if ((lnkpoi = pp->nbrl2l) != NULL)     /* L2-Link vorhanden?          */
    i3tolnk(L2CNETROM, pp->nbrl2l, mbp);
  else
    dealmb(mbp);                         /* sonst wegwerfen             */
}

/*----------------------------------------------------------------------*/
void destot(int index)          /* Ziel ist nicht mehr erreichbar       */
{
  MBHEAD *mbp, *nextmbp;
  NODE   *totnod = netp->nodetab+index;

  l3tol4(totnod);               /* an L4 melden: Knoten wird entfernt   */

  for (mbp = (MBHEAD *) l3txl.head;             /* L4 Sendeliste        */
       mbp != (MBHEAD *)&l3txl.head;            /* durchgehen           */
       mbp = nextmbp)
  {
    nextmbp = (MBHEAD *) mbp->nextmh;
    if ((NODE *) mbp->l2link == totnod) {       /* dieser Node?         */
      ulink((LEHEAD*)mbp);
      dealmb(mbp);
    }
  }
}

/* den besten Weg zu einem Segment feststellen (wenn es mehrere gibt) */
void update_primary_peer(char *id) {
  PEER *peertab = netp->peertab;    /* Segment-Tabelle                     */
  PEER *pp;
  PEER *bestpp = NULL;
  unsigned long quality;
  unsigned long bestqual = 0;

  /* den primaeren Weg suchen und merken */
  for (pp = peertab; pp < &peertab[netp->max_peers]; pp++)
    if (pp->used) {
      if (cmpid(pp->l2link->call,id)) {
        if (bestpp) {
          quality = pp->quality;
          if ((quality && quality < bestqual) || !bestqual) {
            bestpp = pp;
            bestqual = quality;
          }
        } else {
          bestpp = pp;
          bestqual = pp->quality;
        }
      }
    }

  /* und dann in allen Wegen (zu dem Nachbarn) eintragen */
  for (pp = peertab; pp < &peertab[netp->max_peers]; pp++)
    if (pp->used)
      if (cmpid(pp->l2link->call, id))
        pp->primary = bestpp;
}

/* einen Nachbarn austragen                                              */
void unregister_neigb(char *id, char *via, int port) {
  char    digi_list[2*7+1];
  PEER   *pp;                       /* Buffer fuer Eintrag               */

  cpyidl2(digi_list, via);          /* nur maximal 2 Digipeater!         */
  pp = getnei(digi_list, id, port);
  if (!pp) return;

  update_peer_quality(pp,0L,0L);    /* als ausgefallen melden            */

  if (pp->nbrl2l)                   /* noch connected?                   */
    discnbp(pp);

  dealoc((MBHEAD *)pp->l2link);
  unregister_peer(pp);
}

/* einen neuen Nachbarn eintragen                                        */
PEER *register_neigb(char *id, char *via, char *alias, int port, int typ) {
  L2LINK *p;
  char    digi_list[2*7+1];
  PEER   *pp;
  int     index;

  switch (typ) {                   /* werden automatisch erkannt          */
    case TNN :
    case INP :
      typ = NETROM;
  }

  cpyidl2(digi_list, via);         /* nur maximal 2 Digipeater!          */
  pp = getnei(digi_list, id, port);

  if (pp != NULL) {                 /* wir kennen den Nachbarn           */
    p = pp->l2link;
    if (!cmpals(alias, nulide))
      cpyals(p->alias, alias);
    return (pp);                    /* Eintrag liefern                   */
  }

  if ((pp = register_peer()) == NULL)
    return (NULL);

  p = pp->l2link = (L2LINK *) allocb();  /* Platz fr den L2-Link        */

  /* Diese beiden Eintrge werden sofort von auen neu gesetzt.          */
  /* Bei NET/ROMs wird der alias selbstndig bestimmt, die Qualitaet     */
  /* ist nur fr ungemessene Links der Vorgabe-Wert.                     */

  cpyid(p->call, id);               /* Call eintragen                    */
  cpyidl2(p->digil, digi_list);     /* maximal 2 eintragen               */
  cpyals(p->alias, alias);          /* Alias eintragen                   */
  p->port = port;                   /* Port eintragen                    */
  p->ssid_high = SSID(id);          /* noch keine Grenze bekannt         */

  set_peer_typ(pp, typ);
  pp->nbrl2l = NULL;                /* kein L2 Link vorhanden            */
  pp->version = 0;                  /* unbekannte Version                */
  pp->rttstart = 0;                 /* keine Messung unterwegs           */
  pp->rtt_time = 0;                 /* schnell messen                    */
  pp->brotim = 0;                   /* Broadcast Timer                   */
  pp->options = (typ <= NETROM) ?   /* Datagramm oder VirtualConnect     */
        DG :
        (typ == FLEXNET) ?          /* FlexNet oder Local?               */
        VC_FAR : VC;
  inithd(&(pp->rxfl));              /* Empfangsliste                     */

  if (typ == LOCAL) {               /* erste Messung simulieren          */
    if ((index = add_route(pp, id, 400)) != -1) {
      update_alias(index, alias);
      update_lt(pp, index, 1);
    }
    pp->quality = 1;                /* Messung simulieren                */
  }
  update_primary_peer(pp->l2link->call);

  return(pp);                       /* mit Pointer auf Eintrag zurueck   */
}

/************************************************************************/
/*                                                                      */
/* Der Nachbar, auf den nbp zeigt, bekommt eine L3-Mini-Broadcast-      */
/* Bake von uns. Die Bake ist notwendig, da einige aeltere Versionen    */
/* von TheNet und andere NET/ROM-Implementierungen den Nachbarn         */
/* nur annehmen, wenn vorher bereits eine L3-Bake empfangen wurde.      */
/*                                                                      */
/* connbr() wird bei jedem Broadcastintervall aufgerufen, um an die     */
/* nicht-connecteten Nachbarn, deren Connectversuche abgelaufen sind,   */
/* eine regelmaessige Bake als Kennzeichen "ich bin da, wo bist du"     */
/* zu schicken. Zusaetzlich wird connbr immer aufgerufen, wenn in       */
/* l3rest ein leerer nbrl2l-Eintrag vorgefunden wird, damit schneller   */
/* ^^^^^^-> tut nichts mehr!                                            */
/* der Nachbar connected wird (beim Start der Software).                */
/*                                                                      */
/************************************************************************/
BOOLEAN connbr(PEER *pp)
{
  char id[L2IDLEN];

  cpyid(id, myid);
  if (pp->typ == LOCAL_M) id[L2IDLEN-1] = (testid<<1)|0x60;

  lnkpoi = getlnk(pp->l2link->port, id, pp->l2link->call, pp->l2link->digil);

  if (lnkpoi) {                     /* gabs noch einen freien Eintrag?  */
    if (lnkpoi->state == L2SDSCED) {
      newlnk();                     /* Verbindung erstellen             */
      pp->nbrl2l = lnkpoi;
      return (TRUE);
    }
    dsclnk();
  }
  return (FALSE);
}

/*----------------------------------------------------------------------*/
/* Nachbarn in Nachbarliste suchen                                      */
/*----------------------------------------------------------------------*/
PEER *getnei(char *digil, char *call, int port)
{
  PEER *pp;
  int   i;
  int   max_peers = netp->max_peers;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used)
      if (isneig(digil, call, port, pp))
    return (pp);
  return(NULL);
}

unsigned getquality(unsigned route_qual, PEER *pp) {
  unsigned long qual;

  if (route_qual == 0 || pp->quality == 0)
    return (0);
  if (pp->typ <= NETROM) {
    qual = ((unsigned long)route_qual) + pp->quality;
    if (qual > HORIZONT) qual = HORIZONT;
    return ((unsigned)qual);
  } else
    return (route_qual);
}

/* Qualitaet des besten Weges (immer >= 1)                              */
unsigned do_find_best_qual(int index, PEER *notthis, PEER **retpp, int options) {
  int    i;
  PEER  *pp = netp->peertab, *bestpp = NULL;
  ROUTE *rp;
  unsigned bestqual = 0;
  unsigned quality;

  for (i = netp->max_peers; i--; pp++) {
    if (!pp->used) continue;
    if (pp == notthis) continue;
    if ((pp->options & options) == 0) continue;
    rp = pp->routes+index;
    quality = getquality(rp->quality, pp);
    if ((quality && quality < bestqual) || !bestqual) {
      bestpp = pp;                  /* Route und Peer merken */
      bestqual = quality;
    }
  }
  if (retpp) *retpp = bestpp;       /* besten Nachbarn liefern */
  return (bestqual);                /* und Qualitaet als Rueckgabewert */
}

/* Kennen wir das Ziel als Ident?                                       */
int find_alias(char *ident)
{
  NODE *np = netp->nodetab;         /* NET/ROM-Tabelle durchsuchen      */
  int i;
  int max_nodes = netp->max_nodes;

  for (i = 0; i < max_nodes; i++, np++)
    if (np->id[0])                  /* Eintrag existiert?               */
      if (cmpals(ident, np->alias))
    return (i);
  return(-1);                       /* nix gefunden                     */
}

/* Rufzeichen suchen                                                    */
int iscall(char *id,                /* Nach einem Rufzeichen suchen     */
NODE **retnp, PEER **bestpp, int options) {
  int index;

  if ((index = find_node_this_ssid(id)) != -1) {
    if (retnp) *retnp = netp->nodetab+index;
    return (find_best_qual(index,bestpp,options) != 0);  /* beste Qual. */
  }
  return(0);                        /* nix gefunden                     */
}

/*----------------------------------------------------------------------*/
/* Stimmen Digipeaterliste (digis), Rufzeichen (call) und Port mit dem  */
/* Eintrag in die Nachbarnliste (nachp) ueberein?                       */
/* Rueckgabe: TRUE=ja,  FALSE=nein                                      */
/*----------------------------------------------------------------------*/
BOOLEAN isneig(char *digis, char *call,
int port, PEER *pp)
{
  if (pp->l2link->port != port) return(FALSE);
  if (cmpid(pp->l2link->call, call) == FALSE) return(FALSE);
  if (cmpidl(digis,pp->l2link->digil) == FALSE) return(FALSE);

  return(TRUE);
}

/*----------------------------------------------------------------------*/
/* 6 Zeichen aus Message-Puffer lesen und nach Buffer schreiben         */
/* Rueckgabe: TRUE = hat funktioniert                                   */
/*----------------------------------------------------------------------*/
BOOLEAN ge6chr(char *buffer, MBHEAD *mbp)
{
  int i, ch;

  for (i = L2CALEN;
       (mbp->mbpc > mbp->mbgc) && i;   /* noch Zeichen da?             */
       i--) {
    *buffer++ = ch = getchr(mbp);
    if (ch < ' ')
      return (FALSE);                  /* ungueltiges Zeichen          */
    if (ch > 127)
      return (FALSE);
  }
  return(i == 0);                      /* waren genug Zeichen da?      */
}

/*----------------------------------------------------------------------*/
/* 6 Zeichen aus Buffer in Message-Puffer schreiben                     */
/*----------------------------------------------------------------------*/
void pu6chr(char *buffer, MBHEAD *mbp)
{
  WORD i;

  for (i = 0; i < 6; ++i)
      putchr(*buffer++, mbp);
}

/*----------------------------------------------------------------------*/
/* Den aktuellen Nachbarn als connected eintragen.                      */
/*----------------------------------------------------------------------*/
void newnbr(PEER *pp)
{
  pp->nbrl2l = lnkpoi;                      /* Link eintragen           */
  ptctab[g_uid(lnkpoi, L2_USER)].state = PEERLINK;
}

/*----------------------------------------------------------------------*/
/* Den aktuellen Nachbarn als disconnected eintragen.                   */
/*----------------------------------------------------------------------*/
void disnbr(PEER *pp)
{
  if (pp->nbrl2l == NULL)
    return;
  ptctab[g_uid(pp->nbrl2l, L2_USER)].state = 0;
  if (pp->nbrl2l) {
    pp->nbrl2l = NULL;
    dealml((LEHEAD *)&pp->rxfl);            /* nur rx loeschen, den     */
                                            /* Rest macht die Abmeldung */
  }
}

/*----------------------------------------------------------------------*/
/* Ist der neue Link ein erlaubter Nachbar ?                            */
/* Wenn ja: Pointer auf die Nachbarstruktur zurueck, sonst NULL.        */
/*----------------------------------------------------------------------*/
PEER *ispeer(void)
{
  L2LINK *p;
  PEER   *pp;
  int     i;
  int     max_peers = netp->max_peers;
  char   *srcid;

  for (i = 0, pp = netp->peertab; i < max_peers; i++, pp++)
    if (pp->used) {
      p = pp->l2link; /* Pointer auf den eingetragenen Link */
      if (lnkpoi) {
        if (pp->nbrl2l == lnkpoi)
          return (pp);
        if (!cmpid(p->call, lnkpoi->dstid) ||
            !cmpidl(p->digil, lnkpoi->viaidl) ||
            (p->port != lnkpoi->liport)
           ) continue;
      } else {
        if (!cmpid(p->call, &rxfhdr[7]) ||
            !cmpidl(p->digil, &txfhdr[14]) ||
            (rxfprt != p->port)
           ) continue;
        return (pp->typ <= NETROM) ? pp : NULL;
      }

      srcid = (lnkpoi == NULL) ? rxfhdr : lnkpoi->srcid;
      if (pp->typ != LOCAL) {
        if (cmpcal(myid, srcid)) {
          if (pp->typ == LOCAL_M) {
            if (srcid[L2IDLEN-1] == ((testid<<1)|0x60))
              return (pp);
          } else {
            if (srcid[L2IDLEN-1] == myid[L2IDLEN-1])
              return (pp);
          }
        }
      }
    }
  return (NULL);
}

/************************************************************************/
/* Eine Status-Aenderung fuer NET/ROM behandeln                         */
/************************************************************************/
void netrom_status(PEER *pp, WORD status)
{
  if (pp->typ <= NETROM) {                  /* nur NET/ROM interessiert */
    switch (status) {
      case L2MCONNT :
      case L2MLREST :
        connect_peer(pp);
        break;

      default :
        disconnect_peer(pp);
        update_peer_quality(pp,0,DONT_CHANGE_QUAL);
        check_all_destot();
        break;
    }
    pp->rttstart = 0;
    pp->rtt_time = 0;
    switch (pp->typ) {
      case TNN:
      case INP: set_peer_typ(pp, NETROM);
    }
    pp->brotim = 0;                         /* mit Broadcast beginnen   */
  }
}

/*----------------------------------------------------------------------*/
/* eine Status-nderung an alle L3-Module senden                        */
/* Die Module mssen selber darauf achten, das sie die Meldung nur      */
/* annehmen, wenn der Typ des pp stimmt!                                */
/*----------------------------------------------------------------------*/
void mstatus(PEER *pp, WORD status)
{
  netrom_status(pp,status);                 /* neuen Status melden      */
  flex_status(pp,status);                   /* an NETROM & FlexNet      */
  local_status(pp,status);                  /* und unsere Locals        */
}

/*----------------------------------------------------------------------*/
/* Neue Status-Meldung verarbeiten                                      */
/* 0=nicht verwendet, 1=connectet, 2=disconnectet, 3=busy, 4=Failure    */
/*----------------------------------------------------------------------*/
BOOLEAN l2tol3(WORD status)
{
  PEER *pp;
  char notify_call[10];

  switch (status) {
    case L2MCONNT :                         /* CONNECTED to             */
    case L2MLREST :                         /* LINK RESET to            */
      if ((pp = ispeer()) == NULL)
          return (l2toip(status));          /* der L7 ist dran          */
      newnbr(pp);                           /* Nachbar eintragen        */
      mstatus(pp,status);                   /* Status melden            */
      return (TRUE);                        /* Status verarbeitet       */

    case L2MLRESF :                         /* LINK RESET from          */
      if ((pp = ispeer()) == NULL)
        return (l2toip(status));            /* der L7 ist dran          */
      mstatus(pp, status);                  /* Status melden            */
      disnbr(pp);                           /* Nachbar inaktiv          */
      newnbr(pp);                           /* Nachbar eintragen        */
      mstatus(pp, status);                  /* Status melden            */
      call2str(notify_call, rxfhdr+L2IDLEN);
      notify(3, "Linkreset %6s", notify_call);
      return (TRUE);                        /* Status verarbeitet       */

    case L2MDISCF :                         /* DISCONNECTED from        */
    case L2MBUSYF :                         /* BUSY from                */
    case L2MFAILW :                         /* LINK FAILURE with        */
      if ((pp = ispeer()) == NULL)
        return (l2toip(status));            /* der L7 ist dran          */
      mstatus(pp,status);                   /* melden                   */
      disnbr(pp);                           /* Nachbar inaktiv          */
      return (TRUE);                        /* nicht in den L7          */

    case L2MFRMRF :                         /* FRAME REJECT from        */
    case L2MFRMRT :                         /* FRAME REJECT to          */
      if ((pp = ispeer()) == NULL)
        return (l2toip(status));            /* der L7 ist dran          */
      return (TRUE);                        /* Status verarbeitet       */

    case L2MBUSYT :                         /* BUSY to                  */
      return (TRUE);                        /* hier abfangen            */
  }

  return (FALSE);                           /* ungltige Meldung        */
}

/**************************************************************************\
*                                                                          *
* "rx frame to neigbour"                                                   *
*                                                                          *
* Ein L3-Frame wurde empfangen und wird hier an den entsprechenden         *
* Nachbarpointer zur weiteren verarbeitung angehaengt.                     *
*                                                                          *
\**************************************************************************/

void rxneig(PEER *pp, MBHEAD *fbp)
{
  relink((LEHEAD *)fbp,(LEHEAD *)pp->rxfl.tail);    /* ok->weiter         */
}

/**************************************************************************\
*                                                                          *
* "to level 3 switch"                                                      *
*                                                                          *
* Aus I- oder UI-Frame (Framekopf fbp, Getzeiger/Zaehler auf 1. Byte       *
* hinter Level-2-Adressfeld) PID holen, falls vorhanden. Falls es nicht    *
* Level-2-PID ist, das Paket an die Level-3-Empfangsframeliste l3rxfl      *
* haengen. Im Framekopf wird in jedem Fall l2fflg auf PID, wenn vorhanden, *
* oder 0 gesetzt, l2link auf den aktuellen Link (lnkpoi).                  *
* Fr Level-3-Frames wird der Nachbar bestimmt.                            *
*                                                                          *
* Return:  YES - das I/UI-Frame hat ein Nicht-Level-2-PID und wurde an die *
*                Level-3-Empfangsframeliste gehaengt                       *
*          NO  - Frame hat Standard-Level-2-PID                            *
*                                                                          *
\**************************************************************************/

BOOLEAN tol3sw(MBHEAD *fbp)
{
  PEER    *pp;
  UBYTE    pid;
  int      state;
  int      filter_ip_frame;

  pid         = fbp->l2fflg;

  fbp->l2link = lnkpoi;             /* Linkverbindung von diesem Frame    */
  fbp->l2port = rxfprt;             /* Auf diesem Port kam das Frame      */

  if (lnkpoi) {
    state = ptctab[g_uid(lnkpoi, L2_USER)].state;
    filter_ip_frame = (state == D_IPLINK || state == U_IPLINK);
  } else
    filter_ip_frame = TRUE;

  /*
   * Protokolle, die nicht an einen Nachbarn gebunden sind, direkt
   * abfangen
   */
  switch (pid) {
#ifdef IPROUTE
    case L2CIP       :
      if (filter_ip_frame) {
        relink((LEHEAD *)fbp, (LEHEAD *)iprxfl.tail);
        return (TRUE);              /* Frame verarbeitet                  */
      }
      else break;

    case L2CARP      :
      if (filter_ip_frame) {
        relink((LEHEAD *)fbp, (LEHEAD *)arprxfl.tail);
        return (TRUE);              /* Frame verarbeitet                  */
      }
      else break;
#endif

    case 0x12        :              /* Spielzeug fuer DB7KG (PID 12)      */
      dealmb(fbp);
      return (TRUE);
  }

  if ((pp = ispeer()) == NULL)      /* kein Frame fuer einen Nachbarn?    */
    return (FALSE);                 /* zum Level 7 durchlassen            */

  /*
   * Hier landen nur Frames, die zu einem bestimmten Nachbarn gehoeren.
   * Nun muss noch Protokoll-ID und Protokoll verglichen werden.
   */

  if (fbp->l2link)                  /* fuer Level 2 Links Info zaehlen    */
    ptctab[g_uid(fbp->l2link, L2_USER)].inforx += (fbp->mbpc-fbp->mbgc);

  switch (fbp->l2fflg) {            /* Protokoll/Nachbartyp feststellen   */
                                    /* NET/ROM-Protokoll fr              */
                                    /* TheNet, TheNetNode, TNX1J(TexNet)  */
                                    /* KA9Q und Devirate                  */
                                    /* Wampes, Linux usw                  */
                                    /* BPQ, andere Switches               */
    case L2CTEXNET   :              /* fr TexNet/TheNetX1J               */
    case L2CNETROM   :
      if (pp->typ > NETROM) break;  /* nicht richtiger Nachbar-Typ?       */
      rxneig(pp, fbp);              /* Frame zur Nachbar-Bearbeitung      */
      return (TRUE);                /* ... und fertig                     */


                                    /* Fluxwech Protokoll fuer            */
    case L2CFLEXNET  :              /* FluxWech eben, BayCom, Digiware    */
      if (pp->typ != FLEXNET) break;
      if (lnkpoi == NULL) break;    /* UI-Frames sind verboten            */
      rxneig(pp, fbp);              /* FlexNet-Internode-Frame            */
      return (TRUE);                /* toL7: Frame verarbeitet            */

#ifdef IPROUTE                      /* IP/ARP auf Interlink ist erlaubt   */
    case L2CIP       :
      relink((LEHEAD *)fbp, (LEHEAD *)iprxfl.tail);
      return (TRUE);                /* Frame verarbeitet                  */

    case L2CARP      :
      relink((LEHEAD *)fbp, (LEHEAD *)arprxfl.tail);
      return (TRUE);                /* Frame verarbeitet                  */
#endif
  }

  dealmb(fbp); /* unpassende/unbekannte PID, falscher Nachbar, Fehler...  */
  return (TRUE);
}

/*------------------------------------------------------------------------*/
void cpyidl2(char *dest, char *source)
{
  int count = 2;

  while (*source != '\0' && count-- > 0) {
    memcpy(dest,source,L2IDLEN);
    source += L2IDLEN;
    dest += L2IDLEN;
  }
  *dest = '\0';
}

/*
 * Rufzeichen eines Node ausgeben, wahlweise Alias und SSID-Bereich
 */
void putnod(NODE *np, int options, MBHEAD *mbp)
{
  if (options & OPT_ALIAS) {
    putide(np->alias, mbp);
    putchr(':', mbp);                /* ":" als Trennung zum Rufzeichen   */
  }
  if (options & OPT_SSID_RANGE) {
    putprintf(mbp,"%6.6s %2d-%-2d", np->id, SSID(np->id), np->ssid_high);
  } else
    putid(np->id, mbp);
}

/*------------------------------------------------------------------------*/
/*  NODES                                                                 */
/*  -----------                                                           */
/*  clipoi zeigt auf das naechste Zeichen der Komandozeile.               */
/*  Wenn clicnt == 0 ist diese zu ende.                                   */
/*  nodprm() operiert nur auf einer KOPIE von clicnt/clipoi !             */
/*------------------------------------------------------------------------*/
void show_nodes(
char *name,                        /* Name (Nodes,Destinations,Locals)    */
int options)                       /* Optionen fuer die Ausgabe           */
{
  char            newcal[L2IDLEN]; /* neues Call                          */
  char            niden[L2CALEN];  /* neuer Alias                         */
  char            *cpoisa;         /* temp fuer clipoi                    */
  BOOLEAN         alles;           /* versteckte Nodes auch zeigen        */
  BOOLEAN         plus_quality;    /* mit Qualitaet etc. zeigen           */
  WORD            callok;          /* Ergebnis Test auf gueltiges Call    */
  WORD            isnode;          /* Ergebnis Test auf gueltigen Alias   */
  WORD            ccntsa;          /* temp fuer clicnt                    */
  MBHEAD          *mbp;            /* Buffer fuer Meldung an User         */
  WORD            is_mask_or_qual; /* Qualitaet / Wildcards angegeben     */
  UBYTE           mask[MAXMASK];
  UWORD           qual;
  UBYTE           nbrcal[L2IDLEN];
  int             j;
  int             index;
  int             max_peers = netp->max_peers;
  unsigned        route_quality;
  unsigned        quality;
  PEER           *pp;
  PEER           *bestpp;
  NODE           *np;
  ROUTE          *rp;
  int             width;
  int             len;
  BOOLEAN         all_routes;
  char            buf[40];
  char            call1[15];
  char            call2[15];

  if (!ismemr())                   /* Nicht genuegend Buffer !!!          */
    return;

  alles =                          /* default: keine versteckten Nodes    */
  plus_quality = FALSE;            /* default: ohne Qualitaet etc.        */

/* Wenn Befehlszeile leer, Qualitaet nicht beruecksichtigen; bei Aufruf   */
/* mit Parametern, pruefen, ob Qualitaet / Wildcards angegeben            */

  is_mask_or_qual = clicnt ? nodprm(clipoi, clicnt, mask, &qual, nbrcal) : 0;

  if ( (!is_mask_or_qual) && clicnt )         /* nur 1 Node gefragt       */
  {
    cpoisa = clipoi;                          /* Befehlszeile merken      */
    ccntsa = clicnt;
    if (options & OPT_ALIAS) {
      isnode = getide(&clicnt, &clipoi, niden);/* Test auf gueltigen Alias*/
      clipoi = cpoisa;                         /* Befehlszeile zurueck    */
      clicnt = ccntsa;
    } else isnode = FALSE;
    callok = getcal(&clicnt, &clipoi, VCpar, newcal); /* Rufzeichen?      */
    clipoi = cpoisa;
    clicnt = ccntsa;

    while (clicnt)                 /* ans Ende von Call bzw. Alias        */
    {
      if (*clipoi == ' ')
      break;
      ++clipoi;
      --clicnt;
    }

    if ( callok == TRUE || isnode != ERRORS) /* einzeler Eintrag gefragt   */
    {
      if (   !(options & OPT_ALIAS)
          || !(isnode)
          || ((index = find_alias(niden)) == -1)
         ) {
        if (iscall) index = find_node_this_ssid(newcal);
        else index = -1;
      }

      if (index != -1) {
        np = netp->nodetab+index;
        find_best_qual(index, &bestpp, options & OPTIONS_MASK);
        mbp = getmbp();             /* Buffer holen fuer Antwort        */
        putstr("Routes to ", mbp);
        putnod(np, options, mbp);
        if (np->optlen)
          putprintf(mbp, "(%u)", np->optlen);

        putstr("\r---T[ms]----RxT----TxT--LT-Mode-Obc-----RTT-Po-Route------------------------", mbp);

        all_routes = (strchr((char*)clipoi, '*') != NULL);

        for (pp = netp->peertab, j = 0;       /* alle Wege anzeigen     */
             j < max_peers; j++, pp++) {
          if (!pp->used) continue;
          if (!(pp->options & (options & OPTIONS_MASK))) continue;

          mbp->l4time = mbp->mbpc;

          rp = pp->routes+index;
          route_quality = rp->quality;
          quality = getquality(route_quality, pp);

          if (!quality && !all_routes) continue;

          if (pp->typ == FLEXNET)
            putstr(rp->reported_quality ? "\r- " : "\r> ", mbp);
          else
            putstr(quality ? pp == bestpp ? "\r> " : "\r  " : "\r- ", mbp);

          putspa(2, mbp);
          putprintf(mbp, "%6lu %6lu ",
                ((unsigned long)quality)*10L,
                ((unsigned long)route_quality)*10L);
          if (rp->reported_quality != DIRTY)
            putprintf(mbp, "%6lu ", ((unsigned long)rp->reported_quality)*10L);
          else
            putstr("UPDATE ",  mbp);
          putprintf(mbp, "%3u %4s %3u %7lu %2u",
                (int)rp->lt,
                pp->typ <= NETROM ? "DG" : "VC",
                rp->timeout,
                ((unsigned long)pp->quality*10),
                pp->l2link->port);

          putspa(48, mbp);
          putid(pp->l2link->call, mbp);     /* Nachbarcall fuer Weg */
          putdil(pp->l2link->digil, mbp);   /* Digiweg zum Nachbarn */
        }
        putchr('\r', mbp);            /* Antwort abschliessen           */
        prompt(mbp);
        seteom(mbp);                  /* Antwort abschicken             */

    if (   options & OPT_DGTEST   /* N CALL ... Routentest senden   */
            && bestpp->typ <= NETROM)
      request_nrr(np->id, userpo->uid);

    if (options & OPT_VCTEST) {   /* D CALL ... Routentest senden   */
          call2str(call1, myid);
          call2str(call2, np->id);
          sprintf(buf, "6!%5u%s %s", userpo->uid, call1, call2);
          flex_route_query(buf);
        }
        return;                       /* fertig                         */
      } else {
        mbp = putals("No entry for: ");
        strupr((char *)cpoisa);
        putstr((char *)cpoisa, mbp);
        putchr('\r', mbp);
        prompt(mbp);
        seteom(mbp);
        return;
      }
    }
  }

/* ========================== Nodestabelle anzeigen ===================== */

  mbp = putals(name);                 /* Kopfzeile                        */
  putnum(netp->num_nodes, mbp);       /* Zahl Nodeseintraege anzeigen     */
  putchr('/', mbp);                   /* Maximalanzahl ausgeben           */
  putnum(num_nodes_max, mbp);
  putstr("):\r",mbp);                 /* Zeile abschliessen               */

  width = 0;

  if ( is_mask_or_qual )              /* wenn Wildcards, alle untersuchen */
    alles = plus_quality = TRUE;

  for (np  = (NODE *) netp->nodelis.head;
       np != (NODE *)&netp->nodelis;  /* sortierte Nodes-Liste durchgehen */
       np  = np->next) {
    index = (int)(np - netp->nodetab);/* Index berechnen                  */
    if ((np->alias[0] != '#') || (alles == TRUE))
    {                          /* Eintrag kein #-Node oder alles anzeigen */
      quality = find_best_qual(index, &bestpp, options & OPTIONS_MASK);
      rp = bestpp->routes+index;

      if ( is_mask_or_qual )   /* nur eine Auswahl bitte ...              */
      {

/* wird nach Routes eines bestimmten Nachbarn gesucht?                    */

    if (   (is_mask_or_qual & ISNBRCALL)
        && (!cmpid(bestpp->l2link->call, nbrcal) ) )
      continue;

        if ( is_mask_or_qual & ISCALLMASK )        /* Call mit Wildcards? */
        {

/* wenn Call mit Wildcards nicht passt und nicht Alias mit Wildcards      */
/* gefragt wurde oder auch nicht passt, naechsten Eintrag testen          */

          if (     !c6mtch((UBYTE *) np->id, mask )
              && ( !(is_mask_or_qual & ISIDENTMASK)
              ||   !c6mtch((UBYTE *) np->alias, mask ) ) )
            continue;
        }

/* wenn Alias mit Wildcards gefragt, aber nicht passt, naechsten Eintrag  */

        else if (   (is_mask_or_qual & ISIDENTMASK)
                 && !c6mtch((UBYTE *) np->alias, mask ) )
          continue;

        if (quality > 0) {                       /* aktiver Weg zum Node? */

/* wenn untere Qualitaetsgrenze angegeben, aber die Qualitaet fuer den    */
/* aktiven Weg zu gering ist, naechsten Eintrag testen                    */

          if (   (is_mask_or_qual & ISMINQUAL)
              && (quality < qual) )
            continue;

/* wenn obere Qualitaetsgrenze angegeben, aber die Qualitaet fuer den     */
/* aktiven Weg zu hoch ist, naechsten Eintrag testen                      */

      if (   (is_mask_or_qual & ISMAXQUAL)
              && (quality > qual) )
            continue;
    }
      } else
        if (quality == 0)
          continue;
    }

    mbp->l4time = mbp->mbpc;          /* Zaehler merken fuer putspa()    */
    putnod(np, options, mbp);
    if (options & OPT_SSID_RANGE)
      putspa(12, mbp);
    else {
      if (options & OPT_ALIAS)
        putspa(16, mbp);
      else
        putspa(9, mbp);
    }

    if (plus_quality == TRUE)         /* Qualitaet etc. auch anzeigen?   */
    {
      if (quality > 0) {              /* wenn aktiver, diesen anzeigen   */
        if (quality>6000)             /* mehr als eine Minute?           */
          putprintf(mbp, " %2umin", quality/6000);
        else
          putprintf(mbp," %5lu", ((ULONG)quality)*10L);
        if (bestpp) {
          putchr('/', mbp);
          putprintf(mbp,"%2d ", bestpp->l2link->port);
        } else
          putstr("    ", mbp);
      }
      else                            /* kein aktiver Weg                */
        putprintf(mbp,"     -/ - ", quality);
    }

    len = (mbp->mbpc - mbp->l4time);  /* Laenge eines Eintrages          */
    width += len;
    if (width+len < 79) {             /* einer passt noch in die Zeile   */
      len = (79%len)/(79/len);
      while (len--) putchr(' ', mbp);
    } else {
      putchr('\r', mbp);
      width = 0;
    }
  }
  putchr('\r', mbp);              /* Antwort abschliessen                */
  prompt(mbp);
  seteom(mbp);                    /* und abschicken                      */
}

/*---------------------------------------------------------------------*/
/* nodprm() - parameter des erweiterten NODE befehls auswerten         */
/* testet ob p eine wort mit wildcard enthaelt, kopiert dieses nach mp */
/* case-konversion! Nod*E wird NOD*E                                   */
/* n MUSS > 0 sein                                                     */
/*---------------------------------------------------------------------*/
static WORD nodprm(char *p,           /* parameter des node befehls    */
WORD n,                               /* restlaenge der parameterzeile */
UBYTE *mp,                            /* nimmt die maske auf           */
UWORD *qp,                            /* nimmt die quality auf         */
UBYTE *nc)                            /* nimmt das nachbarcall auf     */
{
  WORD    i;
  WORD    ret, matchok;
  WORD    c;

  if ( *p == '-' )
  {
    n--;
    p++;
    ret = ISMAXQUAL;
  }
  if ( (*qp = (UWORD)(nxtlong(&n,&p)/10L)) == 0 )
  {
    ret = 0;
  }
  else if ( ret != ISMAXQUAL )
  {
    ret = ISMINQUAL;
  }

  if ( *p == '<' )
  {
    n--;
    p++;
    if (getcal(&n, &p, VCpar, nc) == TRUE)
      ret |= ISNBRCALL;
  }

  if ( skipsp( &n, &p ) )
  {
    matchok = FALSE;
    for ( i = 0; i < ( MAXMASK-1 ) ; )
    {
      if ( !n || ((c = *p++) == ' ') )
        break;
      n--;
      if ( c == ':' )
      {
        if ( i == 0 )
        {
          ret |= ISCALLMASK;
          continue;
        }
        else
        {
          ret &= ~ISCALLMASK;
          ret |= ISIDENTMASK;
          break;
        }
      }
      if ( (c == MATCHMANY) || (c == MATCHONE) )
      {
        matchok = TRUE;
      }
      mp[i++] = isascii( c )?toupper( c ):MATCHONE;
    }
    mp[i] = MATCHEND;
    if ( matchok )
    {
      if ( !(ret & (ISCALLMASK|ISIDENTMASK)) )
      {
        ret |= (ISCALLMASK|ISIDENTMASK);
      }
    }
    else
    {
      ret &= ~(ISCALLMASK|ISIDENTMASK);
    }
  }
  return ( ret );
}

/*-----------------------------------------------------------------------*/
/* diese funktion hab ich 'gefunden' und etwas abgemagert                */
   /* wer ist ich??   ^^^                              */
/*   Author: James R. Van Zandt                                          */
/*           27 Spencer Dr.                                              */
/*           Nashua NH 03062                                             */
/*           <jrv@mitre-bedford.arpa>                                    */
/*                                                                       */
/*-----------------------------------------------------------------------*/
BOOLEAN  pnmtch( pat, nam )
UBYTE   *pat, *nam;
{
  UBYTE   **a, **n, *s;
  UBYTE   *alive[MAXMASK+2];
  UBYTE   *next[MAXMASK+2];

  next[0] = pat;
  next[1] = 0;
  while(next[0])
  {
    a = alive;
    n = next;

    while( a <= alive+MAXMASK && ((*a++ = *n) != 0))
    {
      if(**n == '*')
      {
        for (s=*n; *++s == '*'; );
        if (s != n[1] && a <= alive+MAXMASK)
          *a++ = s;
      }
      n++;
    }
    if(*nam == 0)
      return ( (*a[-2] == 0)? TRUE: FALSE );
    a = alive;
    n = next;
    while(*a)
    {
      switch(**a)
      {
        case '?':
          *n++ = *a+1;
          break;
        case '*':
          if(n[-1] != *a)
            *n++ = *a;
          break;
        default:
          if(**a == *nam)
            *n++ = *a+1;
      }
      a++;
    }
    *n = 0;
    nam++;
  }
  return ( FALSE );
}

/* c6mtch() - 6 zeichen matschen... */
/* TRUE wenn string 's' auf muster 'pat' passt */
/* nicht dass es umstaendlich waere... der string wird umkopiert und */
/* NULterminiert, um eine vorgefundene Funktion zu benutzen */
BOOLEAN c6mtch(UBYTE *s, UBYTE *pat)
{
  UBYTE   c6[6+1];
  WORD    i;

  for ( i = 0; i < 6; i++)
  {
    if ( s[i] == ' ' )
      break;
    c6[i] = isascii(s[i])?toupper(s[i]):s[i];
  }
  c6[i] = '\0';
  return ( (i > 0)?pnmtch( pat, c6 ):FALSE );
}

/*------------------------------------------------------------------------*/
void ccpnod(void) {                /* Nodes ausgeben                      */
  show_nodes("Nodes (", OPT_ALIAS|OPT_DGTEST|VC|VC_FAR|DG);
}

/*------------------------------------------------------------------------*/
void ccpdest(void) {               /* Destinations ausgeben               */
  show_nodes("Destinations (", OPT_SSID_RANGE|OPT_VCTEST|VC|VC_FAR|DG);
}

/*------------------------------------------------------------------------*/
/* Diese Routine bereitet das Senden des NRR-Requestframes vor            */
static void request_nrr(char *id, UID uid)
{
  NRRLIST list[2];

  cpyid(desnod, id);                 /* L3-Teil */
  cpyid(orgnod, myid);
  time_to_live = timliv;

  l4hdr0 = 0;                        /* L4-Teil */
  l4hdr1 = 1;

  l4hdr2 = uid >> 8;
  l4hdr3 = uid & 0xFF;
  l4hdr4 = 0;

  cpyid(list[0].id, myid);           /* Daten   */
  list[0].lt = time_to_live + 1;
  list[1].id[0] = '\0';

  send_nrr_frame(list);
}

static char *reason[] = { "no route", "local", "flexgate", "", "loop" };

/* Die Antwort wird hier etwas leserlicher gemacht und an den
   User geschickt                                              */
static void nrr2usr(NRRLIST *l)
{
  char    buffer[512], *bp, call[10];
  int     llt, lt, err;
  UID     uid;
  USRBLK *up;
  #define LT_MASK   0x7F
  #define ECHO_FLAG 0x80

  bp = buffer;
  llt = l->lt & LT_MASK;

  while (*l->id) {                      /* Liste abarbeiten         */
    *bp++ = ' ';
    lt = l->lt & LT_MASK;
    while (llt > lt) {                  /* fehlende Digis markieren */
      *bp++ = '?';
      *bp++ = ' ';
      llt--;
    }
    call2str(call, l->id);
    bp += sprintf(bp, "%s", call);
    if (l->lt & ECHO_FLAG) {             /* Echoflag anzeigen        */
      *bp++ = '*';
      err = l->id[L2CALEN] >> 5;         /* Fehlercode extrahieren   */
      if (err < 5 && err != 3)           /*  und anzeigen            */
        bp += sprintf(bp, "<%s>", reason[err]);
    }
    llt--;
    l++;
  }
  *bp++ = ' ';
  time_to_live++;
  while (llt > time_to_live) {
    *bp++ = '?';
    *bp++ = ' ';
    llt--;
  }
  call2str(call, myid);
  bp += sprintf(bp, "%s", call);

  uid = (l4hdr2 << 8) | l4hdr3;            /* User suchen           */
  if (uid > 0 && uid < NUMPAT)
    if ((up = ptctab[uid].ublk) != NULL)
      send_async_response(up, "Route (DG):", buffer);
}

/* Hier wird das NRR-Frame zusammengebastelt und verschickt     */
static void send_nrr_frame(NRRLIST *l)
{
  PEER   *pp;
  NODE   *dstnod;
  MBHEAD *mbp;

  if (iscall(desnod, &dstnod, &pp, DG)) {
    mbp = (MBHEAD *)allocb();

    putfid(orgnod, mbp);
    putfid(desnod, mbp);
    putchr(time_to_live, mbp);
    putchr(l4hdr0, mbp);
    putchr(l4hdr1, mbp);
    putchr(l4hdr2, mbp);
    putchr(l4hdr3, mbp);
    putchr(l4hdr4, mbp);
    while (*l->id) {
      putfid(l->id, mbp);
      putchr(l->lt, mbp);
      l++;
    }
    rwndmb(mbp);
    toneig(pp, mbp);
  }
}

#define TO       0  /* dir */
#define BACK     1

#define NOTKNOWN 1  /* tome und ret */
#define ISLOCAL  2
#define VIAFLEX  3
#define DIRECT   4
#define LOOPED   5

/* Diese Funktion analysiert die empfangenen NRR-Frames.
   Etliche Fehler werden erkannt und entsprechend reagiert.

   tome   gibt an, ob mich das Frame was angeht
   ret    besagt, ob das Frame zurueckgeschickt werden soll und wieso
   dir    gibt die NRR-Richtung an
   looped ist wahr, wenn unsere ID im Hinweg vorkam und dir gleich TO
*/
static void nrr_rx(MBHEAD *mbp, PEER *rxpp)
{
  NRRLIST  list[30], *l;
  int      nlist, ret, tome, dir;
  BOOLEAN  looped;
  PEER    *topp;

  if (!time_to_live)                       /* zuspaet               */
    return;

  looped = tome = ret = FALSE;
  dir = TO;
  topp = NULL;

  if (cmpid(desnod, myid))                 /* das geht uns an...    */
    tome = DIRECT;
  else if (iscall(desnod, NULL,            /* sonst den besten Weg  */
                  &topp, DG|VC|VC_FAR)) {  /*  bestimmen            */
    if (topp->options & VC)                /* ein local von uns     */
      tome = ISLOCAL;
    else if (topp->options & VC_FAR)       /* wuerde via flex gehen */
      tome = VIAFLEX;
  }

  nlist = 0;
  l = list;
  while (mbp->mbpc - mbp->mbgc >= L2IDLEN+1) { /* Eintrag da?       */
    if (getfid(l->id, mbp) == TRUE) {
      l->lt = getchr(mbp);
      if (l->lt & ECHO_FLAG) {             /* EchoFlag              */
        dir = BACK;
        looped = FALSE;
      }
      if (dir == TO && cmpid(l->id, myid)) /* Loop in Hin-Liste     */
        looped = TRUE;
      nlist++;
      l++;
    }
  }
  l->id[0] = '\0';                         /* Liste beenden         */

  if (   !nlist                            /* leere Liste           */
      || rxpp == topp)                     /* Loop in den Nodes     */
    return;

  if (cmpid(list[0].id, myid)) {           /* das ist meine Anwort  */
    nrr2usr(list);
    return;
  }

  if (dir == BACK && (   topp == NULL      /* Ziel unbekannt        */
                      || tome == VIAFLEX)) /* bzw. Flex im Rueckweg */
    return;

  if (topp == NULL && !tome)               /* Ziel unbekannt        */
    ret = NOTKNOWN;
  else if (looped)                         /* Loop in der Liste     */
    ret = LOOPED;
  else if (tome)                           /* wir sind das Ziel     */
    ret = tome;

  if (ret) {                               /* Weg umdrehen          */
    cpyid(desnod, orgnod);
    cpyid(orgnod, myid);
  }

  if (nlist < 29) {                        /* wir passen noch dran  */
    cpyid(l->id, myid);
    l->lt = time_to_live + 1;
    if (ret) {
      l->id[L2CALEN] &= 0x1f;
      l->id[L2CALEN] |= (ret - 1) << 5;    /* Fehler in SSID-Feld   */
      l->lt |= ECHO_FLAG;
    }
    l++;
    l->id[0] = '\0';                       /* Liste beenden         */
  }

  send_nrr_frame(list);
}

/* End of L3.C */
